/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Network;
import at.cdes.api.dto.NetworkType;
import at.cdes.api.dto.StatutoryDuty;
import at.cdes.impl.dao.StatutoryDutyDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcStatutoryDutyDAO
extends AbstrIdDAO<StatutoryDuty>
implements StatutoryDutyDAO {
    public JdbcStatutoryDutyDAO() {
        super(StatutoryDuty.class, "id", "statutory_duty", new String[]{"id", "name", "description", "network_id", "network_type_id", "is_statutory_duty", "create_trx", "mut_trx", "mut_ts"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcStatutoryDutyDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_type_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "is_statutory_duty") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcStatutoryDutyDAO.getSelectClauseForDto("statutory_duty", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcStatutoryDutyDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".description" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + "," + entityLocalName + ".network_type_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_type_id") + "," + entityLocalName + ".is_statutory_duty" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "is_statutory_duty") + "," + entityLocalName + ".create_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + "," + entityLocalName + ".mut_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + "," + entityLocalName + ".mut_ts" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    protected StatutoryDuty fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        StatutoryDuty statutoryDuty = new StatutoryDuty();
        statutoryDuty.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        statutoryDuty.setName(rs.getString(++columnIndex));
        statutoryDuty.setDescription(rs.getString(++columnIndex));
        statutoryDuty.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        statutoryDuty.setNetworkTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        statutoryDuty.setIsStatutoryDuty(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        statutoryDuty.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        statutoryDuty.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        statutoryDuty.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return statutoryDuty;
    }

    public static StatutoryDuty fillStatutoryDutyFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        StatutoryDuty statutoryDuty = new StatutoryDuty();
        statutoryDuty.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        statutoryDuty.setName(rs.getString(columnIndex.incrementAndGet()));
        statutoryDuty.setDescription(rs.getString(columnIndex.incrementAndGet()));
        statutoryDuty.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        statutoryDuty.setNetworkTypeId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        statutoryDuty.setIsStatutoryDuty(JDBCHelper.getBoolean((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        statutoryDuty.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        statutoryDuty.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        statutoryDuty.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return statutoryDuty;
    }

    public static StatutoryDuty fillStatutoryDutyFromResultSet(ResultSet rs) throws SQLException {
        return JdbcStatutoryDutyDAO.fillStatutoryDutyFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 9;
    }

    @Override
    public void deleteByNetworkId(final Long networkId) {
        String sql = "DELETE FROM statutory_duty WHERE network_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, networkId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(StatutoryDuty dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<StatutoryDuty> dtos) {
        Iterator<StatutoryDuty> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, StatutoryDuty statutoryDuty) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)statutoryDuty.getId());
        statement.setString(2, statutoryDuty.getName());
        statement.setString(3, statutoryDuty.getDescription());
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)statutoryDuty.getNetworkId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)statutoryDuty.getNetworkTypeId());
        JDBCHelper.setBoolean((PreparedStatement)statement, (int)6, (Boolean)statutoryDuty.getIsStatutoryDuty());
        JDBCHelper.setLong((PreparedStatement)statement, (int)7, (Number)(statutoryDuty.getCreateTrx() != null ? statutoryDuty.getCreateTrx() : (Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)8, (Number)((Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)9, (Number)System.currentTimeMillis());
    }

    @Override
    public List<StatutoryDuty> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<StatutoryDuty> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<StatutoryDuty> getByNetworkType(NetworkType networkType) {
        return this.getByNetworkType(networkType.getId());
    }

    @Override
    public List<StatutoryDuty> getByNetworkType(final Long networkTypeId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_type_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkTypeId);
            }
        });
    }

    @Override
    public List<StatutoryDuty> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<StatutoryDuty>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<StatutoryDuty> getByNetworkTypes(Collection<Long> networkTypeId) {
        if (networkTypeId.isEmpty()) {
            return new ArrayList<StatutoryDuty>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkTypeId.size()];
        int n = 0;
        Iterator<Long> it = networkTypeId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_type_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

