/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.SubProject;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcNetworkDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcSubProjectDAO;
import at.cdes.impl.dao.jdbc.JdbcNetworkDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcSubProjectDAO
extends AbstractJdbcSubProjectDAO
implements SubProjectDAO {
    @Override
    public ContextJoin getSubProjectContextJoin(final Long subProjectId) {
        String sql = "SELECT " + JdbcNetworkDAO.getContextJoinSelectClause() + "FROM (((((((      sub_project JOIN sub_project_type                  ON sub_project.sub_project_type_id = sub_project_type.id) JOIN project                           ON sub_project.project_id = project.id) JOIN network                           ON project.network_id = network.id) LEFT JOIN localisation project_localisation ON project.localisation_id = project_localisation.id) LEFT JOIN countries project_country         ON project_localisation.country_id = project_country.id) LEFT JOIN object_planner     ON 1=0) LEFT JOIN object ON 1=0) WHERE sub_project.id = ? ";
        return (ContextJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<ContextJoin>(){

            public ContextJoin perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    ContextJoin contextJoin = JdbcNetworkDAO.fillContextJoinFromResultSet(rs);
                    return contextJoin;
                }
                return null;
            }
        });
    }

    @Override
    public List<ContextJoin> getSubProjectContextJoinsByNetwork(Long networkId) {
        String sql = "SELECT " + JdbcNetworkDAO.getContextJoinSelectClause() + "FROM network JOIN project                   ON project.network_id = network.id JOIN sub_project               ON sub_project.project_id = project.id AND sub_project.invalidated = 0 JOIN sub_project_type          ON sub_project.sub_project_type_id = sub_project_type.id LEFT JOIN countries project_country ON 1=0 LEFT JOIN object                    ON 1=0 LEFT JOIN object_planner            ON 1=0 WHERE network.id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcNetworkDAO::fillContextJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
        });
    }

    @Override
    public List<ContextJoin> getSubProjectToObjectPlannerContextJoins(final Long subProjectId) {
        String sql = "SELECT " + JdbcNetworkDAO.getContextJoinSelectClause() + "FROM      sub_project JOIN sub_project_type                  ON sub_project.sub_project_type_id = sub_project_type.id JOIN project                           ON sub_project.project_id = project.id JOIN network                           ON project.network_id = network.id LEFT JOIN localisation project_localisation ON project.localisation_id = project_localisation.id LEFT JOIN countries project_country         ON project_localisation.country_id = project_country.id LEFT JOIN object_list                       ON sub_project.object_list_id = object_list.id LEFT JOIN object                            ON object.object_list_id = object_list.id LEFT JOIN object_planner                    ON object_planner.object_id = object.id WHERE sub_project.id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ContextJoin>>(){

            public List<ContextJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ContextJoin> retJoins = new ArrayList<ContextJoin>();
                while (rs.next()) {
                    ContextJoin contextJoin = JdbcNetworkDAO.fillContextJoinFromResultSet(rs);
                    retJoins.add(contextJoin);
                }
                return retJoins;
            }
        });
    }

    @Override
    public SubProject getByDocumentVersion(final Long documentVersionId) {
        String sql = "SELECT " + JdbcSubProjectDAO.getSelectClauseForDto() + "FROM (((       document_version JOIN document           ON document_version.document_id = document.id) JOIN document_list      ON document.document_list_id = document_list.id) JOIN sub_project        ON document_list.sub_project_id = sub_project.id) WHERE document_version.id = ?";
        SubProject subProject = (SubProject)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<SubProject>(){

            public SubProject perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    return JdbcSubProjectDAO.this.fillDtoFromResultSet(resultSet);
                }
                throw new IllegalArgumentException("Any document_version should be linked to a sub_project via document and document_list.");
            }
        });
        return subProject;
    }

    @Override
    public SubProject getByDocument(Long documentId) {
        String sql = "SELECT " + this.getSelectClauseForDto() + "\nFROM document\nJOIN document_list ON document.document_list_id = document_list.id\nJOIN sub_project   ON document_list.sub_project_id = sub_project.id\nWHERE document.id = ?\n";
        return QueryHelper.getUniqueWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(documentId));
    }

    @Override
    public List<SubProject> getValidByProject(final Long projectId) {
        String sql = "SELECT " + JdbcSubProjectDAO.getSelectClauseForDto() + "FROM sub_project WHERE (sub_project.invalidated IS NULL OR sub_project.invalidated = 0) AND sub_project.project_id = ? ";
        List subProjects = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<SubProject>>(){

            public List<SubProject> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<SubProject> subProjects = new ArrayList<SubProject>();
                while (resultSet.next()) {
                    subProjects.add(JdbcSubProjectDAO.this.fillDtoFromResultSet(resultSet));
                }
                return subProjects;
            }
        });
        return subProjects;
    }

    @Override
    public boolean isSubProjectAllowed(final Long subProjectId, final Long organisationPersonId) {
        String sql = "SELECT 1 FROM organisation_person JOIN project_participant    ON project_participant.organisation_person_id = organisation_person.id JOIN project_participation  ON project_participant.participation_id = project_participation.id WHERE organisation_person.id = ? AND organisation_person.retired_flag != 1 AND project_participant.inactive_flag != 1 AND project_participation.invalidated != 1 AND NOT EXISTS (SELECT 1 FROM project_participation_sub_project_restrictions restriction WHERE restriction.sub_project_id = ? AND restriction.project_participation_id = project_participation.id)";
        return (Boolean)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Boolean>(){

            public Boolean perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public Map<Long, Set<Long>> getRestrictedSubProjectIdToParticipationIds(final Long organisationPersonId) {
        String sql = "SELECT project_participation_sub_project_restrictions.sub_project_id, project_participation_sub_project_restrictions.project_participation_id FROM project_participant JOIN project_participation  ON     project_participant.participation_id = project_participation.id AND project_participation.invalidated = 0 JOIN project_participation_sub_project_restrictions ON project_participation_sub_project_restrictions.project_participation_id = project_participation.id WHERE project_participant.organisation_person_id = ? AND project_participant.inactive_flag = 0 ";
        return (Map)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Map<Long, Set<Long>>>(){

            public Map<Long, Set<Long>> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                ResultSet resultSet = statement.executeQuery();
                HashMap<Long, Set<Long>> restrictedSubProjectIdToParticipationIds = new HashMap<Long, Set<Long>>();
                while (resultSet.next()) {
                    Long subProjectId = JDBCHelper.getLong((ResultSet)resultSet, (int)1);
                    Long participationId = JDBCHelper.getLong((ResultSet)resultSet, (int)2);
                    if (!restrictedSubProjectIdToParticipationIds.containsKey(subProjectId)) {
                        restrictedSubProjectIdToParticipationIds.put(subProjectId, new HashSet());
                    }
                    ((Set)restrictedSubProjectIdToParticipationIds.get(subProjectId)).add(participationId);
                }
                return restrictedSubProjectIdToParticipationIds;
            }
        });
    }
}

