/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.review;

import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.Realm;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.ListenerJoin;
import at.cdes.api.review.compositeDto.CellInstanceInfo;
import at.cdes.api.review.compositeDto.InstanceInfo;
import at.cdes.api.review.compositeDto.NodeInstanceInfo;
import at.cdes.api.review.compositeDto.ParticipationStringInfo;
import at.cdes.api.review.compositeDto.ReviewCycleInfo;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.api.voc.ReviewType;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.service.ChallengeLoginServiceImpl;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.w3c.dom.Node;

public class InstanceInfoExporter {
    private String odfStylePrefix;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private PersonVariablesDAO personVariablesDAO;
    private String tempDirName;
    private static final String SIGNATURE_ON_LABEL_SYMBOL = "\u270e";

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public ScratchFile export(Long organisationPersonId, InstanceInfo instanceInfo, ReviewCycleInfo cycleInfo, boolean enableCustomerLogo) throws Exception {
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyLandscapeTemplate.odt", ChallengeLoginServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        String personVariablesUserLocale = OdfHelper.getPersonVariablesUserLocaleByPrincipal(this.personVariablesDAO);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        OfficeTextElement officeText = document.getContentRoot();
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        Styles contentOfficeStyles = context.getContentOfficeStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        OdfHelper.constructHeader(context, document, standardParagraphStyle, null, enableCustomerLogo);
        ContextJoin contextJoin = instanceInfo.getContextJoin();
        String projectCode = contextJoin.getProjectCode() != null ? contextJoin.getProjectCode() : "";
        String projectName = contextJoin.getProjectName() != null ? contextJoin.getProjectName() : "";
        String leftFooterLabel = resourceBundle.getString("objectListPdfReviewCycleInstanceCaption") + " - " + resourceBundle.getString("project") + " " + projectCode + " " + projectName;
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", null);
        String dataParagraphStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{dataTextProperties});
        AutomaticStyles stylesAutomaticStyles = context.getStylesAutomaticStyles();
        StyleTextPropertiesElement textPropertiesElement = stylesAutomaticStyles.constructTextPropertiesWithFontWeight("bold");
        String leftFooterTextStyle = stylesAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{textPropertiesElement});
        StyleParagraphPropertiesElement paragraphProperties = OdfHelper.constructStandardParagraphProperties(stylesOfficeStyles);
        OdfHelper.constructFooter(context, document, standardParagraphStyle, leftFooterLabel, leftFooterTextStyle, dataParagraphStyle);
        StyleTextPropertiesElement headerTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", "bold");
        StyleParagraphPropertiesElement headerParagraphProperties = contentAutomaticStyles.constructParagraphPropertiesWithTextAlign("right");
        String headerParagraphStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{headerTextProperties, headerParagraphProperties});
        TextHElement textHElement = officeText.newTextHElement(1);
        textHElement.setTextContent(resourceBundle.getString("objectListPdfReviewCycleInstanceCaption") + " " + instanceInfo.getInstance().getName());
        officeText.newTextPElement();
        this.constructBasicDataTable(officeText, instanceInfo, resourceBundle, contentAutomaticStyles, headerParagraphStyle, dataParagraphStyle);
        officeText.newTextPElement();
        this.constructInstanceTable(officeText, instanceInfo, resourceBundle, contentAutomaticStyles, headerParagraphStyle, dataParagraphStyle);
        officeText.newTextPElement();
        this.appendCellSections(officeText, instanceInfo, cycleInfo, resourceBundle, contentOfficeStyles, stylesOfficeStyles, contentAutomaticStyles, headerParagraphStyle, dataParagraphStyle);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_Objektblatt_", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        return new ScratchFile(new File(tmpFileName), "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private TableTableElement constructBasicDataTable(OfficeTextElement parentElement, InstanceInfo instanceInfo, ResourceBundle resourceBundle, Styles contentAutomaticStyles, String headerTextStyle, String dataTextStyle) {
        TableTableElement tableElement = this.constructEmptyTable((Node)parentElement, contentAutomaticStyles);
        ContextJoin contextJoin = instanceInfo.getContextJoin();
        String projectCode = contextJoin.getProjectCode() != null ? contextJoin.getProjectCode() : "";
        String projectName = contextJoin.getProjectName() != null ? contextJoin.getProjectName() : "";
        String projectLabel = projectCode + " " + projectName;
        String stretchName = contextJoin.getProjectStretchName();
        Double stretchKmFrom = contextJoin.getProjectStretchKmFrom();
        Double stretchKmTo = contextJoin.getProjectStretchKmTo();
        DecimalFormat kmFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.GERMAN);
        kmFormat.applyPattern("###,##0.000");
        String kmFromString = kmFormat.format(stretchKmFrom);
        String kmToString = kmFormat.format(stretchKmTo);
        String kmString = kmFromString + " - " + kmToString;
        String projectComment = contextJoin.getProjectComment() != null ? contextJoin.getProjectComment() : "";
        String subProjectCode = contextJoin.getSubProjectCode() != null ? contextJoin.getSubProjectCode() : "";
        String subProjectNumber = contextJoin.getSubProjectNumber() != null ? contextJoin.getSubProjectNumber().toString() : "";
        String subProjectName = contextJoin.getSubProjectName() != null ? contextJoin.getSubProjectName() : "";
        String subProjectLabel = subProjectCode + subProjectNumber + " " + subProjectName;
        this.constructRow(tableElement, resourceBundle.getString("project"), projectLabel, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("objectHeaderStretchLabel"), stretchName, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("objectHeaderKmLabel"), kmString, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("objectHeaderCommentLabel"), projectComment, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("objectHeaderSubProjectLabel"), subProjectLabel, headerTextStyle, dataTextStyle);
        return tableElement;
    }

    private TableTableElement constructInstanceTable(OfficeTextElement parentElement, InstanceInfo instanceInfo, ResourceBundle resourceBundle, Styles contentAutomaticStyles, String headerTextStyle, String dataTextStyle) {
        String instanceName = instanceInfo.getInstance().getName();
        String cycleName = instanceInfo.getReviewCycle().getName();
        Integer duration = instanceInfo.getInstance().getDuration();
        Integer durationPre = instanceInfo.getInstance().getDurationPre();
        String durationLabel = MessageFormat.format(resourceBundle.getString("workingDays"), duration);
        String durationPreLabel = MessageFormat.format(resourceBundle.getString("workingDays"), durationPre);
        String labelName = instanceInfo.getLabel().getName();
        String description = instanceInfo.getInstance().getDescription();
        TableTableElement tableElement = this.constructEmptyTable((Node)parentElement, contentAutomaticStyles);
        this.constructRow(tableElement, resourceBundle.getString("reviewCycleInstanceItem"), instanceName, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("reviewCycleInstanceBasedOnCycle"), cycleName, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("reviewCycleInstanceDuration"), durationLabel, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("reviewCycleInstanceDurationPre"), durationPreLabel, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("labelItem"), labelName, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("description"), description, headerTextStyle, dataTextStyle);
        return tableElement;
    }

    private void appendCellSections(OfficeTextElement officeText, InstanceInfo instanceInfo, ReviewCycleInfo cycleInfo, ResourceBundle resourceBundle, Styles contentOfficeStyles, Styles stylesOfficeStyles, Styles contentAutomaticStyles, String headerTextStyle, String dataTextStyle) {
        List cellInstanceInfos = instanceInfo.getCellInstanceInfos();
        Collections.sort(cellInstanceInfos, new Comparator<CellInstanceInfo>(){

            @Override
            public int compare(CellInstanceInfo infoOne, CellInstanceInfo infoTwo) {
                ReviewCycleCell cellOne = infoOne.getCell();
                ReviewCycleCell cellTwo = infoTwo.getCell();
                int positionOne = cellOne != null && cellOne.getPosition() != null ? cellOne.getPosition() : 0;
                int positionTwo = cellTwo != null && cellTwo.getPosition() != null ? cellTwo.getPosition() : 0;
                return positionOne - positionTwo;
            }
        });
        for (CellInstanceInfo cellInstanceInfo : cellInstanceInfos) {
            String nodeName;
            String cellName = cellInstanceInfo.getCell().getName();
            TextHElement textHElement = officeText.newTextHElement(1);
            textHElement.setTextContent(cellName);
            List nodeInstanceInfos = cellInstanceInfo.getNodeInstanceInfos();
            for (NodeInstanceInfo nodeInstanceInfo : nodeInstanceInfos) {
                if (nodeInstanceInfo.getNodeInstance().getFree() != null && nodeInstanceInfo.getNodeInstance().getFree().booleanValue()) continue;
                nodeName = nodeInstanceInfo.getNode().getName();
                TextHElement nodeHeaderElement = officeText.newTextHElement(3);
                nodeHeaderElement.setTextContent(nodeName);
                this.fillNodeSection(officeText, cycleInfo, nodeInstanceInfo, resourceBundle, contentOfficeStyles, stylesOfficeStyles, contentAutomaticStyles, headerTextStyle, dataTextStyle, false);
            }
            for (NodeInstanceInfo nodeInstanceInfo : nodeInstanceInfos) {
                if (nodeInstanceInfo.getNodeInstance().getFree() == null || !nodeInstanceInfo.getNodeInstance().getFree().booleanValue()) continue;
                nodeName = nodeInstanceInfo.getNode().getName();
                String freeLabel = resourceBundle.getString("objectPlannerShowFreeNodePrefix");
                TextHElement nodeHeaderElement = officeText.newTextHElement(3);
                nodeHeaderElement.setTextContent(freeLabel + nodeName);
                this.fillNodeSection(officeText, cycleInfo, nodeInstanceInfo, resourceBundle, contentOfficeStyles, stylesOfficeStyles, contentAutomaticStyles, headerTextStyle, dataTextStyle, true);
            }
        }
    }

    private void fillNodeSection(OfficeTextElement officeText, ReviewCycleInfo cycleInfo, NodeInstanceInfo nodeInstanceInfo, ResourceBundle resourceBundle, Styles contentOfficeStyles, Styles stylesOfficeStyles, Styles contentAutomaticStyles, String headerTextStyle, String dataTextStyle, boolean free) {
        TableRegistry tableRegistry = new TableRegistry(officeText, contentAutomaticStyles);
        tableRegistry.resetTableElement();
        if (!free) {
            Long nodeId = nodeInstanceInfo.getNode().getId();
            boolean isEndNode = cycleInfo.isEndNode(nodeId);
            String durationCaptionSymbol = isEndNode ? "objectPlannerShowDurationLabelEndNode" : "objectPlannerShowDurationLabelNonEndNode";
            Integer duration = nodeInstanceInfo.getNodeInstance().getDuration();
            String durationLabel = MessageFormat.format(resourceBundle.getString("workingDays"), duration);
            TableTableRowElement durationRowElement = TableFactory.appendRow((TableTableElement)tableRegistry.tableElement, null);
            TableTableCellElement durationHeaderCell = TableFactory.appendTextStyledCell((String)headerTextStyle, (TableTableRowElement)durationRowElement, (String[])new String[]{resourceBundle.getString(durationCaptionSymbol) + " "});
            String durationHeaderCellStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructParagraphPropertiesWithMargin("0cm", "0cm", "0cm", "0.3cm")});
            durationHeaderCell.setStyleName(durationHeaderCellStyle);
            TableFactory.appendTextStyledCell((String)dataTextStyle, (TableTableRowElement)durationRowElement, (String[])new String[]{durationLabel});
        }
        this.appendListenerSection(tableRegistry.tableElement, nodeInstanceInfo, resourceBundle, contentAutomaticStyles, headerTextStyle, dataTextStyle);
        this.appendMatrixSection(tableRegistry, cycleInfo, nodeInstanceInfo, resourceBundle, contentOfficeStyles, stylesOfficeStyles, contentAutomaticStyles, headerTextStyle, dataTextStyle);
    }

    private void appendListenerSection(TableTableElement nodeTableElement, NodeInstanceInfo nodeInstanceInfo, ResourceBundle resourceBundle, Styles contentAutomaticStyles, String headerTextStyle, String dataTextStyle) {
        List listenerJoins = nodeInstanceInfo.getListenerJoins();
        if (listenerJoins.size() == 0) {
            return;
        }
        TableTableRowElement listenerRowElement = TableFactory.appendRow((TableTableElement)nodeTableElement, null);
        TableFactory.appendTextStyledCell((String)headerTextStyle, (TableTableRowElement)listenerRowElement, (String[])new String[]{resourceBundle.getString("objectPlannerShowListenerCaption") + " "});
        StyleTextPropertiesElement secondLineTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", null);
        String secondLineStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructParagraphPropertiesWithMargin("0.5cm", "0cm", "0cm", "0cm"), secondLineTextProperties});
        StyleParagraphPropertiesElement paragraphProperties = contentAutomaticStyles.constructParagraphPropertiesWithMargin("1.0cm", "0cm", "0cm", "0cm");
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", null);
        String thirdLineStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{paragraphProperties, dataTextProperties});
        TableTableCellElement listenerCell = TableFactory.appendEmptyCell(null, null, (TableTableRowElement)listenerRowElement);
        HashMap listenerIdToListenerJoins = new HashMap();
        for (ListenerJoin listenerJoin : listenerJoins) {
            Long listenerId = null;
            if (listenerJoin.getReviewCycleNodeInstanceNotificationReviewCycleNodeListenerId() != null) {
                listenerId = listenerJoin.getReviewCycleNodeInstanceNotificationReviewCycleNodeListenerId();
            } else if (listenerJoin.getReviewCycleNodeInstancePlottOrderListenerId() != null) {
                listenerId = listenerJoin.getReviewCycleNodeInstancePlottOrderListenerId();
            }
            if (listenerId == null) continue;
            if (!listenerIdToListenerJoins.containsKey(listenerId)) {
                listenerIdToListenerJoins.put(listenerId, new ArrayList());
            }
            ((List)listenerIdToListenerJoins.get(listenerId)).add(listenerJoin);
        }
        for (Long listenerId : listenerIdToListenerJoins.keySet()) {
            List listenerJoinsGrouped = (List)listenerIdToListenerJoins.get(listenerId);
            ListenerJoin someListenerJoin = (ListenerJoin)listenerJoinsGrouped.get(0);
            String listenerName = someListenerJoin.getReviewCycleNodeListenerName();
            String listenerString = this.getListenerString(someListenerJoin, resourceBundle);
            String prePostString = this.getPrePostString(someListenerJoin, resourceBundle);
            String listenerInfoString = listenerString + " " + prePostString;
            TextFactory.constructTextNode((Node)listenerCell, (String)listenerName, (String)dataTextStyle);
            TextFactory.constructTextNode((Node)listenerCell, (String)listenerInfoString, (String)secondLineStyle);
            for (ListenerJoin listenerJoin : listenerJoinsGrouped) {
                if (listenerJoin.getReviewCycleNodeInstancePlottOrderListenerId() != null) {
                    String plotOrderTemplateName = listenerJoin.getPlotOrderTemplateName();
                    TextFactory.constructTextNode((Node)listenerCell, (String)plotOrderTemplateName, (String)thirdLineStyle);
                    continue;
                }
                if (listenerJoin.getReviewCycleNodeInstanceNotificationId() == null || listenerJoin.getProjectParticipationId() == null) continue;
                String organisationName = listenerJoin.getOrganisationName();
                String personGivenName = listenerJoin.getPersonGivenName();
                String personSurName = listenerJoin.getPersonSurName();
                String roleName = listenerJoin.getCdesRoleName();
                String participationComment = listenerJoin.getProjectParticipationComment();
                String personString = organisationName + " (" + personSurName + " " + personGivenName + ")" + (participationComment != null && participationComment.length() > 0 ? " - " + participationComment : "");
                if (roleName != null) {
                    personString = personString + " - " + roleName;
                }
                TextFactory.constructTextNode((Node)listenerCell, (String)personString, (String)thirdLineStyle);
            }
        }
    }

    private String getListenerString(ListenerJoin listenerJoin, ResourceBundle resourceBundle) {
        String listenerName = listenerJoin.getReviewCycleNodeListenerListenerName();
        if ("PlottOrderListener".equals(listenerName)) {
            return resourceBundle.getString("objectPlannerShowListenerPlotOrder");
        }
        if ("NotificationListener".equals(listenerName)) {
            return resourceBundle.getString("objectPlannerShowListenerNotification");
        }
        return "";
    }

    private String getPrePostString(ListenerJoin listenerJoin, ResourceBundle resourceBundle) {
        return listenerJoin.getReviewCycleNodeListenerIsPreListener() != null && listenerJoin.getReviewCycleNodeListenerIsPreListener() != false ? resourceBundle.getString("objectPlannerShowListenerPre") : resourceBundle.getString("objectPlannerShowListenerPost");
    }

    private void appendMatrixSection(TableRegistry nodeTableRegistry, ReviewCycleInfo cycleInfo, NodeInstanceInfo nodeInstanceInfo, ResourceBundle resourceBundle, Styles contentOfficeStyles, Styles stylesOfficeStyles, Styles contentAutomaticStyles, String headerTextStyle, String dataTextStyle) {
        StyleTableCellPropertiesElement headerCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000");
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{headerCellProperties});
        StyleTableCellPropertiesElement personCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000");
        String personCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{personCellProperties});
        Long nodeId = nodeInstanceInfo.getNode().getId();
        boolean isEndNode = cycleInfo.isEndNode(nodeId);
        if (!isEndNode && (this.isMatrixNodeNeeded(nodeInstanceInfo) || this.isSerialMatrixNodeNeeded(nodeInstanceInfo) || this.isSerialMultiMatrixNodeNeeded(nodeInstanceInfo))) {
            StyleTextPropertiesElement leftHeaderTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", "bold");
            StyleParagraphPropertiesElement leftHeaderParagraphProperties = contentAutomaticStyles.constructParagraphPropertiesWithTextAlign("left");
            String leftHeaderTextStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{leftHeaderTextProperties, leftHeaderParagraphProperties});
            if (this.isMatrixNodeNeeded(nodeInstanceInfo)) {
                nodeTableRegistry.resetTableElement();
                String pageBreakStyle = this.constructPageBreakStyle(stylesOfficeStyles);
                TextFactory.constructTextNode((Node)nodeTableRegistry.tableElement, (String)"", (String)pageBreakStyle);
                TableTableRowElement matrixCaptionRowElement = TableFactory.appendRow((TableTableElement)nodeTableRegistry.tableElement, null);
                TableFactory.appendTextStyledCell((String)leftHeaderTextStyle, (TableTableRowElement)matrixCaptionRowElement, (String[])new String[]{resourceBundle.getString("objectPlannerShowMatrixCaption") + " "});
                TableFactory.appendEmptyCell(null, null, (TableTableRowElement)matrixCaptionRowElement);
                StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
                dataCellProperties.setStyleVerticalAlignAttribute("middle");
                StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", null);
                StyleParagraphPropertiesElement dataParagraphProperties = contentAutomaticStyles.constructParagraphPropertiesWithTextAlign("center");
                String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties, dataParagraphProperties, dataTextProperties});
                this.constructMatrixNode(nodeTableRegistry, nodeInstanceInfo, resourceBundle, contentOfficeStyles, stylesOfficeStyles, contentAutomaticStyles, headerTextStyle, headerCellStyle, personCellStyle, dataCellStyle, dataTextStyle);
            } else if (this.isSerialMatrixNodeNeeded(nodeInstanceInfo)) {
                TableTableRowElement matrixCaptionRowElement = TableFactory.appendRow((TableTableElement)nodeTableRegistry.tableElement, null);
                TableFactory.appendTextStyledCell((String)leftHeaderTextStyle, (TableTableRowElement)matrixCaptionRowElement, (String[])new String[]{resourceBundle.getString("objectPlannerShowMatrixCaption") + " "});
                TableFactory.appendEmptyCell(null, null, (TableTableRowElement)matrixCaptionRowElement);
                StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
                StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", null);
                String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties, dataTextProperties});
                TableTableRowElement matrixRowElement = TableFactory.appendRow((TableTableElement)nodeTableRegistry.tableElement, null);
                this.constructSerialMatrixNode(matrixRowElement, nodeInstanceInfo, resourceBundle, contentOfficeStyles, stylesOfficeStyles, contentAutomaticStyles, headerTextStyle, headerCellStyle, personCellStyle, dataCellStyle, dataTextStyle);
            } else if (this.isSerialMultiMatrixNodeNeeded(nodeInstanceInfo)) {
                TableTableRowElement matrixCaptionRowElement = TableFactory.appendRow((TableTableElement)nodeTableRegistry.tableElement, null);
                TableFactory.appendTextStyledCell((String)leftHeaderTextStyle, (TableTableRowElement)matrixCaptionRowElement, (String[])new String[]{resourceBundle.getString("objectPlannerShowMatrixCaption") + " "});
                TableFactory.appendEmptyCell(null, null, (TableTableRowElement)matrixCaptionRowElement);
                StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
                StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", null);
                String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties, dataTextProperties});
                TableTableRowElement matrixRowElement = TableFactory.appendRow((TableTableElement)nodeTableRegistry.tableElement, null);
                this.constructSerialMultiMatrixNode(matrixRowElement, nodeInstanceInfo, resourceBundle, contentOfficeStyles, stylesOfficeStyles, contentAutomaticStyles, headerTextStyle, headerCellStyle, personCellStyle, dataCellStyle, dataTextStyle);
            }
        }
    }

    private void constructSerialMatrixNode(TableTableRowElement matrixRowElement, NodeInstanceInfo nodeInstanceInfo, ResourceBundle resourceBundle, Styles contentOfficeStyles, Styles stylesOfficeStyles, Styles contentAutomaticStyles, String headerTextStyle, String headerCellStyle, String personCellStyle, String dataCellStyle, String dataTextStyle) {
        String realmLabel;
        TableTableCellElement matrixCell = TableFactory.appendEmptyCell(null, null, (TableTableRowElement)matrixRowElement);
        matrixCell.setTableNumberColumnsSpannedAttribute(Integer.valueOf(2));
        TableTableElement tableElement = TableFactory.constructTableElement((Node)matrixCell, null);
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"5cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"8cm");
        StyleTextPropertiesElement headerTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", "bold");
        StyleParagraphPropertiesElement headerParagraphProperties = contentAutomaticStyles.constructParagraphPropertiesWithTextAlign("left");
        String headerParagraphStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{headerTextProperties, headerParagraphProperties});
        TableTableRowElement headerRowElement = TableFactory.appendRow((TableTableElement)tableElement, null);
        TableFactory.appendCell((String)headerCellStyle, (String)headerParagraphStyle, (TableTableRowElement)headerRowElement, (String[])new String[]{resourceBundle.getString("objectPlannerShowRealmCaption")});
        TableFactory.appendCell((String)headerCellStyle, (String)headerParagraphStyle, (TableTableRowElement)headerRowElement, (String[])new String[]{resourceBundle.getString("objectPlannerShowPersonsCaption")});
        Realm singleRealm = (Realm)nodeInstanceInfo.getRealms().get(0);
        List participationStringInfos = nodeInstanceInfo.getParticipationStringInfosRestrictedToPositions();
        TableTableRowElement dataRowElement = TableFactory.appendRow((TableTableElement)tableElement, null);
        String realmCode = singleRealm.getCode() != null ? singleRealm.getCode() : "";
        String realmName = singleRealm.getName() != null ? singleRealm.getName() : "";
        Boolean signatureOnLabel = singleRealm.getSignatureOnLabel();
        String string = realmLabel = realmCode.trim().length() > 0 && realmName.trim().length() > 0 ? realmCode + " " + realmName : realmCode + realmName;
        if (signatureOnLabel != null && signatureOnLabel.booleanValue()) {
            realmLabel = realmLabel + " \u270e";
        }
        TableFactory.appendCellStyledCell((String)dataCellStyle, (TableTableRowElement)dataRowElement, (String[])new String[]{realmLabel});
        if (participationStringInfos.size() == 0 || ((ParticipationStringInfo)participationStringInfos.get(0)).getParticipationId() == null) {
            TableFactory.appendCellStyledCell((String)dataCellStyle, (TableTableRowElement)dataRowElement, (String[])new String[]{resourceBundle.getString("objectPlannerShowNotDefined")});
        } else {
            TableTableCellElement cell = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)dataRowElement);
            for (ParticipationStringInfo participationInfo : participationStringInfos) {
                String organisationName = participationInfo.getOrganisationName();
                String personGivenName = participationInfo.getPersonGivenName();
                String personSurName = participationInfo.getPersonSurName();
                String participationComment = participationInfo.getParticipationComment();
                String participationLabel = organisationName + " (" + personSurName + " " + personGivenName + ")" + (participationComment != null && participationComment.length() > 0 ? " - " + participationComment : "");
                TextFactory.constructTextNode((Node)cell, (String)participationLabel, (String)dataTextStyle);
            }
        }
    }

    private void constructSerialMultiMatrixNode(TableTableRowElement matrixRowElement, NodeInstanceInfo nodeInstanceInfo, ResourceBundle resourceBundle, Styles contentOfficeStyles, Styles stylesOfficeStyles, Styles contentAutomaticStyles, String headerTextStyle, String headerCellStyle, String personCellStyle, String dataCellStyle, String dataTextStyle) {
        String standardStyle = stylesOfficeStyles.getParagraphStyleWithClass("text", new OdfStylePropertiesBase[0]);
        StyleTextPropertiesElement orgTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", null);
        orgTextProperties.setFoFontWeightAttribute("bold");
        String orgTextStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{orgTextProperties});
        String captionTextStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructParagraphPropertiesWithTextAlign("center"), contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", null)});
        int maxRealmsPerMatrix = 12;
        TableTableCellElement matrixCell = TableFactory.appendEmptyCell(null, null, (TableTableRowElement)matrixRowElement);
        matrixCell.setTableNumberColumnsSpannedAttribute(Integer.valueOf(2));
        List realms = nodeInstanceInfo.getRealms();
        for (int realmStart = 0; realmStart < realms.size(); realmStart += maxRealmsPerMatrix) {
            Realm realm;
            if (realmStart > 0) {
                TextFactory.appendEmptyTextNode((Node)matrixCell, null);
            }
            TableTableElement tableElement = TableFactory.constructTableElement((Node)matrixCell, null);
            TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"4cm");
            int limit = Math.min(realms.size(), realmStart + maxRealmsPerMatrix);
            for (int n = realmStart; n < limit; ++n) {
                double width = 24.0 / (double)(limit - realmStart);
                TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)(width + "cm"));
            }
            TableTableRowElement headerRowElement = TableFactory.appendRow((TableTableElement)tableElement, null);
            TableFactory.appendCell((String)headerCellStyle, (String)headerTextStyle, (TableTableRowElement)headerRowElement, (String[])new String[]{resourceBundle.getString("objectPlannerShowRealmsCaption")});
            for (int n = realmStart; n < limit; ++n) {
                TableTableCellElement headerCell = TableFactory.appendEmptyCell((String)headerCellStyle, null, (TableTableRowElement)headerRowElement);
                realm = (Realm)realms.get(n);
                String realmCode = realm.getCode();
                String realmName = realm.getName();
                String codeLabel = (realmCode != null ? realmCode.trim() : "") + " " + (realm.isSignatureOnLabel() != null && realm.isSignatureOnLabel() != false ? SIGNATURE_ON_LABEL_SYMBOL : "");
                if (codeLabel.trim().length() > 0) {
                    TextFactory.constructTextNode((Node)headerCell, (String)codeLabel, (String)captionTextStyle);
                }
                TextFactory.constructTextNode((Node)headerCell, (String)realmName, (String)captionTextStyle);
            }
            TableTableRowElement rowElement = TableFactory.appendRow((TableTableElement)tableElement, null);
            TableFactory.appendCell((String)personCellStyle, (String)headerTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{resourceBundle.getString("objectPlannerShowPersonsCaption")});
            for (int n = realmStart; n < limit; ++n) {
                realm = (Realm)realms.get(n);
                Long realmId = realm.getId();
                Set selectedParticipationIds = (Set)nodeInstanceInfo.getRealmIdToSelectedParticipationIds().get(realmId);
                TableTableCellElement personCell = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                for (Long participationId : selectedParticipationIds) {
                    ParticipationStringInfo participationStringInfo = null;
                    for (ParticipationStringInfo currInfo : nodeInstanceInfo.getParticipationStringInfosRestrictedToPositions()) {
                        if (currInfo.getParticipationId().longValue() != participationId.longValue()) continue;
                        participationStringInfo = currInfo;
                        break;
                    }
                    if (participationStringInfo == null) continue;
                    this.appendPersonInfosToCell(personCell, participationStringInfo, nodeInstanceInfo, orgTextStyle, dataTextStyle);
                }
            }
        }
    }

    private boolean isMatrixNodeNeeded(NodeInstanceInfo nodeInstanceInfo) {
        Integer nodeReviewType = nodeInstanceInfo.getNode().getReviewType();
        return nodeReviewType.intValue() != ReviewType.EMPTYREVIEW.getValue() && nodeReviewType.intValue() != ReviewType.SERIALGRAPHICREVIEW.getValue() && nodeReviewType.intValue() != ReviewType.SERIALREVIEW.getValue() && nodeReviewType.intValue() != ReviewType.SERIALMULTIREALMREVIEW.getValue();
    }

    private boolean isSerialMatrixNodeNeeded(NodeInstanceInfo nodeInstanceInfo) {
        Integer nodeReviewType = nodeInstanceInfo.getNode().getReviewType();
        return (nodeReviewType.intValue() == ReviewType.SERIALGRAPHICREVIEW.getValue() || nodeReviewType.intValue() == ReviewType.SERIALREVIEW.getValue() || nodeReviewType.intValue() == ReviewType.SERIALMULTIREALMREVIEW.getValue()) && nodeInstanceInfo.getRealms().size() == 1;
    }

    private boolean isSerialMultiMatrixNodeNeeded(NodeInstanceInfo nodeInstanceInfo) {
        Integer nodeReviewType = nodeInstanceInfo.getNode().getReviewType();
        return nodeReviewType.intValue() == ReviewType.SERIALMULTIREALMREVIEW.getValue() && nodeInstanceInfo.getRealms().size() > 1;
    }

    private void constructMatrixNode(TableRegistry tableRegistry, NodeInstanceInfo nodeInstanceInfo, ResourceBundle resourceBundle, Styles contentOfficeStyles, Styles stylesOfficeStyles, Styles contentAutomaticStyles, String headerTextStyle, String headerCellStyle, String personCellStyle, String dataCellStyle, String dataTextStyle) {
        TableTableRowElement matrixRowElement = TableFactory.appendRow((TableTableElement)tableRegistry.tableElement, null);
        String standardStyle = stylesOfficeStyles.getParagraphStyleWithClass("text", new OdfStylePropertiesBase[0]);
        StyleTextPropertiesElement orgTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", null);
        orgTextProperties.setFoFontWeightAttribute("bold");
        String orgTextStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{orgTextProperties});
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", null);
        dataTextProperties.setFoFontWeightAttribute("bold");
        StyleTextPropertiesElement captionBoldTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", null);
        captionBoldTextProperties.setFoFontWeightAttribute("bold");
        String captionBoldTextStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructParagraphPropertiesWithTextAlign("center"), captionBoldTextProperties});
        String captionTextStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructParagraphPropertiesWithTextAlign("center"), contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", null)});
        int maxRealmsPerMatrix = 12;
        TableTableCellElement matrixCell = TableFactory.appendEmptyCell(null, null, (TableTableRowElement)matrixRowElement);
        matrixCell.setTableNumberColumnsSpannedAttribute(Integer.valueOf(2));
        List realms = nodeInstanceInfo.getRealms();
        int mod = realms.size() % maxRealmsPerMatrix;
        int factor = realms.size() / maxRealmsPerMatrix;
        int offset = factor == 0 || mod == 0 ? maxRealmsPerMatrix : realms.size() / (factor + 1) + (realms.size() % (factor + 1) == 0 ? 0 : 1);
        for (int realmStart = 0; realmStart < realms.size(); realmStart += offset) {
            if (realmStart > 0) {
                String pageBreakStyle = this.constructPageBreakStyle(stylesOfficeStyles);
                TextFactory.constructTextNode((Node)tableRegistry.officeText, (String)"", (String)pageBreakStyle);
                tableRegistry.resetTableElement();
                matrixRowElement = TableFactory.appendRow((TableTableElement)tableRegistry.tableElement, null);
                matrixCell = TableFactory.appendEmptyCell(null, null, (TableTableRowElement)matrixRowElement);
                matrixCell.setTableNumberColumnsSpannedAttribute(Integer.valueOf(2));
            }
            TableTableElement tableElement = TableFactory.constructTableElement((Node)matrixCell, null);
            TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"8cm");
            int limit = Math.min(realms.size(), realmStart + offset);
            for (int n = realmStart; n < limit; ++n) {
                double width = 20.0 / (double)(limit - realmStart);
                TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)(width + "cm"));
            }
            TableTableRowElement headerRowElement = TableFactory.appendRow((TableTableElement)tableElement, null);
            TableFactory.appendCell((String)headerCellStyle, (String)captionBoldTextStyle, (TableTableRowElement)headerRowElement, (String[])new String[]{resourceBundle.getString("objectPlannerShowRealmPersonCaption")});
            for (int n = realmStart; n < limit; ++n) {
                TableTableCellElement headerCell = TableFactory.appendEmptyCell((String)headerCellStyle, null, (TableTableRowElement)headerRowElement);
                Realm realm = (Realm)realms.get(n);
                String realmCode = realm.getCode();
                String realmName = realm.getName();
                String codeLabel = (realmCode != null ? realmCode.trim() : "") + " " + (realm.isSignatureOnLabel() != null && realm.isSignatureOnLabel() != false ? SIGNATURE_ON_LABEL_SYMBOL : "");
                if (codeLabel.trim().length() > 0) {
                    TextFactory.constructTextNode((Node)headerCell, (String)codeLabel, (String)captionBoldTextStyle);
                }
                TextFactory.constructTextNode((Node)headerCell, (String)realmName, (String)captionTextStyle);
            }
            List participationStringInfos = nodeInstanceInfo.getParticipationStringInfos();
            for (ParticipationStringInfo participationStringInfo : participationStringInfos) {
                TableTableRowElement rowElement = TableFactory.appendRow((TableTableElement)tableElement, null);
                if (participationStringInfo.getParticipationId() == null) {
                    TableFactory.appendCellStyledCell((String)personCellStyle, (TableTableRowElement)matrixRowElement, (String[])new String[]{resourceBundle.getString("objectPlannerShowNoEntries")});
                } else {
                    TableTableCellElement personCell = TableFactory.appendEmptyCell((String)personCellStyle, null, (TableTableRowElement)rowElement);
                    this.appendPersonInfosToCell(personCell, participationStringInfo, nodeInstanceInfo, orgTextStyle, dataTextStyle);
                }
                Long participationId = participationStringInfo.getParticipationId();
                Map realmIdToSelectedParticipationIds = nodeInstanceInfo.getRealmIdToSelectedParticipationIds();
                for (int n = realmStart; n < limit; ++n) {
                    boolean selected;
                    Realm realm = (Realm)realms.get(n);
                    Long realmId = realm.getId();
                    TableTableCellElement cell = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                    boolean bl = selected = realmIdToSelectedParticipationIds.containsKey(realmId) && ((Set)realmIdToSelectedParticipationIds.get(realmId)).contains(participationId);
                    if (!selected) continue;
                    TextFactory.constructTextNode((Node)cell, (String)"\u2713", (String)dataCellStyle);
                }
            }
        }
    }

    private void appendPersonInfosToCell(TableTableCellElement personCell, ParticipationStringInfo participationStringInfo, NodeInstanceInfo nodeInstanceInfo, String orgTextStyle, String dataTextStyle) {
        String participationComment;
        String organisationName = participationStringInfo.getOrganisationName();
        TextFactory.constructTextNode((Node)personCell, (String)(organisationName + " "), (String)orgTextStyle);
        String personString = participationStringInfo.getPersonGivenName() + " " + participationStringInfo.getPersonSurName();
        TextFactory.constructTextNode((Node)personCell, (String)personString, (String)dataTextStyle);
        Long nodeInstanceRoleTypeId = nodeInstanceInfo.getNode().getRoleTypeId();
        Long participationRoleTypeId = participationStringInfo.getRoleTypeId();
        if (nodeInstanceRoleTypeId == null != (participationRoleTypeId == null) || nodeInstanceRoleTypeId != null && nodeInstanceRoleTypeId.longValue() != participationRoleTypeId.longValue()) {
            String roleName = participationStringInfo.getRoleName();
            TextFactory.constructTextNode((Node)personCell, (String)roleName, (String)dataTextStyle);
        }
        if ((participationComment = participationStringInfo.getParticipationComment()) != null && participationComment.trim().length() > 0) {
            TextFactory.constructTextNode((Node)personCell, (String)participationComment, (String)dataTextStyle);
        }
    }

    private String constructPageBreakStyle(Styles stylesOfficeStyles) {
        StyleParagraphPropertiesElement paragraphPropertiesElement = stylesOfficeStyles.constructParagraphPropertiesWithBreakBefore("page");
        paragraphPropertiesElement.setFoMarginTopAttribute("0cm");
        return stylesOfficeStyles.getParagraphStyle(new OdfStylePropertiesBase[]{paragraphPropertiesElement});
    }

    private TableTableElement constructEmptyTable(Node parentElement, Styles contentAutomaticStyles) {
        TableTableElement tableElement = TableFactory.constructTableElement((Node)parentElement, null);
        TableFactory.appendColumnWithRelativeSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"225*");
        TableFactory.appendColumnWithRelativeSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"775*");
        return tableElement;
    }

    private TableTableRowElement constructRow(TableTableElement parentElement, String header, String text, String headerTextStyle) {
        return this.constructRow(parentElement, header, text, headerTextStyle, null);
    }

    private TableTableRowElement constructRow(TableTableElement parentElement, String header, String text, String headerTextStyle, String dataTextStyle) {
        if (text == null) {
            text = "";
        }
        TableTableRowElement rowElement = TableFactory.appendRow((TableTableElement)parentElement, null);
        TableFactory.appendTextStyledCell((String)headerTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{header + " "});
        TableFactory.appendTextStyledCell((String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{text});
        return rowElement;
    }

    private class TableRegistry {
        OfficeTextElement officeText;
        Styles contentAutomaticStyles;
        TableTableElement tableElement;

        TableRegistry(OfficeTextElement officeText, Styles contentAutomaticStyles) {
            this.officeText = officeText;
            this.contentAutomaticStyles = contentAutomaticStyles;
        }

        void resetTableElement() {
            StyleTablePropertiesElement tableProperties = this.contentAutomaticStyles.constructTableProperties();
            tableProperties.setStyleMayBreakBetweenRowsAttribute(Boolean.valueOf(false));
            String tableStyle = this.contentAutomaticStyles.getTableStyle(new OdfStylePropertiesBase[]{tableProperties});
            this.tableElement = InstanceInfoExporter.this.constructEmptyTable((Node)this.officeText, this.contentAutomaticStyles);
            this.tableElement.setStyleName(tableStyle);
        }
    }
}

