/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.msp;

import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieReuseStrategy
extends DefaultConnectionReuseStrategy {
    private static Logger log = LoggerFactory.getLogger(CookieReuseStrategy.class);

    public boolean keepAlive(HttpResponse response, HttpContext context) {
        HttpRequest request;
        Header header;
        context.setAttribute("http.response", (Object)response);
        if (log.isDebugEnabled() && (header = response.getFirstHeader("Set-Cookie")) != null) {
            log.debug("Cookie: [" + header + "]");
        }
        if (log.isDebugEnabled() && (request = (HttpRequest)context.getAttribute("http.request")) != null) {
            Header[] responseHeaders;
            Header[] headers;
            log.debug("============= Request headers: =============== ");
            for (Header header2 : headers = request.getAllHeaders()) {
                log.debug(header2.toString());
            }
            RequestLine requestLine = request.getRequestLine();
            log.debug("Request line: " + requestLine.toString());
            log.debug("============= Response headers: =============== ");
            for (Header header3 : responseHeaders = response.getAllHeaders()) {
                log.debug(header3.toString());
            }
            StatusLine statusLine = response.getStatusLine();
            log.debug("Status line: " + statusLine.toString());
        }
        return super.keepAlive(response, context);
    }
}

