/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.reviewCycle;

import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentList;
import at.cdes.api.dto.DocumentType;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.EmailSnippet;
import at.cdes.api.dto.NodelistenerEmailSnippet;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleCellResult;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.dto.ReviewCycleNodeResult;
import at.cdes.api.dto.ReviewCycleResultOption;
import at.cdes.api.dto.SubProject;
import at.cdes.api.joinDto.AttachmentMailJoin;
import at.cdes.api.joinDto.ListenerJoin;
import at.cdes.api.joinDto.MinAttachmentMailJoin;
import at.cdes.impl.dao.DocumentDAO;
import at.cdes.impl.dao.DocumentListDAO;
import at.cdes.impl.dao.DocumentTypeDAO;
import at.cdes.impl.dao.EmailAttachmentDAO;
import at.cdes.impl.dao.EmailSnippetDAO;
import at.cdes.impl.dao.NodelistenerEmailSnippetDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ReviewCycleCellDAO;
import at.cdes.impl.dao.ReviewCycleCellResultDAO;
import at.cdes.impl.dao.ReviewCycleNodeResultDAO;
import at.cdes.impl.dao.ReviewCycleResultOptionDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.debug.DebugContext;
import at.cdes.impl.email.EmailHelper;
import at.cdes.impl.reviewCycle.ReviewCycleHelper;
import at.cdes.impl.task.TaskUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ognl.OgnlContext;

public class ReviewCycleNodeInstanceNotificationListener {
    private EmailAttachmentDAO emailAttachmentDAO;
    private EmailSnippetDAO emailSnippetDAO;
    private NodelistenerEmailSnippetDAO nodeListenerEmailSnippetDAO;
    private ReviewCycleNodeResultDAO reviewCycleNodeResultDAO;
    private ReviewCycleResultOptionDAO reviewCycleResultOptionDAO;
    private DocumentDAO documentDAO;
    private DocumentTypeDAO documentTypeDAO;
    private DocumentListDAO documentListDAO;
    private SubProjectDAO subProjectDAO;
    private ProjectDAO projectDAO;
    private ReviewCycleCellResultDAO reviewCycleCellResultDAO;
    private ReviewCycleCellDAO reviewCycleCellDAO;
    private TaskUtils taskUtils;

    public void setEmailAttachmentDAO(EmailAttachmentDAO emailAttachmentDAO) {
        this.emailAttachmentDAO = emailAttachmentDAO;
    }

    public void setEmailSnippetDAO(EmailSnippetDAO emailSnippetDAO) {
        this.emailSnippetDAO = emailSnippetDAO;
    }

    public void setNodeListenerEmailSnippetDAO(NodelistenerEmailSnippetDAO nodeListenerEmailSnippetDAO) {
        this.nodeListenerEmailSnippetDAO = nodeListenerEmailSnippetDAO;
    }

    public void setReviewCycleNodeResultDAO(ReviewCycleNodeResultDAO reviewCycleNodeResultDAO) {
        this.reviewCycleNodeResultDAO = reviewCycleNodeResultDAO;
    }

    public void setReviewCycleResultOptionDAO(ReviewCycleResultOptionDAO reviewCycleResultOptionDAO) {
        this.reviewCycleResultOptionDAO = reviewCycleResultOptionDAO;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setDocumentTypeDAO(DocumentTypeDAO documentTypeDAO) {
        this.documentTypeDAO = documentTypeDAO;
    }

    public void setDocumentListDAO(DocumentListDAO documentListDAO) {
        this.documentListDAO = documentListDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setReviewCycleCellResultDAO(ReviewCycleCellResultDAO reviewCycleCellResultDAO) {
        this.reviewCycleCellResultDAO = reviewCycleCellResultDAO;
    }

    public void setReviewCycleCellDAO(ReviewCycleCellDAO reviewCycleCellDAO) {
        this.reviewCycleCellDAO = reviewCycleCellDAO;
    }

    public void setTaskUtils(TaskUtils taskUtils) {
        this.taskUtils = taskUtils;
    }

    public void listen(DebugContext debugContext, ListenerJoin listenerJoin, DocumentVersion documentVersion, ReviewCycleNodeInstanceReleased nodeInstanceReleased) {
        debugContext.openDebugNode("NodeInstanceNotificationListener.listen");
        String ognlRule = listenerJoin.getReviewCycleNodeListenerOgnlRule();
        if (!this.evaluate(ognlRule, documentVersion)) {
            debugContext.closeDebugNode("evaluate() returned false");
            return;
        }
        Long documentVersionId = documentVersion.getId();
        Long nodeInstanceNotificationId = listenerJoin.getReviewCycleNodeInstanceNotificationId();
        Long nodeListenerId = listenerJoin.getReviewCycleNodeListenerId();
        List<MinAttachmentMailJoin> minAttachmentMailJoins = this.emailAttachmentDAO.getAttachmentJoinByNodeInstanceNotification(documentVersionId, nodeInstanceNotificationId);
        List<EmailSnippet> emailSnippets = new ArrayList();
        for (MinAttachmentMailJoin minAttachmentMailJoin : minAttachmentMailJoins) {
            Double nextEmailSendTime = EmailHelper.getNextEmailSendTime(minAttachmentMailJoin.getOrganisationPerson());
            if (nextEmailSendTime == null) continue;
            Long organisationPersonId = minAttachmentMailJoin.getOrganisationPersonId();
            EmailSnippet emailSnippet = new EmailSnippet();
            emailSnippet.setOrganisationPersonId(organisationPersonId);
            emailSnippet.setSendTime(nextEmailSendTime);
            emailSnippets.add(emailSnippet);
        }
        emailSnippets = this.emailSnippetDAO.saveBatch(emailSnippets);
        for (EmailSnippet emailSnippet : emailSnippets) {
            debugContext.addSaveEmailSnippetMessage(emailSnippet, null);
        }
        ArrayList<NodelistenerEmailSnippet> nodeListenerEmailSnippets = new ArrayList<NodelistenerEmailSnippet>();
        for (EmailSnippet emailSnippet : emailSnippets) {
            NodelistenerEmailSnippet nodeListenerEmailSnippet = new NodelistenerEmailSnippet();
            nodeListenerEmailSnippet.setDocumentVersionId(documentVersionId);
            nodeListenerEmailSnippet.setNodelistenerId(nodeListenerId);
            nodeListenerEmailSnippet.setEmailSnippetId(emailSnippet.getId());
            nodeListenerEmailSnippets.add(nodeListenerEmailSnippet);
        }
        this.nodeListenerEmailSnippetDAO.saveBatch(nodeListenerEmailSnippets);
        for (NodelistenerEmailSnippet nodeListenerEmailSnippet : nodeListenerEmailSnippets) {
            debugContext.addSaveNodeListenerEmailSnippetMessage(nodeListenerEmailSnippet);
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        for (MinAttachmentMailJoin minAttachmentMailJoin : minAttachmentMailJoins) {
            Long participationId = minAttachmentMailJoin.getProjectParticipationId();
            if (hashSet.contains(participationId)) continue;
            this.taskUtils.createSelectCellConnectionAttachmentMail(debugContext, (AttachmentMailJoin)minAttachmentMailJoin);
            hashSet.add(participationId);
        }
        debugContext.closeDebugNode();
    }

    private boolean evaluate(String ognlRule, DocumentVersion documentVersion) {
        Boolean result;
        if (ognlRule == null || ognlRule.trim().length() == 0) {
            return true;
        }
        ReviewCycleNodeResult reviewCycleNodeResult = this.reviewCycleNodeResultDAO.getByActiveNodeAndDocumentVersion(documentVersion.getId());
        ReviewCycleResultOption resultOption = null;
        if (reviewCycleNodeResult.getReviewCycleResultOptionId() != null) {
            resultOption = (ReviewCycleResultOption)this.reviewCycleResultOptionDAO.get(reviewCycleNodeResult.getReviewCycleResultOptionId());
        }
        Document document = (Document)this.documentDAO.get(documentVersion.getDocumentId());
        DocumentType documentType = (DocumentType)this.documentTypeDAO.get(document.getDocumentTypeId());
        DocumentList documentList = (DocumentList)this.documentListDAO.get(document.getDocumentListId());
        SubProject subProject = (SubProject)this.subProjectDAO.get(documentList.getSubProjectId());
        Project project = (Project)this.projectDAO.get(subProject.getProjectId());
        ReviewCycleCellResult reviewCycleCellResult = (ReviewCycleCellResult)this.reviewCycleCellResultDAO.get(reviewCycleNodeResult.getReviewCycleCellResultId());
        ReviewCycleCell nextCell = null;
        if (reviewCycleCellResult.getNextReviewCycleCellId() != null) {
            nextCell = (ReviewCycleCell)this.reviewCycleCellDAO.get(reviewCycleCellResult.getNextReviewCycleCellId());
        }
        ognlRule = ognlRule.replaceAll("result\\.reviewCycleResultOption", "resultOption");
        ognlRule = ognlRule.replaceAll("documentVersion\\.document\\.documentType\\.code", "documentType");
        ognlRule = ognlRule.replaceAll("documentVersion\\.document\\.documentList\\.subProject\\.project", "project");
        ognlRule = ognlRule.replaceAll("documentVersion\\.document\\.documentList\\.subProject", "subProject");
        OgnlContext context = new OgnlContext();
        context.put("result", reviewCycleNodeResult);
        if (reviewCycleNodeResult.getReviewCycleResultOptionId() != null) {
            context.put("resultOption", resultOption);
        }
        context.put("documentVersion", documentVersion);
        context.put("document", document);
        context.put("documentType", documentType);
        context.put("subProject", subProject);
        context.put("project", project);
        if (reviewCycleCellResult.getNextReviewCycleCellId() != null) {
            context.put("nextCell", nextCell);
        }
        if ((result = ReviewCycleHelper.evaluateBooleanOgnlRule(ognlRule, context, true)) == null) {
            return false;
        }
        return result;
    }
}

