/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.document;

import at.cdes.api.guiService.DocumentService;
import java.util.TimeZone;
import org.clazzes.util.datetime.UtcTimestamp;
import org.clazzes.util.sched.ITimedJob;
import org.clazzes.util.sched.impl.HasLoggingCallable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NightlyDocumentCallable
extends HasLoggingCallable<Void>
implements ITimedJob {
    private DocumentService documentService;
    private boolean triggerNow;
    private boolean finished;
    private Long startSeconds;
    private boolean running;
    private static final Logger log = LoggerFactory.getLogger(NightlyDocumentCallable.class);

    public NightlyDocumentCallable(DocumentService documentService) {
        this.documentService = documentService;
        this.triggerNow = true;
        this.finished = false;
        this.startSeconds = null;
    }

    public NightlyDocumentCallable(DocumentService documentService, Long startSeconds) {
        this.documentService = documentService;
        this.triggerNow = false;
        this.finished = false;
        this.startSeconds = startSeconds;
    }

    public Long getNextExecutionDelay() {
        if (this.triggerNow) {
            return 1L;
        }
        if (this.finished || this.startSeconds < 0L) {
            return null;
        }
        TimeZone timeZone = TimeZone.getTimeZone("Europe/Vienna");
        UtcTimestamp utcTimestamp = new UtcTimestamp(timeZone);
        int year = utcTimestamp.getYear();
        int month = utcTimestamp.getMonth();
        int day = utcTimestamp.getDay();
        UtcTimestamp startThisDay = new UtcTimestamp();
        startThisDay.setDateTime(year, month, day, (int)(this.startSeconds * 1000L), timeZone);
        if (utcTimestamp.getUtcMillis() < startThisDay.getUtcMillis() - 1000L) {
            long retValue = startThisDay.getUtcMillis() - utcTimestamp.getUtcMillis();
            if (log.isDebugEnabled()) {
                log.debug("Scheduling the job to be started today, with utcTimestamp [" + utcTimestamp.getUtcMillis() + "], startThisDay = [" + startThisDay.getUtcMillis() + "], year = [" + year + "], month = [" + month + "], day = [" + day + "], startSeconds = [" + this.startSeconds + "]; returning [" + retValue + "]");
            }
            return retValue;
        }
        UtcTimestamp startNextDay = startThisDay.cloneAdd(5, 1);
        if (startNextDay.getUtcMillis() < utcTimestamp.getUtcMillis()) {
            throw new RuntimeException("startNextDay = [" + startNextDay.getUtcMillis() + "] is expected to be after utcTimestamp = [" + utcTimestamp.getUtcMillis() + "], with startSeconds = [" + this.startSeconds + "], year = [" + year + "], month = [" + month + "], day = [" + day + "] and startThisDay = [" + startThisDay.getUtcMillis() + "]");
        }
        long retValue = startNextDay.getUtcMillis() - utcTimestamp.getUtcMillis();
        if (log.isDebugEnabled()) {
            log.debug("Scheduling the job to be started tomorrow, with utcTimestamp [" + utcTimestamp.getUtcMillis() + "], startThisDay = [" + startThisDay.getUtcMillis() + "], startNextDay = [" + startNextDay.getUtcMillis() + "], year = [" + year + "], month = [" + month + "], day = [" + day + "], startSeconds = [" + this.startSeconds + "], returning [" + retValue + "]");
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void call() throws Exception {
        try {
            NightlyDocumentCallable nightlyDocumentCallable = this;
            synchronized (nightlyDocumentCallable) {
                if (this.running) {
                    throw new RuntimeException("NightlyDocumentCallable may not run twice simultaneously.");
                }
                this.running = true;
            }
            log.info("NightlyDocumentCallable called.");
            if (this.triggerNow) {
                this.triggerNow = false;
                this.finished = true;
            }
            this.documentService.performDocumentExportToMsp();
            nightlyDocumentCallable = null;
            return nightlyDocumentCallable;
        }
        finally {
            NightlyDocumentCallable nightlyDocumentCallable = this;
            synchronized (nightlyDocumentCallable) {
                log.info("NightlyDocumentCallable finishes.");
                this.running = false;
            }
        }
    }
}

