/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.MasterDataSet;
import at.cdes.api.dto.Network;
import at.cdes.api.joinDto.MasterDataJoin;
import at.cdes.impl.dao.GenMasterDataSetDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcMasterDataSetDAO
extends AbstrIdDAO<MasterDataSet>
implements GenMasterDataSetDAO {
    public AbstractJdbcMasterDataSetDAO() {
        super(MasterDataSet.class, "id", "master_data_set", new String[]{"id", "name", "description", "network_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcMasterDataSetDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcMasterDataSetDAO.getSelectClauseForDto("master_data_set", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcMasterDataSetDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".description" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + " ";
    }

    protected MasterDataSet fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        MasterDataSet masterDataSet = new MasterDataSet();
        masterDataSet.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataSet.setName(rs.getString(++columnIndex));
        masterDataSet.setDescription(rs.getString(++columnIndex));
        masterDataSet.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return masterDataSet;
    }

    public static MasterDataSet fillMasterDataSetFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        MasterDataSet masterDataSet = new MasterDataSet();
        masterDataSet.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        masterDataSet.setName(rs.getString(columnIndex.incrementAndGet()));
        masterDataSet.setDescription(rs.getString(columnIndex.incrementAndGet()));
        masterDataSet.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return masterDataSet;
    }

    public static MasterDataSet fillMasterDataSetFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcMasterDataSetDAO.fillMasterDataSetFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 4;
    }

    public static MasterDataJoin fillMasterDataJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        MasterDataJoin masterDataJoin = new MasterDataJoin();
        masterDataJoin.setDocumentNumberGroupId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setDocumentNumberGroupNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setDocumentNumberGroupName(rs.getString(++columnIndex));
        masterDataJoin.setDocumentNumberGroupRendererName(rs.getString(++columnIndex));
        masterDataJoin.setDocumentNumberGroupMasterDataSetId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setDocumentNumberPartId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setDocumentNumberPartName(rs.getString(++columnIndex));
        masterDataJoin.setDocumentNumberPartOgnlRule(rs.getString(++columnIndex));
        masterDataJoin.setDocumentNumberPartFormat(rs.getString(++columnIndex));
        masterDataJoin.setDocumentNumberPartLength(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setDocumentNumberPartPosition(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setDocumentNumberPartSeperator(rs.getString(++columnIndex));
        masterDataJoin.setDocumentNumberPartGroupId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setDocumentNumberPartUniqueKey(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setDocumentNumberPartFieldType(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setDocumentTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setDocumentTypeDocumentTypeGroupId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setDocumentTypeNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setDocumentTypeCode(rs.getString(++columnIndex));
        masterDataJoin.setDocumentTypeName(rs.getString(++columnIndex));
        masterDataJoin.setDocumentTypeDescription(rs.getString(++columnIndex));
        masterDataJoin.setDocumentTypeMasterDataSetId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setMasterDataSetId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setMasterDataSetName(rs.getString(++columnIndex));
        masterDataJoin.setMasterDataSetDescription(rs.getString(++columnIndex));
        masterDataJoin.setMasterDataSetNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setObjectTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setObjectTypeCode(rs.getString(++columnIndex));
        masterDataJoin.setObjectTypeName(rs.getString(++columnIndex));
        masterDataJoin.setObjectTypeComment(rs.getString(++columnIndex));
        masterDataJoin.setObjectTypeNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setObjectTypeMasterDataSetId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setSubProjectTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setSubProjectTypeNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setSubProjectTypeCode(rs.getString(++columnIndex));
        masterDataJoin.setSubProjectTypeName(rs.getString(++columnIndex));
        masterDataJoin.setSubProjectTypeComment(rs.getString(++columnIndex));
        masterDataJoin.setSubProjectTypeMasterDataSetId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        masterDataJoin.setSubProjectTypeIsAsBuiltType(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        return masterDataJoin;
    }

    public static int getNumberOfMasterDataJoinAttributes() {
        return 39;
    }

    @Override
    public void deleteByNetwork(final Long networkId) {
        String sql = "DELETE FROM master_data_set WHERE network_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, networkId);
                statement.execute();
                return null;
            }
        });
    }

    protected String getSelectClauseForMasterDataJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("documentNumberGroup") ? result + "document_number_group.id, document_number_group.network_id, document_number_group.name, document_number_group.rendererName, document_number_group.master_data_set_id" : result + "NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("documentNumberPart") ? result + "document_number_part.id, document_number_part.name, document_number_part.ognl_rule, document_number_part.format, document_number_part.length, document_number_part.position, document_number_part.seperator, document_number_part.group_id, document_number_part.unique_key, document_number_part.field_type" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("documentType") ? result + "document_type.id, document_type.document_type_group_id, document_type.network_id, document_type.code, document_type.name, document_type.description, document_type.master_data_set_id" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("masterDataSet") ? result + "master_data_set.id, master_data_set.name, master_data_set.description, master_data_set.network_id" : result + "NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectType") ? result + "object_type.id, object_type.code, object_type.name, object_type.comment, object_type.network_id, object_type.master_data_set_id" : result + "NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("subProjectType") ? result + "sub_project_type.id, sub_project_type.network_id, sub_project_type.code, sub_project_type.name, sub_project_type.comment, sub_project_type.master_data_set_id, sub_project_type.is_as_built_type" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        return result;
    }

    public int update(MasterDataSet dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<MasterDataSet> dtos) {
        Iterator<MasterDataSet> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    public static String getMasterDataJoinSelectClause() {
        return "document_number_group.id, document_number_group.network_id, document_number_group.name, document_number_group.rendererName, document_number_group.master_data_set_id, document_number_part.id, document_number_part.name, document_number_part.ognl_rule, document_number_part.format, document_number_part.length, document_number_part.position, document_number_part.seperator, document_number_part.group_id, document_number_part.unique_key, document_number_part.field_type, document_type.id, document_type.document_type_group_id, document_type.network_id, document_type.code, document_type.name, document_type.description, document_type.master_data_set_id, master_data_set.id, master_data_set.name, master_data_set.description, master_data_set.network_id, object_type.id, object_type.code, object_type.name, object_type.comment, object_type.network_id, object_type.master_data_set_id, sub_project_type.id, sub_project_type.network_id, sub_project_type.code, sub_project_type.name, sub_project_type.comment, sub_project_type.master_data_set_id, sub_project_type.is_as_built_type ";
    }

    public static String getPrefixedMasterDataJoinSelectClause() {
        return "document_number_group.id AS document_number_group_id, document_number_group.network_id AS document_number_group_network_id, document_number_group.name AS document_number_group_name, document_number_group.rendererName AS document_number_group_rendererName, document_number_group.master_data_set_id AS document_number_group_master_data_set_id, document_number_part.id AS document_number_part_id, document_number_part.name AS document_number_part_name, document_number_part.ognl_rule AS document_number_part_ognl_rule, document_number_part.format AS document_number_part_format, document_number_part.length AS document_number_part_length, document_number_part.position AS document_number_part_position, document_number_part.seperator AS document_number_part_seperator, document_number_part.group_id AS document_number_part_group_id, document_number_part.unique_key AS document_number_part_unique_key, document_number_part.field_type AS document_number_part_field_type, document_type.id AS document_type_id, document_type.document_type_group_id AS document_type_document_type_group_id, document_type.network_id AS document_type_network_id, document_type.code AS document_type_code, document_type.name AS document_type_name, document_type.description AS document_type_description, document_type.master_data_set_id AS document_type_master_data_set_id, master_data_set.id AS master_data_set_id, master_data_set.name AS master_data_set_name, master_data_set.description AS master_data_set_description, master_data_set.network_id AS master_data_set_network_id, object_type.id AS object_type_id, object_type.code AS object_type_code, object_type.name AS object_type_name, object_type.comment AS object_type_comment, object_type.network_id AS object_type_network_id, object_type.master_data_set_id AS object_type_master_data_set_id, sub_project_type.id AS sub_project_type_id, sub_project_type.network_id AS sub_project_type_network_id, sub_project_type.code AS sub_project_type_code, sub_project_type.name AS sub_project_type_name, sub_project_type.comment AS sub_project_type_comment, sub_project_type.master_data_set_id AS sub_project_type_master_data_set_id, sub_project_type.is_as_built_type AS sub_project_type_is_as_built_type ";
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, MasterDataSet masterDataSet) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)masterDataSet.getId());
        statement.setString(2, masterDataSet.getName());
        statement.setString(3, masterDataSet.getDescription());
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)masterDataSet.getNetworkId());
    }

    @Override
    public List<MasterDataSet> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<MasterDataSet> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<MasterDataSet> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<MasterDataSet>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

