/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.OriginalDocumentOrder;
import at.cdes.api.dto.OriginalDocumentOrderItem;
import at.cdes.impl.dao.OriginalDocumentOrderItemDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcOriginalDocumentOrderItemDAO
extends AbstrIdDAO<OriginalDocumentOrderItem>
implements OriginalDocumentOrderItemDAO {
    public JdbcOriginalDocumentOrderItemDAO() {
        super(OriginalDocumentOrderItem.class, "id", "original_document_order_item", new String[]{"id", "order_contract_id", "document_version_id", "receiver_type", "receiver_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcOriginalDocumentOrderItemDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_contract_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "document_version_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "receiver_type") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "receiver_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcOriginalDocumentOrderItemDAO.getSelectClauseForDto("original_document_order_item", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcOriginalDocumentOrderItemDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".order_contract_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_contract_id") + "," + entityLocalName + ".document_version_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "document_version_id") + "," + entityLocalName + ".receiver_type" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "receiver_type") + "," + entityLocalName + ".receiver_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "receiver_id") + " ";
    }

    protected OriginalDocumentOrderItem fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        OriginalDocumentOrderItem originalDocumentOrderItem = new OriginalDocumentOrderItem();
        originalDocumentOrderItem.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        originalDocumentOrderItem.setOrderContractId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        originalDocumentOrderItem.setDocumentVersionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        originalDocumentOrderItem.setReceiverType(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        originalDocumentOrderItem.setReceiverId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return originalDocumentOrderItem;
    }

    public static OriginalDocumentOrderItem fillOriginalDocumentOrderItemFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        OriginalDocumentOrderItem originalDocumentOrderItem = new OriginalDocumentOrderItem();
        originalDocumentOrderItem.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        originalDocumentOrderItem.setOrderContractId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        originalDocumentOrderItem.setDocumentVersionId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        originalDocumentOrderItem.setReceiverType(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        originalDocumentOrderItem.setReceiverId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return originalDocumentOrderItem;
    }

    public static OriginalDocumentOrderItem fillOriginalDocumentOrderItemFromResultSet(ResultSet rs) throws SQLException {
        return JdbcOriginalDocumentOrderItemDAO.fillOriginalDocumentOrderItemFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 5;
    }

    public int update(OriginalDocumentOrderItem dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<OriginalDocumentOrderItem> dtos) {
        Iterator<OriginalDocumentOrderItem> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, OriginalDocumentOrderItem originalDocumentOrderItem) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)originalDocumentOrderItem.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)originalDocumentOrderItem.getOrderContractId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)originalDocumentOrderItem.getDocumentVersionId());
        JDBCHelper.setInt((PreparedStatement)statement, (int)4, (Number)originalDocumentOrderItem.getReceiverType());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)originalDocumentOrderItem.getReceiverId());
    }

    @Override
    public List<OriginalDocumentOrderItem> getByOrderContract(OriginalDocumentOrder originalDocumentOrder) {
        return this.getByOrderContract(originalDocumentOrder.getId());
    }

    @Override
    public List<OriginalDocumentOrderItem> getByOrderContract(final Long originalDocumentOrderId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_contract_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, originalDocumentOrderId);
            }
        });
    }

    @Override
    public List<OriginalDocumentOrderItem> getByDocumentVersion(DocumentVersion documentVersion) {
        return this.getByDocumentVersion(documentVersion.getId());
    }

    @Override
    public List<OriginalDocumentOrderItem> getByDocumentVersion(final Long documentVersionId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"document_version_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, documentVersionId);
            }
        });
    }

    @Override
    public List<OriginalDocumentOrderItem> getByReceiver(OriginalDocumentOrderItem originalDocumentOrderItem) {
        return this.getByReceiver(originalDocumentOrderItem.getId());
    }

    @Override
    public List<OriginalDocumentOrderItem> getByReceiver(final Long originalDocumentOrderItemId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"receiver_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, originalDocumentOrderItemId);
            }
        });
    }

    @Override
    public List<OriginalDocumentOrderItem> getByOrderContracts(Collection<Long> originalDocumentOrderId) {
        if (originalDocumentOrderId.isEmpty()) {
            return new ArrayList<OriginalDocumentOrderItem>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[originalDocumentOrderId.size()];
        int n = 0;
        Iterator<Long> it = originalDocumentOrderId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_contract_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<OriginalDocumentOrderItem> getByDocumentVersions(Collection<Long> documentVersionId) {
        if (documentVersionId.isEmpty()) {
            return new ArrayList<OriginalDocumentOrderItem>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[documentVersionId.size()];
        int n = 0;
        Iterator<Long> it = documentVersionId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"document_version_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<OriginalDocumentOrderItem> getByReceivers(Collection<Long> originalDocumentOrderItemId) {
        if (originalDocumentOrderItemId.isEmpty()) {
            return new ArrayList<OriginalDocumentOrderItem>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[originalDocumentOrderItemId.size()];
        int n = 0;
        Iterator<Long> it = originalDocumentOrderItemId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"receiver_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

