/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util.holiday;

import at.cdes.api.dto.ProjectHoliday;
import at.cdes.impl.util.holiday.HolidayCalculator;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;

public abstract class AbstractHolidayCalculator
implements HolidayCalculator {
    protected SortedSet<Calendar> holidays = new TreeSet<Calendar>();
    private SortedSet<Integer> calculatedYears = new TreeSet<Integer>();

    protected static Calendar normalize(Calendar date) {
        int year = date.get(1);
        int month = date.get(2);
        int day = date.get(5);
        return new GregorianCalendar(year, month, day);
    }

    protected AbstractHolidayCalculator() {
    }

    protected AbstractHolidayCalculator(List<ProjectHoliday> holidays) {
        if (holidays != null) {
            for (ProjectHoliday holiday : holidays) {
                this.setHoliday(holiday);
            }
        }
    }

    protected void setHoliday(ProjectHoliday holiday) {
        if (holiday.getStartDate() == null || holiday.getEndDate() == null) {
            return;
        }
        Calendar start = Calendar.getInstance();
        start.setTime(new Date((long)(holiday.getStartDate() * 1000.0)));
        Calendar end = Calendar.getInstance();
        end.setTime(new Date((long)(holiday.getEndDate() * 1000.0)));
        Calendar actual = (Calendar)start.clone();
        while (actual.compareTo(end) < 1) {
            this.holidays.add(AbstractHolidayCalculator.normalize(actual));
            actual.add(5, 1);
        }
    }

    protected abstract void addLocalizedHolidays(int var1);

    protected synchronized void calculateHolidays(int year) {
        int y = new Integer(year);
        if (this.calculatedYears.contains(y)) {
            return;
        }
        this.addLocalizedHolidays(year);
        this.calculatedYears.add(y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHoliday(Calendar date) {
        boolean isH = false;
        int year = date.get(1);
        this.calculateHolidays(year);
        AbstractHolidayCalculator abstractHolidayCalculator = this;
        synchronized (abstractHolidayCalculator) {
            Calendar key = AbstractHolidayCalculator.normalize(date);
            isH = this.holidays.contains(key);
        }
        return isH;
    }

    @Override
    public boolean isHolidayOrWeekend(Calendar date) {
        int dw = date.get(7);
        if (dw == 7 || dw == 1) {
            return true;
        }
        return this.isHoliday(date);
    }

    public Calendar getEaster(int year) {
        int gg = year % 19;
        int cc = year / 100;
        int hh = (cc - cc / 4 - (8 * cc + 13) / 25 + 19 * gg + 15) % 30;
        int ii = hh - hh / 28 * (1 - 29 / (hh + 1) * ((21 - gg) / 11));
        int jj = (year + year / 4 + ii + 2 - cc + cc / 4) % 7;
        int ll = ii - jj;
        int month = 3 + (ll + 40) / 44;
        int day = ll + 28 - 31 * (month / 4);
        GregorianCalendar easter = new GregorianCalendar(year, month - 1, day);
        return easter;
    }

    @Override
    public Integer getWorkingDaysBetween(Double startDate, Double endDate) {
        return this.getWorkingDaysBetween(startDate, endDate, "Europe/Vienna");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getWorkingDaysBetween(Double startDate, Double endDate, String timeZone) {
        SortedSet<Calendar> sub_holidays;
        GregorianCalendar rb;
        GregorianCalendar ra;
        if (startDate == null || endDate == null) {
            return null;
        }
        Calendar a = this.convertUtcSecondsToCalendar(startDate, timeZone);
        Calendar b = this.convertUtcSecondsToCalendar(endDate, timeZone);
        int sign = 1;
        if (a.compareTo(b) < 0) {
            ra = new GregorianCalendar(a.get(1), a.get(2), a.get(5));
            rb = new GregorianCalendar(b.get(1), b.get(2), b.get(5));
        } else {
            rb = new GregorianCalendar(a.get(1), a.get(2), a.get(5));
            ra = new GregorianCalendar(b.get(1), b.get(2), b.get(5));
            sign = -1;
        }
        int dwa = ra.get(7);
        while (this.isHoliday(ra) || dwa == 1 || dwa == 7) {
            ((Calendar)ra).add(5, dwa == 1 ? -2 : -1);
            dwa = ra.get(7);
        }
        int dwb = rb.get(7);
        while (this.isHoliday(rb) || dwb == 1 || dwb == 7) {
            ((Calendar)rb).add(5, dwb == 7 ? 2 : 1);
            dwb = rb.get(7);
        }
        if (ra.compareTo(rb) >= 0) {
            return 0;
        }
        int yeara = ra.get(1);
        int yearb = rb.get(1);
        int ret = rb.get(6) - ra.get(6);
        for (int year = yeara; year < yearb; ++year) {
            ret += new GregorianCalendar(year, 11, 31).get(6);
            this.calculateHolidays(year);
        }
        this.calculateHolidays(yearb);
        int nweekends = (ret + dwa - dwb) / 7;
        ret -= nweekends * 2;
        AbstractHolidayCalculator abstractHolidayCalculator = this;
        synchronized (abstractHolidayCalculator) {
            sub_holidays = this.holidays.subSet(ra, rb);
        }
        for (Calendar c : sub_holidays) {
            int dw = c.get(7);
            if (dw == 1 || dw == 7) continue;
            --ret;
        }
        return ret * sign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Calendar> getHolidaysBetween(Calendar a, Calendar b) {
        SortedSet<Calendar> sub_holidays;
        int yeara = a.get(1);
        int yearb = b.get(1);
        for (int year = yeara; year <= yearb; ++year) {
            this.calculateHolidays(year);
        }
        AbstractHolidayCalculator abstractHolidayCalculator = this;
        synchronized (abstractHolidayCalculator) {
            sub_holidays = this.holidays.subSet(a, b);
        }
        return sub_holidays;
    }

    private Calendar convertUtcSecondsToCalendar(Double utcSeconds, String timeZone) {
        Double utcMillis = utcSeconds * 1000.0;
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(utcMillis.longValue());
        return calendar;
    }

    private Double convertCalendarToUtcSeconds(Calendar c) {
        Double utcMillis = new Double(c.getTimeInMillis());
        return utcMillis / 1000.0;
    }

    @Override
    public Double addWorkingDays(Double utcSeconds, int delta) {
        return this.addWorkingDays(utcSeconds, delta, "Europe/Vienna");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double addWorkingDays(Double utcSeconds, int delta, String timeZone) {
        SortedSet<Calendar> sub_holidays;
        Calendar calendar = this.convertUtcSecondsToCalendar(utcSeconds, timeZone);
        GregorianCalendar start = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5));
        if (delta == 0) {
            return this.convertCalendarToUtcSeconds(start);
        }
        if (delta > 0) {
            SortedSet<Calendar> sub_holidays2;
            int dwa = start.get(7);
            if (dwa == 1) {
                ((Calendar)start).add(5, -2);
                dwa = 6;
            }
            if (dwa == 7) {
                ((Calendar)start).add(5, -1);
                dwa = 6;
            }
            GregorianCalendar ret = new GregorianCalendar(start.get(1), start.get(2), start.get(5));
            ((Calendar)ret).add(5, delta / 5 * 7);
            if (dwa + delta % 5 > 6) {
                ((Calendar)ret).add(5, 2);
            }
            ((Calendar)ret).add(5, delta % 5);
            int yeara = start.get(1);
            int yearb = ret.get(1);
            for (int year = yeara; year <= yearb + 1; ++year) {
                this.calculateHolidays(year);
            }
            AbstractHolidayCalculator abstractHolidayCalculator = this;
            synchronized (abstractHolidayCalculator) {
                sub_holidays2 = this.holidays.subSet(start, ret);
            }
            int days_to_advance = 0;
            for (Calendar c : sub_holidays2) {
                int dw = c.get(7);
                if (dw == 1 || dw == 7) continue;
                ++days_to_advance;
            }
            while (true) {
                AbstractHolidayCalculator c = this;
                synchronized (c) {
                    if (this.holidays.contains(ret)) {
                        ++days_to_advance;
                    }
                }
                if (days_to_advance <= 0) break;
                ((Calendar)ret).add(5, 1);
                int dw = ret.get(7);
                if (dw == 1) {
                    ((Calendar)ret).add(5, 1);
                }
                if (dw == 7) {
                    ((Calendar)ret).add(5, 2);
                }
                --days_to_advance;
            }
            return this.convertCalendarToUtcSeconds(ret);
        }
        int dwa = start.get(7);
        if (dwa == 1) {
            ((Calendar)start).add(5, 1);
            dwa = 2;
        }
        if (dwa == 7) {
            ((Calendar)start).add(5, 2);
            dwa = 2;
        }
        GregorianCalendar ret = new GregorianCalendar(start.get(1), start.get(2), start.get(5));
        ((Calendar)ret).add(5, -delta / 5 * -7);
        if (dwa - -delta % 5 < 2) {
            ((Calendar)ret).add(5, -2);
        }
        ((Calendar)ret).add(5, -(-delta % 5));
        Calendar sub_start = (Calendar)((Calendar)ret).clone();
        sub_start.add(5, 1);
        Calendar sub_end = (Calendar)((Calendar)start).clone();
        sub_end.add(5, 1);
        int yeara = sub_start.get(1);
        int yearb = sub_end.get(1);
        for (int year = yeara - 1; year <= yearb; ++year) {
            this.calculateHolidays(year);
        }
        AbstractHolidayCalculator dw = this;
        synchronized (dw) {
            sub_holidays = this.holidays.subSet(sub_start, sub_end);
        }
        int days_to_advance = 0;
        for (Calendar c : sub_holidays) {
            int dw2 = c.get(7);
            if (dw2 == 1 || dw2 == 7) continue;
            ++days_to_advance;
        }
        while (true) {
            AbstractHolidayCalculator c = this;
            synchronized (c) {
                if (this.holidays.contains(ret)) {
                    ++days_to_advance;
                }
            }
            if (days_to_advance <= 0) break;
            ((Calendar)ret).add(5, -1);
            int dw3 = ret.get(7);
            if (dw3 == 1) {
                ((Calendar)ret).add(5, -2);
            }
            if (dw3 == 7) {
                ((Calendar)ret).add(5, -1);
            }
            --days_to_advance;
        }
        return this.convertCalendarToUtcSeconds(ret);
    }

    protected void setEpiphany(int year) {
        GregorianCalendar epiphany = new GregorianCalendar(year, 0, 6);
        this.holidays.add(epiphany);
    }

    protected void setNewYearsDay(int year) {
        GregorianCalendar newYear = new GregorianCalendar(year, 0, 1);
        this.holidays.add(newYear);
    }

    protected void setLabourDay(int year) {
        GregorianCalendar labour = new GregorianCalendar(year, 4, 1);
        this.holidays.add(labour);
    }

    protected void setBoxingDay(int year) {
        GregorianCalendar boxing = new GregorianCalendar(year, 11, 26);
        this.holidays.add(boxing);
    }

    protected void setChristmasDay(int year) {
        GregorianCalendar christmas = new GregorianCalendar(year, 11, 25);
        this.holidays.add(christmas);
    }

    protected void setConceptionDay(int year) {
        GregorianCalendar conception = new GregorianCalendar(year, 11, 8);
        this.holidays.add(conception);
    }

    protected void setAllSaintsDay(int year) {
        GregorianCalendar allSaints = new GregorianCalendar(year, 10, 1);
        this.holidays.add(allSaints);
    }

    protected void setGoodFriday(int year) {
        GregorianCalendar goodFriday = (GregorianCalendar)this.getEaster(year);
        goodFriday.add(5, -2);
        this.holidays.add(goodFriday);
    }

    protected void setCorpusChristi(int year) {
        GregorianCalendar corpus = (GregorianCalendar)this.getEaster(year);
        corpus.add(5, 60);
        this.holidays.add(corpus);
    }

    protected void setPentecostMonday(int year) {
        GregorianCalendar pentecostMonday = (GregorianCalendar)this.getEaster(year);
        pentecostMonday.add(5, 50);
        this.holidays.add(pentecostMonday);
    }

    protected void setPentecostSunday(int year) {
        GregorianCalendar pentecost = (GregorianCalendar)this.getEaster(year);
        pentecost.add(5, 49);
        this.holidays.add(pentecost);
    }

    protected void setAscensionDay(int year) {
        GregorianCalendar ascension = (GregorianCalendar)this.getEaster(year);
        ascension.add(5, 39);
        this.holidays.add(ascension);
    }

    protected void setEasterMonday(int year) {
        GregorianCalendar easterMonday = (GregorianCalendar)this.getEaster(year);
        easterMonday.add(5, 1);
        this.holidays.add(easterMonday);
    }

    protected void setEasterSunday(int year) {
        GregorianCalendar easter = (GregorianCalendar)this.getEaster(year);
        this.holidays.add(easter);
    }

    protected void setAssumptionBVM(int year) {
        GregorianCalendar assumption = new GregorianCalendar(year, 7, 15);
        this.holidays.add(assumption);
    }
}

