/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.searchModel.PlanningNotificationSearchModel;
import at.cdes.api.joinDto.PlanningNotificationJoin;
import at.cdes.api.joinDto.PlanningNotificationProjectJoin;
import at.cdes.api.voc.ProjectStatus;
import at.cdes.impl.dao.PlanningNotificationDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcPlanningNotificationDAO;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SearchHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcPlanningNotificationDAO
extends AbstractJdbcPlanningNotificationDAO
implements PlanningNotificationDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcPlanningNotificationDAO.class);

    @Override
    public List<PlanningNotificationProjectJoin> getAllProjectJoins() {
        String sql = "SELECT " + JdbcPlanningNotificationDAO.getPlanningNotificationProjectJoinSelectClause() + "FROM   (((    project LEFT JOIN planning_notification_project_map             ON planning_notification_project_map.project_id = project.id) LEFT JOIN planning_notification                         ON planning_notification_project_map.planning_notification_id = planning_notification.id) LEFT JOIN project_config                                ON project.project_config_id = project_config.id) WHERE project.status = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanningNotificationProjectJoin>>(){

            public List<PlanningNotificationProjectJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue());
                ResultSet rs = statement.executeQuery();
                ArrayList<PlanningNotificationProjectJoin> ret = new ArrayList<PlanningNotificationProjectJoin>();
                while (rs.next()) {
                    PlanningNotificationProjectJoin planningNotificationProjectJoin = JdbcPlanningNotificationDAO.fillPlanningNotificationProjectJoinFromResultSet(rs);
                    ret.add(planningNotificationProjectJoin);
                }
                return ret;
            }
        });
    }

    @Override
    public List<PlanningNotificationProjectJoin> getProjectJoin(final Long networkId) {
        String sql = "SELECT " + JdbcPlanningNotificationDAO.getPlanningNotificationProjectJoinSelectClause() + "FROM   (((    project LEFT JOIN planning_notification_project_map             ON planning_notification_project_map.project_id = project.id) LEFT JOIN planning_notification                         ON planning_notification_project_map.planning_notification_id = planning_notification.id) LEFT JOIN project_config                                ON project.project_config_id = project_config.id) WHERE project.network_id = ? AND project.status = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanningNotificationProjectJoin>>(){

            public List<PlanningNotificationProjectJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue());
                ResultSet rs = statement.executeQuery();
                ArrayList<PlanningNotificationProjectJoin> ret = new ArrayList<PlanningNotificationProjectJoin>();
                while (rs.next()) {
                    PlanningNotificationProjectJoin planningNotificationProjectJoin = JdbcPlanningNotificationDAO.fillPlanningNotificationProjectJoinFromResultSet(rs);
                    ret.add(planningNotificationProjectJoin);
                }
                return ret;
            }
        });
    }

    @Override
    public List<PlanningNotificationJoin> getPlanningNotificationJoins(PlanningNotificationSearchModel searchModel) {
        final Long id = searchModel.getId();
        final List titles = searchModel.getPlanningNotificationTitles();
        final String comment = searchModel.getComment();
        final String fileName = searchModel.getFilename();
        final String path = searchModel.getPath();
        final Long networkId = searchModel.getNetworkId();
        final Long projectId = searchModel.getProjectId();
        final Map textMetaTagIdToValue = searchModel.getTextMetaTagIdToValue() != null ? searchModel.getTextMetaTagIdToValue() : new HashMap();
        final Map dateMetaTagIdToFrom = searchModel.getDateMetaTagIdToFrom() != null ? searchModel.getDateMetaTagIdToFrom() : new HashMap();
        final Map dateMetaTagIdToTo = searchModel.getDateMetaTagIdToTo() != null ? searchModel.getDateMetaTagIdToTo() : new HashMap();
        final Set<Long> dateMetaTagIds = JdbcPlanningNotificationDAO.getDateMetaTagIds(dateMetaTagIdToFrom, dateMetaTagIdToTo);
        final Collection planningNotificationIds = searchModel.getPlanningNotificationIds();
        StringBuffer sql = new StringBuffer("SELECT " + JdbcPlanningNotificationDAO.getPlanningNotificationJoinSelectClause() + "FROM   ((((((( planning_notification LEFT JOIN planning_notification_project_map           ON planning_notification_project_map.planning_notification_id = planning_notification.id) LEFT JOIN project                                     ON planning_notification_project_map.project_id = project.id) LEFT JOIN planning_notification_meta_information      ON planning_notification_meta_information.planning_notification_id = planning_notification.id) LEFT JOIN meta_information                            ON planning_notification_meta_information.meta_information_id = meta_information.id) LEFT JOIN meta_tag                                    ON meta_information.meta_tag_id = meta_tag.id) LEFT JOIN planning_notification_text_meta_information ON planning_notification_text_meta_information.meta_information_id = planning_notification_meta_information.meta_information_id) LEFT JOIN planning_notification_date_meta_information ON planning_notification_date_meta_information.meta_information_id = planning_notification_meta_information.meta_information_id) WHERE 1=1 ");
        JdbcPlanningNotificationDAO.appendPlanningNotificationIdClause(sql, id);
        JdbcPlanningNotificationDAO.appendPlanningNotificationIdsClause(sql, planningNotificationIds, titles);
        JdbcPlanningNotificationDAO.appendNotificationCommentClause(sql, comment);
        JdbcPlanningNotificationDAO.appendNotificationFilenameClause(sql, fileName);
        JdbcPlanningNotificationDAO.appendNotificationPathClause(sql, path);
        JdbcPlanningNotificationDAO.appendNetworkClause(sql, networkId);
        JdbcPlanningNotificationDAO.appendProjectClause(sql, projectId);
        JdbcPlanningNotificationDAO.appendTextMetaTagClause(sql, textMetaTagIdToValue);
        JdbcPlanningNotificationDAO.appendDateMetaTagClause(sql, dateMetaTagIds, dateMetaTagIdToFrom, dateMetaTagIdToTo);
        if (log.isDebugEnabled()) {
            Timestamp timeStamp;
            Long utcMillis;
            Double utcSeconds;
            log.debug("Will execute SQL: " + sql);
            log.debug("Parameter comment: [" + comment + "]");
            log.debug("Parameter projectId: [" + projectId + "]");
            for (Long metaTagId : textMetaTagIdToValue.keySet()) {
                log.debug("Parameter textMetaTag for metaTagId [" + metaTagId + "] = [" + (String)textMetaTagIdToValue.get(metaTagId) + "]");
            }
            for (Long metaTagId : dateMetaTagIdToFrom.keySet()) {
                utcSeconds = (Double)dateMetaTagIdToFrom.get(metaTagId);
                utcMillis = utcSeconds != null ? Long.valueOf((long)(utcSeconds * 1000.0)) : null;
                timeStamp = utcMillis != null ? new Timestamp(utcMillis) : null;
                log.debug("Parameter dateMetaTagFrom for metaTagId [" + metaTagId + "] = [" + dateMetaTagIdToFrom.get(metaTagId) + "]; timestamp: [" + timeStamp + "]");
            }
            for (Long metaTagId : dateMetaTagIdToTo.keySet()) {
                utcSeconds = (Double)dateMetaTagIdToTo.get(metaTagId);
                utcMillis = utcSeconds != null ? Long.valueOf((long)(utcSeconds * 1000.0)) : null;
                timeStamp = utcMillis != null ? new Timestamp(utcMillis) : null;
                log.debug("Parameter dateMetaTagTo for metaTagId [" + metaTagId + "] = [" + dateMetaTagIdToTo.get(metaTagId) + "]; timestamp: [" + timeStamp + "]");
            }
        }
        long beforeMillis = System.currentTimeMillis();
        List planningNotificationJoins = (List)this.performWithPreparedStatement(sql.toString(), (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanningNotificationJoin>>(){

            public List<PlanningNotificationJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                currIndex = JdbcPlanningNotificationDAO.setNotificationIdOnStatement(statement, currIndex, id);
                currIndex = JdbcPlanningNotificationDAO.setPlanningNotificationIdsOnStatement(statement, currIndex, planningNotificationIds, titles);
                currIndex = JdbcPlanningNotificationDAO.setNotificationCommentOnStatement(statement, currIndex, comment);
                currIndex = JdbcPlanningNotificationDAO.setNotificationFilenameOnStatement(statement, currIndex, fileName);
                currIndex = JdbcPlanningNotificationDAO.setNotificationPathOnStatement(statement, currIndex, path);
                currIndex = JdbcPlanningNotificationDAO.setNetworkOnStatement(statement, currIndex, networkId);
                currIndex = JdbcPlanningNotificationDAO.setProjectOnStatement(statement, currIndex, projectId);
                currIndex = JdbcPlanningNotificationDAO.setTextMetaTagsOnStatement(statement, currIndex, textMetaTagIdToValue);
                currIndex = JdbcPlanningNotificationDAO.setDateMetaTagsOnStatement(statement, currIndex, dateMetaTagIds, dateMetaTagIdToFrom, dateMetaTagIdToTo);
                ResultSet rs = statement.executeQuery();
                ArrayList<PlanningNotificationJoin> ret = new ArrayList<PlanningNotificationJoin>();
                while (rs.next()) {
                    PlanningNotificationJoin joinDto = AbstractJdbcPlanningNotificationDAO.fillPlanningNotificationJoinFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
        long afterMillis = System.currentTimeMillis();
        double seconds = ((double)afterMillis - (double)beforeMillis) / 1000.0;
        if (log.isDebugEnabled()) {
            log.debug("Query for planning notifications completed in [" + seconds + "s], retrieved [" + planningNotificationJoins.size() + "] rows.");
        }
        return planningNotificationJoins;
    }

    public static Set<Long> getDateMetaTagIds(Map<Long, Double> dateMetaTagIdToFrom, Map<Long, Double> dateMetaTagIdToTo) {
        HashSet<Long> dateMetaTagIdsTemp = new HashSet<Long>();
        dateMetaTagIdsTemp.addAll(dateMetaTagIdToFrom.keySet());
        dateMetaTagIdsTemp.addAll(dateMetaTagIdToTo.keySet());
        return dateMetaTagIdsTemp;
    }

    public static void appendPlanningNotificationIdClause(StringBuffer sql, Long planningNotificationId) {
        if (planningNotificationId != null) {
            sql.append("AND planning_notification.id = ? ");
        }
    }

    public static void appendTitlesClause(StringBuffer sql, List<String> titles) {
        if (titles != null && titles.size() > 0) {
            sql.append("AND (");
            for (int n = 0; n < titles.size(); ++n) {
                sql.append("planning_notification.title LIKE ? " + (n < titles.size() - 1 ? "OR " : ""));
            }
            sql.append(") ");
        }
    }

    public static void appendNotificationCommentClause(StringBuffer sql, String comment) {
        if (SearchHelper.isStringFilled(comment)) {
            sql.append("AND planning_notification.comment LIKE ? ");
        }
    }

    public static void appendNotificationFilenameClause(StringBuffer sql, String filename) {
        if (SearchHelper.isStringFilled(filename)) {
            sql.append("AND planning_notification.filename = ? ");
        }
    }

    public static void appendNotificationPathClause(StringBuffer sql, String path) {
        if (SearchHelper.isStringFilled(path)) {
            sql.append("AND planning_notification.path = ? ");
        }
    }

    public static void appendNetworkClause(StringBuffer sql, Long networkId) {
        if (networkId != null) {
            sql.append("AND planning_notification.network_id = ? ");
        }
    }

    public static void appendProjectClause(StringBuffer sql, Long projectId) {
        if (projectId != null) {
            sql.append("AND planning_notification_project_map.project_id = ? ");
        }
    }

    public static void appendTextMetaTagClause(StringBuffer sql, Map<Long, String> textMetaTagIdToValue) {
        for (Long metaTagId : textMetaTagIdToValue.keySet()) {
            String value = textMetaTagIdToValue.get(metaTagId);
            if (!SearchHelper.isStringFilled(value)) continue;
            List<String> searchedNames = SearchHelper.extractAndConvertSearchTokens(value);
            sql.append("AND EXISTS (SELECT 1 FROM ((   planning_notification_meta_information local_planning_meta_information JOIN planning_notification_text_meta_information local_text_meta_information ON local_text_meta_information.meta_information_id = local_planning_meta_information.meta_information_id) JOIN meta_information local_meta_information ON local_planning_meta_information.meta_information_id = local_meta_information.id) WHERE local_planning_meta_information.planning_notification_id = planning_notification.id AND local_meta_information.meta_tag_id = ? AND (0=1 ");
            for (int n = 0; n < searchedNames.size(); ++n) {
                sql.append("OR local_text_meta_information.value LIKE ? ");
            }
            sql.append(")) ");
        }
    }

    public static void appendDateMetaTagClause(StringBuffer sql, Set<Long> dateMetaTagIds, Map<Long, Double> dateMetaTagIdToFrom, Map<Long, Double> dateMetaTagIdToTo) {
        for (Long metaTagId : dateMetaTagIds) {
            Double from = dateMetaTagIdToFrom.get(metaTagId);
            Double to = dateMetaTagIdToTo.get(metaTagId);
            if (from != null) {
                if (to != null) {
                    sql.append("AND (meta_tag.id != ? OR (planning_notification_date_meta_information.value >= ? AND planning_notification_date_meta_information.value <= ?)) ");
                    continue;
                }
                sql.append("AND (meta_tag.id != ? OR planning_notification_date_meta_information.value >= ?) ");
                continue;
            }
            if (to == null) continue;
            sql.append("AND (meta_tag.id != ? OR planning_notification_date_meta_information.value <= ?) ");
        }
    }

    public static void appendPlanningNotificationIdsClause(StringBuffer sql, Collection<Long> planningNotificationIds, List<String> planningNotificationTitles) {
        if (planningNotificationIds != null && planningNotificationIds.size() > 0 || planningNotificationTitles != null && planningNotificationTitles.size() > 0) {
            sql.append("AND (1=0 ");
            if (planningNotificationIds != null && planningNotificationIds.size() > 0) {
                sql.append("OR planning_notification.id IN (" + QueryHelper.getPlaceHolderSequence(planningNotificationIds.size()) + ") ");
            }
            if (planningNotificationTitles != null && planningNotificationTitles.size() > 0) {
                for (String title : planningNotificationTitles) {
                    if (!SearchHelper.isStringFilled(title)) continue;
                    sql.append("OR planning_notification.title LIKE ? ");
                }
            }
            sql.append(") ");
        }
    }

    public static int setNotificationIdOnStatement(PreparedStatement statement, int currIndex, Long id) throws SQLException {
        if (id != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)id);
        }
        return currIndex;
    }

    public static int setTitlesOnStatement(PreparedStatement statement, int currIndex, List<String> titles) throws SQLException {
        if (titles != null && titles.size() > 0) {
            for (int n = 0; n < titles.size(); ++n) {
                statement.setString(currIndex++, SearchHelper.convertForSearch(titles.get(n)));
            }
        }
        return currIndex;
    }

    public static int setNotificationCommentOnStatement(PreparedStatement statement, int currIndex, String comment) throws SQLException {
        if (SearchHelper.isStringFilled(comment)) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(comment));
        }
        return currIndex;
    }

    public static int setNotificationFilenameOnStatement(PreparedStatement statement, int currIndex, String filename) throws SQLException {
        if (SearchHelper.isStringFilled(filename)) {
            statement.setString(currIndex++, filename);
        }
        return currIndex;
    }

    public static int setNotificationPathOnStatement(PreparedStatement statement, int currIndex, String path) throws SQLException {
        if (SearchHelper.isStringFilled(path)) {
            statement.setString(currIndex++, path);
        }
        return currIndex;
    }

    public static int setNetworkOnStatement(PreparedStatement statement, int currIndex, Long networkId) throws SQLException {
        if (networkId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
        }
        return currIndex;
    }

    public static int setProjectOnStatement(PreparedStatement statement, int currIndex, Long projectId) throws SQLException {
        if (projectId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
        }
        return currIndex;
    }

    public static int setTextMetaTagsOnStatement(PreparedStatement statement, int currIndex, Map<Long, String> textMetaTagIdToValue) throws SQLException {
        for (Long metaTagId : textMetaTagIdToValue.keySet()) {
            String value = textMetaTagIdToValue.get(metaTagId);
            if (!SearchHelper.isStringFilled(value)) continue;
            List<String> searchedNames = SearchHelper.extractAndConvertSearchTokens(value);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)metaTagId);
            for (String searchedName : searchedNames) {
                statement.setString(currIndex++, searchedName);
            }
        }
        return currIndex;
    }

    public static int setDateMetaTagsOnStatement(PreparedStatement statement, int currIndex, Set<Long> dateMetaTagIds, Map<Long, Double> dateMetaTagIdToFrom, Map<Long, Double> dateMetaTagIdToTo) throws SQLException {
        for (Long metaTagId : dateMetaTagIds) {
            Double from = dateMetaTagIdToFrom.get(metaTagId);
            Double to = dateMetaTagIdToTo.get(metaTagId);
            if (from != null) {
                if (to != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)metaTagId);
                    JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)from);
                    JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)to);
                    continue;
                }
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)metaTagId);
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)from);
                continue;
            }
            if (to == null) continue;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)metaTagId);
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)to);
        }
        return currIndex;
    }

    public static int setPlanningNotificationIdsOnStatement(PreparedStatement statement, int currIndex, Collection<Long> planningNotificationIds, List<String> planningNotificationTitles) throws SQLException {
        if (planningNotificationIds != null && planningNotificationIds.size() > 0) {
            for (Long planningNotificationId : planningNotificationIds) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)planningNotificationId);
            }
        }
        if (planningNotificationTitles != null && planningNotificationTitles.size() > 0) {
            for (String planningNotificationTitle : planningNotificationTitles) {
                if (!SearchHelper.isStringFilled(planningNotificationTitle)) continue;
                statement.setString(currIndex++, SearchHelper.convertForSearch(planningNotificationTitle));
            }
        }
        return currIndex;
    }
}

