/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.db.contentChange;

import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.sched.api.ILoggingCallback;
import org.clazzes.util.sched.api.LogMessage;
import org.clazzes.util.sched.api.LogPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdesLoggingCallbackImpl
implements ILoggingCallback {
    private static final Logger log = LoggerFactory.getLogger(CdesLoggingCallbackImpl.class);
    private static final int DEFAULT_MAX_CACHED_MESSAGES = 1000;
    private final Integer maxCachedMessages;
    private List<LogMessage> logMessages;
    private int numberOfFetchedMessages = 0;
    private boolean hasOverflown;

    public CdesLoggingCallbackImpl(Integer maxCachedMessages) {
        this.maxCachedMessages = maxCachedMessages;
    }

    public CdesLoggingCallbackImpl() {
        this.maxCachedMessages = 1000;
    }

    protected synchronized void addMessage(LogPriority pri, String msg) {
        if (this.hasOverflown) {
            return;
        }
        if (this.logMessages == null) {
            this.logMessages = new ArrayList<LogMessage>();
        } else if (this.maxCachedMessages != null && this.logMessages.size() >= this.maxCachedMessages) {
            log.warn("More than [{}] messages cached in memory, did your client starve?", (Object)this.maxCachedMessages);
            this.hasOverflown = true;
            return;
        }
        LogMessage lm = new LogMessage();
        lm.setTimestamp(System.currentTimeMillis());
        lm.setPriority(pri);
        lm.setMessage(msg);
        this.logMessages.add(lm);
    }

    public void ok(String msg) {
        this.addMessage(LogPriority.OK, msg);
    }

    public void debug(String msg) {
        this.addMessage(LogPriority.DEBUG, msg);
    }

    public void info(String msg) {
        this.addMessage(LogPriority.INFO, msg);
    }

    public void warning(String msg) {
        this.addMessage(LogPriority.WARN, msg);
    }

    public void error(String msg) {
        this.addMessage(LogPriority.ERROR, msg);
    }

    public Integer getMaxCachedMessages() {
        return this.maxCachedMessages;
    }

    public List<LogMessage> getAndKeepLogMessages() {
        return this.logMessages;
    }

    public synchronized List<LogMessage> getLastLogMessages() {
        try {
            ArrayList<LogMessage> retList = new ArrayList<LogMessage>();
            for (int n = this.numberOfFetchedMessages; n < this.logMessages.size(); ++n) {
                retList.add(this.logMessages.get(n));
            }
            this.numberOfFetchedMessages = this.logMessages.size();
            ArrayList<LogMessage> arrayList = retList;
            return arrayList;
        }
        finally {
            if (this.maxCachedMessages != null) {
                this.logMessages = null;
            }
            this.hasOverflown = false;
        }
    }
}

