/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.sec;

import at.cdes.api.sec.SecurityQuestionAnswerValidationError;
import at.cdes.api.sec.SecurityQuestionValidator;
import at.cdes.impl.i18n.CdesImplMessages;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public class SecurityQuestionValidatorImpl
implements SecurityQuestionValidator {
    private Integer minLength;
    private static final Pattern SECURITY_ANSWER_PATTERN = Pattern.compile("[a-zA-Z0-9\\\\\\\\\\\\.\\\\-\\\\_\\\\/\\\\!\\\\?\\\\,\\\\<\\\\>\\\\:\\\\(\\\\)\\\\[\\\\]\\\\{\\\\}\\\\%\\\\\u00a7\\\\$\\\\&\\\\\u20ac\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df]*");

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public SecurityQuestionAnswerValidationError validateAnswer(String answer) {
        if (answer == null || answer.trim().isEmpty()) {
            return SecurityQuestionAnswerValidationError.MISSING;
        }
        if (answer.length() < this.minLength) {
            return SecurityQuestionAnswerValidationError.TOO_SHORT;
        }
        if (!SECURITY_ANSWER_PATTERN.matcher(answer).matches()) {
            return SecurityQuestionAnswerValidationError.INVALID_CHARACTERS;
        }
        return SecurityQuestionAnswerValidationError.OK;
    }

    public String getMessage(Locale locale, SecurityQuestionAnswerValidationError error) {
        ResourceBundle messages = CdesImplMessages.getResourceBundle(locale);
        if (error == null) {
            throw new NullPointerException();
        }
        switch (error) {
            case INVALID_CHARACTERS: {
                return messages.getString("securityQuestionAnswerInvalidCharacters");
            }
            case MISSING: {
                return messages.getString("securityQuestionAnswerMissing");
            }
            case TOO_SHORT: {
                return String.format(messages.getString("securityQuestionAnswerTooShort"), this.minLength);
            }
            case OK: {
                throw new IllegalArgumentException("getMessage cannot be called with OK.");
            }
        }
        throw new RuntimeException("unreachable");
    }
}

