/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Job;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Project;
import at.cdes.api.joinDto.JobJoin;
import at.cdes.impl.dao.GenJobDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcJobDAO
extends AbstrIdDAO<Job>
implements GenJobDAO {
    public AbstractJdbcJobDAO() {
        super(Job.class, "id", "job", new String[]{"id", "type", "organisation_person_id", "network_id", "project_id", "parameters", "start_strategy", "state", "uuid", "start_timestamp", "end_timestamp", "size", "result", "log", "create_trx", "mut_trx", "mut_ts"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcJobDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "type") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_person_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "parameters") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "start_strategy") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "state") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "uuid") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "start_timestamp") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "end_timestamp") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "size") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "result") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "log") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcJobDAO.getSelectClauseForDto("job", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcJobDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".type" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "type") + "," + entityLocalName + ".organisation_person_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_person_id") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + "," + entityLocalName + ".project_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_id") + "," + entityLocalName + ".parameters" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "parameters") + "," + entityLocalName + ".start_strategy" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "start_strategy") + "," + entityLocalName + ".state" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "state") + "," + entityLocalName + ".uuid" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "uuid") + "," + entityLocalName + ".start_timestamp" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "start_timestamp") + "," + entityLocalName + ".end_timestamp" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "end_timestamp") + "," + entityLocalName + ".size" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "size") + "," + entityLocalName + ".result" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "result") + "," + entityLocalName + ".log" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "log") + "," + entityLocalName + ".create_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + "," + entityLocalName + ".mut_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + "," + entityLocalName + ".mut_ts" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    protected Job fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        Job job = new Job();
        job.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        job.setType(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        job.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        job.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        job.setProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        job.setParameters(rs.getString(++columnIndex));
        job.setStartStrategy(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        job.setState(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        job.setUuid(rs.getString(++columnIndex));
        job.setStartTimestamp(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        job.setEndTimestamp(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        job.setSize(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        job.setResult(rs.getString(++columnIndex));
        job.setLog(rs.getString(++columnIndex));
        job.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        job.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        job.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return job;
    }

    public static Job fillJobFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        Job job = new Job();
        job.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        job.setType(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        job.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        job.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        job.setProjectId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        job.setParameters(rs.getString(columnIndex.incrementAndGet()));
        job.setStartStrategy(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        job.setState(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        job.setUuid(rs.getString(columnIndex.incrementAndGet()));
        job.setStartTimestamp(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        job.setEndTimestamp(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        job.setSize(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        job.setResult(rs.getString(columnIndex.incrementAndGet()));
        job.setLog(rs.getString(columnIndex.incrementAndGet()));
        job.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        job.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        job.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return job;
    }

    public static Job fillJobFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcJobDAO.fillJobFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 17;
    }

    public static JobJoin fillJobJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        JobJoin jobJoin = new JobJoin();
        jobJoin.setCreateTrxId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setCreateTrxFromTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setCreateTrxToTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setJobId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setJobType(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setJobOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setJobNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setJobProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setJobParameters(rs.getString(++columnIndex));
        jobJoin.setJobStartStrategy(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setJobState(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setJobUuid(rs.getString(++columnIndex));
        jobJoin.setJobStartTimestamp(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setJobEndTimestamp(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setJobSize(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setJobResult(rs.getString(++columnIndex));
        jobJoin.setJobLog(rs.getString(++columnIndex));
        jobJoin.setJobCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setJobMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setJobMutTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setNetworkName(rs.getString(++columnIndex));
        jobJoin.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setPersonGivenName(rs.getString(++columnIndex));
        jobJoin.setPersonSurName(rs.getString(++columnIndex));
        jobJoin.setProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        jobJoin.setProjectCode(rs.getString(++columnIndex));
        jobJoin.setProjectName(rs.getString(++columnIndex));
        return jobJoin;
    }

    public static int getNumberOfJobJoinAttributes() {
        return 29;
    }

    protected String getSelectClauseForJobJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("CreateTrx") ? result + "create_trx.id, create_trx.from_ts, create_trx.to_ts" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("job") ? result + "job.id, job.type, job.organisation_person_id, job.network_id, job.project_id, job.parameters, job.start_strategy, job.state, job.uuid, job.start_timestamp, job.end_timestamp, job.size, job.result, job.log, job.create_trx, job.mut_trx, job.mut_ts" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("network") ? result + "network.id, network.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("organisationPerson") ? result + "organisation_person.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("person") ? result + "person.id, person.givenName, person.surName" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("project") ? result + "project.id, project.code, project.name" : result + "NULL, NULL, NULL";
        return result;
    }

    public int update(Job dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<Job> dtos) {
        Iterator<Job> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    public static String getJobJoinSelectClause() {
        return "create_trx.id, create_trx.from_ts, create_trx.to_ts, job.id, job.type, job.organisation_person_id, job.network_id, job.project_id, job.parameters, job.start_strategy, job.state, job.uuid, job.start_timestamp, job.end_timestamp, job.size, job.result, job.log, job.create_trx, job.mut_trx, job.mut_ts, network.id, network.name, organisation_person.id, person.id, person.givenName, person.surName, project.id, project.code, project.name ";
    }

    public static String getPrefixedJobJoinSelectClause() {
        return "create_trx.id AS create_trx_id, create_trx.from_ts AS create_trx_from_ts, create_trx.to_ts AS create_trx_to_ts, job.id AS job_id, job.type AS job_type, job.organisation_person_id AS job_organisation_person_id, job.network_id AS job_network_id, job.project_id AS job_project_id, job.parameters AS job_parameters, job.start_strategy AS job_start_strategy, job.state AS job_state, job.uuid AS job_uuid, job.start_timestamp AS job_start_timestamp, job.end_timestamp AS job_end_timestamp, job.size AS job_size, job.result AS job_result, job.log AS job_log, job.create_trx AS job_create_trx, job.mut_trx AS job_mut_trx, job.mut_ts AS job_mut_ts, network.id AS network_id, network.name AS network_name, organisation_person.id AS organisation_person_id, person.id AS person_id, person.givenName AS person_givenName, person.surName AS person_surName, project.id AS project_id, project.code AS project_code, project.name AS project_name ";
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, Job job) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)job.getId());
        JDBCHelper.setInt((PreparedStatement)statement, (int)2, (Number)job.getType());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)job.getOrganisationPersonId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)job.getNetworkId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)job.getProjectId());
        statement.setString(6, job.getParameters());
        JDBCHelper.setInt((PreparedStatement)statement, (int)7, (Number)job.getStartStrategy());
        JDBCHelper.setInt((PreparedStatement)statement, (int)8, (Number)job.getState());
        statement.setString(9, job.getUuid());
        JDBCHelper.setLong((PreparedStatement)statement, (int)10, (Number)job.getStartTimestamp());
        JDBCHelper.setLong((PreparedStatement)statement, (int)11, (Number)job.getEndTimestamp());
        JDBCHelper.setLong((PreparedStatement)statement, (int)12, (Number)job.getSize());
        statement.setString(13, job.getResult());
        statement.setString(14, job.getLog());
        JDBCHelper.setLong((PreparedStatement)statement, (int)15, (Number)(job.getCreateTrx() != null ? job.getCreateTrx() : (Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)16, (Number)((Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)17, (Number)System.currentTimeMillis());
    }

    @Override
    public List<Job> getByOrganisationPerson(OrganisationPerson organisationPerson) {
        return this.getByOrganisationPerson(organisationPerson.getId());
    }

    @Override
    public List<Job> getByOrganisationPerson(final Long organisationPersonId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_person_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, organisationPersonId);
            }
        });
    }

    @Override
    public List<Job> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<Job> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<Job> getByProject(Project project) {
        return this.getByProject(project.getId());
    }

    @Override
    public List<Job> getByProject(final Long projectId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, projectId);
            }
        });
    }

    @Override
    public List<Job> getByOrganisationPersons(Collection<Long> organisationPersonId) {
        if (organisationPersonId.isEmpty()) {
            return new ArrayList<Job>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[organisationPersonId.size()];
        int n = 0;
        Iterator<Long> it = organisationPersonId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_person_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Job> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<Job>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Job> getByProjects(Collection<Long> projectId) {
        if (projectId.isEmpty()) {
            return new ArrayList<Job>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[projectId.size()];
        int n = 0;
        Iterator<Long> it = projectId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

