/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.BaseTask;
import at.cdes.api.dto.FutureEmail;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.impl.dao.FutureEmailDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcFutureEmailDAO
extends AbstrIdDAO<FutureEmail>
implements FutureEmailDAO {
    public JdbcFutureEmailDAO() {
        super(FutureEmail.class, "id", "future_email", new String[]{"id", "project_participation_id", "send_time", "main_participant_only", "task_id", "type"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcFutureEmailDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_participation_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "send_time") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "main_participant_only") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "task_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "type") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcFutureEmailDAO.getSelectClauseForDto("future_email", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcFutureEmailDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".project_participation_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_participation_id") + "," + entityLocalName + ".send_time" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "send_time") + "," + entityLocalName + ".main_participant_only" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "main_participant_only") + "," + entityLocalName + ".task_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "task_id") + "," + entityLocalName + ".type" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "type") + " ";
    }

    protected FutureEmail fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        FutureEmail futureEmail = new FutureEmail();
        futureEmail.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        futureEmail.setProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        futureEmail.setSendTime(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        futureEmail.setMainParticipantOnly(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        futureEmail.setTaskId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        futureEmail.setType(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        return futureEmail;
    }

    public static FutureEmail fillFutureEmailFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        FutureEmail futureEmail = new FutureEmail();
        futureEmail.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        futureEmail.setProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        futureEmail.setSendTime(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        futureEmail.setMainParticipantOnly(JDBCHelper.getBoolean((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        futureEmail.setTaskId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        futureEmail.setType(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return futureEmail;
    }

    public static FutureEmail fillFutureEmailFromResultSet(ResultSet rs) throws SQLException {
        return JdbcFutureEmailDAO.fillFutureEmailFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 6;
    }

    @Override
    public void deleteByParticipation(final Long projectParticipationId) {
        String sql = "DELETE FROM future_email WHERE project_participation_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, projectParticipationId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(FutureEmail dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<FutureEmail> dtos) {
        Iterator<FutureEmail> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, FutureEmail futureEmail) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)futureEmail.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)futureEmail.getProjectParticipationId());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)3, (Double)futureEmail.getSendTime());
        JDBCHelper.setBoolean((PreparedStatement)statement, (int)4, (Boolean)futureEmail.getMainParticipantOnly());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)futureEmail.getTaskId());
        JDBCHelper.setInt((PreparedStatement)statement, (int)6, (Number)futureEmail.getType());
    }

    @Override
    public List<FutureEmail> getByProjectParticipation(ProjectParticipation projectParticipation) {
        return this.getByProjectParticipation(projectParticipation.getId());
    }

    @Override
    public List<FutureEmail> getByProjectParticipation(final Long projectParticipationId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_participation_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, projectParticipationId);
            }
        });
    }

    @Override
    public List<FutureEmail> getByTask(BaseTask baseTask) {
        return this.getByTask(baseTask.getId());
    }

    @Override
    public List<FutureEmail> getByTask(final Long baseTaskId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"task_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, baseTaskId);
            }
        });
    }

    @Override
    public List<FutureEmail> getByProjectParticipations(Collection<Long> projectParticipationId) {
        if (projectParticipationId.isEmpty()) {
            return new ArrayList<FutureEmail>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[projectParticipationId.size()];
        int n = 0;
        Iterator<Long> it = projectParticipationId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_participation_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<FutureEmail> getByTasks(Collection<Long> baseTaskId) {
        if (baseTaskId.isEmpty()) {
            return new ArrayList<FutureEmail>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[baseTaskId.size()];
        int n = 0;
        Iterator<Long> it = baseTaskId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"task_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

