/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.document;

import at.cdes.api.document.compositeDto.DocumentListData;
import at.cdes.api.document.compositeDto.DocumentListRow;
import at.cdes.api.document.searchModel.DocumentSearchModel;
import at.cdes.api.dto.DocumentType;
import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.Object;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.ObjectRelease;
import at.cdes.api.dto.ObjectType;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleResultOption;
import at.cdes.api.guiService.DocumentService;
import at.cdes.api.guiService.UtilService;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.joinDto.ProjectLocalisationJoin;
import at.cdes.api.review.compositeDto.ReviewCycleInfo;
import at.cdes.api.voc.DocumentVersionStatus;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.api.voc.ReviewCycleStatusSearchDelay;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.DocumentTypeDAO;
import at.cdes.impl.dao.ObjectDAO;
import at.cdes.impl.dao.ObjectPlannerDAO;
import at.cdes.impl.dao.ObjectPlannerReleaseDAO;
import at.cdes.impl.dao.ObjectReleaseDAO;
import at.cdes.impl.dao.ObjectTypeDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ReviewCycleCellDAO;
import at.cdes.impl.dao.ReviewCycleNodeDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.export.CdesExportHelper;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.service.ChallengeLoginServiceImpl;
import at.cdes.impl.util.CodeHelper;
import at.cdes.impl.util.ContainerHelper;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.SearchHelper;
import at.cdes.impl.util.i18n.I18nHelper;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.draw.FrameFactory;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeBinaryDataElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.incubator.doc.draw.OdfDrawImage;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class DocumentPagePdfExporter {
    private ActionDAO actionDAO;
    private DocumentService documentService;
    private DocumentTypeDAO documentTypeDAO;
    private ObjectDAO objectDAO;
    private ObjectTypeDAO objectTypeDAO;
    private ObjectReleaseDAO objectReleaseDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private ObjectPlannerReleaseDAO objectPlannerReleaseDAO;
    private String odfStylePrefix;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private OrganisationPersonDAO organisationPersonDAO;
    private ProjectDAO projectDAO;
    private ReviewCycleCellDAO reviewCycleCellDAO;
    private ReviewCycleNodeDAO reviewCycleNodeDAO;
    private SubProjectDAO subProjectDAO;
    private String tempDirName;
    private UtilService utilService;
    private static final Logger log = LoggerFactory.getLogger(DocumentPagePdfExporter.class);

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setDocumentTypeDAO(DocumentTypeDAO documentTypeDAO) {
        this.documentTypeDAO = documentTypeDAO;
    }

    public void setobjectDAO(ObjectDAO objectDAO) {
        this.objectDAO = objectDAO;
    }

    public void setobjectTypeDAO(ObjectTypeDAO objectTypeDAO) {
        this.objectTypeDAO = objectTypeDAO;
    }

    public void setobjectReleaseDAO(ObjectReleaseDAO objectReleaseDAO) {
        this.objectReleaseDAO = objectReleaseDAO;
    }

    public void setobjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    public void setobjectPlannerReleaseDAO(ObjectPlannerReleaseDAO objectPlannerReleaseDAO) {
        this.objectPlannerReleaseDAO = objectPlannerReleaseDAO;
    }

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setReviewCycleCellDAO(ReviewCycleCellDAO reviewCycleCellDAO) {
        this.reviewCycleCellDAO = reviewCycleCellDAO;
    }

    public void setReviewCycleNodeDAO(ReviewCycleNodeDAO reviewCycleNodeDAO) {
        this.reviewCycleNodeDAO = reviewCycleNodeDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public ScratchFile export(DocumentSearchModel searchModel, Map<String, Double> columnToWidth, List<ColumnSortSpec> columnSortSpecs, boolean enableCustomerLogo) throws Exception {
        Long organisationPersonId = searchModel.getOrganisationPersonId();
        Long subProjectId = searchModel.getSubProjectId();
        ContextJoin contextJoin = this.subProjectDAO.getSubProjectContextJoin(subProjectId);
        DocumentListData documentListData = this.documentService.getDocumentListSmallJoin(searchModel);
        ProjectLocalisationJoin localisationJoin = this.projectDAO.getLocalisationJoinBySubProject(subProjectId);
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String personVariablesUserLocale = orgPersonJoin.getPersonVariablesUserLocale();
        String projectLocale = I18nHelper.getProjectLocale(localisationJoin);
        List<String> contentLocales = I18nHelper.getContentLocales(localisationJoin);
        this.checkPrivileges(organisationPersonId, documentListData);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(orgPersonJoin.getPersonVariablesUserLocale());
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyLandscapeTemplate.odt", ChallengeLoginServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        OfficeTextElement officeText = document.getContentRoot();
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        AutomaticStyles stylesAutomaticStyles = context.getStylesAutomaticStyles();
        DocumentPageLocalStyles localStyles = this.constructLocalStyles(context);
        OdfHelper.constructHeader(context, document, localStyles.getStandardParagraphStyle(), null, enableCustomerLogo);
        String projectCode = contextJoin.getProjectCode();
        String projectName = contextJoin.getProjectName();
        String leftFooterLabelRaw = resourceBundle.getString("documentListPdfLeftFooterLabel");
        String leftFooterLabel = MessageFormat.format(leftFooterLabelRaw, projectCode, projectName);
        OdfHelper.constructFooter(context, document, localStyles.getStandardParagraphStyle(), leftFooterLabel);
        OdfHelper.constructCaptionTable(context, officeText, standardParagraphStyle, resourceBundle.getString("documentListPdfCaption"));
        this.constructObjectHeaderTable(contextJoin, context, localStyles, officeText, resourceBundle);
        if (this.displayFilterOptions(searchModel)) {
            this.appendFilterOptions(searchModel, context, localStyles, officeText, resourceBundle, projectLocale, contentLocales);
        }
        columnSortSpecs = this.translateSortColumns(columnSortSpecs);
        this.appendMainTable(documentListData, contentLocales, context, localStyles, officeText, columnSortSpecs, resourceBundle, projectLocale, personVariablesUserLocale);
        List documentListRows = documentListData.getDocumentListRows();
        String entriesLabel = OdfHelper.getNumberOfEntriesLabel(resourceBundle, documentListRows.size());
        String textStyle = this.constructDataTextStyle(context, standardParagraphStyle, "10pt", null, "right");
        TextFactory.constructTextNode((Node)officeText, (String)entriesLabel, (String)textStyle);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_Planverzeichnis_", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        return new ScratchFile(new File(tmpFileName), "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private void checkPrivileges(Long organisationPersonId, DocumentListData documentListData) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List documentListRows = documentListData.getDocumentListRows();
        HashSet<Long> projectIds = new HashSet<Long>();
        for (DocumentListRow documentListRow : documentListRows) {
            projectIds.add(documentListRow.getProjectId());
        }
        Map<Long, Set<Action>> projectIdToActions = this.actionDAO.getActionsForProjects(organisationPersonId, projectIds, Action.DOCUMENT_VERSIONS_OVERVIEW);
        for (Long projectId : projectIds) {
            Set<Action> actions = projectIdToActions.get(projectId);
            if (actions.contains(Action.DOCUMENT_VERSIONS_OVERVIEW)) continue;
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have privilege [documentVersionsOverview] for Project [" + projectId + "].  The pdf export is not allowed.");
        }
    }

    private void constructObjectHeaderTable(ContextJoin contextJoin, OdfContext context, DocumentPageLocalStyles localStyles, OfficeTextElement officeText, ResourceBundle resourceBundle) {
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        StyleTableCellPropertiesElement labelProperties = this.constructDefaultCellProperties(contentAutomaticStyles, "#f3f3f3", "0.05pt solid #666666");
        String labelCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{labelProperties});
        StyleTableCellPropertiesElement valueProperties = this.constructDefaultCellProperties(contentAutomaticStyles, null, "0.05pt solid #666666");
        String valueCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{valueProperties});
        String projectCode = contextJoin.getProjectCode();
        String projectName = contextJoin.getProjectName();
        String stretchName = contextJoin.getProjectStretchName();
        Double stretchKmFrom = contextJoin.getProjectStretchKmFrom();
        Double stretchKmTo = contextJoin.getProjectStretchKmTo();
        String projectComment = contextJoin.getProjectComment();
        String subProjectCode = contextJoin.getSubProjectCode();
        String subProjectNumber = contextJoin.getSubProjectNumber() != null ? contextJoin.getSubProjectNumber().toString() : "";
        String subProjectName = contextJoin.getSubProjectName();
        DecimalFormat kmFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.GERMAN);
        kmFormat.applyPattern("###,###.###");
        String kmFromString = kmFormat.format(stretchKmFrom);
        String kmToString = kmFormat.format(stretchKmTo);
        TableTableElement tableElement = officeText.newTableTableElement();
        StyleTablePropertiesElement tableProperties = contentAutomaticStyles.constructTableProperties("27.2cm", null, "left", "lr-tb");
        String tableStyle = contentAutomaticStyles.getTableStyle(new OdfStylePropertiesBase[]{tableProperties});
        tableElement.setStyleName(tableStyle);
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"5.0cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"22.2cm");
        String spanBoldTextStyle = localStyles.getSpanBoldTextStyle();
        String spanDefaultTextStyle = localStyles.getSpanDefaultTextStyle();
        TableTableRowElement projectRow = TableFactory.appendRow((TableTableElement)tableElement, null);
        CdesExportHelper.appendTextSpanCell(projectRow, labelCellStyle, spanBoldTextStyle, resourceBundle.getString("objectHeaderProjectLabel"));
        CdesExportHelper.appendTextSpanCell(projectRow, valueCellStyle, spanDefaultTextStyle, projectCode + " " + projectName);
        TableTableRowElement stretchRow = TableFactory.appendRow((TableTableElement)tableElement, null);
        CdesExportHelper.appendTextSpanCell(stretchRow, labelCellStyle, spanBoldTextStyle, resourceBundle.getString("objectHeaderStretchLabel"));
        CdesExportHelper.appendTextSpanCell(stretchRow, valueCellStyle, spanDefaultTextStyle, stretchName);
        TableTableRowElement kmRow = TableFactory.appendRow((TableTableElement)tableElement, null);
        CdesExportHelper.appendTextSpanCell(kmRow, labelCellStyle, spanBoldTextStyle, resourceBundle.getString("objectHeaderKmLabel"));
        String kmValueRaw = resourceBundle.getString("objectHeaderKmValue");
        String kmValue = MessageFormat.format(kmValueRaw, kmFromString, kmToString);
        CdesExportHelper.appendTextSpanCell(kmRow, valueCellStyle, spanDefaultTextStyle, kmValue);
        TableTableRowElement commentRow = TableFactory.appendRow((TableTableElement)tableElement, null);
        CdesExportHelper.appendTextSpanCell(commentRow, labelCellStyle, spanBoldTextStyle, resourceBundle.getString("objectHeaderCommentLabel"));
        CdesExportHelper.appendTextSpanCell(commentRow, valueCellStyle, spanDefaultTextStyle, projectComment);
        TableTableRowElement subProjectRow = TableFactory.appendRow((TableTableElement)tableElement, null);
        CdesExportHelper.appendTextSpanCell(subProjectRow, labelCellStyle, spanBoldTextStyle, resourceBundle.getString("objectHeaderSubProjectLabel"));
        CdesExportHelper.appendTextSpanCell(subProjectRow, valueCellStyle, spanDefaultTextStyle, subProjectCode + subProjectNumber + " " + subProjectName);
    }

    private boolean displayFilterOptions(DocumentSearchModel searchModel) {
        return searchModel.getStatus() != null || searchModel.getDelayOption() != null || searchModel.getReviewCycleIds() != null && searchModel.getReviewCycleIds().size() > 0 || searchModel.getReviewCycleCellIds() != null && searchModel.getReviewCycleCellIds().size() > 0 || searchModel.getReviewCycleNodeIds() != null && searchModel.getReviewCycleNodeIds().size() > 0 || searchModel.getDocumentTypeId() != null || searchModel.getObjectId() != null || searchModel.getObjectPlannerId() != null || searchModel.getUploadedFrom() != null || searchModel.getUploadedTo() != null || searchModel.getReleasedFrom() != null || searchModel.getReleasedTo() != null || SearchHelper.isStringFilled(searchModel.getName()) || SearchHelper.isStringFilled(searchModel.getContent()) || searchModel.getPlannerOrgPersonId() != null || SearchHelper.isStringFilled(searchModel.getPlannerName()) || searchModel.getProjectParticipationId() != null;
    }

    private void appendFilterOptions(DocumentSearchModel searchModel, OdfContext context, DocumentPageLocalStyles localStyles, OfficeTextElement officeText, ResourceBundle resourceBundle, String projectLocale, List<String> contentLocales) {
        Styles officeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        OdfStylePropertiesBase[] subHeadingProperties = new OdfStylePropertiesBase[]{officeStyles.constructParagraphPropertiesWithMargin(null, null, "0.7cm", "0.212cm"), officeStyles.constructTextPropertiesWithFont("Arial", "Arial", "8pt", "bold", "variable")};
        String filterHeadingStyle = officeStyles.getParagraphStyle(subHeadingProperties);
        StyleTableCellPropertiesElement cellProperties = this.constructDefaultCellProperties(contentAutomaticStyles, "#f3f3f3", null);
        String cellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{cellProperties});
        String caption = resourceBundle.getString("documentListFilterOptionsCaption");
        TextFactory.constructTextHeaderNode((Node)officeText, (String)caption, (String)filterHeadingStyle, (Integer)3);
        TableTableElement tableElement = officeText.newTableTableElement();
        StyleTablePropertiesElement tableProperties = contentAutomaticStyles.constructTableProperties("27.2cm", null, "left", "lr-tb");
        String tableStyle = contentAutomaticStyles.getTableStyle(new OdfStylePropertiesBase[]{tableProperties});
        tableElement.setStyleName(tableStyle);
        String spanTextStyleSmall = localStyles.getSpanTextStyleSmall();
        String spanTextStyleSmallBold = localStyles.getSpanTextStyleSmallBold();
        boolean releasedFilled = searchModel.getReleasedFrom() != null || searchModel.getReleasedTo() != null;
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"2.0cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"7.1cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"2.0cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"7.1cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"2.0cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"7.0cm");
        TableTableRowElement firstRow = TableFactory.appendRow((TableTableElement)tableElement, null);
        CdesExportHelper.appendTextSpanCell(firstRow, cellStyle, spanTextStyleSmallBold, resourceBundle.getString("documentListFilterStatusLabel"));
        CdesExportHelper.appendTextSpanCell(firstRow, cellStyle, spanTextStyleSmall, this.getSearchedDocumentStatusString(searchModel, resourceBundle));
        CdesExportHelper.appendTextSpanCell(firstRow, cellStyle, spanTextStyleSmallBold, resourceBundle.getString("documentListFilterDateLabel"));
        CdesExportHelper.appendTextSpanCell(firstRow, cellStyle, spanTextStyleSmall, this.getSearchedDelayString(searchModel, resourceBundle));
        CdesExportHelper.appendTextSpanCell(firstRow, cellStyle, spanTextStyleSmallBold, resourceBundle.getString("documentListFilterPhaseLabel"));
        CdesExportHelper.appendTextSpanCell(firstRow, cellStyle, spanTextStyleSmall, this.getSearchedPhaseString(searchModel, resourceBundle, projectLocale, contentLocales));
        TableTableRowElement secondRow = TableFactory.appendRow((TableTableElement)tableElement, null);
        CdesExportHelper.appendTextSpanCell(secondRow, cellStyle, spanTextStyleSmallBold, resourceBundle.getString("documentListFilterDocumentTypeLabel"));
        CdesExportHelper.appendTextSpanCell(secondRow, cellStyle, spanTextStyleSmall, this.getSearchedDocumentTypeString(searchModel, resourceBundle));
        CdesExportHelper.appendTextSpanCell(secondRow, cellStyle, spanTextStyleSmallBold, resourceBundle.getString(searchModel.getObjectPlannerId() != null ? "documentListFilterObjectPlannerLabel" : "documentListFilterObjectLabel"));
        CdesExportHelper.appendTextSpanCell(secondRow, cellStyle, spanTextStyleSmall, this.getSearchedObjectString(searchModel, resourceBundle));
        CdesExportHelper.appendTextSpanCell(secondRow, cellStyle, spanTextStyleSmallBold, releasedFilled ? resourceBundle.getString("documentListFilterReleasedLabel") : resourceBundle.getString("documentListFilterUploadedLabel"));
        CdesExportHelper.appendTextSpanCell(secondRow, cellStyle, spanTextStyleSmall, this.getSearchedFromString(searchModel, resourceBundle), spanTextStyleSmallBold, resourceBundle.getString("toLabel"), spanTextStyleSmall, this.getSearchedToString(searchModel, resourceBundle));
        TableTableRowElement thirdRow = TableFactory.appendRow((TableTableElement)tableElement, null);
        CdesExportHelper.appendTextSpanCell(thirdRow, cellStyle, spanTextStyleSmallBold, resourceBundle.getString("documentListFilterDocumentNameLabel"));
        CdesExportHelper.appendTextSpanCell(thirdRow, cellStyle, spanTextStyleSmall, this.getSearchedDocumentVersionNameString(searchModel));
        CdesExportHelper.appendTextSpanCell(thirdRow, cellStyle, spanTextStyleSmallBold, resourceBundle.getString("documentListFilterDocumentContentLabel"));
        CdesExportHelper.appendTextSpanCell(thirdRow, cellStyle, spanTextStyleSmall, this.getSearchedDocumentContentString(searchModel));
        CdesExportHelper.appendTextSpanCell(thirdRow, cellStyle, spanTextStyleSmallBold, resourceBundle.getString("documentListFilterPlannerLabel"));
        CdesExportHelper.appendTextSpanCell(thirdRow, cellStyle, spanTextStyleSmall, this.getSearchedPlannerString(searchModel, resourceBundle));
    }

    private String getSearchedDocumentStatusString(DocumentSearchModel searchModel, ResourceBundle resourceBundle) {
        Integer status = searchModel.getStatus();
        if (status == null) {
            return resourceBundle.getString("allFilterLabel");
        }
        return CodeHelper.getI18nDocumentVersionStatus(resourceBundle, status);
    }

    private String getSearchedDelayString(DocumentSearchModel searchModel, ResourceBundle resourceBundle) {
        Integer delayOptionInt = searchModel.getDelayOption();
        ReviewCycleStatusSearchDelay delay = ReviewCycleStatusSearchDelay.getByValue((Integer)delayOptionInt);
        if (delay == null) {
            return resourceBundle.getString("allFilterLabel");
        }
        if (delay == ReviewCycleStatusSearchDelay.NO_DELAY) {
            return resourceBundle.getString("reviewCycleStatusSearchNoDelay");
        }
        if (delay == ReviewCycleStatusSearchDelay.DELAY) {
            return resourceBundle.getString("reviewCycleStatusSearchDelay");
        }
        if (delay == ReviewCycleStatusSearchDelay.LONG_DELAY) {
            return resourceBundle.getString("reviewCycleStatusSearchLongDelay");
        }
        throw new IllegalArgumentException("Unsupported ReviewCycleStatusSearchDelay value");
    }

    private String getSearchedPhaseString(DocumentSearchModel searchModel, ResourceBundle resourceBundle, String projectLocale, List<String> contentLocales) {
        List reviewCycleNodeIds;
        Long reviewCycleNodeId;
        Long reviewCycleCellId;
        String phaseSearchString = resourceBundle.getString("allFilterLabel");
        List reviewCycleCellIds = searchModel.getReviewCycleCellIds();
        Long l = reviewCycleCellId = reviewCycleCellIds != null && reviewCycleCellIds.size() > 0 ? (Long)reviewCycleCellIds.get(0) : null;
        if (reviewCycleCellId != null) {
            ReviewCycleCell reviewCycleCell = (ReviewCycleCell)this.reviewCycleCellDAO.get(reviewCycleCellId);
            if (reviewCycleCell == null) {
                phaseSearchString = resourceBundle.getString("unknown cell");
            } else {
                String reviewCycleCellName;
                String reviewCycleCellNameRaw = reviewCycleCell.getName();
                String reviewCycleCellNameJs = I18nHelper.convertDatabaseToJs(reviewCycleCellNameRaw, projectLocale, contentLocales);
                phaseSearchString = reviewCycleCellName = I18nHelper.getLocaleString(reviewCycleCellNameJs, projectLocale);
            }
        }
        Long l2 = reviewCycleNodeId = (reviewCycleNodeIds = searchModel.getReviewCycleNodeIds()) != null && reviewCycleNodeIds.size() > 0 ? (Long)reviewCycleNodeIds.get(0) : null;
        if (reviewCycleNodeId != null) {
            ReviewCycleNode reviewCycleNode = (ReviewCycleNode)this.reviewCycleNodeDAO.get(reviewCycleNodeId);
            if (reviewCycleNode == null) {
                phaseSearchString = resourceBundle.getString("unknown node");
            } else {
                ReviewCycleCell reviewCycleCell = (ReviewCycleCell)this.reviewCycleCellDAO.get(reviewCycleNode.getReviewCycleCellId());
                String reviewCycleCellNameRaw = reviewCycleCell.getName();
                String reviewCycleCellNameJs = I18nHelper.convertDatabaseToJs(reviewCycleCellNameRaw, projectLocale, contentLocales);
                String reviewCycleCellName = I18nHelper.getLocaleString(reviewCycleCellNameJs, projectLocale);
                String reviewCycleNodeNameRaw = reviewCycleNode.getName();
                String reviewCycleNodeNameJs = I18nHelper.convertDatabaseToJs(reviewCycleNodeNameRaw, projectLocale, contentLocales);
                String reviewCycleNodeName = I18nHelper.getLocaleString(reviewCycleNodeNameJs, projectLocale);
                phaseSearchString = reviewCycleCellName + " - " + reviewCycleNodeName;
            }
        }
        return phaseSearchString;
    }

    private String getSearchedDocumentTypeString(DocumentSearchModel searchModel, ResourceBundle resourceBundle) {
        Long documentTypeId = searchModel.getDocumentTypeId();
        if (documentTypeId == null) {
            return resourceBundle.getString("allFilterLabel");
        }
        DocumentType documentType = (DocumentType)this.documentTypeDAO.get(documentTypeId);
        if (documentType == null) {
            return resourceBundle.getString("unknownLong");
        }
        return documentType.getCode() + " " + documentType.getName();
    }

    private String getSearchedObjectString(DocumentSearchModel searchModel, ResourceBundle resourceBundle) {
        Long objectId = searchModel.getObjectId();
        Long objectPlannerId = searchModel.getObjectPlannerId();
        if (objectId != null) {
            Object object = (Object)this.objectDAO.get(objectId);
            ObjectRelease objectRel = null;
            List<ObjectRelease> objectReleases = this.objectReleaseDAO.getLastReleasedObjects(searchModel.getSubProjectId());
            for (ObjectRelease objectRelease : objectReleases) {
                if (!objectRelease.getObjectId().equals(objectId)) continue;
                objectRel = objectRelease;
                break;
            }
            if (objectRel == null) {
                return resourceBundle.getString("unknownLong");
            }
            String objectTypeCode = null;
            if (objectRel.getObjectTypeId() != null) {
                objectTypeCode = ((ObjectType)this.objectTypeDAO.get(objectRel.getObjectTypeId())).getCode();
            }
            return objectRel.getCode() + (objectRel.getObjectTypeId() != null ? objectTypeCode : "") + " " + objectRel.getName();
        }
        if (objectPlannerId != null) {
            ObjectPlannerRelease objectPlannerRel = null;
            List<ObjectPlannerRelease> objectPlannerReleases = this.objectPlannerReleaseDAO.getByObjectPlanner(objectPlannerId);
            if (objectPlannerReleases != null && objectPlannerReleases.size() > 0) {
                objectPlannerRel = objectPlannerReleases.get(objectPlannerReleases.size() - 1);
            }
            if (objectPlannerRel == null) {
                return resourceBundle.getString("unknownLong");
            }
            return objectPlannerRel.getCode() + " " + objectPlannerRel.getArea();
        }
        return resourceBundle.getString("allFilterLabel");
    }

    private String getSearchedFromString(DocumentSearchModel searchModel, ResourceBundle resourceBundle) {
        Double uploadedFrom = searchModel.getUploadedFrom();
        Double releasedFrom = searchModel.getReleasedFrom();
        if (uploadedFrom != null) {
            return DateHelper.formatUtcSeconds(uploadedFrom, "Europe/Vienna", resourceBundle.getString("yearToSecondFormat"));
        }
        if (releasedFrom != null) {
            return DateHelper.formatUtcSeconds(releasedFrom, "Europe/Vienna", resourceBundle.getString("yearToSecondFormat"));
        }
        return "";
    }

    private String getSearchedToString(DocumentSearchModel searchModel, ResourceBundle resourceBundle) {
        Double uploadedTo = searchModel.getUploadedTo();
        Double releasedTo = searchModel.getReleasedTo();
        if (uploadedTo != null) {
            return DateHelper.formatUtcSeconds(uploadedTo, "Europe/Vienna", resourceBundle.getString("yearToSecondFormat"));
        }
        if (releasedTo != null) {
            return DateHelper.formatUtcSeconds(releasedTo, "Europe/Vienna", resourceBundle.getString("yearToSecondFormat"));
        }
        return "";
    }

    private String getSearchedDocumentVersionNameString(DocumentSearchModel searchModel) {
        String documentVersionName = searchModel.getName();
        return documentVersionName != null ? documentVersionName : "";
    }

    private String getSearchedDocumentContentString(DocumentSearchModel searchModel) {
        String documentContent = searchModel.getContent();
        return documentContent != null ? documentContent : "";
    }

    private String getSearchedPlannerString(DocumentSearchModel searchModel, ResourceBundle resourceBundle) {
        Long plannerOrganisationPersonId = searchModel.getPlannerOrgPersonId();
        String plannerName = searchModel.getPlannerName();
        if (plannerOrganisationPersonId != null) {
            OrganisationPersonJoin organisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(plannerOrganisationPersonId);
            Organisation organisation = organisationPersonJoin.getOrganisation();
            Person person = organisationPersonJoin.getPerson();
            return PersonHelper.getOrganisationAndInverseCommonName(organisation, person);
        }
        if (plannerName != null) {
            return plannerName;
        }
        return resourceBundle.getString("allFilterLabel");
    }

    private void appendMainTable(DocumentListData documentListData, final List<String> contentLocales, final OdfContext context, DocumentPageLocalStyles localStyles, OfficeTextElement officeText, List<ColumnSortSpec> columnSortSpecs, final ResourceBundle resourceBundle, final String projectLocale, final String personVariablesUserLocale) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        String tableUnderCaptionStyle = null;
        String standardParagraphStyle = localStyles.getStandardParagraphStyle();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        final String dataCellStyle = localStyles.getDataCellStyle();
        final String defaultTextStyle = localStyles.getDataTextStyle();
        final String invalidatedOrDeletedTextStyle = this.constructDataTextStyle(context, standardParagraphStyle, "10pt", null, null, "solid", "single", null, null);
        final String invalidatedAllTextStyle = this.constructDataTextStyle(context, standardParagraphStyle, "10pt", null, null, "solid", "single", "#800000", null);
        final String objectPlannerInactiveTextStyle = this.constructDataTextStyle(context, standardParagraphStyle, "10pt", null, null, "solid", "single", "gray", null);
        List documentListRows = documentListData.getDocumentListRows();
        final Map documentIdToReviewStatusSvg = documentListData.getDocumentIdToReviewStatusSvg();
        final Map documentIdToReviewStatusToolTip = documentListData.getDocumentIdToReviewStatusToolTip();
        ArrayList columns = new ArrayList();
        List resultOptions = documentListData.getResultOptions();
        final Map idToResultOption = ContainerHelper.groupById(resultOptions);
        final ReviewCycleInfo cycleInfo = documentListData.getCycleInfo();
        columns.add(new FancyOdfTableColumn<DocumentListRow>("documentNumber", resourceBundle.getString("documentListNumberCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentListRow documentListRow) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                String documentNumber = documentListRow.getDocument().getNumber().toString();
                String textStyle = DocumentPagePdfExporter.this.getLineStyle(documentListRow, defaultTextStyle, invalidatedOrDeletedTextStyle, invalidatedAllTextStyle, objectPlannerInactiveTextStyle);
                TextFactory.constructTextNode((Node)cellElement, (String)documentNumber, (String)textStyle);
            }

            public int compare(DocumentListRow rowOne, DocumentListRow rowTwo, boolean descending) {
                Integer documentNumberOne = rowOne.getDocument().getNumber();
                Integer documentNumberTwo = rowTwo.getDocument().getNumber();
                return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)documentNumberOne.longValue(), (Long)documentNumberTwo.longValue(), (boolean)descending);
            }
        });
        columns.add(new FancyOdfTableColumn<DocumentListRow>("documentVersionName", resourceBundle.getString("documentListDocumentVersionNameCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentListRow documentListRow) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                String documentVersionName = this.getName(documentListRow);
                String textStyle = DocumentPagePdfExporter.this.getLineStyle(documentListRow, defaultTextStyle, invalidatedOrDeletedTextStyle, invalidatedAllTextStyle, objectPlannerInactiveTextStyle);
                TextFactory.constructTextNode((Node)cellElement, (String)documentVersionName, (String)textStyle);
                String alternativeName = documentListRow.getDocumentVersionAlternativeName();
                if (SearchHelper.isStringFilled(alternativeName)) {
                    TextFactory.constructTextNode((Node)cellElement, (String)alternativeName, (String)defaultTextStyle);
                }
            }

            private String getName(DocumentListRow row) {
                if (row.hasDocumentVersion()) {
                    return row.getDocumentVersionName();
                }
                if (row.getDocumentReleaseId() != null) {
                    return row.getDocumentReleaseName();
                }
                return row.getDocumentName();
            }

            public int compare(DocumentListRow rowOne, DocumentListRow rowTwo, boolean descending) {
                String documentVersionNameOne = this.getName(rowOne);
                String documentVersionNameTwo = this.getName(rowTwo);
                String alternativeNameOne = rowOne.getDocumentVersionAlternativeName();
                String alternativeNameTwo = rowTwo.getDocumentVersionAlternativeName();
                String s1 = documentVersionNameOne + (alternativeNameOne != null ? alternativeNameOne : "");
                String s2 = documentVersionNameTwo + (alternativeNameTwo != null ? alternativeNameTwo : "");
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }
        });
        columns.add(new FancyOdfTableColumn<DocumentListRow>("documentContent", resourceBundle.getString("documentListDocumentContentCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentListRow documentListRow) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                String textStyle = DocumentPagePdfExporter.this.getLineStyle(documentListRow, defaultTextStyle, invalidatedOrDeletedTextStyle, invalidatedAllTextStyle, objectPlannerInactiveTextStyle);
                String documentContentRaw = this.getOutput(documentListRow);
                if (contentLocales != null && contentLocales.size() == 2) {
                    Map<String, String> localeToTranslation = I18nHelper.parseI18nJsonString(documentContentRaw, projectLocale);
                    for (String contentLocale : contentLocales) {
                        String translation;
                        if (!localeToTranslation.containsKey(contentLocale) || (translation = localeToTranslation.get(contentLocale)) == null) continue;
                        TextFactory.constructTextNode((Node)cellElement, (String)translation, (String)textStyle);
                    }
                } else {
                    TextFactory.constructTextNode((Node)cellElement, (String)documentContentRaw, (String)textStyle);
                }
            }

            public int compare(DocumentListRow rowOne, DocumentListRow rowTwo, boolean descending) {
                String s1 = this.getOutput(rowOne);
                String s2 = this.getOutput(rowTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(DocumentListRow row) {
                if (row.getDocumentReleaseId() != null) {
                    return row.getDocumentReleaseContent();
                }
                return row.getDocumentContent();
            }
        });
        columns.add(new FancyOdfTableColumn<DocumentListRow>("objectPlanner", resourceBundle.getString("documentListObjectPlannerCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentListRow documentListRow) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                String output = this.getOutput(documentListRow);
                String textStyle = DocumentPagePdfExporter.this.getLineStyle(documentListRow, defaultTextStyle, invalidatedOrDeletedTextStyle, invalidatedAllTextStyle, objectPlannerInactiveTextStyle);
                TextFactory.constructTextNode((Node)cellElement, (String)output, (String)textStyle);
            }

            public int compare(DocumentListRow rowOne, DocumentListRow rowTwo, boolean descending) {
                String s1 = this.getOutput(rowOne);
                String s2 = this.getOutput(rowTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(DocumentListRow documentListRow) {
                String objectReleasedCode = documentListRow.getObjectReleaseCode() + (documentListRow.getObjectReleaseObjectTypeCode() != null ? documentListRow.getObjectReleaseObjectTypeCode() : "");
                String objectPlannerReleasedCode = documentListRow.getObjectPlannerReleaseCode();
                String reviewCycleInstanceName = documentListRow.getReviewCycleInstanceReleasedName();
                return (objectReleasedCode != null ? objectReleasedCode + " " : "") + (objectPlannerReleasedCode != null ? objectPlannerReleasedCode : "") + " [" + (reviewCycleInstanceName != null ? reviewCycleInstanceName : "") + "]";
            }
        });
        columns.add(new FancyOdfTableColumn<DocumentListRow>("uploadDate", resourceBundle.getString("documentListUploadDateCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentListRow documentListRow) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                String output = this.getOutput(documentListRow);
                String textStyle = DocumentPagePdfExporter.this.getLineStyle(documentListRow, defaultTextStyle, invalidatedOrDeletedTextStyle, invalidatedAllTextStyle, objectPlannerInactiveTextStyle);
                TextFactory.constructTextNode((Node)cellElement, (String)output, (String)textStyle);
            }

            public int compare(DocumentListRow rowOne, DocumentListRow rowTwo, boolean descending) {
                String s1 = this.getOutput(rowOne);
                String s2 = this.getOutput(rowTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(DocumentListRow documentListRow) {
                Double uploaded = documentListRow.getDocumentVersionUploaded();
                if (uploaded != null) {
                    return DateHelper.formatUtcSeconds(uploaded, "Europe/Vienna", resourceBundle.getString("yearToDayFormat"));
                }
                return "";
            }
        });
        columns.add(new FancyOdfTableColumn<DocumentListRow>("status", resourceBundle.getString("documentListStatusCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentListRow documentListRow) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                String textStyle = DocumentPagePdfExporter.this.getLineStyle(documentListRow, defaultTextStyle, invalidatedOrDeletedTextStyle, invalidatedAllTextStyle, objectPlannerInactiveTextStyle);
                DocumentVersionStatus documentVersionStatus = documentListRow.getDocumentVersionStatus();
                String documentVersionStatusString = documentListRow.getDocumentVersionId() != null ? CodeHelper.getI18nDocumentVersionStatus(resourceBundle, documentVersionStatus) : resourceBundle.getString("documentVersionStatusNotUploaded");
                TextFactory.constructTextNode((Node)cellElement, (String)documentVersionStatusString, (String)textStyle);
                Double effectiveEndDate = null;
                if (documentVersionStatus == DocumentVersionStatus.RELEASEDPOSITIV) {
                    if (!documentListRow.hasLatestPositionResult()) {
                        if (documentListRow.hasLatestNodeResult()) {
                            effectiveEndDate = documentListRow.getLatestNodeResultArrivalDate();
                        }
                    } else {
                        DocumentVersionStatus resultOptionStatus;
                        Long resultOptionId = documentListRow.getLatestPositionResultResultOptionId();
                        ReviewCycleResultOption resultOption = resultOptionId != null ? (ReviewCycleResultOption)idToResultOption.get(resultOptionId) : null;
                        DocumentVersionStatus documentVersionStatus2 = resultOptionStatus = resultOption != null ? DocumentVersionStatus.getByValue((Integer)resultOption.getDocumentVersionStatus()) : null;
                        if (resultOptionStatus == DocumentVersionStatus.RELEASEDPOSITIV) {
                            effectiveEndDate = documentListRow.getLatestPositionResultResultDate();
                        }
                    }
                }
                if (effectiveEndDate != null) {
                    String effectiveEndDateString = "[" + DateHelper.formatUtcSeconds(effectiveEndDate, "Europe/Vienna", resourceBundle.getString("yearToDayFormat")) + "]";
                    TextFactory.constructTextNode((Node)cellElement, (String)effectiveEndDateString, (String)textStyle);
                }
                if (documentListRow.getDocumentVersionId() != null && documentVersionStatus != DocumentVersionStatus.INVALIDATEDALL) {
                    Long nodeId = documentListRow.getLatestNodeResultNodeId();
                    boolean isEndNode = cycleInfo.isEndNode(nodeId);
                    ReviewCycleNode node = cycleInfo.getNodeById(nodeId);
                    Long cellId = node.getReviewCycleCellId();
                    ReviewCycleCell cell = cycleInfo.getCellById(cellId);
                    boolean endOfReviewCycle = cell.getIsEndCell() != null && cell.getIsEndCell() != false && isEndNode;
                    boolean inAction = CodeHelper.isDocumentVersionStatusInAction(documentVersionStatus);
                    if (!endOfReviewCycle || endOfReviewCycle && inAction || documentListRow.getDocumentVersionUploaded() == null && documentListRow.getDocumentReleaseId() != null && documentListRow.getDocumentReleaseStartDate() != null) {
                        String reviewCycleCellName = I18nHelper.getLocaleString(cell.getName(), personVariablesUserLocale);
                        String reviewCycleNodeName = I18nHelper.getLocaleString(node.getName(), personVariablesUserLocale);
                        String label = reviewCycleCellName + " - " + reviewCycleNodeName;
                        TextFactory.constructTextNode((Node)cellElement, (String)label, (String)textStyle);
                    }
                }
                if (documentListRow.getRevisedDocumentVersionStatus() == DocumentVersionStatus.RELEASEDPOSITIV && documentVersionStatus == DocumentVersionStatus.INREVIEW) {
                    TextFactory.constructTextNode((Node)cellElement, (String)resourceBundle.getString("documentListReleasedVersionStillValidLabel"), (String)textStyle);
                }
            }

            public int compare(DocumentListRow rowOne, DocumentListRow rowTwo, boolean descending) {
                String s1 = CodeHelper.getI18nDocumentVersionStatus(resourceBundle, rowOne.getDocumentVersionStatus());
                String s2 = CodeHelper.getI18nDocumentVersionStatus(resourceBundle, rowTwo.getDocumentVersionStatus());
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }
        });
        columns.add(new FancyOdfTableColumn<DocumentListRow>("reviewStatus", resourceBundle.getString("documentListReviewStatusCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentListRow documentListRow) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                String textStyle = DocumentPagePdfExporter.this.getLineStyle(documentListRow, defaultTextStyle, invalidatedOrDeletedTextStyle, invalidatedAllTextStyle, objectPlannerInactiveTextStyle);
                Long documentId = documentListRow.getDocumentId();
                String reviewStatusSvg = (String)documentIdToReviewStatusSvg.get(documentId);
                String reviewStatusToolTip = (String)documentIdToReviewStatusToolTip.get(documentId);
                String[] toolTipTokens = reviewStatusToolTip != null ? reviewStatusToolTip.split("<br>") : new String[]{};
                ArrayList<String> toolTipTokensSafe = new ArrayList<String>();
                for (String toolTipToken : toolTipTokens) {
                    toolTipTokensSafe.add(DocumentPagePdfExporter.this.utilService.getSafeHtml(toolTipToken, true));
                }
                if (reviewStatusSvg == null) {
                    return;
                }
                double desiredWidth = 3.0;
                double desiredHeight = 1.0;
                DecimalFormat dimensionFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
                dimensionFormat.applyPattern("###,###.###");
                String desiredWidthString = dimensionFormat.format(desiredWidth) + "cm";
                String desiredHeightString = dimensionFormat.format(desiredHeight) + "cm";
                Styles contentAutomaticStyles = context.getContentAutomaticStyles();
                Styles stylesStyles = context.getStylesOfficeStyles();
                String frameContentsStyle = stylesStyles.getParagraphStyleWithParent(stylesStyles.getParagraphStyleWithClass("text", new OdfStylePropertiesBase[0]), "extra", new OdfStylePropertiesBase[0]);
                TextPElement imagePElement = TextFactory.constructTextNode((Node)cellElement, null, (String)frameContentsStyle);
                String parentStyle = stylesStyles.getGraphicStyle(new OdfStylePropertiesBase[]{FrameFactory.constructImageFrameParentProperties((Styles)stylesStyles)});
                StyleGraphicPropertiesElement graphicProperties = FrameFactory.constructImageFrameProperties((Styles)contentAutomaticStyles);
                String imageFrameStyle = contentAutomaticStyles.getGraphicStyleWithParent(parentStyle, new OdfStylePropertiesBase[]{graphicProperties});
                DrawFrameElement drawFrameElement = (DrawFrameElement)((OdfFileDom)imagePElement.getOwnerDocument()).newOdfElement(DrawFrameElement.class);
                drawFrameElement.setStyleName(imageFrameStyle);
                drawFrameElement.setTextAnchorTypeAttribute("as-char");
                drawFrameElement.setSvgWidthAttribute(desiredWidthString);
                drawFrameElement.setSvgHeightAttribute(desiredHeightString);
                drawFrameElement.setDrawZIndexAttribute(Integer.valueOf(0));
                DrawFrameElement svgInnerFrame = FrameFactory.constructDrawFrameNode((Node)imagePElement, (String)imageFrameStyle, (String)"as-char", null, null, (String)desiredWidthString, (String)desiredHeightString, (Integer)0);
                for (String tooltipTokenSafe : toolTipTokensSafe) {
                    TextFactory.constructTextNode((Node)cellElement, (String)tooltipTokenSafe, (String)textStyle);
                }
                try {
                    OdfDrawImage image = (OdfDrawImage)svgInnerFrame.newDrawImageElement();
                    image.setXlinkShowAttribute("embed");
                    image.setXlinkActuateAttribute("onLoad");
                    OfficeBinaryDataElement officeBinaryDataElement = image.newOfficeBinaryDataElement();
                    String base64Svg = Base64.encodeBase64String((byte[])reviewStatusSvg.getBytes());
                    officeBinaryDataElement.setTextContent(base64Svg);
                    image.appendChild((Node)officeBinaryDataElement);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public int compare(DocumentListRow rowOne, DocumentListRow rowTwo, boolean descending) {
                return 0;
            }
        });
        HashMap<String, Double> relativeColumnWidths = new HashMap<String, Double>();
        relativeColumnWidths.put("documentNumber", 0.025);
        relativeColumnWidths.put("documentVersionName", 0.17);
        relativeColumnWidths.put("documentContent", 0.28);
        relativeColumnWidths.put("objectPlanner", 0.2);
        relativeColumnWidths.put("uploadDate", 0.1);
        relativeColumnWidths.put("status", 0.25);
        relativeColumnWidths.put("reviewStatus", 0.15);
        List<ColumnSortSpec> adjustedSortSpecs = new ArrayList<ColumnSortSpec>();
        if (columnSortSpecs == null || columnSortSpecs.isEmpty()) {
            adjustedSortSpecs.add(new ColumnSortSpec("uploadDate", Boolean.valueOf(true)));
        } else {
            adjustedSortSpecs = columnSortSpecs;
        }
        Styles styles = context.getContentAutomaticStyles();
        FancyOdfTable table = DocumentPagePdfExporter.constructFancyTable(styles, localStyles, 23.9, columns, relativeColumnWidths);
        table.setTableStyle(tableUnderCaptionStyle);
        table.setRenderHeaderLine(true);
        table.render((Node)officeText, documentListRows, adjustedSortSpecs);
    }

    private static <T> FancyOdfTable<T> constructFancyTable(Styles styles, DocumentPageLocalStyles localStyles, Double width, List<FancyOdfTableColumn<T>> columns, Map<String, Double> relativeColumnWidths) {
        String headerCellStyle = localStyles.getHeaderCellStyle();
        String headerTextStyle = localStyles.getHeaderTextStyle();
        String dataCellStyle = localStyles.getDataCellStyle();
        String dataTextStyle = localStyles.getDataTextStyle();
        String dataRowStyle = localStyles.getDataRowStyle();
        FancyOdfTable table = new FancyOdfTable(styles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, width, relativeColumnWidths, columns);
        table.setDataRowStyle(dataRowStyle);
        return table;
    }

    private String getLineStyle(DocumentListRow documentListRow, String defaultStyle, String deletedOrInvalidatedStyle, String invalidatedAllStyle, String inactiveObjectPlannerStyle) {
        if (documentListRow.isObjectPlannerInactive()) {
            return inactiveObjectPlannerStyle;
        }
        if (documentListRow.hasDocumentVersion()) {
            DocumentVersionStatus documentVersionStatus = documentListRow.getDocumentVersionStatus();
            if (documentVersionStatus == DocumentVersionStatus.INVALIDATEDVERSION || documentVersionStatus == DocumentVersionStatus.DELETED) {
                return deletedOrInvalidatedStyle;
            }
            if (documentVersionStatus == DocumentVersionStatus.INVALIDATEDALL) {
                return invalidatedAllStyle;
            }
            return defaultStyle;
        }
        return defaultStyle;
    }

    private DocumentPageLocalStyles constructLocalStyles(OdfContext context) {
        Styles officeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        DocumentPageLocalStyles localStyles = new DocumentPageLocalStyles();
        String standardParagraphStyle = this.constructStandardParagraphStyle(officeStyles);
        localStyles.setStandardParagraphStyle(standardParagraphStyle);
        String spanBoldTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorAndFont(null, "Arial", "10pt", "bold")});
        localStyles.setSpanBoldTextStyle(spanBoldTextStyle);
        String spanDefaultTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorAndFont(null, "Arial", "10pt", null)});
        localStyles.setSpanDefaultTextStyle(spanDefaultTextStyle);
        StyleTableCellPropertiesElement headerCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#666666", "0.079cm", "none");
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{headerCellProperties});
        localStyles.setHeaderCellStyle(headerCellStyle);
        StyleTextPropertiesElement headerTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorAndFont("#ffffff", "Arial", "10pt", "bold");
        headerTextProperties.setFoHyphenateAttribute(Boolean.valueOf(true));
        headerTextProperties.setFoHyphenationRemainCharCountAttribute(Integer.valueOf(2));
        headerTextProperties.setFoHyphenationPushCharCountAttribute(Integer.valueOf(2));
        String headerTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{headerTextProperties});
        localStyles.setHeaderTextStyle(headerTextStyle);
        StyleTableRowPropertiesElement dataRowProperties = contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "auto");
        String dataRowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{dataRowProperties});
        localStyles.setDataRowStyle(dataRowStyle);
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellProperties();
        dataCellProperties.setFoBackgroundColorAttribute("#e6e6e6");
        dataCellProperties.setFoBorderLeftAttribute("0.5pt solid #ffffff");
        dataCellProperties.setFoBorderRightAttribute("0.5pt solid #ffffff");
        dataCellProperties.setFoBorderTopAttribute("none");
        dataCellProperties.setFoBorderBottomAttribute("0.5pt solid #ffffff");
        dataCellProperties.setFoPaddingAttribute("0.079cm");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties});
        localStyles.setDataCellStyle(dataCellStyle);
        String dataTextStyle = this.constructDataTextStyle(context, standardParagraphStyle, "10pt", null, null);
        localStyles.setDataTextStyle(dataTextStyle);
        String dataTextStyleBold = this.constructDataTextStyle(context, standardParagraphStyle, "10pt", "bold", null);
        localStyles.setDataTextStyleBold(dataTextStyleBold);
        StyleTextPropertiesElement spanTextStyleSmallProperties = contentAutomaticStyles.constructTextPropertiesWithColorAndFont(null, "Arial", "7pt", null);
        String spanTextStyleSmall = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{spanTextStyleSmallProperties});
        localStyles.setSpanTextStyleSmall(spanTextStyleSmall);
        StyleTextPropertiesElement spanTextStyleSmallBoldProperties = contentAutomaticStyles.constructTextPropertiesWithColorAndFont(null, "Arial", "7pt", "bold");
        String spanTextStyleSmallBold = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{spanTextStyleSmallBoldProperties});
        localStyles.setSpanTextStyleSmallBold(spanTextStyleSmallBold);
        return localStyles;
    }

    public String constructStandardParagraphStyle(Styles context) {
        return context.getParagraphStyle(null, "text", new OdfStylePropertiesBase[]{DocumentPagePdfExporter.constructStandardParagraphProperties(context), DocumentPagePdfExporter.constructStandardTextProperties(context)});
    }

    private StyleTableCellPropertiesElement constructDefaultCellProperties(Styles contentAutomaticStyles) {
        return this.constructDefaultCellProperties(contentAutomaticStyles, null, null);
    }

    private StyleTableCellPropertiesElement constructDefaultCellProperties(Styles contentAutomaticStyles, String backgroundColor, String borderStyle) {
        StyleTableCellPropertiesElement labelProperties = contentAutomaticStyles.constructTableCellProperties();
        if (backgroundColor != null) {
            labelProperties.setFoBackgroundColorAttribute(backgroundColor);
        }
        labelProperties.setFoPaddingLeftAttribute("0.2cm");
        labelProperties.setFoPaddingRightAttribute("0.2cm");
        labelProperties.setFoPaddingTopAttribute("0.1cm");
        labelProperties.setFoPaddingBottomAttribute("0.1cm");
        if (borderStyle != null) {
            labelProperties.setFoBorderLeftAttribute(borderStyle);
            labelProperties.setFoBorderRightAttribute(borderStyle);
            labelProperties.setFoBorderTopAttribute(borderStyle);
            labelProperties.setFoBorderBottomAttribute(borderStyle);
        }
        return labelProperties;
    }

    public static StyleParagraphPropertiesElement constructStandardParagraphProperties(Styles context) {
        StyleParagraphPropertiesElement paragraphProperties = context.constructParagraphProperties();
        paragraphProperties.setStyleLineHeightAtLeastAttribute("0.423cm");
        paragraphProperties.setFoTextAlignAttribute("start");
        paragraphProperties.setStyleJustifySingleWordAttribute(Boolean.valueOf(false));
        paragraphProperties.setFoOrphansAttribute(Integer.valueOf(2));
        paragraphProperties.setFoWidowsAttribute(Integer.valueOf(2));
        paragraphProperties.setStyleWritingModeAttribute("lr-tb");
        return paragraphProperties;
    }

    public static StyleTextPropertiesElement constructStandardTextProperties(Styles context) {
        StyleTextPropertiesElement textProperties = context.constructTextProperties();
        textProperties.setFoColorAttribute("#00000a");
        textProperties.setStyleUseWindowFontColorAttribute(Boolean.valueOf(true));
        textProperties.setStyleFontNameAttribute("Arial");
        textProperties.setFoFontFamilyAttribute("Arial");
        textProperties.setStyleFontFamilyGenericAttribute("roman");
        textProperties.setStyleFontPitchAttribute("variable");
        textProperties.setFoFontSizeAttribute("10pt");
        textProperties.setFoLanguageAttribute("de");
        textProperties.setFoCountryAttribute("DE");
        textProperties.setFoHyphenateAttribute(Boolean.valueOf(false));
        textProperties.setFoHyphenationRemainCharCountAttribute(Integer.valueOf(2));
        textProperties.setFoHyphenationPushCharCountAttribute(Integer.valueOf(2));
        return textProperties;
    }

    private String constructDataTextStyle(OdfContext context, String parentStyle, String fontSize, String fontWeight, String textAlign) {
        return this.constructDataTextStyle(context, parentStyle, fontSize, fontWeight, textAlign, null, null, null);
    }

    private String constructDataTextStyle(OdfContext context, String parentStyle, String fontSize, String fontWeight, String textAlign, String lineThroughStyle, String lineThroughType, String color) {
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorAndFont("#000000", "Arial", fontSize, fontWeight);
        dataTextProperties.setFoHyphenateAttribute(Boolean.valueOf(true));
        dataTextProperties.setFoHyphenationRemainCharCountAttribute(Integer.valueOf(2));
        dataTextProperties.setFoHyphenationPushCharCountAttribute(Integer.valueOf(2));
        if (lineThroughStyle != null) {
            dataTextProperties.setStyleTextLineThroughStyleAttribute(lineThroughStyle);
        }
        if (lineThroughType != null) {
            dataTextProperties.setStyleTextLineThroughTypeAttribute(lineThroughType);
        }
        if (color != null) {
            dataTextProperties.setFoColorAttribute(color);
        }
        if (textAlign == null) {
            return contentAutomaticStyles.getParagraphStyleWithParent(parentStyle, new OdfStylePropertiesBase[]{dataTextProperties});
        }
        StyleParagraphPropertiesElement paragraphProperties = contentAutomaticStyles.constructParagraphPropertiesWithTextAlign(textAlign, null);
        return contentAutomaticStyles.getParagraphStyleWithParent(parentStyle, new OdfStylePropertiesBase[]{dataTextProperties, paragraphProperties});
    }

    private String constructDataTextStyle(OdfContext context, String parentStyle, String fontSize, String fontWeight, String textAlign, String lineThroughStyle, String lineThroughType, String color, String keepWithNext) {
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorAndFont("#000000", "Arial", fontSize, fontWeight);
        dataTextProperties.setFoHyphenateAttribute(Boolean.valueOf(true));
        dataTextProperties.setFoHyphenationRemainCharCountAttribute(Integer.valueOf(2));
        dataTextProperties.setFoHyphenationPushCharCountAttribute(Integer.valueOf(2));
        if (lineThroughStyle != null) {
            dataTextProperties.setStyleTextLineThroughStyleAttribute(lineThroughStyle);
        }
        if (lineThroughType != null) {
            dataTextProperties.setStyleTextLineThroughTypeAttribute(lineThroughType);
        }
        if (color != null) {
            dataTextProperties.setFoColorAttribute(color);
        }
        StyleParagraphPropertiesElement paragraphProperties = contentAutomaticStyles.constructParagraphPropertiesWithTextAlign(textAlign, null);
        if (keepWithNext != null) {
            paragraphProperties.setFoKeepWithNextAttribute(keepWithNext);
        }
        return contentAutomaticStyles.getParagraphStyleWithParent(parentStyle, new OdfStylePropertiesBase[]{dataTextProperties, paragraphProperties});
    }

    private List<ColumnSortSpec> translateSortColumns(List<ColumnSortSpec> columnSortSpecs) {
        ArrayList<ColumnSortSpec> newColumnSortSpecs = new ArrayList<ColumnSortSpec>();
        for (ColumnSortSpec columnSortSpec : columnSortSpecs) {
            String property = columnSortSpec.getProperty();
            Boolean descending = columnSortSpec.getDescending();
            if ("_documentNumber".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("documentNumber", descending));
                continue;
            }
            if ("_documentVersionName".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("documentVersionName", descending));
                continue;
            }
            if ("_documentContent".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("documentContent", descending));
                continue;
            }
            if ("documentNumber".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("documentNumber", descending));
                continue;
            }
            if ("_objectPlanner".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("objectPlanner", descending));
                continue;
            }
            if ("documentVersionUploaded".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("uploadDate", descending));
                continue;
            }
            if ("status".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("status", descending));
                continue;
            }
            log.warn("Unknown column [" + property + "] delivered from client.");
        }
        return newColumnSortSpecs;
    }

    private static class DocumentPageLocalStyles {
        private String standardParagraphStyle;
        private String spanBoldTextStyle;
        private String spanDefaultTextStyle;
        private String spanTextStyleSmall;
        private String spanTextStyleSmallBold;
        private String headerCellStyle;
        private String headerTextStyle;
        private String dataRowStyle;
        private String dataCellStyle;
        private String dataTextStyle;
        private String dataTextStyleBold;
        private String dataTextStyleSmall;
        private String dataTextStyleSmallBold;

        private DocumentPageLocalStyles() {
        }

        public String getStandardParagraphStyle() {
            return this.standardParagraphStyle;
        }

        public void setStandardParagraphStyle(String standardParagraphStyle) {
            this.standardParagraphStyle = standardParagraphStyle;
        }

        public String getSpanBoldTextStyle() {
            return this.spanBoldTextStyle;
        }

        public void setSpanBoldTextStyle(String spanBoldTextStyle) {
            this.spanBoldTextStyle = spanBoldTextStyle;
        }

        public String getSpanDefaultTextStyle() {
            return this.spanDefaultTextStyle;
        }

        public void setSpanDefaultTextStyle(String spanDefaultTextStyle) {
            this.spanDefaultTextStyle = spanDefaultTextStyle;
        }

        public String getSpanTextStyleSmall() {
            return this.spanTextStyleSmall;
        }

        public void setSpanTextStyleSmall(String spanTextStyleSmall) {
            this.spanTextStyleSmall = spanTextStyleSmall;
        }

        public String getSpanTextStyleSmallBold() {
            return this.spanTextStyleSmallBold;
        }

        public void setSpanTextStyleSmallBold(String spanTextStyleSmallBold) {
            this.spanTextStyleSmallBold = spanTextStyleSmallBold;
        }

        public String getHeaderCellStyle() {
            return this.headerCellStyle;
        }

        public void setHeaderCellStyle(String headerCellStyle) {
            this.headerCellStyle = headerCellStyle;
        }

        public String getHeaderTextStyle() {
            return this.headerTextStyle;
        }

        public void setHeaderTextStyle(String headerTextStyle) {
            this.headerTextStyle = headerTextStyle;
        }

        public String getDataRowStyle() {
            return this.dataRowStyle;
        }

        public void setDataRowStyle(String dataRowStyle) {
            this.dataRowStyle = dataRowStyle;
        }

        public String getDataTextStyleSmall() {
            return this.dataTextStyleSmall;
        }

        public void setDataTextStyleSmall(String dataTextStyleSmall) {
            this.dataTextStyleSmall = dataTextStyleSmall;
        }

        public String getDataTextStyleSmallBold() {
            return this.dataTextStyleSmallBold;
        }

        public void setDataTextStyleSmallBold(String dataTextStyleSmallBold) {
            this.dataTextStyleSmallBold = dataTextStyleSmallBold;
        }

        public String getDataCellStyle() {
            return this.dataCellStyle;
        }

        public void setDataCellStyle(String dataCellStyle) {
            this.dataCellStyle = dataCellStyle;
        }

        public String getDataTextStyle() {
            return this.dataTextStyle;
        }

        public void setDataTextStyle(String dataTextStyle) {
            this.dataTextStyle = dataTextStyle;
        }

        public String getDataTextStyleBold() {
            return this.dataTextStyleBold;
        }

        public void setDataTextStyleBold(String dataTextStyleBold) {
            this.dataTextStyleBold = dataTextStyleBold;
        }
    }
}

