/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Network;
import at.cdes.api.dto.SupportContact;
import at.cdes.impl.dao.SupportContactDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcSupportContactDAO
extends AbstrIdDAO<SupportContact>
implements SupportContactDAO {
    public JdbcSupportContactDAO() {
        super(SupportContact.class, "id", "support_contact", new String[]{"id", "title", "email_address", "descr_text", "network_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcSupportContactDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "title") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "email_address") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "descr_text") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcSupportContactDAO.getSelectClauseForDto("support_contact", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcSupportContactDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".title" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "title") + "," + entityLocalName + ".email_address" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "email_address") + "," + entityLocalName + ".descr_text" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "descr_text") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + " ";
    }

    protected SupportContact fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        SupportContact supportContact = new SupportContact();
        supportContact.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        supportContact.setTitle(rs.getString(++columnIndex));
        supportContact.setEmailAddress(rs.getString(++columnIndex));
        supportContact.setDescrText(rs.getString(++columnIndex));
        supportContact.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return supportContact;
    }

    public static SupportContact fillSupportContactFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        SupportContact supportContact = new SupportContact();
        supportContact.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        supportContact.setTitle(rs.getString(columnIndex.incrementAndGet()));
        supportContact.setEmailAddress(rs.getString(columnIndex.incrementAndGet()));
        supportContact.setDescrText(rs.getString(columnIndex.incrementAndGet()));
        supportContact.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return supportContact;
    }

    public static SupportContact fillSupportContactFromResultSet(ResultSet rs) throws SQLException {
        return JdbcSupportContactDAO.fillSupportContactFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 5;
    }

    public int update(SupportContact dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<SupportContact> dtos) {
        Iterator<SupportContact> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, SupportContact supportContact) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)supportContact.getId());
        statement.setString(2, supportContact.getTitle());
        statement.setString(3, supportContact.getEmailAddress());
        statement.setString(4, supportContact.getDescrText());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)supportContact.getNetworkId());
    }

    @Override
    public List<SupportContact> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<SupportContact> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<SupportContact> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<SupportContact>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

