/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Object;
import at.cdes.api.dto.ObjectList;
import at.cdes.api.dto.ObjectType;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.joinDto.ObjectJoin;
import at.cdes.api.joinDto.ObjectShowInstanceJoin;
import at.cdes.api.joinDto.ObjectShowJoin;
import at.cdes.impl.dao.GenObjectDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcObjectDAO
extends AbstrIdDAO<Object>
implements GenObjectDAO {
    public AbstractJdbcObjectDAO() {
        super(Object.class, "id", "object", new String[]{"id", "object_list_id", "code", "name", "comment", "stretch_km_from", "stretch_km_to", "inactive_flag", "read_only", "modified", "modified_by_id", "hasChanged", "object_type_id", "as_built_reference"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcObjectDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "object_list_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "stretch_km_from") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "stretch_km_to") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "inactive_flag") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "read_only") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "modified") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "modified_by_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "hasChanged") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "object_type_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "as_built_reference") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcObjectDAO.getSelectClauseForDto("object", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcObjectDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".object_list_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "object_list_id") + "," + entityLocalName + ".code" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".comment" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + "," + entityLocalName + ".stretch_km_from" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "stretch_km_from") + "," + entityLocalName + ".stretch_km_to" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "stretch_km_to") + "," + entityLocalName + ".inactive_flag" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "inactive_flag") + "," + entityLocalName + ".read_only" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "read_only") + "," + entityLocalName + ".modified" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "modified") + "," + entityLocalName + ".modified_by_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "modified_by_id") + "," + entityLocalName + ".hasChanged" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "hasChanged") + "," + entityLocalName + ".object_type_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "object_type_id") + "," + entityLocalName + ".as_built_reference" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "as_built_reference") + " ";
    }

    protected Object fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        Object object = new Object();
        object.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        object.setObjectListId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        object.setCode(rs.getString(++columnIndex));
        object.setName(rs.getString(++columnIndex));
        object.setComment(rs.getString(++columnIndex));
        object.setStretchKmFrom(JDBCHelper.getDouble((ResultSet)rs, (int)(++columnIndex)));
        object.setStretchKmTo(JDBCHelper.getDouble((ResultSet)rs, (int)(++columnIndex)));
        object.setInactiveFlag(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        object.setReadOnly(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        object.setModifiedDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        object.setModifiedById(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        object.setHasChanged(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        object.setObjectTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        object.setAsBuiltReference(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return object;
    }

    public static Object fillObjectFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        Object object = new Object();
        object.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        object.setObjectListId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        object.setCode(rs.getString(columnIndex.incrementAndGet()));
        object.setName(rs.getString(columnIndex.incrementAndGet()));
        object.setComment(rs.getString(columnIndex.incrementAndGet()));
        object.setStretchKmFrom(JDBCHelper.getDouble((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        object.setStretchKmTo(JDBCHelper.getDouble((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        object.setInactiveFlag(JDBCHelper.getBoolean((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        object.setReadOnly(JDBCHelper.getBoolean((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        object.setModifiedDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        object.setModifiedById(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        object.setHasChanged(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        object.setObjectTypeId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        object.setAsBuiltReference(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return object;
    }

    public static Object fillObjectFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcObjectDAO.fillObjectFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 14;
    }

    public static ObjectJoin fillObjectJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ObjectJoin objectJoin = new ObjectJoin();
        objectJoin.setObjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectCode(rs.getString(++columnIndex));
        objectJoin.setObjectName(rs.getString(++columnIndex));
        objectJoin.setObjectComment(rs.getString(++columnIndex));
        objectJoin.setObjectAsBuiltReference(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectReadOnly(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectStretchKmFrom(JDBCHelper.getDouble((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectStretchKmTo(JDBCHelper.getDouble((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectInactiveFlag(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectHasChanged(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectListId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectListVersion(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectPlannerId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectPlannerCode(rs.getString(++columnIndex));
        objectJoin.setObjectPlannerArea(rs.getString(++columnIndex));
        objectJoin.setObjectPlannerAsBuiltReference(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectPlannerChanged(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectPlannerInactive(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectPlannerPlannerId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectPlannerDefinitionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectPlannerPositionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectPlannerPositionProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectPlannerPositionRoleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectPlannerPositionDefinitionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectPlannerPositionDefinitionName(rs.getString(++columnIndex));
        objectJoin.setObjectPlannerPositionDefinitionRoleTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectPlannerReleaseId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setObjectTypeCode(rs.getString(++columnIndex));
        objectJoin.setOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setOrganisationName(rs.getString(++columnIndex));
        objectJoin.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setPersonGivenName(rs.getString(++columnIndex));
        objectJoin.setPersonSurName(rs.getString(++columnIndex));
        objectJoin.setPlannerHasVersionsId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setReviewCycleCellInstanceId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setReviewCycleCellInstanceChanged(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setReviewCycleInstanceId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setReviewCycleInstanceChanged(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectJoin.setReviewCycleInstanceName(rs.getString(++columnIndex));
        return objectJoin;
    }

    public static int getNumberOfObjectJoinAttributes() {
        return 42;
    }

    public static ObjectShowJoin fillObjectShowJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ObjectShowJoin objectShowJoin = new ObjectShowJoin();
        objectShowJoin.setDocumentId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setDocumentName(rs.getString(++columnIndex));
        objectShowJoin.setDocumentContent(rs.getString(++columnIndex));
        objectShowJoin.setDocumentReleaseId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setDocumentReleaseName(rs.getString(++columnIndex));
        objectShowJoin.setDocumentReleaseContent(rs.getString(++columnIndex));
        objectShowJoin.setDocumentVersionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setDocumentVersionName(rs.getString(++columnIndex));
        objectShowJoin.setObjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setObjectListReleaseId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setObjectListReleaseVersion(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setObjectPlannerReleaseId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setObjectPlannerReleaseCode(rs.getString(++columnIndex));
        objectShowJoin.setObjectPlannerReleaseArea(rs.getString(++columnIndex));
        objectShowJoin.setObjectReleaseId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setObjectReleaseCode(rs.getString(++columnIndex));
        objectShowJoin.setObjectReleaseName(rs.getString(++columnIndex));
        objectShowJoin.setObjectReleaseStretchKmFrom(JDBCHelper.getDouble((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setObjectReleaseStretchKmTo(JDBCHelper.getDouble((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setObjectTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setObjectTypeCode(rs.getString(++columnIndex));
        objectShowJoin.setPlannerInstanceCycleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setPlannerInstanceCycleName(rs.getString(++columnIndex));
        objectShowJoin.setPlannerInstanceLabelId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setPlannerInstanceLabelName(rs.getString(++columnIndex));
        objectShowJoin.setPlannerInstanceReleasedId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setPlannerInstanceReleasedName(rs.getString(++columnIndex));
        objectShowJoin.setPlannerInstanceReleasedDescription(rs.getString(++columnIndex));
        objectShowJoin.setPlannerInstanceReleasedDuration(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setPlannerInstanceReleasedDurationPre(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setPlannerMainPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setPlannerMainPersonGivenName(rs.getString(++columnIndex));
        objectShowJoin.setPlannerMainPersonSurName(rs.getString(++columnIndex));
        objectShowJoin.setPlannerOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setPlannerOrganisationName(rs.getString(++columnIndex));
        objectShowJoin.setPlannerParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setPlannerParticipationComment(rs.getString(++columnIndex));
        objectShowJoin.setPlannerPositionDefinitionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setPlannerPositionDefinitionName(rs.getString(++columnIndex));
        objectShowJoin.setPlannerPositionMainPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setPlannerPositionMainPersonGivenName(rs.getString(++columnIndex));
        objectShowJoin.setPlannerPositionMainPersonSurName(rs.getString(++columnIndex));
        objectShowJoin.setPlannerPositionOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setPlannerPositionOrganisationName(rs.getString(++columnIndex));
        objectShowJoin.setPlannerPositionParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setPlannerPositionParticipationComment(rs.getString(++columnIndex));
        objectShowJoin.setPlannerPositionReleaseId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setProjectCode(rs.getString(++columnIndex));
        objectShowJoin.setProjectName(rs.getString(++columnIndex));
        objectShowJoin.setProjectComment(rs.getString(++columnIndex));
        objectShowJoin.setProjectRouteName(rs.getString(++columnIndex));
        objectShowJoin.setProjectStretchName(rs.getString(++columnIndex));
        objectShowJoin.setProjectStretchKmFrom(JDBCHelper.getDouble((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setProjectStretchKmTo(JDBCHelper.getDouble((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setSignatureId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setSignatureTime(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setSubProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowJoin.setSubProjectCode(rs.getString(++columnIndex));
        objectShowJoin.setSubProjectName(rs.getString(++columnIndex));
        objectShowJoin.setSubProjectNumber(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        return objectShowJoin;
    }

    public static int getNumberOfObjectShowJoinAttributes() {
        return 61;
    }

    public static ObjectShowInstanceJoin fillObjectShowInstanceJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ObjectShowInstanceJoin objectShowInstanceJoin = new ObjectShowInstanceJoin();
        objectShowInstanceJoin.setCdesRoleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setCdesRoleName(rs.getString(++columnIndex));
        objectShowInstanceJoin.setCdesRoleTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setEndPositionTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setObjectListReleaseId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setObjectListReleaseVersion(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setObjectPlannerReleaseId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setObjectReleaseId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setOrganisationName(rs.getString(++columnIndex));
        objectShowInstanceJoin.setPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setPersonGivenName(rs.getString(++columnIndex));
        objectShowInstanceJoin.setPersonSurName(rs.getString(++columnIndex));
        objectShowInstanceJoin.setPlotOrderTemplateId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setPlotOrderTemplateName(rs.getString(++columnIndex));
        objectShowInstanceJoin.setPlotOrderTemplateInvalidated(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setPlotOrderTemplatePlotterId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setProjectParticipationComment(rs.getString(++columnIndex));
        objectShowInstanceJoin.setReviewCycleCellId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleCellName(rs.getString(++columnIndex));
        objectShowInstanceJoin.setReviewCycleCellPosition(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleCellInstanceReleasedId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleInstanceReleasedId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleNodeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleNodeName(rs.getString(++columnIndex));
        objectShowInstanceJoin.setReviewCycleNodePosition(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleNodeReviewType(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleNodeRoleTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleNodeInstanceId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleNodeInstanceNotificationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleNodeInstancePlottOrderListenerId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleNodeInstanceReleasedId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleNodeInstanceReleasedDuration(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleNodeInstanceReleasedFree(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleNodeListenerId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleNodeListenerName(rs.getString(++columnIndex));
        objectShowInstanceJoin.setReviewCycleNodeListenerListenerName(rs.getString(++columnIndex));
        objectShowInstanceJoin.setReviewCycleNodeListenerPosition(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCycleNodeListenerIsPreListener(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCyclePositionTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectShowInstanceJoin.setReviewCyclePositionTypeName(rs.getString(++columnIndex));
        return objectShowInstanceJoin;
    }

    public static int getNumberOfObjectShowInstanceJoinAttributes() {
        return 42;
    }

    protected String getSelectClauseForObjectJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("object") ? result + "object.id, object.code, object.name, object.comment, object.as_built_reference, object.read_only, object.stretch_km_from, object.stretch_km_to, object.inactive_flag, object.hasChanged" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectList") ? result + "object_list.id, object_list.version" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectPlanner") ? result + "object_planner.id, object_planner.code, object_planner.area, object_planner.as_built_reference, object_planner.changed, object_planner.inactive, object_planner.planner_id, object_planner.definition_id" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectPlannerPosition") ? result + "object_planner_position.id, object_planner_position.project_participation_id, object_planner_position.role_id" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectPlannerPositionDefinition") ? result + "object_planner_position_definition.id, object_planner_position_definition.name, object_planner_position_definition.role_type_id" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectPlannerRelease") ? result + "object_planner_release.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectType") ? result + "object_type.id, object_type.code" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("organisation") ? result + "organisation.id, organisation.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("organisationPerson") ? result + "organisation_person.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("person") ? result + "person.id, person.givenName, person.surName" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("plannerHasVersions") ? result + "planner_has_versions.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("projectParticipation") ? result + "project_participation.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("reviewCycleCellInstance") ? result + "review_cycle_cell_instance.id, review_cycle_cell_instance.changed" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("reviewCycleInstance") ? result + "review_cycle_instance.id, review_cycle_instance.changed, review_cycle_instance.name" : result + "NULL, NULL, NULL";
        return result;
    }

    protected String getSelectClauseForObjectShowJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("document") ? result + "document.id, document.name, document.content" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("documentRelease") ? result + "document_release.id, document_release.name, document_release.content" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("documentVersion") ? result + "document_version.id, document_version.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("object") ? result + "object.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectListRelease") ? result + "object_list_release.id, object_list_release.version" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectPlannerRelease") ? result + "object_planner_release.id, object_planner_release.code, object_planner_release.area" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectRelease") ? result + "object_release.id, object_release.code, object_release.name, object_release.stretch_km_from, object_release.stretch_km_to" : result + "NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectType") ? result + "object_type.id, object_type.code" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("plannerInstanceCycle") ? result + "planner_instance_cycle.id, planner_instance_cycle.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("plannerInstanceLabel") ? result + "planner_instance_label.id, planner_instance_label.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("plannerInstanceReleased") ? result + "planner_instance_released.id, planner_instance_released.name, planner_instance_released.description, planner_instance_released.duration, planner_instance_released.duration_pre" : result + "NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("plannerMainPerson") ? result + "planner_main_person.id, planner_main_person.givenName, planner_main_person.surName" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("plannerOrganisation") ? result + "planner_organisation.id, planner_organisation.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("plannerParticipation") ? result + "planner_participation.id, planner_participation.comment" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("plannerPositionDefinition") ? result + "planner_position_definition.id, planner_position_definition.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("plannerPositionMainPerson") ? result + "planner_position_main_person.id, planner_position_main_person.givenName, planner_position_main_person.surName" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("plannerPositionOrganisation") ? result + "planner_position_organisation.id, planner_position_organisation.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("plannerPositionParticipation") ? result + "planner_position_participation.id, planner_position_participation.comment" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("plannerPositionRelease") ? result + "planner_position_release.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("project") ? result + "project.id, project.code, project.name, project.comment, project.route_name, project.stretch_name, project.stretch_km_from, project.stretch_km_to" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("signature") ? result + "signature.id, signature.time" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("subProject") ? result + "sub_project.id, sub_project.code, sub_project.name, sub_project.number" : result + "NULL, NULL, NULL, NULL";
        return result;
    }

    protected String getSelectClauseForObjectShowInstanceJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("cdesRole") ? result + "cdes_role.id, cdes_role.name, cdes_role.type_id" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("endPositionType") ? result + "end_position_type.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectListRelease") ? result + "object_list_release.id, object_list_release.version" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectPlannerRelease") ? result + "object_planner_release.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectRelease") ? result + "object_release.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("organisation") ? result + "organisation.id, organisation.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("person") ? result + "person.id, person.givenName, person.surName" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("plotOrderTemplate") ? result + "plot_order_template.id, plot_order_template.name, plot_order_template.invalidated, plot_order_template.plotter_id" : result + "NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("projectParticipation") ? result + "project_participation.id, project_participation.comment" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("reviewCycleCell") ? result + "review_cycle_cell.id, review_cycle_cell.name, review_cycle_cell.position" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("reviewCycleCellInstanceReleased") ? result + "review_cycle_cell_instance_released.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("reviewCycleInstanceReleased") ? result + "review_cycle_instance_released.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("reviewCycleNode") ? result + "review_cycle_node.id, review_cycle_node.name, review_cycle_node.position, review_cycle_node.review_type, review_cycle_node.role_type_id" : result + "NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("reviewCycleNodeInstance") ? result + "review_cycle_node_instance.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("reviewCycleNodeInstanceNotification") ? result + "review_cycle_node_instance_notification.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("reviewCycleNodeInstancePlottOrderListener") ? result + "review_cycle_node_instance_plott_order_listener.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("reviewCycleNodeInstanceReleased") ? result + "review_cycle_node_instance_released.id, review_cycle_node_instance_released.duration, review_cycle_node_instance_released.free" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("reviewCycleNodeListener") ? result + "review_cycle_node_listener.id, review_cycle_node_listener.name, review_cycle_node_listener.listenerName, review_cycle_node_listener.position, review_cycle_node_listener.is_pre_listener" : result + "NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("reviewCyclePositionType") ? result + "review_cycle_position_type.id, review_cycle_position_type.name" : result + "NULL, NULL";
        return result;
    }

    public int update(Object dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((java.lang.Object)dto);
    }

    public int[] updateBatch(Collection<Object> dtos) {
        Iterator<Object> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    public static String getObjectJoinSelectClause() {
        return "object.id, object.code, object.name, object.comment, object.as_built_reference, object.read_only, object.stretch_km_from, object.stretch_km_to, object.inactive_flag, object.hasChanged, object_list.id, object_list.version, object_planner.id, object_planner.code, object_planner.area, object_planner.as_built_reference, object_planner.changed, object_planner.inactive, object_planner.planner_id, object_planner.definition_id, object_planner_position.id, object_planner_position.project_participation_id, object_planner_position.role_id, object_planner_position_definition.id, object_planner_position_definition.name, object_planner_position_definition.role_type_id, object_planner_release.id, object_type.id, object_type.code, organisation.id, organisation.name, organisation_person.id, person.id, person.givenName, person.surName, planner_has_versions.id, project_participation.id, review_cycle_cell_instance.id, review_cycle_cell_instance.changed, review_cycle_instance.id, review_cycle_instance.changed, review_cycle_instance.name ";
    }

    public static String getPrefixedObjectJoinSelectClause() {
        return "object.id AS object_id, object.code AS object_code, object.name AS object_name, object.comment AS object_comment, object.as_built_reference AS object_as_built_reference, object.read_only AS object_read_only, object.stretch_km_from AS object_stretch_km_from, object.stretch_km_to AS object_stretch_km_to, object.inactive_flag AS object_inactive_flag, object.hasChanged AS object_hasChanged, object_list.id AS object_list_id, object_list.version AS object_list_version, object_planner.id AS object_planner_id, object_planner.code AS object_planner_code, object_planner.area AS object_planner_area, object_planner.as_built_reference AS object_planner_as_built_reference, object_planner.changed AS object_planner_changed, object_planner.inactive AS object_planner_inactive, object_planner.planner_id AS object_planner_planner_id, object_planner.definition_id AS object_planner_definition_id, object_planner_position.id AS object_planner_position_id, object_planner_position.project_participation_id AS object_planner_position_project_participation_id, object_planner_position.role_id AS object_planner_position_role_id, object_planner_position_definition.id AS object_planner_position_definition_id, object_planner_position_definition.name AS object_planner_position_definition_name, object_planner_position_definition.role_type_id AS object_planner_position_definition_role_type_id, object_planner_release.id AS object_planner_release_id, object_type.id AS object_type_id, object_type.code AS object_type_code, organisation.id AS organisation_id, organisation.name AS organisation_name, organisation_person.id AS organisation_person_id, person.id AS person_id, person.givenName AS person_givenName, person.surName AS person_surName, planner_has_versions.id AS planner_has_versions_id, project_participation.id AS project_participation_id, review_cycle_cell_instance.id AS review_cycle_cell_instance_id, review_cycle_cell_instance.changed AS review_cycle_cell_instance_changed, review_cycle_instance.id AS review_cycle_instance_id, review_cycle_instance.changed AS review_cycle_instance_changed, review_cycle_instance.name AS review_cycle_instance_name ";
    }

    public static String getObjectShowJoinSelectClause() {
        return "document.id, document.name, document.content, document_release.id, document_release.name, document_release.content, document_version.id, document_version.name, object.id, object_list_release.id, object_list_release.version, object_planner_release.id, object_planner_release.code, object_planner_release.area, object_release.id, object_release.code, object_release.name, object_release.stretch_km_from, object_release.stretch_km_to, object_type.id, object_type.code, planner_instance_cycle.id, planner_instance_cycle.name, planner_instance_label.id, planner_instance_label.name, planner_instance_released.id, planner_instance_released.name, planner_instance_released.description, planner_instance_released.duration, planner_instance_released.duration_pre, planner_main_person.id, planner_main_person.givenName, planner_main_person.surName, planner_organisation.id, planner_organisation.name, planner_participation.id, planner_participation.comment, planner_position_definition.id, planner_position_definition.name, planner_position_main_person.id, planner_position_main_person.givenName, planner_position_main_person.surName, planner_position_organisation.id, planner_position_organisation.name, planner_position_participation.id, planner_position_participation.comment, planner_position_release.id, project.id, project.code, project.name, project.comment, project.route_name, project.stretch_name, project.stretch_km_from, project.stretch_km_to, signature.id, signature.time, sub_project.id, sub_project.code, sub_project.name, sub_project.number ";
    }

    public static String getPrefixedObjectShowJoinSelectClause() {
        return "document.id AS document_id, document.name AS document_name, document.content AS document_content, document_release.id AS document_release_id, document_release.name AS document_release_name, document_release.content AS document_release_content, document_version.id AS document_version_id, document_version.name AS document_version_name, object.id AS object_id, object_list_release.id AS object_list_release_id, object_list_release.version AS object_list_release_version, object_planner_release.id AS object_planner_release_id, object_planner_release.code AS object_planner_release_code, object_planner_release.area AS object_planner_release_area, object_release.id AS object_release_id, object_release.code AS object_release_code, object_release.name AS object_release_name, object_release.stretch_km_from AS object_release_stretch_km_from, object_release.stretch_km_to AS object_release_stretch_km_to, object_type.id AS object_type_id, object_type.code AS object_type_code, planner_instance_cycle.id AS planner_instance_cycle_id, planner_instance_cycle.name AS planner_instance_cycle_name, planner_instance_label.id AS planner_instance_label_id, planner_instance_label.name AS planner_instance_label_name, planner_instance_released.id AS planner_instance_released_id, planner_instance_released.name AS planner_instance_released_name, planner_instance_released.description AS planner_instance_released_description, planner_instance_released.duration AS planner_instance_released_duration, planner_instance_released.duration_pre AS planner_instance_released_duration_pre, planner_main_person.id AS planner_main_person_id, planner_main_person.givenName AS planner_main_person_givenName, planner_main_person.surName AS planner_main_person_surName, planner_organisation.id AS planner_organisation_id, planner_organisation.name AS planner_organisation_name, planner_participation.id AS planner_participation_id, planner_participation.comment AS planner_participation_comment, planner_position_definition.id AS planner_position_definition_id, planner_position_definition.name AS planner_position_definition_name, planner_position_main_person.id AS planner_position_main_person_id, planner_position_main_person.givenName AS planner_position_main_person_givenName, planner_position_main_person.surName AS planner_position_main_person_surName, planner_position_organisation.id AS planner_position_organisation_id, planner_position_organisation.name AS planner_position_organisation_name, planner_position_participation.id AS planner_position_participation_id, planner_position_participation.comment AS planner_position_participation_comment, planner_position_release.id AS planner_position_release_id, project.id AS project_id, project.code AS project_code, project.name AS project_name, project.comment AS project_comment, project.route_name AS project_route_name, project.stretch_name AS project_stretch_name, project.stretch_km_from AS project_stretch_km_from, project.stretch_km_to AS project_stretch_km_to, signature.id AS signature_id, signature.time AS signature_time, sub_project.id AS sub_project_id, sub_project.code AS sub_project_code, sub_project.name AS sub_project_name, sub_project.number AS sub_project_number ";
    }

    public static String getObjectShowInstanceJoinSelectClause() {
        return "cdes_role.id, cdes_role.name, cdes_role.type_id, end_position_type.id, object_list_release.id, object_list_release.version, object_planner_release.id, object_release.id, organisation.id, organisation.name, person.id, person.givenName, person.surName, plot_order_template.id, plot_order_template.name, plot_order_template.invalidated, plot_order_template.plotter_id, project_participation.id, project_participation.comment, review_cycle_cell.id, review_cycle_cell.name, review_cycle_cell.position, review_cycle_cell_instance_released.id, review_cycle_instance_released.id, review_cycle_node.id, review_cycle_node.name, review_cycle_node.position, review_cycle_node.review_type, review_cycle_node.role_type_id, review_cycle_node_instance.id, review_cycle_node_instance_notification.id, review_cycle_node_instance_plott_order_listener.id, review_cycle_node_instance_released.id, review_cycle_node_instance_released.duration, review_cycle_node_instance_released.free, review_cycle_node_listener.id, review_cycle_node_listener.name, review_cycle_node_listener.listenerName, review_cycle_node_listener.position, review_cycle_node_listener.is_pre_listener, review_cycle_position_type.id, review_cycle_position_type.name ";
    }

    public static String getPrefixedObjectShowInstanceJoinSelectClause() {
        return "cdes_role.id AS cdes_role_id, cdes_role.name AS cdes_role_name, cdes_role.type_id AS cdes_role_type_id, end_position_type.id AS end_position_type_id, object_list_release.id AS object_list_release_id, object_list_release.version AS object_list_release_version, object_planner_release.id AS object_planner_release_id, object_release.id AS object_release_id, organisation.id AS organisation_id, organisation.name AS organisation_name, person.id AS person_id, person.givenName AS person_givenName, person.surName AS person_surName, plot_order_template.id AS plot_order_template_id, plot_order_template.name AS plot_order_template_name, plot_order_template.invalidated AS plot_order_template_invalidated, plot_order_template.plotter_id AS plot_order_template_plotter_id, project_participation.id AS project_participation_id, project_participation.comment AS project_participation_comment, review_cycle_cell.id AS review_cycle_cell_id, review_cycle_cell.name AS review_cycle_cell_name, review_cycle_cell.position AS review_cycle_cell_position, review_cycle_cell_instance_released.id AS review_cycle_cell_instance_released_id, review_cycle_instance_released.id AS review_cycle_instance_released_id, review_cycle_node.id AS review_cycle_node_id, review_cycle_node.name AS review_cycle_node_name, review_cycle_node.position AS review_cycle_node_position, review_cycle_node.review_type AS review_cycle_node_review_type, review_cycle_node.role_type_id AS review_cycle_node_role_type_id, review_cycle_node_instance.id AS review_cycle_node_instance_id, review_cycle_node_instance_notification.id AS review_cycle_node_instance_notification_id, review_cycle_node_instance_plott_order_listener.id AS review_cycle_node_instance_plott_order_listener_id, review_cycle_node_instance_released.id AS review_cycle_node_instance_released_id, review_cycle_node_instance_released.duration AS review_cycle_node_instance_released_duration, review_cycle_node_instance_released.free AS review_cycle_node_instance_released_free, review_cycle_node_listener.id AS review_cycle_node_listener_id, review_cycle_node_listener.name AS review_cycle_node_listener_name, review_cycle_node_listener.listenerName AS review_cycle_node_listener_listenerName, review_cycle_node_listener.position AS review_cycle_node_listener_position, review_cycle_node_listener.is_pre_listener AS review_cycle_node_listener_is_pre_listener, review_cycle_position_type.id AS review_cycle_position_type_id, review_cycle_position_type.name AS review_cycle_position_type_name ";
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, Object object) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)object.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)object.getObjectListId());
        statement.setString(3, object.getCode());
        statement.setString(4, object.getName());
        statement.setString(5, object.getComment());
        JDBCHelper.setDouble((PreparedStatement)statement, (int)6, (Number)object.getStretchKmFrom());
        JDBCHelper.setDouble((PreparedStatement)statement, (int)7, (Number)object.getStretchKmTo());
        JDBCHelper.setBoolean((PreparedStatement)statement, (int)8, (Boolean)object.getInactiveFlag());
        JDBCHelper.setBoolean((PreparedStatement)statement, (int)9, (Boolean)object.getReadOnly());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)10, (Double)object.getModifiedDate());
        JDBCHelper.setLong((PreparedStatement)statement, (int)11, (Number)object.getModifiedById());
        JDBCHelper.setInt((PreparedStatement)statement, (int)12, (Number)object.getHasChanged());
        JDBCHelper.setLong((PreparedStatement)statement, (int)13, (Number)object.getObjectTypeId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)14, (Number)object.getAsBuiltReference());
    }

    @Override
    public List<Object> getByObjectList(ObjectList objectList) {
        return this.getByObjectList(objectList.getId());
    }

    @Override
    public List<Object> getByObjectList(final Long objectListId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"object_list_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, objectListId);
            }
        });
    }

    @Override
    public List<Object> getByModifiedBy(OrganisationPerson organisationPerson) {
        return this.getByModifiedBy(organisationPerson.getId());
    }

    @Override
    public List<Object> getByModifiedBy(final Long organisationPersonId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"modified_by_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, organisationPersonId);
            }
        });
    }

    @Override
    public List<Object> getByObjectType(ObjectType objectType) {
        return this.getByObjectType(objectType.getId());
    }

    @Override
    public List<Object> getByObjectType(final Long objectTypeId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"object_type_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, objectTypeId);
            }
        });
    }

    @Override
    public List<Object> getByAsBuiltReference(Object object) {
        return this.getByAsBuiltReference(object.getId());
    }

    @Override
    public List<Object> getByAsBuiltReference(final Long objectId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"as_built_reference"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, objectId);
            }
        });
    }

    @Override
    public List<Object> getByObjectLists(Collection<Long> objectListId) {
        if (objectListId.isEmpty()) {
            return new ArrayList<Object>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[objectListId.size()];
        int n = 0;
        Iterator<Long> it = objectListId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"object_list_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Object> getByModifiedBys(Collection<Long> organisationPersonId) {
        if (organisationPersonId.isEmpty()) {
            return new ArrayList<Object>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[organisationPersonId.size()];
        int n = 0;
        Iterator<Long> it = organisationPersonId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"modified_by_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Object> getByObjectTypes(Collection<Long> objectTypeId) {
        if (objectTypeId.isEmpty()) {
            return new ArrayList<Object>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[objectTypeId.size()];
        int n = 0;
        Iterator<Long> it = objectTypeId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"object_type_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Object> getByAsBuiltReferences(Collection<Long> objectId) {
        if (objectId.isEmpty()) {
            return new ArrayList<Object>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[objectId.size()];
        int n = 0;
        Iterator<Long> it = objectId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"as_built_reference"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

