/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Person;
import at.cdes.api.dto.PersonTraining;
import at.cdes.impl.dao.PersonTrainingDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcPersonTrainingDAO
extends AbstrIdDAO<PersonTraining>
implements PersonTrainingDAO {
    public JdbcPersonTrainingDAO() {
        super(PersonTraining.class, "id", "person_training", new String[]{"id", "date", "type", "comment", "person_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcPersonTrainingDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "date") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "type") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "person_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcPersonTrainingDAO.getSelectClauseForDto("person_training", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcPersonTrainingDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".date" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "date") + "," + entityLocalName + ".type" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "type") + "," + entityLocalName + ".comment" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + "," + entityLocalName + ".person_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "person_id") + " ";
    }

    protected PersonTraining fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        PersonTraining personTraining = new PersonTraining();
        personTraining.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        personTraining.setDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        personTraining.setType(rs.getString(++columnIndex));
        personTraining.setComment(rs.getString(++columnIndex));
        personTraining.setPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return personTraining;
    }

    public static PersonTraining fillPersonTrainingFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        PersonTraining personTraining = new PersonTraining();
        personTraining.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        personTraining.setDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        personTraining.setType(rs.getString(columnIndex.incrementAndGet()));
        personTraining.setComment(rs.getString(columnIndex.incrementAndGet()));
        personTraining.setPersonId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return personTraining;
    }

    public static PersonTraining fillPersonTrainingFromResultSet(ResultSet rs) throws SQLException {
        return JdbcPersonTrainingDAO.fillPersonTrainingFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 5;
    }

    public int update(PersonTraining dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<PersonTraining> dtos) {
        Iterator<PersonTraining> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, PersonTraining personTraining) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)personTraining.getId());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)2, (Double)personTraining.getDate());
        statement.setString(3, personTraining.getType());
        statement.setString(4, personTraining.getComment());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)personTraining.getPersonId());
    }

    @Override
    public List<PersonTraining> getByPerson(Person person) {
        return this.getByPerson(person.getId());
    }

    @Override
    public List<PersonTraining> getByPerson(final Long personId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"person_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, personId);
            }
        });
    }

    @Override
    public List<PersonTraining> getByPersons(Collection<Long> personId) {
        if (personId.isEmpty()) {
            return new ArrayList<PersonTraining>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[personId.size()];
        int n = 0;
        Iterator<Long> it = personId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"person_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

