/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.IReviewCycleNodePosition;
import at.cdes.api.dto.ReviewCycleNodePosition;
import at.cdes.api.joinDto.RoleConflictJoin;
import at.cdes.impl.dao.ReviewCycleNodePositionDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcReviewCycleNodePositionDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcReviewCycleNodePositionDAO
extends AbstractJdbcReviewCycleNodePositionDAO
implements ReviewCycleNodePositionDAO {
    @Override
    public List<IReviewCycleNodePosition> getByNodeInstanceAndDocumentVersion(Long reviewCycleNodeInstanceId, Long documentVersionId) {
        String sql = "SELECT " + JdbcReviewCycleNodePositionDAO.getSelectClauseForIReviewCycleNodePositionUsingReviewCycleNodePosition() + "\nFROM review_cycle_node_position\nWHERE review_cycle_node_position.review_cycle_node_instance_id = ?\nUNION ALL\nSELECT " + JdbcReviewCycleNodePositionDAO.getSelectClauseForIReviewCycleNodePositionUsingAttachedReviewCycleNodePosition() + "\nFROM attached_review_cycle_node_position\nWHERE attached_review_cycle_node_position.document_version_id = ?\nAND attached_review_cycle_node_position.review_cycle_node_instance_id = ?\n";
        return QueryHelper.getListWithSqlFiller((JdbcDAOSupport)this, sql, AbstractJdbcReviewCycleNodePositionDAO::fillIReviewCycleNodePositionFromResultSet, filler -> filler.addLong(reviewCycleNodeInstanceId).addLong(documentVersionId).addLong(reviewCycleNodeInstanceId));
    }

    @Override
    public List<IReviewCycleNodePosition> getByNodeInstanceReleasedAndDocumentVersion(Long reviewCycleNodeInstanceReleasedId, Long documentVersionId) {
        String sql = "SELECT " + JdbcReviewCycleNodePositionDAO.getSelectClauseForIReviewCycleNodePositionUsingReviewCycleNodePositionReleased() + "\nFROM review_cycle_node_position_released\nWHERE review_cycle_node_position_released.review_cycle_node_instance_id = ?\nUNION ALL\nSELECT " + JdbcReviewCycleNodePositionDAO.getSelectClauseForIReviewCycleNodePositionUsingAttachedReviewCycleNodePosition() + "\nFROM review_cycle_node_instance_released\nJOIN review_cycle_node_instance          ON review_cycle_node_instance_released.review_cycle_node_instance_id = review_cycle_node_instance.id\nJOIN attached_review_cycle_node_position ON attached_review_cycle_node_position.review_cycle_node_instance_id = review_cycle_node_instance.id\nWHERE attached_review_cycle_node_position.document_version_id = ?\nAND review_cycle_node_instance_released.id = ?";
        return QueryHelper.getListWithSqlFiller((JdbcDAOSupport)this, sql, AbstractJdbcReviewCycleNodePositionDAO::fillIReviewCycleNodePositionFromResultSet, filler -> filler.addLong(reviewCycleNodeInstanceReleasedId).addLong(documentVersionId).addLong(reviewCycleNodeInstanceReleasedId));
    }

    @Override
    public List<ReviewCycleNodePosition> getBySubProject(Long subProjectId) {
        String sql = "SELECT " + JdbcReviewCycleNodePositionDAO.getSelectClauseForDto() + "FROM review_cycle_instance JOIN review_cycle_cell_instance ON review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id JOIN review_cycle_node_instance ON review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id JOIN review_cycle_node_position ON review_cycle_node_position.review_cycle_node_instance_id = review_cycle_node_instance.id WHERE review_cycle_instance.sub_project_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)subProjectId));
    }

    @Override
    public List<RoleConflictJoin> getRoleConflictJoins(List<Long> participationIds, Long projectId) {
        String sql = "SELECT " + JdbcReviewCycleNodePositionDAO.getRoleConflictJoinSelectClause() + "FROM review_cycle_node_position JOIN project_participation       ON     review_cycle_node_position.project_participation_id = project_participation.id AND project_participation.invalidated = 0 JOIN project_participant         ON     project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag = 0 JOIN organisation_person         ON project_participant.organisation_person_id = organisation_person.id AND organisation_person.retired_flag = 0 JOIN person                      ON organisation_person.person_id = person.id JOIN organisation                ON organisation_person.organisation_id = organisation.id JOIN review_cycle_node_instance  ON review_cycle_node_position.review_cycle_node_instance_id = review_cycle_node_instance.id JOIN review_cycle_cell_instance  ON review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id JOIN review_cycle_instance       ON review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id JOIN review_cycle_cell           ON review_cycle_cell_instance.review_cycle_cell_id = review_cycle_cell.id JOIN sub_project                 ON review_cycle_instance.sub_project_id = sub_project.id JOIN project                     ON sub_project.project_id = project.id LEFT JOIN realm                       ON review_cycle_node_position.realm_id = realm.id WHERE project_participation.id IN (" + QueryHelper.getPlaceHolderSequence(participationIds.size()) + ") AND project.id = ? ORDER BY organisation.name, person.surName, review_cycle_instance.name, review_cycle_cell.code, realm.code ASC ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcReviewCycleNodePositionDAO::fillRoleConflictJoinFromResultSet, statement -> {
            int currIndex = 1;
            for (Long participationId : participationIds) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)participationId);
            }
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
        });
    }

    @Override
    public List<ReviewCycleNodePosition> getByInstanceId(Long instanceId) {
        String sql = "SELECT " + JdbcReviewCycleNodePositionDAO.getSelectClauseForDto() + "FROM review_cycle_node_position JOIN review_cycle_node_instance       ON review_cycle_node_position.review_cycle_node_instance_id = review_cycle_node_instance.id JOIN review_cycle_cell_instance       ON review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id WHERE review_cycle_cell_instance.review_cycle_instance_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)instanceId);
        });
    }
}

