/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.planning;

import at.cdes.api.compositeDto.PlanningNotificationOrderReferenceInfo;
import at.cdes.api.dto.MetaTag;
import at.cdes.api.dto.PlanningNotificationAttachment;
import at.cdes.api.dto.PlanningNotificationDateMetaInformation;
import at.cdes.api.dto.PlanningNotificationTextMetaInformation;
import at.cdes.api.guiService.UtilService;
import at.cdes.api.joinDto.WorkflowActivityPositionResultJoin;
import at.cdes.api.joinDto.WorkflowNodeJoin;
import at.cdes.api.planning.compositeDto.PlanningNotificationReportInfo;
import at.cdes.api.voc.MetaTagType;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.util.CodeHelper;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.odf.OdfFromHtmlConverter;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.SimpleOdfStringColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.util.aop.ThreadLocalManager;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class PlanningExportHelper {
    private static final Logger log = LoggerFactory.getLogger(PlanningExportHelper.class);
    public static final String REPLACEMENT_URL_PREFIX = "attachment://nae0uic3Xu2uoD5x/";

    public static List<String> getMetaTagTokens(ResourceBundle resourceBundle, MetaTag metaTag, Map<Long, List<PlanningNotificationTextMetaInformation>> metaTagIdToTextMetaInformations, Map<Long, List<PlanningNotificationDateMetaInformation>> metaTagIdToDateMetaInformations) {
        ArrayList<String> tokens = new ArrayList<String>();
        Long metaTagId = metaTag.getId();
        if (metaTag.getTagFormat().intValue() == MetaTagType.TEXT.getValue()) {
            if (metaTagIdToTextMetaInformations.containsKey(metaTagId)) {
                List<PlanningNotificationTextMetaInformation> textMetaInformations = metaTagIdToTextMetaInformations.get(metaTagId);
                Collections.sort(textMetaInformations, new Comparator<PlanningNotificationTextMetaInformation>(){

                    @Override
                    public int compare(PlanningNotificationTextMetaInformation referenceInfoOne, PlanningNotificationTextMetaInformation referenceInfoTwo) {
                        return referenceInfoOne.getValue().compareTo(referenceInfoTwo.getValue());
                    }
                });
                for (PlanningNotificationTextMetaInformation textMetaInformation : textMetaInformations) {
                    tokens.add(textMetaInformation.getValue());
                }
            }
        } else if (metaTag.getTagFormat().intValue() == MetaTagType.DATE.getValue()) {
            if (metaTagIdToDateMetaInformations.containsKey(metaTagId)) {
                List<PlanningNotificationDateMetaInformation> dateMetaInformations = metaTagIdToDateMetaInformations.get(metaTagId);
                for (PlanningNotificationDateMetaInformation dateMetaInformation : dateMetaInformations) {
                    Double utcSeconds = dateMetaInformation.getValue();
                    String dateFormatPattern = resourceBundle.getString("yearToDayFormat");
                    String dateString = utcSeconds != null ? DateHelper.formatUtcSeconds(utcSeconds, "Europe/Vienna", dateFormatPattern) : resourceBundle.getString("nothing");
                    tokens.add(dateString);
                }
            }
        } else {
            log.warn("Unknown metaTag.tagFormat [" + metaTag.getTagFormat() + "]");
        }
        return tokens;
    }

    public static void appendWorkflowNodeCell(TableTableRowElement rowElement, ResourceBundle resourceBundle, List<WorkflowNodeJoin> workflowNodeJoins, Map<Long, List<WorkflowNodeJoin>> workflowNodeIdToPositions, Map<Long, List<PlanningNotificationTextMetaInformation>> workflowNodePositionIdToBaulose, String dataCellStyle, String dataTextStyle, String dataItalicTextStyle, String dataRedTextStyle, String dataCaptionTextStyle) {
        String dateFormatPattern = resourceBundle.getString("yearToDayFormat");
        TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
        for (int n = 0; workflowNodeJoins != null && n < workflowNodeJoins.size(); ++n) {
            WorkflowNodeJoin workflowNodeJoin = workflowNodeJoins.get(n);
            String captionTextStyle = workflowNodeJoin.getWorkflowEntityInvalidated() != null && workflowNodeJoin.getWorkflowEntityInvalidated() != false ? dataTextStyle : dataCaptionTextStyle;
            TextFactory.constructTextNode((Node)cellElement, (String)workflowNodeJoin.getWorkflowNodeTemplateName(), (String)dataCaptionTextStyle);
            List<WorkflowNodeJoin> workflowNodePositionJoins = workflowNodeIdToPositions.get(workflowNodeJoin.getWorkflowNodeId());
            if (workflowNodePositionJoins == null || workflowNodePositionJoins.size() == 0) {
                TextFactory.constructTextNode((Node)cellElement, (String)resourceBundle.getString("planningNotificationOrderListNoPersonsInWorkflow"), (String)dataItalicTextStyle);
                continue;
            }
            for (int z = 0; z < workflowNodePositionJoins.size(); ++z) {
                WorkflowNodeJoin workflowNodePositionJoin = workflowNodePositionJoins.get(z);
                Long workflowNodePositionId = workflowNodePositionJoin.getWorkflowNodePositionId();
                String inverseCommonName = PersonHelper.getInverseCommonName(workflowNodePositionJoin.getPerson());
                Double dueDate = workflowNodePositionJoin.getWorkflowNodePositionDueDate();
                String dueDateRemark = CodeHelper.getI18nDueDateRemark(resourceBundle, workflowNodePositionJoin.getWorkflowNodePositionDueDateRemark());
                Double optionalDueDate = workflowNodePositionJoin.getWorkflowNodePositionOptionalDueDate();
                String dueDateString = dueDate != null ? DateHelper.formatUtcSeconds(dueDate, "Europe/Vienna", dateFormatPattern) : resourceBundle.getString("nothing");
                String optionalDueDateString = optionalDueDate != null ? DateHelper.formatUtcSeconds(optionalDueDate, "Europe/Vienna", dateFormatPattern) : resourceBundle.getString("nothing");
                List<PlanningNotificationTextMetaInformation> baulose = workflowNodePositionIdToBaulose.get(workflowNodePositionId);
                if (baulose == null || baulose.size() == 0) {
                    if (optionalDueDate == null) {
                        TextFactory.constructTextNode((Node)cellElement, (String)(inverseCommonName + " " + (dueDate != null ? dueDateString : (dueDateRemark != null ? dueDateRemark : ""))), (String)dataTextStyle);
                        continue;
                    }
                    TextPElement textPElement = (TextPElement)((OdfFileDom)cellElement.getOwnerDocument()).newOdfElement(TextPElement.class);
                    textPElement.setTextStyleNameAttribute(dataTextStyle);
                    cellElement.appendChild((Node)textPElement);
                    TextFactory.constructTextSpan((Node)textPElement, (String)(inverseCommonName + " "), null);
                    TextFactory.constructTextSpan((Node)textPElement, (String)optionalDueDateString, (String)dataRedTextStyle);
                    continue;
                }
                for (int v = 0; v < baulose.size(); ++v) {
                    String baulosString = baulose.get(v).getValue();
                    if (optionalDueDate == null) {
                        TextFactory.constructTextNode((Node)cellElement, (String)(inverseCommonName + " [" + baulosString + "] " + (dueDate != null ? dueDateString : (dueDateRemark != null ? dueDateRemark : ""))), (String)dataTextStyle);
                        continue;
                    }
                    TextPElement textPElement = (TextPElement)((OdfFileDom)cellElement.getOwnerDocument()).newOdfElement(TextPElement.class);
                    textPElement.setTextStyleNameAttribute(dataTextStyle);
                    cellElement.appendChild((Node)textPElement);
                    TextFactory.constructTextSpan((Node)textPElement, (String)(inverseCommonName + " [" + baulosString + "] "), null);
                    TextFactory.constructTextSpan((Node)textPElement, (String)optionalDueDateString, (String)dataRedTextStyle);
                }
            }
        }
    }

    public static void appendWorkflowNodesFlatCell(TableTableRowElement rowElement, ResourceBundle resourceBundle, List<WorkflowNodeJoin> workflowNodeJoins, Map<Long, List<WorkflowNodeJoin>> workflowNodeIdToPositions, Map<Long, List<PlanningNotificationTextMetaInformation>> workflowNodePositionIdToBaulose, String dataCellStyle, String dataTextStyle, String dataItalicTextStyle, String dataRedTextStyle, String dataCaptionTextStyle) {
        String dateFormatPattern = resourceBundle.getString("yearToDayFormat");
        ArrayList<TableTableCellElement> cellElements = new ArrayList<TableTableCellElement>();
        for (int n = 0; workflowNodeJoins != null && n < workflowNodeJoins.size(); ++n) {
            if (n == 0) {
                cellElements.add(TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement));
                cellElements.add(TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement));
            }
            cellElements.add(TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement));
            cellElements.add(TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement));
            WorkflowNodeJoin workflowNodeJoin = workflowNodeJoins.get(n);
            String captionTextStyle = workflowNodeJoin.getWorkflowEntityInvalidated() != null && workflowNodeJoin.getWorkflowEntityInvalidated() != false ? dataTextStyle : dataCaptionTextStyle;
            String organisationName = "";
            String inverseCommonName = "";
            String projectParticipationComment = "";
            String baulosString = "";
            String dueDateStringFinal = "";
            List<WorkflowNodeJoin> workflowNodePositionJoins = workflowNodeIdToPositions.get(workflowNodeJoin.getWorkflowNodeId());
            if (workflowNodePositionJoins == null || workflowNodePositionJoins.size() == 0) {
                if (n == 0) {
                    TextFactory.constructTextNode((Node)((Node)cellElements.get(0)), (String)baulosString, (String)dataItalicTextStyle);
                    TextFactory.constructTextNode((Node)((Node)cellElements.get(1)), (String)dueDateStringFinal, (String)dataItalicTextStyle);
                }
                TextFactory.constructTextNode((Node)((Node)cellElements.get(2 * n + 2)), (String)resourceBundle.getString("planningNotificationOrderListNoPersonsInWorkflow"), (String)dataItalicTextStyle);
                TextFactory.constructTextNode((Node)((Node)cellElements.get(2 * n + 3)), (String)projectParticipationComment, (String)dataItalicTextStyle);
                continue;
            }
            for (int z = 0; z < 1; ++z) {
                String dueDateString;
                WorkflowNodeJoin workflowNodePositionJoin = workflowNodePositionJoins.get(z);
                Long workflowNodePositionId = workflowNodePositionJoin.getWorkflowNodePositionId();
                projectParticipationComment = workflowNodePositionJoin.getProjectParticipationComment();
                organisationName = workflowNodePositionJoin.getOrganisationName();
                inverseCommonName = PersonHelper.getInverseCommonName(workflowNodePositionJoin.getPerson());
                Double dueDate = workflowNodePositionJoin.getWorkflowNodePositionDueDate();
                String dueDateRemark = CodeHelper.getI18nDueDateRemark(resourceBundle, workflowNodePositionJoin.getWorkflowNodePositionDueDateRemark());
                Double optionalDueDate = workflowNodePositionJoin.getWorkflowNodePositionOptionalDueDate();
                String string = dueDateString = dueDate != null ? DateHelper.formatUtcSeconds(dueDate, "Europe/Vienna", dateFormatPattern) : resourceBundle.getString("nothing");
                dueDateStringFinal = dueDate != null ? dueDateString : (dueDateRemark != null ? dueDateRemark : "");
                String optionalDueDateString = optionalDueDate != null ? DateHelper.formatUtcSeconds(optionalDueDate, "Europe/Vienna", dateFormatPattern) : resourceBundle.getString("nothing");
                List<PlanningNotificationTextMetaInformation> baulose = workflowNodePositionIdToBaulose.get(workflowNodePositionId);
                if (baulose == null && baulose.size() <= 0) continue;
                for (int v = 0; v < baulose.size(); ++v) {
                    baulosString = baulose.get(v).getValue();
                }
            }
            if (n == 0) {
                TextFactory.constructTextNode((Node)((Node)cellElements.get(0)), (String)baulosString, (String)dataItalicTextStyle);
                TextFactory.constructTextNode((Node)((Node)cellElements.get(1)), (String)dueDateStringFinal, (String)dataItalicTextStyle);
            }
            TextFactory.constructTextNode((Node)((Node)cellElements.get(2 * n + 2)), (String)(organisationName + " (" + inverseCommonName + ")"), (String)dataItalicTextStyle);
            TextFactory.constructTextNode((Node)((Node)cellElements.get(2 * n + 3)), (String)projectParticipationComment, (String)dataItalicTextStyle);
        }
    }

    public static FancyOdfTable<WorkflowActivityPositionResultJoin> constructHistoryTable(final ResourceBundle resourceBundle, final Styles contentAutomaticStyles, String headerCellStyle, String headerTextStyle, final String dataCellStyle, final String dataTextStyle, String dataRowStyle, final String internetLinkStyle, Map<String, Double> relativeColumnWidths, final Map<Long, List<PlanningNotificationTextMetaInformation>> workflowActivityIdToBaulose, final Map<Long, List<PlanningNotificationAttachment>> workflowActivityIdToAttachments, final boolean reportMode, final UtilService utilService) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new SimpleOdfStringColumn<WorkflowActivityPositionResultJoin>("workflowNodeName", resourceBundle.getString("workflowActivityResultWorkflowNodeNameColumnCaption"), dataCellStyle, dataTextStyle){

            protected String getString(WorkflowActivityPositionResultJoin join) {
                return join.getWorkflowActivityWorkflowNodeName();
            }
        });
        columns.add(new FancyOdfTableColumn<WorkflowActivityPositionResultJoin>("baulos", resourceBundle.getString("workflowActivityResultBaulosColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, WorkflowActivityPositionResultJoin data) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, this.getOutput(data));
            }

            public int compare(WorkflowActivityPositionResultJoin dataOne, WorkflowActivityPositionResultJoin dataTwo, boolean descending) {
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, this.getOutput(dataOne), this.getOutput(dataTwo), (boolean)descending);
            }

            private List<String> getOutput(WorkflowActivityPositionResultJoin join) {
                ArrayList<String> tokens = new ArrayList<String>();
                Long workflowActivityId = join.getWorkflowActivityId();
                List baulose = (List)workflowActivityIdToBaulose.get(workflowActivityId);
                if (baulose != null && baulose.size() > 0) {
                    for (PlanningNotificationTextMetaInformation baulos : baulose) {
                        tokens.add(baulos.getValue());
                    }
                }
                return tokens;
            }
        });
        columns.add(new SimpleOdfStringColumn<WorkflowActivityPositionResultJoin>("tokenInitiator", resourceBundle.getString("workflowActivityResultTokenInitiatorColumnCaption"), dataCellStyle, dataTextStyle){

            protected String getString(WorkflowActivityPositionResultJoin join) {
                return join.getWorkflowActivityTokenInitiator();
            }
        });
        columns.add(new SimpleOdfStringColumn<WorkflowActivityPositionResultJoin>("reviewer", resourceBundle.getString("workflowActivityResultReviewerColumnCaption"), dataCellStyle, dataTextStyle){

            protected String getString(WorkflowActivityPositionResultJoin join) {
                return join.getWorkflowActivityPositionResultReviewer();
            }
        });
        columns.add(new SimpleOdfStringColumn<WorkflowActivityPositionResultJoin>("issued", resourceBundle.getString("workflowActivityResultIssuedColumnCaption"), dataCellStyle, dataTextStyle){

            protected String getString(WorkflowActivityPositionResultJoin join) {
                String dateFormatPattern = resourceBundle.getString("yearToSecondFormat");
                Double issued = join.getWorkflowActivityIssued();
                return DateHelper.formatUtcSeconds(issued, "Europe/Vienna", dateFormatPattern);
            }
        });
        columns.add(new FancyOdfTableColumn<WorkflowActivityPositionResultJoin>("comment", resourceBundle.getString("workflowActivityResultCommentColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, WorkflowActivityPositionResultJoin join) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                String unsafeComment = join.getWorkflowActivityPositionResultComment();
                String safeComment = utilService.getSafeHtml(unsafeComment, true);
                OdfFromHtmlConverter.convert((Node)cellElement, safeComment, dataTextStyle, contentAutomaticStyles);
            }

            public int compare(WorkflowActivityPositionResultJoin dataOne, WorkflowActivityPositionResultJoin dataTwo, boolean descending) {
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
            }

            private String getOutput(WorkflowActivityPositionResultJoin join) {
                return join.getWorkflowActivityPositionResultComment();
            }
        });
        columns.add(new SimpleOdfStringColumn<WorkflowActivityPositionResultJoin>("result", resourceBundle.getString("workflowActivityResultResultColumnCaption"), dataCellStyle, dataTextStyle){

            protected String getString(WorkflowActivityPositionResultJoin join) {
                return join.getWorkflowActivityPositionResultResult();
            }
        });
        columns.add(new FancyOdfTableColumn<WorkflowActivityPositionResultJoin>("attachment", resourceBundle.getString("workflowActivityResultAttachmentColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, WorkflowActivityPositionResultJoin data) {
                Long workflowActivityId = data.getWorkflowActivityId();
                List attachments = (List)workflowActivityIdToAttachments.get(workflowActivityId);
                if (attachments != null) {
                    if (reportMode) {
                        PlanningExportHelper.constructAttachmentLinkCell(rowElement, dataTextStyle, dataCellStyle, internetLinkStyle, attachments);
                    } else {
                        String label = resourceBundle.getString("workflowActivityResultAttachmentsExist");
                        TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{label});
                    }
                } else {
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{""});
                }
            }

            public int compare(WorkflowActivityPositionResultJoin dataOne, WorkflowActivityPositionResultJoin dataTwo, boolean descending) {
                return 0;
            }
        });
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, Double.valueOf(23.9), relativeColumnWidths, columns);
        table.setDataRowStyle(dataRowStyle);
        return table;
    }

    public static String getReferenceOutput(List<PlanningNotificationOrderReferenceInfo> referenceInfos) {
        Collections.sort(referenceInfos, new Comparator<PlanningNotificationOrderReferenceInfo>(){

            @Override
            public int compare(PlanningNotificationOrderReferenceInfo referenceInfoOne, PlanningNotificationOrderReferenceInfo referenceInfoTwo) {
                return (int)(referenceInfoOne.getPlanningNotificationOrder().getSerialNumber() - referenceInfoTwo.getPlanningNotificationOrder().getSerialNumber());
            }
        });
        String result = "";
        for (int n = 0; n < referenceInfos.size(); ++n) {
            PlanningNotificationOrderReferenceInfo referenceInfo = referenceInfos.get(n);
            result = result + referenceInfo.getPlanningNotificationOrder().getSerialNumber().toString();
            if (n >= referenceInfos.size() - 1) continue;
            result = result + ", ";
        }
        return result;
    }

    public static TableTableCellElement constructSerialNumberLinkCell(TableTableRowElement rowElement, String dataTextStyle, String dataCellStyle, String internetLinkStyle, String anchor, PlanningNotificationReportInfo reportInfo) {
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        TableTableCellElement cellElement = rowElement.newTableTableCellElement(0.0, "string");
        if (dataCellStyle != null) {
            cellElement.setTableStyleNameAttribute(dataCellStyle);
        }
        cellElement.removeAttribute("office:value");
        Long serialNumber = reportInfo.getReportJoin().getPlanningNotificationOrderSerialNumber();
        String serialNumberString = MessageFormat.format(resourceBundle.getString("planningNotificationReportSerialNumberWithParam"), serialNumber != null ? serialNumber : "---");
        TextPElement pElement = TextFactory.constructTextNode((Node)cellElement, null, (String)dataTextStyle);
        TextAElement aElement = TextFactory.constructTextAElement((Node)pElement, (String)"simple", (String)("#" + anchor), (String)internetLinkStyle, null);
        TextFactory.constructTextSpan((Node)aElement, (String)serialNumberString, null);
        return cellElement;
    }

    public static TableTableCellElement constructAttachmentLinkCell(TableTableRowElement rowElement, String dataTextStyle, String dataCellStyle, String internetLinkStyle, List<PlanningNotificationAttachment> attachments) {
        TableTableCellElement cellElement = rowElement.newTableTableCellElement(0.0, "string");
        if (dataCellStyle != null) {
            cellElement.setTableStyleNameAttribute(dataCellStyle);
        }
        cellElement.removeAttribute("office:value");
        for (PlanningNotificationAttachment attachment : attachments) {
            TextPElement pElement = TextFactory.constructTextNode((Node)cellElement, null, (String)dataTextStyle);
            TextAElement aElement = TextFactory.constructTextAElement((Node)pElement, (String)"simple", (String)(REPLACEMENT_URL_PREFIX + attachment.getId()), (String)internetLinkStyle, null);
            String caption = attachment.getOriginalName();
            TextFactory.constructTextSpan((Node)aElement, (String)caption, null);
        }
        return cellElement;
    }
}

