/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.compositeDto.PlanningNotificationReportSearchInfo;
import at.cdes.api.dto.Country;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.Search;
import at.cdes.api.dto.util.LocalStorageItem;
import at.cdes.api.guiService.UtilService;
import at.cdes.api.joinDto.SearchJoin;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.CountryDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ReviewCycleStatusSearchDAO;
import at.cdes.impl.dao.SearchDAO;
import at.cdes.impl.sec.util.SecurityHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.clazzes.util.aop.ThreadLocalManager;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilServiceImpl
implements UtilService {
    private ActionDAO actionDAO;
    private CountryDAO countryDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private ProjectDAO projectDAO;
    private ReviewCycleStatusSearchDAO reviewCycleStatusSearchDAO;
    private SearchDAO searchDAO;
    private static final Logger log = LoggerFactory.getLogger(UtilServiceImpl.class);

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setCountryDAO(CountryDAO countryDAO) {
        this.countryDAO = countryDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setReviewCycleStatusSearchDAO(ReviewCycleStatusSearchDAO reviewCycleStatusSearchDAO) {
        this.reviewCycleStatusSearchDAO = reviewCycleStatusSearchDAO;
    }

    public void setSearchDAO(SearchDAO searchDAO) {
        this.searchDAO = searchDAO;
    }

    public String getSafeHtml(String unsafeHtml, boolean simpleText) {
        if (unsafeHtml == null) {
            return "";
        }
        String safeHtml = "";
        safeHtml = simpleText ? Jsoup.clean((String)unsafeHtml, (Whitelist)Whitelist.simpleText()) : Jsoup.clean((String)unsafeHtml, (Whitelist)Whitelist.basic());
        return safeHtml;
    }

    public void printLocalStorageToDebug(List<LocalStorageItem> localStorageItems) {
        for (LocalStorageItem item : localStorageItems) {
            log.info("Local storage item [" + item.getKey() + "] of orgPerson [" + item.getOrganisationPersonId() + "] for network [" + item.getNetworkId() + "] has content [" + item.getJson() + "]");
        }
    }

    public List<Search> getAllOwnSearchesByNetwork(Long networkId, String pageName) {
        CdesPrincipal principal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        return this.searchDAO.getByPersonNetworkAndPage(principal.getPersonId(), networkId, pageName);
    }

    public List<Search> getAllOwnSearchesByProject(Long projectId, String pageName) {
        CdesPrincipal principal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        return this.searchDAO.getByPersonProjectAndPage(principal.getPersonId(), projectId, pageName);
    }

    public PlanningNotificationReportSearchInfo getAllOwnSearchJoinsByProject(Long projectId, String pageName) {
        CdesPrincipal principal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        List<SearchJoin> searchJoins = this.searchDAO.getSearchJoinsByProjectAndPage(principal.getPersonId(), projectId, pageName);
        PlanningNotificationReportSearchInfo reportSearch = new PlanningNotificationReportSearchInfo();
        reportSearch.setSearchJoins(searchJoins);
        reportSearch.setHasProjects(null);
        return reportSearch;
    }

    public List<SearchJoin> getAllOwnReportSearchesWithForeignByNetwork(Long organisationPersonId, Long networkId, Boolean includeForeign) {
        List<Project> networkProjects = this.projectDAO.getByNetwork(networkId);
        ArrayList<Long> networkProjectIds = new ArrayList<Long>();
        for (Project networkProject : networkProjects) {
            networkProjectIds.add(networkProject.getId());
        }
        Map<Long, Set<Action>> projectIdToAllowedActions = this.actionDAO.getActionsForProjects(organisationPersonId, networkProjectIds, Action.GENERATE_PLANNING_NOTIFICATION_REPORT);
        return this.getAllOwnSearchesWithForeignByNetwork(organisationPersonId, networkId, "ReportConfig", Action.GENERATE_PLANNING_NOTIFICATION_REPORT, includeForeign, networkProjectIds, projectIdToAllowedActions);
    }

    public PlanningNotificationReportSearchInfo getPlanningNotificationReportSearchs(Long organisationPersonId, Long networkId, Boolean includeForeign) {
        List<Project> networkProjects = this.projectDAO.getByNetwork(networkId);
        ArrayList<Long> networkProjectIds = new ArrayList<Long>();
        for (Project networkProject : networkProjects) {
            networkProjectIds.add(networkProject.getId());
        }
        Map<Long, Set<Action>> projectIdToAllowedActions = this.actionDAO.getActionsForProjects(organisationPersonId, networkProjectIds, Action.GENERATE_PLANNING_NOTIFICATION_REPORT);
        List<SearchJoin> searchJoins = this.getAllOwnSearchesWithForeignByNetwork(organisationPersonId, networkId, "ReportConfig", Action.GENERATE_PLANNING_NOTIFICATION_REPORT, includeForeign, networkProjectIds, projectIdToAllowedActions);
        PlanningNotificationReportSearchInfo reportSearch = new PlanningNotificationReportSearchInfo();
        reportSearch.setSearchJoins(searchJoins);
        reportSearch.setHasProjects(Boolean.valueOf(!projectIdToAllowedActions.isEmpty()));
        return reportSearch;
    }

    private List<SearchJoin> getAllOwnSearchesWithForeignByNetwork(Long organisationPersonId, Long networkId, String pageName, Action actionName, Boolean includeForeign, List<Long> networkProjectIds, Map<Long, Set<Action>> projectIdToAllowedActions) {
        CdesPrincipal principal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long principalPersonId = principal.getPersonId();
        List<SearchJoin> rawSearchJoins = this.searchDAO.getSearchJoinsByNetworkAndPage(networkId, pageName);
        boolean includeForeignSearches = includeForeign != null && includeForeign != false;
        ArrayList<SearchJoin> searchJoins = new ArrayList<SearchJoin>();
        for (SearchJoin rawSearchJoin : rawSearchJoins) {
            if ((rawSearchJoin.getSearchPersonId() == null || rawSearchJoin.getSearchPersonId().longValue() != principalPersonId.longValue()) && (!includeForeignSearches || !this.doesAnyProjectHavePermission(networkProjectIds, projectIdToAllowedActions, actionName))) continue;
            searchJoins.add(rawSearchJoin);
        }
        return searchJoins;
    }

    private boolean doesAnyProjectHavePermission(List<Long> projectIds, Map<Long, Set<Action>> projectIdToAllowedActions, Action actionName) {
        boolean anyHas = false;
        for (Long projectId : projectIds) {
            anyHas |= projectIdToAllowedActions.containsKey(projectId) && projectIdToAllowedActions.get(projectId).contains(actionName);
        }
        return anyHas;
    }

    public boolean saveOrUpdateSearch(Long organisationPersonId, String pageName, Long projectId, Search search) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_PERSONAL_DATA);
        if (!actions.contains(Action.EDIT_PERSONAL_DATA)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have privilege [editPersonalData] to save or update a Search.");
        }
        if (search.getName() == null || search.getName().trim().length() == 0) {
            return false;
        }
        search.setName(this.getSafeHtml(search.getName(), true));
        String name = search.getName();
        CdesPrincipal principal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = principal.getPersonId();
        search.setPersonId(personId);
        search.setPageName(pageName);
        search.setProject(projectId);
        if (search.getId() == null) {
            List<Search> existingSearches = this.searchDAO.getByPersonProjectPageAndName(personId, projectId, pageName, name);
            if (existingSearches.size() > 0) {
                return false;
            }
            this.searchDAO.save(search);
            return true;
        }
        this.searchDAO.update(search);
        return true;
    }

    public void deleteSearch(Long organisationPersonId, Long searchId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.EDIT_PERSONAL_DATA);
        if (!actions.contains(Action.EDIT_PERSONAL_DATA)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have privilege [editPersonalData] to delete a Search.");
        }
        this.reviewCycleStatusSearchDAO.delete(searchId);
        this.searchDAO.delete(searchId);
    }

    public List<Country> getAllCountries(Long organisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        return this.countryDAO.getAll();
    }
}

