/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util.plot;

import at.cdes.api.dto.PlottOrderItemTemplate;
import at.cdes.api.dto.PlottProperties;
import at.cdes.api.joinDto.PlotOrderDeleteJoin;
import at.cdes.api.plot.compositeDto.PlotTaskInfo;
import at.cdes.api.plot.compositeDto.PlotTaskItemInfo;
import at.cdes.api.plot.voc.PlotColor;
import at.cdes.api.plot.voc.PlotMargin;
import at.cdes.api.plot.voc.PlotPaperQuality;
import at.cdes.api.voc.OrderStepMode;
import at.cdes.impl.plot.BoundingBox;
import at.cdes.impl.plot.LengthCalculator;
import at.cdes.impl.plot.LengthUnit;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class PlotHelper {
    public static Map<Long, List<PlotOrderDeleteJoin>> groupDeleteJoinsByPlotOrder(List<PlotOrderDeleteJoin> deleteJoins) {
        HashMap<Long, List<PlotOrderDeleteJoin>> plotOrderIdToDeleteJoins = new HashMap<Long, List<PlotOrderDeleteJoin>>();
        for (PlotOrderDeleteJoin deleteJoin : deleteJoins) {
            Long plotOrderId = deleteJoin.getPlotOrderId();
            if (!plotOrderIdToDeleteJoins.containsKey(plotOrderId)) {
                plotOrderIdToDeleteJoins.put(plotOrderId, new ArrayList());
            }
            ((List)plotOrderIdToDeleteJoins.get(plotOrderId)).add(deleteJoin);
        }
        return plotOrderIdToDeleteJoins;
    }

    public static Collection<Long> getPlotOrderIdsByPlotOrderDeleteJoins(List<PlotOrderDeleteJoin> plotOrderDeleteJoins) {
        HashSet<Long> plotOrderIds = new HashSet<Long>();
        for (PlotOrderDeleteJoin plotOrderDeleteJoin : plotOrderDeleteJoins) {
            plotOrderIds.add(plotOrderDeleteJoin.getPlotOrderId());
        }
        return plotOrderIds;
    }

    public static boolean isDeclined(Integer orderStepMode) {
        return orderStepMode != null && orderStepMode.intValue() == OrderStepMode.DECLINED.getValue();
    }

    public static Set<Long> getPlotOrderTemplateIdsByItemTemplates(List<PlottOrderItemTemplate> itemTemplates) {
        HashSet<Long> orderContractIds = new HashSet<Long>();
        for (PlottOrderItemTemplate itemTemplate : itemTemplates) {
            orderContractIds.add(itemTemplate.getOrderContractId());
        }
        return orderContractIds;
    }

    public static Map<Long, List<PlottOrderItemTemplate>> groupByOrderContractId(List<PlottOrderItemTemplate> plotOrderItemTemplates) {
        HashMap<Long, List<PlottOrderItemTemplate>> templateIdToItemTemplates = new HashMap<Long, List<PlottOrderItemTemplate>>();
        for (PlottOrderItemTemplate plotOrderItemTemplate : plotOrderItemTemplates) {
            Long orderContractId = plotOrderItemTemplate.getOrderContractId();
            if (!templateIdToItemTemplates.containsKey(orderContractId)) {
                templateIdToItemTemplates.put(orderContractId, new ArrayList());
            }
            ((List)templateIdToItemTemplates.get(orderContractId)).add(plotOrderItemTemplate);
        }
        return templateIdToItemTemplates;
    }

    public static String getColorLabel(ResourceBundle resourceBundle, Integer color) {
        if (color == null) {
            return "";
        }
        if (color.intValue() == PlotColor.IN_COLOR.getValue()) {
            return resourceBundle.getString("plotOrderItemColorLabel");
        }
        if (color.intValue() == PlotColor.LIKE_TEMPLATE.getValue()) {
            return resourceBundle.getString("plotOrderItemAsDisplayedLabel");
        }
        if (color.intValue() == PlotColor.MONOCHROME.getValue()) {
            return resourceBundle.getString("plotOrderItemBlackWhiteLabel");
        }
        throw new IllegalArgumentException("Unsupported color: [" + color + "]");
    }

    public static String getMirrorLabel(ResourceBundle resourceBundle, Boolean mirror) {
        if (mirror == null) {
            return "";
        }
        if (mirror.booleanValue()) {
            return resourceBundle.getString("yes");
        }
        return resourceBundle.getString("no");
    }

    public static Double getPlotPropertiesArea(PlottProperties plotProperties) {
        BoundingBox boundingBox = BoundingBox.getByPlotProperties(plotProperties);
        Double area = LengthCalculator.getBBoxArea(boundingBox, LengthUnit.METER);
        if (area != null) {
            Integer count;
            Double paperFormatSquareSize = LengthCalculator.getPaperFormatSquareSize(plotProperties.getScale(), LengthUnit.METER);
            if (paperFormatSquareSize != null) {
                area = paperFormatSquareSize;
            }
            if ((count = plotProperties.getCount()) != null) {
                area = area * (double)count.intValue();
            }
            return area;
        }
        return null;
    }

    public static String getPlotAreaString(Double area) {
        if (area != null) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.GERMAN);
            numberFormat.setMinimumFractionDigits(2);
            numberFormat.setMaximumFractionDigits(2);
            String areaString = numberFormat.format(area);
            return areaString + " " + LengthCalculator.getSquareUnitLabel(LengthUnit.METER);
        }
        return "";
    }

    private static boolean isInvalidated(PlotTaskItemInfo itemInfo) {
        int status = itemInfo.getDocumentVersion().getStatus();
        return status == 4 || status == 5 || status == 7;
    }

    public static Double getSumForColorValue(PlotTaskInfo taskInfo, Integer isInColorValue) {
        Double sum = 0.0;
        if (taskInfo != null) {
            for (PlotTaskItemInfo itemInfo : taskInfo.getItemInfos()) {
                Double area;
                PlottProperties plotProperties = itemInfo.getPlotProperties();
                if (PlotHelper.isInvalidated(itemInfo) || plotProperties.getIsInColor() == null || plotProperties.getIsInColor().intValue() != isInColorValue.intValue() || (area = PlotHelper.getPlotPropertiesArea(plotProperties)) == null) continue;
                sum = sum + area;
            }
        }
        return sum;
    }

    public static double[] getSumForPaperQuality(PlotTaskInfo taskInfo) {
        double[] resDPaperQuality = new double[PlotPaperQuality.values().length];
        if (taskInfo != null) {
            for (PlotTaskItemInfo itemInfo : taskInfo.getItemInfos()) {
                PlottProperties itemsPlotProperties = itemInfo.getPlotProperties();
                if (PlotHelper.isInvalidated(itemInfo) || itemsPlotProperties.getPaperQuality() == null) continue;
                for (int i = 0; i < PlotPaperQuality.values().length; ++i) {
                    Double area;
                    if (!PlotPaperQuality.values()[i].getValue().equals(itemsPlotProperties.getPaperQuality()) || (area = PlotHelper.getPlotPropertiesArea(itemsPlotProperties)) == null) continue;
                    int n = i;
                    resDPaperQuality[n] = resDPaperQuality[n] + area;
                }
            }
        }
        return resDPaperQuality;
    }

    public static double[] getSumForPlotMargin(PlotTaskInfo taskInfo) {
        double[] resDPlotMargin = new double[PlotMargin.values().length];
        if (taskInfo != null) {
            for (PlotTaskItemInfo itemInfo : taskInfo.getItemInfos()) {
                PlottProperties itemsPlotProperties = itemInfo.getPlotProperties();
                if (PlotHelper.isInvalidated(itemInfo) || itemsPlotProperties.getMargin() == null) continue;
                for (int i = 0; i < PlotMargin.values().length; ++i) {
                    Double area;
                    if (!PlotMargin.values()[i].getValue().equals(itemsPlotProperties.getMargin()) || (area = PlotHelper.getPlotPropertiesArea(itemsPlotProperties)) == null) continue;
                    int n = i;
                    resDPlotMargin[n] = resDPlotMargin[n] + area;
                }
            }
        }
        return resDPlotMargin;
    }
}

