/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.plot;

import at.cdes.api.compositeDto.PlotOrderItemData;
import at.cdes.api.dto.ExportResult;
import at.cdes.api.guiService.PlotService;
import at.cdes.api.joinDto.PlotOrderZipExportJoin;
import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.impl.export.plot.PlotOrderZipExporter;
import at.cdes.preview.api.IMimeInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.clazzes.util.http.osgi.DefaultHttpContext;
import org.clazzes.util.sched.cache.ScratchFile;
import org.clazzes.util.sched.impl.HasLoggingCallable;
import org.clazzes.util.sched.impl.LoggingCallbackLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotOrderZipExportCallable
extends HasLoggingCallable<ScratchFile> {
    private static final Logger log = LoggerFactory.getLogger(PlotOrderZipExportCallable.class);
    private static final Logger clog = new LoggingCallbackLogger(log);
    private PlotOrderZipExporter plotOrderZipExporter;
    private PlotService plotService;
    private VisitlessMimeSource documentVersionMimeSource;
    private Long projectId;
    private Long plotOrderId;
    private List<PlotOrderZipExportJoin> zipExportJoins;
    private String exportTempDir;
    private Long organisationPersonId;
    private String personVariablesUserLocale;

    public PlotOrderZipExportCallable(PlotOrderZipExporter plotOrderZipExporter, PlotService plotService, VisitlessMimeSource documentVersionMimeSource, Long organisationPersonId, Long projectId, Long plotOrderId, List<PlotOrderZipExportJoin> zipExportJoins, String exportTempDir, String personVariablesUserLocale) {
        this.plotOrderZipExporter = plotOrderZipExporter;
        this.plotService = plotService;
        this.documentVersionMimeSource = documentVersionMimeSource;
        this.projectId = projectId;
        this.plotOrderId = plotOrderId;
        this.zipExportJoins = zipExportJoins;
        this.exportTempDir = exportTempDir;
        this.organisationPersonId = organisationPersonId;
        this.personVariablesUserLocale = personVariablesUserLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScratchFile call() throws Exception {
        File tmp = File.createTempFile("PlotOrderZipExport_", ".zip", new File(this.exportTempDir));
        FileInputStream xlsInputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(tmp));
            for (int n = 0; n < this.zipExportJoins.size(); ++n) {
                Integer currNumber = n + 1;
                PlotOrderZipExportJoin zipExportJoin = this.zipExportJoins.get(n);
                try (IMimeInputStream inputStream = null;){
                    inputStream = this.documentVersionMimeSource.getMimeStream(new Object[]{zipExportJoin.getDocumentVersionId()});
                    String mimeType = inputStream.getMimeType();
                    String extension = DefaultHttpContext.getExtension((String)mimeType);
                    String fileName = "Plan_" + currNumber.toString() + (extension != null ? "." + extension.toLowerCase() : "");
                    zipOutputStream.putNextEntry(new ZipEntry(fileName));
                    int lengthOfBuffer = 16384;
                    long numberOfBytesRead = 0L;
                    long totalSize = inputStream.getStreamSize();
                    while (numberOfBytesRead < totalSize) {
                        byte[] buffer = inputStream.readBlock(lengthOfBuffer);
                        zipOutputStream.write(buffer, 0, (int)((numberOfBytesRead += (long)lengthOfBuffer) < totalSize ? (long)lengthOfBuffer : totalSize % (long)lengthOfBuffer));
                    }
                }
                zipOutputStream.closeEntry();
            }
            ArrayList<PlotOrderItemData> plotOrderItemDatas = new ArrayList<PlotOrderItemData>();
            for (PlotOrderZipExportJoin zipExportJoin : this.zipExportJoins) {
                plotOrderItemDatas.add(new PlotOrderItemData(zipExportJoin));
            }
            ExportResult xlsExportResult = this.plotOrderZipExporter.export(this.organisationPersonId, plotOrderItemDatas, this.personVariablesUserLocale);
            String xlsFile = xlsExportResult.getTmpFileName();
            xlsInputStream = new FileInputStream(xlsFile);
            zipOutputStream.putNextEntry(new ZipEntry("Plaene.xlsx"));
            int numberOfBytesRead = 0;
            int lengthOfBuffer = 16384;
            byte[] buffer = new byte[lengthOfBuffer];
            while (numberOfBytesRead >= 0) {
                numberOfBytesRead = xlsInputStream.read(buffer, 0, lengthOfBuffer);
                if (numberOfBytesRead <= 0) continue;
                zipOutputStream.write(buffer, 0, numberOfBytesRead);
            }
            zipOutputStream.closeEntry();
        }
        finally {
            if (xlsInputStream != null) {
                xlsInputStream.close();
            }
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
        String encodedFileName = "Test";
        return new ScratchFile(tmp, "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }
}

