/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.certificate.CertificateGenerator;
import at.cdes.api.compositeDto.CertficateRequestPersonInfo;
import at.cdes.api.compositeDto.CertificateRequestResult;
import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.CertificateRequest;
import at.cdes.api.dto.Country;
import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Person;
import at.cdes.api.guiService.ChallengeLoginService;
import at.cdes.api.joinDto.CertificateRequestPersonJoin;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.person.PasswordUtils;
import at.cdes.api.person.PersonPasswordChanger;
import at.cdes.api.sec.PasswordValidationError;
import at.cdes.api.sec.PasswordValidator;
import at.cdes.api.sec.SecurityQuestionAnswerValidationError;
import at.cdes.api.sec.SecurityQuestionValidator;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.impl.dao.CertificateDAO;
import at.cdes.impl.dao.CertificateRequestDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PersonDAO;
import at.cdes.impl.export.ChallengeLoginGeneratePdfCallable;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.odf.OdfAddressHelper;
import at.cdes.impl.util.odf.OdfHelper;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.draw.FrameFactory;
import org.clazzes.odf.util.draw.ImageFactory;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.GraphicStyleFactory;
import org.clazzes.odf.util.style.ParagraphStyleFactory;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.style.TextStyleFactory;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.table.TableStyleFactory;
import org.clazzes.odf.util.text.CompositeTextFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.datetime.ISO8601Format;
import org.clazzes.util.datetime.UtcTimestamp;
import org.clazzes.util.lang.Pair;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawTextBoxElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class ChallengeLoginServiceImpl
implements ChallengeLoginService {
    private static final Logger log = LoggerFactory.getLogger(ChallengeLoginServiceImpl.class);
    private Boolean enableCustomerLogo;
    private CertificateDAO certificateDAO;
    private CertificateGenerator certificateGenerator;
    private CertificateRequestDAO certificateRequestDAO;
    private String odfStylePrefix;
    private Long odfTimeout;
    private IOneTimeScheduler oneTimeScheduler;
    private OOoFileEngine oooFileEngine = null;
    private OrganisationPersonDAO organisationPersonDAO;
    private PersonDAO personDAO;
    private PasswordUtils passwordUtils;
    private PasswordValidator passwordValidator;
    private PersonPasswordChanger personPasswordChanger;
    private String tempDirName;
    private String userPolicyPath;
    private Integer securityAnswerMinLength;
    private Integer passwordMinLength;
    private SecurityQuestionValidator securityQuestionValidator;
    private static final String LOGIN_PATTERN_STRING = "[a-zA-Z][a-zA-Z0-9\\-_.]*";
    private static final Pattern LOGIN_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9\\-_.]*");
    private static final String SECURITY_ANSWER_PATTERN_STRING = "[a-zA-Z0-9\\-_.]*";
    private static final Pattern SECURITY_ANSWER_PATTERN = Pattern.compile("[a-zA-Z0-9\\-_.]*");

    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public void setCertificateDAO(CertificateDAO certificateDAO) {
        this.certificateDAO = certificateDAO;
    }

    public void setCertificateGenerator(CertificateGenerator certificateGenerator) {
        this.certificateGenerator = certificateGenerator;
    }

    public void setCertificateRequestDAO(CertificateRequestDAO certificateRequestDAO) {
        this.certificateRequestDAO = certificateRequestDAO;
    }

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOneTimeScheduler(IOneTimeScheduler oneTimeScheduler) {
        this.oneTimeScheduler = oneTimeScheduler;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public void setPasswordUtils(PasswordUtils passwordUtils) {
        this.passwordUtils = passwordUtils;
    }

    public void setPasswordValidator(PasswordValidator passwordValidator) {
        this.passwordValidator = passwordValidator;
    }

    public void setPersonPasswordChanger(PersonPasswordChanger personPasswordChanger) {
        this.personPasswordChanger = personPasswordChanger;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public void setUserPolicyPath(String userPolicyPath) {
        this.userPolicyPath = userPolicyPath;
    }

    public void setSecurityAnswerMinLength(Integer securityAnswerMinLength) {
        this.securityAnswerMinLength = securityAnswerMinLength;
    }

    public void setPasswordMinLength(Integer passwordMinLength) {
        this.passwordMinLength = passwordMinLength;
    }

    public void setSecurityQuestionValidator(SecurityQuestionValidator securityQuestionValidator) {
        this.securityQuestionValidator = securityQuestionValidator;
    }

    public Person getPersonByChallengeOne() {
        Principal principal = ThreadLocalManager.getLoginPrincipal();
        String challengeOne = principal.getName();
        if (challengeOne.contains("/")) {
            challengeOne = challengeOne.substring(challengeOne.indexOf("/") + 1);
        }
        return this.personDAO.getPersonByChallengeLoginOne(challengeOne);
    }

    public CertficateRequestPersonInfo getCertificateRequestPersonJoinByChallengeOne() {
        Principal principal = ThreadLocalManager.getLoginPrincipal();
        String challengeOne = principal.getName();
        if (challengeOne.contains("/")) {
            challengeOne = challengeOne.substring(challengeOne.indexOf("/") + 1);
        }
        CertificateRequestPersonJoin certificateRequestPersonJoin = this.certificateRequestDAO.getPersonJoinByChallengeOne(challengeOne);
        CertficateRequestPersonInfo certficateRequestPersonInfo = new CertficateRequestPersonInfo();
        certficateRequestPersonInfo.setCertificateRequestPersonJoin(certificateRequestPersonJoin);
        certficateRequestPersonInfo.setHasUserPolicyPath(Boolean.valueOf(false));
        certficateRequestPersonInfo.setSecurityAnswerMinLength(this.securityAnswerMinLength);
        certficateRequestPersonInfo.setPasswordMinLength(this.passwordMinLength);
        if (this.userPolicyPath != null && this.userPolicyPath.length() > 0) {
            certficateRequestPersonInfo.setHasUserPolicyPath(Boolean.valueOf(true));
        }
        return certficateRequestPersonInfo;
    }

    private CertificateRequest getCertificateRequest() {
        Principal principal = ThreadLocalManager.getLoginPrincipal();
        String challengeOne = principal.getName();
        if (challengeOne.contains("/")) {
            challengeOne = challengeOne.substring(challengeOne.indexOf("/") + 1);
        }
        return this.certificateRequestDAO.getByChallengeLoginOne(challengeOne);
    }

    public CertificateRequestResult requestCertificate(String userName, String password, String securityQuestion, String securityAnswer) {
        Person person = this.getPersonByChallengeOne();
        CertificateRequest certificateRequest = this.getCertificateRequest();
        Long certificateRequestOrgPersonId = certificateRequest.getCreatedFor();
        PasswordValidationError passwordValidationError = this.passwordValidator.validate(password, person.getId());
        SecurityQuestionAnswerValidationError answerValidationError = this.securityQuestionValidator.validateAnswer(securityAnswer);
        String result = null;
        if (person == null) {
            result = "Die angegebene Person existiert nicht.";
        } else {
            if (certificateRequest == null) {
                throw new IllegalArgumentException("Could not find CertificateRequest matching the challenge login.");
            }
            if (userName.length() == 0) {
                result = "Bitte geben Sie einen nichtleeren Benutzernamen an.";
            } else if (passwordValidationError != PasswordValidationError.OK) {
                switch (passwordValidationError) {
                    case LACKING_DIVERSITY: {
                        result = "Das neue Passwort muss Zeichen aus mindestens drei der nachfolgenden Kategorien enthalten: Kleinbuchstaben, Gro\u00dfbuchstaben, Sonderzeichen, Zahlen";
                        break;
                    }
                    case TOO_SHORT: {
                        result = "Das neue Passwort muss mindestens 12 Zeichen lang sein.";
                        break;
                    }
                    case INVALID_CHARS: {
                        result = "Das Passwort enth\u00e4lt nicht erlaubte Zeichen.  Erlaubt sind: Gro\u00df- und Kleinbuchstaben (inklusive Umlaute und \u00df), Ziffern, \u00fcbliche Satz- und Sonderzeichen (d.h. .-_/\\!?,:\u00a7$%&\u20ac), Klammern (d.h. ()[]\\{\\}).  Nicht erlaubt sind insbesondere Leerzeichen.";
                        break;
                    }
                    case OLD_PW: {
                        result = "Alte Passw\u00f6rter d\u00fcrfen nicht wiederverwendet werden.";
                        break;
                    }
                }
            } else if ("root".equals(userName)) {
                result = "root ist kein zul\u00e4ssiger Benutzername.";
            } else if (answerValidationError != SecurityQuestionAnswerValidationError.OK) {
                result = this.securityQuestionValidator.getMessage(new Locale("de-AT"), answerValidationError);
            }
        }
        if (result != null) {
            return new CertificateRequestResult(null, result);
        }
        log.info("Received request Id: [" + certificateRequest.getId() + "] with type: [" + certificateRequest.getRequestType() + "]");
        Person existingPerson = this.personDAO.getPersonByLogin(userName);
        if (existingPerson != null && !existingPerson.getId().equals(person.getId())) {
            result = "Der angegebene Benutzername ist bereits vergeben.  Bitte w\u00e4hlen Sie einen anderen.";
            return new CertificateRequestResult(null, result);
        }
        double now = (double)System.currentTimeMillis() / 1000.0;
        double yesterday = now - 86400.0;
        this.personPasswordChanger.setPassword(person.getId(), password);
        person = (Person)this.personDAO.get(person.getId());
        person.setLogin(userName);
        person.setQuestion(securityQuestion);
        String encodedAnswer = this.passwordUtils.encryptSecurityAnswer(password, securityAnswer);
        person.setAnswerPassword(encodedAnswer);
        this.personDAO.update(person);
        List<OrganisationPersonJoin> organisationPersonJoins = this.organisationPersonDAO.getOrganisationPersonJoin(certificateRequestOrgPersonId);
        if (organisationPersonJoins.size() == 0) {
            throw new IllegalArgumentException("Could not find any OrganisationPersonJoin for certificateRequest organisationPersonId [" + certificateRequestOrgPersonId + "]; expected exactly one.");
        }
        if (organisationPersonJoins.size() > 1) {
            throw new IllegalArgumentException("Found more than one OrganisationPersonJoin for certificateRequest organisationPersonId [" + certificateRequestOrgPersonId + "]; expected exactly one.");
        }
        OrganisationPersonJoin organisationPersonJoin = organisationPersonJoins.get(0);
        Certificate newCertificate = this.certificateGenerator.generateCertificate(certificateRequest, organisationPersonJoin, password);
        this.certificateDAO.save(newCertificate);
        this.certificateRequestDAO.update(certificateRequest);
        List<Certificate> existingCertificates = this.certificateDAO.getValidCertificatesByPerson(person.getId(), false);
        for (Certificate existingCertificate : existingCertificates) {
            if (existingCertificate.getId().equals(newCertificate.getId()) || !existingCertificate.isMaySign().booleanValue() || !(existingCertificate.getCertValidTo() > now)) continue;
            existingCertificate.setMayLogin(Boolean.valueOf(false));
            existingCertificate.setMaySign(Boolean.valueOf(false));
            if (existingCertificate.getOrganisationPersonId().equals(certificateRequestOrgPersonId)) {
                existingCertificate.setCertValidTo(Double.valueOf(yesterday));
            }
            this.certificateDAO.update(existingCertificate);
        }
        certificateRequest.setChallenge1(null);
        certificateRequest.setChallenge2(null);
        certificateRequest.setRequest(null);
        return new CertificateRequestResult(certificateRequest, null);
    }

    public String triggerGenerateCertificateRequestPdf() {
        ChallengeLoginGeneratePdfCallable job = new ChallengeLoginGeneratePdfCallable(this);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)job));
        return uuid.toString();
    }

    public ExportResult generateCertificateRequestPdf() throws Exception {
        CertificateRequestPersonJoin certificateRequestPersonJoin = this.getCertificateRequestPersonJoinByChallengeOne().getCertificateRequestPersonJoin();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyOdtTemplate.odt", ChallengeLoginServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        OfficeTextElement officeText = document.getContentRoot();
        OdfContext odfContext = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        String standardStyle = this.constructStandardStyle(odfContext);
        String subjectStyle = this.constructSubjectStyle(odfContext, standardStyle);
        String headerStyle = this.constructHeaderStyle(odfContext, standardStyle);
        String frameStyle = this.constructFrameGraphicStyle(odfContext);
        String addressStyle = this.constructAddressStyle(odfContext, standardStyle);
        String graphicsStyle = this.constructGraphicsStyle(odfContext);
        String addressTextStyle = this.constructDestAddressTextStyle(odfContext, addressStyle);
        String cdesLabelStyle = TextStyleFactory.constructTextStyleWithFontStyle((OdfContext)odfContext, (String)"italic");
        String signatureTextStyle = this.constructSignatureTextStyle(odfContext, standardStyle);
        GenerationContext generationContext = new GenerationContext(document, resourceBundle, certificateRequestPersonJoin, officeText, odfContext, standardStyle, subjectStyle, headerStyle, frameStyle, addressStyle, graphicsStyle, addressTextStyle, cdesLabelStyle, signatureTextStyle);
        this.generateFooter(generationContext);
        this.generateDestinationAddressBlock(generationContext);
        this.generateSourceAddressLogoBlock(generationContext);
        TextFactory.appendEmptyTextNodes((Node)officeText, (String)standardStyle, (int)2);
        TextFactory.appendEmptyTextNode((Node)officeText, (String)subjectStyle);
        this.generatePleaseSendBlock(generationContext);
        TextFactory.appendEmptyTextNode((Node)officeText, (String)standardStyle);
        TextFactory.appendEmptyTextNode((Node)officeText, (String)subjectStyle);
        this.generateSubjectSection(generationContext);
        TextFactory.appendEmptyTextNodes((Node)officeText, (String)standardStyle, (int)8);
        this.generateConfirmationSection(generationContext);
        TextFactory.appendEmptyTextNodes((Node)officeText, (String)standardStyle, (int)3);
        this.generateOwnSignatureTableSection(generationContext);
        TextFactory.appendEmptyTextNodes((Node)officeText, (String)standardStyle, (int)2);
        this.generateAdminSignatureTableSection(generationContext);
        TextFactory.constructTextNode((Node)officeText, (String)resourceBundle.getString("certificateRequestPleaseDoNotFill"), (String)standardStyle);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"CertificateRequest", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        return OdfHelper.constructExportResult(pdfFileName);
    }

    private void generateFooter(GenerationContext generationContext) {
        OdfTextDocument document = generationContext.getDocument();
        OdfContext odfContext = generationContext.getOdfContext();
        ResourceBundle resourceBundle = generationContext.getResourceBundle();
        String standardStyle = generationContext.getStandardStyle();
        String footerStyle = this.generateFooterStyle(odfContext, standardStyle);
        String footerTextStyle = this.generateFooterTextStyle(odfContext, footerStyle);
        OdfOfficeMasterStyles masterStyles = document.getOfficeMasterStyles();
        Iterator masterPages = masterStyles.getMasterPages();
        while (masterPages.hasNext()) {
            StyleMasterPageElement masterPage = (StyleMasterPageElement)masterPages.next();
            StyleFooterElement footerElement = masterPage.newStyleFooterElement();
            if (this.enableCustomerLogo.booleanValue()) {
                TextFactory.constructTextNode((Node)footerElement, (String)resourceBundle.getString("bankDataFooterLineOEBBOne"), (String)footerTextStyle);
                TextFactory.constructTextNode((Node)footerElement, (String)resourceBundle.getString("bankDataFooterLineOEBBTwo"), (String)footerTextStyle);
                TextFactory.constructTextNode((Node)footerElement, (String)resourceBundle.getString("bankDataFooterLineOEBBThree"), (String)footerTextStyle);
                continue;
            }
            TextFactory.constructTextNode((Node)footerElement, (String)resourceBundle.getString("bankDataFooterLineOne"), (String)footerTextStyle);
        }
    }

    private String generateFooterStyle(OdfContext odfContext, String standardStyle) {
        Styles stylesOfficeStyles = odfContext.getStylesOfficeStyles();
        StyleParagraphPropertiesElement paragraphProperties = stylesOfficeStyles.constructParagraphProperties();
        ParagraphStyleFactory.setLineAttributes((StyleParagraphPropertiesElement)paragraphProperties, (Boolean)false, (Integer)0);
        ParagraphStyleFactory.addTabStops((StyleParagraphPropertiesElement)paragraphProperties, (Pair[])new Pair[]{new Pair((Object)"8.5cm", (Object)"center"), new Pair((Object)"17cm", (Object)"right")});
        StyleTextPropertiesElement textProperties = stylesOfficeStyles.constructTextPropertiesWithColor("#999999");
        TextStyleFactory.setFontSizeProperties((StyleTextPropertiesElement)textProperties, (String)"7pt");
        return stylesOfficeStyles.getParagraphStyleWithParent(standardStyle, "extra", new OdfStylePropertiesBase[]{paragraphProperties});
    }

    private String generateFooterTextStyle(OdfContext odfContext, String footerStyle) {
        Styles stylesOfficeStyles = odfContext.getStylesOfficeStyles();
        StyleTextPropertiesElement textProperties = stylesOfficeStyles.constructTextProperties();
        textProperties.setStyleUseWindowFontColorAttribute(Boolean.valueOf(true));
        TextStyleFactory.setFontSizeProperties((StyleTextPropertiesElement)textProperties, (String)"7pt");
        TextStyleFactory.setFontNameProperties((StyleTextPropertiesElement)textProperties, (String)"Arial1");
        return stylesOfficeStyles.getParagraphStyleWithParent(footerStyle, new OdfStylePropertiesBase[]{textProperties});
    }

    private String constructStandardStyle(OdfContext context) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleTextPropertiesElement textProperties = TextStyleFactory.constructFontTextProperties((Styles)stylesOfficeStyles, (String)"Arial", (String)"Arial", (String)"11pt", (String)"Regular", (String)"swiss", (String)"variable");
        return stylesOfficeStyles.getParagraphStyle("Standard", "text", new OdfStylePropertiesBase[]{textProperties});
    }

    private String constructSubjectStyle(OdfContext context, String parentStyle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleTextPropertiesElement properties = stylesOfficeStyles.constructTextProperties();
        properties.setFoFontWeightAttribute("bold");
        return stylesOfficeStyles.getParagraphStyleWithParent(parentStyle, "text", new OdfStylePropertiesBase[]{properties});
    }

    private String constructAddressStyle(OdfContext context, String parentStyle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleParagraphPropertiesElement properties = stylesOfficeStyles.constructParagraphProperties();
        ParagraphStyleFactory.setMarginAttributes((StyleParagraphPropertiesElement)properties, null, null, (String)"0cm", (String)"0.106cm");
        ParagraphStyleFactory.setLineAttributes((StyleParagraphPropertiesElement)properties, (Boolean)false, (Integer)0);
        return stylesOfficeStyles.getParagraphStyleWithParent(parentStyle, "extra", new OdfStylePropertiesBase[]{properties});
    }

    private String constructFrameGraphicStyle(OdfContext context) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleGraphicPropertiesElement properties = stylesOfficeStyles.constructGraphicProperties();
        properties.setTextAnchorTypeAttribute("paragraph");
        GraphicStyleFactory.setMarginRelatedAttributes((StyleGraphicPropertiesElement)properties, (String)"0.201cm", (String)"0.15cm", (String)"0.06pt solid #000000");
        GraphicStyleFactory.setPositionAttributes((StyleGraphicPropertiesElement)properties, (String)"top", (String)"paragraph-content", (String)"center", (String)"paragraph-content");
        GraphicStyleFactory.setWrapRelatedAttributes((StyleGraphicPropertiesElement)properties, (String)"parallel", null, (Boolean)false);
        GraphicStyleFactory.setSvgPositionAttributes((StyleGraphicPropertiesElement)properties, (String)"0cm", (String)"0cm");
        properties.setStyleWrapAttribute("parallel");
        return stylesOfficeStyles.getGraphicStyle("Frame", new OdfStylePropertiesBase[]{properties});
    }

    private String constructGraphicsStyle(OdfContext odfContext) {
        Styles stylesOfficeStyles = odfContext.getStylesOfficeStyles();
        StyleGraphicPropertiesElement properties = stylesOfficeStyles.constructGraphicProperties();
        properties.setTextAnchorTypeAttribute("paragraph");
        GraphicStyleFactory.setPositionAttributes((StyleGraphicPropertiesElement)properties, (String)"top", (String)"paragraph", (String)"center", (String)"paragraph");
        GraphicStyleFactory.setWrapRelatedAttributes((StyleGraphicPropertiesElement)properties, (String)"dynamic", null, (Boolean)false);
        GraphicStyleFactory.setSvgPositionAttributes((StyleGraphicPropertiesElement)properties, (String)"0cm", (String)"0cm");
        return stylesOfficeStyles.getGraphicStyle("Graphics", new OdfStylePropertiesBase[]{properties});
    }

    private String constructHeaderStyle(OdfContext odfContext, String standardStyle) {
        Styles stylesOfficeStyles = odfContext.getStylesOfficeStyles();
        StyleParagraphPropertiesElement paragraphProperties = stylesOfficeStyles.constructParagraphProperties();
        ParagraphStyleFactory.setLineAttributes((StyleParagraphPropertiesElement)paragraphProperties, (Boolean)false, (Integer)0);
        ParagraphStyleFactory.addTabStops((StyleParagraphPropertiesElement)paragraphProperties, (Pair[])new Pair[]{new Pair((Object)"8.5cm", (Object)"center"), new Pair((Object)"17cm", (Object)"right")});
        StyleTextPropertiesElement textProperties = stylesOfficeStyles.constructTextProperties();
        textProperties.setFoColorAttribute("#999999");
        TextStyleFactory.setFontSizeProperties((StyleTextPropertiesElement)textProperties, (String)"7pt");
        return stylesOfficeStyles.getParagraphStyleWithParent(standardStyle, "extra", new OdfStylePropertiesBase[]{paragraphProperties, textProperties});
    }

    private void generateDestinationAddressBlock(GenerationContext generationContext) {
        OrganisationPerson createdForOrgPerson = generationContext.getCreatedForOrgPerson();
        Person createdForPerson = generationContext.getCreatedForPerson();
        Organisation createdForOrganisation = generationContext.getCreatedForOrganisation();
        Country createdForCountry = generationContext.getCreatedForCountry();
        OfficeTextElement officeText = generationContext.getOfficeText();
        ResourceBundle resourceBundle = generationContext.getResourceBundle();
        OdfContext odfContext = generationContext.getOdfContext();
        String standardStyle = generationContext.getStandardStyle();
        String frameStyle = generationContext.getFrameStyle();
        String addressTextStyle = generationContext.getAddressTextStyle();
        TextPElement destAddressTopNode = TextFactory.constructTextNode((Node)officeText, null, (String)standardStyle);
        String destAddressGraphicStyle = this.constructDestAddressGraphicStyle(odfContext, frameStyle);
        DrawFrameElement destAddressdrawFrameElement = FrameFactory.constructDrawFrameNode((Node)destAddressTopNode, (String)destAddressGraphicStyle, (String)"paragraph", null, null, (String)"11.389cm", null, (Integer)0);
        DrawTextBoxElement destAddressTextBoxElement = TextFactory.constructTextBox((Node)destAddressdrawFrameElement, (String)"3.127cm");
        OdfAddressHelper.generateAddressBlock((OdfElement)destAddressTextBoxElement, resourceBundle, odfContext, addressTextStyle, createdForOrgPerson, createdForOrganisation, createdForPerson, createdForCountry);
    }

    private String constructDestAddressGraphicStyle(OdfContext context, String parentStyle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleGraphicPropertiesElement graphicProperties = stylesOfficeStyles.constructGraphicProperties();
        GraphicStyleFactory.setMarginRelatedAttributes((StyleGraphicPropertiesElement)graphicProperties, (String)"0cm", (String)"0cm", (String)"none");
        GraphicStyleFactory.setPositionAttributes((StyleGraphicPropertiesElement)graphicProperties, (String)"top", (String)"page-content", (String)"left", (String)"page-content");
        GraphicStyleFactory.setBackgroundColorAttributes((StyleGraphicPropertiesElement)graphicProperties, (String)"transparent", (String)"100%");
        GraphicStyleFactory.setWrapRelatedAttributes((StyleGraphicPropertiesElement)graphicProperties, (String)"none", null, null);
        GraphicStyleFactory.setShadowAttributes((StyleGraphicPropertiesElement)graphicProperties, (String)"none", (String)"100%");
        GraphicStyleFactory.appendColumnsAttribute((StyleGraphicPropertiesElement)graphicProperties, (Integer)1, (String)"0cm");
        return stylesOfficeStyles.getGraphicStyleWithParent(parentStyle, new OdfStylePropertiesBase[]{graphicProperties});
    }

    private String constructDestAddressTextStyle(OdfContext context, String parentStyle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleParagraphPropertiesElement paragraphProperties = stylesOfficeStyles.constructParagraphProperties();
        ParagraphStyleFactory.setMarginAttributes((StyleParagraphPropertiesElement)paragraphProperties, null, null, (String)"0cm", (String)"0cm");
        StyleTextPropertiesElement textProperties = stylesOfficeStyles.constructTextProperties();
        TextStyleFactory.setFontSizeProperties((StyleTextPropertiesElement)textProperties, (String)"10pt", (String)"10pt", (String)"10pt");
        return stylesOfficeStyles.getParagraphStyleWithParent(parentStyle, new OdfStylePropertiesBase[]{paragraphProperties, textProperties});
    }

    private void generateSourceAddressLogoBlock(GenerationContext generationContext) {
        OrganisationPerson createdByOrgPerson = generationContext.getCreatedByOrgPerson();
        Person createdByPerson = generationContext.getCreatedByPerson();
        Organisation createdByOrganisation = generationContext.getCreatedByOrganisation();
        Country createdByCountry = generationContext.getCreatedByCountry();
        OfficeTextElement officeText = generationContext.getOfficeText();
        ResourceBundle resourceBundle = generationContext.getResourceBundle();
        OdfContext odfContext = generationContext.getOdfContext();
        String standardStyle = generationContext.getStandardStyle();
        String frameStyle = generationContext.getFrameStyle();
        String addressStyle = generationContext.getAddressStyle();
        String graphicsStyle = generationContext.getGraphicsStyle();
        String addressTextStyle = generationContext.getAddressTextStyle();
        TextPElement sourceAddressBlockTopNode = TextFactory.constructTextNode((Node)officeText, null, (String)standardStyle);
        String sourceAddressLogoGraphicStyle = this.constructSourceAddressLogoGraphicStyle(odfContext, frameStyle);
        String sourceAddressBlockTextStyle = this.constructSourceAddressBlockTextStyle(odfContext, addressStyle);
        String logoGraphicStyle = this.constructLogoGraphicStyle(odfContext, graphicsStyle);
        String cdesAdministrationSourceLabel = resourceBundle.getString("cdesAdministrationSourceLabel");
        DrawFrameElement sourceAddressBlockDrawFrameElement = FrameFactory.constructDrawFrameNode((Node)sourceAddressBlockTopNode, (String)sourceAddressLogoGraphicStyle, (String)"paragraph", (String)"0cm", (String)"0.388cm", (String)"11.442cm", null, (Integer)1);
        DrawTextBoxElement sourceAddressBlockTextBoxElement = TextFactory.constructTextBox((Node)sourceAddressBlockDrawFrameElement, (String)"3.512cm");
        TextPElement sourceAddressLogoElement = TextFactory.constructTextNode((Node)sourceAddressBlockTextBoxElement, null, (String)sourceAddressBlockTextStyle);
        DrawFrameElement logoFrameElement = FrameFactory.constructDrawFrameNode((Node)sourceAddressLogoElement, (String)logoGraphicStyle, (String)"paragraph", (String)"13.259cm", (String)"0.021cm", (String)"2.923cm", (String)"1.436cm", (Integer)2);
        if (this.enableCustomerLogo.booleanValue()) {
            ImageFactory.constructImage((Node)logoFrameElement, (ClassLoader)this.getClass().getClassLoader(), (String)"export/oebbInfraLogo.tif");
        }
        TextFactory.appendSimpleTextNode((Node)sourceAddressLogoElement, (String)cdesAdministrationSourceLabel);
        OdfAddressHelper.generateAddressBlock((OdfElement)sourceAddressBlockTextBoxElement, resourceBundle, odfContext, addressTextStyle, createdByOrgPerson, createdByOrganisation, createdByPerson, createdByCountry);
    }

    private String constructSourceAddressLogoGraphicStyle(OdfContext context, String parentStyle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleGraphicPropertiesElement graphicProperties = stylesOfficeStyles.constructGraphicProperties();
        GraphicStyleFactory.setMarginRelatedAttributes((StyleGraphicPropertiesElement)graphicProperties, (String)"0cm", (String)"0cm", (String)"none");
        GraphicStyleFactory.setPositionAttributes((StyleGraphicPropertiesElement)graphicProperties, (String)"from-top", (String)"paragraph", (String)"from-left", (String)"paragraph");
        GraphicStyleFactory.setWrapRelatedAttributes((StyleGraphicPropertiesElement)graphicProperties, (String)"none", null, null);
        GraphicStyleFactory.setShadowAttributes((StyleGraphicPropertiesElement)graphicProperties, (String)"none", (String)"100%");
        return stylesOfficeStyles.getGraphicStyleWithParent(parentStyle, new OdfStylePropertiesBase[]{graphicProperties});
    }

    private String constructLogoGraphicStyle(OdfContext context, String parentStyle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleGraphicPropertiesElement graphicProperties = stylesOfficeStyles.constructGraphicProperties();
        GraphicStyleFactory.setPositionAttributes((StyleGraphicPropertiesElement)graphicProperties, (String)"from-top", (String)"paragraph", (String)"from-left", (String)"paragraph");
        graphicProperties.setStyleMirrorAttribute("none");
        graphicProperties.setFoClipAttribute("rect(0cm, 0cm, 0cm, 0cm)");
        GraphicStyleFactory.setColorAttributes((StyleGraphicPropertiesElement)graphicProperties, (String)"standard", (String)"0%", (String)"0%", (String)"0%", (String)"100%", (Boolean)false, (String)"0%", (String)"0%", (String)"100%");
        return stylesOfficeStyles.getGraphicStyleWithParent(parentStyle, new OdfStylePropertiesBase[]{graphicProperties});
    }

    private String constructSourceAddressBlockTextStyle(OdfContext context, String parentStyle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleTextPropertiesElement textProperties = stylesOfficeStyles.constructTextProperties();
        TextStyleFactory.setFontSizeProperties((StyleTextPropertiesElement)textProperties, (String)"10pt", (String)"10pt", (String)"10pt");
        return stylesOfficeStyles.getParagraphStyleWithParent(parentStyle, new OdfStylePropertiesBase[]{textProperties});
    }

    private void generatePleaseSendBlock(GenerationContext generationContext) {
        OrganisationPerson createdByOrgPerson = generationContext.getCreatedByOrgPerson();
        OfficeTextElement officeText = generationContext.getOfficeText();
        ResourceBundle resourceBundle = generationContext.getResourceBundle();
        OdfContext odfContext = generationContext.getOdfContext();
        String standardStyle = generationContext.getStandardStyle();
        String pleaseSendTextStyle = this.constructPleaseSendTextStyle(odfContext, standardStyle);
        String pleaseSendLabel = resourceBundle.getString("certificateRequestPdfPleaseSendLabel");
        TextFactory.constructTextNode((Node)officeText, (String)pleaseSendLabel, (String)pleaseSendTextStyle);
        String facsimileLabelRaw = resourceBundle.getString("facsimileLabel");
        String facsimileLabel = MessageFormat.format(facsimileLabelRaw, createdByOrgPerson.getFacsimileTelephoneNumber() != null ? createdByOrgPerson.getFacsimileTelephoneNumber() : "-");
        TextFactory.constructTextNode((Node)officeText, (String)facsimileLabel, (String)pleaseSendTextStyle);
        String emailLabelRaw = resourceBundle.getString("emailLabel");
        String emailLabel = MessageFormat.format(emailLabelRaw, createdByOrgPerson.getEmailAddress() != null ? createdByOrgPerson.getEmailAddress() : "-");
        TextFactory.constructTextNode((Node)officeText, (String)emailLabel, (String)pleaseSendTextStyle);
    }

    private String constructPleaseSendTextStyle(OdfContext context, String parentStyle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleTextPropertiesElement textProperties = stylesOfficeStyles.constructTextProperties();
        TextStyleFactory.setFontWeightProperties((StyleTextPropertiesElement)textProperties, (String)"bold", (String)"bold", (String)"bold");
        return stylesOfficeStyles.getParagraphStyleWithParent(parentStyle, new OdfStylePropertiesBase[]{textProperties});
    }

    private void generateSubjectSection(GenerationContext generationContext) {
        OfficeTextElement officeText = generationContext.getOfficeText();
        ResourceBundle resourceBundle = generationContext.getResourceBundle();
        OdfContext odfContext = generationContext.getOdfContext();
        String subjectStyle = generationContext.getSubjectStyle();
        String cdesLabelStyle = generationContext.getCdesLabelStyle();
        String subjectSectionParagraphStyle = this.constructSubjectSectionParagraphStyle(odfContext, subjectStyle);
        HashMap dataMap = new HashMap();
        HashMap<String, String> styleMap = new HashMap<String, String>();
        styleMap.put("cdesLabelStyle", cdesLabelStyle);
        TextPElement subjectSectionNode = TextFactory.constructTextNode((Node)officeText, null, (String)subjectSectionParagraphStyle);
        CompositeTextFactory.appendCompositeText((Node)subjectSectionNode, (ResourceBundle)resourceBundle, (String)"certificateRequestSubjectLabel", dataMap, styleMap);
    }

    private String constructSubjectSectionParagraphStyle(OdfContext context, String parentStyle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleParagraphPropertiesElement paragraphProperties = stylesOfficeStyles.constructParagraphProperties();
        ParagraphStyleFactory.addTabStops((StyleParagraphPropertiesElement)paragraphProperties, (String[])new String[]{"1.614cm"});
        return stylesOfficeStyles.getParagraphStyleWithParent(parentStyle, new OdfStylePropertiesBase[]{paragraphProperties});
    }

    private void generateConfirmationSection(GenerationContext generationContext) {
        CertificateRequest certificateRequest = generationContext.getCertificateRequest();
        OfficeTextElement officeText = generationContext.getOfficeText();
        ResourceBundle resourceBundle = generationContext.getResourceBundle();
        OdfContext odfContext = generationContext.getOdfContext();
        String standardStyle = generationContext.getStandardStyle();
        String cdesLabelStyle = generationContext.getCdesLabelStyle();
        String confirmationSectionTextStyle = this.constructConfirmationSectionTextStyle(odfContext, standardStyle);
        String challengeStyle = TextStyleFactory.constructTextStyleWithFontName((OdfContext)odfContext, (String)"Courier New");
        String requestDateString = this.getRequestDateString(certificateRequest);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("challenge1", certificateRequest.getChallenge1());
        dataMap.put("requestDate", requestDateString);
        HashMap<String, String> styleMap = new HashMap<String, String>();
        styleMap.put("challengeStyle", challengeStyle);
        styleMap.put("cdesLabelStyle", cdesLabelStyle);
        TextPElement confirmationSectionNode = TextFactory.constructTextNode((Node)officeText, null, (String)confirmationSectionTextStyle);
        CompositeTextFactory.appendCompositeText((Node)confirmationSectionNode, (ResourceBundle)resourceBundle, (String)"certificateRequestConfirmation", dataMap, styleMap);
    }

    private String constructConfirmationSectionTextStyle(OdfContext context, String parentStyle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleTextPropertiesElement textProperties = stylesOfficeStyles.constructTextProperties();
        TextStyleFactory.setFontNameProperties((StyleTextPropertiesElement)textProperties, (String)"Arial1");
        return stylesOfficeStyles.getParagraphStyleWithParent(parentStyle, new OdfStylePropertiesBase[]{textProperties});
    }

    private String getRequestDateString(CertificateRequest certificateRequest) {
        if (certificateRequest.getRequestDatetime() != null) {
            UtcTimestamp utcTimestamp = new UtcTimestamp(ThreadLocalManager.getLoginTimeZone(), (long)(certificateRequest.getRequestDatetime() * 1000.0));
            return utcTimestamp.toString(ISO8601Format.DATE_FORMAT);
        }
        return null;
    }

    private void generateOwnSignatureTableSection(GenerationContext generationContext) {
        OfficeTextElement officeText = generationContext.getOfficeText();
        ResourceBundle resourceBundle = generationContext.getResourceBundle();
        OdfContext odfContext = generationContext.getOdfContext();
        String standardStyle = generationContext.getStandardStyle();
        String headerStyle = generationContext.getHeaderStyle();
        String signatureTextStyle = generationContext.getSignatureTextStyle();
        OrganisationPerson createdForOrgPerson = generationContext.getCreatedForOrgPerson();
        Person createdForPerson = generationContext.getCreatedForPerson();
        CertificateRequest certificateRequest = generationContext.getCertificateRequest();
        Styles stylesOfficeAutomaticStyles = odfContext.getContentAutomaticStyles();
        String ownSignatureTableStyle = TableStyleFactory.constructTableStyle((OdfContext)odfContext, (String)"16.478cm", (String)"0.014cm", (String)"left", (String)"lr-tb");
        TableTableElement tableElement = TableFactory.constructTableElement((Node)officeText, (String)ownSignatureTableStyle);
        TableFactory.appendColumnWithAbsoluteSize((Styles)stylesOfficeAutomaticStyles, (TableTableElement)tableElement, (String)"10.382cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)stylesOfficeAutomaticStyles, (TableTableElement)tableElement, (String)"6.096cm");
        TableTableRowElement row = tableElement.newTableTableRowElement();
        String locationTableCellStyle = this.constructLocationCellStyle(odfContext);
        String locationStringRaw = resourceBundle.getString("certificateRequestLocation");
        String localityName = createdForOrgPerson.getLocalityName();
        String requestDateString = this.getRequestDateString(certificateRequest);
        String locationString = MessageFormat.format(locationStringRaw, localityName, requestDateString);
        TableFactory.appendCell((String)locationTableCellStyle, (String)standardStyle, (TableTableRowElement)row, (String[])new String[]{locationString});
        String signatureTableCellStyle = this.constructSignatureTableCellStyle(odfContext);
        String signatureNameTextStyle = this.constructSignatureNameTextStyle(odfContext, headerStyle);
        TableTableCellElement signatureTableCellElement = TableFactory.appendCellStyledCell((String)signatureTableCellStyle, (TableTableRowElement)row, (String[])new String[0]);
        String signatureLabel = resourceBundle.getString("certificateRequestSignature");
        TextFactory.constructTextNode((Node)signatureTableCellElement, (String)signatureLabel, (String)signatureTextStyle);
        TextFactory.appendEmptyTextNodes((Node)signatureTableCellElement, (String)signatureTextStyle, (int)3);
        String titleWithCommonName = PersonHelper.getCommonNameWithTitle(resourceBundle, createdForPerson);
        TextFactory.constructTextNode((Node)signatureTableCellElement, (String)titleWithCommonName, (String)signatureNameTextStyle);
    }

    private String constructLocationCellStyle(OdfContext odfContext) {
        Styles stylesOfficeAutomaticStyles = odfContext.getContentAutomaticStyles();
        StyleTableCellPropertiesElement tableCellProperties = stylesOfficeAutomaticStyles.constructTableCellPropertiesWithPaddingAndBorders("0.123cm", "0.05pt solid #000000", "0.123cm", "none", "0cm", "0.05pt solid #000000", "0cm", "0.05pt solid #000000");
        tableCellProperties.setStyleVerticalAlignAttribute("top");
        return stylesOfficeAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{tableCellProperties});
    }

    private String constructSignatureTableCellStyle(OdfContext odfContext) {
        Styles stylesOfficeAutomaticStyles = odfContext.getContentAutomaticStyles();
        StyleTableCellPropertiesElement tableCellProperties = stylesOfficeAutomaticStyles.constructTableCellPropertiesWithPaddingAndBorders("0.123cm", "0.05pt solid #000000", "0.123cm", "0.05pt solid #000000", "0cm", "0.05pt solid #000000", "0cm", "0.05pt solid #000000");
        tableCellProperties.setStyleVerticalAlignAttribute("top");
        return stylesOfficeAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{tableCellProperties});
    }

    private String constructSignatureTextStyle(OdfContext odfContext, String standardStyle) {
        Styles stylesOfficeStyles = odfContext.getStylesOfficeStyles();
        StyleParagraphPropertiesElement paragraphProperties = stylesOfficeStyles.constructParagraphPropertiesWithTextAlign("center", Boolean.valueOf(false));
        StyleTextPropertiesElement textProperties = stylesOfficeStyles.constructTextProperties();
        TextStyleFactory.setFontNameProperties((StyleTextPropertiesElement)textProperties, (String)"Arial1");
        return stylesOfficeStyles.getParagraphStyleWithParent(standardStyle, new OdfStylePropertiesBase[]{paragraphProperties, textProperties});
    }

    private String constructSignatureNameTextStyle(OdfContext odfContext, String headerStyle) {
        Styles stylesOfficeStyles = odfContext.getStylesOfficeStyles();
        StyleParagraphPropertiesElement paragraphProperties = stylesOfficeStyles.constructParagraphPropertiesWithTextAlign("center", Boolean.valueOf(false));
        StyleTextPropertiesElement textProperties = stylesOfficeStyles.constructTextProperties();
        TextStyleFactory.setFontNameProperties((StyleTextPropertiesElement)textProperties, (String)"Arial1");
        TextStyleFactory.setFontSizeProperties((StyleTextPropertiesElement)textProperties, (String)"9pt");
        textProperties.setFoLanguageAttribute("en");
        return stylesOfficeStyles.getParagraphStyleWithParent(headerStyle, new OdfStylePropertiesBase[]{paragraphProperties, textProperties});
    }

    private void generateAdminSignatureTableSection(GenerationContext generationContext) {
        OfficeTextElement officeText = generationContext.getOfficeText();
        ResourceBundle resourceBundle = generationContext.getResourceBundle();
        OdfContext odfContext = generationContext.getOdfContext();
        String standardStyle = generationContext.getStandardStyle();
        String headerStyle = generationContext.getHeaderStyle();
        String signatureTextStyle = generationContext.getSignatureTextStyle();
        OrganisationPerson createdByOrgPerson = generationContext.getCreatedByOrgPerson();
        Person createdByPerson = generationContext.getCreatedByPerson();
        Styles stylesOfficeAutomaticStyles = odfContext.getContentAutomaticStyles();
        String adminSignatureTableStyle = TableStyleFactory.constructTableStyle((OdfContext)odfContext, (String)"16.478cm", (String)"0.014cm", (String)"left", (String)"lr-tb");
        TableTableElement tableElement = TableFactory.constructTableElement((Node)officeText, (String)adminSignatureTableStyle);
        TableFactory.appendColumnWithAbsoluteSize((Styles)stylesOfficeAutomaticStyles, (TableTableElement)tableElement, (String)"7.216cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)stylesOfficeAutomaticStyles, (TableTableElement)tableElement, (String)"3.166cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)stylesOfficeAutomaticStyles, (TableTableElement)tableElement, (String)"6.096cm");
        TableTableRowElement row = tableElement.newTableTableRowElement();
        String adminLocationTableCellStyle = this.constructAdminLocationCellStyle(odfContext);
        String issueString = resourceBundle.getString("certificateRequestIssue");
        String locationStringRaw = resourceBundle.getString("certificateRequestLocation");
        String localityName = createdByOrgPerson.getLocalityName();
        String locationString = MessageFormat.format(locationStringRaw, localityName, "");
        TableFactory.appendCell((String)adminLocationTableCellStyle, (String)standardStyle, (TableTableRowElement)row, (String[])new String[]{issueString, locationString});
        String serialNumberString = resourceBundle.getString("certificateRequestSerialNumber");
        TableFactory.appendCell((String)adminLocationTableCellStyle, (String)standardStyle, (TableTableRowElement)row, (String[])new String[]{serialNumberString});
        String adminSignatureTableCellStyle = this.constructAdminSignatureTableCellStyle(odfContext);
        TableTableCellElement signatureTableCellElement = TableFactory.appendCellStyledCell((String)adminSignatureTableCellStyle, (TableTableRowElement)row, (String[])new String[0]);
        String signatureLabel = resourceBundle.getString("certificateRequestSignature");
        TextFactory.constructTextNode((Node)signatureTableCellElement, (String)signatureLabel, (String)signatureTextStyle);
        TextFactory.appendEmptyTextNodes((Node)signatureTableCellElement, (String)signatureTextStyle, (int)3);
        String signaturePersonTextStyle = this.constructSignaturePersonTextStyle(odfContext, headerStyle);
        String signaturePersonCommonName = PersonHelper.getCommonName(createdByPerson);
        TextFactory.constructTextNode((Node)signatureTableCellElement, (String)signaturePersonCommonName, (String)signaturePersonTextStyle);
    }

    private String constructAdminLocationCellStyle(OdfContext odfContext) {
        Styles stylesOfficeAutomaticStyles = odfContext.getContentAutomaticStyles();
        StyleTableCellPropertiesElement tableCellProperties = stylesOfficeAutomaticStyles.constructTableCellPropertiesWithPaddingAndBorders("0.123cm", "0.05pt solid #000000", "0.123cm", "none", "0cm", "0.05pt solid #000000", "0cm", "0.05pt solid #000000");
        tableCellProperties.setStyleVerticalAlignAttribute("top");
        tableCellProperties.setFoBackgroundColorAttribute("#e6e6e6");
        return stylesOfficeAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{tableCellProperties});
    }

    private String constructAdminSignatureTableCellStyle(OdfContext odfContext) {
        Styles stylesOfficeAutomaticStyles = odfContext.getContentAutomaticStyles();
        StyleTableCellPropertiesElement tableCellProperties = stylesOfficeAutomaticStyles.constructTableCellPropertiesWithPaddingAndBorders("0.123cm", "0.05pt solid #000000", "0.123cm", "0.05pt solid #000000", "0cm", "0.05pt solid #000000", "0cm", "0.05pt solid #000000");
        tableCellProperties.setStyleVerticalAlignAttribute("top");
        tableCellProperties.setFoBackgroundColorAttribute("#e6e6e6");
        return stylesOfficeAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{tableCellProperties});
    }

    private String constructSignaturePersonTextStyle(OdfContext odfContext, String headerStyle) {
        Styles stylesOfficeStyles = odfContext.getStylesOfficeStyles();
        StyleParagraphPropertiesElement paragraphProperties = stylesOfficeStyles.constructParagraphPropertiesWithTextAlign("center", Boolean.valueOf(false));
        StyleTextPropertiesElement textProperties = stylesOfficeStyles.constructTextProperties();
        TextStyleFactory.setFontSizeProperties((StyleTextPropertiesElement)textProperties, (String)"9pt");
        return stylesOfficeStyles.getParagraphStyleWithParent(headerStyle, new OdfStylePropertiesBase[]{paragraphProperties, textProperties});
    }

    private static class GenerationContext {
        private OdfTextDocument document;
        private ResourceBundle resourceBundle;
        private CertificateRequestPersonJoin certificateRequestPersonJoin;
        private OfficeTextElement officeText;
        private OdfContext odfContext;
        private String standardStyle;
        private String subjectStyle;
        private String headerStyle;
        private String frameStyle;
        private String addressStyle;
        private String graphicsStyle;
        private String addressTextStyle;
        private String cdesLabelStyle;
        private String signatureTextStyle;

        private GenerationContext(OdfTextDocument document, ResourceBundle resourceBundle, CertificateRequestPersonJoin certificateRequestPersonJoin, OfficeTextElement officeText, OdfContext odfContext, String standardStyle, String subjectStyle, String headerStyle, String frameStyle, String addressStyle, String graphicsStyle, String addressTextStyle, String cdesLabelStyle, String signatureTextStyle) {
            this.document = document;
            this.resourceBundle = resourceBundle;
            this.certificateRequestPersonJoin = certificateRequestPersonJoin;
            this.officeText = officeText;
            this.odfContext = odfContext;
            this.standardStyle = standardStyle;
            this.subjectStyle = subjectStyle;
            this.headerStyle = headerStyle;
            this.frameStyle = frameStyle;
            this.addressStyle = addressStyle;
            this.graphicsStyle = graphicsStyle;
            this.addressTextStyle = addressTextStyle;
            this.cdesLabelStyle = cdesLabelStyle;
            this.signatureTextStyle = signatureTextStyle;
        }

        private OdfTextDocument getDocument() {
            return this.document;
        }

        private ResourceBundle getResourceBundle() {
            return this.resourceBundle;
        }

        private CertificateRequestPersonJoin getCertificateRequestPersonJoin() {
            return this.certificateRequestPersonJoin;
        }

        private CertificateRequest getCertificateRequest() {
            return this.getCertificateRequestPersonJoin().getCertificateRequest();
        }

        private OrganisationPerson getCreatedForOrgPerson() {
            return this.getCertificateRequestPersonJoin().getCreatedForOrgPerson();
        }

        private Person getCreatedForPerson() {
            return this.getCertificateRequestPersonJoin().getCreatedForPerson();
        }

        private Organisation getCreatedForOrganisation() {
            return this.getCertificateRequestPersonJoin().getCreatedForOrganisation();
        }

        private Country getCreatedForCountry() {
            return this.getCertificateRequestPersonJoin().getCreatedForCountry();
        }

        private OrganisationPerson getCreatedByOrgPerson() {
            return this.getCertificateRequestPersonJoin().getCreatedByOrgPerson();
        }

        private Person getCreatedByPerson() {
            return this.getCertificateRequestPersonJoin().getCreatedByPerson();
        }

        private Organisation getCreatedByOrganisation() {
            return this.getCertificateRequestPersonJoin().getCreatedByOrganisation();
        }

        private Country getCreatedByCountry() {
            return this.getCertificateRequestPersonJoin().getCreatedByCountry();
        }

        private OfficeTextElement getOfficeText() {
            return this.officeText;
        }

        private OdfContext getOdfContext() {
            return this.odfContext;
        }

        private String getStandardStyle() {
            return this.standardStyle;
        }

        private String getSubjectStyle() {
            return this.subjectStyle;
        }

        private String getHeaderStyle() {
            return this.headerStyle;
        }

        private String getFrameStyle() {
            return this.frameStyle;
        }

        private String getAddressStyle() {
            return this.addressStyle;
        }

        private String getGraphicsStyle() {
            return this.graphicsStyle;
        }

        private String getAddressTextStyle() {
            return this.addressTextStyle;
        }

        private String getCdesLabelStyle() {
            return this.cdesLabelStyle;
        }

        private String getSignatureTextStyle() {
            return this.signatureTextStyle;
        }
    }
}

