/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Country;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.OrderAddress;
import at.cdes.impl.dao.GenOrderAddressDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcOrderAddressDAO
extends AbstrIdDAO<OrderAddress>
implements GenOrderAddressDAO {
    public AbstractJdbcOrderAddressDAO() {
        super(OrderAddress.class, "id", "order_address", new String[]{"id", "commonName", "givenName", "surName", "gender", "title", "postalAddress", "postalCode", "localityName", "country_id", "organisationName", "organisationalUnitName", "client_code", "type", "network_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcOrderAddressDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "commonName") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "givenName") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "surName") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "gender") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "title") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "postalAddress") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "postalCode") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "localityName") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "country_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisationName") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisationalUnitName") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "client_code") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "type") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcOrderAddressDAO.getSelectClauseForDto("order_address", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcOrderAddressDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".commonName" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "commonName") + "," + entityLocalName + ".givenName" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "givenName") + "," + entityLocalName + ".surName" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "surName") + "," + entityLocalName + ".gender" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "gender") + "," + entityLocalName + ".title" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "title") + "," + entityLocalName + ".postalAddress" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "postalAddress") + "," + entityLocalName + ".postalCode" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "postalCode") + "," + entityLocalName + ".localityName" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "localityName") + "," + entityLocalName + ".country_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "country_id") + "," + entityLocalName + ".organisationName" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisationName") + "," + entityLocalName + ".organisationalUnitName" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisationalUnitName") + "," + entityLocalName + ".client_code" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "client_code") + "," + entityLocalName + ".type" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "type") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + " ";
    }

    protected OrderAddress fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        OrderAddress orderAddress = new OrderAddress();
        orderAddress.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderAddress.setCommonName(rs.getString(++columnIndex));
        orderAddress.setGivenName(rs.getString(++columnIndex));
        orderAddress.setSurName(rs.getString(++columnIndex));
        orderAddress.setGender(rs.getString(++columnIndex));
        orderAddress.setTitle(rs.getString(++columnIndex));
        orderAddress.setPostalAddress(rs.getString(++columnIndex));
        orderAddress.setPostalCode(rs.getString(++columnIndex));
        orderAddress.setLocalityName(rs.getString(++columnIndex));
        orderAddress.setCountryId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderAddress.setOrganisationName(rs.getString(++columnIndex));
        orderAddress.setOrganisationalUnitName(rs.getString(++columnIndex));
        orderAddress.setClientCode(rs.getString(++columnIndex));
        orderAddress.setType(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        orderAddress.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return orderAddress;
    }

    public static OrderAddress fillOrderAddressFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        OrderAddress orderAddress = new OrderAddress();
        orderAddress.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        orderAddress.setCommonName(rs.getString(columnIndex.incrementAndGet()));
        orderAddress.setGivenName(rs.getString(columnIndex.incrementAndGet()));
        orderAddress.setSurName(rs.getString(columnIndex.incrementAndGet()));
        orderAddress.setGender(rs.getString(columnIndex.incrementAndGet()));
        orderAddress.setTitle(rs.getString(columnIndex.incrementAndGet()));
        orderAddress.setPostalAddress(rs.getString(columnIndex.incrementAndGet()));
        orderAddress.setPostalCode(rs.getString(columnIndex.incrementAndGet()));
        orderAddress.setLocalityName(rs.getString(columnIndex.incrementAndGet()));
        orderAddress.setCountryId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        orderAddress.setOrganisationName(rs.getString(columnIndex.incrementAndGet()));
        orderAddress.setOrganisationalUnitName(rs.getString(columnIndex.incrementAndGet()));
        orderAddress.setClientCode(rs.getString(columnIndex.incrementAndGet()));
        orderAddress.setType(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        orderAddress.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return orderAddress;
    }

    public static OrderAddress fillOrderAddressFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcOrderAddressDAO.fillOrderAddressFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 15;
    }

    public int update(OrderAddress dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<OrderAddress> dtos) {
        Iterator<OrderAddress> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, OrderAddress orderAddress) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)orderAddress.getId());
        statement.setString(2, orderAddress.getCommonName());
        statement.setString(3, orderAddress.getGivenName());
        statement.setString(4, orderAddress.getSurName());
        statement.setString(5, orderAddress.getGender());
        statement.setString(6, orderAddress.getTitle());
        statement.setString(7, orderAddress.getPostalAddress());
        statement.setString(8, orderAddress.getPostalCode());
        statement.setString(9, orderAddress.getLocalityName());
        JDBCHelper.setLong((PreparedStatement)statement, (int)10, (Number)orderAddress.getCountryId());
        statement.setString(11, orderAddress.getOrganisationName());
        statement.setString(12, orderAddress.getOrganisationalUnitName());
        statement.setString(13, orderAddress.getClientCode());
        JDBCHelper.setInt((PreparedStatement)statement, (int)14, (Number)orderAddress.getType());
        JDBCHelper.setLong((PreparedStatement)statement, (int)15, (Number)orderAddress.getNetworkId());
    }

    @Override
    public List<OrderAddress> getByCountry(Country country) {
        return this.getByCountry(country.getId());
    }

    @Override
    public List<OrderAddress> getByCountry(final Long countryId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"country_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, countryId);
            }
        });
    }

    @Override
    public List<OrderAddress> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<OrderAddress> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<OrderAddress> getByCountrys(Collection<Long> countryId) {
        if (countryId.isEmpty()) {
            return new ArrayList<OrderAddress>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[countryId.size()];
        int n = 0;
        Iterator<Long> it = countryId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"country_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<OrderAddress> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<OrderAddress>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

