/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.planning;

import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.MetaTag;
import at.cdes.api.dto.PersonVariables;
import at.cdes.api.guiService.PlanningNotificationService;
import at.cdes.api.guiService.UtilService;
import at.cdes.api.job.core.JobHandle;
import at.cdes.api.joinDto.PlanningNotificationReportJoin;
import at.cdes.api.planning.compositeDto.FlatReportInfo;
import at.cdes.api.planning.compositeDto.PlanningNotificationReportColumnSettings;
import at.cdes.api.planning.compositeDto.PlanningNotificationReportExportInfo;
import at.cdes.api.planning.compositeDto.PlanningNotificationReportInfo;
import at.cdes.api.planning.voc.PlanningNotificationReportType;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.api.voc.job.JobType;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.MetaTagDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.export.planning.CellTextStyles;
import at.cdes.impl.export.planning.PlanningReportHelper;
import at.cdes.impl.export.planning.PlanningReportLocalStyles;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.job.core.JobRegistry;
import at.cdes.impl.job.util.JobHelper;
import at.cdes.impl.planning.PlanningReportResult;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfConversionHandle;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanningReportXlsExporter {
    private ActionDAO actionDAO;
    private JobRegistry jobRegistry;
    private String odfStylePrefix;
    private MetaTagDAO metaTagDAO;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private PlanningNotificationService planningNotificationService;
    private String tempDirName;
    private PersonVariablesDAO personVariablesDAO;
    private UtilService utilService;
    private static final Logger log = LoggerFactory.getLogger(PlanningReportXlsExporter.class);

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setMetaTagDAO(MetaTagDAO metaTagDAO) {
        this.metaTagDAO = metaTagDAO;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setPlanningNotificationService(PlanningNotificationService planningNotificationService) {
        this.planningNotificationService = planningNotificationService;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlanningReportResult export(String cdesUuid, PlanningNotificationReportExportInfo exportInfo) throws Exception {
        try {
            final OdfConversionHandle conversionHandle = new OdfConversionHandle();
            JobHandle jobHandle = new JobHandle(){

                public void destroy() {
                    conversionHandle.destroy();
                }
            };
            JobHelper.registerCallableJob(this.jobRegistry, JobType.EXPORT_XLS_REPORT, exportInfo.getOrganisationPersonId(), exportInfo.getNetworkId(), null, cdesUuid, jobHandle);
            CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
            Long personId = loginPrincipal.getPersonId();
            List<PersonVariables> personVariablesList = this.personVariablesDAO.getByPerson(personId);
            PersonVariables personVariables = personVariablesList.get(0);
            ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariables.getUserLocale());
            OdfSpreadsheetDocument document = DocumentFactory.constructSpreadsheetDocument((String)"export/emptyOdsTemplate.ods", PlanningReportXlsExporter.class, (Locale)ThreadLocalManager.getLoginLocale());
            OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
            PlanningReportLocalStyles localStyles = this.constructLocalStyles(context);
            PlanningReportResult planningReportResult = this.doExport(document, context, localStyles, exportInfo);
            String xlsxFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"PlanningNotificationReportXls", (OdfSpreadsheetDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.MSEXCEL_2007_XML, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.REPORT.getValue(), null);
            ExportResult exportResult = OdfHelper.constructExportResult(xlsxFileName);
            String tmpFileName = exportResult.getTmpFileName();
            ScratchFile scratchFile = new ScratchFile(new File(tmpFileName), "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "attachment; filename*=UTF-8''" + (exportInfo.getFileName() != null ? exportInfo.getFileName() + ".xlsx" : tmpFileName));
            planningReportResult.setScratchFile(scratchFile);
            PlanningReportResult planningReportResult2 = planningReportResult;
            return planningReportResult2;
        }
        finally {
            this.jobRegistry.clearJob(cdesUuid);
        }
    }

    private PlanningReportResult doExport(OdfSpreadsheetDocument document, OdfContext context, PlanningReportLocalStyles localStyles, PlanningNotificationReportExportInfo exportInfo) {
        ArrayList<ColumnSortSpec> columnSortSpecs;
        List metaTags = this.metaTagDAO.getAll();
        HashMap<Long, MetaTag> idToMetaTag = new HashMap<Long, MetaTag>();
        for (MetaTag metaTag : metaTags) {
            idToMetaTag.put(metaTag.getId(), metaTag);
        }
        if (exportInfo.getSortSpecs() != null && exportInfo.getType() != PlanningNotificationReportType.ALL) {
            columnSortSpecs = ColumnSortSpec.getFromClient((List)exportInfo.getSortSpecs());
            PlanningReportHelper.convertReportColumnSortSpecsFromClientToServer(columnSortSpecs, idToMetaTag);
        } else {
            columnSortSpecs = new ArrayList<ColumnSortSpec>();
            columnSortSpecs.add(new ColumnSortSpec("Dokumentendatum", Boolean.valueOf(false)));
            columnSortSpecs.add(new ColumnSortSpec("serialNumber", Boolean.valueOf(false)));
        }
        PlanningNotificationReportColumnSettings columnSettings = exportInfo.getColumnSettings();
        boolean duplicateRows = PlanningReportHelper.duplicateRows(columnSettings);
        List<FlatReportInfo> flatReportInfos = PlanningReportHelper.getFlatReportInfos(this.planningNotificationService, exportInfo, this.actionDAO, duplicateRows);
        HashSet<Long> planningNotificationIdSet = new HashSet<Long>();
        HashSet<Long> workflowEntityIdSet = new HashSet<Long>();
        for (FlatReportInfo flatReportInfo : flatReportInfos) {
            planningNotificationIdSet.add(flatReportInfo.getReportInfo().getReportJoin().getPlanningNotificationId());
            workflowEntityIdSet.add(flatReportInfo.getReportInfo().getReportJoin().getWorkflowEntityId());
        }
        ArrayList<Long> planningNotificationIds = new ArrayList<Long>();
        ArrayList<Long> workflowEntityIds = new ArrayList<Long>();
        planningNotificationIds.addAll(planningNotificationIdSet);
        workflowEntityIds.addAll(workflowEntityIdSet);
        List tableElements = document.getTables();
        TableTableElement tableElement = (TableTableElement)tableElements.get(0);
        TableFactory.cleanTableElementBeforeUsage((TableTableElement)tableElement);
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        Styles contentOfficeStyles = context.getStylesOfficeStyles();
        Map<String, Double> relativeColumnWidths = PlanningReportHelper.getFlatReportColumnWidths(metaTags, columnSettings);
        List columns = PlanningReportHelper.constructFlatReportColumns(localStyles, metaTags, columnSettings, exportInfo.getType() == PlanningNotificationReportType.ALL, this.utilService, contentAutomaticStyles);
        FancyOdfTable table = PlanningReportXlsExporter.constructFancyTable(contentAutomaticStyles, localStyles, null, columns, relativeColumnWidths);
        table.setDataRowStyle(contentOfficeStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentOfficeStyles.constructTableRowPropertiesWithOptimalRowHeight()}));
        if (log.isDebugEnabled()) {
            for (FlatReportInfo flatReportInfo : flatReportInfos) {
                PlanningNotificationReportInfo reportInfo = flatReportInfo.getReportInfo();
                if (reportInfo == null) {
                    log.debug("FlatReportInfo with reportInfo == null detected.");
                    continue;
                }
                PlanningNotificationReportJoin reportJoin = reportInfo.getReportJoin();
                if (reportJoin == null) {
                    log.debug("FlatReportInfo with reportJoin == null detected.");
                    continue;
                }
                log.debug("Will render FlatReportInfo for orderId [" + reportJoin.getPlanningNotificationOrderWorkflowEntityId() + "] and serialNumber [" + reportJoin.getPlanningNotificationOrderSerialNumber() + "]");
            }
        }
        table.renderIntoTableElement(tableElement, flatReportInfos, columnSortSpecs, true);
        PlanningReportResult planningReportResult = new PlanningReportResult();
        planningReportResult.setPlanningNotificationIds(planningNotificationIds);
        planningReportResult.setWorkflowEntityIds(workflowEntityIds);
        return planningReportResult;
    }

    private static <T> FancyOdfTable<T> constructFancyTable(Styles styles, PlanningReportLocalStyles localStyles, Double width, List<FancyOdfTableColumn<T>> columns, Map<String, Double> absoluteColumnWidths) {
        String headerCellStyle = localStyles.getHeaderCellStyle();
        String headerTextStyle = localStyles.getHeaderTextStyle();
        String dataCellStyle = localStyles.getDataCellStyle();
        String dataTextStyle = localStyles.getNormalDataTextStyle();
        String dataRowStyle = localStyles.getDataRowStyle();
        FancyOdfTable table = new FancyOdfTable(styles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, width, null, columns);
        table.setDataRowStyle(dataRowStyle);
        table.setAbsoluteColumnWidths(absoluteColumnWidths);
        return table;
    }

    private PlanningReportLocalStyles constructLocalStyles(OdfContext context) {
        PlanningReportLocalStyles localStyles = new PlanningReportLocalStyles();
        Styles automaticStyles = context.getContentAutomaticStyles();
        Styles officeStyles = context.getStylesOfficeStyles();
        String standardParagraphStyle = this.constructStandardParagraphStyle(officeStyles);
        localStyles.setStandardParagraphStyle(standardParagraphStyle);
        String headerCellStyle = automaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{automaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000")});
        localStyles.setHeaderCellStyle(headerCellStyle);
        String headerTextStyle = automaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{automaticStyles.constructTextPropertiesWithColorAndFont("#000000", "Arial", "8pt", "bold")});
        localStyles.setHeaderTextStyle(headerTextStyle);
        StyleTableCellPropertiesElement tableCellProperties = automaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        tableCellProperties.setFoWrapOptionAttribute("wrap");
        String dataCellStyle = automaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{tableCellProperties});
        localStyles.setDataCellStyle(dataCellStyle);
        String dataTextStyle = automaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{automaticStyles.constructTextPropertiesWithColorAndFont("#000000", "Arial", "9pt", null)});
        String invalidatedDataTextStyle = automaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{automaticStyles.constructTextPropertiesWithColorAndFont("#BBBBBB", "Arial", "9pt", null)});
        String dataRowStyle = automaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{automaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        localStyles.setDataRowStyle(dataRowStyle);
        String dataCaptionTextStyle = officeStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{officeStyles.constructTextPropertiesWithColorAndFont("#000000", "Arial", "9pt", "bold")});
        String invalidatedDataCaptionTextStyle = officeStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{officeStyles.constructTextPropertiesWithColorAndFont("#BBBBBB", "Arial", "9pt", "bold")});
        String dataItalicTextStyle = officeStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{officeStyles.constructTextPropertiesWithColorAndFont("#000000", "Arial", "9pt", "italic")});
        String invalidatedDataItalicTextStyle = officeStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{officeStyles.constructTextPropertiesWithColorAndFont("#BBBBBB", "Arial", "9pt", "italic")});
        String dataRedTextStyle = officeStyles.getTextStyle(new OdfStylePropertiesBase[]{officeStyles.constructTextPropertiesWithColorAndFont("#FF0000", "Arial", "9pt", null)});
        String invalidatedDataRedTextStyle = officeStyles.getTextStyle(new OdfStylePropertiesBase[]{officeStyles.constructTextPropertiesWithColorAndFont("#BBBBBB", "Arial", "9pt", null)});
        localStyles.setNormalCellTextStyles(new CellTextStyles(dataTextStyle, null, dataItalicTextStyle, dataCaptionTextStyle, dataRedTextStyle));
        localStyles.setInvalidatedCellTextStyles(new CellTextStyles(invalidatedDataTextStyle, null, invalidatedDataItalicTextStyle, invalidatedDataCaptionTextStyle, invalidatedDataRedTextStyle));
        return localStyles;
    }

    public String constructStandardParagraphStyle(Styles context) {
        return context.getParagraphStyle("StandardParagraphStyle", "text", new OdfStylePropertiesBase[]{PlanningReportXlsExporter.constructStandardParagraphProperties(context), PlanningReportXlsExporter.constructStandardTextProperties(context)});
    }

    public static StyleParagraphPropertiesElement constructStandardParagraphProperties(Styles context) {
        StyleParagraphPropertiesElement paragraphProperties = context.constructParagraphProperties();
        paragraphProperties.setStyleLineHeightAtLeastAttribute("0.423cm");
        paragraphProperties.setFoTextAlignAttribute("start");
        paragraphProperties.setStyleJustifySingleWordAttribute(Boolean.valueOf(false));
        paragraphProperties.setFoOrphansAttribute(Integer.valueOf(2));
        paragraphProperties.setFoWidowsAttribute(Integer.valueOf(2));
        paragraphProperties.setStyleWritingModeAttribute("lr-tb");
        return paragraphProperties;
    }

    public static StyleTextPropertiesElement constructStandardTextProperties(Styles context) {
        StyleTextPropertiesElement textProperties = context.constructTextProperties();
        textProperties.setFoColorAttribute("#00000a");
        textProperties.setStyleUseWindowFontColorAttribute(Boolean.valueOf(true));
        textProperties.setStyleFontNameAttribute("Arial");
        textProperties.setFoFontFamilyAttribute("Arial");
        textProperties.setStyleFontFamilyGenericAttribute("roman");
        textProperties.setStyleFontPitchAttribute("variable");
        textProperties.setFoFontSizeAttribute("10pt");
        textProperties.setFoLanguageAttribute("de");
        textProperties.setFoCountryAttribute("DE");
        textProperties.setFoHyphenateAttribute(Boolean.valueOf(false));
        textProperties.setFoHyphenationRemainCharCountAttribute(Integer.valueOf(2));
        textProperties.setFoHyphenationPushCharCountAttribute(Integer.valueOf(2));
        return textProperties;
    }
}

