/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.plot;

import at.cdes.impl.plot.BoundingBox;
import at.cdes.impl.plot.LengthUnit;

public class LengthCalculator {
    public static double getMetricFactor(LengthUnit u) {
        switch (u) {
            default: {
                return 1.0;
            }
            case DECIMETER: {
                return 0.1;
            }
            case CENTIMETER: {
                return 0.01;
            }
            case MILLIMETER: {
                return 0.001;
            }
            case INCH: {
                return 0.0254;
            }
            case PT: 
        }
        return 3.5277777777777776E-4;
    }

    public static double convertUnit(double x, LengthUnit from, LengthUnit to) {
        return x * LengthCalculator.getMetricFactor(from) / LengthCalculator.getMetricFactor(to);
    }

    public static double convertSquareUnit(double x, LengthUnit from, LengthUnit to) {
        return x * Math.pow(LengthCalculator.getMetricFactor(from) / LengthCalculator.getMetricFactor(to), 2.0);
    }

    public static String getUnitLabel(LengthUnit u) {
        switch (u) {
            default: {
                return "m";
            }
            case DECIMETER: {
                return "dm";
            }
            case CENTIMETER: {
                return "cm";
            }
            case MILLIMETER: {
                return "mm";
            }
            case INCH: {
                return "inch";
            }
            case PT: 
        }
        return "pt";
    }

    public static String getSquareUnitLabel(LengthUnit u) {
        return LengthCalculator.getUnitLabel(u) + "\u00b2";
    }

    public static Double getBBoxWidth(BoundingBox bbox, LengthUnit u) {
        if (bbox.getUrx() == null || bbox.getLlx() == null) {
            return null;
        }
        return LengthCalculator.convertUnit(bbox.getUrx() - bbox.getLlx(), LengthUnit.PT, u);
    }

    public static Double getBBoxHeight(BoundingBox bbox, LengthUnit u) {
        if (bbox.getUry() == null || bbox.getLly() == null) {
            return null;
        }
        return LengthCalculator.convertUnit(bbox.getUry() - bbox.getLly(), LengthUnit.PT, u);
    }

    public static Double getBBoxArea(BoundingBox bbox, LengthUnit u) {
        Double w = LengthCalculator.getBBoxWidth(bbox, u);
        Double h = LengthCalculator.getBBoxHeight(bbox, u);
        if (w == null || h == null) {
            return null;
        }
        return w * h;
    }

    public static Double getPaperFormatSquareSize(String din, LengthUnit u) {
        if (din == null) {
            return null;
        }
        if (din.equals("A0")) {
            return LengthCalculator.convertSquareUnit(1.0, LengthUnit.METER, u);
        }
        if (din.equals("A1")) {
            return LengthCalculator.convertSquareUnit(0.5, LengthUnit.METER, u);
        }
        if (din.equals("A2")) {
            return LengthCalculator.convertSquareUnit(0.25, LengthUnit.METER, u);
        }
        if (din.equals("A3")) {
            return LengthCalculator.convertSquareUnit(0.125, LengthUnit.METER, u);
        }
        if (din.equals("A4")) {
            return LengthCalculator.convertSquareUnit(0.0625, LengthUnit.METER, u);
        }
        return null;
    }

    public static Double getPaperFormatHeigth(String din, LengthUnit u) {
        if (din == null) {
            return null;
        }
        if (din.equals("A0")) {
            return LengthCalculator.convertUnit(1.189, LengthUnit.METER, u);
        }
        if (din.equals("A1")) {
            return LengthCalculator.convertUnit(0.841, LengthUnit.METER, u);
        }
        if (din.equals("A2")) {
            return LengthCalculator.convertUnit(0.594, LengthUnit.METER, u);
        }
        if (din.equals("A3")) {
            return LengthCalculator.convertUnit(0.42, LengthUnit.METER, u);
        }
        if (din.equals("A4")) {
            return LengthCalculator.convertUnit(0.297, LengthUnit.METER, u);
        }
        return null;
    }

    public static Double getPaperFormatWidth(String din, LengthUnit u) {
        if (din == null) {
            return null;
        }
        if (din.equals("A0")) {
            return LengthCalculator.convertUnit(0.841, LengthUnit.METER, u);
        }
        if (din.equals("A1")) {
            return LengthCalculator.convertUnit(0.594, LengthUnit.METER, u);
        }
        if (din.equals("A2")) {
            return LengthCalculator.convertUnit(0.42, LengthUnit.METER, u);
        }
        if (din.equals("A3")) {
            return LengthCalculator.convertUnit(0.297, LengthUnit.METER, u);
        }
        if (din.equals("A4")) {
            return LengthCalculator.convertUnit(0.21, LengthUnit.METER, u);
        }
        return null;
    }
}

