/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.person;

import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.Project;
import at.cdes.api.joinDto.PersonJoin;
import at.cdes.api.person.compositeDto.PersonInfo;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.api.voc.person.PersonStatus;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.export.person.ExportPersonHelper;
import at.cdes.impl.export.person.PersonListOrganisationRow;
import at.cdes.impl.export.person.PersonListProjectRow;
import at.cdes.impl.export.person.PersonListRow;
import at.cdes.impl.export.planning.CellTextStyles;
import at.cdes.impl.service.ChallengeLoginServiceImpl;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class PersonListExporter {
    private String odfStylePrefix;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private String tempDirName;
    private PersonVariablesDAO personVariablesDAO;
    private static final Logger log = LoggerFactory.getLogger(PersonListExporter.class);

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    private static CellTextStyles constructInvalidatedTextStyles(String standardParagraphStyle, Styles contentAutomaticStyles) {
        String dataCaptionTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "bold")});
        String dataBoldTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "bold")});
        String dataItalicTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "italic")});
        String dataRedTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", null)});
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", null)});
        return new CellTextStyles(dataTextStyle, dataBoldTextStyle, dataItalicTextStyle, dataCaptionTextStyle, dataRedTextStyle);
    }

    public ScratchFile export(PersonInfo personInfo, Boolean showDetails, Map<String, Double> columnToWidth, List<ColumnSortSpec> columnSortSpecs, boolean enableCustomerLogo) throws Exception {
        ResourceBundle resourceBundle = PersonHelper.getResourceBundleByPrincipal(this.personVariablesDAO);
        Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        columnToWidth.put("phone", columnToWidth.get("organisation"));
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyLandscapeTemplate.odt", ChallengeLoginServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        OfficeTextElement officeText = document.getContentRoot();
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        OdfHelper.constructHeader(context, document, standardParagraphStyle, null, enableCustomerLogo);
        String leftFooterLabelRaw = resourceBundle.getString("personListFooterPrefix");
        OdfHelper.constructFooter(context, document, standardParagraphStyle, leftFooterLabelRaw);
        StyleTextPropertiesElement personsHeaderProperties = contentAutomaticStyles.constructTextProperties();
        personsHeaderProperties.setStyleFontNameAttribute("Arial");
        personsHeaderProperties.setFoFontFamilyAttribute("Arial");
        TextHElement textHElement = officeText.newTextHElement(2);
        textHElement.setTextContent(resourceBundle.getString("personListExportCaption"));
        officeText.newTextPElement();
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000")});
        String headerTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "8pt", "bold")});
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000")});
        StyleTableCellPropertiesElement withoutMarginProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.0cm", "0.05pt solid #000000");
        withoutMarginProperties.setFoPaddingLeftAttribute("0.097cm");
        withoutMarginProperties.setFoPaddingRightAttribute("0.097cm");
        String dataCellStyleWithoutMargin = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{withoutMarginProperties});
        StyleTableCellPropertiesElement innerWithBordersProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.15cm", "0.05pt solid #000000");
        innerWithBordersProperties.setFoPaddingRightAttribute("0.097cm");
        String innerWithBordersDataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{innerWithBordersProperties});
        StyleTableCellPropertiesElement innerWithoutBordersSectionProperties = contentAutomaticStyles.constructTableCellProperties();
        innerWithoutBordersSectionProperties.setFoBackgroundColorAttribute("#ffffff");
        innerWithoutBordersSectionProperties.setFoPaddingBottomAttribute("0.12cm");
        innerWithoutBordersSectionProperties.setFoPaddingRightAttribute("0.15cm");
        String innerWithoutBordersSectionStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{innerWithoutBordersSectionProperties});
        StyleTableCellPropertiesElement innerWithoutBordersProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.0cm", null);
        innerWithoutBordersProperties.setFoPaddingRightAttribute("0.097cm");
        String innerWithoutBordersDataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{innerWithoutBordersProperties});
        CellTextStyles normalTextStyles = OdfHelper.constructNormalTextStyles(standardParagraphStyle, contentAutomaticStyles);
        CellTextStyles invalidatedTextStyles = PersonListExporter.constructInvalidatedTextStyles(standardParagraphStyle, contentAutomaticStyles);
        StyleTableRowPropertiesElement properties = contentAutomaticStyles.constructTableRowProperties();
        properties.setFoKeepTogetherAttribute("auto");
        String dataRowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{properties});
        Collection persons = personInfo.getPersons();
        Map rawPersonIdToOrganisationJoins = personInfo.getPersonIdToOrganisationJoins();
        Map<Long, List<PersonJoin>> personIdToOrganisationJoins = this.getOrganisationJoinMapSorted(collator, rawPersonIdToOrganisationJoins);
        HashMap<Long, String> opIdToOPSortString = new HashMap<Long, String>();
        HashMap<Long, String> personIdToSortString = new HashMap<Long, String>();
        this.deriveSortStrings(opIdToOPSortString, personIdToSortString, persons, personIdToOrganisationJoins);
        StylesRegistry stylesRegistry = new StylesRegistry();
        stylesRegistry.setInnerWithBordersCellStyle(innerWithBordersDataCellStyle);
        stylesRegistry.setInnerWithoutBordersSectionCellStyle(innerWithoutBordersSectionStyle);
        stylesRegistry.setInnerWithoutBordersCellStyle(innerWithoutBordersDataCellStyle);
        List<PersonListRow> rows = this.calculateRows(personInfo);
        FancyOdfTable<PersonListRow> odfTable = this.constructPersonTable(resourceBundle, collator, showDetails, stylesRegistry, opIdToOPSortString, personIdToSortString, contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataRowStyle, dataCellStyleWithoutMargin, normalTextStyles, invalidatedTextStyles, columnToWidth);
        odfTable.setDataRowStyle(dataRowStyle);
        odfTable.render((Node)officeText, rows, columnSortSpecs);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_Personenliste_", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        return new ScratchFile(new File(tmpFileName), "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private List<PersonListRow> calculateRows(PersonInfo personInfo) {
        ArrayList<PersonListRow> personListRows = new ArrayList<PersonListRow>();
        Collection persons = personInfo.getPersons();
        Map personIdToOrganisationJoins = personInfo.getPersonIdToOrganisationJoins();
        Map organisationPersonIdToProjects = personInfo.getOrganisationPersonIdToProjects();
        Map organisationPersonIdToProjectIdToRoleJoins = personInfo.getOrganisationPersonIdToProjectIdToRoleJoins();
        Map organisationIdToNetworks = personInfo.getOrganisationIdToNetworks();
        for (Person person : persons) {
            Long personId = person.getId();
            Collection organisationJoinsCollection = personIdToOrganisationJoins.containsKey(personId) ? (Collection)personIdToOrganisationJoins.get(personId) : new ArrayList();
            ArrayList organisationJoins = new ArrayList();
            organisationJoins.addAll(organisationJoinsCollection);
            ArrayList<PersonListOrganisationRow> organisationRows = new ArrayList<PersonListOrganisationRow>();
            for (PersonJoin organisationJoin : organisationJoins) {
                PersonListOrganisationRow organisationRow = new PersonListOrganisationRow();
                organisationRow.setOrganisationJoin(organisationJoin);
                ArrayList<PersonListProjectRow> projectRows = new ArrayList<PersonListProjectRow>();
                Long organisationPersonId = organisationJoin.getOrganisationPersonId();
                Collection projectsCollection = organisationPersonIdToProjects.containsKey(organisationPersonId) ? (Collection)organisationPersonIdToProjects.get(organisationPersonId) : new ArrayList();
                for (Project project : projectsCollection) {
                    PersonListProjectRow projectRow = new PersonListProjectRow();
                    projectRow.setProject(project);
                    Long projectId = project.getId();
                    Map projectIdToRoleJoins = (Map)organisationPersonIdToProjectIdToRoleJoins.get(organisationPersonId);
                    ArrayList roleJoinsCollection = projectIdToRoleJoins != null && projectIdToRoleJoins.containsKey(projectId) ? (Collection)projectIdToRoleJoins.get(projectId) : new ArrayList();
                    ArrayList<PersonJoin> roleJoins = new ArrayList<PersonJoin>();
                    roleJoins.addAll(roleJoinsCollection);
                    projectRow.setRoleJoins(roleJoins);
                    projectRows.add(projectRow);
                }
                organisationRow.setProjectRows(projectRows);
                organisationRows.add(organisationRow);
            }
            PersonListRow row = new PersonListRow();
            row.setPerson(person);
            row.setOrganisationRows(organisationRows);
            HashSet<Long> networkIds = new HashSet<Long>();
            for (PersonJoin organisationJoin : organisationJoins) {
                Long organisationId = organisationJoin.getOrganisationId();
                Collection networks = (Collection)organisationIdToNetworks.get(organisationId);
                if (networks == null) continue;
                for (Network network : networks) {
                    Long networkId = network.getId();
                    networkIds.add(networkId);
                }
            }
            row.setNetworkIds(networkIds);
            personListRows.add(row);
        }
        return personListRows;
    }

    private FancyOdfTable<PersonListRow> constructPersonTable(final ResourceBundle resourceBundle, final Collator collator, final Boolean showDetails, final StylesRegistry stylesRegistry, Map<Long, String> opIdToOPSortString, Map<Long, String> personIdToSortString, final Styles contentAutomaticStyles, final String headerCellStyle, final String headerTextStyle, final String dataCellStyle, final String dataRowStyle, final String dataCellStyleWithoutMargin, final CellTextStyles normalCellTextStyles, final CellTextStyles invalidatedCellTextStyles, Map<String, Double> relativeColumnWidths) {
        ArrayList<FancyOdfTableColumn> columns = new ArrayList<FancyOdfTableColumn>();
        columns.add(new FancyOdfTableColumn<PersonListRow>("name", resourceBundle.getString("personListNameColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PersonListRow row) {
                CellTextStyles cellTextStyles = PersonListExporter.getCellTextStyles(row, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(row)});
            }

            public int compare(PersonListRow rowOne, PersonListRow rowTwo, boolean descending) {
                String nameOne = this.getOutput(rowOne);
                String nameTwo = this.getOutput(rowTwo);
                return (descending ? -1 : 1) * collator.compare(nameOne, nameTwo);
            }

            private String getOutput(PersonListRow row) {
                Person person = row.getPerson();
                return PersonHelper.getInverseCommonName(person);
            }
        });
        String organisationCaptionKey = showDetails != null && showDetails != false ? "personListOrganisationWithProjectsColumnCaption" : "personListOrganisationColumnCaption";
        columns.add(new FancyOdfTableColumn<PersonListRow>("organisation", resourceBundle.getString(organisationCaptionKey)){

            public void appendCell(TableTableRowElement rowElement, PersonListRow row) {
                CellTextStyles cellTextStyles = PersonListExporter.getCellTextStyles(row, normalCellTextStyles, invalidatedCellTextStyles);
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyleWithoutMargin, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement);
                List<PersonListOrganisationRow> organisationRows = row.getOrganisationRows();
                PersonListExporter.this.renderOrganisationCellTable(resourceBundle, collator, (OdfElement)cellElement, row, organisationRows, stylesRegistry, showDetails, contentAutomaticStyles, headerCellStyle, headerTextStyle, dataRowStyle, normalCellTextStyles, invalidatedCellTextStyles);
            }

            public int compare(PersonListRow rowOne, PersonListRow rowTwo, boolean descending) {
                String sortStringOne = this.getSortString(rowOne);
                String sortStringTwo = this.getSortString(rowTwo);
                return (descending ? -1 : 1) * collator.compare(sortStringOne, sortStringTwo);
            }

            private String getSortString(PersonListRow row) {
                String sortString = "";
                List<PersonListOrganisationRow> organisationRows = row.getOrganisationRows();
                for (PersonListOrganisationRow organisationRow : organisationRows) {
                    PersonJoin organisationJoin = organisationRow.getOrganisationJoin();
                    sortString = sortString + PersonListExporter.getNonNullString(organisationJoin.getOrganisationName());
                    if (organisationJoin.getOrganisationPersonOrganisationalUnitName() == null || organisationJoin.getOrganisationPersonOrganisationalUnitName().trim().length() <= 0) continue;
                    sortString = sortString + "(" + organisationJoin.getOrganisationPersonOrganisationalUnitName().trim() + ") ";
                }
                return sortString;
            }
        });
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        String dataTextStyle = normalCellTextStyles.getDataTextStyle();
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, Double.valueOf(23.9), relativeColumnWidths, columns);
        table.setDataRowStyle(rowStyle);
        return table;
    }

    private void deriveSortStrings(Map<Long, String> personIdToOPSortString, Map<Long, String> personIdToSortString, Collection<Person> persons, Map<Long, List<PersonJoin>> personIdToOrganisationJoins) {
        for (Person person : persons) {
            String personSortString = "";
            Long personId = person.getId();
            List<PersonJoin> organisationJoins = personIdToOrganisationJoins.get(personId);
            for (PersonJoin organisationJoin : organisationJoins) {
                String sortString = "";
                sortString = sortString + PersonListExporter.getNonNullString(organisationJoin.getOrganisationName()) + " ";
                String postalAddress = PersonListExporter.getNonNullString(organisationJoin.getOrganisationPostalAddress());
                String postalCode = PersonListExporter.getNonNullString(organisationJoin.getOrganisationPostalCode());
                String localityName = PersonListExporter.getNonNullString(organisationJoin.getOrganisationLocalityName());
                String countryDescDe = PersonListExporter.getNonNullString(organisationJoin.getCountryDescDe());
                sortString = sortString + postalAddress + " ";
                sortString = sortString + postalCode + " " + localityName + " ";
                sortString = sortString + countryDescDe + " ";
                Long organisationPersonId = organisationJoin.getOrganisationPersonId();
                personIdToOPSortString.put(organisationPersonId, sortString);
                personSortString = personSortString + sortString;
            }
            personIdToSortString.put(personId, personSortString);
        }
    }

    private Map<Long, List<PersonJoin>> getOrganisationJoinMapSorted(Collator collator, Map<Long, Collection<PersonJoin>> personIdToOrganisationJoins) {
        HashMap<Long, List<PersonJoin>> personIdToOrganisationJoinsSorted = new HashMap<Long, List<PersonJoin>>();
        for (Long personId : personIdToOrganisationJoins.keySet()) {
            Collection<PersonJoin> rawOrganisationJoins = personIdToOrganisationJoins.get(personId);
            List<PersonJoin> organisationJoinsSorted = this.getOrganisationJoinsSorted(collator, rawOrganisationJoins);
            personIdToOrganisationJoinsSorted.put(personId, organisationJoinsSorted);
        }
        return personIdToOrganisationJoinsSorted;
    }

    private List<PersonJoin> getOrganisationJoinsSorted(final Collator collator, Collection<PersonJoin> organisationJoins) {
        if (organisationJoins != null) {
            ArrayList<PersonJoin> organisationJoinsList = new ArrayList<PersonJoin>();
            organisationJoinsList.addAll(organisationJoins);
            Collections.sort(organisationJoinsList, new Comparator<PersonJoin>(){

                @Override
                public int compare(PersonJoin joinOne, PersonJoin joinTwo) {
                    String nameOne = joinOne.getOrganisationName() != null ? joinOne.getOrganisationName() : "";
                    String nameTwo = joinTwo.getOrganisationName() != null ? joinTwo.getOrganisationName() : "";
                    return collator.compare(nameOne, nameTwo);
                }
            });
            return organisationJoinsList;
        }
        return new ArrayList<PersonJoin>();
    }

    private static CellTextStyles getCellTextStyles(PersonListRow personListRow, CellTextStyles normalTextStyles, CellTextStyles invalidatedTextStyles) {
        Person person = personListRow.getPerson();
        Integer invalidated = person.getStatus();
        if (invalidated == null || invalidated.intValue() != PersonStatus.INVALID.getValue()) {
            return normalTextStyles;
        }
        return invalidatedTextStyles;
    }

    private static CellTextStyles getCellTextStyles(PersonListOrganisationRow organisationRow, CellTextStyles normalTextStyles, CellTextStyles invalidatedTextStyles) {
        PersonJoin organisationJoin = organisationRow.getOrganisationJoin();
        Boolean retired = organisationJoin.getOrganisationPersonRetiredFlag();
        if (!retired.booleanValue()) {
            return normalTextStyles;
        }
        return invalidatedTextStyles;
    }

    private static String getNonNullString(String s) {
        return s != null && s.trim().length() > 0 ? s.trim() : "---";
    }

    private void renderOrganisationCellTable(ResourceBundle resourceBundle, Collator collator, OdfElement parentElement, PersonListRow personListRow, List<PersonListOrganisationRow> organisationRows, StylesRegistry stylesRegistry, Boolean showDetails, Styles contentAutomaticStyles, String headerCellStyle, String headerTextStyle, String dataRowStyle, CellTextStyles normalTextStyles, CellTextStyles invalidatedTextStyles) {
        FancyOdfTable<PersonListOrganisationRow> odfTable = this.constructOrganisationTable(resourceBundle, collator, personListRow, stylesRegistry, showDetails, contentAutomaticStyles, headerCellStyle, headerTextStyle, normalTextStyles, invalidatedTextStyles);
        odfTable.setRenderHeaderLine(false);
        odfTable.setDataRowStyle(dataRowStyle);
        ArrayList<ColumnSortSpec> columnSortSpecs = new ArrayList<ColumnSortSpec>();
        columnSortSpecs.add(new ColumnSortSpec("organisation", Boolean.valueOf(false)));
        odfTable.render((Node)parentElement, organisationRows, columnSortSpecs);
    }

    private FancyOdfTable<PersonListOrganisationRow> constructOrganisationTable(final ResourceBundle resourceBundle, final Collator collator, final PersonListRow row, final StylesRegistry stylesRegistry, Boolean showDetails, final Styles contentAutomaticStyles, final String headerCellStyle, final String headerTextStyle, final CellTextStyles normalCellTextStyles, final CellTextStyles invalidatedCellTextStyles) {
        ArrayList<FancyOdfTableColumn> columns = new ArrayList<FancyOdfTableColumn>();
        columns.add(new FancyOdfTableColumn<PersonListOrganisationRow>("organisation", "TODO"){

            public void appendCell(TableTableRowElement rowElement, PersonListOrganisationRow organisationRow) {
                CellTextStyles cellTextStyles = PersonListExporter.getCellTextStyles(organisationRow, normalCellTextStyles, invalidatedCellTextStyles);
                PersonJoin organisationJoin = organisationRow.getOrganisationJoin();
                String cellStyle = stylesRegistry.getInnerWithBordersCellStyle();
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)cellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement);
                String organisationName = PersonListExporter.getNonNullString(organisationJoin.getOrganisationName());
                String postalAddress = PersonListExporter.getNonNullString(organisationJoin.getOrganisationPostalAddress());
                String postalCode = PersonListExporter.getNonNullString(organisationJoin.getOrganisationPostalCode());
                String localityName = PersonListExporter.getNonNullString(organisationJoin.getOrganisationLocalityName());
                String country = PersonListExporter.getNonNullString(organisationJoin.getCountryDescDe());
                TextPElement nameElement = TextFactory.constructTextNode((Node)cellElement, (String)"", (String)cellTextStyles.getDataBoldTextStyle());
                TextFactory.constructTextSpan((Node)nameElement, (String)organisationName, (String)cellTextStyles.getDataBoldTextStyle());
                ExportPersonHelper.addAddressBlock(cellElement, cellTextStyles.getDataTextStyle(), postalAddress, postalCode, localityName, country);
            }

            public int compare(PersonListOrganisationRow rowOne, PersonListOrganisationRow rowTwo, boolean descending) {
                PersonJoin joinOne = rowOne.getOrganisationJoin();
                PersonJoin joinTwo = rowTwo.getOrganisationJoin();
                String nameOne = joinOne.getOrganisationName() != null ? joinOne.getOrganisationName() : "";
                String nameTwo = joinTwo.getOrganisationName() != null ? joinTwo.getOrganisationName() : "";
                return (descending ? -1 : 1) * collator.compare(nameOne, nameTwo);
            }
        });
        columns.add(new FancyOdfTableColumn<PersonListOrganisationRow>("address", "TODO"){

            public void appendCell(TableTableRowElement rowElement, PersonListOrganisationRow organisationRow) {
                CellTextStyles cellTextStyles = PersonListExporter.getCellTextStyles(organisationRow, normalCellTextStyles, invalidatedCellTextStyles);
                PersonJoin organisationJoin = organisationRow.getOrganisationJoin();
                String cellStyle = stylesRegistry.getInnerWithBordersCellStyle();
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)cellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement);
                String opUnitName = PersonListExporter.getNonNullString(organisationJoin.getOrganisationPersonOrganisationalUnitName());
                String opPostalAddress = PersonListExporter.getNonNullString(organisationJoin.getOrganisationPersonPostalAddress());
                String opPostalCode = PersonListExporter.getNonNullString(organisationJoin.getOrganisationPersonPostalCode());
                String opLocalityName = PersonListExporter.getNonNullString(organisationJoin.getOrganisationPersonLocalityName());
                String opCountryDescDe = PersonListExporter.getNonNullString(organisationJoin.getOpCountryDescDe());
                String opMail = PersonListExporter.getNonNullString(organisationJoin.getOrganisationPersonEmailAddress());
                String opPhone = PersonListExporter.getNonNullString(organisationJoin.getOrganisationPersonTelephoneNumber());
                String opMobile = PersonListExporter.getNonNullString(organisationJoin.getOrganisationPersonMobileTelephoneNumber());
                String opFax = PersonListExporter.getNonNullString(organisationJoin.getOrganisationPersonFacsimileTelephoneNumber());
                ExportPersonHelper.addContactBlock(cellElement, cellTextStyles.getDataTextStyle(), resourceBundle, opUnitName, opPostalAddress, opPostalCode, opLocalityName, opCountryDescDe, opMail, opPhone, opMobile, opFax);
            }

            public int compare(PersonListOrganisationRow rowOne, PersonListOrganisationRow rowTwo, boolean descending) {
                return 0;
            }
        });
        if (showDetails != null && showDetails.booleanValue()) {
            columns.add(new FancyOdfTableColumn<PersonListOrganisationRow>("projects", "TODO"){

                public void appendCell(TableTableRowElement rowElement, PersonListOrganisationRow organisationRow) {
                    CellTextStyles cellTextStyles = PersonListExporter.getCellTextStyles(organisationRow, normalCellTextStyles, invalidatedCellTextStyles);
                    StyleTableCellPropertiesElement withoutMarginProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.0cm", "0.05pt solid #000000");
                    withoutMarginProperties.setFoPaddingLeftAttribute("0.097cm");
                    withoutMarginProperties.setFoPaddingRightAttribute("0.097cm");
                    String dataCellStyleWithoutMargin = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{withoutMarginProperties});
                    StyleTableCellPropertiesElement innerProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.0cm", null);
                    innerProperties.setFoPaddingRightAttribute("0.097cm");
                    String innerDataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{innerProperties});
                    StyleTableRowPropertiesElement properties = contentAutomaticStyles.constructTableRowProperties();
                    properties.setFoKeepTogetherAttribute("auto");
                    String dataRowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{properties});
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyleWithoutMargin, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement);
                    List<PersonListProjectRow> projectRows = organisationRow.getProjectRows();
                    PersonListExporter.this.renderProjectCellTable(resourceBundle, collator, (OdfElement)cellElement, row, projectRows, stylesRegistry, contentAutomaticStyles, headerCellStyle, headerTextStyle, dataRowStyle, normalCellTextStyles, invalidatedCellTextStyles);
                }

                public int compare(PersonListOrganisationRow rowOne, PersonListOrganisationRow rowTwo, boolean descending) {
                    return 0;
                }
            });
        }
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        HashMap<String, Double> relativeColumnWidths = new HashMap<String, Double>();
        relativeColumnWidths.put("organisation", 0.25);
        relativeColumnWidths.put("address", 0.25);
        relativeColumnWidths.put("projects", 0.5);
        String cellStyle = stylesRegistry.getInnerWithoutBordersCellStyle();
        String dataTextStyle = normalCellTextStyles.getDataTextStyle();
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, cellStyle, dataTextStyle, Double.valueOf(23.9), relativeColumnWidths, columns);
        table.setDataRowStyle(rowStyle);
        return table;
    }

    private void renderProjectCellTable(ResourceBundle resourceBundle, Collator collator, OdfElement parentElement, PersonListRow personListRow, List<PersonListProjectRow> rows, StylesRegistry stylesRegistry, Styles contentAutomaticStyles, String headerCellStyle, String headerTextStyle, String dataRowStyle, CellTextStyles normalTextStyles, CellTextStyles invalidatedTextStyles) {
        FancyOdfTable<PersonListProjectRow> odfTable = this.constructProjectTable(resourceBundle, collator, personListRow, stylesRegistry, contentAutomaticStyles, headerCellStyle, headerTextStyle, normalTextStyles, invalidatedTextStyles);
        odfTable.setRenderHeaderLine(false);
        odfTable.setDataRowStyle(dataRowStyle);
        ArrayList<ColumnSortSpec> columnSortSpecs = new ArrayList<ColumnSortSpec>();
        columnSortSpecs.add(new ColumnSortSpec("project", Boolean.valueOf(false)));
        odfTable.render((Node)parentElement, rows, columnSortSpecs);
    }

    private FancyOdfTable<PersonListProjectRow> constructProjectTable(ResourceBundle resourceBundle, final Collator collator, final PersonListRow personListRow, final StylesRegistry stylesRegistry, Styles contentAutomaticStyles, String headerCellStyle, String headerTextStyle, final CellTextStyles normalCellTextStyles, final CellTextStyles invalidatedCellTextStyles) {
        ArrayList<FancyOdfTableColumn> columns = new ArrayList<FancyOdfTableColumn>();
        columns.add(new FancyOdfTableColumn<PersonListProjectRow>("project", "TODO"){

            public void appendCell(TableTableRowElement rowElement, PersonListProjectRow row) {
                CellTextStyles cellTextStyles = PersonListExporter.getCellTextStyles(personListRow, normalCellTextStyles, invalidatedCellTextStyles);
                String cellStyle = stylesRegistry.getInnerWithoutBordersSectionCellStyle();
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)cellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement);
                String projectString = this.getOutput(row);
                TextFactory.constructTextNode((Node)cellElement, (String)projectString, (String)cellTextStyles.getDataTextStyle());
            }

            public int compare(PersonListProjectRow rowOne, PersonListProjectRow rowTwo, boolean descending) {
                String nameOne = this.getOutput(rowOne);
                String nameTwo = this.getOutput(rowTwo);
                return (descending ? -1 : 1) * collator.compare(nameOne, nameTwo);
            }

            private String getOutput(PersonListProjectRow row) {
                Project project = row.getProject();
                List<PersonJoin> roles = row.getRoleJoins();
                String code = PersonListExporter.getNonNullString(project.getCode());
                String name = PersonListExporter.getNonNullString(project.getName());
                String networkNameRaw = roles != null && roles.size() > 0 ? roles.get(0).getNetworkName() : null;
                String networkName = PersonListExporter.getNonNullString(networkNameRaw);
                String projectString = code + " " + name + " [" + networkName + "]";
                return projectString;
            }
        });
        columns.add(new FancyOdfTableColumn<PersonListProjectRow>("role", "TODO"){

            public void appendCell(TableTableRowElement rowElement, PersonListProjectRow row) {
                CellTextStyles cellTextStyles = PersonListExporter.getCellTextStyles(personListRow, normalCellTextStyles, invalidatedCellTextStyles);
                String cellStyle = stylesRegistry.getInnerWithoutBordersCellStyle();
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)cellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement);
                List<PersonJoin> roleJoins = row.getRoleJoins();
                Collections.sort(roleJoins, new Comparator<PersonJoin>(){

                    @Override
                    public int compare(PersonJoin joinOne, PersonJoin joinTwo) {
                        String roleOne = PersonListExporter.getNonNullString(joinOne.getCdesRoleName());
                        String surNameOne = PersonListExporter.getNonNullString(joinOne.getPersonSurName());
                        String givenNameOne = PersonListExporter.getNonNullString(joinOne.getPersonGivenName());
                        String roleTwo = PersonListExporter.getNonNullString(joinTwo.getCdesRoleName());
                        String surNameTwo = PersonListExporter.getNonNullString(joinTwo.getPersonSurName());
                        String givenNameTwo = PersonListExporter.getNonNullString(joinTwo.getPersonGivenName());
                        String s1 = roleOne + surNameOne + givenNameOne;
                        String s2 = roleTwo + surNameTwo + givenNameTwo;
                        return collator.compare(s1, s2);
                    }
                });
                for (PersonJoin roleJoin : roleJoins) {
                    String role = roleJoin.getCdesRoleName();
                    String surName = roleJoin.getMainPersonSurName();
                    String givenName = roleJoin.getMainPersonGivenName();
                    String roleString = role + " (" + surName + " " + givenName + ")";
                    TextFactory.constructTextNode((Node)cellElement, (String)roleString, (String)cellTextStyles.getDataTextStyle());
                }
            }

            public int compare(PersonListProjectRow rowOne, PersonListProjectRow rowTwo, boolean descending) {
                return 0;
            }
        });
        HashMap<String, Double> relativeColumnWidths = new HashMap<String, Double>();
        relativeColumnWidths.put("project", 0.5);
        relativeColumnWidths.put("role", 0.5);
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        String cellStyle = stylesRegistry.getInnerWithoutBordersCellStyle();
        String dataTextStyle = normalCellTextStyles.getDataTextStyle();
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, cellStyle, dataTextStyle, Double.valueOf(23.9), relativeColumnWidths, columns);
        table.setDataRowStyle(rowStyle);
        return table;
    }

    private class StylesRegistry {
        private String innerWithBordersCellStyle;
        private String innerWithoutBordersSectionCellStyle;
        private String innerWithoutBordersCellStyle;

        private StylesRegistry() {
        }

        public String getInnerWithBordersCellStyle() {
            return this.innerWithBordersCellStyle;
        }

        public void setInnerWithBordersCellStyle(String innerWithBordersCellStyle) {
            this.innerWithBordersCellStyle = innerWithBordersCellStyle;
        }

        public String getInnerWithoutBordersSectionCellStyle() {
            return this.innerWithoutBordersSectionCellStyle;
        }

        public void setInnerWithoutBordersSectionCellStyle(String innerWithoutBordersSectionCellStyle) {
            this.innerWithoutBordersSectionCellStyle = innerWithoutBordersSectionCellStyle;
        }

        public String getInnerWithoutBordersCellStyle() {
            return this.innerWithoutBordersCellStyle;
        }

        public void setInnerWithoutBordersCellStyle(String innerWithoutBordersCellStyle) {
            this.innerWithoutBordersCellStyle = innerWithoutBordersCellStyle;
        }
    }
}

