/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.reviewCycle;

import at.cdes.api.dto.BaseTask;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentRelease;
import at.cdes.api.dto.DocumentTask;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.DocumentVersionTask;
import at.cdes.api.dto.EmailSnippet;
import at.cdes.api.dto.FutureEmail;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectHoliday;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.ReviewCycleEntryTask;
import at.cdes.api.dto.ReviewCycleInstanceReleased;
import at.cdes.api.dto.TaskEmailSnippet;
import at.cdes.api.email.compositeDto.NewFutureEmailInfo;
import at.cdes.api.joinDto.PlanDeliverReleaseJoin;
import at.cdes.api.result.ResultSummary;
import at.cdes.api.voc.EntityVoc;
import at.cdes.impl.dao.DocumentTaskDAO;
import at.cdes.impl.dao.DocumentVersionTaskDAO;
import at.cdes.impl.dao.EmailSnippetDAO;
import at.cdes.impl.dao.FutureEmailDAO;
import at.cdes.impl.dao.ReviewCycleEntryTaskDAO;
import at.cdes.impl.dao.TaskDAO;
import at.cdes.impl.dao.TaskEmailSnippetDAO;
import at.cdes.impl.document.context.GenerateTaskEmailSnippetsContext;
import at.cdes.impl.util.ContainerHelper;
import at.cdes.impl.util.DBChanges;
import at.cdes.impl.util.ObjectCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewTaskContext
implements GenerateTaskEmailSnippetsContext {
    private Map<Long, List<FutureEmail>> taskIdToFutureEmails = new HashMap<Long, List<FutureEmail>>();
    private Map<Long, DocumentVersion> idToDocumentVersion = new HashMap<Long, DocumentVersion>();
    private Map<Long, Document> idToDocument = new HashMap<Long, Document>();
    private Map<Long, DocumentRelease> documentIdToDocumentRelease = new HashMap<Long, DocumentRelease>();
    private Map<Long, ProjectParticipation> idToProjectParticipation = new HashMap<Long, ProjectParticipation>();
    private Map<Long, Project> idToProject = new HashMap<Long, Project>();
    private Map<Long, ReviewCycleInstanceReleased> idToReviewCycleInstanceReleased = new HashMap<Long, ReviewCycleInstanceReleased>();
    private Map<Long, ProjectParticipation> idToProjectRoleParticipation = new HashMap<Long, ProjectParticipation>();
    private DBChanges<BaseTask> taskChanges = new DBChanges();
    private DBChanges<DocumentTask> documentTaskChanges = new DBChanges();
    private DBChanges<ReviewCycleEntryTask> reviewCycleEntryTaskChanges = new DBChanges();
    private DBChanges<DocumentVersionTask> documentVersionTaskChanges = new DBChanges();
    private DBChanges<EmailSnippet> emailSnippetChanges = new DBChanges();
    private DBChanges<TaskEmailSnippet> taskEmailSnippetChanges = new DBChanges();
    private DBChanges<FutureEmail> futureEmailChanges = new DBChanges();
    private List<NewFutureEmailInfo> newFutureEmailInfos = new ArrayList<NewFutureEmailInfo>();
    private Map<Long, ObjectPlannerRelease> idToObjectPlannerRelease = new HashMap<Long, ObjectPlannerRelease>();
    private Map<Long, List<PlanDeliverReleaseJoin>> documentIdToReleaseJoins = new HashMap<Long, List<PlanDeliverReleaseJoin>>();
    private List<ProjectHoliday> projectHolidays = new ArrayList<ProjectHoliday>();
    private List<PlanDeliverReleaseJoin> objectPlannerJoins;
    private static final Logger log = LoggerFactory.getLogger(ReviewTaskContext.class);

    public ReviewTaskContext(List<PlanDeliverReleaseJoin> documentJoins, List<PlanDeliverReleaseJoin> documentVersionTaskJoins, List<PlanDeliverReleaseJoin> futureEmailJoins, List<PlanDeliverReleaseJoin> entryTaskJoins, List<PlanDeliverReleaseJoin> objectPlannerJoins, List<PlanDeliverReleaseJoin> projectRoleJoins, List<ProjectHoliday> projectHolidays) {
        for (PlanDeliverReleaseJoin documentJoin : documentJoins) {
            if (documentJoin.getDocumentId() != null) {
                this.idToDocument.put(documentJoin.getDocumentId(), documentJoin.getDocument());
            }
            if (documentJoin.getDocumentId() == null || documentJoin.getDocumentReleaseId() == null) continue;
            this.documentIdToDocumentRelease.put(documentJoin.getDocumentId(), documentJoin.getDocumentRelease());
        }
        for (PlanDeliverReleaseJoin documentVersionTaskJoin : documentVersionTaskJoins) {
            if (documentVersionTaskJoin.getDocumentVersionId() == null) continue;
            this.idToDocumentVersion.put(documentVersionTaskJoin.getDocumentVersionId(), documentVersionTaskJoin.getDocumentVersion());
        }
        for (PlanDeliverReleaseJoin futureEmailJoin : futureEmailJoins) {
            ContainerHelper.registerChildInstance(futureEmailJoin.getDocumentVersionTaskTaskId(), futureEmailJoin.getFutureEmailId(), futureEmailJoin.getFutureEmail(), this.taskIdToFutureEmails);
        }
        for (PlanDeliverReleaseJoin entryTaskJoin : entryTaskJoins) {
            ContainerHelper.registerChildInstance(entryTaskJoin.getDocumentTaskDocumentId(), entryTaskJoin.getDocumentTaskTaskId(), entryTaskJoin, this.documentIdToReleaseJoins);
        }
        for (PlanDeliverReleaseJoin objectPlannerJoin : objectPlannerJoins) {
            if (objectPlannerJoin.getObjectPlannerReleaseId() != null) {
                this.idToObjectPlannerRelease.put(objectPlannerJoin.getObjectPlannerReleaseId(), objectPlannerJoin.getObjectPlannerRelease());
            }
            if (objectPlannerJoin.getProjectParticipationId() != null) {
                this.idToProjectParticipation.put(objectPlannerJoin.getProjectParticipationId(), objectPlannerJoin.getProjectParticipation());
            }
            if (objectPlannerJoin.getProjectId() != null) {
                this.idToProject.put(objectPlannerJoin.getProjectId(), objectPlannerJoin.getProject());
            }
            if (objectPlannerJoin.getInstanceReleasedId() == null) continue;
            this.idToReviewCycleInstanceReleased.put(objectPlannerJoin.getInstanceReleasedId(), objectPlannerJoin.getInstanceReleased());
        }
        for (PlanDeliverReleaseJoin projectRoleJoin : projectRoleJoins) {
            if (projectRoleJoin.getProjectParticipationId() == null) continue;
            this.idToProjectRoleParticipation.put(projectRoleJoin.getProjectParticipationId(), projectRoleJoin.getProjectParticipation());
        }
        this.projectHolidays = projectHolidays;
        this.objectPlannerJoins = objectPlannerJoins;
    }

    public boolean containsProjectRoleParticipation(Long participationId) {
        return this.idToProjectRoleParticipation.containsKey(participationId);
    }

    public Document getDocument(Long documentId) {
        return this.idToDocument.get(documentId);
    }

    public DocumentVersion getDocumentVersion(Long documentVersionId) {
        return this.idToDocumentVersion.get(documentVersionId);
    }

    public DocumentRelease getReleasedDocumentByDocumentId(Long documentId) {
        return this.documentIdToDocumentRelease.get(documentId);
    }

    public ProjectParticipation getProjectParticipation(Long participationId) {
        return this.idToProjectParticipation.get(participationId);
    }

    public Project getProject(Long projectId) {
        return this.idToProject.get(projectId);
    }

    public ReviewCycleInstanceReleased getInstanceReleased(Long instanceReleasedId) {
        return this.idToReviewCycleInstanceReleased.get(instanceReleasedId);
    }

    @Override
    public List<FutureEmail> getFutureEmailsForTask(Long taskId) {
        return this.taskIdToFutureEmails.containsKey(taskId) ? this.taskIdToFutureEmails.get(taskId) : new ArrayList<FutureEmail>();
    }

    public Collection<PlanDeliverReleaseJoin> getEntryTaskJoinsForDocument(Long documentId) {
        return this.documentIdToReleaseJoins.containsKey(documentId) ? (Collection)this.documentIdToReleaseJoins.get(documentId) : new ArrayList<PlanDeliverReleaseJoin>();
    }

    public Collection<ObjectPlannerRelease> getAllReleasedObjectPlanners() {
        return this.idToObjectPlannerRelease.values();
    }

    @Override
    public List<ProjectHoliday> getAllProjectHolidays() {
        return this.projectHolidays;
    }

    public List<PlanDeliverReleaseJoin> getAllObjectPlannerJoins() {
        return this.objectPlannerJoins;
    }

    public Collection<ProjectParticipation> getAllProjectRoleParticipations() {
        return this.idToProjectRoleParticipation.values();
    }

    @Override
    public void registerNewTaskEmailSnippet(EmailSnippet emailSnippet, TaskEmailSnippet taskEmailSnippet) {
        if (taskEmailSnippet.getTaskId() == null) {
            throw new IllegalArgumentException("Task Id needs to be set");
        }
        this.emailSnippetChanges.registerNew(emailSnippet);
        this.taskEmailSnippetChanges.registerNew(taskEmailSnippet);
    }

    @Override
    public void registerNewFutureEmail(FutureEmail futureEmail, BaseTask refTask) {
        this.futureEmailChanges.registerNew(futureEmail);
        this.newFutureEmailInfos.add(new NewFutureEmailInfo(futureEmail, refTask));
    }

    public void registerNewReviewCycleEntryTask(BaseTask task, DocumentTask documentTask, ReviewCycleEntryTask reviewCycleEntryTask) {
        this.taskChanges.registerNew(task);
        this.documentTaskChanges.registerNew(documentTask);
        this.reviewCycleEntryTaskChanges.registerNew(reviewCycleEntryTask);
    }

    public void registerTaskForUpdate(BaseTask task) {
        this.taskChanges.registerForUpdate(task.getId(), task);
    }

    public void registerDocumentTaskForUpdate(DocumentTask documentTask) {
        this.documentTaskChanges.registerForUpdate(documentTask.getTaskId(), documentTask);
    }

    public void registerDocumentVersionTaskForUpdate(DocumentVersionTask documentVersionTask) {
        this.documentVersionTaskChanges.registerForUpdate(documentVersionTask.getTaskId(), documentVersionTask);
    }

    public void registerReviewCycleEntryTaskForUpdate(ReviewCycleEntryTask reviewCycleEntryTask) {
        this.reviewCycleEntryTaskChanges.registerForUpdate(reviewCycleEntryTask.getTaskId(), reviewCycleEntryTask);
    }

    @Override
    public void registerFutureEmailForDelete(FutureEmail futureEmail) {
        this.futureEmailChanges.registerForDelete(futureEmail.getId());
    }

    @Override
    public void registerFutureEmailsForDelete(ObjectCriteria<FutureEmail> criteria) {
        this.futureEmailChanges.registerForDelete(criteria);
    }

    public void registerTaskEmailSnippetForDelete(TaskEmailSnippet taskEmailSnippet) {
        this.emailSnippetChanges.registerForDelete(taskEmailSnippet.getEmailSnippetId());
        this.taskEmailSnippetChanges.registerForDelete(taskEmailSnippet.getEmailSnippetId());
    }

    public void registerReviewCycleEntryTaskForDelete(ReviewCycleEntryTask reviewCycleEntryTask) {
        this.reviewCycleEntryTaskChanges.registerForDelete(reviewCycleEntryTask.getTaskId());
    }

    public void registerDocumentTaskForDelete(DocumentTask documentTask) {
        this.documentTaskChanges.registerForDelete(documentTask.getTaskId());
    }

    public void registerTaskForDelete(BaseTask task) {
        if (log.isDebugEnabled()) {
            log.debug("Will register task [" + task.getId() + "] for deletion.");
        }
        this.taskChanges.registerForDelete(task.getId());
    }

    public void commitAll(ResultSummary resultSummary, EmailSnippetDAO emailSnippetDAO, TaskEmailSnippetDAO taskEmailSnippetDAO, FutureEmailDAO futureEmailDAO, TaskDAO taskDAO, DocumentTaskDAO documentTaskDAO, ReviewCycleEntryTaskDAO reviewCycleEntryTaskDAO, DocumentVersionTaskDAO documentVersionTaskDAO) {
        int n;
        List<BaseTask> justInsertedTasks = this.taskChanges.saveBatch(taskDAO, EntityVoc.BASE_TASK, resultSummary);
        for (int n2 = 0; n2 < justInsertedTasks.size(); ++n2) {
            ReviewCycleEntryTask reviewCycleEntryTask;
            DocumentTask documentTask = this.documentTaskChanges.getNewInstance(n2);
            if (documentTask != null) {
                documentTask.setTaskId(justInsertedTasks.get(n2).getId());
            }
            if ((reviewCycleEntryTask = this.reviewCycleEntryTaskChanges.getNewInstance(n2)) == null) continue;
            reviewCycleEntryTask.setTaskId(justInsertedTasks.get(n2).getId());
        }
        this.documentTaskChanges.saveBatch(documentTaskDAO, EntityVoc.DOCUMENT_TASK, resultSummary);
        this.reviewCycleEntryTaskChanges.saveBatch(reviewCycleEntryTaskDAO, EntityVoc.REVIEW_CYCLE_ENTRY_TASK, resultSummary);
        this.documentVersionTaskChanges.saveBatch(documentVersionTaskDAO, EntityVoc.DOCUMENT_VERSION_TASK, resultSummary);
        List<EmailSnippet> justInsertedEmailSnippets = this.emailSnippetChanges.saveBatch(emailSnippetDAO, EntityVoc.EMAIL_SNIPPET, resultSummary);
        for (n = 0; n < justInsertedEmailSnippets.size(); ++n) {
            TaskEmailSnippet taskEmailSnippet = this.taskEmailSnippetChanges.getNewInstance(n);
            if (taskEmailSnippet == null) continue;
            taskEmailSnippet.setEmailSnippetId(justInsertedEmailSnippets.get(n).getId());
        }
        this.taskEmailSnippetChanges.saveBatch(taskEmailSnippetDAO, EntityVoc.TASK_EMAIL_SNIPPET, resultSummary);
        for (n = 0; n < this.futureEmailChanges.getNumberOfNewInstances(); ++n) {
            FutureEmail newFutureEmail = this.futureEmailChanges.getNewInstance(n);
            if (newFutureEmail == null) continue;
            for (NewFutureEmailInfo newFutureEmailInfo : this.newFutureEmailInfos) {
                if (newFutureEmailInfo.getFutureEmail() != newFutureEmail) continue;
                newFutureEmail.setTaskId(newFutureEmailInfo.getTask().getId());
            }
        }
        this.futureEmailChanges.saveBatch(futureEmailDAO, EntityVoc.FUTURE_EMAIL, resultSummary);
        this.futureEmailChanges.updateDeleteBatch(futureEmailDAO, EntityVoc.FUTURE_EMAIL, resultSummary);
        this.taskEmailSnippetChanges.updateDeleteBatch(taskEmailSnippetDAO, EntityVoc.TASK_EMAIL_SNIPPET, resultSummary);
        this.emailSnippetChanges.updateDeleteBatch(emailSnippetDAO, EntityVoc.EMAIL_SNIPPET, resultSummary);
        this.documentVersionTaskChanges.updateDeleteBatch(documentVersionTaskDAO, EntityVoc.DOCUMENT_VERSION_TASK, resultSummary);
        this.reviewCycleEntryTaskChanges.updateDeleteBatch(reviewCycleEntryTaskDAO, EntityVoc.REVIEW_CYCLE_ENTRY_TASK, resultSummary);
        this.documentTaskChanges.updateDeleteBatch(documentTaskDAO, EntityVoc.DOCUMENT_TASK, resultSummary);
        this.taskChanges.updateDeleteBatch(taskDAO, EntityVoc.BASE_TASK, resultSummary);
    }
}

