/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.certificate;

import at.cdes.api.certificate.CertificateGenerator;
import at.cdes.api.dto.Ca;
import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.CertificateRequest;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.impl.certificate.KeyHelper;
import at.cdes.impl.sec.util.CertificateHelper;
import at.cdes.impl.util.PersonHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.openssl.PEMEncryptor;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcePEMEncryptorBuilder;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.clazzes.util.datetime.UtcTimestamp;

public class BouncyCastleCertificateGenerator
implements CertificateGenerator {
    private SecureRandom secureRandom = new SecureRandom();

    public String generateChallenge() {
        return this.generateChallenge(16);
    }

    private String generateChallenge(int length) {
        String randomChars = "123456789ABCDEFGHJKLMNPQRSTUVWXZ";
        char[] newpwd = new char[length];
        for (int i = 0; i < length; ++i) {
            newpwd[i] = randomChars.charAt(this.secureRandom.nextInt(randomChars.length()));
        }
        return new String(newpwd);
    }

    public void renewCertificate(Certificate oldCertificate, Certificate newCertificate, Ca certificateAuthority, String password, Long signerId, int years) {
        PEMParser pr2 = null;
        PEMWriter pw = null;
        try {
            KeyPair rootCaKeyPair = KeyHelper.openKeyPair(certificateAuthority.getPrivateKey(), password);
            pr2 = new PEMParser((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(certificateAuthority.getCertificate()), "US-ASCII"));
            Object o2 = pr2.readObject();
            X509CertificateHolder x509CertHolder2 = (X509CertificateHolder)o2;
            X509Certificate ca_cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertHolder2);
            X509V3CertificateGenerator gen = new X509V3CertificateGenerator();
            X509Certificate x509Cert = CertificateHelper.getX509Certificate(oldCertificate.getCertificate());
            gen.setPublicKey(x509Cert.getPublicKey());
            gen.setSubjectDN(x509Cert.getSubjectX500Principal());
            gen.setSignatureAlgorithm("SHA1withRSA");
            UtcTimestamp now = UtcTimestamp.now((TimeZone)TimeZone.getTimeZone("Europe/Berlin"));
            Double fromSeconds = (double)now.getUtcMillis().longValue() / 1000.0;
            now.addYears(years);
            Double toSeconds = (double)now.getUtcMillis().longValue() / 1000.0;
            gen.setNotBefore(new Date(fromSeconds.longValue() * 1000L));
            gen.setNotAfter(new Date(toSeconds.longValue() * 1000L));
            gen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
            gen.setSignatureAlgorithm("SHA1withRSA");
            gen.setIssuerDN(ca_cert.getSubjectX500Principal());
            X509Certificate cert = gen.generateX509Certificate(rootCaKeyPair.getPrivate());
            StringWriter sw = new StringWriter();
            pw = new PEMWriter((Writer)sw);
            pw.writeObject((Object)cert);
            pw.close();
            String cert_pem = sw.toString();
            newCertificate.setCaCertId(certificateAuthority.getId());
            newCertificate.setCertificate(cert_pem.getBytes("US-ASCII"));
            newCertificate.setCertSerial(cert.getSerialNumber().toString(16));
            newCertificate.setCreatedById(signerId);
            newCertificate.setMayLogin(Boolean.valueOf(true));
            newCertificate.setMaySign(Boolean.valueOf(true));
            newCertificate.setCertValidFrom(fromSeconds);
            newCertificate.setCertValidTo(toSeconds);
        }
        catch (CertificateException e) {
            throw new SecurityException(e);
        }
        catch (InvalidKeyException e) {
            throw new SecurityException(e);
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (SignatureException e) {
            throw new SecurityException(e);
        }
        finally {
            try {
                if (pr2 != null) {
                    pr2.close();
                }
                if (pw != null) {
                    pw.close();
                }
            }
            catch (IOException e) {
                throw new SecurityException("Verifying PKCS7 Signature", e);
            }
        }
    }

    public void signCertificateRequest(Certificate certificate, CertificateRequest certificateRequest, Ca ca, String password, Long signerId, int years) {
        PEMParser pr2 = null;
        try {
            KeyPair rootca_keypair = KeyHelper.openKeyPair(ca.getPrivateKey(), password);
            pr2 = new PEMParser((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(ca.getCertificate()), "US-ASCII"));
            Object o2 = pr2.readObject();
            X509CertificateHolder x509CertHolder2 = (X509CertificateHolder)o2;
            X509Certificate ca_cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertHolder2);
            PKCS10CertificationRequest pkcs10_request = new PKCS10CertificationRequest(certificateRequest.getRequest());
            X509V3CertificateGenerator gen = new X509V3CertificateGenerator();
            PKCS10CertificationRequest request = new PKCS10CertificationRequest(certificateRequest.getRequest());
            gen.addExtension(X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            gen.setPublicKey(request.getPublicKey());
            gen.setSubjectDN(X509Name.getInstance((Object)request.getCertificationRequestInfo().getSubject()));
            gen.setSignatureAlgorithm("SHA1withRSA");
            gen.setPublicKey(pkcs10_request.getPublicKey());
            gen.setSubjectDN(X509Name.getInstance((Object)pkcs10_request.getCertificationRequestInfo().getSubject()));
            long now = System.currentTimeMillis();
            Date from_date = new Date(now);
            gen.setNotBefore(from_date);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(from_date);
            ((Calendar)cal).add(1, 4);
            Date to_date = cal.getTime();
            gen.setNotAfter(to_date);
            gen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
            gen.setSignatureAlgorithm("SHA1withRSA");
            gen.setIssuerDN(ca_cert.getSubjectX500Principal());
            X509Certificate cert = gen.generateX509Certificate(rootca_keypair.getPrivate());
            StringWriter sw = new StringWriter();
            PEMWriter pw = new PEMWriter((Writer)sw);
            pw.writeObject((Object)cert);
            pw.close();
            String cert_pem = sw.toString();
            certificate.setCaCertId(ca.getId());
            certificate.setCertificate(cert_pem.getBytes("US-ASCII"));
            certificate.setCertSerial(cert.getSerialNumber().toString(16));
            certificate.setCreatedById(signerId);
            certificate.setMayLogin(Boolean.valueOf(true));
            certificate.setMaySign(Boolean.valueOf(true));
            certificate.setCertValidFrom(Double.valueOf((double)from_date.getTime() / 1000.0));
            certificate.setCertValidTo(Double.valueOf((double)to_date.getTime() / 1000.0));
            certificateRequest.setRequestType("Accepted");
            certificate.setCertificateRequestId(certificateRequest.getId());
        }
        catch (CertificateException e) {
            throw new SecurityException(e);
        }
        catch (InvalidKeyException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException(e);
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
        catch (SignatureException e) {
            throw new SecurityException(e);
        }
        finally {
            try {
                if (pr2 != null) {
                    pr2.close();
                }
            }
            catch (IOException e) {
                throw new SecurityException("Verifying PKCS7 Signature", e);
            }
        }
    }

    public Certificate generateDirectCertificate(OrganisationPersonJoin opJoin, byte[] privateKey) {
        String personCommonName = PersonHelper.getCommonName(opJoin.getPerson());
        String name = "CN=" + personCommonName.replace("+", "*").replace(",", ";") + ", O=" + opJoin.getOrganisationName().replace("+", "*").replace(",", ";") + ", C=" + opJoin.getOpCountryCode2().toUpperCase();
        X509Name xName = new X509Name(name);
        X509Principal subject = new X509Principal(xName);
        Certificate cert = new Certificate();
        cert.setCertificate(null);
        cert.setSubjectDn(subject.toString().getBytes());
        cert.setCreatedById(opJoin.getOrganisationPersonId());
        cert.setMayLogin(Boolean.valueOf(false));
        cert.setMaySign(Boolean.valueOf(false));
        cert.setOrganisationPersonId(opJoin.getOrganisationPersonId());
        cert.setPrivateKey(privateKey);
        cert.setCertSerial(null);
        cert.setCertValidFrom(Double.valueOf((double)System.currentTimeMillis() / 1000.0));
        cert.setCertValidTo(null);
        return cert;
    }

    public Certificate signCertificateDirectly(Certificate certificate, Ca ca, String password, Long signerId, int years, Certificate oldCertificate) {
        PEMParser pr2 = null;
        try {
            KeyPair rootca_keypair = KeyHelper.openKeyPair(ca.getPrivateKey(), password);
            pr2 = new PEMParser((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(ca.getCertificate()), "US-ASCII"));
            Object o2 = pr2.readObject();
            X509CertificateHolder x509CertHolder2 = (X509CertificateHolder)o2;
            X509Certificate ca_cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertHolder2);
            X509V3CertificateGenerator gen = new X509V3CertificateGenerator();
            X509Certificate x509Cert = CertificateHelper.getX509Certificate(oldCertificate.getCertificate());
            gen.addExtension(X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            gen.setPublicKey(x509Cert.getPublicKey());
            gen.setSubjectDN(new X509Name(new String(certificate.getSubjectDn(), "US-ASCII")));
            long now = System.currentTimeMillis();
            Date from_date = new Date(now);
            gen.setNotBefore(from_date);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(from_date);
            ((Calendar)cal).add(1, 4);
            Date to_date = cal.getTime();
            gen.setNotAfter(to_date);
            gen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
            gen.setSignatureAlgorithm("SHA1withRSA");
            gen.setIssuerDN(ca_cert.getSubjectX500Principal());
            X509Certificate cert = gen.generateX509Certificate(rootca_keypair.getPrivate());
            StringWriter sw = new StringWriter();
            PEMWriter pw = new PEMWriter((Writer)sw);
            pw.writeObject((Object)cert);
            pw.close();
            String cert_pem = sw.toString();
            certificate.setCaCertId(ca.getId());
            certificate.setCertificate(cert_pem.getBytes("US-ASCII"));
            certificate.setCertSerial(cert.getSerialNumber().toString(16));
            certificate.setCreatedById(signerId);
            certificate.setMayLogin(Boolean.valueOf(true));
            certificate.setMaySign(Boolean.valueOf(true));
            certificate.setCertValidFrom(Double.valueOf((double)from_date.getTime() / 1000.0));
            certificate.setCertValidTo(Double.valueOf((double)to_date.getTime() / 1000.0));
            Certificate certificate2 = certificate;
            return certificate2;
        }
        catch (CertificateException e) {
            throw new SecurityException(e);
        }
        catch (InvalidKeyException e) {
            throw new SecurityException(e);
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
        catch (SecurityException e) {
            throw new SecurityException(e);
        }
        catch (SignatureException e) {
            throw new SecurityException(e);
        }
        finally {
            try {
                if (pr2 != null) {
                    pr2.close();
                }
            }
            catch (IOException e) {
                throw new SecurityException("Verifying PKCS7 Signature", e);
            }
        }
    }

    public Certificate generateCertificate(CertificateRequest invitation, OrganisationPersonJoin requester, String password) {
        JcaPEMWriter pemWriter = null;
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
            kpg.initialize(2048);
            KeyPair kp = kpg.genKeyPair();
            StringWriter sw = new StringWriter();
            pemWriter = new JcaPEMWriter((Writer)sw);
            JcePEMEncryptorBuilder builder = new JcePEMEncryptorBuilder("AES-256-CBC");
            PEMEncryptor encryptor = builder.build(password.toCharArray());
            pemWriter.writeObject((Object)kp.getPrivate(), encryptor);
            pemWriter.close();
            pemWriter = null;
            String privkey_pem = sw.toString();
            String commonName = PersonHelper.getCommonName(requester.getPerson());
            String name = "CN=" + commonName.replace("+", "*").replace(",", ";") + ", O=" + requester.getOrganisationName().replace("+", "*").replace(",", ";") + ", C=" + requester.getOpCountry().getCode2().toUpperCase();
            X509Name xName = new X509Name(name);
            X509Principal subject = new X509Principal(xName);
            PKCS10CertificationRequest request = new PKCS10CertificationRequest("SHA1withRSA", (X509Name)subject, kp.getPublic(), null, kp.getPrivate());
            Double currentUtcSeconds = new Double(System.currentTimeMillis()) / 1000.0;
            invitation.setRequest(request.getEncoded());
            invitation.setRequestDatetime(currentUtcSeconds);
            invitation.setRequestType("Request");
            Certificate certificate = new Certificate();
            certificate.setCertificateRequestId(invitation.getId());
            certificate.setCertificate(null);
            certificate.setSubjectDn(subject.toString().getBytes());
            certificate.setCreatedById(requester.getOrganisationPersonId());
            certificate.setMayLogin(Boolean.valueOf(false));
            certificate.setMaySign(Boolean.valueOf(false));
            certificate.setOrganisationPersonId(requester.getOrganisationPersonId());
            certificate.setPrivateKey(privkey_pem.getBytes());
            certificate.setCertificate(null);
            certificate.setCertValidFrom(currentUtcSeconds);
            certificate.setCertValidTo(null);
            Certificate certificate2 = certificate;
            return certificate2;
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
        catch (InvalidKeyException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException(e);
        }
        catch (SignatureException e) {
            throw new SecurityException(e);
        }
        finally {
            try {
                if (pemWriter != null) {
                    pemWriter.close();
                }
            }
            catch (IOException e) {
                throw new SecurityException("Verifying PKCS7 Signature", e);
            }
        }
    }

    public Certificate changePassword(String newPassword, String oldPassword, Certificate cert) {
        JcaPEMWriter pw2 = null;
        try {
            KeyPair pair = KeyHelper.openKeyPair(cert.getPrivateKey(), oldPassword);
            StringWriter sw2 = new StringWriter();
            pw2 = new JcaPEMWriter((Writer)sw2);
            JcePEMEncryptorBuilder builder = new JcePEMEncryptorBuilder("AES-256-CBC");
            PEMEncryptor encryptor = builder.build(newPassword.toCharArray());
            pw2.writeObject((Object)pair.getPrivate(), encryptor);
            pw2.close();
            pw2 = null;
            String privkey_pem = sw2.toString();
            cert.setPrivateKey(privkey_pem.getBytes());
            Certificate certificate = cert;
            return certificate;
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
        finally {
            try {
                if (pw2 != null) {
                    pw2.close();
                }
            }
            catch (IOException e) {
                throw new SecurityException("Verifying PKCS7 Signature", e);
            }
        }
    }
}

