/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.action;

import at.cdes.api.joinDto.ObjectPlannerAction;
import at.cdes.api.joinDto.ShortObjectPlannerAction;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.action.ActionDAOHelper;
import at.cdes.impl.dao.jdbc.AbstractJdbcActionDAO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.clazzes.util.sql.helper.JDBCHelper;

public class ObjectPlannerActionHelper {
    public static String getObjectPlannerRuleClause(int numberOfActionNames) {
        return ObjectPlannerActionHelper.getObjectPlannerSelectClause() + ObjectPlannerActionHelper.getObjectPlannerFromClause() + ObjectPlannerActionHelper.getObjectPlannerWhereClauseGivenSubProject(numberOfActionNames);
    }

    public static String getObjectPlannerRuleClauseGivenObjectPlanners(int numberOfObjectPlanners, int numberOfActionNames) {
        return ObjectPlannerActionHelper.getObjectPlannerSelectClause() + ObjectPlannerActionHelper.getObjectPlannerFromClause() + ObjectPlannerActionHelper.getObjectPlannerWhereClauseGivenObjectPlanners(numberOfObjectPlanners, numberOfActionNames);
    }

    private static String getObjectPlannerSelectClause() {
        return "SELECT DISTINCT " + AbstractJdbcActionDAO.getShortObjectPlannerActionSelectClause() + ", dest_action_rule.id, dest_action_rule.destination_context_id, dest_action_rule.check_member, network.id, planner_role.id, project.id, project.access, participant.id, participant.inactive_flag, participation.id ";
    }

    private static String getObjectPlannerFromClause() {
        return "FROM (((((((((((((((((((((object_planner JOIN object                         ON object_planner.object_id = object.id) JOIN object_list                    ON object.object_list_id = object_list.id) JOIN sub_project                    ON object_list.sub_project_id = sub_project.id) JOIN project                        ON     sub_project.project_id = project.id) JOIN network                        ON     project.network_id = network.id) JOIN object_list_release            ON      object_list_release.object_list_id = object_list.id AND object_list_release.version = object_list.version - 1) JOIN object_release                 ON      object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id) JOIN object_planner_release         ON      object_planner_release.object_id = object_release.id AND object_planner_release.object_planner_id = object_planner.id) CROSS JOIN project_participant participant) JOIN organisation_person            ON     participant.organisation_person_id = organisation_person.id) JOIN project_participation participation ON     participant.participation_id = participation.id AND participation.project_id = project.id) CROSS JOIN action) JOIN action_rule dest_action_rule ON       dest_action_rule.action_id = action.id AND (dest_action_rule.network_id = network.id OR dest_action_rule.network_id IS NULL)) JOIN cdes_role planner_role         ON participation.role_id = planner_role.id) JOIN action_rule                    ON  action_rule.action_id = action.id) JOIN role_action_rule               ON      role_action_rule.action_rule_id = action_rule.id AND role_action_rule.cdes_role_id = planner_role.id) LEFT JOIN object_planner_position_release ON object_planner_position_release.object_planner_id = object_planner_release.id AND object_planner_position_release.project_participation_id = participation.id) LEFT JOIN review_cycle_instance_released ON object_planner_release.review_cycle_instance_id = review_cycle_instance_released.id) LEFT JOIN review_cycle_cell_instance_released ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id) LEFT JOIN review_cycle_node_instance_released ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id) LEFT JOIN review_cycle_node_position_released ON       review_cycle_node_position_released.review_cycle_node_instance_id = review_cycle_node_instance_released.id AND review_cycle_node_position_released.project_participation_id = participation.id) ";
    }

    private static String getObjectPlannerCoreWhereClause() {
        return "WHERE participant.organisation_person_id = ? AND organisation_person.person_id = ? AND participant.inactive_flag = 0 AND (    object_planner_release.planner_id = participation.id OR object_planner_position_release.id IS NOT NULL OR review_cycle_node_position_released.id IS NOT NULL) AND dest_action_rule.destination_context_id = 4 AND (    project.access = 2 OR (    (project.access = 1 OR project.access = 0) AND  action.read_only = 1)) AND (     action_rule.check_member = 0 OR (    sub_project.read_only = 0 OR action.read_only = 1)) ";
    }

    private static String getObjectPlannerWhereClauseGivenSubProject(int numberOfActionNames) {
        String actionNameWhereClause = ActionDAOHelper.getActionNameWhereClauses(numberOfActionNames);
        return ObjectPlannerActionHelper.getObjectPlannerCoreWhereClause() + "AND sub_project.id = ? " + (actionNameWhereClause.length() > 0 ? "AND " + actionNameWhereClause : "");
    }

    private static String getObjectPlannerWhereClauseGivenObjectPlanners(int numberOfObjectPlanners, int numberOfActionNames) {
        String objectPlannerWhereClause = ActionDAOHelper.getInClauseWithPlaceHolders("object_planner.id", numberOfObjectPlanners);
        String actionNameWhereClause = ActionDAOHelper.getActionNameWhereClauses(numberOfActionNames);
        return ObjectPlannerActionHelper.getObjectPlannerCoreWhereClause() + (objectPlannerWhereClause.length() > 0 ? "AND " + objectPlannerWhereClause : "AND 1=0 ") + (actionNameWhereClause.length() > 0 ? "AND " + actionNameWhereClause : "");
    }

    public static int populateObjectPlannerRuleClause(PreparedStatement statement, int currIndex, Long organisationPersonId, Long subProjectId, Action ... actionNames) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ActionDAOHelper.getPersonIdFromPrincipal());
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        for (Action actionName : actionNames) {
            statement.setString(currIndex++, actionName.getName());
        }
        return currIndex;
    }

    public static int populateObjectPlannerRuleClause(PreparedStatement statement, int currIndex, Long organisationPersonId, Collection<Long> objectPlannerIds, Action ... actionNames) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ActionDAOHelper.getPersonIdFromPrincipal());
        for (Long objectPlannerId : objectPlannerIds) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerId);
        }
        for (Action actionName : actionNames) {
            statement.setString(currIndex++, actionName.getName());
        }
        return currIndex;
    }

    public static ObjectPlannerAction fillObjectPlannerActionFromResultSet(ResultSet resultSet) throws SQLException {
        ShortObjectPlannerAction shortObjectPlannerAction = AbstractJdbcActionDAO.fillShortObjectPlannerActionFromResultSet(resultSet);
        ObjectPlannerAction objectPlannerAction = new ObjectPlannerAction();
        objectPlannerAction.setAction(shortObjectPlannerAction.getAction());
        objectPlannerAction.setObjectPlannerId(shortObjectPlannerAction.getObjectPlannerId());
        objectPlannerAction.setDestActionRuleId(JDBCHelper.getLong((ResultSet)resultSet, (int)6));
        objectPlannerAction.setDestActionRuleDestinationContextId(JDBCHelper.getLong((ResultSet)resultSet, (int)7));
        objectPlannerAction.setDestActionRuleCheckMember(JDBCHelper.getBoolean((ResultSet)resultSet, (int)8));
        objectPlannerAction.setNetworkId(JDBCHelper.getLong((ResultSet)resultSet, (int)9));
        objectPlannerAction.setPlannerRoleId(JDBCHelper.getLong((ResultSet)resultSet, (int)10));
        objectPlannerAction.setProjectId(JDBCHelper.getLong((ResultSet)resultSet, (int)11));
        objectPlannerAction.setProjectAccess(JDBCHelper.getInt((ResultSet)resultSet, (int)12));
        objectPlannerAction.setProjectParticipantId(JDBCHelper.getLong((ResultSet)resultSet, (int)13));
        objectPlannerAction.setProjectParticipantInactiveFlag(JDBCHelper.getBoolean((ResultSet)resultSet, (int)14));
        objectPlannerAction.setProjectParticipationId(JDBCHelper.getLong((ResultSet)resultSet, (int)15));
        return objectPlannerAction;
    }

    public static void popuplateActionsForSubProjectStatement(PreparedStatement statement, Long organisationPersonId, Long subProjectId, String ... actionNames) throws SQLException {
        int currIndex = 1;
        for (String actionName : actionNames) {
            statement.setString(currIndex++, actionName);
        }
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        for (String actionName : actionNames) {
            statement.setString(currIndex++, actionName);
        }
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
    }
}

