/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.PlotOrderSearchModel;
import at.cdes.api.dto.PlottOrder;
import at.cdes.api.joinDto.PlotOrderDeleteJoin;
import at.cdes.api.joinDto.PlotOrderEditJoin;
import at.cdes.api.joinDto.PlotOrderJoin;
import at.cdes.api.joinDto.PlotOrderZipExportJoin;
import at.cdes.api.joinDto.PlotTaskJoin;
import at.cdes.impl.dao.PlottOrderDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcPlottOrderDAO;
import at.cdes.impl.dao.jdbc.JdbcDocumentVersionDAO;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SearchHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcPlottOrderDAO
extends AbstractJdbcPlottOrderDAO
implements PlottOrderDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcPlottOrderDAO.class);

    @Override
    public List<PlotOrderJoin> getPlotOrderJoin(final PlotOrderSearchModel searchModel) {
        String sql = this.getPlotOrderJoinSQL() + "WHERE plot_order.project_id = ? ";
        List<String> searchedJobNumbers = SearchHelper.extractAndConvertSearchTokens(searchModel.getJobNumber());
        if (searchModel.getJobNumber() != null && searchedJobNumbers.size() > 0) {
            sql = sql + "AND (0=1 ";
            for (int n = 0; n < searchedJobNumbers.size(); ++n) {
                sql = sql + "OR plot_order.job_number LIKE ? ";
            }
            sql = sql + ") ";
        }
        if (SearchHelper.isStringFilled(searchModel.getPlotterName())) {
            sql = sql + "AND plotter.name LIKE ? ";
        }
        if (SearchHelper.isStringFilled(searchModel.getOrganisationName())) {
            sql = sql + "AND billing_address.organisationName LIKE ? ";
        }
        if (searchModel.getFrom() != null) {
            sql = sql + "AND ( (request_step.finished IS NOT NULL AND request_step.finished >= ?) OR (acceptance_step.finished IS NOT NULL AND acceptance_step.finished >= ?) OR (completed_step.finished IS NOT NULL AND completed_step.finished >= ?)) ";
        }
        if (searchModel.getTo() != null) {
            sql = sql + "AND ( (request_step.finished IS NOT NULL AND request_step.finished < ?) OR (acceptance_step.finished IS NOT NULL AND acceptance_step.finished < ?) OR (completed_step.finished IS NOT NULL AND completed_step.finished < ?)) ";
        }
        if (log.isTraceEnabled()) {
            log.trace("Will query PlotOrderJoin: " + sql);
        }
        if (log.isDebugEnabled()) {
            this.printSearchModelToDebug(searchModel);
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlotOrderJoin>>(){

            public List<PlotOrderJoin> perform(PreparedStatement statement) throws Exception {
                JdbcPlottOrderDAO.this.populatePlotOrderStatement(statement, searchModel);
                ResultSet rs = statement.executeQuery();
                ArrayList<PlotOrderJoin> ret = new ArrayList<PlotOrderJoin>();
                while (rs.next()) {
                    PlotOrderJoin joinDto = AbstractJdbcPlottOrderDAO.fillPlotOrderJoinFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }

    @Override
    public List<PlotOrderJoin> getPlotOrderJoin(final List<Long> plotOrderIds) {
        String sql = this.getPlotOrderJoinSQL();
        if (plotOrderIds.size() > 0) {
            sql = sql + " WHERE plot_order.id IN (";
            for (int n = 0; n < plotOrderIds.size(); ++n) {
                sql = sql + "?" + (n < plotOrderIds.size() - 1 ? ", " : ")");
            }
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlotOrderJoin>>(){

            public List<PlotOrderJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long plotOrderId : plotOrderIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)plotOrderId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<PlotOrderJoin> ret = new ArrayList<PlotOrderJoin>();
                while (rs.next()) {
                    PlotOrderJoin joinDto = AbstractJdbcPlottOrderDAO.fillPlotOrderJoinFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }

    public String getPlotOrderJoinSQL() {
        return "SELECT " + JdbcPlottOrderDAO.getPlotOrderJoinSelectClause() + ", 0, 0, 0, 0 FROM (((((((((((((((((((( plott_order plot_order LEFT JOIN project                              ON plot_order.project_id = project.id) LEFT JOIN organisation plotter                 ON plot_order.plotter_id = plotter.id) LEFT JOIN countries plotter_country            ON plotter.country_id = plotter_country.id) LEFT JOIN order_address billing_address        ON plot_order.billing_address_id = billing_address.id) LEFT JOIN countries order_address_country      ON billing_address.country_id = order_address_country.id) LEFT JOIN order_step request_step              ON plot_order.request_id = request_step.id) LEFT JOIN order_step acceptance_step           ON plot_order.acceptance_id = acceptance_step.id) LEFT JOIN order_step completed_step            ON plot_order.completed_id = completed_step.id) LEFT JOIN received_plott_order_step received_plot_order_step    ON received_plot_order_step.order_id = plot_order.id) LEFT JOIN order_step received_step             ON received_plot_order_step.order_step_id = received_step.id) LEFT JOIN project_participation_order_step     ON project_participation_order_step.order_step_id = received_step.id) LEFT JOIN project_participation                ON project_participation_order_step.project_participation_id = project_participation.id) LEFT JOIN order_step charged_step              ON plot_order.charged_step_id = charged_step.id) LEFT JOIN plott_order_item plot_order_item     ON received_step.order_item_id = plot_order_item.id) LEFT JOIN plott_properties plot_properties     ON plot_order_item.plott_properties_id = plot_properties.id) LEFT JOIN order_address delivery_order_address ON plot_order_item.delivery_address_id = delivery_order_address.id) LEFT JOIN document_version                     ON plot_order_item.document_version_id = document_version.id) LEFT JOIN document                             ON document_version.document_id = document.id) LEFT JOIN document_list                        ON document.document_list_id = document_list.id) LEFT JOIN sub_project                          ON document_list.sub_project_id = sub_project.id) ";
    }

    private void printSearchModelToDebug(PlotOrderSearchModel searchModel) {
        log.debug("projectId = [" + searchModel.getProjectId() + "]");
    }

    private void populatePlotOrderStatement(PreparedStatement statement, PlotOrderSearchModel searchModel) throws SQLException {
        String searchString;
        int currIndex = 1;
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getProjectId());
        List<String> searchedJobNumbers = SearchHelper.extractAndConvertSearchTokens(searchModel.getJobNumber());
        if (searchModel.getJobNumber() != null) {
            if (searchedJobNumbers.size() > 0) {
                for (String searchedJobNumber : searchedJobNumbers) {
                    statement.setString(currIndex++, searchedJobNumber);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("Filter: _plot_order.job_number = [" + searchModel.getJobNumber() + "]");
            }
        }
        if (SearchHelper.isStringFilled(searchModel.getPlotterName())) {
            searchString = SearchHelper.convertForSearch(searchModel.getPlotterName());
            statement.setString(currIndex++, searchString);
            if (log.isTraceEnabled()) {
                log.trace("Filter: _plotter.name LIKE [" + searchModel.getPlotterName() + "]");
            }
        }
        if (SearchHelper.isStringFilled(searchModel.getOrganisationName())) {
            searchString = SearchHelper.convertForSearch(searchModel.getOrganisationName());
            statement.setString(currIndex++, searchString);
            if (log.isTraceEnabled()) {
                log.trace("Filter: billing_address.organisationName LIKE [" + searchModel.getOrganisationName() + "]");
            }
        }
        if (searchModel.getFrom() != null) {
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)searchModel.getFrom().doubleValue());
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)searchModel.getFrom().doubleValue());
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)searchModel.getFrom().doubleValue());
            if (log.isTraceEnabled()) {
                log.trace("Filter: from = [" + searchModel.getFrom() + "]");
            }
        }
        if (searchModel.getTo() != null) {
            Double utcSecondsAsEntered = searchModel.getTo().doubleValue();
            Double utcSecondsNextDay = utcSecondsAsEntered + 86400.0;
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)utcSecondsNextDay);
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)utcSecondsNextDay);
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)utcSecondsNextDay);
            if (log.isTraceEnabled()) {
                log.trace("Filter: to = [" + searchModel.getTo() + "]");
            }
        }
    }

    @Override
    public List<PlotOrderDeleteJoin> getPlotOrderDeleteJoin(final Long plotOrderId) {
        String sql = "SELECT " + JdbcPlottOrderDAO.getPlotOrderDeleteJoinSelectClause() + "FROM plott_order plot_order LEFT JOIN plott_order_item plot_order_item               ON plot_order_item.order_contract_id = plot_order.id LEFT JOIN order_step acceptance_step                     ON plot_order.acceptance_id = acceptance_step.id LEFT JOIN order_step completed_step                      ON plot_order.completed_id = completed_step.id LEFT JOIN review_cycle_plott_task review_cycle_plot_task ON review_cycle_plot_task.order_step_id = acceptance_step.id LEFT JOIN document_version                               ON plot_order_item.document_version_id = document_version.id LEFT JOIN document                                       ON document_version.document_id = document.id LEFT JOIN document_list                                  ON document.document_list_id = document_list.id LEFT JOIN sub_project                                    ON document_list.sub_project_id = sub_project.id WHERE plot_order.id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlotOrderDeleteJoin>>(){

            public List<PlotOrderDeleteJoin> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)plotOrderId);
                ResultSet rs = statement.executeQuery();
                ArrayList<PlotOrderDeleteJoin> ret = new ArrayList<PlotOrderDeleteJoin>();
                while (rs.next()) {
                    PlotOrderDeleteJoin joinDto = AbstractJdbcPlottOrderDAO.fillPlotOrderDeleteJoinFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }

    @Override
    public List<PlotOrderDeleteJoin> getPlotOrderDeleteJoinByProjectOfSubProject(final Long subProjectId) {
        String sql = "SELECT " + JdbcPlottOrderDAO.getPlotOrderDeleteJoinSelectClause() + "FROM sub_project ref_sub_project JOIN project ref_project                            ON ref_sub_project.project_id = ref_project.id JOIN plott_order plot_order                         ON plot_order.project_id = ref_project.id LEFT JOIN plott_order_item plot_order_item               ON plot_order_item.order_contract_id = plot_order.id LEFT JOIN order_step acceptance_step                     ON plot_order.acceptance_id = acceptance_step.id LEFT JOIN order_step completed_step                      ON plot_order.completed_id = completed_step.id LEFT JOIN review_cycle_plott_task review_cycle_plot_task ON review_cycle_plot_task.order_step_id = acceptance_step.id LEFT JOIN document_version                               ON plot_order_item.document_version_id = document_version.id LEFT JOIN document                                       ON document_version.document_id = document.id LEFT JOIN document_list                                  ON document.document_list_id = document_list.id LEFT JOIN sub_project                                    ON document_list.sub_project_id = sub_project.id WHERE ref_sub_project.id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlotOrderDeleteJoin>>(){

            public List<PlotOrderDeleteJoin> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)subProjectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<PlotOrderDeleteJoin> ret = new ArrayList<PlotOrderDeleteJoin>();
                while (rs.next()) {
                    PlotOrderDeleteJoin joinDto = AbstractJdbcPlottOrderDAO.fillPlotOrderDeleteJoinFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }

    public List<PlotOrderDeleteJoin> getPlotOrderItemDeleteJoin(final Long plotOrderItemId) {
        String sql = "SELECT " + JdbcPlottOrderDAO.getPlotOrderDeleteJoinSelectClause() + "FROM ((plott_order_item plot_order_item LEFT JOIN plott_order plot_order                                  ON plot_order_item.order_contract_id = plot_order.id) LEFT JOIN order_step acceptance_step                              ON plot_order.acceptance_id = acceptance_step.id) WHERE plot_order_item.id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlotOrderDeleteJoin>>(){

            public List<PlotOrderDeleteJoin> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)plotOrderItemId);
                ResultSet rs = statement.executeQuery();
                ArrayList<PlotOrderDeleteJoin> ret = new ArrayList<PlotOrderDeleteJoin>();
                while (rs.next()) {
                    PlotOrderDeleteJoin joinDto = AbstractJdbcPlottOrderDAO.fillPlotOrderDeleteJoinFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }

    @Override
    public List<PlotOrderEditJoin> getPlotOrderEditJoin(final Long plotOrderId) {
        String sql = "SELECT " + JdbcPlottOrderDAO.getPlotOrderEditJoinSelectClause() + "FROM ((((((((((((((((((((((((((((((((((((( plott_order plot_order LEFT JOIN project                                      ON plot_order.project_id = project.id) LEFT JOIN network                                      ON project.network_id = network.id) LEFT JOIN organisation plotter                         ON plot_order.plotter_id = plotter.id) LEFT JOIN countries plotter_country                    ON plotter.country_id = plotter_country.id) LEFT JOIN order_address billing_address                ON plot_order.billing_address_id = billing_address.id) LEFT JOIN countries billing_country                    ON billing_address.country_id = billing_country.id) LEFT JOIN order_step request_step                      ON plot_order.request_id = request_step.id) LEFT JOIN order_step acceptance_step                   ON plot_order.acceptance_id = acceptance_step.id) LEFT JOIN signature acceptance_signature               ON acceptance_step.signature_id = acceptance_signature.id) LEFT JOIN project_participant acceptance_participant   ON acceptance_signature.project_participant_id = acceptance_participant.id) LEFT JOIN organisation_person acceptance_organisation_person ON acceptance_participant.organisation_person_id = acceptance_organisation_person.id) LEFT JOIN person acceptance_person                     ON acceptance_organisation_person.person_id = acceptance_person.id) LEFT JOIN order_step completed_step                    ON plot_order.completed_id = completed_step.id) LEFT JOIN signature completed_signature                ON completed_step.signature_id = completed_signature.id) LEFT JOIN project_participant completed_participant    ON completed_signature.project_participant_id = completed_participant.id) LEFT JOIN organisation_person completed_organisation_person  ON completed_participant.organisation_person_id = completed_organisation_person.id) LEFT JOIN person completed_person                      ON completed_organisation_person.person_id = completed_person.id) LEFT JOIN plott_order_item plot_order_item             ON plot_order_item.order_contract_id = plot_order.id) LEFT JOIN plott_properties plot_properties             ON plot_order_item.plott_properties_id = plot_properties.id) LEFT JOIN project_participant                          ON plot_order_item.initiator_id = project_participant.id) LEFT JOIN organisation_person                          ON project_participant.organisation_person_id = organisation_person.id) LEFT JOIN person                                       ON organisation_person.person_id = person.id) LEFT JOIN review_cycle_node_instance_released          ON plot_order_item.node_instance_release_id = review_cycle_node_instance_released.id) LEFT JOIN review_cycle_node                            ON review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id) LEFT JOIN order_step received_step                     ON received_step.order_item_id = plot_order_item.id) LEFT JOIN signature                                    ON received_step.signature_id = signature.id) LEFT JOIN project_participant signature_participant    ON signature.project_participant_id = signature_participant.id) LEFT JOIN organisation_person signature_organisation_person            ON signature_participant.organisation_person_id = signature_organisation_person.id) LEFT JOIN person signature_person                      ON signature_organisation_person.person_id = signature_person.id) LEFT JOIN order_address delivery_address               ON plot_order_item.delivery_address_id = delivery_address.id) LEFT JOIN countries delivery_country                   ON delivery_address.country_id = delivery_country.id) LEFT JOIN document_version                             ON plot_order_item.document_version_id = document_version.id) LEFT JOIN document                                     ON document_version.document_id = document.id) LEFT JOIN document_list                                ON document.document_list_id = document_list.id) LEFT JOIN sub_project                                  ON document_list.sub_project_id = sub_project.id) LEFT JOIN document_list_release                        ON document_list_release.sub_project_id = sub_project.id AND document_list_release.version = (SELECT max(local_document_list_release.version) FROM document_list_release local_document_list_release WHERE local_document_list_release.sub_project_id = sub_project.id)) LEFT JOIN document_release                             ON document_release.document_id = document.id AND document_release.document_list_id = document_list_release.id) WHERE plot_order.id = ?";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlotOrderEditJoin>>(){

            public List<PlotOrderEditJoin> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)plotOrderId);
                ResultSet rs = statement.executeQuery();
                ArrayList<PlotOrderEditJoin> ret = new ArrayList<PlotOrderEditJoin>();
                while (rs.next()) {
                    PlotOrderEditJoin joinDto = AbstractJdbcPlottOrderDAO.fillPlotOrderEditJoinFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }

    @Override
    public List<PlotOrderZipExportJoin> getPlotOrderZipExportJoin(final Long plotOrderId) {
        String sql = "SELECT " + JdbcPlottOrderDAO.getPlotOrderZipExportJoinSelectClause() + "FROM (((((( plott_order plot_order LEFT JOIN plott_order_item plot_order_item     ON plot_order_item.order_contract_id = plot_order.id) LEFT JOIN plott_properties plot_properties     ON plot_order_item.plott_properties_id = plot_properties.id) LEFT JOIN order_address delivery_address       ON plot_order_item.delivery_address_id = delivery_address.id) LEFT JOIN countries delivery_country           ON delivery_address.country_id = delivery_country.id) LEFT JOIN document_version                     ON plot_order_item.document_version_id = document_version.id) LEFT JOIN document                             ON document_version.document_id = document.id) WHERE plot_order.id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlotOrderZipExportJoin>>(){

            public List<PlotOrderZipExportJoin> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)plotOrderId);
                ResultSet rs = statement.executeQuery();
                ArrayList<PlotOrderZipExportJoin> ret = new ArrayList<PlotOrderZipExportJoin>();
                while (rs.next()) {
                    PlotOrderZipExportJoin joinDto = AbstractJdbcPlottOrderDAO.fillPlotOrderZipExportJoinFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }

    @Override
    public List<PlottOrder> getUnfinishedByTemplate(final Long plotOrderTemplateId) {
        String sql = "SELECT " + JdbcPlottOrderDAO.getSelectClauseForDto() + "FROM  ((( plott_order_template JOIN project_participation                    ON plott_order_template.plotter_id = project_participation.id) JOIN plott_order                              ON      plott_order.project_id = plott_order_template.project_id AND plott_order.plotter_id = project_participation.organisation_id) JOIN order_step acceptance_step               ON      plott_order.acceptance_id = acceptance_step.id AND acceptance_step.finished IS NULL) WHERE plott_order_template.id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlottOrder>>(){

            public List<PlottOrder> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)plotOrderTemplateId);
                ResultSet rs = statement.executeQuery();
                ArrayList<PlottOrder> ret = new ArrayList<PlottOrder>();
                while (rs.next()) {
                    PlottOrder joinDto = JdbcPlottOrderDAO.this.fillDtoFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }

    @Override
    public List<PlottOrder> getUnfinishedByProjectAndPersons(final Long projectId, final Collection<Long> organisationPersonIds) {
        String sql = "SELECT DISTINCT " + JdbcPlottOrderDAO.getSelectClauseForDto() + "FROM plott_order JOIN plott_order_item ON plott_order_item.order_contract_id = plott_order.id WHERE plott_order.project_id = ? AND   plott_order_item.receiver_organisation_person_id IN (" + QueryHelper.getPlaceHolderSequence(organisationPersonIds.size()) + ") ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlottOrder>>(){

            public List<PlottOrder> perform(PreparedStatement statement) throws Exception {
                int currentIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currentIndex++, (Number)projectId);
                for (Long id : organisationPersonIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currentIndex++, (Number)id);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<PlottOrder> ret = new ArrayList<PlottOrder>();
                while (rs.next()) {
                    PlottOrder joinDto = JdbcPlottOrderDAO.this.fillDtoFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }

    @Override
    public List<PlotTaskJoin> getPlotTaskJoinsByOrderIdWithoutTask(Long plotOrderId) {
        String sql = "SELECT " + JdbcPlottOrderDAO.getPlotTaskJoinSelectClause() + "FROM (((( plott_order plot_order LEFT JOIN project                           ON plot_order.project_id = project.id LEFT JOIN network                           ON project.network_id = network.id LEFT JOIN order_address billing_address     ON plot_order.billing_address_id = billing_address.id LEFT JOIN countries billing_country         ON billing_address.country_id = billing_country.id LEFT JOIN organisation plotter_organisation ON plot_order.plotter_id = plotter_organisation.id LEFT JOIN countries plotter_country         ON plotter_organisation.country_id = plotter_country.id LEFT JOIN plott_order_item plot_order_item  ON plot_order_item.order_contract_id = plot_order.id LEFT JOIN (     order_step received_step JOIN received_plott_order_step ON received_plott_order_step.order_step_id = received_step.id) ON     received_step.order_item_id = plot_order_item.id AND received_plott_order_step.order_id = plot_order.id LEFT JOIN signature received_signature      ON received_step.signature_id = received_signature.id LEFT JOIN project_participant received_participant ON received_signature.project_participant_id = received_participant.id LEFT JOIN organisation_person received_organisation_person ON received_participant.organisation_person_id = received_organisation_person.id LEFT JOIN organisation received_organisation ON received_organisation_person.organisation_id = received_organisation.id LEFT JOIN person received_person            ON received_organisation_person.person_id = received_person.id LEFT JOIN plott_properties plot_properties  ON plot_order_item.plott_properties_id = plot_properties.id LEFT JOIN order_address delivery_address    ON plot_order_item.delivery_address_id = delivery_address.id LEFT JOIN countries delivery_country        ON delivery_address.country_id = delivery_country.id LEFT JOIN document_version                  ON plot_order_item.document_version_id = document_version.id LEFT JOIN document                          ON document_version.document_id = document.id LEFT JOIN document_list                     ON document.document_list_id = document_list.id LEFT JOIN document_list_release             ON     document_list_release.document_list_id = document_list.id AND document_list_release.version = document_list.version - 1 LEFT JOIN document_release                  ON     document_release.document_id = document.id AND document_release.document_list_id = document_list_release.id LEFT JOIN sub_project                       ON document_list.sub_project_id = sub_project.id LEFT JOIN project_participant initiator_participant ON plot_order_item.initiator_id = initiator_participant.id LEFT JOIN organisation_person initiator_op  ON initiator_participant.organisation_person_id = initiator_op.id LEFT JOIN person initiator_person           ON initiator_op.person_id = initiator_person.id LEFT JOIN review_cycle_node_instance_released ON plot_order_item.node_instance_release_id = review_cycle_node_instance_released.id LEFT JOIN review_cycle_node                 ON review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id LEFT JOIN order_step request_step           ON plot_order.request_id = request_step.id LEFT JOIN signature request_signature       ON request_step.signature_id = request_signature.id LEFT JOIN project_participant request_participant ON request_signature.project_participant_id = request_participant.id LEFT JOIN organisation_person request_organisation_person ON request_participant.organisation_person_id = request_organisation_person.id LEFT JOIN organisation request_organisation ON request_organisation_person.organisation_id = request_organisation.id LEFT JOIN person request_person             ON request_organisation_person.person_id = request_person.id LEFT JOIN order_step acceptance_step        ON plot_order.acceptance_id = acceptance_step.id LEFT JOIN signature acceptance_signature    ON acceptance_step.signature_id = acceptance_signature.id LEFT JOIN project_participant acceptance_participant ON acceptance_signature.project_participant_id = acceptance_participant.id LEFT JOIN organisation_person acceptance_organisation_person ON acceptance_participant.organisation_person_id = acceptance_organisation_person.id LEFT JOIN organisation acceptance_organisation ON acceptance_organisation_person.organisation_id = acceptance_organisation.id LEFT JOIN person acceptance_person          ON acceptance_organisation_person.person_id = acceptance_person.id LEFT JOIN document_version_task             ON 1=0 LEFT JOIN order_step task_step              ON 1=0 " + JdbcDocumentVersionDAO.getPreviewSupportDocumentVersionClause() + "WHERE plot_order.id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcPlottOrderDAO::fillPlotTaskJoinFromResultSet, statement -> {
            int currIndex = 1;
            currIndex = JdbcDocumentVersionDAO.populatePreviewSupportDocumentVersionClause(statement, currIndex);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)plotOrderId);
        });
    }

    @Override
    public List<PlotTaskJoin> getPlotTaskJoins(Long taskId, String plotTaskTable) {
        String sql = "SELECT " + JdbcPlottOrderDAO.getPlotTaskJoinSelectClause() + "FROM (((( document_version_task JOIN " + plotTaskTable + " base_task   ON document_version_task.task_id = base_task.task_id LEFT JOIN plott_order plot_order            ON base_task.order_id = plot_order.id LEFT JOIN project                           ON plot_order.project_id = project.id LEFT JOIN network                           ON project.network_id = network.id LEFT JOIN order_address billing_address     ON plot_order.billing_address_id = billing_address.id LEFT JOIN countries billing_country         ON billing_address.country_id = billing_country.id LEFT JOIN organisation plotter_organisation ON plot_order.plotter_id = plotter_organisation.id LEFT JOIN countries plotter_country         ON plotter_organisation.country_id = plotter_country.id LEFT JOIN plott_order_item plot_order_item  ON plot_order_item.order_contract_id = plot_order.id LEFT JOIN (     order_step received_step JOIN received_plott_order_step ON received_plott_order_step.order_step_id = received_step.id) ON     received_step.order_item_id = plot_order_item.id AND received_plott_order_step.order_id = plot_order.id LEFT JOIN signature received_signature      ON received_step.signature_id = received_signature.id LEFT JOIN project_participant received_participant ON received_signature.project_participant_id = received_participant.id LEFT JOIN organisation_person received_organisation_person ON received_participant.organisation_person_id = received_organisation_person.id LEFT JOIN organisation received_organisation ON received_organisation_person.organisation_id = received_organisation.id LEFT JOIN person received_person            ON received_organisation_person.person_id = received_person.id LEFT JOIN plott_properties plot_properties  ON plot_order_item.plott_properties_id = plot_properties.id LEFT JOIN order_address delivery_address    ON plot_order_item.delivery_address_id = delivery_address.id LEFT JOIN countries delivery_country        ON delivery_address.country_id = delivery_country.id LEFT JOIN document_version                  ON plot_order_item.document_version_id = document_version.id LEFT JOIN document                          ON document_version.document_id = document.id LEFT JOIN document_list                     ON document.document_list_id = document_list.id LEFT JOIN document_list_release             ON     document_list_release.document_list_id = document_list.id AND document_list_release.version = document_list.version - 1 LEFT JOIN document_release                  ON     document_release.document_id = document.id AND document_release.document_list_id = document_list_release.id LEFT JOIN sub_project                       ON document_list.sub_project_id = sub_project.id LEFT JOIN project_participant initiator_participant ON plot_order_item.initiator_id = initiator_participant.id LEFT JOIN organisation_person initiator_op  ON initiator_participant.organisation_person_id = initiator_op.id LEFT JOIN person initiator_person           ON initiator_op.person_id = initiator_person.id LEFT JOIN review_cycle_node_instance_released ON plot_order_item.node_instance_release_id = review_cycle_node_instance_released.id LEFT JOIN review_cycle_node                 ON review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id LEFT JOIN order_step request_step           ON plot_order.request_id = request_step.id LEFT JOIN signature request_signature       ON request_step.signature_id = request_signature.id LEFT JOIN project_participant request_participant ON request_signature.project_participant_id = request_participant.id LEFT JOIN organisation_person request_organisation_person ON request_participant.organisation_person_id = request_organisation_person.id LEFT JOIN organisation request_organisation ON request_organisation_person.organisation_id = request_organisation.id LEFT JOIN person request_person             ON request_organisation_person.person_id = request_person.id LEFT JOIN order_step acceptance_step        ON plot_order.acceptance_id = acceptance_step.id LEFT JOIN signature acceptance_signature    ON acceptance_step.signature_id = acceptance_signature.id LEFT JOIN project_participant acceptance_participant ON acceptance_signature.project_participant_id = acceptance_participant.id LEFT JOIN organisation_person acceptance_organisation_person ON acceptance_participant.organisation_person_id = acceptance_organisation_person.id LEFT JOIN organisation acceptance_organisation ON acceptance_organisation_person.organisation_id = acceptance_organisation.id LEFT JOIN person acceptance_person          ON acceptance_organisation_person.person_id = acceptance_person.id LEFT JOIN order_step completed_step        ON plot_order.completed_id = completed_step.id LEFT JOIN signature completed_signature    ON completed_step.signature_id = completed_signature.id LEFT JOIN project_participant completed_participant ON completed_signature.project_participant_id = completed_participant.id LEFT JOIN organisation_person completed_organisation_person ON completed_participant.organisation_person_id = completed_organisation_person.id LEFT JOIN organisation completed_organisation ON completed_organisation_person.organisation_id = completed_organisation.id LEFT JOIN person completed_person          ON completed_organisation_person.person_id = completed_person.id LEFT JOIN order_step task_step              ON base_task.order_step_id = task_step.id " + JdbcDocumentVersionDAO.getPreviewSupportDocumentVersionClause() + "WHERE document_version_task.task_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcPlottOrderDAO::fillPlotTaskJoinFromResultSet, statement -> {
            int currIndex = 1;
            currIndex = JdbcDocumentVersionDAO.populatePreviewSupportDocumentVersionClause(statement, currIndex);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)taskId);
        });
    }
}

