/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.compositeDto.PersonCertificates;
import at.cdes.api.compositeDto.VersionInfo;
import at.cdes.api.dto.Ca;
import at.cdes.api.dto.CdesRole;
import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.CertificateRequest;
import at.cdes.api.dto.Email;
import at.cdes.api.dto.InfoMessage;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.OldPassword;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.PersonSearchModel;
import at.cdes.api.dto.PersonVariables;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.Search;
import at.cdes.api.dto.SubProject;
import at.cdes.api.dto.util.MainUiInfo;
import at.cdes.api.guiService.ContextService;
import at.cdes.api.guiService.PersonService;
import at.cdes.api.guiService.TabSessionContextService;
import at.cdes.api.joinDto.CertificateRequestJoin;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.joinDto.ParticipationInvalidatableJoin;
import at.cdes.api.joinDto.PersonJoin;
import at.cdes.api.joinDto.PersonSearchJoin;
import at.cdes.api.joinDto.ProjectParticipationJoin;
import at.cdes.api.person.PersonPasswordChanger;
import at.cdes.api.person.compositeDto.OrganisationPersonDeleteInfo;
import at.cdes.api.person.compositeDto.PasswordRequirements;
import at.cdes.api.person.compositeDto.PersonEditInfo;
import at.cdes.api.person.compositeDto.PersonInfo;
import at.cdes.api.person.compositeDto.PersonOwnEditInfo;
import at.cdes.api.person.compositeDto.PersonSearchInfo;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.sec.TabSessionService;
import at.cdes.api.voc.EmailSendMode;
import at.cdes.api.voc.ProjectStatus;
import at.cdes.api.voc.action.Action;
import at.cdes.api.voc.person.PersonStatus;
import at.cdes.impl.certificate.CertificateUtils;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.CaDAO;
import at.cdes.impl.dao.CdesRoleDAO;
import at.cdes.impl.dao.CertificateDAO;
import at.cdes.impl.dao.CertificateRequestDAO;
import at.cdes.impl.dao.CountryDAO;
import at.cdes.impl.dao.EmailDAO;
import at.cdes.impl.dao.InfoMessageDAO;
import at.cdes.impl.dao.NetworkDAO;
import at.cdes.impl.dao.ObjectPlannerDAO;
import at.cdes.impl.dao.ObjectPlannerPositionDAO;
import at.cdes.impl.dao.ObjectPlannerReleaseDAO;
import at.cdes.impl.dao.OldPasswordDAO;
import at.cdes.impl.dao.OrganisationDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PersonDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ProjectParticipantDAO;
import at.cdes.impl.dao.ProjectParticipationDAO;
import at.cdes.impl.dao.SearchDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.dao.jdbc.JdbcProjectParticipationDAO;
import at.cdes.impl.dao.unionComponent.ParticipationInvalidatableComponent;
import at.cdes.impl.dao.unionComponent.PersonSearchComponent;
import at.cdes.impl.export.person.PersonListExporter;
import at.cdes.impl.export.person.PersonListPdfCallable;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.project.ProjectUtils;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.util.ActionHelper;
import at.cdes.impl.util.BatchedDAOGetter;
import at.cdes.impl.util.BatchedDAOGetterMap;
import at.cdes.impl.util.ContainerHelper;
import at.cdes.impl.util.GroupHelper;
import at.cdes.impl.util.PasswordUtil;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SearchHelper;
import at.cdes.impl.util.i18n.I18nHelper;
import at.cdes.impl.util.sql.ForeignKeyHelper;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.lang.Pair;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.clazzes.util.sql.helper.ForeignKeyInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonServiceImpl
implements PersonService {
    private ActionDAO actionDAO;
    private CaDAO caDAO;
    private CdesRoleDAO cdesRoleDAO;
    private CertificateDAO certificateDAO;
    private CertificateRequestDAO certificateRequestDAO;
    private CertificateUtils certificateUtils;
    private CountryDAO countryDAO;
    private EmailDAO emailDAO;
    private Boolean enableCustomerLogo;
    private Boolean isTestInstance;
    private String externalManualLink;
    private InfoMessageDAO infoMessageDAO;
    private Integer maximumNumberOfOldPasswords;
    private NetworkDAO networkDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private ObjectPlannerPositionDAO objectPlannerPositionDAO;
    private ObjectPlannerReleaseDAO objectPlannerReleaseDAO;
    private OldPasswordDAO oldPasswordDAO;
    private IOneTimeScheduler oneTimeScheduler;
    private OrganisationDAO organisationDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private Integer passwordMinLength;
    private PersonDAO personDAO;
    private PersonListExporter personListExporter;
    private PersonPasswordChanger personPasswordChanger;
    private PersonVariablesDAO personVariablesDAO;
    private ProjectDAO projectDAO;
    private ProjectParticipantDAO projectParticipantDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private ProjectUtils projectUtils;
    private Integer securityAnswerMinLength;
    private SearchDAO searchDAO;
    private SubProjectDAO subProjectDAO;
    private int sqlQueryBatchSize;
    private TabSessionService tabSessionService;
    private TabSessionContextService tabSessionContextService;
    private Boolean enableLocaleSelection;
    private Boolean enableAutoInitSearch;
    private Boolean certificateAdministrationGlobal;
    private ContextService contextService;
    private static final Logger log = LoggerFactory.getLogger(PersonServiceImpl.class);

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setCaDAO(CaDAO caDAO) {
        this.caDAO = caDAO;
    }

    public void setCdesRoleDAO(CdesRoleDAO cdesRoleDAO) {
        this.cdesRoleDAO = cdesRoleDAO;
    }

    public void setCertificateDAO(CertificateDAO certificateDAO) {
        this.certificateDAO = certificateDAO;
    }

    public void setCertificateRequestDAO(CertificateRequestDAO certificateRequestDAO) {
        this.certificateRequestDAO = certificateRequestDAO;
    }

    public void setCertificateUtils(CertificateUtils certificateUtils) {
        this.certificateUtils = certificateUtils;
    }

    public void setCountryDAO(CountryDAO countryDAO) {
        this.countryDAO = countryDAO;
    }

    public void setEmailDAO(EmailDAO emailDAO) {
        this.emailDAO = emailDAO;
    }

    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public void setIsTestInstance(Boolean isTestInstance) {
        this.isTestInstance = isTestInstance;
    }

    public void setExternalManualLink(String externalManualLink) {
        this.externalManualLink = externalManualLink;
    }

    public void setInfoMessageDAO(InfoMessageDAO infoMessageDAO) {
        this.infoMessageDAO = infoMessageDAO;
    }

    public void setMaximumNumberOfOldPasswords(Integer maximumNumberOfOldPasswords) {
        this.maximumNumberOfOldPasswords = maximumNumberOfOldPasswords;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    public void setObjectPlannerPositionDAO(ObjectPlannerPositionDAO objectPlannerPositionDAO) {
        this.objectPlannerPositionDAO = objectPlannerPositionDAO;
    }

    public void setObjectPlannerReleaseDAO(ObjectPlannerReleaseDAO objectPlannerReleaseDAO) {
        this.objectPlannerReleaseDAO = objectPlannerReleaseDAO;
    }

    public void setOldPasswordDAO(OldPasswordDAO oldPasswordDAO) {
        this.oldPasswordDAO = oldPasswordDAO;
    }

    public void setOneTimeScheduler(IOneTimeScheduler oneTimeScheduler) {
        this.oneTimeScheduler = oneTimeScheduler;
    }

    public void setOrganisationDAO(OrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPasswordMinLength(Integer passwordMinLength) {
        this.passwordMinLength = passwordMinLength;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public void setPersonListExporter(PersonListExporter personListExporter) {
        this.personListExporter = personListExporter;
    }

    public void setPersonPasswordChanger(PersonPasswordChanger personPasswordChanger) {
        this.personPasswordChanger = personPasswordChanger;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setProjectUtils(ProjectUtils projectUtils) {
        this.projectUtils = projectUtils;
    }

    public void setSecurityAnswerMinLength(Integer securityAnswerMinLength) {
        this.securityAnswerMinLength = securityAnswerMinLength;
    }

    public void setSearchDAO(SearchDAO searchDAO) {
        this.searchDAO = searchDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setSqlQueryBatchSize(int sqlQueryBatchSize) {
        this.sqlQueryBatchSize = sqlQueryBatchSize;
    }

    public void setTabSessionService(TabSessionService tabSessionService) {
        this.tabSessionService = tabSessionService;
    }

    public void setTabSessionContextService(TabSessionContextService tabSessionContextService) {
        this.tabSessionContextService = tabSessionContextService;
    }

    public void setEnableLocaleSelection(Boolean enableLocaleSelection) {
        this.enableLocaleSelection = enableLocaleSelection;
    }

    public void setEnableAutoInitSearch(Boolean enableAutoInitSearch) {
        this.enableAutoInitSearch = enableAutoInitSearch;
    }

    public void setCertificateAdministrationGlobal(Boolean certificateAdministrationGlobal) {
        this.certificateAdministrationGlobal = certificateAdministrationGlobal;
    }

    public void setContextService(ContextService contextService) {
        this.contextService = contextService;
    }

    public boolean mayInvalidateUserLoginAndCertificates(Long organisationPersonId, Long personId) {
        try {
            List<Certificate> certificates = this.personDAO.getCertificatesByPerson(personId, true);
            this.checkInvalidateUserLoginAndCertificates(certificates, organisationPersonId, personId);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private void checkInvalidateUserLoginAndCertificates(List<Certificate> certificates, Long organisationPersonId, Long personId) {
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.ADMINISTRATE_CERTIFICATE);
        List<Long> networkIds = this.personDAO.getNetworkIdsViaNetworkOrganisation(personId);
        String networkIdString = "[";
        for (int n = 0; n < networkIds.size(); ++n) {
            networkIdString = networkIdString + networkIds.get(n);
            networkIdString = networkIdString + (n < networkIds.size() - 1 ? ", " : "]");
        }
        if (this.certificateAdministrationGlobal.booleanValue() && !actions.contains(Action.ADMINISTRATE_CERTIFICATE) || !this.certificateAdministrationGlobal.booleanValue() && !ActionHelper.hasActionsForAllNetworks(this.actionDAO, organisationPersonId, networkIds, Action.EDIT_PERSON, Action.EDIT_ORGANISATION_PERSON)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is missing privilege [editPerson, editOrganisationPerson] for one of the networks [" + networkIdString + "] of person [" + personId + "].  Thus deleting the access of that person is not allowed.");
        }
        ArrayList<Long> caIds = new ArrayList<Long>();
        for (Certificate certificate : certificates) {
            if (certificate.getCaCertId() == null) continue;
            caIds.add(certificate.getCaCertId());
        }
        List cas = this.caDAO.getBatch(caIds);
        HashMap<Long, Ca> caIdToCa = new HashMap<Long, Ca>();
        for (Ca ca : cas) {
            caIdToCa.put(ca.getId(), ca);
        }
        for (Certificate certificate : certificates) {
            if (!certificate.isMayLogin().booleanValue() && !certificate.isMaySign().booleanValue()) continue;
            Ca ca = (Ca)caIdToCa.get(certificate.getCaCertId());
            if (ca.getCaCertId() != null && ca.getNetworkId() == null) {
                throw new SecurityException("Ca [" + ca.getId() + "] has no network id, thus no privilege check can be performed, thus invalidating certificate [" + certificate.getId() + "] for deleting the access of person [" + personId + "] is not allowed.");
            }
            if ((!this.certificateAdministrationGlobal.booleanValue() || actions.contains(Action.ADMINISTRATE_CERTIFICATE)) && (this.certificateAdministrationGlobal.booleanValue() || ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, ca.getNetworkId(), Action.EDIT_PERSON, Action.EDIT_ORGANISATION_PERSON))) continue;
            throw new SecurityException("No privilege [editPerson, editOrganisationPerson or administrateCertificate] to invalidate certificate [" + certificate.getId() + "] signed with ca [" + ca.getId() + "] with network [" + ca.getNetworkId() + "] exists for organisationPersonId [" + organisationPersonId + "].  Thus deleting the access of person [" + personId + "] is not allowed.");
        }
    }

    public PersonCertificates invalidateUserLoginAndCertificates(Long organisationPersonId, Long personId) {
        Person person = (Person)this.personDAO.get(personId);
        List<Certificate> certificates = this.personDAO.getCertificatesByPerson(personId, true);
        this.checkInvalidateUserLoginAndCertificates(certificates, organisationPersonId, personId);
        for (Certificate certificate : certificates) {
            certificate.setMaySign(Boolean.valueOf(false));
            certificate.setMayLogin(Boolean.valueOf(false));
        }
        this.certificateDAO.updateBatch(certificates);
        person.setLogin(null);
        person.setPassword(null);
        this.personDAO.update(person);
        PersonCertificates personCertificates = new PersonCertificates();
        personCertificates.setPerson(person);
        personCertificates.setCertificates(certificates);
        return personCertificates;
    }

    public PersonSearchInfo getPersonSearchInfo(Long organisationPersonId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        this.checkForGlobalNetworkActions(organisationPersonId);
        PersonSearchInfo personSearchInfo = new PersonSearchInfo();
        List<PersonSearchJoin> personSearchJoins = this.personDAO.getPersonSearchJoinByNetwork(networkId, false);
        ArrayList<Person> persons = new ArrayList<Person>();
        ArrayList<Organisation> organisations = new ArrayList<Organisation>();
        ArrayList<Network> networks = new ArrayList<Network>();
        ArrayList<Project> projects = new ArrayList<Project>();
        ArrayList<CdesRole> roles = new ArrayList<CdesRole>();
        for (PersonSearchJoin personSearchJoin : personSearchJoins) {
            int unionClause = personSearchJoin.getUnionClause();
            if (unionClause == PersonSearchComponent.PERSON.getValue()) {
                persons.add(personSearchJoin.getPerson());
                continue;
            }
            if (unionClause == PersonSearchComponent.ORGANISATION.getValue()) {
                organisations.add(personSearchJoin.getOrganisation());
                continue;
            }
            if (unionClause == PersonSearchComponent.NETWORK.getValue()) {
                networks.add(personSearchJoin.getNetwork());
                continue;
            }
            if (unionClause == PersonSearchComponent.PROJECT.getValue()) {
                projects.add(personSearchJoin.getProject());
                continue;
            }
            if (unionClause == PersonSearchComponent.ROLE.getValue()) {
                roles.add(personSearchJoin.getCdesRole());
                continue;
            }
            throw new IllegalArgumentException("Found illegal unionClause [" + unionClause + "] when processing results of [JdbcPersonDAO.getPersonSearchJoinByNetwork].  Please check at.cdes.impl.service.PersonServiceImpl.getPersonSearchInfo(Long, Long) and at.cdes.impl.dao.jdbc.JdbcPersonDAO.getPersonSearchJoinByNetwork(Long, Boolean).");
        }
        personSearchInfo.setEnableAutoInitSearch(this.enableAutoInitSearch.booleanValue());
        personSearchInfo.setNetworkId(networkId);
        for (Person person : persons) {
            PersonHelper.removeSecurityPersonData(person);
        }
        personSearchInfo.setPersons(persons);
        personSearchInfo.setOrganisations(organisations);
        personSearchInfo.setNetworks(networks);
        personSearchInfo.setProjects(projects);
        personSearchInfo.setRoles(roles);
        List<Network> administratedNetworks = this.networkDAO.getNetworksToAdmin(organisationPersonId);
        personSearchInfo.setAdministratedNetworks(administratedNetworks);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkActions(organisationPersonId, Action.EDIT_PERSON, Action.SHOW_PERSON);
        HashMap<String, Boolean> networkActionMap = new HashMap<String, Boolean>();
        for (Long currNetworkId : networkIdToActions.keySet()) {
            Set<Action> actions = networkIdToActions.get(currNetworkId);
            for (Action action : actions) {
                networkActionMap.put(action.getName(), true);
            }
        }
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.ADMINISTRATE_CERTIFICATE);
        personSearchInfo.setGlobalActions(ActionHelper.convertEnumToString(globalActions));
        personSearchInfo.setNetworkActions(networkActionMap);
        personSearchInfo.setCertificateAdministrationGlobal(this.certificateAdministrationGlobal);
        return personSearchInfo;
    }

    public PersonInfo getPersonJoins(PersonSearchModel searchModel) {
        Object currOrganisationPersonId4;
        Object organisationIdToJoin;
        Object personId;
        Long organisationPersonId = searchModel.getOrganisationPersonId();
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        this.checkForGlobalNetworkActions(organisationPersonId);
        List<PersonJoin> personJoins = this.personDAO.getPersonJoins(searchModel);
        HashMap<Long, PersonJoin> organisationPersonIdToJoin = new HashMap<Long, PersonJoin>();
        for (PersonJoin personJoin : personJoins) {
            Long currOrganisationPersonId2 = personJoin.getOrganisationPersonId();
            organisationPersonIdToJoin.put(currOrganisationPersonId2, personJoin);
        }
        ArrayList organisationPersonJoins = new ArrayList();
        organisationPersonJoins.addAll(organisationPersonIdToJoin.values());
        final HashSet<Long> organisationIds = new HashSet<Long>();
        HashMap<Long, Person> personIdToPerson = new HashMap<Long, Person>();
        HashMap personIdToOrganisationJoins = new HashMap();
        HashMap organisationPersonIdToParticipationJoins = new HashMap();
        for (PersonJoin personJoin : personJoins) {
            Person person = personJoin.getPerson();
            personId = person.getId();
            personIdToPerson.put((Long)personId, PersonHelper.removeSecurityPersonData(person));
            Long organisationId = personJoin.getOrganisationId();
            if (organisationId != null) {
                if (!personIdToOrganisationJoins.containsKey(personId)) {
                    personIdToOrganisationJoins.put((Long)personId, new HashMap());
                }
                organisationIdToJoin = (Map)personIdToOrganisationJoins.get(personId);
                organisationIdToJoin.put(organisationId, personJoin);
                organisationIds.add(organisationId);
            }
            Long currOrganisationPersonId3 = personJoin.getOrganisationPersonId();
            Long participationId = personJoin.getProjectParticipationId();
            if (participationId == null) continue;
            if (!organisationPersonIdToParticipationJoins.containsKey(currOrganisationPersonId3)) {
                organisationPersonIdToParticipationJoins.put(currOrganisationPersonId3, new HashMap());
            }
            Map participationIdToJoin = (Map)organisationPersonIdToParticipationJoins.get(currOrganisationPersonId3);
            participationIdToJoin.put(participationId, personJoin);
        }
        ArrayList<Long> organisationIdsList = new ArrayList<Long>();
        organisationIdsList.addAll(organisationIds);
        Map<Long, List<Network>> organisationIdToNetworks = QueryHelper.executeDAOGetter(organisationIdsList, this.sqlQueryBatchSize / 2, new BatchedDAOGetterMap<List<Network>, Long>(){

            @Override
            public Map<Long, List<Network>> execute(List<Long> ids) {
                return PersonServiceImpl.this.networkDAO.getNetworksByOrganisations(organisationIds);
            }
        });
        HashMap personIdToOrganisationJoinList = new HashMap();
        personId = personIdToOrganisationJoins.keySet().iterator();
        while (personId.hasNext()) {
            Long personId2;
            organisationIdToJoin = (Map)personIdToOrganisationJoins.get(personId2 = (Long)personId.next());
            personIdToOrganisationJoinList.put(personId2, organisationIdToJoin != null ? organisationIdToJoin.values() : null);
        }
        HashMap organisationPersonIdToProjects = new HashMap();
        HashMap organisationPersonIdToProjectIdToRoleJoins = new HashMap();
        for (Object currOrganisationPersonId4 : organisationPersonIdToParticipationJoins.keySet()) {
            HashMap<Long, Project> projectIdToProject = new HashMap<Long, Project>();
            HashMap projectIdToParticipationIdToRoleJoin = new HashMap();
            Map participationIdToJoin = (Map)organisationPersonIdToParticipationJoins.get(currOrganisationPersonId4);
            for (PersonJoin participationJoin : participationIdToJoin.values()) {
                Project project = participationJoin.getProject();
                Long projectId = project.getId();
                projectIdToProject.put(projectId, project);
                if (!projectIdToParticipationIdToRoleJoin.containsKey(projectId)) {
                    projectIdToParticipationIdToRoleJoin.put(projectId, new HashMap());
                }
                ((Map)projectIdToParticipationIdToRoleJoin.get(projectId)).put(participationJoin.getProjectParticipationId(), participationJoin);
            }
            organisationPersonIdToProjects.put(currOrganisationPersonId4, projectIdToProject.values());
            HashMap projectIdToRoleJoins = new HashMap();
            for (Long projectId : projectIdToParticipationIdToRoleJoin.keySet()) {
                Map participationIdToRoleJoin = (Map)projectIdToParticipationIdToRoleJoin.get(projectId);
                if (participationIdToRoleJoin == null) continue;
                projectIdToRoleJoins.put(projectId, participationIdToRoleJoin.values());
            }
            organisationPersonIdToProjectIdToRoleJoins.put(currOrganisationPersonId4, projectIdToRoleJoins);
        }
        HashMap organisationPersonIdToParticipationJoinList = new HashMap();
        currOrganisationPersonId4 = organisationPersonIdToParticipationJoins.keySet().iterator();
        while (currOrganisationPersonId4.hasNext()) {
            Long currOrganisationPersonId5;
            Map participationIdToJoin = (Map)organisationPersonIdToParticipationJoins.get(currOrganisationPersonId5 = (Long)currOrganisationPersonId4.next());
            organisationPersonIdToParticipationJoinList.put(currOrganisationPersonId5, participationIdToJoin != null ? participationIdToJoin.values() : null);
        }
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkActions(organisationPersonId, Action.EDIT_PERSON, Action.SHOW_PERSON, Action.EDIT_ORGANISATION_PERSON, Action.DELETE_PERSON, Action.REFERENCE_ORGANISATION);
        PersonInfo personInfo = new PersonInfo();
        personInfo.setPersons(personIdToPerson.values());
        personInfo.setPersonIdToOrganisationJoins(personIdToOrganisationJoinList);
        personInfo.setOrganisationPersonIdToProjects(organisationPersonIdToProjects);
        personInfo.setOrganisationPersonIdToProjectIdToRoleJoins(organisationPersonIdToProjectIdToRoleJoins);
        personInfo.setOrganisationIdToNetworks(organisationIdToNetworks);
        personInfo.setNetworkIdToActions(ActionHelper.convertEnumToString(networkIdToActions));
        return personInfo;
    }

    public PersonEditInfo getPersonEditInfo(Long organisationPersonId, Long personId) {
        List<PersonVariables> personVariablesList;
        List<OrganisationPersonJoin> organisationPersonJoins;
        boolean hasEditPerson;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (personId == null) {
            hasEditPerson = false;
        } else {
            List<Network> networks = this.networkDAO.getNetworksByPerson(personId);
            List<Long> networkIds = ContainerHelper.getPersistentIdsList(networks);
            Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkToActionMap(organisationPersonId, networkIds, Action.EDIT_PERSON, Action.SHOW_PERSON);
            hasEditPerson = ActionHelper.hasActionsForAnyNetwork(networkIdToActions, Action.EDIT_PERSON);
            boolean hasShowPerson = ActionHelper.hasActionsForAnyNetwork(networkIdToActions, Action.SHOW_PERSON);
            if (!hasEditPerson && !hasShowPerson) {
                throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] has no privilege [editPerson] or [showPerson] to access person [" + personId + "]");
            }
        }
        Person person = personId == null ? new Person() : (Person)this.personDAO.get(personId);
        PersonHelper.removeSecurityPersonData(person);
        if (personId == null) {
            OrganisationPersonJoin newOrganisationPersonJoin = new OrganisationPersonJoin();
            newOrganisationPersonJoin.setOrganisationPersonEmailSendMode(Integer.valueOf(EmailSendMode.BRIEF.getValue()));
            newOrganisationPersonJoin.setOrganisationPersonEmailSendTime(Integer.valueOf(780));
            organisationPersonJoins = new ArrayList<OrganisationPersonJoin>();
            organisationPersonJoins.add(newOrganisationPersonJoin);
        } else {
            organisationPersonJoins = this.organisationPersonDAO.getOrganisationPersonJoinByPerson(personId);
        }
        PersonEditInfo personEditInfo = new PersonEditInfo();
        List<CdesRole> availableRoles = this.cdesRoleDAO.getWithoutNetwork();
        personEditInfo.setAvailableRoles(availableRoles);
        if (personId == null) {
            personEditInfo.setCertificateRequestJoins(new ArrayList());
        } else if (hasEditPerson) {
            List<CertificateRequestJoin> certificateRequestJoins = this.certificateDAO.getCertificateRequestJoinsWithRequestsByPerson(personId);
            personEditInfo.setCertificateRequestJoins(certificateRequestJoins);
        }
        List<Person> personNames = this.personDAO.getAllPersonNames();
        PersonVariables personVariables = personId == null ? new PersonVariables() : ((personVariablesList = this.personVariablesDAO.getByPerson(personId)).size() > 0 ? personVariablesList.get(0) : new PersonVariables());
        personEditInfo.setPerson(person);
        personEditInfo.setPersonVariables(personVariables);
        personEditInfo.setPersonNames(personNames);
        personEditInfo.setOrganisationPersonJoins(organisationPersonJoins);
        personEditInfo.setEnableLocaleSelection(this.enableLocaleSelection);
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.ROLES_GLOBAL_OVERVIEW, Action.ADMINISTRATE_CERTIFICATE);
        personEditInfo.setHasRolesGlobalOverview(Boolean.valueOf(globalActions.contains(Action.ROLES_GLOBAL_OVERVIEW)));
        personEditInfo.setHasCertificateAdministration(Boolean.valueOf(this.certificateAdministrationGlobal == false && hasEditPerson || this.certificateAdministrationGlobal != false && globalActions.contains(Action.ADMINISTRATE_CERTIFICATE)));
        return personEditInfo;
    }

    public List<OrganisationPersonJoin> getSimilarPersons(Long organisationPersonId, Person person) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<OrganisationPersonJoin> similarPersonJoins = this.getSimilarPersons(person, 2);
        return similarPersonJoins;
    }

    private List<OrganisationPersonJoin> getSimilarPersons(Person person, int maxDistance) {
        String baseGivenName = person.getGivenName();
        String baseSurName = person.getSurName();
        String baseName = (baseGivenName != null ? baseGivenName.trim() : "") + (baseSurName != null ? baseSurName.trim() : "");
        Long personId = person.getId();
        List<Person> candidates = this.personDAO.getSimilarPersonCandidates(personId);
        ArrayList<Person> matches = new ArrayList<Person>();
        for (Person candidatePerson : candidates) {
            String candidateGivenName = candidatePerson.getGivenName();
            String candidateSurName = candidatePerson.getSurName();
            String candidateName = (candidateGivenName != null ? candidateGivenName.trim() : "") + (candidateSurName != null ? candidateSurName.trim() : "");
            if (!SearchHelper.areStringsSimilar(baseName, candidateName, maxDistance)) continue;
            matches.add(candidatePerson);
        }
        List<Long> matchingPersonIds = ContainerHelper.getPersistentIdsList(matches);
        List<OrganisationPersonJoin> matchingOrganisationPersonJoins = this.organisationPersonDAO.getOrganisationPersonJoinByPersons(matchingPersonIds);
        for (OrganisationPersonJoin organisationPersonJoin : matchingOrganisationPersonJoins) {
            PersonHelper.removeSecurityPersonData(organisationPersonJoin);
        }
        return matchingOrganisationPersonJoins;
    }

    public OrganisationPerson saveOrganisationPerson(Long organisationPersonId, OrganisationPerson passedOrganisationPerson) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Long organisationId = passedOrganisationPerson.getOrganisationId();
        List<Network> networks = this.networkDAO.getNetworksByOrganisation(organisationId);
        List<Long> networkIds = ContainerHelper.getPersistentIdsList(networks);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkToActionMap(organisationPersonId, networkIds, Action.EDIT_PERSON);
        boolean actionFound = false;
        for (Network network : networks) {
            Long networkId = network.getId();
            Set<Action> actionNames = networkIdToActions.get(networkId);
            actionFound |= actionNames != null && actionNames.contains(Action.EDIT_PERSON);
        }
        if (!actionFound) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] has no privilege to touch an OrganisationPerson with Organisation [" + organisationId + "].  Would need:  The Organisation being member of a Network with permission [editPerson].");
        }
        Long personId = passedOrganisationPerson.getPersonId();
        OrganisationPerson organisationPerson = this.constructNewOrganisationPerson(personId, passedOrganisationPerson);
        this.checkAndCopyOrganisationPersonFieldsToSave(organisationPerson, passedOrganisationPerson);
        organisationPerson = (OrganisationPerson)this.organisationPersonDAO.save(organisationPerson);
        return organisationPerson;
    }

    public PersonEditInfo saveOrUpdatePersonAndOrganisationPersons(Long organisationPersonId, Person passedPerson, PersonVariables passedPersonVariables, Long existingPersonId, List<OrganisationPerson> passedOrganisationPersons, boolean fetchNewPersonEditInfo) {
        Long personId;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Long oldPersonId = existingPersonId != null ? existingPersonId : passedPerson.getId();
        Map<Long, OrganisationPerson> idToOldOrganisationPerson = this.getOldOrganisationPersons(oldPersonId);
        Map<Long, OrganisationPerson> idToNewOrganisationPerson = ContainerHelper.groupByIdIgnoreWithout(passedOrganisationPersons);
        Set<Object> deletedOrganisationPersonIds = existingPersonId != null ? new HashSet() : ContainerHelper.getDeletedKeys(idToOldOrganisationPerson, idToNewOrganisationPerson);
        final List<Long> relevantOrganisationIds = this.getAllRelevantOrganisationIds(idToOldOrganisationPerson, passedOrganisationPersons);
        Map<Long, List<Network>> organisationIdToNetworks = QueryHelper.executeDAOGetter(relevantOrganisationIds, this.sqlQueryBatchSize / 2, new BatchedDAOGetterMap<List<Network>, Long>(){

            @Override
            public Map<Long, List<Network>> execute(List<Long> ids) {
                return PersonServiceImpl.this.networkDAO.getNetworksByOrganisations(relevantOrganisationIds);
            }
        });
        List<Long> networkIds = ContainerHelper.getIdsFromMultiMapAsList(organisationIdToNetworks);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkToActionMap(organisationPersonId, networkIds, Action.EDIT_PERSON);
        for (OrganisationPerson oldOrganisationPerson : idToOldOrganisationPerson.values()) {
            this.checkForOrganisationPersonSavePermission(organisationPersonId, oldOrganisationPerson, organisationIdToNetworks, networkIdToActions);
        }
        for (OrganisationPerson newOrganisationPerson : passedOrganisationPersons) {
            this.checkForOrganisationPersonSavePermission(organisationPersonId, newOrganisationPerson, organisationIdToNetworks, networkIdToActions);
        }
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.ROLES_GLOBAL_OVERVIEW);
        Long l = personId = existingPersonId != null ? existingPersonId : passedPerson.getId();
        if (personId == null) {
            Person person = new Person();
            this.checkAndCopyPersonFieldsToSave(person, passedPerson, globalActions);
            person.setStatus(Integer.valueOf(PersonStatus.ACTIVE.getValue()));
            person = (Person)this.personDAO.save(person);
            personId = person.getId();
            PersonVariables personVariables = this.constructNewPersonVariables(person.getId(), passedPersonVariables);
            personVariables = (PersonVariables)this.personVariablesDAO.save(personVariables);
            List<OrganisationPerson> organisationPersons = new ArrayList();
            for (OrganisationPerson organisationPerson : passedOrganisationPersons) {
                OrganisationPerson organisationPerson2 = this.constructNewOrganisationPerson(person.getId(), organisationPerson);
                this.checkAndCopyOrganisationPersonFieldsToSave(organisationPerson2, organisationPerson);
                organisationPersons.add(organisationPerson2);
            }
            if (organisationPersons.size() > 0) {
                organisationPersons = this.organisationPersonDAO.saveBatch(organisationPersons);
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            arrayList.add(person.getId());
            for (OrganisationPerson organisationPerson2 : organisationPersons) {
                arrayList.add(organisationPerson2.getId());
            }
            return this.getUpdatedPersonEditInfo(organisationPersonId, personId, organisationPersons, fetchNewPersonEditInfo);
        }
        Person person = (Person)this.personDAO.get(personId);
        if (existingPersonId == null) {
            this.checkAndCopyPersonFieldsToSave(person, passedPerson, globalActions);
            this.personDAO.update(person);
            List<PersonVariables> oldPersonVariablesList = this.personVariablesDAO.getByPerson(personId);
            PersonVariables personVariables = oldPersonVariablesList.get(0);
            personVariables.setUserLocale(passedPersonVariables.getUserLocale());
            this.personVariablesDAO.update(personVariables);
        }
        ArrayList<OrganisationPerson> organisationPersons = new ArrayList<OrganisationPerson>();
        for (OrganisationPerson organisationPerson : passedOrganisationPersons) {
            if (organisationPerson.getId() == null || organisationPerson.getId() < 0L) {
                OrganisationPerson organisationPerson3 = this.constructNewOrganisationPerson(person.getId(), organisationPerson);
                this.checkAndCopyOrganisationPersonFieldsToSave(organisationPerson3, organisationPerson);
                OrganisationPerson organisationPerson4 = (OrganisationPerson)this.organisationPersonDAO.save(organisationPerson3);
                organisationPersons.add(organisationPerson4);
                continue;
            }
            OrganisationPerson organisationPerson5 = idToOldOrganisationPerson.get(organisationPerson.getId());
            this.checkAndCopyOrganisationPersonFieldsToSave(organisationPerson5, organisationPerson);
            this.organisationPersonDAO.update(organisationPerson5);
            organisationPersons.add(organisationPerson5);
        }
        for (Long l2 : deletedOrganisationPersonIds) {
            this.deleteOrganisationPerson(l2);
        }
        return this.getUpdatedPersonEditInfo(organisationPersonId, personId, organisationPersons, fetchNewPersonEditInfo);
    }

    private void deleteOrganisationPerson(Long organisationPersonId) {
        List<CertificateRequest> certificateRequests;
        List<Long> certificateRequestIds;
        List<Certificate> certificates = this.certificateDAO.getByOrganisationPerson(organisationPersonId);
        List<Long> certificateIds = ContainerHelper.getPersistentIdsList(certificates);
        if (certificateIds.size() > 0) {
            this.certificateDAO.deleteBatch(certificateIds);
        }
        if ((certificateRequestIds = ContainerHelper.getPersistentIdsList(certificateRequests = this.certificateRequestDAO.getByCreatedFor(organisationPersonId))).size() > 0) {
            this.certificateRequestDAO.deleteBatch(certificateRequestIds);
        }
        List<Email> emails = this.emailDAO.getByOrganisationPerson(organisationPersonId);
        for (Email email : emails) {
            email.setOrganisationPersonId(null);
        }
        this.emailDAO.updateBatch(emails);
        this.organisationPersonDAO.delete(organisationPersonId);
    }

    private Map<Long, OrganisationPerson> getOldOrganisationPersons(Long oldPersonId) {
        List<Object> oldOrganisationPersons = oldPersonId == null ? new ArrayList() : this.organisationPersonDAO.getByPerson(oldPersonId);
        return ContainerHelper.groupById(oldOrganisationPersons);
    }

    private List<Long> getAllRelevantOrganisationIds(Map<Long, OrganisationPerson> oldOrganisationPersonMap, List<OrganisationPerson> newOrganisationPersons) {
        HashSet<Long> organisationIds = new HashSet<Long>();
        for (OrganisationPerson organisationPerson : oldOrganisationPersonMap.values()) {
            organisationIds.add(organisationPerson.getOrganisationId());
        }
        for (OrganisationPerson organisationPerson : newOrganisationPersons) {
            organisationIds.add(organisationPerson.getOrganisationId());
        }
        ArrayList<Long> organisationIdsList = new ArrayList<Long>();
        organisationIdsList.addAll(organisationIds);
        return organisationIdsList;
    }

    private void checkForOrganisationPersonSavePermission(Long organisationPersonId, OrganisationPerson organisationPerson, Map<Long, List<Network>> organisationIdToNetworks, Map<Long, Set<Action>> networkIdToActions) {
        Long organisationId = organisationPerson.getOrganisationId();
        if (organisationId == null) {
            throw new IllegalArgumentException("Found OrganisationPerson [" + organisationPerson.getId() + "] without Organisation reference.");
        }
        boolean actionFound = false;
        List<Network> networks = organisationIdToNetworks.get(organisationId);
        for (Network network : networks) {
            Long networkId = network.getId();
            Set<Action> actions = networkIdToActions.get(networkId);
            actionFound |= actions != null && actions.contains(Action.EDIT_PERSON);
        }
        if (!actionFound) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] has no privilege to touch an OrganisationPerson with Organisation [" + organisationId + "].  Would need:  The Organisation being member of a Network with permission [editPerson].");
        }
    }

    private void checkAndCopyPersonFieldsToSave(Person person, Person passedPerson, Set<Action> globalActions) {
        CdesRole role;
        Integer contextDefaultRoleFlag;
        String gender = passedPerson.getGender();
        String string = gender = gender != null ? gender.trim() : null;
        if (gender == null || gender.length() == 0) {
            throw new IllegalArgumentException("Must field gender not given / the empty string.");
        }
        if (!("m".equals(gender) || "f".equals(gender) || "-".equals(gender))) {
            throw new IllegalArgumentException("Only values 'm', 'f' and '-' are allowed for gender.");
        }
        person.setGender(gender);
        Long roleId = passedPerson.getRoleId();
        QueryHelper.checkMandatoryValue(roleId, "roleId");
        if (!(globalActions.contains(Action.ROLES_GLOBAL_OVERVIEW) || (contextDefaultRoleFlag = (role = (CdesRole)this.cdesRoleDAO.get(roleId)).getContextDefaultRoleFlag()) != null && contextDefaultRoleFlag != 0)) {
            throw new SecurityException("Permission [" + Action.ROLES_GLOBAL_OVERVIEW + "] is needed to create a person with role [" + role.getName() + "]");
        }
        person.setRoleId(roleId);
        person.setTitle(QueryHelper.trimOptionalFieldValue(passedPerson.getTitle()));
        person.setGivenName(QueryHelper.trimMandatoryFieldValue(passedPerson.getGivenName(), "givenName"));
        person.setSurName(QueryHelper.trimMandatoryFieldValue(passedPerson.getSurName(), "surName"));
        person.setZtPermission(QueryHelper.checkMandatoryValue(passedPerson.getZtPermission(), "ztPermission"));
    }

    private PersonVariables constructNewPersonVariables(Long personId, PersonVariables passedPersonVariables) {
        PersonVariables personVariables = new PersonVariables();
        personVariables.setPersonId(personId);
        String passedLocale = passedPersonVariables.getUserLocale();
        if (passedLocale == null || passedLocale.trim().length() == 0) {
            passedLocale = "de";
        }
        personVariables.setUserLocale(passedLocale);
        personVariables.setDisplayedDaysOfDoneTasks(passedPersonVariables.getDisplayedDaysOfDoneTasks());
        personVariables.setDisplayedDaysUntilDue(passedPersonVariables.getDisplayedDaysUntilDue());
        personVariables.setPreselectedTab(passedPersonVariables.getPreselectedTab());
        personVariables.setScreenSize(passedPersonVariables.getScreenSize());
        personVariables.setTabViewMode(passedPersonVariables.getTabViewMode());
        return personVariables;
    }

    private OrganisationPerson constructNewOrganisationPerson(Long personId, OrganisationPerson passedOrganisationPerson) {
        OrganisationPerson organisationPerson = new OrganisationPerson();
        organisationPerson.setPersonId(personId);
        organisationPerson.setOrganisationId(passedOrganisationPerson.getOrganisationId());
        organisationPerson.setEmailSendMode(passedOrganisationPerson.getEmailSendMode());
        organisationPerson.setEmailSendTime(passedOrganisationPerson.getEmailSendTime());
        return organisationPerson;
    }

    private void checkAndCopyOrganisationPersonFieldsToSave(OrganisationPerson organisationPerson, OrganisationPerson passedOrganisationPerson) {
        organisationPerson.setOrganisationalUnitName(QueryHelper.trimOptionalFieldValue(passedOrganisationPerson.getOrganisationalUnitName()));
        organisationPerson.setPostalAddress(QueryHelper.trimMandatoryFieldValue(passedOrganisationPerson.getPostalAddress(), "postalAddress"));
        organisationPerson.setPostalCode(QueryHelper.trimMandatoryFieldValue(passedOrganisationPerson.getPostalCode(), "postalCode"));
        organisationPerson.setLocalityName(QueryHelper.trimMandatoryFieldValue(passedOrganisationPerson.getLocalityName(), "localityName"));
        organisationPerson.setCountryId(QueryHelper.checkMandatoryValue(passedOrganisationPerson.getCountryId(), "countryId"));
        organisationPerson.setRetiredFlag(QueryHelper.checkMandatoryValue(passedOrganisationPerson.getRetiredFlag(), "retiredFlag"));
        organisationPerson.setRetiredComment(QueryHelper.trimOptionalFieldValue(passedOrganisationPerson.getRetiredComment()));
        organisationPerson.setTelephoneNumber(QueryHelper.trimMandatoryFieldValue(passedOrganisationPerson.getTelephoneNumber(), "telephoneNumber"));
        organisationPerson.setMobileTelephoneNumber(QueryHelper.trimOptionalFieldValue(passedOrganisationPerson.getMobileTelephoneNumber()));
        organisationPerson.setFacsimileTelephoneNumber(QueryHelper.trimOptionalFieldValue(passedOrganisationPerson.getFacsimileTelephoneNumber()));
        organisationPerson.setEmailAddress(QueryHelper.trimMandatoryFieldValue(passedOrganisationPerson.getEmailAddress(), "emailAddress"));
    }

    private PersonEditInfo getUpdatedPersonEditInfo(Long organisationPersonId, Long personId, List<OrganisationPerson> organisationPersons, boolean fetchNewPersonEditInfo) {
        if (fetchNewPersonEditInfo) {
            PersonEditInfo personEditInfo = this.getPersonEditInfo(organisationPersonId, personId);
            List personEditOrganisationPersonJoins = personEditInfo.getOrganisationPersonJoins();
            HashMap<Long, OrganisationPersonJoin> personEditOPMap = new HashMap<Long, OrganisationPersonJoin>();
            for (OrganisationPersonJoin personEditOPJoin : personEditOrganisationPersonJoins) {
                personEditOPMap.put(personEditOPJoin.getOrganisationPersonId(), personEditOPJoin);
            }
            ArrayList<OrganisationPersonJoin> newPersonEditOrganisationPersonJoins = new ArrayList<OrganisationPersonJoin>();
            for (OrganisationPerson organisationPerson : organisationPersons) {
                Long opId = organisationPerson.getId();
                OrganisationPersonJoin newPersonEditOrganisationPersonJoin = (OrganisationPersonJoin)personEditOPMap.get(opId);
                newPersonEditOrganisationPersonJoins.add(newPersonEditOrganisationPersonJoin);
            }
            personEditInfo.setOrganisationPersonJoins(newPersonEditOrganisationPersonJoins);
            return personEditInfo;
        }
        return null;
    }

    public List<OrganisationPersonDeleteInfo> getPersonDeleteInfo(Long organisationPersonId, Long personId) {
        if (log.isDebugEnabled()) {
            log.debug("Called getUndeletableOrganisationPersonJoinsByPerson");
        }
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<OrganisationPersonJoin> organisationPersonJoins = this.organisationPersonDAO.getOrganisationPersonJoinByPerson(personId);
        HashMap<Long, OrganisationPersonJoin> idToOrganisationPersonJoin = new HashMap<Long, OrganisationPersonJoin>();
        final ArrayList<Long> organisationIds = new ArrayList<Long>();
        for (OrganisationPersonJoin organisationPersonJoin : organisationPersonJoins) {
            organisationIds.add(organisationPersonJoin.getOrganisationId());
            idToOrganisationPersonJoin.put(organisationPersonJoin.getOrganisationPersonId(), organisationPersonJoin);
        }
        Map organisationIdToNetworks = QueryHelper.executeDAOGetter(organisationIds, this.sqlQueryBatchSize / 2, new BatchedDAOGetterMap<List<Network>, Long>(){

            @Override
            public Map<Long, List<Network>> execute(List<Long> ids) {
                return PersonServiceImpl.this.networkDAO.getNetworksByOrganisations(organisationIds);
            }
        });
        List<Long> networkIds = ContainerHelper.getIdsFromMultiMapAsList(organisationIdToNetworks);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkToActionMap(organisationPersonId, networkIds, Action.DELETE_PERSON);
        HashSet<Long> organisationPersonIdsWithPrivilege = new HashSet<Long>();
        for (OrganisationPersonJoin organisationPersonJoin : organisationPersonJoins) {
            boolean actionFound = false;
            Long organisationId = organisationPersonJoin.getOrganisationId();
            List networks = organisationIdToNetworks.get(organisationId);
            if (networks != null) {
                for (Network network : networks) {
                    Set<Action> actions = networkIdToActions.get(network.getId());
                    if (log.isDebugEnabled()) {
                        log.debug("Organisation [" + organisationId + "], Network [" + network.getId() + "]: Found actions [" + actions + "]");
                    }
                    actionFound |= actions != null && actions.contains(Action.DELETE_PERSON);
                }
            }
            if (!actionFound) continue;
            organisationPersonIdsWithPrivilege.add(organisationPersonJoin.getOrganisationPersonId());
        }
        if (organisationPersonIdsWithPrivilege.isEmpty()) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to gain information about deletion of person [" + personId + "]; needs privilege [deletePerson] for at least one of its OrganisationPersons.");
        }
        OrganisationPersonJoin callingOrganisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String userLocale = callingOrganisationPersonJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(userLocale);
        HashMap<Long, OrganisationPersonDeleteInfo> organisationPersonIdToDeleteInfo = new HashMap<Long, OrganisationPersonDeleteInfo>();
        ArrayList<Long> organisationPersonIds = new ArrayList<Long>();
        for (OrganisationPersonJoin organisationPersonJoin : organisationPersonJoins) {
            Long currOrganisationPersonId = organisationPersonJoin.getOrganisationPersonId();
            if (!organisationPersonIdsWithPrivilege.contains(currOrganisationPersonId)) {
                if (log.isDebugEnabled()) {
                    log.debug("[NO-PERMISSION] OrganisationPerson [" + organisationPersonId + "] has no permission [deletePerson] to delete OrganisationPerson [" + currOrganisationPersonId + "]");
                }
                OrganisationPersonDeleteInfo deleteInfo = new OrganisationPersonDeleteInfo(organisationPersonJoin);
                deleteInfo.setDeletePermission(false);
                organisationPersonIdToDeleteInfo.put(currOrganisationPersonId, deleteInfo);
                continue;
            }
            organisationPersonIds.add(organisationPersonJoin.getOrganisationPersonId());
        }
        List<ForeignKeyInstance> instancesReferringToOrganisationPersons = this.organisationPersonDAO.getReferringInstances(organisationPersonIds);
        if (log.isDebugEnabled()) {
            log.debug("getPersonDeleteInfo called by [" + organisationPersonId + "] finds [" + instancesReferringToOrganisationPersons.size() + "] referring instances for organisationPersonIds [" + organisationPersonIds + "] of person [" + personId + "]");
        }
        Map<Long, Map<String, List<ForeignKeyInstance>>> ownIdToEntityToInstances = ForeignKeyHelper.groupForeignKeyInstances(instancesReferringToOrganisationPersons);
        List<ProjectParticipationJoin> allParticipationJoins = this.projectParticipationDAO.getParticipationJoinsByPerson(personId, true);
        List<Long> participationIds = JdbcProjectParticipationDAO.getParticipationIdsFromJoins(allParticipationJoins);
        List<ForeignKeyInstance> instancesReferringToParticipations = this.projectParticipationDAO.getReferringInstances(participationIds);
        if (log.isDebugEnabled()) {
            log.debug("getPersonDeleteInfo called by [" + organisationPersonId + "] finds [" + instancesReferringToParticipations.size() + "] referring instances for mainParticipationIds [" + participationIds + "] of person [" + personId + "]");
        }
        for (Long l : organisationPersonIds) {
            if (log.isDebugEnabled()) {
                log.debug("Checking organisationPerson [" + l + "]...");
            }
            OrganisationPersonJoin organisationPersonJoin = (OrganisationPersonJoin)idToOrganisationPersonJoin.get(l);
            OrganisationPersonDeleteInfo deleteInfo = new OrganisationPersonDeleteInfo(organisationPersonJoin);
            organisationPersonIdToDeleteInfo.put(l, deleteInfo);
            deleteInfo.setDeletePermission(true);
            boolean inUse = false;
            Map<String, List<ForeignKeyInstance>> entityToInstances = ownIdToEntityToInstances.get(l);
            if (entityToInstances != null) {
                for (String entityWithAttribute : entityToInstances.keySet()) {
                    List<ForeignKeyInstance> instances = entityToInstances.get(entityWithAttribute);
                    if ("Certificate.organisationPersonId".equals(entityWithAttribute) || "CertificateRequest.createdFor".equals(entityWithAttribute) || "Email.organisationPersonId".equals(entityWithAttribute)) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("[  DELETABLE] found [" + instances.size() + "] instances of [" + entityWithAttribute + "]");
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("[UNDELETABLE] found [" + instances.size() + "] instances of [" + entityWithAttribute + "]");
                    }
                    inUse = true;
                }
            }
            deleteInfo.setInUse(inUse);
        }
        List<ParticipationInvalidatableJoin> invalidatableJoins = this.projectParticipationDAO.getInvalidatableJoin(personId);
        for (ParticipationInvalidatableJoin invalidatableJoin : invalidatableJoins) {
            List<String> hint;
            ParticipationInvalidatableComponent component = ParticipationInvalidatableComponent.getByValue(invalidatableJoin.getUnionClause());
            Long opId = invalidatableJoin.getOrganisationPersonId();
            OrganisationPersonDeleteInfo deleteInfo = (OrganisationPersonDeleteInfo)organisationPersonIdToDeleteInfo.get(opId);
            OrganisationPersonJoin organisationPersonJoin = (OrganisationPersonJoin)idToOrganisationPersonJoin.get(opId);
            if (log.isDebugEnabled()) {
                log.debug("Processing invalidatableJoin: opId [" + opId + "], person [" + organisationPersonJoin.getPersonGivenName() + " " + organisationPersonJoin.getPersonSurName() + "], component [" + (Object)((Object)component) + "]");
            }
            if (component == ParticipationInvalidatableComponent.OBJECT_PLANNER) {
                hint = this.getParticipationUsesObjectPlannerMessage(resourceBundle, invalidatableJoin, false, userLocale);
                deleteInfo.addMainParticipationInUseHint(hint);
                continue;
            }
            if (component == ParticipationInvalidatableComponent.OBJECT_PLANNER_POSITION) {
                hint = this.getParticipationUsesObjectPlannerPositionMessage(resourceBundle, invalidatableJoin, false, userLocale);
                deleteInfo.addMainParticipationInUseHint(hint);
                continue;
            }
            if (component == ParticipationInvalidatableComponent.OBJECT_PLANNER_RELEASE) {
                hint = this.getParticipationUsesObjectPlannerMessage(resourceBundle, invalidatableJoin, true, userLocale);
                deleteInfo.addMainParticipationInUseHint(hint);
                continue;
            }
            if (component == ParticipationInvalidatableComponent.OBJECT_PLANNER_POSITION_RELEASE) {
                hint = this.getParticipationUsesObjectPlannerPositionMessage(resourceBundle, invalidatableJoin, true, userLocale);
                deleteInfo.addMainParticipationInUseHint(hint);
                continue;
            }
            if (component == ParticipationInvalidatableComponent.REVIEW_CYCLE_NODE_POSITION) {
                hint = this.getParticipationUsesReviewCycleNodeInstanceMessage(resourceBundle, invalidatableJoin, userLocale);
                deleteInfo.addMainParticipationInUseHint(hint);
                continue;
            }
            if (component == ParticipationInvalidatableComponent.REVIEW_CYCLE_NODE_INSTANCE_NOTIFICATION) {
                hint = this.getParticipationUsesReviewCycleNodeInstanceNotificationMessage(resourceBundle, invalidatableJoin, userLocale);
                deleteInfo.addMainParticipationInUseHint(hint);
                continue;
            }
            if (component == ParticipationInvalidatableComponent.PLOT_ORDER_TEMPLATE) {
                hint = this.getParticipationUsesPlotOrderTemplateMessage(resourceBundle, invalidatableJoin, userLocale);
                deleteInfo.addMainParticipationInUseHint(hint);
                continue;
            }
            if (component == ParticipationInvalidatableComponent.PLOT_ORDER_ITEM_TEMPLATE) {
                hint = this.getParticipationUsesPlotOrderItemTemplateMessage(resourceBundle, invalidatableJoin, userLocale);
                deleteInfo.addMainParticipationInUseHint(hint);
                continue;
            }
            if (component == ParticipationInvalidatableComponent.PLOT_ORDER_ITEM) {
                hint = this.getParticipationUsesPlotOrderItemMessage(resourceBundle, invalidatableJoin, userLocale);
                deleteInfo.addMainParticipationInUseHint(hint);
                continue;
            }
            if (component == ParticipationInvalidatableComponent.REVIEW_CYCLE_NODE_POSITION_RELEASED) {
                hint = this.getParticipationUsesReviewCycleNodeInstanceReleasedMessage(resourceBundle, invalidatableJoin, userLocale);
                deleteInfo.addMainParticipationInUseHint(hint);
                continue;
            }
            if (component != ParticipationInvalidatableComponent.WORKFLOW_NODE_POSITION) continue;
            hint = this.getParticipationUsesWorkflowNodePositionMessage(resourceBundle, invalidatableJoin, userLocale);
            deleteInfo.addMainParticipationInUseHint(hint);
        }
        ArrayList<OrganisationPersonDeleteInfo> arrayList = new ArrayList<OrganisationPersonDeleteInfo>();
        arrayList.addAll(organisationPersonIdToDeleteInfo.values());
        return arrayList;
    }

    private static String getNonNullInfoString(String s) {
        return s != null && s.trim().length() > 0 ? s.trim() : "---";
    }

    private static void addContextTokensNetworkToProject(List<String> tokens, ResourceBundle resourceBundle, ParticipationInvalidatableJoin contextJoin) {
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("network"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(contextJoin.getNetworkName()));
        tokens.add("</tr>");
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("project"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(contextJoin.getProjectCode()) + " " + PersonServiceImpl.getNonNullInfoString(contextJoin.getProjectName()));
        tokens.add("</tr>");
    }

    private static void addContextTokensNetworkToSubProject(List<String> tokens, ResourceBundle resourceBundle, ParticipationInvalidatableJoin contextJoin) {
        PersonServiceImpl.addContextTokensNetworkToProject(tokens, resourceBundle, contextJoin);
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("subProject"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(contextJoin.getSubProjectCode()) + " " + PersonServiceImpl.getNonNullInfoString(contextJoin.getSubProjectName()));
        tokens.add("</tr>");
    }

    private static void addContextTokensNetworkToObjectPlanner(List<String> tokens, ResourceBundle resourceBundle, ParticipationInvalidatableJoin contextJoin, boolean released) {
        PersonServiceImpl.addContextTokensNetworkToSubProject(tokens, resourceBundle, contextJoin);
        if (released) {
            tokens.add("<tr>");
            tokens.add(resourceBundle.getString("objectListReleaseItem"));
            tokens.add(contextJoin.getObjectListReleaseVersion() != null ? contextJoin.getObjectListReleaseVersion().toString() : "---");
            tokens.add("</tr>");
        }
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("object"));
        if (released) {
            tokens.add(PersonServiceImpl.getNonNullInfoString(contextJoin.getObjectReleaseCode()) + " " + PersonServiceImpl.getNonNullInfoString(contextJoin.getObjectReleaseName()));
        } else {
            tokens.add(PersonServiceImpl.getNonNullInfoString(contextJoin.getObjectCode()) + " " + PersonServiceImpl.getNonNullInfoString(contextJoin.getObjectName()));
        }
        tokens.add("</tr>");
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("objectPlanner"));
        if (released) {
            tokens.add(PersonServiceImpl.getNonNullInfoString(contextJoin.getObjectPlannerReleaseCode()) + " " + PersonServiceImpl.getNonNullInfoString(contextJoin.getObjectPlannerReleaseArea()));
        } else {
            tokens.add(PersonServiceImpl.getNonNullInfoString(contextJoin.getObjectPlannerCode()) + " " + PersonServiceImpl.getNonNullInfoString(contextJoin.getObjectPlannerArea()));
        }
        tokens.add("</tr>");
    }

    private List<String> getParticipationUsesObjectPlannerMessage(ResourceBundle resourceBundle, ParticipationInvalidatableJoin join, boolean released, String userLocale) {
        ArrayList<String> tokens = new ArrayList<String>();
        String prefixI18nKey = released ? "projectParticipationInUseObjectPlannerReleasePrefix" : "projectParticipationInUseObjectPlannerPrefix";
        String postfixI18nKey = released ? "projectParticipationInUseObjectPlannerReleasePostfix" : "projectParticipationInUseObjectPlannerPostfix";
        String prefix = MessageFormat.format(resourceBundle.getString(prefixI18nKey), PersonServiceImpl.getNonNullInfoString(join.getOrganisationName()));
        tokens.add(prefix);
        tokens.add("<table>");
        PersonServiceImpl.addContextTokensNetworkToObjectPlanner(tokens, resourceBundle, join, released);
        tokens.add("</table>");
        tokens.add(resourceBundle.getString(postfixI18nKey));
        return tokens;
    }

    private List<String> getParticipationUsesObjectPlannerPositionMessage(ResourceBundle resourceBundle, ParticipationInvalidatableJoin join, boolean released, String userLocale) {
        ArrayList<String> tokens = new ArrayList<String>();
        String prefixI18nKey = released ? "projectParticipationInUseObjectPlannerPositionReleasePrefix" : "projectParticipationInUseObjectPlannerPositionPrefix";
        String postfixI18nKey = released ? "projectParticipationInUseObjectPlannerPositionReleasePostfix" : "projectParticipationInUseObjectPlannerPositionPostfix";
        String prefix = MessageFormat.format(resourceBundle.getString(prefixI18nKey), PersonServiceImpl.getNonNullInfoString(join.getOrganisationName()));
        tokens.add(prefix);
        tokens.add("<table>");
        PersonServiceImpl.addContextTokensNetworkToObjectPlanner(tokens, resourceBundle, join, released);
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("objectPlannerPosition"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(join.getObjectPlannerPositionDefinitionName()));
        tokens.add("</tr>");
        tokens.add("</table>");
        String postfix = MessageFormat.format(resourceBundle.getString(postfixI18nKey), PersonServiceImpl.getNonNullInfoString(join.getCdesRoleName()));
        tokens.add(postfix);
        return tokens;
    }

    private List<String> getParticipationUsesReviewCycleNodeInstanceMessage(ResourceBundle resourceBundle, ParticipationInvalidatableJoin join, String userLocale) {
        ArrayList<String> tokens = new ArrayList<String>();
        String prefixI18nKey = "projectParticipationInUseReviewCycleNodePositionPrefix";
        String postfixI18nKey = "projectParticipationInUseReviewCycleNodePositionPostfix";
        String prefix = MessageFormat.format(resourceBundle.getString(prefixI18nKey), PersonServiceImpl.getNonNullInfoString(join.getOrganisationName()));
        tokens.add(prefix);
        tokens.add("<table>");
        PersonServiceImpl.addContextTokensNetworkToSubProject(tokens, resourceBundle, join);
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("reviewCycleInstanceItem"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(I18nHelper.getLocaleStringFromDatabase(join.getReviewCycleInstanceName(), userLocale)));
        tokens.add("</tr>");
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("reviewCycleCellItem"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(join.getReviewCycleCellCode() + " " + I18nHelper.getLocaleStringFromDatabase(join.getReviewCycleCellName(), userLocale)));
        tokens.add("</tr>");
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("realmItem"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(join.getRealmCode() + " " + I18nHelper.getLocaleStringFromDatabase(join.getRealmName(), userLocale)));
        tokens.add("</tr>");
        tokens.add("</table>");
        String postfix = resourceBundle.getString(postfixI18nKey);
        tokens.add(postfix);
        return tokens;
    }

    private List<String> getParticipationUsesReviewCycleNodeInstanceNotificationMessage(ResourceBundle resourceBundle, ParticipationInvalidatableJoin join, String userLocale) {
        ArrayList<String> tokens = new ArrayList<String>();
        String prefixI18nKey = "projectParticipationInUseReviewCycleNodePositionPrefix";
        String prefix = MessageFormat.format(resourceBundle.getString(prefixI18nKey), PersonServiceImpl.getNonNullInfoString(join.getOrganisationName()));
        tokens.add(prefix);
        tokens.add("<table>");
        PersonServiceImpl.addContextTokensNetworkToSubProject(tokens, resourceBundle, join);
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("reviewCycleInstanceItem"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(I18nHelper.getLocaleStringFromDatabase(join.getReviewCycleInstanceName(), userLocale)));
        tokens.add("</tr>");
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("reviewCycleCellItem"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(join.getReviewCycleCellCode() + " " + I18nHelper.getLocaleStringFromDatabase(join.getReviewCycleCellName(), userLocale)));
        tokens.add("</tr>");
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("reviewCycleNodeItem"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(I18nHelper.getLocaleStringFromDatabase(join.getReviewCycleNodeName(), userLocale)));
        tokens.add("</tr>");
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("reviewCycleNodeListener"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(I18nHelper.getLocaleStringFromDatabase(join.getReviewCycleNodeListenerName(), userLocale)));
        tokens.add("</tr>");
        tokens.add("</table>");
        boolean isPreListener = join.getReviewCycleNodeListenerIsPreListener() != null ? join.getReviewCycleNodeListenerIsPreListener() : false;
        String postfix = MessageFormat.format(resourceBundle.getString("projectParticipationInUseReviewCycleNodeInstanceNotificationPostfix"), isPreListener ? resourceBundle.getString("reviewCycleNodeListenerPre") : resourceBundle.getString("reviewCycleNodeListenerPost"));
        tokens.add(postfix);
        return tokens;
    }

    private List<String> getParticipationUsesPlotOrderTemplateMessage(ResourceBundle resourceBundle, ParticipationInvalidatableJoin join, String userLocale) {
        ArrayList<String> tokens = new ArrayList<String>();
        String prefixI18nKey = "projectParticipationInUsePlotOrderTemplatePrefix";
        String postfixI18nKey = "projectParticipationInUsePlotOrderTemplatePostfix";
        String prefix = MessageFormat.format(resourceBundle.getString(prefixI18nKey), PersonServiceImpl.getNonNullInfoString(join.getOrganisationName()));
        tokens.add(prefix);
        tokens.add("<table>");
        PersonServiceImpl.addContextTokensNetworkToProject(tokens, resourceBundle, join);
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("plotOrderTemplate"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(join.getPlottOrderTemplateName()));
        tokens.add("</tr>");
        tokens.add("</table>");
        tokens.add(resourceBundle.getString(postfixI18nKey));
        return tokens;
    }

    private List<String> getParticipationUsesPlotOrderItemTemplateMessage(ResourceBundle resourceBundle, ParticipationInvalidatableJoin join, String userLocale) {
        ArrayList<String> tokens = new ArrayList<String>();
        String prefixI18nKey = "projectParticipationInUsePlotOrderItemTemplatePrefix";
        String postfixI18nKey = "projectParticipationInUsePlotOrderItemTemplatePostfix";
        String prefix = MessageFormat.format(resourceBundle.getString(prefixI18nKey), PersonServiceImpl.getNonNullInfoString(join.getOrganisationName()));
        tokens.add(prefix);
        tokens.add("<table>");
        PersonServiceImpl.addContextTokensNetworkToProject(tokens, resourceBundle, join);
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("plotOrderTemplate"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(join.getPlottOrderTemplateName()));
        tokens.add("</tr>");
        tokens.add("</table>");
        tokens.add(resourceBundle.getString(postfixI18nKey));
        return tokens;
    }

    private List<String> getParticipationUsesPlotOrderItemMessage(ResourceBundle resourceBundle, ParticipationInvalidatableJoin join, String userLocale) {
        ArrayList<String> tokens = new ArrayList<String>();
        String prefixI18nKey = "projectParticipationInUsePlotOrderItemPrefix";
        String postfixI18nKey = "projectParticipationInUsePlotOrderItemPostfix";
        String prefix = MessageFormat.format(resourceBundle.getString(prefixI18nKey), PersonServiceImpl.getNonNullInfoString(join.getOrganisationName()));
        tokens.add(prefix);
        tokens.add("<table>");
        PersonServiceImpl.addContextTokensNetworkToProject(tokens, resourceBundle, join);
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("plotOrderTemplate"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(join.getPlottOrderTemplateName()));
        tokens.add("</tr>");
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("plotOrderJobNumber"));
        tokens.add(join.getPlottOrderJobNumber() != null ? join.getPlottOrderJobNumber().toString() : "---");
        tokens.add("</tr>");
        tokens.add("</table>");
        tokens.add(resourceBundle.getString(postfixI18nKey));
        return tokens;
    }

    public void deletePerson(Long organisationPersonId, Long personId) {
        List<PersonVariables> personVariables;
        List<Long> personVariablesIds;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        this.checkDeleteInvalidatePersonPrivileges(organisationPersonId, personId);
        List<OrganisationPerson> organisationPersons = this.organisationPersonDAO.getByPerson(personId);
        for (OrganisationPerson organisationPerson : organisationPersons) {
            this.deleteOrganisationPerson(organisationPerson.getId());
        }
        List<Search> searches = this.searchDAO.getByPerson(personId);
        List<Long> searchIds = ContainerHelper.getPersistentIdsList(searches);
        if (searchIds.size() > 0) {
            this.searchDAO.deleteBatch(searchIds);
        }
        if ((personVariablesIds = ContainerHelper.getPersistentIdsList(personVariables = this.personVariablesDAO.getByPerson(personId))).size() > 0) {
            this.personVariablesDAO.deleteBatch(personVariablesIds);
        }
        this.personDAO.delete(personId);
    }

    public void undeletePerson(Long organisationPersonId, Long personId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        this.checkDeleteInvalidatePersonPrivileges(organisationPersonId, personId);
        Person person = (Person)this.personDAO.get(personId);
        person.setStatus(Integer.valueOf(PersonStatus.ACTIVE.getValue()));
        this.personDAO.update(person);
    }

    private List<String> getParticipationUsesReviewCycleNodeInstanceReleasedMessage(ResourceBundle resourceBundle, ParticipationInvalidatableJoin join, String userLocale) {
        ArrayList<String> tokens = new ArrayList<String>();
        String prefixI18nKey = "projectParticipationInUseReviewCycleNodePositionReleasedPrefix";
        String postfixI18nKey = "projectParticipationInUseReviewCycleNodePositionReleasedPostfix";
        String prefix = MessageFormat.format(resourceBundle.getString(prefixI18nKey), PersonServiceImpl.getNonNullInfoString(join.getOrganisationName()));
        tokens.add(prefix);
        tokens.add("<table>");
        PersonServiceImpl.addContextTokensNetworkToSubProject(tokens, resourceBundle, join);
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("reviewCycleInstanceReleasedItem"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(join.getReviewCycleInstanceReleasedName()));
        tokens.add("</tr>");
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("objectListReleaseItem"));
        tokens.add(join.getObjectListReleaseVersion() != null ? join.getObjectListReleaseVersion().toString() : "---");
        tokens.add("</tr>");
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("reviewCycleCellItem"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(join.getReviewCycleCellCode() + " " + I18nHelper.getLocaleStringFromDatabase(join.getReviewCycleCellName(), userLocale)));
        tokens.add("</tr>");
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("realmItem"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(join.getRealmCode() + " " + I18nHelper.getLocaleStringFromDatabase(join.getRealmName(), userLocale)));
        tokens.add("</tr>");
        tokens.add("</table>");
        String postfix = resourceBundle.getString(postfixI18nKey);
        tokens.add(postfix);
        return tokens;
    }

    private List<String> getParticipationUsesWorkflowNodePositionMessage(ResourceBundle resourceBundle, ParticipationInvalidatableJoin join, String userLocale) {
        ArrayList<String> tokens = new ArrayList<String>();
        String prefixI18nKey = "projectParticipationInUseWorkflowNodePositionPrefix";
        String postfixI18nKey = "projectParticipationInUseWorkflowNodePositionPostfix";
        String prefix = MessageFormat.format(resourceBundle.getString(prefixI18nKey), PersonServiceImpl.getNonNullInfoString(join.getOrganisationName()));
        tokens.add(prefix);
        tokens.add("<table>");
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("network"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(join.getNetworkName()));
        tokens.add("</tr>");
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("planningNotification"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(join.getPlanningNotificationTitle()));
        tokens.add("</tr>");
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("planningNotificationOrder"));
        tokens.add(join.getPlanningNotificationOrderSerialNumber() != null ? join.getPlanningNotificationOrderSerialNumber().toString() : "---");
        tokens.add("</tr>");
        tokens.add("<tr>");
        tokens.add(resourceBundle.getString("workflowNodeTemplate"));
        tokens.add(PersonServiceImpl.getNonNullInfoString(join.getWorkflowNodeTemplateName()));
        tokens.add("</tr>");
        String postfix = resourceBundle.getString(postfixI18nKey);
        tokens.add(postfix);
        return tokens;
    }

    public void invalidatePerson(Long organisationPersonId, Long personId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<OrganisationPersonDeleteInfo> deleteInfos = this.getPersonDeleteInfo(organisationPersonId, personId);
        for (OrganisationPersonDeleteInfo deleteInfo : deleteInfos) {
            OrganisationPersonJoin organisationPersonJoin = deleteInfo.getOrganisationPersonJoin();
            Long l = organisationPersonJoin.getOrganisationPersonId();
            if (!deleteInfo.isDeletePermission()) {
                throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to delete/invalidate person [" + personId + "]; for its OrganisationPerson [" + l + "], privilege [deletePerson] is missing.");
            }
            if (!deleteInfo.isMainParticipationInUse()) continue;
            throw new IllegalArgumentException("OrganisationPerson [" + organisationPersonId + "] cannot invalidate the mainParticipation of organisationPerson [" + l + "] since it is in non-invalidatable use.  ");
        }
        List<ProjectParticipationJoin> participationJoins = this.projectParticipationDAO.getParticipationJoinsByPerson(personId, false);
        ArrayList<Long> participationIds = new ArrayList<Long>();
        for (ProjectParticipationJoin projectParticipationJoin : participationJoins) {
            participationIds.add(projectParticipationJoin.getProjectParticipationId());
        }
        List<OrganisationPerson> organisationPersons = this.organisationPersonDAO.getByPerson(personId);
        for (OrganisationPerson organisationPerson : organisationPersons) {
            organisationPerson.setOrganisationalUnitName(null);
            organisationPerson.setPostalCode("");
            organisationPerson.setPostalAddress("");
            organisationPerson.setLocalityName("");
            organisationPerson.setStateOrProvinceName(null);
            organisationPerson.setTelephoneNumber("");
            organisationPerson.setMobileTelephoneNumber(null);
            organisationPerson.setFacsimileTelephoneNumber(null);
            organisationPerson.setEmailAddress("");
        }
        this.organisationPersonDAO.updateBatch(organisationPersons);
        List<ProjectParticipant> list = QueryHelper.executeDAOGetter(participationIds, this.sqlQueryBatchSize / 2, new BatchedDAOGetter<ProjectParticipant, Long>(){

            @Override
            public List<ProjectParticipant> execute(List<Long> ids) {
                return PersonServiceImpl.this.projectParticipantDAO.getByParticipations(ids);
            }
        });
        Map<Long, List<ProjectParticipant>> participationIdToParticipants = GroupHelper.groupParticipantsByParticipation(list);
        for (ProjectParticipationJoin projectParticipationJoin : participationJoins) {
            Long participationId = projectParticipationJoin.getProjectParticipationId();
            ProjectParticipant participant = projectParticipationJoin.getProjectParticipant();
            boolean mainParticipantFlag = participant.getMainParticipantFlag() != null ? participant.getMainParticipantFlag() : false;
            List<ProjectParticipant> participantsForParticipation = participationIdToParticipants.get(participationId);
            if (mainParticipantFlag) {
                if (participantsForParticipation.size() <= 1) {
                    this.projectUtils.setParticipationInvalid(participationId);
                    continue;
                }
                Long cdesRoleId = projectParticipationJoin.getProjectParticipationRoleId();
                ProjectParticipant newMainParticipant = null;
                for (ProjectParticipant candidateParticipant : participantsForParticipation) {
                    Long candidateParticipantId = candidateParticipant.getId();
                    if (candidateParticipantId.longValue() == participant.getId().longValue()) continue;
                    newMainParticipant = candidateParticipant;
                }
                this.projectUtils.removeAndReplaceMainParticipant(organisationPersonId, cdesRoleId, participantsForParticipation, newMainParticipant);
                continue;
            }
            this.projectUtils.removeParticipant(organisationPersonId, participant);
        }
        List<Certificate> certificates = this.certificateDAO.getCertificatesByPerson(personId);
        for (Certificate certificate : certificates) {
            this.certificateUtils.invalidateCertificate(certificate);
        }
        Person person = (Person)this.personDAO.get(personId);
        person.setStatus(Integer.valueOf(PersonStatus.INVALID.getValue()));
        person.setTitle(null);
        person.setLogin(null);
        person.setPassword(null);
        person.setGender("");
        person.setQuestion(null);
        person.setAnswerPassword(null);
        person.setLastPasswordChangeTs(null);
        this.personDAO.update(person);
    }

    private void checkDeleteInvalidatePersonPrivileges(Long organisationPersonId, Long personId) {
        Map<Long, List<Network>> organisationPersonIdToNetworks = this.networkDAO.getOPGroupedNetworksByPerson(personId);
        List<Network> allNetworks = ContainerHelper.getAllValues(organisationPersonIdToNetworks);
        List<Long> networkIds = ContainerHelper.getPersistentIdsList(allNetworks);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkToActionMap(organisationPersonId, networkIds, Action.DELETE_PERSON);
        for (Long opId : organisationPersonIdToNetworks.keySet()) {
            boolean deletePersonFound = false;
            List<Network> networks = organisationPersonIdToNetworks.get(opId);
            if (networks != null) {
                for (Network network : networks) {
                    Set<Action> actions = networkIdToActions.get(network.getId());
                    deletePersonFound |= actions != null && actions.contains(Action.DELETE_PERSON);
                }
            }
            if (deletePersonFound) continue;
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to delete/invalidate person [" + personId + "]; for its OrganisationPerson [" + opId + "], privilege [deletePerson] is missing.");
        }
    }

    private void checkForGlobalNetworkActions(Long organisationPersonId) {
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.NETWORK_SECTION_OVERVIEW, Action.SUPER_ADMIN_RIGHT);
        if (!globalActions.contains(Action.NETWORK_SECTION_OVERVIEW) && !globalActions.contains(Action.SUPER_ADMIN_RIGHT)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] has neither global permission [networkSectionOverview] nor global permission [superAdminRight].");
        }
    }

    public List<OrganisationPersonJoin> getOrganisationPersonJoins(Long askingOrganisationPersonId, List<Long> organisationPersonIds) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, askingOrganisationPersonId);
        Map<Long, List<Network>> organisationPersonIdToNetworks = this.networkDAO.getOPGroupedNetworksByOrganisationPersons(organisationPersonIds);
        List<Network> allNetworks = ContainerHelper.getAllValues(organisationPersonIdToNetworks);
        List<Long> networkIds = ContainerHelper.getPersistentIdsList(allNetworks);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkToActionMap(askingOrganisationPersonId, networkIds, Action.SHOW_PERSON, Action.EDIT_PERSON);
        for (Long organisationPersonId : organisationPersonIds) {
            if (organisationPersonId.longValue() == askingOrganisationPersonId.longValue() || ActionHelper.hasActionsForAnyNetwork(networkIdToActions, Action.SHOW_PERSON) || ActionHelper.hasActionsForAnyNetwork(networkIdToActions, Action.EDIT_PERSON)) continue;
            throw new SecurityException("OrganisationPerson [" + askingOrganisationPersonId + "] is not allowed to load OrganisationPersonJoin about organisationPerson [" + organisationPersonId + "]; required action is either [showPerson] or [editPerson] for at least one of its networks.");
        }
        Long[] organisationPersonIdArray = new Long[organisationPersonIds.size()];
        for (int n = 0; n < organisationPersonIds.size(); ++n) {
            organisationPersonIdArray[n] = organisationPersonIds.get(n);
        }
        List<OrganisationPersonJoin> organisationPersonJoins = this.organisationPersonDAO.getOrganisationPersonJoin(organisationPersonIdArray);
        for (OrganisationPersonJoin organisationPersonJoin : organisationPersonJoins) {
            PersonHelper.removeSecurityPersonData(organisationPersonJoin);
        }
        return organisationPersonJoins;
    }

    public String triggerExportPersonList(PersonSearchModel searchModel, Boolean showDetails, Map<String, Double> columnToWidth, List<Pair<String, Boolean>> sortColumns) {
        Long organisationPersonId = searchModel.getOrganisationPersonId();
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List columnSortSpecs = ColumnSortSpec.getFromClient(sortColumns);
        PersonListPdfCallable job = new PersonListPdfCallable(this.personListExporter, this, searchModel, showDetails, columnToWidth, columnSortSpecs, this.enableCustomerLogo);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)job));
        return uuid.toString();
    }

    public String getPersonAdditonalInfo(Long personId) {
        Person person = (Person)this.personDAO.get(personId);
        return person.getLogin().length() > 0 ? person.getLogin() : "n/a";
    }

    public MainUiInfo getMainUiInfo(String tabSessionId) {
        OrganisationPersonJoin firstJoin;
        MainUiInfo mainUiInfo = new MainUiInfo();
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        String principal = loginPrincipal.getName();
        mainUiInfo.setPrincipal(principal);
        Long personId = this.tabSessionService.getTabSessionPersonId(tabSessionId);
        List<OrganisationPersonJoin> organisationPersonJoins = this.organisationPersonDAO.getActiveOrganisationPersonJoinByPerson(personId);
        List allProjects = this.projectDAO.getAll();
        List<Long> projectIds = ContainerHelper.getPersistentIdsList(allProjects);
        boolean isSuperAdmin = false;
        boolean mayShowAdminMenu = false;
        boolean mayShowReviewSection = false;
        boolean mayShowBuek = false;
        boolean mayShowNetworkSection = false;
        boolean hasEditProject = false;
        boolean hasEditPerson = false;
        boolean hasShowPerson = false;
        boolean hasShowOrganisation = false;
        boolean hasShowConsortium = false;
        boolean hasGenerateReviewReport = false;
        for (OrganisationPersonJoin organisationPersonJoin : organisationPersonJoins) {
            Long organisationPersonId = organisationPersonJoin.getOrganisationPersonId();
            Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.SUPER_ADMIN_RIGHT, Action.MANAGE_ROOT_CAS, Action.EDIT_REVIEW_CYCLE, Action.REVIEW_SECTION_OVERVIEW, Action.NETWORK_SECTION_OVERVIEW, Action.PLANNING_NOTIFICATION_SECTION_OVERVIEW);
            isSuperAdmin |= globalActions.contains(Action.SUPER_ADMIN_RIGHT);
            mayShowAdminMenu |= globalActions.contains(Action.SUPER_ADMIN_RIGHT) || globalActions.contains(Action.MANAGE_ROOT_CAS) || globalActions.contains(Action.EDIT_REVIEW_CYCLE);
            mayShowReviewSection |= globalActions.contains(Action.REVIEW_SECTION_OVERVIEW);
            mayShowBuek |= globalActions.contains(Action.PLANNING_NOTIFICATION_SECTION_OVERVIEW);
            mayShowNetworkSection |= globalActions.contains(Action.NETWORK_SECTION_OVERVIEW);
            Map<Long, Set<Action>> projectIdToActions = this.actionDAO.getActionsForProjects(organisationPersonId, projectIds, Action.PLANNING_NOTIFICATION_OVERVIEW, Action.GENERATE_PLANNING_NOTIFICATION_REPORT, Action.EDIT_PROJECT);
            for (Long l : projectIdToActions.keySet()) {
                mayShowBuek |= projectIdToActions.get(l).contains(Action.PLANNING_NOTIFICATION_OVERVIEW);
                hasEditProject |= projectIdToActions.get(l).contains(Action.EDIT_PROJECT);
                hasGenerateReviewReport |= projectIdToActions.get(l).contains(Action.GENERATE_PLANNING_NOTIFICATION_REPORT);
            }
            Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkActions(organisationPersonId, Action.EDIT_PERSON, Action.SHOW_PERSON, Action.SHOW_ORGANISATION, Action.SHOW_CONSORTIUM);
            for (Long networkId : networkIdToActions.keySet()) {
                hasEditPerson |= networkIdToActions.get(networkId).contains(Action.EDIT_PERSON);
                hasShowPerson |= networkIdToActions.get(networkId).contains(Action.SHOW_PERSON);
                hasShowOrganisation |= networkIdToActions.get(networkId).contains(Action.SHOW_ORGANISATION);
                hasShowConsortium |= networkIdToActions.get(networkId).contains(Action.SHOW_CONSORTIUM);
            }
        }
        mainUiInfo.setIsSuperAdmin(Boolean.valueOf(isSuperAdmin));
        mainUiInfo.setHasEditPerson(Boolean.valueOf(hasEditPerson));
        mainUiInfo.setHasShowPerson(Boolean.valueOf(hasShowPerson));
        mainUiInfo.setHasShowOrganisation(Boolean.valueOf(hasShowOrganisation));
        mainUiInfo.setHasShowConsortium(Boolean.valueOf(hasShowConsortium));
        mainUiInfo.setHasEditProject(Boolean.valueOf(hasEditProject));
        mainUiInfo.setHasGenerateReviewReport(Boolean.valueOf(hasGenerateReviewReport));
        mainUiInfo.setMayShowAdminMenu(Boolean.valueOf(mayShowAdminMenu));
        mainUiInfo.setMayShowReviewSection(Boolean.valueOf(mayShowReviewSection));
        mainUiInfo.setMayShowBuek(Boolean.valueOf(mayShowBuek));
        mainUiInfo.setMayShowNetworkSection(Boolean.valueOf(mayShowNetworkSection));
        OrganisationPersonJoin organisationPersonJoin = firstJoin = organisationPersonJoins.size() > 0 ? organisationPersonJoins.get(0) : null;
        if (firstJoin == null) {
            throw new RuntimeException("Found no OrganisationPersonJoin for tabSessionId [" + tabSessionId + "] and resulting personId [" + personId + "]");
        }
        ZonedDateTime midnightZonedDateTime = ZonedDateTime.now(ZoneId.of("Europe/Vienna"));
        Instant midnight = midnightZonedDateTime.toInstant().truncatedTo(ChronoUnit.DAYS);
        Double prevMidnightUtcSeconds = new Double(midnight.toEpochMilli()) / 1000.0 - 10800.0;
        Double afterMidnightUtcSeconds = new Double(midnight.toEpochMilli()) / 1000.0 + 10800.0;
        List<InfoMessage> infoMessages = this.infoMessageDAO.getActiveInfoMessages(prevMidnightUtcSeconds, afterMidnightUtcSeconds);
        PersonVariables personVariables = firstJoin.getPersonVariables();
        mainUiInfo.setPerson(firstJoin.getPerson());
        mainUiInfo.setPersonVariables(personVariables);
        mainUiInfo.setOrganisationPersonJoins(organisationPersonJoins);
        mainUiInfo.setInfoMessages(infoMessages);
        VersionInfo versionInfo = this.contextService.getVersionInfo();
        mainUiInfo.setVersionInfo(versionInfo);
        Long activeNetworkId = personVariables.getActiveNetworkId();
        Long activeProjectId = personVariables.getActiveSubprojectId();
        Long activePnNetworkId = personVariables.getActivePnNetworkId();
        ArrayList<Long> organisationPersonIds = new ArrayList<Long>();
        for (OrganisationPersonJoin organisationPersonJoin2 : organisationPersonJoins) {
            organisationPersonIds.add(organisationPersonJoin2.getOrganisationPersonId());
        }
        Map<Long, List<Network>> organisationPersonIdToNetworks = this.networkDAO.getNetworksForOrganisationPersons(organisationPersonIds);
        mainUiInfo.setOrganisationPersonIdToNetworks(organisationPersonIdToNetworks);
        List<Project> projects = this.projectDAO.getUserVisibleByStatesAndNetwork(activeNetworkId, ProjectStatus.ACTIVE.getValue(), ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue());
        HashMap<Long, List<Project>> networkIdToProjects = new HashMap<Long, List<Project>>();
        networkIdToProjects.put(activeNetworkId, projects);
        mainUiInfo.setNetworkIdToProjects(networkIdToProjects);
        List<SubProject> subProjects = this.subProjectDAO.getValidByProject(activeProjectId);
        HashMap<Long, List<SubProject>> projectIdToSubProjects = new HashMap<Long, List<SubProject>>();
        projectIdToSubProjects.put(activeProjectId, subProjects);
        mainUiInfo.setProjectIdToSubProjects(projectIdToSubProjects);
        mainUiInfo.setEnableCustomerLogo(this.enableCustomerLogo);
        mainUiInfo.setIsTestInstance(this.isTestInstance);
        mainUiInfo.setCertificateAdministrationGlobal(this.certificateAdministrationGlobal);
        mainUiInfo.setExternalManualLink(this.externalManualLink);
        return mainUiInfo;
    }

    public void updateContext(String tabSessionId, Long organisationPersonId, Long networkId, Long projectId, Long subProjectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = loginPrincipal.getPersonId();
        PersonVariables personVariables = this.personVariablesDAO.getUniqueByPerson(personId);
        personVariables.setActiveOrganisationPersonId(organisationPersonId);
        personVariables.setActiveNetworkId(networkId);
        personVariables.setActiveProjectId(projectId);
        personVariables.setActiveSubprojectId(subProjectId);
        personVariables.setPreselectedTab(Integer.valueOf(6));
        this.personVariablesDAO.update(personVariables);
        this.tabSessionContextService.writeContext(tabSessionId, organisationPersonId, networkId, projectId, subProjectId);
    }

    public void updatePnContext(String tabSessionId, Long organisationPersonId, Long networkId, Long projectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = loginPrincipal.getPersonId();
        PersonVariables personVariables = this.personVariablesDAO.getUniqueByPerson(personId);
        personVariables.setActiveOrganisationPersonId(organisationPersonId);
        personVariables.setActivePnNetworkId(networkId);
        personVariables.setActivePnProjectId(projectId);
        personVariables.setPreselectedTab(Integer.valueOf(7));
        this.personVariablesDAO.update(personVariables);
        this.tabSessionContextService.writePnContext(tabSessionId, organisationPersonId, networkId, projectId);
    }

    public boolean openBuekTasksByDefault() {
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = loginPrincipal.getPersonId();
        PersonVariables personVariables = this.personVariablesDAO.getUniqueByPerson(personId);
        Integer preselectedTab = personVariables.getPreselectedTab();
        List<OrganisationPersonJoin> organisationPersonJoins = this.organisationPersonDAO.getActiveOrganisationPersonJoinByPerson(personId);
        boolean openBuekTasksByDefault = false;
        boolean mayShowReviewSection = false;
        boolean mayShowBuek = false;
        for (OrganisationPersonJoin organisationPersonJoin : organisationPersonJoins) {
            Long organisationPersonId = organisationPersonJoin.getOrganisationPersonId();
            Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.REVIEW_SECTION_OVERVIEW, Action.PLANNING_NOTIFICATION_SECTION_OVERVIEW);
            mayShowReviewSection |= globalActions.contains(Action.REVIEW_SECTION_OVERVIEW);
            mayShowBuek |= globalActions.contains(Action.PLANNING_NOTIFICATION_SECTION_OVERVIEW);
        }
        if (preselectedTab != null && preselectedTab == 7 && mayShowBuek) {
            openBuekTasksByDefault = true;
        } else if ((preselectedTab == null || preselectedTab != null && preselectedTab < 7) && !mayShowReviewSection) {
            openBuekTasksByDefault = true;
        }
        return openBuekTasksByDefault;
    }

    public Person getOwnPerson() {
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = loginPrincipal.getPersonId();
        Person person = (Person)this.personDAO.get(personId);
        PersonHelper.removeSecurityPersonData(person);
        return person;
    }

    public PasswordRequirements getPasswordRequirements() {
        PasswordRequirements passwordRequirements = new PasswordRequirements();
        passwordRequirements.setPasswordMinLength(this.passwordMinLength);
        passwordRequirements.setSecurityAnswerMinLength(this.securityAnswerMinLength);
        return passwordRequirements;
    }

    public boolean isOldPasswordReused(String password) {
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = loginPrincipal.getPersonId();
        if (this.maximumNumberOfOldPasswords != null && this.maximumNumberOfOldPasswords > 0) {
            Person person = (Person)this.personDAO.get(personId);
            List<OldPassword> oldPasswords = this.oldPasswordDAO.getByPerson(personId);
            return oldPasswords.stream().anyMatch(oldPw -> PasswordUtil.checkPassword(oldPw.getPassword(), password)) || person != null && person.getPassword() != null && PasswordUtil.checkPassword(person.getPassword(), password);
        }
        return false;
    }

    public void changePersonPasswordAndSecurityQuestion(String newPassword, String oldPassword, String question, String answer) {
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = loginPrincipal.getPersonId();
        log.info("Called PersonServiceImpl.changePersonPasswordAndSecurityQuestion for person [" + personId + "]");
        this.personPasswordChanger.changePersonPasswordAndSecurityQuestion(personId, newPassword, oldPassword, question, answer);
    }

    public PersonOwnEditInfo getPersonOwnEditInfo() {
        PersonOwnEditInfo ownEditInfo = new PersonOwnEditInfo();
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = loginPrincipal.getPersonId();
        Person person = (Person)this.personDAO.get(personId);
        List<PersonVariables> personVariablesList = this.personVariablesDAO.getByPerson(personId);
        PersonVariables somePersonVariables = personVariablesList.size() > 0 ? personVariablesList.get(0) : null;
        List<OrganisationPersonJoin> organisationPersonJoins = this.organisationPersonDAO.getOrganisationPersonJoinByPerson(personId);
        List countries = this.countryDAO.getAll();
        PersonHelper.removeSecurityPersonData(person);
        ownEditInfo.setPerson(person);
        ownEditInfo.setPersonVariables(somePersonVariables);
        ownEditInfo.setOrganisationPersonJoins(organisationPersonJoins);
        ownEditInfo.setCountries(countries);
        return ownEditInfo;
    }

    public void updateOwnPersonData(Person newPerson, PersonVariables newPersonVariables, List<OrganisationPersonJoin> newOrganisationPersonJoins) {
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = loginPrincipal.getPersonId();
        Person person = (Person)this.personDAO.get(personId);
        person.setGender(newPerson.getGender());
        person.setTitle(newPerson.getTitle());
        person.setGivenName(newPerson.getGivenName());
        person.setSurName(newPerson.getSurName());
        this.personDAO.update(person);
        List<PersonVariables> personVariablesList = this.personVariablesDAO.getByPerson(personId);
        PersonVariables personVariables = personVariablesList.size() > 0 ? personVariablesList.get(0) : null;
        personVariables.setUserLocale(newPersonVariables.getUserLocale());
        this.personVariablesDAO.update(personVariables);
        List<OrganisationPerson> organisationPersons = this.organisationPersonDAO.getByPerson(personId);
        Map<Long, OrganisationPerson> idToOrganisationPerson = ContainerHelper.groupById(organisationPersons);
        for (OrganisationPersonJoin newOrganisationPersonJoin : newOrganisationPersonJoins) {
            OrganisationPerson newOrganisationPerson = newOrganisationPersonJoin.getOrganisationPerson();
            OrganisationPerson organisationPerson = idToOrganisationPerson.get(newOrganisationPerson.getId());
            organisationPerson.setOrganisationalUnitName(newOrganisationPerson.getOrganisationalUnitName());
            organisationPerson.setPostalAddress(newOrganisationPerson.getPostalAddress());
            organisationPerson.setPostalCode(newOrganisationPerson.getPostalCode());
            organisationPerson.setLocalityName(newOrganisationPerson.getLocalityName());
            organisationPerson.setCountryId(newOrganisationPerson.getCountryId());
            organisationPerson.setTelephoneNumber(newOrganisationPerson.getTelephoneNumber());
            organisationPerson.setMobileTelephoneNumber(newOrganisationPerson.getMobileTelephoneNumber());
            organisationPerson.setFacsimileTelephoneNumber(newOrganisationPerson.getFacsimileTelephoneNumber());
            organisationPerson.setEmailAddress(newOrganisationPerson.getEmailAddress());
            organisationPerson.setEmailSendTime(newOrganisationPerson.getEmailSendTime());
            organisationPerson.setEmailSendMode(newOrganisationPerson.getEmailSendMode());
            log.info("personId [" + personId + "] changed personal settings: EmailAddress [" + newOrganisationPerson.getEmailAddress() + "] EmailSendMode [" + newOrganisationPerson.getEmailSendMode() + "] EmailSendTime [" + newOrganisationPerson.getEmailSendTime() + "]");
        }
        this.organisationPersonDAO.updateBatch(organisationPersons);
    }
}

