/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.joinDto.OrganisationPersonSelectionJoin;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcOrganisationPersonDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcOrganisationPersonDAO
extends AbstractJdbcOrganisationPersonDAO
implements OrganisationPersonDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcOrganisationPersonDAO.class);

    @Override
    public List<OrganisationPersonJoin> getOrganisationPersonJoinByPerson(Long personId) {
        ArrayList<Long> personIds = new ArrayList<Long>();
        personIds.add(personId);
        return this.getOrganisationPersonJoinByPersons(personIds);
    }

    @Override
    public List<OrganisationPersonJoin> getOrganisationPersonJoinByPersons(final List<Long> personIds) {
        if (personIds.size() == 0) {
            return new ArrayList<OrganisationPersonJoin>();
        }
        String sql = "SELECT " + JdbcOrganisationPersonDAO.getOrganisationPersonJoinSelectClause() + "FROM       ((((organisation_person  JOIN organisation              ON organisation_person.organisation_id = organisation.id) JOIN person                    ON organisation_person.person_id = person.id) JOIN person_variables          ON person_variables.person_id = person.id) LEFT JOIN countries op_country ON organisation_person.country_id = op_country.id) WHERE person.id IN (" + QueryHelper.getPlaceHolderSequence(personIds.size()) + ")";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<OrganisationPersonJoin>>(){

            public List<OrganisationPersonJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long personId : personIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<OrganisationPersonJoin> ret = new ArrayList<OrganisationPersonJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcOrganisationPersonDAO.fillOrganisationPersonJoinFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<OrganisationPersonJoin> getOrganisationPersonJoinByOrganisation(final Long organisationId) {
        String sql = "SELECT " + JdbcOrganisationPersonDAO.getOrganisationPersonJoinSelectClause() + "FROM       ((((organisation_person  JOIN organisation              ON organisation_person.organisation_id = organisation.id) JOIN person                    ON (organisation_person.person_id = person.id AND person.invalidated = 0)) JOIN person_variables          ON person_variables.person_id = person.id) LEFT JOIN countries op_country ON organisation_person.country_id = op_country.id) WHERE organisation.id = ?";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<OrganisationPersonJoin>>(){

            public List<OrganisationPersonJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
                ResultSet rs = statement.executeQuery();
                ArrayList<OrganisationPersonJoin> ret = new ArrayList<OrganisationPersonJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcOrganisationPersonDAO.fillOrganisationPersonJoinFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<OrganisationPersonJoin> getOrganisationPersonJoin(final Long ... organisationPersonIds) {
        if (organisationPersonIds.length == 0) {
            return new ArrayList<OrganisationPersonJoin>();
        }
        String sql = "SELECT " + JdbcOrganisationPersonDAO.getOrganisationPersonJoinSelectClause() + "FROM       ((((organisation_person  JOIN organisation              ON organisation_person.organisation_id = organisation.id) JOIN person                    ON organisation_person.person_id = person.id) JOIN person_variables          ON person_variables.person_id = person.id) LEFT JOIN countries op_country      ON organisation_person.country_id = op_country.id) WHERE organisation_person.id IN (";
        for (int n = 0; n < organisationPersonIds.length; ++n) {
            if (organisationPersonIds[n] == null) continue;
            sql = sql + "?";
            if (n >= organisationPersonIds.length - 1) continue;
            sql = sql + ", ";
        }
        sql = sql + ")";
        if (log.isDebugEnabled()) {
            log.debug("Will emit query [" + sql + "]");
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<OrganisationPersonJoin>>(){

            public List<OrganisationPersonJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long organisationPersonId : organisationPersonIds) {
                    if (organisationPersonId == null) continue;
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<OrganisationPersonJoin> ret = new ArrayList<OrganisationPersonJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcOrganisationPersonDAO.fillOrganisationPersonJoinFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public OrganisationPersonJoin getOrganisationPersonJoinById(Long organisationPersonId) {
        List<OrganisationPersonJoin> organisationPersonJoins = this.getOrganisationPersonJoin(organisationPersonId);
        if (organisationPersonJoins.size() == 0) {
            return null;
        }
        if (organisationPersonJoins.size() > 1) {
            throw new IllegalArgumentException("Found [" + organisationPersonJoins.size() + "] instances of OrganisationPersonJoin for organisationPersonId = [" + organisationPersonId + "]; expected exactly one.");
        }
        return organisationPersonJoins.get(0);
    }

    @Override
    public List<Long> getNetworkIdsViaNetworkOrganisation(final Long organisationPersonId) {
        String sql = "SELECT network_organisation.network_id FROM ((    organisation_person JOIN organisation                       ON organisation_person.organisation_id = organisation.id) JOIN network_organisation               ON network_organisation.organisation_id = organisation.id) WHERE organisation_person.id = ?";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Long>>(){

            public List<Long> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)organisationPersonId);
                ResultSet rs = statement.executeQuery();
                ArrayList<Long> ret = new ArrayList<Long>();
                while (rs.next()) {
                    ret.add(JDBCHelper.getLong((ResultSet)rs, (int)1));
                }
                return ret;
            }
        });
    }

    @Override
    public List<OrganisationPerson> getActiveOrganisationPersonsByWorkflow(final Long workflowId) {
        String sql = "SELECT DISTINCT " + JdbcOrganisationPersonDAO.getSelectClauseForDto() + "FROM ((((               workflow_node JOIN workflow_node_position                     ON workflow_node_position.workflow_node_id = workflow_node.id) JOIN project_participation                      ON workflow_node_position.project_participation_id = project_participation.id) JOIN project_participant                        ON project_participant.participation_id = project_participation.id) JOIN organisation_person                        ON project_participant.organisation_person_id = organisation_person.id) WHERE workflow_node.workflow_id = ? AND (project_participation.invalidated IS NULL OR project_participation.invalidated = 0) AND (project_participant.inactive_flag IS NULL OR project_participant.inactive_flag = 0) ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<OrganisationPerson>>(){

            public List<OrganisationPerson> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)workflowId);
                ResultSet rs = statement.executeQuery();
                ArrayList<OrganisationPerson> ret = new ArrayList<OrganisationPerson>();
                while (rs.next()) {
                    ret.add(JdbcOrganisationPersonDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<OrganisationPerson> getActiveOrganisationPersonsByNode(final Long nodeId) {
        String sql = "SELECT DISTINCT " + JdbcOrganisationPersonDAO.getSelectClauseForDto() + "FROM ((((               workflow_node JOIN workflow_node_position                     ON workflow_node_position.workflow_node_id = workflow_node.id) JOIN project_participation                      ON workflow_node_position.project_participation_id = project_participation.id) JOIN project_participant                        ON project_participant.participation_id = project_participation.id) JOIN organisation_person                        ON project_participant.organisation_person_id = organisation_person.id) WHERE workflow_node.id = ? AND (project_participation.invalidated IS NULL OR project_participation.invalidated = 0) AND (project_participant.inactive_flag IS NULL OR project_participant.inactive_flag = 0) ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<OrganisationPerson>>(){

            public List<OrganisationPerson> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)nodeId);
                ResultSet rs = statement.executeQuery();
                ArrayList<OrganisationPerson> ret = new ArrayList<OrganisationPerson>();
                while (rs.next()) {
                    ret.add(JdbcOrganisationPersonDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<OrganisationPerson> getActiveOrganisationPersonsByPosition(final Long positionId) {
        String sql = "SELECT DISTINCT " + JdbcOrganisationPersonDAO.getSelectClauseForDto() + "FROM ((((               workflow_node JOIN workflow_node_position                     ON workflow_node_position.workflow_node_id = workflow_node.id) JOIN project_participation                      ON workflow_node_position.project_participation_id = project_participation.id) JOIN project_participant                        ON project_participant.participation_id = project_participation.id) JOIN organisation_person                        ON project_participant.organisation_person_id = organisation_person.id) WHERE workflow_node_position.id = ? AND (project_participation.invalidated IS NULL OR project_participation.invalidated = 0) AND (project_participant.inactive_flag IS NULL OR project_participant.inactive_flag = 0) ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<OrganisationPerson>>(){

            public List<OrganisationPerson> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)positionId);
                ResultSet rs = statement.executeQuery();
                ArrayList<OrganisationPerson> ret = new ArrayList<OrganisationPerson>();
                while (rs.next()) {
                    ret.add(JdbcOrganisationPersonDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<OrganisationPersonJoin> getOrganisationPersonJoinForProjectParticipants(final Long projectId) {
        String sql = "SELECT " + JdbcOrganisationPersonDAO.getOrganisationPersonJoinSelectClause() + "FROM       (((((( project_participation JOIN project_participant       ON       project_participant.participation_id = project_participation.id AND project_participant.inactive_flag = 0) JOIN organisation_person       ON project_participant.organisation_person_id = organisation_person.id AND organisation_person.retired_flag = 0) JOIN organisation              ON organisation_person.organisation_id = organisation.id) JOIN person                    ON organisation_person.person_id = person.id) JOIN person_variables          ON person_variables.person_id = person.id) LEFT JOIN countries op_country ON organisation_person.country_id = op_country.id) WHERE project_participation.project_id = ? AND project_participation.invalidated = 0 ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<OrganisationPersonJoin>>(){

            public List<OrganisationPersonJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<OrganisationPersonJoin> rawResults = new ArrayList<OrganisationPersonJoin>();
                while (rs.next()) {
                    rawResults.add(AbstractJdbcOrganisationPersonDAO.fillOrganisationPersonJoinFromResultSet(rs));
                }
                HashMap<Long, OrganisationPersonJoin> distinct = new HashMap<Long, OrganisationPersonJoin>();
                for (OrganisationPersonJoin rawResult : rawResults) {
                    distinct.put(rawResult.getOrganisationPersonId(), rawResult);
                }
                return new ArrayList<OrganisationPersonJoin>(distinct.values());
            }
        });
    }

    @Override
    public List<OrganisationPersonSelectionJoin> getAllOrganisationPersonSelectionJoins() {
        String sql = "SELECT " + JdbcOrganisationPersonDAO.getOrganisationPersonSelectionJoinSelectClause() + "FROM (( organisation_person JOIN person                ON organisation_person.person_id = person.id) JOIN organisation          ON organisation_person.organisation_id = organisation.id) WHERE organisation_person.retired_flag IS NULL OR organisation_person.retired_flag = 0 ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<OrganisationPersonSelectionJoin>>(){

            public List<OrganisationPersonSelectionJoin> perform(PreparedStatement statement) throws Exception {
                ResultSet rs = statement.executeQuery();
                ArrayList<OrganisationPersonSelectionJoin> ret = new ArrayList<OrganisationPersonSelectionJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcOrganisationPersonDAO.fillOrganisationPersonSelectionJoinFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<OrganisationPersonSelectionJoin> getAllNetworkPersonOrganisationPersonSelectionJoins() {
        String sql = "SELECT DISTINCT " + JdbcOrganisationPersonDAO.getOrganisationPersonSelectionJoinSelectClause() + "FROM network_person JOIN organisation_person ON network_person.organisation_person_id = organisation_person.id JOIN organisation        ON organisation_person.organisation_id = organisation.id JOIN person              ON organisation_person.person_id = person.id ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcOrganisationPersonDAO::fillOrganisationPersonSelectionJoinFromResultSet, statement -> {});
    }

    @Override
    public OrganisationPersonJoin getOrganisationPersonJoinByParticipationViaMainParticipant(Long participationId) {
        String sql = "SELECT " + JdbcOrganisationPersonDAO.getOrganisationPersonJoinSelectClause() + "FROM project_participation JOIN project_participant       ON       project_participant.participation_id = project_participation.id AND project_participant.inactive_flag = 0 AND project_participant.main_participant_flag = 1 JOIN organisation_person       ON project_participant.organisation_person_id = organisation_person.id AND organisation_person.retired_flag = 0 JOIN organisation              ON organisation_person.organisation_id = organisation.id JOIN person                    ON organisation_person.person_id = person.id JOIN person_variables          ON person_variables.person_id = person.id LEFT JOIN countries op_country ON organisation_person.country_id = op_country.id WHERE project_participation.id = ? ";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, AbstractJdbcOrganisationPersonDAO::fillOrganisationPersonJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)participationId);
        });
    }

    @Override
    public List<OrganisationPersonSelectionJoin> getParticipationSearchOrganisationPersonSelectionJoins(final Long personId) {
        String sql = "SELECT " + JdbcOrganisationPersonDAO.getOrganisationPersonSelectionJoinSelectClause() + "FROM (((((( organisation_person base_organisation_person JOIN project_participant base_participant ON base_participant.organisation_person_id = base_organisation_person.id) JOIN project_participation base_participation ON base_participant.participation_id = base_participation.id) LEFT JOIN project_participant   ON project_participant.participation_id = base_participation.id) LEFT JOIN organisation_person   ON project_participant.organisation_person_id = organisation_person.id) LEFT JOIN person                ON organisation_person.person_id = person.id) LEFT JOIN organisation          ON base_participation.organisation_id = organisation.id) WHERE (base_participant.inactive_flag IS NULL OR base_participant.inactive_flag = 0) AND (project_participant.inactive_flag IS NULL OR project_participant.inactive_flag = 0) AND base_organisation_person.person_id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<OrganisationPersonSelectionJoin>>(){

            public List<OrganisationPersonSelectionJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                ResultSet rs = statement.executeQuery();
                ArrayList<OrganisationPersonSelectionJoin> ret = new ArrayList<OrganisationPersonSelectionJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcOrganisationPersonDAO.fillOrganisationPersonSelectionJoinFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<OrganisationPersonJoin> getAllActiveOrganisationPersonJoins() {
        String sql = "SELECT " + JdbcOrganisationPersonDAO.getOrganisationPersonJoinSelectClause() + "\n     FROM organisation_person\n     JOIN certificate          ON certificate.organisation_person_id = organisation_person.id\n     JOIN organisation         ON organisation_person.organisation_id = organisation.id\n     JOIN person               ON organisation_person.person_id = person.id\n     JOIN person_variables     ON person_variables.person_id = person.id\nLEFT JOIN countries op_country ON organisation_person.country_id = op_country.id\nWHERE organisation_person.retired_flag = 0\n     AND certificate.may_sign = 1 AND certificate.may_login = 1\n     AND certificate.cert_valid_to > CAST(CURRENT_TIMESTAMP - 30 AS DATE)\n";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<OrganisationPersonJoin>>(){

            public List<OrganisationPersonJoin> perform(PreparedStatement statement) throws Exception {
                ResultSet rs = statement.executeQuery();
                ArrayList<OrganisationPersonJoin> ret = new ArrayList<OrganisationPersonJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcOrganisationPersonDAO.fillOrganisationPersonJoinFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<OrganisationPersonJoin> getActiveOrganisationPersonJoinByPerson(final Long personId) {
        String sql = "SELECT " + JdbcOrganisationPersonDAO.getOrganisationPersonJoinSelectClause() + "FROM      (((( person JOIN person_variables    ON person_variables.person_id = person.id) LEFT JOIN organisation_person ON organisation_person.person_id = person.id AND (    organisation_person.retired_flag IS NULL OR organisation_person.retired_flag = 0) AND EXISTS (SELECT 1 FROM certificate WHERE certificate.organisation_person_id = organisation_person.id AND certificate.may_login = 1 AND certificate.may_sign = 1 AND certificate.cert_valid_from <= ? AND certificate.cert_valid_to >= ? )) LEFT JOIN organisation         ON organisation_person.organisation_id = organisation.id) LEFT JOIN countries op_country ON organisation_person.country_id = op_country.id) WHERE person.id = ? AND (person.invalidated IS NULL OR person.invalidated = 0) ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<OrganisationPersonJoin>>(){

            public List<OrganisationPersonJoin> perform(PreparedStatement statement) throws Exception {
                Long currentUtcMillis = System.currentTimeMillis();
                Double currentUtcSeconds = currentUtcMillis.doubleValue() / 1000.0;
                int currIndex = 1;
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)currentUtcSeconds);
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)currentUtcSeconds);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                ResultSet rs = statement.executeQuery();
                ArrayList<OrganisationPersonJoin> ret = new ArrayList<OrganisationPersonJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcOrganisationPersonDAO.fillOrganisationPersonJoinFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<OrganisationPersonSelectionJoin> getOrganisationPersonSelectionJoinsByOrganisation(Long organisationId) {
        String sql = "SELECT " + this.getOrganisationPersonSelectionJoinSelectClause() + "\n     FROM organisation start_org\nLEFT JOIN consortium_member   ON consortium_member.consortium_id = start_org.id\n     JOIN organisation_person ON organisation_person.organisation_id IN (consortium_member.organisation_id, start_org.id)\n     JOIN organisation        ON organisation.id = organisation_person.organisation_id\n     JOIN person              ON person.id = organisation_person.person_id\nWHERE start_org.id = ?\n";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcOrganisationPersonDAO::fillOrganisationPersonSelectionJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
        });
    }

    @Override
    public OrganisationPerson getPlannerMainParticipantOrgPersonByDocumentVersionId(Long documentVersionId) {
        String sql = "SELECT " + JdbcOrganisationPersonDAO.getSelectClauseForDto() + "FROM document_version JOIN document              ON document_version.document_id = document.id JOIN object_planner        ON document.object_planner_id = object_planner.id JOIN project_participation ON object_planner.planner_id = project_participation.id JOIN project_participant   ON     project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag = 0 JOIN organisation_person   ON project_participant.organisation_person_id = organisation_person.id WHERE document_version.id = ? ";
        return QueryHelper.getUniqueWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(documentVersionId));
    }

    @Override
    public OrganisationPerson getPlannerMainParticipantOrgPersonByDocumentId(Long documentId) {
        String sql = "SELECT " + JdbcOrganisationPersonDAO.getSelectClauseForDto() + "FROM document JOIN object_planner        ON document.object_planner_id = object_planner.id JOIN project_participation ON object_planner.planner_id = project_participation.id JOIN project_participant   ON     project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag = 0 JOIN organisation_person   ON project_participant.organisation_person_id = organisation_person.id WHERE document.id = ? ";
        return QueryHelper.getUniqueWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(documentId));
    }

    @Override
    public List<OrganisationPersonSelectionJoin> getOPJoinsBySubProjectViaOriginalRequest(Long subProjectId) {
        String sql = "SELECT DISTINCT " + this.getOrganisationPersonSelectionJoinSelectClause() + "\nFROM       original_document_order JOIN organisation_person_order_step ON original_document_order.request_id = organisation_person_order_step.order_step_id JOIN organisation_person            ON organisation_person_order_step.organisation_person_id = organisation_person.id AND organisation_person.retired_flag = 1 JOIN organisation                   ON organisation_person.organisation_id = organisation.id JOIN person                         ON organisation_person.person_id = person.id WHERE original_document_order.sub_project_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcOrganisationPersonDAO::fillOrganisationPersonSelectionJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        });
    }

    @Override
    public List<OrganisationPersonSelectionJoin> getOPJoinsBySubProjectViaOriginalReceiver(Long subProjectId) {
        String sql = "SELECT DISTINCT * FROM (\nSELECT " + this.getPrefixedOrganisationPersonSelectionJoinSelectClause() + "\nFROM       original_document_order JOIN original_document_order_item   ON original_document_order_item.order_contract_id = original_document_order.id JOIN organisation_person            ON original_document_order_item.receiver_id = organisation_person.id AND organisation_person.retired_flag = 0 JOIN organisation                   ON organisation_person.organisation_id = organisation.id JOIN person                         ON organisation_person.person_id = person.id WHERE original_document_order.sub_project_id = ? UNION ALL SELECT " + this.getPrefixedOrganisationPersonSelectionJoinSelectClause() + "\nFROM       original_document_order JOIN original_document_order_item   ON original_document_order_item.order_contract_id = original_document_order.id JOIN project_participation          ON original_document_order_item.receiver_id = project_participation.id AND project_participation.invalidated = 0 JOIN project_participant            ON project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag = 0 JOIN organisation_person            ON project_participant.organisation_person_id = organisation_person.id AND organisation_person.retired_flag = 0 JOIN organisation                   ON organisation_person.organisation_id = organisation.id JOIN person                         ON organisation_person.person_id = person.id WHERE original_document_order.sub_project_id = ? ) AS a\n";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcOrganisationPersonDAO::fillOrganisationPersonSelectionJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        });
    }

    @Override
    public List<OrganisationPersonSelectionJoin> getOPSearchJoinsByObjectListId(Long objectListId) {
        String sql = "SELECT " + JdbcOrganisationPersonDAO.getOrganisationPersonSelectionJoinSelectClause() + "FROM object JOIN object_planner           ON object_planner.object_id = object.id JOIN project_participation    ON object_planner.planner_id = project_participation.id JOIN project_participant      ON project_participant.participation_id = project_participation.id AND project_participant.inactive_flag = 0 AND project_participant.main_participant_flag = 1 JOIN organisation_person      ON project_participant.organisation_person_id = organisation_person.id JOIN organisation             ON organisation_person.organisation_id = organisation.id JOIN person                   ON organisation_person.person_id = person.id WHERE object.object_list_id = ? AND object.inactive_flag = 0 UNION ALL SELECT " + JdbcOrganisationPersonDAO.getOrganisationPersonSelectionJoinSelectClause() + "FROM object JOIN object_planner           ON object_planner.object_id = object.id JOIN object_planner_position  ON object_planner_position.object_planner_id = object_planner.id JOIN project_participation    ON object_planner_position.project_participation_id = project_participation.id JOIN project_participant      ON project_participant.participation_id = project_participation.id AND project_participant.inactive_flag = 0 AND project_participant.main_participant_flag = 1 JOIN organisation_person      ON project_participant.organisation_person_id = organisation_person.id JOIN organisation             ON organisation_person.organisation_id = organisation.id JOIN person                   ON organisation_person.person_id = person.id WHERE object.object_list_id = ? AND object.inactive_flag = 0 ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcOrganisationPersonDAO::fillOrganisationPersonSelectionJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectListId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectListId);
        });
    }

    @Override
    public List<OrganisationPersonSelectionJoin> getOPSearchJoinsByObjectListReleaseId(Long objectListReleaseId) {
        String sql = "SELECT " + JdbcOrganisationPersonDAO.getOrganisationPersonSelectionJoinSelectClause() + "FROM object_release JOIN object_planner_release   ON object_planner_release.object_id = object_release.id JOIN project_participation    ON object_planner_release.planner_id = project_participation.id JOIN project_participant      ON project_participant.participation_id = project_participation.id AND project_participant.inactive_flag = 0 AND project_participant.main_participant_flag = 1 JOIN organisation_person      ON project_participant.organisation_person_id = organisation_person.id JOIN organisation             ON organisation_person.organisation_id = organisation.id JOIN person                   ON organisation_person.person_id = person.id WHERE object_release.object_list_release_id = ? AND object_release.inactive_flag = 0 UNION ALL SELECT " + JdbcOrganisationPersonDAO.getOrganisationPersonSelectionJoinSelectClause() + "FROM object_release JOIN object_planner_release   ON object_planner_release.object_id = object_release.id JOIN object_planner_position_release ON object_planner_position_release.object_planner_id = object_planner_release.id JOIN project_participation    ON object_planner_position_release.project_participation_id = project_participation.id JOIN project_participant      ON project_participant.participation_id = project_participation.id AND project_participant.inactive_flag = 0 AND project_participant.main_participant_flag = 1 JOIN organisation_person      ON project_participant.organisation_person_id = organisation_person.id JOIN organisation             ON organisation_person.organisation_id = organisation.id JOIN person                   ON organisation_person.person_id = person.id WHERE object_release.object_list_release_id = ? AND object_release.inactive_flag = 0 ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcOrganisationPersonDAO::fillOrganisationPersonSelectionJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectListReleaseId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectListReleaseId);
        });
    }

    @Override
    public OrganisationPerson getAsBuiltContractorOrganisationPerson(Long objectPlannerId) {
        String sql = "SELECT " + this.getSelectClauseForDto() + "\nFROM object_planner\nJOIN object_planner_position            ON object_planner_position.object_planner_id = object_planner.as_built_reference\nJOIN object_planner_position_definition ON object_planner_position_definition.id = object_planner_position.definition_id\nJOIN cdes_role                          ON cdes_role.id = object_planner_position.role_id\n                                       AND cdes_role.project_flag = 4\nJOIN project_participation              ON project_participation.id = object_planner_position.project_participation_id\nJOIN project_participant                ON project_participant.participation_id = project_participation.id\n                                       AND project_participant.main_participant_flag = 1\n                                       AND project_participant.inactive_flag != 1\nJOIN organisation_person                ON project_participant.organisation_person_id = organisation_person.id\nWHERE object_planner.id =  ?\nORDER BY object_planner_position_definition.name\n" + QueryHelper.getLimitClause((JdbcDAOSupport)this, "1") + "";
        return QueryHelper.getUniqueWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(objectPlannerId));
    }

    @Override
    public List<OrganisationPerson> getActiveOrganisationPersonsByProject(Long projectId) {
        String sql = "SELECT " + JdbcOrganisationPersonDAO.getSelectClauseForDto() + "FROM project JOIN project_participation ON project_participation.project_id = project.id JOIN project_participant   ON project_participant.participation_id = project_participation.id JOIN organisation_person   ON project_participant.organisation_person_id = organisation_person.id WHERE project.id = ? AND project_participation.invalidated = 0 AND project_participant.inactive_flag = 0 AND organisation_person.retired_flag = 0 ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
        });
    }
}

