/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ReviewCycle;
import at.cdes.api.joinDto.GenerateTaskDeadlinesJoin;
import at.cdes.api.joinDto.PlanDeliverReleaseJoin;
import at.cdes.api.joinDto.ReviewCycleRealmChainJoin;
import at.cdes.api.joinDto.ReviewCycleSelectJoin;
import at.cdes.api.joinDto.ReviewCycleTreeJoin;
import at.cdes.api.result.ResultSummary;
import at.cdes.api.voc.RoleTypeEnum;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ReviewCycleDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcReviewCycleDAO;
import at.cdes.impl.dao.unionComponent.GenerateTaskDeadlinesJoinComponent;
import at.cdes.impl.dao.unionComponent.PlanDeliverReleaseComponent;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcReviewCycleDAO
extends AbstractJdbcReviewCycleDAO
implements ReviewCycleDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcReviewCycleDAO.class);

    @Override
    public List<PlanDeliverReleaseJoin> getPlanDeliverReleaseJoin(final Long projectId, final Long subProjectId, final List<Long> documentIds) {
        final String sql = "SELECT " + this.getReleaseUnionSelectClause(PlanDeliverReleaseComponent.DOCUMENT, "document", "documentRelease") + ", null FROM (( document_list_release  LEFT JOIN document                                   ON 1=1) LEFT JOIN document_release                           ON     document_release.document_id = document.id AND document_release.document_list_id = document_list_release.id) WHERE document.id IN (" + QueryHelper.getPlaceHolderSequence(documentIds.size()) + ") AND document_list_release.sub_project_id = ? AND document_list_release.version = (SELECT MAX(document_list_release_local.version) FROM document_list_release document_list_release_local WHERE document_list_release_local.sub_project_id = ?) UNION ALL SELECT " + this.getReleaseUnionSelectClause(PlanDeliverReleaseComponent.DOCUMENT_VERSION_TASK, "document", "documentRelease", "documentVersion", "documentVersionTask", "project", "baseTask") + ", null FROM ((((((((((((( document  LEFT JOIN document_version                      ON document_version.document_id = document.id) LEFT JOIN document_version_task                 ON document_version_task.document_version_id = document_version.id) LEFT JOIN review_task                           ON review_task.task_id = document_version_task.task_id) LEFT JOIN attached_review_task                  ON attached_review_task.task_id = document_version_task.task_id) LEFT JOIN task                                  ON document_version_task.task_id = task.id) LEFT JOIN object_planner                        ON document.object_planner_id = object_planner.id) LEFT JOIN object                                ON object_planner.object_id = object.id) LEFT JOIN object_list                           ON object.object_list_id = object_list.id) LEFT JOIN sub_project                           ON object_list.sub_project_id = sub_project.id) LEFT JOIN project                               ON sub_project.project_id = project.id) LEFT JOIN document_list                         ON document.document_list_id = document_list.id) LEFT JOIN document_list_release                 ON document_list_release.document_list_id = document_list.id AND document_list_release.version = (SELECT MAX(document_list_release_local.version) FROM document_list_release document_list_release_local WHERE document_list_release_local.sub_project_id = sub_project.id)) LEFT JOIN document_release                      ON document_release.document_list_id = document_list_release.id AND document_release.document_id = document.id) WHERE document_version.document_id in (" + QueryHelper.getPlaceHolderSequence(documentIds.size()) + ") AND (    review_task.task_id IS NOT NULL OR attached_review_task.task_id IS NOT NULL) UNION ALL SELECT " + this.getReleaseUnionSelectClause(PlanDeliverReleaseComponent.REVIEW_CYCLE, "cell", "cellConnection", "cellInstance", "cellInstanceReleased", "documentVersion", "instance", "instanceReleased", "node", "nodeInstance", "nodeInstanceReleased", "nodePositionReleased") + ", null FROM ((((((((((( document_version LEFT JOIN object_list_release                                        ON 1=1) LEFT JOIN review_cycle_node_instance node_instance                   ON document_version.active_node_instance_id = node_instance.id) LEFT JOIN review_cycle_cell_instance cell_instance                   ON node_instance.review_cycle_cell_instance_id = cell_instance.id) LEFT JOIN review_cycle_instance instance                             ON cell_instance.review_cycle_instance_id = instance.id) LEFT JOIN review_cycle_instance_released instance_released           ON instance_released.review_cycle_instance_id = instance.id AND instance_released.object_list_id = object_list_release.id) LEFT JOIN review_cycle_cell_instance_released cell_instance_released ON cell_instance_released.review_cycle_instance_id = instance_released.id) LEFT JOIN review_cycle_node_instance_released node_instance_released ON node_instance_released.review_cycle_cell_instance_id = cell_instance_released.id) LEFT JOIN review_cycle_node_position_released node_position_released ON node_position_released.review_cycle_node_instance_id = node_instance_released.id) LEFT JOIN review_cycle_node node                                     ON node_instance_released.review_cycle_node_id = node.id) LEFT JOIN review_cycle_cell cell                                     ON node.review_cycle_cell_id = cell.id) LEFT JOIN review_cycle_cell_connection cell_connection               ON (     cell_connection.source_cell_id = cell.id OR cell_connection.destination_cell_id = cell.id)) WHERE object_list_release.sub_project_id = ? AND object_list_release.version = (SELECT MAX(version) FROM object_list_release WHERE sub_project_id = ?) AND " + this.getDocumentVersionWhereClause(documentIds.size()) + "UNION ALL SELECT " + this.getReleaseUnionSelectClause(PlanDeliverReleaseComponent.DOCUMENT_VERSION_FUTURE_EMAIL, "documentVersion", "documentVersionTask", "futureEmail") + ", null FROM (( document_version LEFT JOIN document_version_task                 ON document_version_task.document_version_id = document_version.id) LEFT JOIN future_email                          ON future_email.task_id = document_version_task.task_id) WHERE " + this.getDocumentVersionTaskWhereClause(documentIds.size()) + "UNION ALL SELECT " + this.getReleaseUnionSelectClause(PlanDeliverReleaseComponent.DOCUMENT_VERSION_PARTICIPATION, "documentVersion", "documentVersionTask", "organisationPerson", "projectParticipant", "projectParticipation") + ", null FROM (((( document_version  LEFT JOIN document_version_task                 ON document_version_task.document_version_id = document_version.id) LEFT JOIN project_participation                 ON document_version_task.project_participation_id = project_participation.id) LEFT JOIN project_participant                   ON project_participant.participation_id = project_participation.id) LEFT JOIN organisation_person                   ON project_participant.organisation_person_id = organisation_person.id) WHERE " + this.getDocumentVersionTaskWhereClause(documentIds.size()) + "UNION ALL SELECT " + this.getReleaseUnionSelectClause(PlanDeliverReleaseComponent.PROJECT_ROLE, "projectParticipation") + ", null FROM ((((( project_participation JOIN cdes_role                                  ON project_participation.role_id = cdes_role.id) JOIN role_type                                  ON cdes_role.type_id = role_type.id) JOIN role_action_rule                           ON role_action_rule.cdes_role_id = cdes_role.id) JOIN action_rule                                ON role_action_rule.action_rule_id = action_rule.id) JOIN action                                     ON action_rule.action_id = action.id) WHERE project_participation.project_id = ? AND role_type.type = ? AND action.name = ? UNION ALL SELECT " + this.getReleaseUnionSelectClause(PlanDeliverReleaseComponent.ENTRY_TASK, "baseTask", "documentTask", "reviewCycleEntryTask") + ", null FROM ((((( document_task  JOIN task                                ON document_task.task_id = task.id) JOIN review_cycle_entry_task             ON review_cycle_entry_task.task_id = document_task.task_id) LEFT JOIN future_email                        ON future_email.task_id = document_task.task_id) LEFT JOIN task_email_snippet                  ON task_email_snippet.task_id = document_task.task_id) LEFT JOIN email_snippet                       ON task_email_snippet.email_snippet_id = email_snippet.id) WHERE document_task.document_id IN (" + QueryHelper.getPlaceHolderSequence(documentIds.size()) + ") UNION ALL SELECT " + this.getReleaseUnionSelectClause(PlanDeliverReleaseComponent.DOCUMENT_FUTURE_EMAIL, "documentTask", "emailSnippet", "futureEmail", "taskEmailSnippet") + ", null FROM ((( document_task LEFT JOIN future_email                             ON future_email.task_id = document_task.task_id) LEFT JOIN task_email_snippet                       ON task_email_snippet.task_id = document_task.task_id) LEFT JOIN email_snippet                            ON task_email_snippet.email_snippet_id = email_snippet.id) WHERE " + this.getDocumentTaskWhereClause(documentIds.size()) + "UNION ALL SELECT " + this.getReleaseUnionSelectClause(PlanDeliverReleaseComponent.DOCUMENT_PARTICIPATION, "documentTask", "organisationPerson", "projectParticipant", "projectParticipation") + ", null FROM ((( document_task  LEFT JOIN project_participation                   ON document_task.project_participation_id = project_participation.id) LEFT JOIN project_participant                     ON project_participant.participation_id = project_participation.id) LEFT JOIN organisation_person                     ON project_participant.organisation_person_id = organisation_person.id) WHERE " + this.getDocumentTaskWhereClause(documentIds.size()) + "UNION ALL SELECT " + this.getReleaseUnionSelectClause(PlanDeliverReleaseComponent.DOCUMENT_OBJECT_PLANNER, "instanceReleased", "objectPlannerRelease", "organisationPerson", "projectParticipant", "projectParticipation", "project") + ", null FROM ((((((((( object_planner  LEFT JOIN object_list_release                     ON 1=1) LEFT JOIN object_release                       ON object_release.object_list_release_id = object_list_release.id) LEFT JOIN object_planner_release               ON object_planner_release.object_planner_id = object_planner.id AND object_planner_release.object_id = object_release.id) LEFT JOIN review_cycle_instance_released instance_released           ON object_planner_release.review_cycle_instance_id = instance_released.id) LEFT JOIN project_participation                ON object_planner_release.planner_id = project_participation.id) LEFT JOIN project                              ON project_participation.project_id = project.id) LEFT JOIN project_participant                  ON project_participant.participation_id = project_participation.id) LEFT JOIN organisation_person                  ON project_participant.organisation_person_id = organisation_person.id) LEFT JOIN person                               ON organisation_person.person_id = person.id) WHERE object_list_release.sub_project_id = ? AND object_list_release.version = (SELECT MAX(version) FROM object_list_release WHERE sub_project_id = ?) AND EXISTS (SELECT 1 FROM document document_local WHERE    document_local.object_planner_id = object_planner.id AND document_local.id IN (" + QueryHelper.getPlaceHolderSequence(documentIds.size()) + ")) UNION ALL SELECT " + this.getReleaseUnionSelectClause(PlanDeliverReleaseComponent.POSITION_TYPE, "positionType") + ", null FROM review_cycle_position_type position_type UNION ALL SELECT " + this.getReleaseUnionSelectClause(PlanDeliverReleaseComponent.PROJECT_HOLIDAY, "projectHoliday") + ", null FROM project_holiday WHERE project_holiday.project_id = ? UNION ALL SELECT " + this.getReleaseUnionSelectClause(PlanDeliverReleaseComponent.RESULT_OPTION, "resultOption") + ", null FROM review_cycle_result_option result_option UNION ALL SELECT " + this.getReleaseUnionSelectClause(PlanDeliverReleaseComponent.REVIEW_CYCLE_NODE_RESULT, "document", "reviewCycleCellResult", "reviewCycleNodeResult") + ", (SELECT COUNT(1) FROM document_version WHERE document_version.document_id = document.id) FROM ((( document  LEFT JOIN document_version                      ON document_version.document_id = document.id) LEFT JOIN review_cycle_node_result              ON review_cycle_node_result.document_version_id = document_version.id) LEFT JOIN review_cycle_cell_result              ON review_cycle_node_result.review_cycle_cell_result_id = review_cycle_cell_result.id) WHERE document_version.document_id in (" + QueryHelper.getPlaceHolderSequence(documentIds.size()) + ") ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanDeliverReleaseJoin>>(){

            public List<PlanDeliverReleaseJoin> perform(PreparedStatement statement) throws Exception {
                if (log.isDebugEnabled()) {
                    log.debug("projectId = [" + projectId + "]; subProjectId = [" + subProjectId + "]; documentIds = ");
                    for (Long documentId : documentIds) {
                        log.debug("===> [" + documentId + "]");
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace("Will execute sql: " + sql);
                }
                int currIndex = 1;
                currIndex = JdbcReviewCycleDAO.this.setDocumentIdsToStatement(statement, currIndex, documentIds);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                currIndex = JdbcReviewCycleDAO.this.setDocumentIdsToStatement(statement, currIndex, documentIds);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                currIndex = JdbcReviewCycleDAO.this.setDocumentIdsToStatement(statement, currIndex, documentIds);
                currIndex = JdbcReviewCycleDAO.this.setDocumentIdsToStatement(statement, currIndex, documentIds);
                currIndex = JdbcReviewCycleDAO.this.setDocumentIdsToStatement(statement, currIndex, documentIds);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)RoleTypeEnum.PROJECT_SURVEILLANT.getValue());
                statement.setString(currIndex++, Action.MONITOR_LATE_REVIEWS.getName());
                currIndex = JdbcReviewCycleDAO.this.setDocumentIdsToStatement(statement, currIndex, documentIds);
                currIndex = JdbcReviewCycleDAO.this.setDocumentIdsToStatement(statement, currIndex, documentIds);
                currIndex = JdbcReviewCycleDAO.this.setDocumentIdsToStatement(statement, currIndex, documentIds);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                currIndex = JdbcReviewCycleDAO.this.setDocumentIdsToStatement(statement, currIndex, documentIds);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                currIndex = JdbcReviewCycleDAO.this.setDocumentIdsToStatement(statement, currIndex, documentIds);
                QueryHelper.checkNumberOfWildcards(sql, currIndex);
                ArrayList<PlanDeliverReleaseJoin> results = new ArrayList<PlanDeliverReleaseJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    PlanDeliverReleaseJoin joinDto = AbstractJdbcReviewCycleDAO.fillPlanDeliverReleaseJoinFromResultSet(rs);
                    currIndex = AbstractJdbcReviewCycleDAO.getNumberOfPlanDeliverReleaseJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    joinDto.setDerivedInfoNumberOfDocumentVersions(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                log.info("Returning " + results.size() + " tuples.");
                return results;
            }
        });
    }

    private String getDocumentVersionWhereClause(int numberOfDocuments) {
        return "document_version.document_id IN (" + QueryHelper.getPlaceHolderSequence(numberOfDocuments) + ") AND (   EXISTS (SELECT 1 FROM (       document_version_task document_version_task_local JOIN  review_task review_task_local                    ON review_task_local.task_id = document_version_task_local.task_id) WHERE document_version_task_local.document_version_id = document_version.id) OR EXISTS (SELECT 1 FROM (document_version_task document_version_task_local JOIN  attached_review_task attached_review_task_local  ON attached_review_task_local.task_id = document_version_task_local.task_id) WHERE document_version_task_local.document_version_id = document_version.id)) ";
    }

    private String getDocumentVersionTaskWhereClause(int numberOfDocuments) {
        return "document_version.document_id IN (" + QueryHelper.getPlaceHolderSequence(numberOfDocuments) + ") AND     (EXISTS (SELECT 1 FROM review_task WHERE task_id = document_version_task.task_id) OR EXISTS (SELECT 1 FROM attached_review_task WHERE task_id = document_version_task.task_id)) ";
    }

    private String getDocumentTaskWhereClause(int numberOfDocuments) {
        return "document_task.document_id in (" + QueryHelper.getPlaceHolderSequence(numberOfDocuments) + ") AND EXISTS (SELECT 1 FROM review_cycle_entry_task WHERE task_id = document_task.task_id) ";
    }

    private String getReleaseUnionSelectClause(PlanDeliverReleaseComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForPlanDeliverReleaseJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    private String getGenerateTaskDeadlinesSelectClause(GenerateTaskDeadlinesJoinComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForGenerateTaskDeadlinesJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    private int setDocumentIdsToStatement(PreparedStatement statement, int currIndex, List<Long> documentIds) throws SQLException {
        for (Long documentId : documentIds) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentId);
        }
        return currIndex;
    }

    public static List<PlanDeliverReleaseJoin> extractForComponent(PlanDeliverReleaseComponent component, List<PlanDeliverReleaseJoin> joins) {
        return JdbcReviewCycleDAO.extractForComponent(component, joins, null);
    }

    public static List<PlanDeliverReleaseJoin> extractForComponent(PlanDeliverReleaseComponent component, List<PlanDeliverReleaseJoin> joins, ResultSummary resultSummary) {
        ArrayList<PlanDeliverReleaseJoin> retJoins = new ArrayList<PlanDeliverReleaseJoin>();
        for (PlanDeliverReleaseJoin join : joins) {
            if (join.getUnionClause().intValue() != component.getValue()) continue;
            retJoins.add(join);
        }
        if (resultSummary != null) {
            resultSummary.recordReceivedJoinComponentTuples(component.toString(), retJoins.size());
        }
        return retJoins;
    }

    public static Map<Long, PlanDeliverReleaseJoin> extractMapByDocumentVersion(PlanDeliverReleaseComponent component, List<PlanDeliverReleaseJoin> joins) {
        HashMap<Long, PlanDeliverReleaseJoin> documentVersionIdToJoin = new HashMap<Long, PlanDeliverReleaseJoin>();
        for (PlanDeliverReleaseJoin join : joins) {
            if (join.getUnionClause().intValue() != component.getValue()) continue;
            documentVersionIdToJoin.put(join.getDocumentVersionId(), join);
        }
        return documentVersionIdToJoin;
    }

    public static List<GenerateTaskDeadlinesJoin> extractForComponent(GenerateTaskDeadlinesJoinComponent component, List<GenerateTaskDeadlinesJoin> joins) {
        ArrayList<GenerateTaskDeadlinesJoin> retJoins = new ArrayList<GenerateTaskDeadlinesJoin>();
        for (GenerateTaskDeadlinesJoin join : joins) {
            if (join.getUnionClause().intValue() != component.getValue()) continue;
            retJoins.add(join);
        }
        return retJoins;
    }

    @Override
    public List<GenerateTaskDeadlinesJoin> getGenerateTaskDeadlinesJoin(final Long documentVersionId, final Long projectId, final Long subProjectId) {
        String sql = "SELECT " + this.getGenerateTaskDeadlinesSelectClause(GenerateTaskDeadlinesJoinComponent.REVIEW_CYCLE, "cell", "cellConnection", "cellInstance", "cellInstanceReleased", "documentVersion", "instance", "instanceReleased", "node", "nodeInstance", "nodeInstanceReleased", "nodePositionReleased") + "FROM ((((((((((( document_version LEFT JOIN object_list_release                                        ON 1=1) LEFT JOIN review_cycle_node_instance node_instance                   ON document_version.active_node_instance_id = node_instance.id) LEFT JOIN review_cycle_cell_instance cell_instance                   ON node_instance.review_cycle_cell_instance_id = cell_instance.id) LEFT JOIN review_cycle_instance instance                             ON cell_instance.review_cycle_instance_id = instance.id) LEFT JOIN review_cycle_instance_released instance_released           ON instance_released.review_cycle_instance_id = instance.id AND instance_released.object_list_id = object_list_release.id) LEFT JOIN review_cycle_cell_instance_released cell_instance_released ON cell_instance_released.review_cycle_instance_id = instance_released.id) LEFT JOIN review_cycle_node_instance_released node_instance_released ON node_instance_released.review_cycle_cell_instance_id = cell_instance_released.id) LEFT JOIN review_cycle_node_position_released node_position_released ON node_position_released.review_cycle_node_instance_id = node_instance_released.id) LEFT JOIN review_cycle_node node                                     ON node_instance_released.review_cycle_node_id = node.id) LEFT JOIN review_cycle_cell cell                                     ON node.review_cycle_cell_id = cell.id) LEFT JOIN review_cycle_cell_connection cell_connection               ON (     cell_connection.source_cell_id = cell.id OR cell_connection.destination_cell_id = cell.id)) WHERE object_list_release.sub_project_id = ? AND object_list_release.version = (SELECT MAX(version) FROM object_list_release WHERE sub_project_id = ?) ";
        if (documentVersionId != null) {
            sql = sql + "AND document_version.id = ? ";
        }
        sql = sql + "UNION ALL SELECT " + this.getGenerateTaskDeadlinesSelectClause(GenerateTaskDeadlinesJoinComponent.PROJECT_HOLIDAY, "projectHoliday") + "FROM project_holiday WHERE project_holiday.project_id = ? UNION ALL SELECT " + this.getGenerateTaskDeadlinesSelectClause(GenerateTaskDeadlinesJoinComponent.PROJECT_ROLE, "projectParticipation") + "FROM ((((( project_participation JOIN cdes_role                                  ON project_participation.role_id = cdes_role.id) JOIN role_type                                  ON cdes_role.type_id = role_type.id) JOIN role_action_rule                           ON role_action_rule.cdes_role_id = cdes_role.id) JOIN action_rule                                ON role_action_rule.action_rule_id = action_rule.id) JOIN action                                     ON action_rule.action_id = action.id) WHERE project_participation.project_id = ? UNION ALL SELECT " + this.getGenerateTaskDeadlinesSelectClause(GenerateTaskDeadlinesJoinComponent.RESULT_OPTION, "resultOption") + "FROM review_cycle_result_option result_option ";
        if (log.isTraceEnabled()) {
            log.trace("Will execute sql: " + sql);
        }
        final String sql2 = sql;
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<GenerateTaskDeadlinesJoin>>(){

            public List<GenerateTaskDeadlinesJoin> perform(PreparedStatement statement) throws Exception {
                if (log.isDebugEnabled()) {
                    log.debug("projectId = [" + projectId + "]; subProjectId = [" + subProjectId + "]; documentVersionId = [" + documentVersionId + "]");
                }
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                if (documentVersionId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                }
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                QueryHelper.checkNumberOfWildcards(sql2, currIndex);
                ArrayList<GenerateTaskDeadlinesJoin> results = new ArrayList<GenerateTaskDeadlinesJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    GenerateTaskDeadlinesJoin joinDto = AbstractJdbcReviewCycleDAO.fillGenerateTaskDeadlinesJoinFromResultSet(rs);
                    currIndex = AbstractJdbcReviewCycleDAO.getNumberOfGenerateTaskDeadlinesJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                log.info("Returning " + results.size() + " tuples.");
                return results;
            }
        });
    }

    @Override
    public List<ReviewCycleRealmChainJoin> getReviewCycleRealmChainJoinsByPersonViaInstanceReleased(final Long personId) {
        String sql = "SELECT " + JdbcReviewCycleDAO.getReviewCycleRealmChainJoinSelectClause() + "FROM (((((((((((((((((( organisation_person JOIN project_participant    ON project_participant.organisation_person_id = organisation_person.id) JOIN project_participation  ON project_participant.participation_id = project_participation.id) JOIN review_cycle_node_position_released ON review_cycle_node_position_released.project_participation_id = project_participation.id) JOIN review_cycle_node_instance_released ON review_cycle_node_position_released.review_cycle_node_instance_id = review_cycle_node_instance_released.id) JOIN review_cycle_node      ON review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id) JOIN review_cycle_cell_instance_released ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id) JOIN review_cycle_cell      ON review_cycle_cell_instance_released.review_cycle_cell_id = review_cycle_cell.id) JOIN review_cycle_instance_released ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id) JOIN review_cycle           ON review_cycle_instance_released.review_cycle_id = review_cycle.id) JOIN object_planner_release ON object_planner_release.review_cycle_instance_id = review_cycle_instance_released.id) JOIN object_release         ON object_planner_release.object_id = object_release.id) JOIN object_list_release    ON object_release.object_list_release_id = object_list_release.id) JOIN object_list            ON object_list_release.object_list_id = object_list.id) JOIN sub_project            ON object_list.sub_project_id = sub_project.id) JOIN project                ON sub_project.project_id = project.id) JOIN network                ON project.network_id = network.id) LEFT JOIN network_review_cycle   ON network_review_cycle.review_cycle_id = review_cycle.id) LEFT JOIN realm                  ON review_cycle_node_position_released.realm_id = realm.id) WHERE (project_participant.inactive_flag IS NULL OR project_participant.inactive_flag = 0) AND object_list_release.version = object_list.version - 1 AND organisation_person.person_id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ReviewCycleRealmChainJoin>>(){

            public List<ReviewCycleRealmChainJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ReviewCycleRealmChainJoin> ret = new ArrayList<ReviewCycleRealmChainJoin>();
                while (rs.next()) {
                    ReviewCycleRealmChainJoin reviewCycleSelectJoin = JdbcReviewCycleDAO.fillReviewCycleRealmChainJoinFromResultSet(rs);
                    ret.add(reviewCycleSelectJoin);
                }
                return ret;
            }
        });
    }

    @Override
    public List<ReviewCycleSelectJoin> getReviewCycleSelectJoin(final Long networkId) {
        String sql = "SELECT " + JdbcReviewCycleDAO.getReviewCycleSelectJoinSelectClause() + "FROM (((      network_review_cycle LEFT JOIN review_cycle         ON network_review_cycle.review_cycle_id = review_cycle.id) LEFT JOIN review_cycle_cell    ON review_cycle_cell.review_cycle_id = review_cycle.id) LEFT JOIN review_cycle_node    ON review_cycle_node.review_cycle_cell_id = review_cycle_cell.id) WHERE 1=1 ";
        if (networkId != null) {
            sql = sql + "AND network_review_cycle.network_id = ? ";
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ReviewCycleSelectJoin>>(){

            public List<ReviewCycleSelectJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (networkId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<ReviewCycleSelectJoin> ret = new ArrayList<ReviewCycleSelectJoin>();
                while (rs.next()) {
                    ReviewCycleSelectJoin reviewCycleSelectJoin = JdbcReviewCycleDAO.fillReviewCycleSelectJoinFromResultSet(rs);
                    ret.add(reviewCycleSelectJoin);
                }
                return ret;
            }
        });
    }

    @Override
    public List<ReviewCycleTreeJoin> getAllReviewCycleTreeJoins() {
        String sql = "SELECT " + JdbcReviewCycleDAO.getReviewCycleTreeJoinSelectClause() + "FROM review_cycle\nLEFT JOIN review_cycle_cell ON review_cycle_cell.review_cycle_id = review_cycle.id\nLEFT JOIN review_cycle_node ON (review_cycle_node.review_cycle_cell_id = review_cycle_cell.id) LEFT JOIN review_cycle_position_type\nON review_cycle_node.review_cycle_position_type_id = review_cycle_position_type.id\nLEFT JOIN review_cycle_node end_node ON end_node.id = review_cycle_node.id AND NOT EXISTS (SELECT 1 FROM review_cycle_result_option WHERE review_cycle_result_option.review_cycle_position_type_id = review_cycle_position_type.id)\nLEFT JOIN review_cycle_cell_connection ON review_cycle_cell_connection.destination_cell_id = review_cycle_cell.id\n";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ReviewCycleTreeJoin>>(){

            public List<ReviewCycleTreeJoin> perform(PreparedStatement statement) throws Exception {
                ResultSet rs = statement.executeQuery();
                ArrayList<ReviewCycleTreeJoin> ret = new ArrayList<ReviewCycleTreeJoin>();
                while (rs.next()) {
                    ReviewCycleTreeJoin reviewCycleTreeJoin = JdbcReviewCycleDAO.fillReviewCycleTreeJoinFromResultSet(rs);
                    ret.add(reviewCycleTreeJoin);
                }
                return ret;
            }
        });
    }

    @Override
    public ReviewCycle getByObjectPlanner(Long objectPlannerId) {
        String sql = "SELECT " + JdbcReviewCycleDAO.getSelectClauseForDto() + "FROM object_planner JOIN review_cycle_instance ON object_planner.review_cycle_instance_id = review_cycle_instance.id JOIN review_cycle          ON review_cycle_instance.review_cycle_id = review_cycle.id WHERE object_planner.id = ? ";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerId);
        });
    }
}

