/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.sec;

import at.cdes.api.joinDto.CertificateOrgPersonJoin;
import at.cdes.api.sec.UserPolicyStatus;
import at.cdes.api.sec.UserPolicyStatusChecker;
import at.cdes.impl.dao.CertificateRequestDAO;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPolicyStatusCheckerImpl
implements UserPolicyStatusChecker {
    private static final Logger log = LoggerFactory.getLogger(UserPolicyStatusCheckerImpl.class);
    private Instant userPolicyDeadline;
    private Long userPolicyDeadlineInterval;
    private Integer userPolicyVersion;
    private CertificateRequestDAO certificateRequestDAO;

    public void setUserPolicyDeadline(String userPolicyDeadline) {
        if (userPolicyDeadline != null && userPolicyDeadline.length() > 0) {
            this.userPolicyDeadline = LocalDate.parse(userPolicyDeadline, DateTimeFormatter.ofPattern("dd.MM.yyyy")).plusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant();
        }
    }

    public void setUserPolicyDeadlineInterval(Long userPolicyDeadlineInterval) {
        this.userPolicyDeadlineInterval = userPolicyDeadlineInterval;
    }

    public void setUserPolicyVersion(Integer userPolicyVersion) {
        this.userPolicyVersion = userPolicyVersion;
    }

    public void setCertificateRequestDAO(CertificateRequestDAO certificateRequestDAO) {
        this.certificateRequestDAO = certificateRequestDAO;
    }

    public UserPolicyStatus checkStatus(Long personId) {
        if (this.userPolicyDeadline == null) {
            return UserPolicyStatus.UP_TO_DATE;
        }
        boolean outdated = false;
        List<CertificateOrgPersonJoin> signedUserPolicyVersions = this.certificateRequestDAO.getSignedUserPolicyVersionsForPerson(personId);
        for (CertificateOrgPersonJoin signedUserPolicyVersion : signedUserPolicyVersions) {
            Integer mostRecentSignedVersion = signedUserPolicyVersion.getCertificateRequestRequestPdfUploadVersion();
            outdated |= mostRecentSignedVersion == null || mostRecentSignedVersion < this.userPolicyVersion;
        }
        Instant shownDeadline = ChronoUnit.DAYS.addTo(this.userPolicyDeadline, -this.userPolicyDeadlineInterval.longValue());
        if (outdated && Instant.now().compareTo(shownDeadline) <= 0) {
            return UserPolicyStatus.WARN;
        }
        return outdated && Instant.now().compareTo(this.userPolicyDeadline) > 0 ? UserPolicyStatus.EXPIRED : UserPolicyStatus.UP_TO_DATE;
    }
}

