/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.sec.login;

import at.cdes.api.sec.CdesHttpLoginService;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.sec.PasswordStatus;
import at.cdes.api.sec.PasswordStatusChecker;
import at.cdes.api.sec.UserPolicyStatus;
import at.cdes.api.sec.UserPolicyStatusChecker;
import java.security.Principal;
import java.security.acl.Group;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.clazzes.util.http.sec.HttpLoginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdesHttpLoginServiceImpl
implements CdesHttpLoginService {
    private static Logger log = LoggerFactory.getLogger(CdesHttpLoginServiceImpl.class);
    private HttpLoginService delegate;
    private PasswordStatusChecker passwordStatusChecker;
    private UserPolicyStatusChecker userPolicyStatusChecker;

    public void setDelegate(HttpLoginService delegate) {
        this.delegate = delegate;
    }

    public void setPasswordStatusChecker(PasswordStatusChecker passwordStatusChecker) {
        this.passwordStatusChecker = passwordStatusChecker;
    }

    public void setUserPolicyStatusChecker(UserPolicyStatusChecker userPolicyStatusChecker) {
        this.userPolicyStatusChecker = userPolicyStatusChecker;
    }

    public Principal checkLogin(HttpServletRequest request) {
        Principal p = this.delegate.checkLogin(request);
        if (p == null) {
            log.warn("CdesHttpLoginService received null from delegate.checkLogin, will return null.");
            log.warn("... Cookie is [" + request.getHeader("Cookie") + "]");
            return p;
        }
        boolean logOut = false;
        if (p instanceof CdesPrincipal) {
            CdesPrincipal cdesPrincipal = (CdesPrincipal)p;
            if (!cdesPrincipal.isDsgvoChecked()) {
                Long personId = cdesPrincipal.getPersonId();
                if (this.passwordStatusChecker.checkPasswordStatus(personId, null) == PasswordStatus.EXPIRED) {
                    log.warn("Will logout person [" + cdesPrincipal.getPersonId() + "], because PasswordStatusChecker returned EXPIRED.");
                    logOut = true;
                } else if (this.userPolicyStatusChecker.checkStatus(personId) == UserPolicyStatus.EXPIRED) {
                    log.warn("Will logout person [" + cdesPrincipal.getPersonId() + "], because UserPolicyStatusChecker returned EXPIRED.");
                    logOut = true;
                }
                if (!logOut) {
                    cdesPrincipal.setDsgvoChecked(true);
                }
            }
        } else {
            log.warn("CdesHttpLoginService received a non-CdesPrincipal, will logout user and return null");
            logOut = true;
        }
        if (logOut) {
            this.delegate.logout(request);
            return null;
        }
        return p;
    }

    public boolean checkPermission(HttpServletRequest request, String context) {
        CdesPrincipal principal = (CdesPrincipal)this.delegate.checkLogin(request);
        if ("/cdes-web/superUserNecessary".equals(context)) {
            return principal.isSuPrincipal();
        }
        return true;
    }

    public List<? extends Group> checkLoginGroups(HttpServletRequest request) {
        return this.delegate.checkLoginGroups(request);
    }

    public Locale getLocale(HttpServletRequest request) {
        try {
            return this.delegate.getLocale(request);
        }
        catch (Throwable e) {
            return request.getLocale();
        }
    }

    public String getLoginUrl() {
        return this.delegate.getLoginUrl();
    }

    public TimeZone getTimeZone(HttpServletRequest request) {
        try {
            return this.delegate.getTimeZone(request);
        }
        catch (Throwable e) {
            return TimeZone.getDefault();
        }
    }

    public void logout(HttpServletRequest request) {
        this.delegate.logout(request);
    }
}

