/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.service.CdesFileService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdesFileServiceImpl
implements CdesFileService {
    private static final Logger log = LoggerFactory.getLogger(CdesFileServiceImpl.class);
    private String planningNotificationRepository;
    private Long requestMaximumMB;
    private String requestRepository;

    public void setPlanningNotificationRepository(String planningNotificationRepository) {
        this.planningNotificationRepository = planningNotificationRepository;
    }

    public void setRequestMaximumMB(Long requestMaximumMB) {
        this.requestMaximumMB = requestMaximumMB;
    }

    public void setRequestRepository(String requestRepository) {
        this.requestRepository = requestRepository;
    }

    public File getPlanningNotificationFile(String path) throws IOException {
        return this.getRepositoryFile(path, this.planningNotificationRepository, null);
    }

    private File getRepositoryFile(String path, String repositoryPath, String backupRepositoryPath) throws IOException {
        File candidate = new File(repositoryPath, path = path.replace("\\", File.separator));
        if (candidate.exists()) {
            return candidate;
        }
        candidate = backupRepositoryPath == null ? null : new File(backupRepositoryPath, path);
        if (candidate != null && candidate.exists()) {
            return candidate;
        }
        throw new FileNotFoundException("File with path [" + path + "] was found neither in repository [" + repositoryPath + "] nor in backup repository [" + backupRepositoryPath + "]");
    }

    public void saveRequestFile(Long certificateRequestId, InputStream inputStream, String fileName) throws IOException {
        boolean result;
        File repositoryDir = new File(this.requestRepository);
        if (!repositoryDir.exists() && !(result = repositoryDir.mkdir())) {
            throw new RuntimeException("Repository directory [" + repositoryDir.getAbsolutePath() + "] could not be created, maybe due to missing file system privileges.");
        }
        File directory = this.getFileInstance(this.requestRepository, null, certificateRequestId.toString());
        if (directory.exists()) {
            for (File f : directory.listFiles()) {
                f.delete();
            }
            directory.delete();
        }
        File file = this.getFileInstance(this.requestRepository, fileName, certificateRequestId.toString());
        this.saveFileInternal(file, inputStream, this.requestMaximumMB);
    }

    private File getFileInstance(String basePath, String fileName, String ... directories) {
        File currFile = new File(basePath);
        for (String directory : directories) {
            boolean result;
            String path = currFile.getAbsolutePath() + File.separator + directory;
            if ((currFile = new File(path)).exists() || (result = currFile.mkdir())) continue;
            throw new RuntimeException("Directory [" + currFile.getAbsolutePath() + "] could not be created, maybe due to missing file system privileges.");
        }
        if (fileName != null) {
            String filePath = currFile.getAbsolutePath() + File.separator + fileName;
            return new File(filePath);
        }
        return currFile;
    }

    private void saveFileInternal(File file, InputStream is, Long maximumMB) throws IOException {
        try (FileOutputStream os = null;){
            int bytes_read;
            long total_written = 0L;
            os = new FileOutputStream(file);
            int bufSize = 4096;
            byte[] buffer = new byte[bufSize];
            long log_bareer = 0xA00000L;
            long watermark = maximumMB * 1024L * 1024L;
            while ((bytes_read = is.read(buffer)) > 0) {
                os.write(buffer, 0, bytes_read);
                if (log.isTraceEnabled() && (total_written += (long)bytes_read) >= log_bareer) {
                    log.trace("Saved [{}] bytes of file [{}]", (Object)total_written, (Object)file);
                    log_bareer += 0xA00000L;
                }
                if (total_written <= watermark) continue;
                throw new IOException("The size [" + total_written + "] of file [" + file + "] exceeds the configured maximum size of [" + maximumMB + "MB].");
            }
            if (log.isTraceEnabled()) {
                log.trace("Saved [{}] bytes of file [{}]", (Object)total_written, (Object)file);
            }
        }
    }
}

