/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.document;

import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentNumberPart;
import at.cdes.api.dto.DocumentType;
import at.cdes.api.dto.Object;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.ObjectRelease;
import at.cdes.api.dto.ObjectType;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.SubProject;
import at.cdes.api.dto.SubProjectType;
import at.cdes.api.joinDto.DocumentNumberGenJoin;
import java.util.IllegalFormatConversionException;
import java.util.List;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentNumberCalculator {
    private static final Logger log = LoggerFactory.getLogger(DocumentNumberCalculator.class);

    public static String getNumber(List<DocumentNumberPart> documentNumberParts, DocumentNumberGenJoin genJoin, boolean includeLastSeparator) {
        Document document = genJoin.getDocument();
        DocumentType documentType = genJoin.getDocumentType();
        DocumentType documentTypeGroup = genJoin.getDocumentTypeGroup();
        Object object = genJoin.getObject();
        ObjectType objectType = genJoin.getObjectType();
        Project project = genJoin.getProject();
        SubProject subProject = genJoin.getSubProject();
        SubProjectType subProjectType = genJoin.getSubProjectType();
        ObjectPlannerRelease objectPlannerRelease = genJoin.getObjectPlannerRelease();
        ObjectRelease objectRelease = genJoin.getObjectRelease();
        ObjectType objectTypeRelease = genJoin.getObjectTypeRelease();
        ProjectParticipation planner = genJoin.getProjectParticipation();
        return DocumentNumberCalculator.getNumber(documentNumberParts, document, documentType, documentTypeGroup, object, objectType, project, subProject, subProjectType, objectPlannerRelease, objectRelease, objectTypeRelease, planner, includeLastSeparator);
    }

    public static String getNumber(List<DocumentNumberPart> documentNumberParts, Document document, DocumentType documentType, DocumentType documentTypeGroup, Object object, ObjectType objectType, Project project, SubProject subProject, SubProjectType subProjectType, ObjectPlannerRelease objectPlannerRelease, ObjectRelease objectRelease, ObjectType objectReleaseType, ProjectParticipation planner, boolean includeLastSeparator) {
        String result = "";
        DocumentWrapper documentWrapper = new DocumentWrapper(document, documentType, documentTypeGroup, object, objectType, project, subProject, subProjectType);
        ObjectPlannerReleaseWrapper objectPlannerReleaseWrapper = new ObjectPlannerReleaseWrapper(objectPlannerRelease, objectRelease, objectReleaseType, planner);
        OgnlContext ctxt = new OgnlContext();
        ctxt.put("document", documentWrapper);
        ctxt.put("relObjectPlanner", objectPlannerReleaseWrapper);
        for (int n = 0; n < documentNumberParts.size(); ++n) {
            java.lang.Object expression;
            DocumentNumberPart part = documentNumberParts.get(n);
            if (part.getOgnlRule() == null) continue;
            try {
                expression = Ognl.parseExpression(part.getOgnlRule());
            }
            catch (OgnlException e) {
                throw new RuntimeException("Parse Exception", e);
            }
            try {
                java.lang.Object res = Ognl.getValue(expression, (Map)ctxt, (java.lang.Object)ctxt);
                result = result + DocumentNumberCalculator.format(part.getFormat(), res);
                if (n >= documentNumberParts.size() - 1 && !includeLastSeparator) continue;
                result = result + part.getSeperator();
                continue;
            }
            catch (OgnlException e) {
                log.error("calc error ", (Throwable)e);
                throw new RuntimeException("Calulation Exception", e);
            }
        }
        return result;
    }

    private static String format(String format, java.lang.Object value) {
        if (value == null) {
            return "";
        }
        if (format == null || format.length() == 0) {
            return String.valueOf(value);
        }
        try {
            return String.format(format, value);
        }
        catch (IllegalFormatConversionException e) {
            log.error("IllegalFormatConversion error ", (Throwable)e);
            return String.valueOf(value);
        }
    }

    private static class ObjectReleaseWrapper {
        private ObjectRelease objectRelease;
        private ObjectType objectType;

        ObjectReleaseWrapper(ObjectRelease objectRelease, ObjectType objectType) {
            this.objectRelease = objectRelease;
            this.objectType = objectType;
        }

        String getCode() {
            return this.objectRelease.getCode() + this.objectType.getCode();
        }

        String getCodeWithoutType() {
            return this.objectRelease.getCode();
        }

        ObjectType getObjectType() {
            return this.objectType;
        }
    }

    private static class ObjectPlannerReleaseWrapper {
        private ObjectPlannerRelease objectPlannerRelease;
        private ObjectReleaseWrapper objectReleaseWrapper;
        private ProjectParticipation planner;

        ObjectPlannerReleaseWrapper(ObjectPlannerRelease objectPlannerRelease, ObjectRelease objectRelease, ObjectType objectType, ProjectParticipation planner) {
            this.objectPlannerRelease = objectPlannerRelease;
            this.objectReleaseWrapper = new ObjectReleaseWrapper(objectRelease, objectType);
            this.planner = planner;
        }

        String getCode() {
            return this.objectPlannerRelease.getCode();
        }

        ObjectReleaseWrapper getObject() {
            return this.objectReleaseWrapper;
        }

        ProjectParticipation getPlanner() {
            return this.planner;
        }
    }

    private static class ObjectWrapper {
        private Object object;
        private ObjectType objectType;

        ObjectWrapper(Object object, ObjectType objectType) {
            this.object = object;
            this.objectType = objectType;
        }

        String getCodeWithoutType() {
            return this.object.getCode();
        }

        ObjectType getObjectType() {
            return this.objectType;
        }
    }

    private static class ObjectPlannerWrapper {
        private ObjectWrapper objectWrapper;

        ObjectPlannerWrapper(Object object, ObjectType objectType) {
            this.objectWrapper = new ObjectWrapper(object, objectType);
        }
    }

    private static class DocumentTypeWrapper {
        private DocumentType documentType;
        private DocumentType documentTypeGroup;

        DocumentTypeWrapper(DocumentType documentType, DocumentType documentTypeGroup) {
            this.documentType = documentType;
            this.documentTypeGroup = documentTypeGroup;
        }

        String getCode() {
            return this.documentType.getCode();
        }

        DocumentType getDocumentTypeGroup() {
            return this.documentTypeGroup;
        }
    }

    private static class SubProjectWrapper {
        private Project project;
        private SubProject subProject;
        private SubProjectType subProjectType;

        SubProjectWrapper(Project project, SubProject subProject, SubProjectType subProjectType) {
            this.project = project;
            this.subProject = subProject;
            this.subProjectType = subProjectType;
        }

        String getCode() {
            return this.subProject.getCode();
        }

        Project getProject() {
            return this.project;
        }

        SubProjectType getSubProjectType() {
            return this.subProjectType;
        }
    }

    private static class DocumentListWrapper {
        private SubProjectWrapper subProjectWrapper;

        DocumentListWrapper(Project project, SubProject subProject, SubProjectType subProjectType) {
            this.subProjectWrapper = new SubProjectWrapper(project, subProject, subProjectType);
        }

        SubProjectWrapper getSubProject() {
            return this.subProjectWrapper;
        }
    }

    private static class DocumentWrapper {
        private Document document;
        private DocumentListWrapper documentListWrapper;
        private DocumentTypeWrapper documentTypeWrapper;
        private ObjectPlannerWrapper objectPlannerWrapper;

        DocumentWrapper(Document document, DocumentType documentType, DocumentType documentTypeGroup, Object object, ObjectType objectType, Project project, SubProject subProject, SubProjectType subProjectType) {
            this.document = document;
            this.documentListWrapper = new DocumentListWrapper(project, subProject, subProjectType);
            this.documentTypeWrapper = new DocumentTypeWrapper(documentType, documentTypeGroup);
            this.objectPlannerWrapper = new ObjectPlannerWrapper(object, objectType);
        }

        DocumentListWrapper getDocumentList() {
            return this.documentListWrapper;
        }

        DocumentTypeWrapper getDocumentType() {
            return this.documentTypeWrapper;
        }

        Integer getNumber() {
            return this.document.getNumber();
        }

        ObjectPlannerWrapper getObjectPlanner() {
            return this.objectPlannerWrapper;
        }
    }
}

