/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.obj;

import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.ObjectList;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.ObjectListReleaseJoin;
import at.cdes.api.obj.dto.ObjectInfo;
import at.cdes.api.obj.dto.ObjectSearchModel;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.api.voc.misc.SortDirection;
import at.cdes.api.voc.misc.SortOrder;
import at.cdes.impl.dao.ObjectListDAO;
import at.cdes.impl.dao.ObjectListReleaseDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.export.obj.ObjectListCols;
import at.cdes.impl.export.obj.ObjectListExportHelper;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.service.ChallengeLoginServiceImpl;
import at.cdes.impl.util.SearchHelper;
import at.cdes.impl.util.odf.OdfHelper;
import at.cdes.impl.util.odf.RowPos;
import java.io.File;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.w3c.dom.Node;

public class ObjectListPdfExporter {
    private ObjectListDAO objectListDAO;
    private String odfStylePrefix;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private ObjectListReleaseDAO objectListReleaseDAO;
    private PersonVariablesDAO personVariablesDAO;
    private SubProjectDAO subProjectDAO;
    private String tempDirName;

    public void setObjectListDAO(ObjectListDAO objectListDAO) {
        this.objectListDAO = objectListDAO;
    }

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setObjectListReleaseDAO(ObjectListReleaseDAO objectListReleaseDAO) {
        this.objectListReleaseDAO = objectListReleaseDAO;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public ScratchFile export(Long loginOrganisationPersonId, ObjectSearchModel searchModel, SortOrder sortOrder, List<ObjectInfo> objectInfos, boolean enableCustomerLogo) throws Exception {
        String personVariablesUserLocale = OdfHelper.getPersonVariablesUserLocaleByPrincipal(this.personVariablesDAO);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        boolean released = searchModel.isReleased();
        Long objectListReleaseId = null;
        ContextJoin contextJoin = null;
        ObjectListReleaseJoin objectListReleaseJoin = null;
        ObjectList objectList = null;
        String versionLabel = null;
        if (released) {
            objectListReleaseId = searchModel.getObjectListReleaseId();
            contextJoin = this.objectListReleaseDAO.getContextJoin(objectListReleaseId);
            objectListReleaseJoin = this.objectListReleaseDAO.getObjectListReleaseJoinById(objectListReleaseId);
            versionLabel = ObjectListExportHelper.getReleasedVersionLabel(objectListReleaseJoin, resourceBundle);
        } else {
            Long subProjectId = searchModel.getSourceSubProjectId();
            contextJoin = this.subProjectDAO.getSubProjectContextJoin(subProjectId);
            List<ObjectList> objectLists = this.objectListDAO.getBySubProject(subProjectId);
            objectList = objectLists.get(0);
            versionLabel = ObjectListExportHelper.getUnreleasedVersionLabel(objectList, resourceBundle);
        }
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyLandscapeTemplate.odt", ChallengeLoginServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        OfficeTextElement officeText = document.getContentRoot();
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        AutomaticStyles stylesAutomaticStyles = context.getStylesAutomaticStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        Styles contentOfficeStyles = context.getContentOfficeStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        OdfHelper.constructHeader(context, document, standardParagraphStyle, null, enableCustomerLogo);
        String projectCode = contextJoin.getProjectCode();
        String projectName = contextJoin.getProjectName();
        String leftFooterLabel = MessageFormat.format(resourceBundle.getString("objectListPdfLeftFooter"), projectCode, projectName);
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", null);
        String dataParagraphStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{dataTextProperties});
        StyleTextPropertiesElement textPropertiesElement = stylesAutomaticStyles.constructTextPropertiesWithFontWeight("bold");
        String leftFooterTextStyle = stylesAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{textPropertiesElement});
        StyleParagraphPropertiesElement paragraphProperties = OdfHelper.constructStandardParagraphProperties(stylesOfficeStyles);
        OdfHelper.constructFooter(context, document, standardParagraphStyle, leftFooterLabel, leftFooterTextStyle, dataParagraphStyle);
        StyleTextPropertiesElement headerTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", "bold");
        StyleParagraphPropertiesElement headerParagraphProperties = contentAutomaticStyles.constructParagraphPropertiesWithTextAlign("right");
        String headerParagraphStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{headerTextProperties, headerParagraphProperties});
        TextHElement textHElement = officeText.newTextHElement(1);
        textHElement.setTextContent(resourceBundle.getString("objectListPdfCaption"));
        officeText.newTextPElement();
        this.constructBasicDataTable(officeText, contextJoin, versionLabel, resourceBundle, contentAutomaticStyles, headerParagraphStyle, dataParagraphStyle);
        officeText.newTextPElement();
        this.constructSearchFieldTable(officeText, searchModel, resourceBundle, contentAutomaticStyles, headerParagraphStyle, dataParagraphStyle);
        officeText.newTextPElement();
        this.appendDataTable(officeText, objectInfos, sortOrder, resourceBundle, (Styles)stylesAutomaticStyles, contentAutomaticStyles, standardParagraphStyle);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_Objektliste_", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        return new ScratchFile(new File(tmpFileName), "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private TableTableElement constructBasicDataTable(OfficeTextElement parentElement, ContextJoin contextJoin, String versionLabel, ResourceBundle resourceBundle, Styles contentAutomaticStyles, String headerTextStyle, String dataTextStyle) {
        TableTableElement tableElement = this.constructEmptyTable((Node)parentElement, contentAutomaticStyles);
        String projectCode = contextJoin.getProjectCode() != null ? contextJoin.getProjectCode() : "";
        String projectName = contextJoin.getProjectName() != null ? contextJoin.getProjectName() : "";
        String projectLabel = projectCode + " " + projectName;
        String stretchName = contextJoin.getProjectStretchName();
        String kmString = ObjectListExportHelper.getProjectKmString(contextJoin);
        String projectComment = contextJoin.getProjectComment() != null ? contextJoin.getProjectComment() : "";
        String subProjectCode = contextJoin.getSubProjectCode() != null ? contextJoin.getSubProjectCode() : "";
        String subProjectNumber = contextJoin.getSubProjectNumber() != null ? contextJoin.getSubProjectNumber().toString() : "";
        String subProjectName = contextJoin.getSubProjectName() != null ? contextJoin.getSubProjectName() : "";
        String subProjectLabel = subProjectCode + subProjectNumber + " " + subProjectName;
        this.constructRow(tableElement, resourceBundle.getString("project"), projectLabel, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("objectHeaderStretchLabel"), stretchName, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("objectHeaderKmLabel"), kmString, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("objectHeaderCommentLabel"), projectComment, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("objectHeaderSubProjectLabel"), subProjectLabel, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("objectListPdfCaption"), versionLabel, headerTextStyle, dataTextStyle);
        return tableElement;
    }

    private TableTableElement constructSearchFieldTable(OfficeTextElement parentElement, ObjectSearchModel searchModel, ResourceBundle resourceBundle, Styles contentAutomaticStyles, String headerTextStyle, String dataTextStyle) {
        String text;
        TableTableElement tableElement = this.constructEmptyTable((Node)parentElement, contentAutomaticStyles);
        String obj = searchModel.getObj();
        String objectPlanner = searchModel.getObjectPlanner();
        String responsible = searchModel.getResponsible();
        String caption = resourceBundle.getString("objectListPdfFilterCaption");
        boolean first = true;
        if (SearchHelper.isStringFilled(obj)) {
            text = resourceBundle.getString("objectListPdfFilterObject") + ": " + obj;
            this.constructRow(tableElement, first ? caption : "", text, headerTextStyle, dataTextStyle);
            first = false;
        }
        if (SearchHelper.isStringFilled(objectPlanner)) {
            text = resourceBundle.getString("objectListPdfFilterObjectPlanner") + ": " + objectPlanner;
            this.constructRow(tableElement, first ? caption : "", text, headerTextStyle, dataTextStyle);
            first = false;
        }
        if (SearchHelper.isStringFilled(responsible)) {
            text = resourceBundle.getString("objectListPdfFilterObjectResponsible") + ": " + responsible;
            this.constructRow(tableElement, first ? caption : "", text, headerTextStyle, dataTextStyle);
            first = false;
        }
        if (first) {
            this.constructRow(tableElement, caption, resourceBundle.getString("objectListPdfFilterNone"), headerTextStyle, dataTextStyle);
        }
        return tableElement;
    }

    private TableTableElement constructEmptyTable(Node parentElement, Styles contentAutomaticStyles) {
        TableTableElement tableElement = TableFactory.constructTableElement((Node)parentElement, null);
        TableFactory.appendColumnWithRelativeSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"225*");
        TableFactory.appendColumnWithRelativeSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"775*");
        return tableElement;
    }

    private TableTableRowElement constructRow(TableTableElement parentElement, String header, String text, String headerTextStyle, String dataTextStyle) {
        if (text == null) {
            text = "";
        }
        TableTableRowElement rowElement = TableFactory.appendRow((TableTableElement)parentElement, null);
        TableFactory.appendTextStyledCell((String)headerTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{header + " "});
        TableFactory.appendTextStyledCell((String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{text});
        return rowElement;
    }

    private void appendDataTable(OfficeTextElement officeText, List<ObjectInfo> objectInfos, SortOrder sortOrder, ResourceBundle resourceBundle, Styles stylesAutomaticStyles, Styles contentAutomaticStyles, String standardParagraphStyle) {
        String headerCellStyle = OdfHelper.getDataTableHeaderCellStyle(contentAutomaticStyles);
        String headerTextStyle = OdfHelper.getDataTableHeaderTextStyle(contentAutomaticStyles, standardParagraphStyle);
        String dataCellStyle = OdfHelper.getDataTableDataCellStyleNoWrap(contentAutomaticStyles);
        String dataTextStyle = OdfHelper.getDataTableDataTextStyle(contentAutomaticStyles, standardParagraphStyle);
        ArrayList<ColumnSortSpec> columnSortSpecs = new ArrayList<ColumnSortSpec>();
        if (sortOrder != null) {
            columnSortSpecs.add(new ColumnSortSpec(sortOrder.getId(), Boolean.valueOf(sortOrder.getDirection() != SortDirection.ASCENDING)));
        }
        List<RowPos<ObjectInfo>> rowPosList = ObjectListExportHelper.constructRowPosList(objectInfos);
        FancyOdfTable<RowPos<ObjectInfo>> odfTable = this.constructTable(resourceBundle, stylesAutomaticStyles, contentAutomaticStyles, standardParagraphStyle, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle);
        odfTable.render((Node)officeText, rowPosList, columnSortSpecs);
    }

    private FancyOdfTable<RowPos<ObjectInfo>> constructTable(ResourceBundle resourceBundle, Styles stylesAutomaticStyles, Styles contentAutomaticStyles, String standardParagraphStyle, String headerCellStyle, String headerTextStyle, String dataCellStyle, String dataTextStyle) {
        Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        List<FancyOdfTableColumn<RowPos<ObjectInfo>>> columns = ObjectListExportHelper.constructDataColumns(resourceBundle, collator, contentAutomaticStyles, standardParagraphStyle, dataCellStyle, dataTextStyle);
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        Map<String, Double> columnIdToRelativeWidth = this.constructRelativeColumnWidths();
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, Double.valueOf(23.9), columnIdToRelativeWidth, columns);
        table.setDataRowStyle(rowStyle);
        return table;
    }

    private Map<String, Double> constructRelativeColumnWidths() {
        HashMap<String, Double> columnIdToRelativeWidth = new HashMap<String, Double>();
        columnIdToRelativeWidth.put(ObjectListCols.CODE.getValue(), 0.15);
        columnIdToRelativeWidth.put(ObjectListCols.KM.getValue(), 0.1);
        columnIdToRelativeWidth.put(ObjectListCols.OBJECT_PLANNER.getValue(), 0.25);
        columnIdToRelativeWidth.put(ObjectListCols.REVIEW_CYCLE_INSTANCE.getValue(), 0.15);
        columnIdToRelativeWidth.put(ObjectListCols.POSITION.getValue(), 0.35);
        return columnIdToRelativeWidth;
    }
}

