/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.reviewCycle;

import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentList;
import at.cdes.api.dto.DocumentType;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleCellResult;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.dto.ReviewCycleNodeResult;
import at.cdes.api.dto.ReviewCycleResultOption;
import at.cdes.api.dto.SubProject;
import at.cdes.api.joinDto.ListenerJoin;
import at.cdes.impl.dao.DocumentDAO;
import at.cdes.impl.dao.DocumentListDAO;
import at.cdes.impl.dao.DocumentTypeDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ProjectParticipantDAO;
import at.cdes.impl.dao.ProjectParticipationDAO;
import at.cdes.impl.dao.ReviewCycleCellDAO;
import at.cdes.impl.dao.ReviewCycleCellResultDAO;
import at.cdes.impl.dao.ReviewCycleNodeResultDAO;
import at.cdes.impl.dao.ReviewCycleResultOptionDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.debug.DebugContext;
import at.cdes.impl.plot.PlotUtils;
import at.cdes.impl.reviewCycle.ReviewCycleHelper;
import ognl.OgnlContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewCycleNodeInstancePlotOrderListener {
    private PlotUtils plotUtils;
    private ProjectParticipantDAO projectParticipantDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private ReviewCycleNodeResultDAO reviewCycleNodeResultDAO;
    private ReviewCycleResultOptionDAO reviewCycleResultOptionDAO;
    private DocumentDAO documentDAO;
    private DocumentTypeDAO documentTypeDAO;
    private DocumentListDAO documentListDAO;
    private SubProjectDAO subProjectDAO;
    private ProjectDAO projectDAO;
    private ReviewCycleCellResultDAO reviewCycleCellResultDAO;
    private ReviewCycleCellDAO reviewCycleCellDAO;
    private static final Logger log = LoggerFactory.getLogger(ReviewCycleNodeInstancePlotOrderListener.class);

    public void setPlotUtils(PlotUtils plotUtils) {
        this.plotUtils = plotUtils;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setReviewCycleNodeResultDAO(ReviewCycleNodeResultDAO reviewCycleNodeResultDAO) {
        this.reviewCycleNodeResultDAO = reviewCycleNodeResultDAO;
    }

    public void setReviewCycleResultOptionDAO(ReviewCycleResultOptionDAO reviewCycleResultOptionDAO) {
        this.reviewCycleResultOptionDAO = reviewCycleResultOptionDAO;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setDocumentTypeDAO(DocumentTypeDAO documentTypeDAO) {
        this.documentTypeDAO = documentTypeDAO;
    }

    public void setDocumentListDAO(DocumentListDAO documentListDAO) {
        this.documentListDAO = documentListDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setReviewCycleCellResultDAO(ReviewCycleCellResultDAO reviewCycleCellResultDAO) {
        this.reviewCycleCellResultDAO = reviewCycleCellResultDAO;
    }

    public void setReviewCycleCellDAO(ReviewCycleCellDAO reviewCycleCellDAO) {
        this.reviewCycleCellDAO = reviewCycleCellDAO;
    }

    public void listen(DebugContext debugContext, ListenerJoin listenerJoin, DocumentVersion documentVersion, ReviewCycleNodeInstanceReleased nodeInstanceReleased, Long objectPlannerReleaseId) {
        debugContext.openDebugNode("PlotOrderListener.listen");
        Long documentVersionId = documentVersion.getId();
        Long plotOrderTemplateId = listenerJoin.getPlotOrderTemplateId();
        String plotOrderTemplateName = listenerJoin.getPlotOrderTemplateName();
        Long referenceId = listenerJoin.getReviewCycleNodeInstancePlottOrderListenerReferenceId();
        Boolean invalidated = listenerJoin.getPlotOrderTemplateInvalidated();
        Long plotterId = listenerJoin.getPlotOrderTemplatePlotterId();
        Long listenerId = listenerJoin.getReviewCycleNodeListenerId();
        if (referenceId == null || invalidated != null && invalidated.booleanValue()) {
            debugContext.closeDebugNode("No referenceId or invalidated");
            log.warn("PlotOrderTemplate [" + plotOrderTemplateId + ":" + plotOrderTemplateName + "] is inconsistent.  The referenceId is null or the template is invalidated.  Will do nothing for ReviewCycleNodeListener [" + listenerId + "].");
            return;
        }
        if (plotterId == null) {
            log.warn("PlotOrderTemplate [" + plotOrderTemplateId + ":" + plotOrderTemplateName + "] is inconsistent.  The plotterId is missing.  Will do nothing for ReviewCycleNodeListener [" + listenerId + "].");
            debugContext.closeDebugNode("No plotterId");
            return;
        }
        String ognlRule = listenerJoin.getReviewCycleNodeListenerOgnlRule();
        if (!this.evaluate(ognlRule, documentVersion)) {
            debugContext.closeDebugNode("evalute(" + ognlRule + ") returned false");
            log.info("PlotOrderTemplate [" + plotOrderTemplateId + ":" + plotOrderTemplateName + "] will be skipped, because of not passed ognlRule for documentVersionId [" + documentVersionId + "].");
            return;
        }
        ProjectParticipant clientParticipant = this.projectParticipantDAO.getObjectPlannerReleasePlannerMainParticipant(objectPlannerReleaseId);
        ProjectParticipation plotterParticipation = (ProjectParticipation)this.projectParticipationDAO.get(plotterId);
        log.info("Will generate PlottOrder [plotOrderTemplateId=" + plotOrderTemplateId + "] [documentVersionId=" + documentVersionId + "]");
        this.plotUtils.generatePlotOrderFromTemplate(debugContext, documentVersionId, plotOrderTemplateId, clientParticipant, plotterParticipation);
        debugContext.closeDebugNode();
    }

    private boolean evaluate(String ognlRule, DocumentVersion documentVersion) {
        Boolean result;
        if (ognlRule == null || ognlRule.trim().length() == 0) {
            return true;
        }
        ReviewCycleNodeResult reviewCycleNodeResult = this.reviewCycleNodeResultDAO.getByActiveNodeAndDocumentVersion(documentVersion.getId());
        ReviewCycleResultOption resultOption = null;
        if (reviewCycleNodeResult.getReviewCycleResultOptionId() != null) {
            resultOption = (ReviewCycleResultOption)this.reviewCycleResultOptionDAO.get(reviewCycleNodeResult.getReviewCycleResultOptionId());
        }
        Document document = (Document)this.documentDAO.get(documentVersion.getDocumentId());
        DocumentType documentType = (DocumentType)this.documentTypeDAO.get(document.getDocumentTypeId());
        DocumentList documentList = (DocumentList)this.documentListDAO.get(document.getDocumentListId());
        SubProject subProject = (SubProject)this.subProjectDAO.get(documentList.getSubProjectId());
        Project project = (Project)this.projectDAO.get(subProject.getProjectId());
        ReviewCycleCellResult reviewCycleCellResult = (ReviewCycleCellResult)this.reviewCycleCellResultDAO.get(reviewCycleNodeResult.getReviewCycleCellResultId());
        ReviewCycleCell nextCell = null;
        if (reviewCycleCellResult.getNextReviewCycleCellId() != null) {
            nextCell = (ReviewCycleCell)this.reviewCycleCellDAO.get(reviewCycleCellResult.getNextReviewCycleCellId());
        }
        ognlRule = ognlRule.replaceAll("result\\.reviewCycleResultOption", "resultOption");
        ognlRule = ognlRule.replaceAll("documentVersion\\.document\\.documentType\\.code", "documentType");
        ognlRule = ognlRule.replaceAll("documentVersion\\.document\\.documentList\\.subProject\\.project", "project");
        ognlRule = ognlRule.replaceAll("documentVersion\\.document\\.documentList\\.subProject", "subProject");
        OgnlContext context = new OgnlContext();
        context.put("result", reviewCycleNodeResult);
        if (reviewCycleNodeResult.getReviewCycleResultOptionId() != null) {
            context.put("resultOption", resultOption);
        }
        context.put("documentVersion", documentVersion);
        context.put("document", document);
        context.put("documentType", documentType);
        context.put("subProject", subProject);
        context.put("project", project);
        if (reviewCycleCellResult.getNextReviewCycleCellId() != null) {
            context.put("nextCell", nextCell);
        }
        if ((result = ReviewCycleHelper.evaluateBooleanOgnlRule(ognlRule, context, true)) == null) {
            return false;
        }
        return result;
    }
}

