/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.organisation;

import at.cdes.api.dto.ExportResult;
import at.cdes.api.organisation.compositeDto.OrganisationInfo;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.export.person.ExportPersonHelper;
import at.cdes.impl.export.planning.CellTextStyles;
import at.cdes.impl.export.planning.PlanningNotificationOrderListExporter;
import at.cdes.impl.service.ChallengeLoginServiceImpl;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class OrganisationListExporter {
    private String odfStylePrefix;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private String tempDirName;
    private PersonVariablesDAO personVariablesDAO;
    private static final Logger log = LoggerFactory.getLogger(OrganisationListExporter.class);

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public ScratchFile export(List<OrganisationInfo> organisationInfos, Map<String, Double> columnToWidth, List<ColumnSortSpec> columnSortSpecs, boolean enableCustomerLogo) throws Exception {
        ResourceBundle resourceBundle = PersonHelper.getResourceBundleByPrincipal(this.personVariablesDAO);
        Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyLandscapeTemplate.odt", ChallengeLoginServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        ClassLoader classLoader = PlanningNotificationOrderListExporter.class.getClassLoader();
        URL logoUrl = classLoader.getResource("export/logos/OeBB_INFRA_black_eps_small.png");
        OfficeTextElement officeText = document.getContentRoot();
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        AutomaticStyles stylesAutomaticStyles = context.getStylesAutomaticStyles();
        OdfHelper.constructHeader(context, document, standardParagraphStyle, null, enableCustomerLogo);
        String leftFooterLabelRaw = resourceBundle.getString("organisationListFooterPrefix");
        OdfHelper.constructFooter(context, document, standardParagraphStyle, leftFooterLabelRaw);
        TextHElement textHElement = officeText.newTextHElement(2);
        textHElement.setTextContent(resourceBundle.getString("organisationListExportCaption"));
        officeText.newTextPElement();
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000")});
        String headerTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "8pt", "bold")});
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000")});
        CellTextStyles normalTextStyles = OdfHelper.constructNormalTextStyles(standardParagraphStyle, contentAutomaticStyles);
        CellTextStyles invalidatedTextStyles = OdfHelper.constructInvalidatedTextStyles(standardParagraphStyle, contentAutomaticStyles);
        StyleTableRowPropertiesElement properties = contentAutomaticStyles.constructTableRowProperties();
        properties.setFoKeepTogetherAttribute("auto");
        String dataRowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{properties});
        FancyOdfTable<OrganisationInfo> odfTable = this.constructOrganisationTable(resourceBundle, collator, contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, normalTextStyles, invalidatedTextStyles, columnToWidth);
        odfTable.setDataRowStyle(dataRowStyle);
        odfTable.render((Node)officeText, organisationInfos, columnSortSpecs);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_Organisationenliste_", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        return new ScratchFile(new File(tmpFileName), "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private FancyOdfTable<OrganisationInfo> constructOrganisationTable(ResourceBundle resourceBundle, Collator collator, Styles contentAutomaticStyles, String headerCellStyle, String headerTextStyle, String dataCellStyle, CellTextStyles normalCellTextStyles, CellTextStyles invalidatedCellTextStyles, Map<String, Double> relativeColumnWidths) {
        ArrayList<FancyOdfTableColumn<OrganisationInfo>> columns = new ArrayList<FancyOdfTableColumn<OrganisationInfo>>();
        ExportPersonHelper.addOrganisationNameColumn(columns, resourceBundle, collator, dataCellStyle, normalCellTextStyles, invalidatedCellTextStyles, false);
        ExportPersonHelper.addOrganisationAddressColumn(columns, resourceBundle, collator, dataCellStyle, normalCellTextStyles, invalidatedCellTextStyles);
        ExportPersonHelper.addOrganisationContactColumn(columns, resourceBundle, collator, dataCellStyle, normalCellTextStyles, invalidatedCellTextStyles);
        ExportPersonHelper.addOrganisationNetworksColumn(columns, resourceBundle, collator, dataCellStyle, normalCellTextStyles, invalidatedCellTextStyles);
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        String dataTextStyle = normalCellTextStyles.getDataTextStyle();
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, Double.valueOf(23.9), relativeColumnWidths, columns);
        table.setDataRowStyle(rowStyle);
        return table;
    }
}

