/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Context;
import at.cdes.impl.dao.ContextDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcContextDAO
extends AbstrIdDAO<Context>
implements ContextDAO {
    public JdbcContextDAO() {
        super(Context.class, "id", "context", new String[]{"id", "code", "name", "description"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcContextDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcContextDAO.getSelectClauseForDto("context", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcContextDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".code" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".description" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + " ";
    }

    protected Context fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        Context context = new Context();
        context.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        context.setCode(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        context.setName(rs.getString(++columnIndex));
        context.setDescription(rs.getString(++columnIndex));
        return context;
    }

    public static Context fillContextFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        Context context = new Context();
        context.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        context.setCode(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        context.setName(rs.getString(columnIndex.incrementAndGet()));
        context.setDescription(rs.getString(columnIndex.incrementAndGet()));
        return context;
    }

    public static Context fillContextFromResultSet(ResultSet rs) throws SQLException {
        return JdbcContextDAO.fillContextFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 4;
    }

    public int update(Context dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<Context> dtos) {
        Iterator<Context> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, Context context) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)context.getId());
        JDBCHelper.setInt((PreparedStatement)statement, (int)2, (Number)context.getCode());
        statement.setString(3, context.getName());
        statement.setString(4, context.getDescription());
    }
}

