/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Network;
import at.cdes.api.dto.NetworkType;
import at.cdes.api.dto.SiteType;
import at.cdes.impl.dao.SiteTypeDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcSiteTypeDAO
extends AbstrIdDAO<SiteType>
implements SiteTypeDAO {
    public JdbcSiteTypeDAO() {
        super(SiteType.class, "id", "site_type", new String[]{"id", "name", "description", "network_id", "network_type_id", "create_trx", "mut_trx", "mut_ts"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcSiteTypeDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_type_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcSiteTypeDAO.getSelectClauseForDto("site_type", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcSiteTypeDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".description" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + "," + entityLocalName + ".network_type_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_type_id") + "," + entityLocalName + ".create_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + "," + entityLocalName + ".mut_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + "," + entityLocalName + ".mut_ts" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    protected SiteType fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        SiteType siteType = new SiteType();
        siteType.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        siteType.setName(rs.getString(++columnIndex));
        siteType.setDescription(rs.getString(++columnIndex));
        siteType.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        siteType.setNetworkTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        siteType.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        siteType.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        siteType.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return siteType;
    }

    public static SiteType fillSiteTypeFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        SiteType siteType = new SiteType();
        siteType.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        siteType.setName(rs.getString(columnIndex.incrementAndGet()));
        siteType.setDescription(rs.getString(columnIndex.incrementAndGet()));
        siteType.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        siteType.setNetworkTypeId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        siteType.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        siteType.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        siteType.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return siteType;
    }

    public static SiteType fillSiteTypeFromResultSet(ResultSet rs) throws SQLException {
        return JdbcSiteTypeDAO.fillSiteTypeFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 8;
    }

    public int update(SiteType dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<SiteType> dtos) {
        Iterator<SiteType> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, SiteType siteType) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)siteType.getId());
        statement.setString(2, siteType.getName());
        statement.setString(3, siteType.getDescription());
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)siteType.getNetworkId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)siteType.getNetworkTypeId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)6, (Number)(siteType.getCreateTrx() != null ? siteType.getCreateTrx() : (Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)7, (Number)((Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)8, (Number)System.currentTimeMillis());
    }

    @Override
    public List<SiteType> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<SiteType> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<SiteType> getByNetworkType(NetworkType networkType) {
        return this.getByNetworkType(networkType.getId());
    }

    @Override
    public List<SiteType> getByNetworkType(final Long networkTypeId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_type_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkTypeId);
            }
        });
    }

    @Override
    public List<SiteType> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<SiteType>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<SiteType> getByNetworkTypes(Collection<Long> networkTypeId) {
        if (networkTypeId.isEmpty()) {
            return new ArrayList<SiteType>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkTypeId.size()];
        int n = 0;
        Iterator<Long> it = networkTypeId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_type_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

