/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.action;

import at.cdes.api.joinDto.NetworkAction;
import at.cdes.api.joinDto.ObjectPlannerAction;
import at.cdes.api.joinDto.ProjectAction;
import at.cdes.api.joinDto.ShortObjectPlannerAction;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.action.ActionDAOHelper;
import at.cdes.impl.dao.jdbc.AbstractJdbcActionDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.clazzes.util.sql.helper.JDBCHelper;

public class GlobalActionHelper {
    public static String getGlobalRuleClauseForNetwork(int numberOfNetworks, int numberOfActionNames) {
        String networkIdWhereClause = ActionDAOHelper.getInClauseWithPlaceHolders("network.id", numberOfNetworks);
        String actionNameWhereClause = ActionDAOHelper.getActionNameWhereClauses(numberOfActionNames);
        return "SELECT DISTINCT " + AbstractJdbcActionDAO.getSelectClauseForDto() + ", dest_action_rule.id, dest_action_rule.destination_context_id, dest_action_rule.check_member, global_role.id, network.id FROM (((((((      network JOIN  action_rule dest_action_rule  ON    (dest_action_rule.network_id = network.id OR dest_action_rule.network_id IS NULL)) JOIN  action                        ON     dest_action_rule.action_id = action.id) JOIN  action_rule                   ON     action_rule.action_id = action.id) CROSS JOIN  organisation_person) JOIN  person                       ON      organisation_person.person_id = person.id) JOIN  cdes_role global_role        ON      person.role_id = global_role.id) JOIN  role_action_rule             ON      role_action_rule.cdes_role_id = global_role.id AND role_action_rule.action_rule_id = action_rule.id) WHERE " + (networkIdWhereClause.length() > 0 ? networkIdWhereClause + " AND " : "") + "(dest_action_rule.destination_context_id = 1 OR dest_action_rule.destination_context_id = 2) AND organisation_person.id = ? AND person.id = ? " + (actionNameWhereClause.length() > 0 ? "AND " + actionNameWhereClause : "");
    }

    public static String getGlobalRuleClauseForProject(Integer numberOfProjects, int numberOfActionNames) {
        String actionNameWhereClause = ActionDAOHelper.getActionNameWhereClauses(numberOfActionNames);
        String sql = "SELECT DISTINCT " + AbstractJdbcActionDAO.getSelectClauseForDto() + ", dest_action_rule.id, dest_action_rule.destination_context_id, dest_action_rule.check_member, global_role.id, network.id, project.id, project.access FROM ((((((((      project JOIN  network                       ON     project.network_id = network.id) JOIN  action_rule dest_action_rule  ON    (dest_action_rule.network_id = network.id OR dest_action_rule.network_id IS NULL)) JOIN  action                        ON     dest_action_rule.action_id = action.id) JOIN  action_rule                   ON     action_rule.action_id = action.id) CROSS JOIN  organisation_person) JOIN  person                       ON      organisation_person.person_id = person.id) JOIN  cdes_role global_role        ON      person.role_id = global_role.id) JOIN  role_action_rule             ON      role_action_rule.cdes_role_id = global_role.id AND role_action_rule.action_rule_id = action_rule.id) WHERE 1=1 ";
        if (numberOfProjects != null) {
            sql = sql + "AND project.id IN ( " + QueryHelper.getPlaceHolderSequence(numberOfProjects) + ") ";
        }
        sql = sql + "AND (      dest_action_rule.destination_context_id = 1 OR dest_action_rule.destination_context_id = 2  OR (     (dest_action_rule.destination_context_id = 3 OR dest_action_rule.destination_context_id = 4) AND (     project.access = 2 OR (     project.access IN (0, 1) AND action.read_only = 1)))) AND organisation_person.id = ? AND person.id = ? ";
        if (actionNameWhereClause.length() > 0) {
            sql = sql + "AND " + actionNameWhereClause;
        }
        return sql;
    }

    public static String getGlobalRuleClauseForAllNetworks(int numberOfActionNames) {
        return GlobalActionHelper.getGlobalRuleNetworkSelectClause() + GlobalActionHelper.getGlobalRuleFromClause() + GlobalActionHelper.getGlobalRuleWhereClauseForAllNetworks(numberOfActionNames);
    }

    public static String getGlobalRuleClauseForObjectPlanner(int numberOfActionNames) {
        return GlobalActionHelper.getGlobalRuleObjectPlannerSelectClause() + GlobalActionHelper.getGlobalRuleFromClause() + GlobalActionHelper.getGlobalRuleWhereClauseGivenSubProject(numberOfActionNames);
    }

    public static String getGlobalRuleClauseForObjectPlannerGivenObjectPlanners(int numberOfObjectPlanners, int numberOfActionNames) {
        return GlobalActionHelper.getGlobalRuleObjectPlannerSelectClause() + GlobalActionHelper.getGlobalRuleFromClause() + GlobalActionHelper.getGlobalRuleWhereClauseGivenObjectPlanners(numberOfObjectPlanners, numberOfActionNames);
    }

    private static String getGlobalRuleObjectPlannerSelectClause() {
        return "SELECT DISTINCT " + AbstractJdbcActionDAO.getShortObjectPlannerActionSelectClause() + ", dest_action_rule.id, dest_action_rule.destination_context_id, dest_action_rule.check_member, global_role.id, network.id, project.id, project.access ";
    }

    private static String getGlobalRuleNetworkSelectClause() {
        return "SELECT DISTINCT " + AbstractJdbcActionDAO.getSelectClauseForDto() + ", dest_action_rule.id, dest_action_rule.destination_context_id, dest_action_rule.check_member, global_role.id, network.id, project.id, project.access ";
    }

    private static String getGlobalRuleFromClause() {
        return "FROM (((((((((((((( object_planner JOIN object                        ON object_planner.object_id = object.id) JOIN object_list                   ON object.object_list_id = object_list.id) LEFT JOIN object_list_release           ON       object_list_release.object_list_id = object_list.id AND object_list_release.version = object_list.version - 1) LEFT JOIN object_release                ON       object_release.object_id = object.id AND object_release.object_list_release_id = object_list_release.id) LEFT JOIN object_planner_release        ON       object_planner_release.object_id = object_release.id AND object_planner_release.object_planner_id = object_planner.id) JOIN sub_project                   ON object_list.sub_project_id = sub_project.id) JOIN project                       ON sub_project.project_id = project.id) JOIN network                       ON project.network_id = network.id) CROSS JOIN action) JOIN action_rule dest_action_rule  ON      dest_action_rule.action_id = action.id AND (   dest_action_rule.network_id = network.id OR dest_action_rule.network_id IS NULL)) CROSS JOIN organisation_person) JOIN person                       ON     organisation_person.person_id = person.id) JOIN cdes_role global_role        ON     person.role_id = global_role.id) JOIN (action_rule JOIN role_action_rule ON role_action_rule.action_rule_id = action_rule.id) ON     action_rule.action_id = action.id AND role_action_rule.cdes_role_id = global_role.id) ";
    }

    private static String getGlobalRuleCoreWhereClause() {
        return "WHERE dest_action_rule.destination_context_id >= 1 AND dest_action_rule.destination_context_id <= 4 AND organisation_person.id = ? AND person.id = ? ";
    }

    private static String getGlobalRuleWhereClauseForAllNetworks(int numberOfActionNames) {
        String actionNameWhereClause = ActionDAOHelper.getActionNameWhereClauses(numberOfActionNames);
        return GlobalActionHelper.getGlobalRuleCoreWhereClause() + (actionNameWhereClause.length() > 0 ? "AND " + actionNameWhereClause : "AND 1=0 ");
    }

    private static String getGlobalRuleWhereClauseGivenSubProject(int numberOfActionNames) {
        String actionNameWhereClause = ActionDAOHelper.getActionNameWhereClauses(numberOfActionNames);
        return GlobalActionHelper.getGlobalRuleCoreWhereClause() + "AND sub_project.id = ? " + (actionNameWhereClause.length() > 0 ? "AND " + actionNameWhereClause : "");
    }

    private static String getGlobalRuleWhereClauseGivenObjectPlanners(int numberOfObjectPlanners, int numberOfActionNames) {
        String objectPlannerWhereClause = ActionDAOHelper.getInClauseWithPlaceHolders("object_planner.id", numberOfObjectPlanners);
        String actionNameWhereClause = ActionDAOHelper.getActionNameWhereClauses(numberOfActionNames);
        return GlobalActionHelper.getGlobalRuleCoreWhereClause() + (objectPlannerWhereClause.length() > 0 ? "AND " + objectPlannerWhereClause : "AND 1=0 ") + (actionNameWhereClause.length() > 0 ? "AND " + actionNameWhereClause : "");
    }

    private String getSelectClause() {
        return AbstractJdbcActionDAO.getShortObjectPlannerActionSelectClause() + ", project.id, network.id, global_rule.id ";
    }

    public static int populateGlobalNetworkRuleClause(PreparedStatement statement, int currIndex, Long organisationPersonId, List<Long> networkIds, Action ... actionNames) throws SQLException {
        for (Long networkId : networkIds) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
        }
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ActionDAOHelper.getPersonIdFromPrincipal());
        for (Action actionName : actionNames) {
            statement.setString(currIndex++, actionName.getName());
        }
        return currIndex;
    }

    public static int populateGlobalRuleClauseForAllNetworks(PreparedStatement statement, int currIndex, Long organisationPersonId, Action ... actionNames) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ActionDAOHelper.getPersonIdFromPrincipal());
        for (Action actionName : actionNames) {
            statement.setString(currIndex++, actionName.getName());
        }
        return currIndex;
    }

    public static int populateGlobalProjectRuleClause(PreparedStatement statement, int currIndex, Long organisationPersonId, Collection<Long> projectIds, Action ... actionNames) throws SQLException {
        if (projectIds != null) {
            for (Long projectId : projectIds) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
            }
        }
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ActionDAOHelper.getPersonIdFromPrincipal());
        for (Action actionName : actionNames) {
            statement.setString(currIndex++, actionName.getName());
        }
        return currIndex;
    }

    public static int populateGlobalObjectPlannerRuleClause(PreparedStatement statement, int currIndex, Long organisationPersonId, Long subProjectId, Action ... actionNames) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ActionDAOHelper.getPersonIdFromPrincipal());
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        for (Action actionName : actionNames) {
            statement.setString(currIndex++, actionName.getName());
        }
        return currIndex;
    }

    public static int populateGlobalObjectPlannerRuleClause(PreparedStatement statement, int currIndex, Long organisationPersonId, Collection<Long> objectPlannerIds, Action ... actionNames) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)ActionDAOHelper.getPersonIdFromPrincipal());
        for (Long objectPlannerId : objectPlannerIds) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerId);
        }
        for (Action actionName : actionNames) {
            statement.setString(currIndex++, actionName.getName());
        }
        return currIndex;
    }

    public static NetworkAction fillNetworkActionFromResultSet(ResultSet resultSet) throws SQLException {
        NetworkAction networkAction = new NetworkAction();
        networkAction.setActionId(JDBCHelper.getLong((ResultSet)resultSet, (int)1));
        networkAction.setActionName(resultSet.getString(2));
        networkAction.setActionDescription(resultSet.getString(3));
        networkAction.setActionReadOnly(JDBCHelper.getBoolean((ResultSet)resultSet, (int)4));
        networkAction.setDestActionRuleId(JDBCHelper.getLong((ResultSet)resultSet, (int)5));
        networkAction.setDestActionRuleDestinationContextId(JDBCHelper.getLong((ResultSet)resultSet, (int)6));
        networkAction.setDestActionRuleCheckMember(JDBCHelper.getBoolean((ResultSet)resultSet, (int)7));
        networkAction.setGlobalRoleId(JDBCHelper.getLong((ResultSet)resultSet, (int)8));
        networkAction.setNetworkId(JDBCHelper.getLong((ResultSet)resultSet, (int)9));
        return networkAction;
    }

    public static ProjectAction fillProjectActionFromResultSet(ResultSet resultSet) throws SQLException {
        ProjectAction projectAction = new ProjectAction();
        projectAction.setActionId(JDBCHelper.getLong((ResultSet)resultSet, (int)1));
        projectAction.setActionName(resultSet.getString(2));
        projectAction.setActionDescription(resultSet.getString(3));
        projectAction.setActionReadOnly(JDBCHelper.getBoolean((ResultSet)resultSet, (int)4));
        projectAction.setDestActionRuleId(JDBCHelper.getLong((ResultSet)resultSet, (int)5));
        projectAction.setDestActionRuleDestinationContextId(JDBCHelper.getLong((ResultSet)resultSet, (int)6));
        projectAction.setDestActionRuleCheckMember(JDBCHelper.getBoolean((ResultSet)resultSet, (int)7));
        projectAction.setGlobalRoleId(JDBCHelper.getLong((ResultSet)resultSet, (int)8));
        projectAction.setNetworkId(JDBCHelper.getLong((ResultSet)resultSet, (int)9));
        projectAction.setProjectId(JDBCHelper.getLong((ResultSet)resultSet, (int)10));
        projectAction.setProjectAccess(JDBCHelper.getInt((ResultSet)resultSet, (int)11));
        return projectAction;
    }

    public static ObjectPlannerAction fillObjectPlannerActionFromResultSet(ResultSet resultSet) throws SQLException {
        ShortObjectPlannerAction shortObjectPlannerAction = AbstractJdbcActionDAO.fillShortObjectPlannerActionFromResultSet(resultSet);
        ObjectPlannerAction objectPlannerAction = new ObjectPlannerAction();
        objectPlannerAction.setAction(shortObjectPlannerAction.getAction());
        objectPlannerAction.setObjectPlannerId(shortObjectPlannerAction.getObjectPlannerId());
        objectPlannerAction.setDestActionRuleId(JDBCHelper.getLong((ResultSet)resultSet, (int)6));
        objectPlannerAction.setDestActionRuleDestinationContextId(JDBCHelper.getLong((ResultSet)resultSet, (int)7));
        objectPlannerAction.setDestActionRuleCheckMember(JDBCHelper.getBoolean((ResultSet)resultSet, (int)8));
        objectPlannerAction.setGlobalRoleId(JDBCHelper.getLong((ResultSet)resultSet, (int)9));
        objectPlannerAction.setNetworkId(JDBCHelper.getLong((ResultSet)resultSet, (int)10));
        objectPlannerAction.setProjectId(JDBCHelper.getLong((ResultSet)resultSet, (int)11));
        objectPlannerAction.setProjectAccess(JDBCHelper.getInt((ResultSet)resultSet, (int)12));
        return objectPlannerAction;
    }
}

