/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.PersonSearchModel;
import at.cdes.api.joinDto.PersonJoin;
import at.cdes.api.joinDto.PersonSearchJoin;
import at.cdes.api.voc.ProjectStatus;
import at.cdes.api.voc.person.PersonStatus;
import at.cdes.impl.dao.PersonDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcPersonDAO;
import at.cdes.impl.dao.jdbc.JdbcCertificateDAO;
import at.cdes.impl.dao.unionComponent.PersonSearchComponent;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SearchHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcPersonDAO
extends AbstractJdbcPersonDAO
implements PersonDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcPersonDAO.class);

    @Override
    public List<Certificate> getCertificatesByPerson(final Long personId, boolean includeRetiredOrgPersons) {
        String sql = "SELECT " + JdbcCertificateDAO.getSelectClauseForDto() + "FROM organisation_person , certificate  WHERE organisation_person.person_id = ? ";
        if (!includeRetiredOrgPersons) {
            sql = sql + "AND organisation_person.retired_flag = 0 ";
        }
        sql = sql + "AND certificate.organisation_person_id = organisation_person.id";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Certificate>>(){

            public List<Certificate> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)personId);
                ResultSet rs = statement.executeQuery();
                ArrayList<Certificate> ret = new ArrayList<Certificate>();
                while (rs.next()) {
                    Certificate certificate = JdbcCertificateDAO.fillCertificateFromResultSet(rs);
                    ret.add(certificate);
                }
                return ret;
            }
        });
    }

    public List<PersonJoin> getPersonJoin(final Long personId) {
        String sql = "SELECT " + JdbcPersonDAO.getPersonJoinSelectClause() + "FROM       person LEFT JOIN person_training ON person_training.person_id = person.id WHERE  person.id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PersonJoin>>(){

            public List<PersonJoin> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)personId);
                ResultSet rs = statement.executeQuery();
                ArrayList<PersonJoin> ret = new ArrayList<PersonJoin>();
                while (rs.next()) {
                    PersonJoin personJoin = AbstractJdbcPersonDAO.fillPersonJoinFromResultSet(rs);
                    ret.add(personJoin);
                }
                return ret;
            }
        });
    }

    @Override
    public List<Long> getNetworkIdsViaNetworkOrganisation(final Long personId) {
        String sql = "SELECT network_organisation.network_id FROM (((   person JOIN organisation_person                ON organisation_person.person_id = person.id) JOIN organisation                       ON organisation_person.organisation_id = organisation.id) JOIN network_organisation               ON network_organisation.organisation_id = organisation.id) WHERE person.id = ?";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Long>>(){

            public List<Long> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)personId);
                ResultSet rs = statement.executeQuery();
                ArrayList<Long> ret = new ArrayList<Long>();
                while (rs.next()) {
                    ret.add(JDBCHelper.getLong((ResultSet)rs, (int)1));
                }
                return ret;
            }
        });
    }

    @Override
    public Person getPerson(final String login) {
        String sql = "SELECT " + JdbcPersonDAO.getSelectClauseForDto() + " FROM person WHERE login = ?";
        return (Person)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Person>(){

            public Person perform(PreparedStatement statement) throws Exception {
                statement.setString(1, login);
                ResultSet rs = statement.executeQuery();
                ArrayList<Person> persons = new ArrayList<Person>();
                while (rs.next()) {
                    persons.add(JdbcPersonDAO.this.fillDtoFromResultSet(rs));
                }
                if (persons.size() > 1) {
                    throw new DAOException("Found [" + persons.size() + "] passwords for login [" + login + "].");
                }
                if (persons.size() == 1) {
                    return (Person)persons.get(0);
                }
                return null;
            }
        });
    }

    @Override
    public Person getPersonByChallengeLoginOne(final String challengeLoginOne) {
        String sql = "SELECT " + JdbcPersonDAO.getSelectClauseForDto() + "FROM ((certificate_request JOIN organisation_person        ON certificate_request.created_for = organisation_person.id) JOIN person ON organisation_person.person_id = person.id) WHERE certificate_request.challenge1 = ? ";
        return (Person)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Person>(){

            public Person perform(PreparedStatement statement) throws Exception {
                statement.setString(1, challengeLoginOne);
                ResultSet rs = statement.executeQuery();
                Person person = null;
                while (rs.next()) {
                    if (person == null) {
                        person = JdbcPersonDAO.this.fillDtoFromResultSet(rs);
                        continue;
                    }
                    throw new DAOException("Found multiple persons with a CertificateRequest having challenge1 = [" + challengeLoginOne + "]; expected zero or one.");
                }
                return person;
            }
        });
    }

    @Override
    public Person getPersonByLogin(final String login) {
        String sql = "SELECT " + JdbcPersonDAO.getSelectClauseForDto() + "FROM person WHERE login = ?";
        return (Person)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Person>(){

            public Person perform(PreparedStatement statement) throws Exception {
                statement.setString(1, login);
                ResultSet rs = statement.executeQuery();
                Person person = null;
                while (rs.next()) {
                    if (person == null) {
                        person = JdbcPersonDAO.this.fillDtoFromResultSet(rs);
                        continue;
                    }
                    throw new DAOException("Found multiple persons with login = [" + login + "]; expected zero or one.");
                }
                return person;
            }
        });
    }

    @Override
    public List<Person> getSimilarPersonCandidates(final Long personId) {
        String sql = "SELECT " + JdbcPersonDAO.getSelectClauseForDto() + "FROM person WHERE person.invalidated = 0 ";
        if (personId != null) {
            sql = sql + "AND person.id != ? ";
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Person>>(){

            public List<Person> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (personId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<Person> persons = new ArrayList<Person>();
                while (rs.next()) {
                    persons.add(JdbcPersonDAO.this.fillDtoFromResultSet(rs));
                }
                return persons;
            }
        });
    }

    @Override
    public List<PersonSearchJoin> getPersonSearchJoinByNetwork(final Long networkId, Boolean personsInvalidated) {
        String personInvalidatedClause = personsInvalidated == null ? "" : (personsInvalidated != false ? "AND person.invalidated = 1 " : "AND (person.invalidated = 0 OR person.invalidated IS NULL) ");
        final String sql = "SELECT DISTINCT " + this.getPersonSearchUnionSelectClause(PersonSearchComponent.PERSON, "person") + "FROM (((      person JOIN organisation_person     ON organisation_person.person_id = person.id) JOIN organisation            ON organisation_person.organisation_id = organisation.id) JOIN network_organisation    ON network_organisation.organisation_id = organisation.id) WHERE 1=1 " + (networkId != null ? "AND network_organisation.network_id = ? " : "") + personInvalidatedClause + "UNION ALL SELECT DISTINCT " + this.getPersonSearchUnionSelectClause(PersonSearchComponent.ORGANISATION, "organisation") + "FROM (        organisation JOIN network_organisation    ON network_organisation.organisation_id = organisation.id) WHERE 1=1 " + (networkId != null ? "AND network_organisation.network_id = ? " : "") + "UNION ALL SELECT " + this.getPersonSearchUnionSelectClause(PersonSearchComponent.NETWORK, "network") + "FROM network UNION ALL SELECT " + this.getPersonSearchUnionSelectClause(PersonSearchComponent.PROJECT, "project") + "FROM project WHERE 1=1 " + (networkId != null ? "AND project.network_id = ? " : "") + "AND project.status != ? UNION ALL SELECT DISTINCT " + this.getPersonSearchUnionSelectClause(PersonSearchComponent.ROLE, "cdesRole") + "FROM cdes_role WHERE 1=1 " + (networkId != null ? "AND cdes_role.network_id = ? " : "");
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PersonSearchJoin>>(){

            public List<PersonSearchJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (networkId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
                }
                if (networkId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
                }
                if (networkId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
                }
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue());
                if (networkId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
                }
                QueryHelper.checkNumberOfWildcards(sql, currIndex);
                ArrayList<PersonSearchJoin> results = new ArrayList<PersonSearchJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    PersonSearchJoin joinDto = AbstractJdbcPersonDAO.fillPersonSearchJoinFromResultSet(rs);
                    currIndex = AbstractJdbcPersonDAO.getNumberOfPersonSearchJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    private String getPersonSearchUnionSelectClause(PersonSearchComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForPersonSearchJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    @Override
    public List<PersonJoin> getPersonJoins(final PersonSearchModel searchModel) {
        String sql = "SELECT " + JdbcPersonDAO.getPersonJoinSelectClause() + "FROM (((((((((((( person LEFT JOIN organisation_person   ON organisation_person.person_id = person.id) LEFT JOIN organisation          ON organisation.id = organisation_person.organisation_id) LEFT JOIN countries country     ON organisation.country_id = country.id) LEFT JOIN countries op_country  ON organisation_person.country_id = op_country.id) LEFT JOIN project_participant   ON      project_participant.organisation_person_id = organisation_person.id AND (    project_participant.inactive_flag IS NULL OR project_participant.inactive_flag = 0)) LEFT JOIN project_participation ON project_participant.participation_id = project_participation.id AND (    project_participation.invalidated IS NULL OR project_participation.invalidated = 0)) LEFT JOIN cdes_role             ON project_participation.role_id = cdes_role.id) LEFT JOIN project_participant main_participant ON      main_participant.participation_id = project_participation.id AND main_participant.main_participant_flag = 1) LEFT JOIN organisation_person main_organisation_person ON main_participant.organisation_person_id = main_organisation_person.id ";
        sql = sql + ") ";
        sql = sql + "LEFT JOIN person main_person    ON main_organisation_person.person_id = main_person.id) LEFT JOIN project               ON project_participation.project_id = project.id) LEFT JOIN network               ON project.network_id = network.id) WHERE 1=1 ";
        if (!searchModel.isShowInvalidPersons().booleanValue()) {
            sql = sql + "AND person.invalidated != ? ";
        }
        if (searchModel.getPersonId() != null) {
            sql = sql + "AND person.id = ? ";
        }
        if (SearchHelper.isStringFilled(searchModel.getName())) {
            sql = sql + "AND (    CONCAT(person.givenName, ' ', person.surName) LIKE ? OR CONCAT(person.surName, ' ', person.givenName) LIKE ?) ";
        }
        if (searchModel.getOrganisationId() != null || SearchHelper.isStringFilled(searchModel.getOrganisation())) {
            sql = sql + "AND EXISTS (SELECT 1 FROM ( organisation_person local_organisation_person JOIN organisation local_organisation               ON local_organisation_person.organisation_id = local_organisation.id) WHERE local_organisation_person.person_id = person.id ";
            if (!searchModel.isShowInvalidPersons().booleanValue()) {
                sql = sql + "AND (local_organisation_person.retired_flag IS NULL OR local_organisation_person.retired_flag = 0) ";
            }
            sql = searchModel.getOrganisationId() != null ? sql + "AND local_organisation.id = ?) " : sql + "AND local_organisation.name LIKE ?) ";
        }
        if (searchModel.getNetworkId() != null || SearchHelper.isStringFilled(searchModel.getNetworkName())) {
            sql = sql + "AND EXISTS (SELECT 1 FROM (((( organisation_person local_organisation_person JOIN organisation local_organisation ON local_organisation_person.organisation_id = local_organisation.id) JOIN network_organisation            ON network_organisation.organisation_id = local_organisation.id) JOIN network                         ON network_organisation.network_id = network.id) LEFT JOIN project local_project           ON local_project.network_id = network.id) WHERE local_organisation_person.person_id = person.id ";
            if (!searchModel.isShowInvalidPersons().booleanValue()) {
                sql = sql + "AND (local_organisation_person.retired_flag IS NULL OR local_organisation_person.retired_flag = 0) ";
            }
            sql = searchModel.getNetworkId() != null ? sql + "AND network.id = ? " : sql + "AND network.name LIKE ? ";
            sql = sql + "AND (project.id IS NULL OR project.id = local_project.id)) ";
        }
        if (searchModel.getCdesRoleId() != null || SearchHelper.isStringFilled(searchModel.getRole())) {
            if (searchModel.getProjectId() != null || SearchHelper.isStringFilled(searchModel.getProject())) {
                sql = sql + "AND EXISTS (SELECT 1 FROM (((( organisation_person local_organisation_person JOIN project_participant local_participant         ON local_participant.organisation_person_id = local_organisation_person.id) JOIN project_participation local_participation     ON local_participant.participation_id = local_participation.id) JOIN cdes_role local_role                          ON local_participation.role_id = local_role.id) JOIN project local_project                         ON local_participation.project_id = local_project.id) WHERE local_organisation_person.person_id = person.id ";
                if (!searchModel.isShowInvalidPersons().booleanValue()) {
                    sql = sql + "AND (local_organisation_person.retired_flag IS NULL OR local_organisation_person.retired_flag = 0) ";
                }
                sql = searchModel.getCdesRoleId() != null ? sql + "AND local_role.id = ? " : sql + "AND local_role.name LIKE ? ";
                sql = searchModel.getProjectId() != null ? sql + "AND local_project.id = ?) " : sql + "AND CONCAT(local_project.code, ' ', local_project.name) LIKE ?) ";
            } else {
                sql = sql + "AND EXISTS (SELECT 1 FROM ((( organisation_person local_organisation_person JOIN project_participant local_participant         ON local_participant.organisation_person_id = local_organisation_person.id) JOIN project_participation local_participation     ON local_participant.participation_id = local_participation.id) JOIN cdes_role local_role                          ON local_participation.role_id = local_role.id) WHERE local_organisation_person.person_id = person.id ";
                if (!searchModel.isShowInvalidPersons().booleanValue()) {
                    sql = sql + "AND (local_organisation_person.retired_flag IS NULL OR local_organisation_person.retired_flag = 0) ";
                }
                sql = searchModel.getCdesRoleId() != null ? sql + "AND local_role.id = ?) " : sql + "AND local_role.name LIKE ?) ";
            }
        } else if (searchModel.getProjectId() != null || SearchHelper.isStringFilled(searchModel.getProject())) {
            sql = sql + "AND EXISTS (SELECT 1 FROM ((( organisation_person local_organisation_person JOIN project_participant local_participant         ON local_participant.organisation_person_id = local_organisation_person.id) JOIN project_participation local_participation     ON local_participant.participation_id = local_participation.id) JOIN project local_project                         ON local_participation.project_id = local_project.id) WHERE local_organisation_person.person_id = person.id AND (local_participant.inactive_flag IS NULL OR local_participant.inactive_flag = 0) AND (local_participation.invalidated IS NULL OR local_participation.invalidated = 0) ";
            if (!searchModel.isShowInvalidPersons().booleanValue()) {
                sql = sql + "AND (local_organisation_person.retired_flag IS NULL OR local_organisation_person.retired_flag = 0) ";
            }
            sql = searchModel.getProjectId() != null ? sql + "AND local_project.id = ?) " : sql + "AND CONCAT(local_project.code, ' ', local_project.name) LIKE ?) ";
        }
        sql = sql + "ORDER BY organisation_person.retired_flag desc";
        if (log.isDebugEnabled()) {
            log.info("Will query persons using sql [" + sql + "]");
        }
        final String sql2 = sql;
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PersonJoin>>(){

            public List<PersonJoin> perform(PreparedStatement statement) throws Exception {
                String project;
                int currIndex = 1;
                if (!searchModel.isShowInvalidPersons().booleanValue()) {
                    JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)PersonStatus.INVALID.getValue());
                }
                if (searchModel.getPersonId() != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getPersonId());
                }
                if (SearchHelper.isStringFilled(searchModel.getName())) {
                    String name = SearchHelper.convertForSearch(searchModel.getName());
                    if (log.isDebugEnabled()) {
                        log.debug("... Populating name wildcard with [" + name + "]");
                    }
                    statement.setString(currIndex++, name);
                    statement.setString(currIndex++, name);
                }
                if (searchModel.getOrganisationId() != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getOrganisationId());
                } else if (SearchHelper.isStringFilled(searchModel.getOrganisation())) {
                    String organisation = SearchHelper.convertForSearch(searchModel.getOrganisation());
                    if (log.isDebugEnabled()) {
                        log.debug("... Populating organisation wildcard with [" + organisation + "]");
                    }
                    statement.setString(currIndex++, organisation);
                }
                if (searchModel.getNetworkId() != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getNetworkId());
                } else if (SearchHelper.isStringFilled(searchModel.getNetworkName())) {
                    if (log.isDebugEnabled()) {
                        log.debug("... Populating network wildcard with [" + searchModel.getNetworkName() + "]");
                    }
                    String networkName = SearchHelper.convertForSearch(searchModel.getNetworkName());
                    statement.setString(currIndex++, networkName);
                }
                if (searchModel.getCdesRoleId() != null || SearchHelper.isStringFilled(searchModel.getRole())) {
                    String role;
                    if (searchModel.getProjectId() != null || SearchHelper.isStringFilled(searchModel.getProject())) {
                        if (searchModel.getCdesRoleId() != null) {
                            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getCdesRoleId());
                        } else {
                            role = SearchHelper.convertForSearch(searchModel.getRole());
                            if (log.isDebugEnabled()) {
                                log.debug("... Populating role wildcard with [" + role + "]");
                            }
                            statement.setString(currIndex++, role);
                        }
                        if (searchModel.getProjectId() != null) {
                            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getProjectId());
                        } else {
                            project = SearchHelper.convertForSearch(searchModel.getProject());
                            if (log.isDebugEnabled()) {
                                log.debug("... Populating project wildcard with [" + project + "]");
                            }
                            statement.setString(currIndex++, project);
                        }
                    } else if (searchModel.getCdesRoleId() != null) {
                        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getCdesRoleId());
                    } else {
                        role = SearchHelper.convertForSearch(searchModel.getRole());
                        if (log.isDebugEnabled()) {
                            log.debug("... Populating role wildcard with [" + role + "]");
                        }
                        statement.setString(currIndex++, role);
                    }
                } else if (searchModel.getProjectId() != null || SearchHelper.isStringFilled(searchModel.getProject())) {
                    if (searchModel.getProjectId() != null) {
                        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getProjectId());
                    } else {
                        project = SearchHelper.convertForSearch(searchModel.getProject());
                        if (log.isDebugEnabled()) {
                            log.debug("... Populating project wildcard with [" + project + "]");
                        }
                        statement.setString(currIndex++, project);
                    }
                }
                QueryHelper.checkNumberOfWildcards(sql2, currIndex);
                ArrayList<PersonJoin> results = new ArrayList<PersonJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    PersonJoin joinDto = AbstractJdbcPersonDAO.fillPersonJoinFromResultSet(rs);
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    @Override
    public List<Person> getAllPersonNames() {
        String sql = "SELECT DISTINCT id, givenName, surName FROM person ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Person>>(){

            public List<Person> perform(PreparedStatement statement) throws Exception {
                ResultSet rs = statement.executeQuery();
                ArrayList<Person> ret = new ArrayList<Person>();
                while (rs.next()) {
                    Person person = new Person(true);
                    person.setId(JDBCHelper.getLong((ResultSet)rs, (int)1));
                    person.setGivenName(rs.getString(2));
                    person.setSurName(rs.getString(3));
                    ret.add(person);
                }
                return ret;
            }
        });
    }

    @Override
    public List<Person> getProjectLeaders(Long projectId) {
        String sql = "SELECT " + this.getSelectClauseForDto() + "\nFROM project\nJOIN project_participation ON project_participation.project_id = project.id\n                          AND project_participation.invalidated = 0\nJOIN cdes_role             ON cdes_role.id = project_participation.role_id\n                          AND cdes_role.project_flag = 2\nJOIN project_participant   ON project_participant.participation_id = project_participation.id\n                          AND project_participant.inactive_flag = 0\n                          AND project_participant.main_participant_flag = 1\nJOIN organisation_person   ON organisation_person.id = project_participant.organisation_person_id\nJOIN person                ON person.id = organisation_person.person_id\nWHERE project.id = ?";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
        });
    }

    @Override
    public List<PersonJoin> getByProjectAndRole(final Long projectId, final Integer roleTypeId) {
        String sql = "SELECT " + JdbcPersonDAO.getPersonJoinSelectClause() + "FROM project_participation JOIN project_participant       ON project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 JOIN organisation_person       ON project_participant.organisation_person_id = organisation_person.id JOIN organisation              ON organisation_person.organisation_id = organisation.id JOIN person                    ON organisation_person.person_id = person.id JOIN person main_person        ON person.id = main_person.id JOIN cdes_role                 ON project_participation.role_id = cdes_role.id JOIN role_type                 ON cdes_role.type_id = role_type.id JOIN project                   ON project_participation.project_id = project.id JOIN network                   ON project.network_id = network.id LEFT JOIN countries country         ON organisation.country_id = country.id LEFT JOIN countries op_country      ON organisation_person.country_id = op_country.id WHERE project_participation.invalidated = 0 AND project_participant.inactive_flag = 0 AND organisation_person.retired_flag = 0 ";
        if (projectId != null) {
            sql = sql + "AND project.id = ? ";
        }
        if (roleTypeId != null) {
            sql = sql + "AND role_type.id = ? ";
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PersonJoin>>(){

            public List<PersonJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (projectId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                }
                if (roleTypeId != null) {
                    JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex, (Number)roleTypeId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<PersonJoin> ret = new ArrayList<PersonJoin>();
                while (rs.next()) {
                    PersonJoin personJoin = JdbcPersonDAO.fillPersonJoinFromResultSet(rs);
                    ret.add(personJoin);
                }
                return ret;
            }
        });
    }

    @Override
    public List<PersonJoin> getBySubProjectViaOriginalDocumentOwner(Long subProjectId) {
        String sql = "SELECT DISTINCT " + JdbcPersonDAO.getPersonJoinSelectClause() + "FROM original_document_order JOIN project_participation   ON      original_document_order.document_owner_id = project_participation.id AND project_participation.invalidated = 0 JOIN project_participant     ON      project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag = 0 JOIN organisation_person     ON project_participant.organisation_person_id = organisation_person.id AND organisation_person.retired_flag = 0 JOIN organisation            ON organisation_person.organisation_id = organisation.id JOIN person                  ON organisation_person.person_id = person.id JOIN person main_person      ON person.id = main_person.id JOIN cdes_role               ON project_participation.role_id = cdes_role.id JOIN role_type               ON cdes_role.type_id = role_type.id JOIN project                 ON project_participation.project_id = project.id JOIN network                 ON project.network_id = network.id LEFT JOIN countries country         ON organisation.country_id = country.id LEFT JOIN countries op_country      ON organisation_person.country_id = op_country.id WHERE original_document_order.sub_project_id = ? \n";
        return QueryHelper.getListWithSqlFiller((JdbcDAOSupport)this, sql, AbstractJdbcPersonDAO::fillPersonJoinFromResultSet, filler -> filler.addLong(subProjectId));
    }
}

