/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.document;

import at.cdes.api.document.compositeDto.ReviewProtocolData;
import at.cdes.api.dto.Attachment;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.ReviewCycleResultOption;
import at.cdes.api.guiService.DocumentService;
import at.cdes.api.guiService.UtilService;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.DocumentArchivePathJoin;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.joinDto.ProjectLocalisationJoin;
import at.cdes.api.joinDto.ReviewProtocolBaseJoin;
import at.cdes.api.joinDto.ReviewProtocolVersionJoin;
import at.cdes.api.voc.ArchiveFileFormat;
import at.cdes.api.voc.ArchiveScope;
import at.cdes.api.voc.DocumentVersionStatus;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.DocumentVersionDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.export.CdesExportHelper;
import at.cdes.impl.export.archive.ArchiveHelper;
import at.cdes.impl.export.planning.PlanningReportHelper;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.service.DocumentServiceImpl;
import at.cdes.impl.util.CodeHelper;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.i18n.I18nHelper;
import at.cdes.impl.util.odf.OdfFromHtmlConverter;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.draw.FrameFactory;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnchorTypeAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.draw.DrawAElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeBinaryDataElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.incubator.doc.draw.OdfDrawFrame;
import org.odftoolkit.odfdom.incubator.doc.draw.OdfDrawImage;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class ReviewProtocolPdfExporter {
    private ActionDAO actionDAO;
    private DocumentService documentService;
    private DocumentVersionDAO documentVersionDAO;
    private String odfStylePrefix;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private OrganisationPersonDAO organisationPersonDAO;
    private ProjectDAO projectDAO;
    private String tempDirName;
    private UtilService utilService;
    private static final Logger log = LoggerFactory.getLogger(ReviewProtocolPdfExporter.class);
    private String userLocale;

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public ScratchFile export(Long organisationPersonId, Long documentVersionId, ArchiveScope archiveScope, ArchiveFileFormat archiveFileFormat, boolean enableCustomerLogo) throws Exception {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ContextJoin contextJoin = this.documentVersionDAO.getContextJoin(documentVersionId);
        Long objectPlannerId = contextJoin.getObjectPlannerId();
        Set<Action> allowedActions = this.actionDAO.getObjectPlannerActions(organisationPersonId, objectPlannerId, Action.REVIEW_PROTOCOL, Action.REVIEW_PROTOCOL_OP_CONTEXT);
        if (!allowedActions.contains(Action.REVIEW_PROTOCOL) && !allowedActions.contains(Action.REVIEW_PROTOCOL_OP_CONTEXT)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] has none of the privileges [reviewProtocoll, reviewProtocollOPContext] to view the review protocol for documentVersionId [" + documentVersionId + "] in objectPlanner [" + objectPlannerId + "]");
        }
        Long subProjectId = contextJoin.getSubProjectId();
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        this.userLocale = orgPersonJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(this.userLocale);
        ProjectLocalisationJoin localisationJoin = this.projectDAO.getLocalisationJoinBySubProject(subProjectId);
        List<String> contentLocales = I18nHelper.getContentLocales(localisationJoin);
        ReviewProtocolData reviewProtocolData = this.documentService.getReviewProtocolData(organisationPersonId, documentVersionId);
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyLandscapeTemplate.odt", ReviewProtocolPdfExporter.class, (Locale)ThreadLocalManager.getLoginLocale());
        OfficeTextElement officeText = document.getContentRoot();
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        AutomaticStyles stylesAutomaticStyles = context.getStylesAutomaticStyles();
        ReviewProtocolLocalStyles localStyles = this.constructLocalStyles(context);
        OdfHelper.constructHeader(context, document, localStyles.getStandardParagraphStyle(), null, enableCustomerLogo);
        String projectCode = contextJoin.getProjectCode();
        String projectName = contextJoin.getProjectName();
        String leftFooterLabelRaw = resourceBundle.getString("reviewProtocolPdfLeftFooterLabel");
        String leftFooterLabel = MessageFormat.format(leftFooterLabelRaw, projectCode, projectName);
        OdfHelper.constructFooter(context, document, localStyles.getStandardParagraphStyle(), leftFooterLabel, null, null, resourceBundle);
        OdfHelper.constructCaptionTable(context, officeText, standardParagraphStyle, resourceBundle.getString("reviewProtocolPdfCaption"));
        this.constructObjectHeaderTable(reviewProtocolData, context, localStyles, officeText, resourceBundle);
        String documentVersionCaption = resourceBundle.getString("reviewProtocolDocumentsAndVersionsCaption");
        this.appendContentCaption(officeText, context, localStyles, documentVersionCaption);
        this.appendOwnVersionTable(reviewProtocolData, context, localStyles, officeText, resourceBundle, this.userLocale, contentLocales);
        this.appendOtherDocumentVersionsTable(officeText, context, archiveFileFormat, archiveScope, localStyles, reviewProtocolData, resourceBundle);
        this.appendReferenceTable(officeText, context, archiveFileFormat, localStyles, reviewProtocolData, resourceBundle, this.userLocale, contentLocales);
        this.appendStatusSvgSection(reviewProtocolData, officeText, context, localStyles, resourceBundle);
        this.appendVersionSections(reviewProtocolData, archiveScope, officeText, context, localStyles, resourceBundle, this.userLocale, contentLocales);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_Pruefprotokoll_", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        return new ScratchFile(new File(tmpFileName), "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private ReviewProtocolLocalStyles constructLocalStyles(OdfContext context) {
        Styles officeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        ReviewProtocolLocalStyles localStyles = new ReviewProtocolLocalStyles();
        String standardParagraphStyle = this.constructStandardParagraphStyle(officeStyles);
        localStyles.setStandardParagraphStyle(standardParagraphStyle);
        StyleParagraphPropertiesElement paragraphProperties = officeStyles.constructParagraphPropertiesWithMargin(null, null, "0.7cm", "0.212cm");
        paragraphProperties.setFoKeepWithNextAttribute("always");
        StyleParagraphPropertiesElement superParagraphProperties = officeStyles.constructParagraphPropertiesWithMargin(null, null, "0.7cm", "0.212cm");
        superParagraphProperties.setFoKeepWithNextAttribute("always");
        OdfStylePropertiesBase[] superHeadingProperties = new OdfStylePropertiesBase[]{superParagraphProperties, officeStyles.constructTextPropertiesWithFont("Arial", "Arial", "14pt", "bold", "variable")};
        String superHeadingStyle = officeStyles.getParagraphStyle(superHeadingProperties);
        OdfStylePropertiesBase[] headingProperties = new OdfStylePropertiesBase[]{paragraphProperties, officeStyles.constructTextPropertiesWithFont("Arial", "Arial", "12pt", "bold", "variable")};
        String headingStyle = officeStyles.getParagraphStyle(headingProperties);
        localStyles.setHeadingStyle(headingStyle);
        localStyles.setSuperHeadingStyle(superHeadingStyle);
        OdfStylePropertiesBase[] subHeadingProperties = new OdfStylePropertiesBase[]{officeStyles.constructParagraphPropertiesWithMargin(null, null, "0.7cm", "0.212cm"), officeStyles.constructTextPropertiesWithFont("Arial", "Arial", "10pt", "bold", "variable")};
        String subHeadingStyle = officeStyles.getParagraphStyle(subHeadingProperties);
        localStyles.setSubHeadingStyle(subHeadingStyle);
        StyleTextPropertiesElement boldProperties = contentAutomaticStyles.constructTextProperties();
        boldProperties.setFoFontSizeAttribute("10pt");
        boldProperties.setFoFontWeightAttribute("bold");
        boldProperties.setStyleFontWeightAsianAttribute("bold");
        boldProperties.setStyleFontWeightComplexAttribute("bold");
        String spanBoldTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorAndFont(null, "Arial", "12pt", "bold")});
        localStyles.setSpanBoldTextStyle(spanBoldTextStyle);
        String spanDefaultTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorAndFont(null, "Arial", "12pt", null)});
        localStyles.setSpanDefaultTextStyle(spanDefaultTextStyle);
        StyleTextPropertiesElement nodeBoldProperties = contentAutomaticStyles.constructTextProperties();
        nodeBoldProperties.setFoFontSizeAttribute("10pt");
        nodeBoldProperties.setFoFontWeightAttribute("bold");
        nodeBoldProperties.setStyleFontWeightAsianAttribute("bold");
        nodeBoldProperties.setStyleFontWeightComplexAttribute("bold");
        String nodeBoldTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{nodeBoldProperties});
        localStyles.setNodeBoldTextStyle(nodeBoldTextStyle);
        StyleTableCellPropertiesElement headerCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#666666", "0.079cm", "none");
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{headerCellProperties});
        localStyles.setHeaderCellStyle(headerCellStyle);
        StyleTextPropertiesElement headerTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorAndFont("#ffffff", "Arial", "10pt", "bold");
        headerTextProperties.setFoHyphenateAttribute(Boolean.valueOf(true));
        headerTextProperties.setFoHyphenationRemainCharCountAttribute(Integer.valueOf(2));
        headerTextProperties.setFoHyphenationPushCharCountAttribute(Integer.valueOf(2));
        String headerTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{headerTextProperties});
        localStyles.setHeaderTextStyle(headerTextStyle);
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellProperties();
        dataCellProperties.setFoBackgroundColorAttribute("#e6e6e6");
        dataCellProperties.setFoBorderLeftAttribute("0.5pt solid #ffffff");
        dataCellProperties.setFoBorderRightAttribute("0.5pt solid #ffffff");
        dataCellProperties.setFoBorderTopAttribute("none");
        dataCellProperties.setFoBorderBottomAttribute("0.5pt solid #ffffff");
        dataCellProperties.setFoPaddingAttribute("0.079cm");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties});
        localStyles.setDataCellStyle(dataCellStyle);
        String dataTextStyle = this.constructDataTextStyle(context, standardParagraphStyle, "10pt", null, null, null);
        localStyles.setDataTextStyle(dataTextStyle);
        String dataTextStyleBold = this.constructDataTextStyle(context, standardParagraphStyle, "10pt", "bold", null, null);
        localStyles.setDataTextStyleBold(dataTextStyleBold);
        String dataTextStyleMedium = this.constructDataTextStyle(context, standardParagraphStyle, "9pt", null, null, null);
        localStyles.setDataTextStyleMedium(dataTextStyleMedium);
        String intervalDataTextStyle = this.constructDataTextStyle(context, standardParagraphStyle, "9pt", null, null, "always");
        localStyles.setIntervalDataTextStyle(intervalDataTextStyle);
        String dataTextStyleSmall = this.constructDataTextStyle(context, standardParagraphStyle, "7pt", null, null, null);
        localStyles.setDataTextStyleSmall(dataTextStyleSmall);
        String dataTextStyleComment = this.constructDataTextStyle(context, standardParagraphStyle, "7.5pt", null, null, null);
        localStyles.setDataTextStyleComment(dataTextStyleComment);
        String dataTextStyleRight = this.constructDataTextStyle(context, standardParagraphStyle, "10pt", null, "right", null);
        localStyles.setDataTextStyleRight(dataTextStyleRight);
        String dataTextStyleSmallRight = this.constructDataTextStyle(context, standardParagraphStyle, "7pt", null, "right", null);
        localStyles.setDataTextStyleSmallRight(dataTextStyleSmallRight);
        StyleTableRowPropertiesElement dataRowProperties = contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "auto");
        String dataRowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{dataRowProperties});
        localStyles.setDataRowStyle(dataRowStyle);
        return localStyles;
    }

    private String constructDataTextStyle(OdfContext context, String parentStyle, String fontSize, String fontWeight, String textAlign, String keepWithNext) {
        return this.constructDataTextStyle(context, parentStyle, fontSize, fontWeight, textAlign, null, null, null, keepWithNext);
    }

    private String constructDataTextStyle(OdfContext context, String parentStyle, String fontSize, String fontWeight, String textAlign, String lineThroughStyle, String lineThroughType, String color, String keepWithNext) {
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorAndFont("#000000", "Arial", fontSize, fontWeight);
        dataTextProperties.setFoHyphenateAttribute(Boolean.valueOf(true));
        dataTextProperties.setFoHyphenationRemainCharCountAttribute(Integer.valueOf(2));
        dataTextProperties.setFoHyphenationPushCharCountAttribute(Integer.valueOf(2));
        if (lineThroughStyle != null) {
            dataTextProperties.setStyleTextLineThroughStyleAttribute(lineThroughStyle);
        }
        if (lineThroughType != null) {
            dataTextProperties.setStyleTextLineThroughTypeAttribute(lineThroughType);
        }
        if (color != null) {
            dataTextProperties.setFoColorAttribute(color);
        }
        StyleParagraphPropertiesElement paragraphProperties = contentAutomaticStyles.constructParagraphPropertiesWithTextAlign(textAlign, null);
        if (keepWithNext != null) {
            paragraphProperties.setFoKeepWithNextAttribute(keepWithNext);
        }
        return contentAutomaticStyles.getParagraphStyleWithParent(parentStyle, new OdfStylePropertiesBase[]{dataTextProperties, paragraphProperties});
    }

    public String constructStandardParagraphStyle(Styles context) {
        return context.getParagraphStyle(null, "text", new OdfStylePropertiesBase[]{ReviewProtocolPdfExporter.constructStandardParagraphProperties(context), ReviewProtocolPdfExporter.constructStandardTextProperties(context)});
    }

    public static StyleParagraphPropertiesElement constructStandardParagraphProperties(Styles context) {
        StyleParagraphPropertiesElement paragraphProperties = context.constructParagraphProperties();
        paragraphProperties.setStyleLineHeightAtLeastAttribute("0.423cm");
        paragraphProperties.setFoTextAlignAttribute("start");
        paragraphProperties.setStyleJustifySingleWordAttribute(Boolean.valueOf(false));
        paragraphProperties.setFoOrphansAttribute(Integer.valueOf(2));
        paragraphProperties.setFoWidowsAttribute(Integer.valueOf(2));
        paragraphProperties.setStyleWritingModeAttribute("lr-tb");
        return paragraphProperties;
    }

    public static StyleTextPropertiesElement constructStandardTextProperties(Styles context) {
        StyleTextPropertiesElement textProperties = context.constructTextProperties();
        textProperties.setFoColorAttribute("#00000a");
        textProperties.setStyleUseWindowFontColorAttribute(Boolean.valueOf(true));
        textProperties.setStyleFontNameAttribute("Arial");
        textProperties.setFoFontFamilyAttribute("Arial");
        textProperties.setStyleFontFamilyGenericAttribute("roman");
        textProperties.setStyleFontPitchAttribute("variable");
        textProperties.setFoFontSizeAttribute("10pt");
        textProperties.setFoLanguageAttribute("de");
        textProperties.setFoCountryAttribute("DE");
        textProperties.setFoHyphenateAttribute(Boolean.valueOf(false));
        textProperties.setFoHyphenationRemainCharCountAttribute(Integer.valueOf(2));
        textProperties.setFoHyphenationPushCharCountAttribute(Integer.valueOf(2));
        return textProperties;
    }

    private void constructHeader(OdfContext context, OdfTextDocument document, String standardParagraphStyle) throws Exception {
        Styles styles = context.getStylesOfficeStyles();
        String leftHeaderTextStyle = styles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[0]);
        String headerCellStyle = styles.getTableCellStyle(new OdfStylePropertiesBase[]{styles.constructTableCellPropertiesWithPaddingAndBorders("0.125cm", "none", "0.125cm", "none", "0cm", "none", "0.3cm", "none")});
        OdfOfficeMasterStyles masterStyles = document.getOfficeMasterStyles();
        Iterator masterPages = masterStyles.getMasterPages();
        while (masterPages.hasNext()) {
            Styles contentAutomaticStyles = context.getContentAutomaticStyles();
            StyleMasterPageElement masterPage = (StyleMasterPageElement)masterPages.next();
            StyleHeaderElement headerElement = masterPage.newStyleHeaderElement();
            TableTableElement headerTableElement = headerElement.newTableTableElement();
            TableFactory.appendColumnWithOptimalSize((Styles)styles, (TableTableElement)headerTableElement);
            TableFactory.appendColumnWithOptimalSize((Styles)styles, (TableTableElement)headerTableElement);
            TableTableRowElement headerRowElement = TableFactory.appendRow((TableTableElement)headerTableElement, null);
            TableFactory.appendCell((String)headerCellStyle, (String)leftHeaderTextStyle, (TableTableRowElement)headerRowElement, (String[])new String[]{""});
            TableTableCellElement imageCellElement = headerRowElement.newTableTableCellElement(0.0, "string");
            String imageTextElementStyle = styles.getParagraphStyleWithClass("text", new OdfStylePropertiesBase[]{styles.constructParagraphPropertiesWithMargin(null, null, null, "0.6cm")});
            TextPElement imageTextElement = TextFactory.constructTextNode((Node)imageCellElement, null, (String)imageTextElementStyle);
            OdfDrawFrame drawFrame = (OdfDrawFrame)((OdfFileDom)imageTextElement.getOwnerDocument()).newOdfElement(OdfDrawFrame.class);
            Styles stylesOfficeStyles = context.getStylesOfficeStyles();
            StyleGraphicPropertiesElement graphicProperties = stylesOfficeStyles.constructGraphicProperties();
            graphicProperties.setFoMarginBottomAttribute("1cm");
            graphicProperties.setStyleHorizontalPosAttribute("right");
            graphicProperties.setStyleFlowWithTextAttribute(Boolean.valueOf(true));
            String imageStyle = stylesOfficeStyles.getGraphicStyle(new OdfStylePropertiesBase[]{graphicProperties});
            imageTextElement.appendChild((Node)drawFrame);
            drawFrame.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PARAGRAPH.toString());
            drawFrame.setDrawStyleNameAttribute(imageStyle);
            ClassLoader classLoader = PlanningReportHelper.class.getClassLoader();
            URL logoUrl = classLoader.getResource("export/logos/OeBB_INFRA_black_eps_small.png");
            URI logoUri = logoUrl.toURI();
            OdfDrawImage image = (OdfDrawImage)drawFrame.newDrawImageElement();
            image.newImage(logoUri);
        }
    }

    private void constructObjectHeaderTable(ReviewProtocolData reviewProtocolData, OdfContext context, ReviewProtocolLocalStyles localStyles, OfficeTextElement officeText, ResourceBundle resourceBundle) {
        String standardParagraphStyle = localStyles.getStandardParagraphStyle();
        AutomaticStyles styles = context.getStylesAutomaticStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        StyleTableCellPropertiesElement labelProperties = this.constructDefaultCellProperties(contentAutomaticStyles, "#f3f3f3", "0.05pt solid #666666");
        String labelCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{labelProperties});
        StyleTableCellPropertiesElement valueProperties = this.constructDefaultCellProperties(contentAutomaticStyles, null, "0.05pt solid #666666");
        String valueCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{valueProperties});
        ReviewProtocolBaseJoin baseJoin = reviewProtocolData.getBaseJoin();
        String projectCode = baseJoin.getProjectCode();
        String projectName = baseJoin.getProjectName();
        String objectCode = baseJoin.getObjectTypeId() != null ? baseJoin.getObjectReleaseCode() + baseJoin.getObjectTypeCode() : baseJoin.getObjectReleaseCode();
        String objectName = baseJoin.getObjectReleaseName();
        String objectPlannerCode = baseJoin.getObjectPlannerReleaseCode();
        String objectPlannerArea = baseJoin.getObjectPlannerReleaseArea();
        String reviewCycleInstanceName = baseJoin.getReviewCycleInstanceReleasedName();
        Long plannerParticipationId = baseJoin.getPlannerParticipationId();
        String plannerOrganisationName = baseJoin.getPlannerOrganisationName() != null ? baseJoin.getPlannerOrganisationName() : "";
        String plannerPersonGivenName = baseJoin.getPlannerPersonGivenName() != null ? baseJoin.getPlannerPersonGivenName() : "";
        String plannerPersonSurName = baseJoin.getPlannerPersonSurName() != null ? baseJoin.getPlannerPersonSurName() : "";
        String plannerComment = baseJoin.getPlannerParticipationComment() != null ? baseJoin.getPlannerParticipationComment() : "";
        Double kmFrom = baseJoin.getObjectReleaseStretchKmFrom();
        Double kmTo = baseJoin.getObjectReleaseStretchKmTo();
        DecimalFormat kmFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.GERMAN);
        kmFormat.applyPattern("###,###.###");
        String kmFromString = kmFormat.format(kmFrom);
        String kmToString = kmFormat.format(kmTo);
        String reviewCycleInstanceLabel = MessageFormat.format(resourceBundle.getString("objectHeaderReviewCycleInstance"), reviewCycleInstanceName);
        TableTableElement tableElement = officeText.newTableTableElement();
        StyleTablePropertiesElement tableProperties = contentAutomaticStyles.constructTableProperties("24.0cm", null, "left", "lr-tb");
        String tableStyle = contentAutomaticStyles.getTableStyle(new OdfStylePropertiesBase[]{tableProperties});
        tableElement.setStyleName(tableStyle);
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"5.0cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"13.0cm");
        String spanBoldTextStyle = localStyles.getSpanBoldTextStyle();
        String spanDefaultTextStyle = localStyles.getSpanDefaultTextStyle();
        TableTableRowElement projectRow = TableFactory.appendRow((TableTableElement)tableElement, null);
        CdesExportHelper.appendTextSpanCell(projectRow, labelCellStyle, spanBoldTextStyle, resourceBundle.getString("objectHeaderProjectLabel"));
        CdesExportHelper.appendTextSpanCell(projectRow, valueCellStyle, spanBoldTextStyle, projectCode, spanDefaultTextStyle, " " + projectName);
        TableTableRowElement objectRow = TableFactory.appendRow((TableTableElement)tableElement, null);
        CdesExportHelper.appendTextSpanCell(objectRow, labelCellStyle, spanBoldTextStyle, resourceBundle.getString("objectHeaderObjectLabel"));
        CdesExportHelper.appendTextSpanCell(objectRow, valueCellStyle, spanBoldTextStyle, objectCode, spanDefaultTextStyle, " " + objectName);
        TableTableRowElement objectPlannerRow = TableFactory.appendRow((TableTableElement)tableElement, null);
        CdesExportHelper.appendTextSpanCell(objectPlannerRow, labelCellStyle, spanBoldTextStyle, resourceBundle.getString("objectHeaderObjectPlannerLabel"));
        String objectPlannerValueTextStyle = this.constructDataTextStyle(context, standardParagraphStyle, "12pt", null, null, null);
        TableTableCellElement objectPlannerValueCell = TableFactory.appendEmptyCell((String)valueCellStyle, (String)objectPlannerValueTextStyle, (TableTableRowElement)objectPlannerRow);
        TextFactory.constructTextNode((Node)objectPlannerValueCell, (String)(objectPlannerCode + " " + objectPlannerArea), (String)objectPlannerValueTextStyle);
        TextFactory.constructTextNode((Node)objectPlannerValueCell, (String)reviewCycleInstanceLabel, (String)objectPlannerValueTextStyle);
        String nodeBoldTextStyle = localStyles.getNodeBoldTextStyle();
        if (plannerParticipationId == null) {
            TextFactory.constructTextNode((Node)objectPlannerValueCell, (String)resourceBundle.getString("objectHeaderNoPlanner"), (String)nodeBoldTextStyle);
        } else {
            String plannerLabel = MessageFormat.format(resourceBundle.getString("objectHeaderPlanner"), plannerOrganisationName, plannerPersonGivenName, plannerPersonSurName, plannerComment);
            TextFactory.constructTextNode((Node)objectPlannerValueCell, (String)plannerLabel, (String)objectPlannerValueTextStyle);
        }
        TableTableRowElement kmRow = TableFactory.appendRow((TableTableElement)tableElement, null);
        CdesExportHelper.appendTextSpanCell(kmRow, labelCellStyle, spanBoldTextStyle, resourceBundle.getString("objectHeaderKmLabel"));
        String kmValueRaw = resourceBundle.getString("objectHeaderKmValue");
        String kmValue = MessageFormat.format(kmValueRaw, kmFromString, kmToString);
        CdesExportHelper.appendTextSpanCell(kmRow, valueCellStyle, spanDefaultTextStyle, kmValue);
    }

    private StyleTableCellPropertiesElement constructDefaultCellProperties(Styles contentAutomaticStyles) {
        return this.constructDefaultCellProperties(contentAutomaticStyles, null, null);
    }

    private StyleTableCellPropertiesElement constructDefaultCellProperties(Styles contentAutomaticStyles, String backgroundColor, String borderStyle) {
        StyleTableCellPropertiesElement labelProperties = contentAutomaticStyles.constructTableCellProperties();
        if (backgroundColor != null) {
            labelProperties.setFoBackgroundColorAttribute(backgroundColor);
        }
        labelProperties.setFoPaddingLeftAttribute("0.2cm");
        labelProperties.setFoPaddingRightAttribute("0.2cm");
        labelProperties.setFoPaddingTopAttribute("0.1cm");
        labelProperties.setFoPaddingBottomAttribute("0.1cm");
        if (borderStyle != null) {
            labelProperties.setFoBorderLeftAttribute(borderStyle);
            labelProperties.setFoBorderRightAttribute(borderStyle);
            labelProperties.setFoBorderTopAttribute(borderStyle);
            labelProperties.setFoBorderBottomAttribute(borderStyle);
        }
        return labelProperties;
    }

    private void appendContentCaption(OfficeTextElement officeText, OdfContext context, ReviewProtocolLocalStyles localStyles, String caption) {
        String headingStyle = localStyles.getSuperHeadingStyle();
        TextFactory.constructTextHeaderNode((Node)officeText, (String)caption, (String)headingStyle, (Integer)2);
    }

    private void appendOwnVersionTable(ReviewProtocolData reviewProtocolData, OdfContext context, ReviewProtocolLocalStyles localStyles, OfficeTextElement officeText, ResourceBundle resourceBundle, String userLocale, List<String> contentLocales) {
        String standardParagraphStyle = localStyles.getStandardParagraphStyle();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        TableTableElement tableElement = officeText.newTableTableElement();
        StyleTablePropertiesElement tableProperties = contentAutomaticStyles.constructTableProperties("100%", null, "left", "lr-tb");
        String tableStyle = contentAutomaticStyles.getTableStyle(new OdfStylePropertiesBase[]{tableProperties});
        tableElement.setStyleName(tableStyle);
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"3.0cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"7.0cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"2.5cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"13.5cm");
        String spanBoldTextStyle = localStyles.getSpanBoldTextStyle();
        String spanDefaultTextStyle = localStyles.getSpanDefaultTextStyle();
        StyleTableCellPropertiesElement labelProperties = this.constructDefaultCellProperties(contentAutomaticStyles);
        String cellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{labelProperties});
        ReviewProtocolBaseJoin baseJoin = reviewProtocolData.getBaseJoin();
        Long documentVersionId = baseJoin.getDocumentVersionId();
        ReviewProtocolVersionJoin ownVersionJoin = null;
        List versionJoins = reviewProtocolData.getVersionJoins();
        for (ReviewProtocolVersionJoin versionJoin : versionJoins) {
            if (versionJoin.getDocumentVersionId().longValue() != documentVersionId.longValue()) continue;
            ownVersionJoin = versionJoin;
            break;
        }
        String documentVersionName = ownVersionJoin.getDocumentVersionName();
        String documentScale = baseJoin.getDocumentReleaseScale() != null ? baseJoin.getDocumentReleaseScale() : ownVersionJoin.getDocumentScale();
        String rawDocumentContent = baseJoin.getDocumentReleaseContent() != null ? baseJoin.getDocumentReleaseContent() : ownVersionJoin.getDocumentContent();
        String documentContent = I18nHelper.getLocaleStringFromDatabase(rawDocumentContent, userLocale, contentLocales);
        TableTableRowElement firstRow = TableFactory.appendRow((TableTableElement)tableElement, null);
        CdesExportHelper.appendTextSpanCell(firstRow, cellStyle, spanBoldTextStyle, resourceBundle.getString("reviewProtocolOwnDocumentVersionNameCaption"));
        CdesExportHelper.appendTextSpanCell(firstRow, cellStyle, spanDefaultTextStyle, documentVersionName);
        CdesExportHelper.appendTextSpanCell(firstRow, cellStyle, spanBoldTextStyle, resourceBundle.getString("reviewProtocolOwnDocumentScaleCaption"));
        CdesExportHelper.appendTextSpanCell(firstRow, cellStyle, spanDefaultTextStyle, documentScale);
        TableTableRowElement secondRow = TableFactory.appendRow((TableTableElement)tableElement, null);
        CdesExportHelper.appendTextSpanCell(secondRow, cellStyle, spanBoldTextStyle, resourceBundle.getString("reviewProtocolOwnDocumentContentCaption"));
        TableTableCellElement contentCell = CdesExportHelper.appendTextSpanCell(secondRow, cellStyle, spanDefaultTextStyle, documentContent);
        contentCell.setTableNumberColumnsSpannedAttribute(Integer.valueOf(3));
    }

    private static <T> FancyOdfTable<T> constructFancyTable(Styles styles, ReviewProtocolLocalStyles localStyles, Double width, List<FancyOdfTableColumn<T>> columns, Map<String, Double> relativeColumnWidths) {
        String headerCellStyle = localStyles.getHeaderCellStyle();
        String headerTextStyle = localStyles.getHeaderTextStyle();
        String dataCellStyle = localStyles.getDataCellStyle();
        String dataTextStyle = localStyles.getDataTextStyle();
        String dataRowStyle = localStyles.getDataRowStyle();
        FancyOdfTable table = new FancyOdfTable(styles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, width, relativeColumnWidths, columns);
        table.setDataRowStyle(dataRowStyle);
        return table;
    }

    private static String getNonNull(String s) {
        return s != null ? s : "";
    }

    private List<ReviewProtocolVersionJoin> getOtherVersionJoins(ReviewProtocolData reviewProtocolData) {
        ReviewProtocolBaseJoin baseJoin = reviewProtocolData.getBaseJoin();
        List versionJoins = reviewProtocolData.getVersionJoins();
        ArrayList<ReviewProtocolVersionJoin> otherVersionJoins = new ArrayList<ReviewProtocolVersionJoin>();
        for (ReviewProtocolVersionJoin versionJoin : versionJoins) {
            if (versionJoin.getDocumentVersionId().longValue() == baseJoin.getDocumentVersionId().longValue()) continue;
            otherVersionJoins.add(versionJoin);
        }
        return otherVersionJoins;
    }

    private void appendNoEntriesTable(OfficeTextElement officeText, OdfContext context, ReviewProtocolLocalStyles localStyles, ResourceBundle resourceBundle) {
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        TableTableElement tableElement = officeText.newTableTableElement();
        TableFactory.appendColumnWithOptimalSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement);
        TableTableRowElement rowElement = TableFactory.appendRow((TableTableElement)tableElement, null);
        String cellStyle = localStyles.getDataCellStyle();
        String textStyle = localStyles.getDataTextStyleRight();
        TableFactory.appendCell((String)cellStyle, (String)textStyle, (TableTableRowElement)rowElement, (String[])new String[]{resourceBundle.getString("reviewProtocolEmptySectionLabel")});
    }

    private void sortVersionJoinsByUploaded(List<ReviewProtocolVersionJoin> versionJoins) {
        Collections.sort(versionJoins, new Comparator<ReviewProtocolVersionJoin>(){

            @Override
            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo) {
                Double uploadedTwo;
                Double uploadedOne = versionJoinOne.getDocumentVersionUploaded();
                Double delta = (uploadedOne != null ? uploadedOne : 0.0) - ((uploadedTwo = versionJoinTwo.getDocumentVersionUploaded()) != null ? uploadedTwo : 0.0);
                if (delta < 0.0) {
                    return -1;
                }
                if (delta > 0.0) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private ReviewProtocolVersionJoin getLastVersion(List<ReviewProtocolVersionJoin> givenVersionJoins) {
        ReviewProtocolVersionJoin lastVersionJoin;
        ArrayList<ReviewProtocolVersionJoin> versionJoins = new ArrayList<ReviewProtocolVersionJoin>();
        for (ReviewProtocolVersionJoin givenVersionJoin : givenVersionJoins) {
            versionJoins.add(givenVersionJoin);
        }
        this.sortVersionJoinsByUploaded(versionJoins);
        ReviewProtocolVersionJoin reviewProtocolVersionJoin = lastVersionJoin = versionJoins.size() > 0 ? (ReviewProtocolVersionJoin)versionJoins.get(versionJoins.size() - 1) : null;
        if (lastVersionJoin.getDocumentVersionReactivatedDocumentVersionId() != null) {
            long reactivatedVersionId = lastVersionJoin.getDocumentVersionReactivatedDocumentVersionId();
            for (ReviewProtocolVersionJoin givenVersionJoin : givenVersionJoins) {
                long givenVersionId = givenVersionJoin.getDocumentVersionId();
                if (givenVersionId != reactivatedVersionId) continue;
                return givenVersionJoin;
            }
            throw new RuntimeException("Did not find documentVersionJoin with id [" + reactivatedVersionId + "] in givenVersionJoins.  However, it should be there.");
        }
        return lastVersionJoin;
    }

    private boolean isLastVersion(List<ReviewProtocolVersionJoin> versionJoins, Long documentVersionId) {
        ReviewProtocolVersionJoin lastVersionJoin = this.getLastVersion(versionJoins);
        return lastVersionJoin.getDocumentVersionId().longValue() == documentVersionId.longValue();
    }

    private int getRevisedCount(List<ReviewProtocolVersionJoin> versionJoins, Long documentVersionId) {
        int count = 0;
        for (ReviewProtocolVersionJoin versionJoin : versionJoins) {
            Long revisedVersionId = versionJoin.getRevisedDocumentVersionId();
            if (revisedVersionId == null || revisedVersionId.longValue() != documentVersionId.longValue()) continue;
            ++count;
        }
        return count;
    }

    private StyleTextPropertiesElement getInvalidatedOrDeletedVersionTextProperties(Styles contentAutomaticStyles) {
        StyleTextPropertiesElement textProperties = contentAutomaticStyles.constructTextProperties();
        textProperties.setStyleTextLineThroughStyleAttribute("solid");
        textProperties.setStyleTextLineThroughTypeAttribute("single");
        return textProperties;
    }

    private StyleTextPropertiesElement getInvalidatedAllVersionTextProperties(Styles contentAutomaticStyles) {
        StyleTextPropertiesElement textProperties = this.getInvalidatedOrDeletedVersionTextProperties(contentAutomaticStyles);
        textProperties.setFoColorAttribute("#800000");
        return textProperties;
    }

    private String getVersionStyle(ReviewProtocolVersionJoin versionJoin, String defaultStyle, String invalidatedOrDeletedStyle, String invalidatedAllStyle) {
        DocumentVersionStatus documentVersionStatus = DocumentVersionStatus.getByValue((Integer)versionJoin.getDocumentVersionStatus());
        if (documentVersionStatus == DocumentVersionStatus.INVALIDATEDVERSION || documentVersionStatus == DocumentVersionStatus.DELETED) {
            return invalidatedOrDeletedStyle;
        }
        if (documentVersionStatus == DocumentVersionStatus.INVALIDATEDALL) {
            return invalidatedAllStyle;
        }
        return defaultStyle;
    }

    public boolean isShowUrl(ArchiveScope archiveScope, ReviewProtocolVersionJoin versionJoin, ReviewProtocolData reviewProtocolData) {
        if (archiveScope == ArchiveScope.ARCHIVE_SCOPE_ALL || archiveScope == ArchiveScope.ARCHIVE_SCOPE_ALLWITHHISTORY) {
            return true;
        }
        List versionJoins = reviewProtocolData.getVersionJoins();
        long documentVersionId = versionJoin.getDocumentVersionId();
        ReviewProtocolVersionJoin lastVersionJoin = this.getLastVersion(versionJoins);
        boolean isLastDocumentVersion = lastVersionJoin.getDocumentVersionId() == documentVersionId;
        return isLastDocumentVersion;
    }

    public String getAttachmentUrl(ArchiveScope archiveScope, ReviewProtocolVersionJoin versionJoin, ReviewProtocolData reviewProtocolData, Attachment attachment, ResourceBundle resourceBundle) {
        if (!this.isShowUrl(archiveScope, versionJoin, reviewProtocolData)) {
            return null;
        }
        if (attachment.isIsRedliningDelta().booleanValue()) {
            ReviewProtocolBaseJoin baseJoin = reviewProtocolData.getBaseJoin();
            return ArchiveHelper.getRedliningFilename((DocumentArchivePathJoin)versionJoin, baseJoin.getObjectReleaseCode(), baseJoin.getObjectTypeCode(), resourceBundle, 0);
        }
        ReviewProtocolBaseJoin baseJoin = reviewProtocolData.getBaseJoin();
        return ArchiveHelper.getAttachmentFilename((DocumentArchivePathJoin)versionJoin, baseJoin.getObjectReleaseCode(), baseJoin.getObjectTypeCode(), resourceBundle, 0, attachment);
    }

    private void appendOtherDocumentVersionsTable(OfficeTextElement officeText, OdfContext context, final ArchiveFileFormat archiveFileFormat, final ArchiveScope archiveScope, ReviewProtocolLocalStyles localStyles, final ReviewProtocolData reviewProtocolData, final ResourceBundle resourceBundle) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        String tableUnderCaptionStyle = null;
        final ReviewProtocolBaseJoin baseJoin = reviewProtocolData.getBaseJoin();
        List otherVersionJoins = reviewProtocolData.getVersionJoins();
        final String dataTextStyle = localStyles.getDataTextStyle();
        String dataTextStyleSmall = localStyles.getDataTextStyleSmall();
        final String dataTextStyleRight = localStyles.getDataTextStyleRight();
        final String dataTextStyleSmallRight = localStyles.getDataTextStyleSmallRight();
        final String dataCellStyle = localStyles.getDataCellStyle();
        String standardParagraphStyle = localStyles.getStandardParagraphStyle();
        final Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        final String dataTextStyleInvalidatedOrDeleted = this.constructDataTextStyle(context, standardParagraphStyle, "10pt", null, null, "solid", "single", null, null);
        String dataTextStyleSmallInvalidatedOrDeleted = this.constructDataTextStyle(context, standardParagraphStyle, "7pt", null, null, "solid", "single", null, null);
        final String dataTextStyleRightInvalidatedOrDeleted = this.constructDataTextStyle(context, standardParagraphStyle, "10pt", null, "right", "solid", "single", null, null);
        final String dataTextStyleSmallRightInvalidatedOrDeleted = this.constructDataTextStyle(context, standardParagraphStyle, "7pt", null, "right", "solid", "single", null, null);
        final String dataTextStyleInvalidatedAll = this.constructDataTextStyle(context, standardParagraphStyle, "10pt", null, null, "solid", "single", "#800000", null);
        String dataTextStyleSmallInvalidatedAll = this.constructDataTextStyle(context, standardParagraphStyle, "7pt", null, null, "solid", "single", "#800000", null);
        final String dataTextStyleRightInvalidatedAll = this.constructDataTextStyle(context, standardParagraphStyle, "10pt", null, "right", "solid", "single", "#800000", null);
        final String dataTextStyleSmallRightInvalidatedAll = this.constructDataTextStyle(context, standardParagraphStyle, "7pt", null, "right", "solid", "single", "#800000", null);
        ArrayList columns = new ArrayList();
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("versionInfo", resourceBundle.getString("reviewProtocolVersionInfoColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                String versionString = this.getVersionString(versionJoin);
                String textStyleSmallRight = ReviewProtocolPdfExporter.this.getVersionStyle(versionJoin, dataTextStyleSmallRight, dataTextStyleSmallRightInvalidatedOrDeleted, dataTextStyleSmallRightInvalidatedAll);
                String textStyleRight = ReviewProtocolPdfExporter.this.getVersionStyle(versionJoin, dataTextStyleRight, dataTextStyleRightInvalidatedOrDeleted, dataTextStyleRightInvalidatedAll);
                if (ReviewProtocolPdfExporter.this.isShowUrl(archiveScope, versionJoin, reviewProtocolData) && archiveFileFormat != null && (archiveFileFormat == ArchiveFileFormat.ARCHIVE_TYPE_BOTH || archiveFileFormat == ArchiveFileFormat.ARCHIVE_TYPE_ORIGINAL)) {
                    TextPElement pElement = TextFactory.constructTextNode((Node)cellElement, (String)"", (String)textStyleRight);
                    String href = ArchiveHelper.getDocumentVersionFilename((DocumentArchivePathJoin)versionJoin, baseJoin.getObjectReleaseCode(), baseJoin.getObjectTypeCode(), resourceBundle, 0, false);
                    TextAElement textAElement = TextFactory.constructTextAElement((Node)pElement, (String)"simple", (String)href, (String)dataTextStyle, (String)textStyleRight);
                    TextFactory.constructTextSpan((Node)textAElement, (String)versionString, (String)textStyleSmallRight);
                } else {
                    TextFactory.constructTextNode((Node)cellElement, (String)versionString, (String)textStyleRight);
                }
                String revisionString = this.getRevisionInfo(versionJoin);
                if (revisionString != null && revisionString.trim().length() > 0) {
                    TextFactory.constructTextNode((Node)cellElement, (String)revisionString, (String)textStyleRight);
                }
                if (archiveFileFormat != null && (archiveFileFormat == ArchiveFileFormat.ARCHIVE_TYPE_BOTH || archiveFileFormat == ArchiveFileFormat.ARCHIVE_TYPE_PDF)) {
                    TextPElement pElement = TextFactory.constructTextNode((Node)cellElement, (String)"", (String)textStyleRight);
                    String href = ArchiveHelper.getDocumentVersionFilename((DocumentArchivePathJoin)versionJoin, baseJoin.getObjectReleaseCode(), baseJoin.getObjectTypeCode(), resourceBundle, 0, true);
                    TextAElement textAElement = TextFactory.constructTextAElement((Node)pElement, (String)"simple", (String)href, (String)dataTextStyle, (String)textStyleRight);
                    textAElement.setTextContent(resourceBundle.getString("reviewProtocolVersionPdfLabel"));
                }
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = this.getVersionString(versionJoinOne);
                String s2 = this.getVersionString(versionJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getVersionString(ReviewProtocolVersionJoin versionJoin) {
                String versionPartA = versionJoin.getDocumentVersionVersionParta();
                String versionPartSeparator = versionJoin.getDocumentVersionVersionPartSeperator();
                String versionPartB = versionJoin.getDocumentVersionVersionPartb();
                String versionStringRaw = resourceBundle.getString("reviewProtocolVersionVersionLabel");
                String versionString = MessageFormat.format(versionStringRaw, ReviewProtocolPdfExporter.getNonNull(versionPartA), ReviewProtocolPdfExporter.getNonNull(versionPartSeparator), ReviewProtocolPdfExporter.getNonNull(versionPartB));
                return versionString;
            }

            public String getRevisionInfo(ReviewProtocolVersionJoin versionJoin) {
                DocumentVersionStatus documentVersionStatus = DocumentVersionStatus.getByValue((Integer)versionJoin.getDocumentVersionStatus());
                String documentVersionFileName = versionJoin.getDocumentVersionFileName();
                String asBuiltVersionFileName = versionJoin.getAsBuiltDocumentVersionFileName();
                boolean unchanged = documentVersionFileName != null && asBuiltVersionFileName != null && documentVersionFileName.equals(asBuiltVersionFileName);
                String unchangedPrefix = unchanged ? resourceBundle.getString("reviewProtocolVersionUnchanged") : null;
                List versionJoins = reviewProtocolData.getVersionJoins();
                long documentVersionId = versionJoin.getDocumentVersionId();
                ReviewProtocolVersionJoin lastVersionJoin = ReviewProtocolPdfExporter.this.getLastVersion(versionJoins);
                boolean isLastDocumentVersion = lastVersionJoin.getDocumentVersionId() == documentVersionId;
                DocumentVersionStatus lastStatus = DocumentVersionStatus.getByValue((Integer)lastVersionJoin.getDocumentVersionStatus());
                Long revisedDocumentVersionId = versionJoin.getDocumentVersionRevisedDocumentVersionId();
                int revisedCount = ReviewProtocolPdfExporter.this.getRevisedCount(versionJoins, documentVersionId);
                String postfix = revisedDocumentVersionId != null && isLastDocumentVersion && documentVersionStatus != DocumentVersionStatus.RELEASEDPOSITIV ? resourceBundle.getString("reviewProcotolVersionStatusInReviewStillValid") : (revisedCount > 0 && documentVersionStatus == DocumentVersionStatus.INVALIDATEDVERSION && lastStatus != DocumentVersionStatus.RELEASEDPOSITIV ? resourceBundle.getString("reviewProcotolVersionStatusInvalidNewVersionInReview") : (revisedCount > 0 && documentVersionStatus == DocumentVersionStatus.INVALIDATEDVERSION && lastStatus == DocumentVersionStatus.RELEASEDPOSITIV ? resourceBundle.getString("reviewProcotolVersionStatusInvalidReplaced") : (revisedCount > 0 && documentVersionStatus == DocumentVersionStatus.RELEASEDPOSITIV ? resourceBundle.getString("reviewProcotolVersionStatusCurrentlyReleasedVersion") : (versionJoin.getDocumentVersionReactivatedDocumentVersionId() != null ? resourceBundle.getString("reviewProcotolVersionStatusInvalidPreviousVersionReactivated") : (documentVersionStatus == DocumentVersionStatus.DELETED ? resourceBundle.getString("reviewProcotolVersionStatusDeleted") : null)))));
                return (unchangedPrefix != null || postfix != null ? "(" : "") + (unchangedPrefix != null ? unchangedPrefix : "") + (unchangedPrefix != null && postfix != null ? " \u2015 " : "") + (postfix != null ? postfix : "") + (unchangedPrefix != null || postfix != null ? ")" : "");
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("comment", resourceBundle.getString("reviewProtocolVersionCommentColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                String textStyle = ReviewProtocolPdfExporter.this.getVersionStyle(versionJoin, dataTextStyle, dataTextStyleInvalidatedOrDeleted, dataTextStyleInvalidatedAll);
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                OdfFromHtmlConverter.convert((Node)cellElement, this.getOutput(versionJoin), textStyle, contentAutomaticStyles);
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = this.getOutput(versionJoinOne);
                String s2 = this.getOutput(versionJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin versionJoin) {
                String connectionComment;
                String entryResultComment = versionJoin.getReviewCycleEntryResultId() != null ? versionJoin.getReviewCycleEntryResultComment() : null;
                String string = connectionComment = versionJoin.getDestVersionCellConnectionResultId() != null ? versionJoin.getDestVersionCellConnectionResultComment() : null;
                if (entryResultComment != null && connectionComment != null) {
                    return entryResultComment + " " + connectionComment;
                }
                return (entryResultComment != null ? entryResultComment : "") + (connectionComment != null ? connectionComment : "");
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("uploaded", resourceBundle.getString("reviewProtocolVersionUploadedColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                String textStyle = ReviewProtocolPdfExporter.this.getVersionStyle(versionJoin, dataTextStyle, dataTextStyleInvalidatedOrDeleted, dataTextStyleInvalidatedAll);
                TableFactory.appendCell((String)dataCellStyle, (String)textStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                Double uploadedOne = versionJoinOne.getDocumentVersionUploaded();
                Double uploadedTwo = versionJoinTwo.getDocumentVersionUploaded();
                return ReviewProtocolPdfExporter.defaultDoubleCompare(uploadedOne, uploadedTwo, descending);
            }

            private String getOutput(ReviewProtocolVersionJoin versionJoin) {
                Double uploaded = versionJoin.getDocumentVersionUploaded();
                if (uploaded != null) {
                    String format = resourceBundle.getString("yearToSecondFormat");
                    return DateHelper.formatUtcSeconds(uploaded, "Europe/Vienna", format);
                }
                return "";
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("uploadedBy", resourceBundle.getString("reviewProtocolVersionUploadedByCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                String textStyle = ReviewProtocolPdfExporter.this.getVersionStyle(versionJoin, dataTextStyle, dataTextStyleInvalidatedOrDeleted, dataTextStyleInvalidatedAll);
                if (versionJoin.getEntryResultOrganisationId() != null && versionJoin.getEntryResultPersonId() != null) {
                    String entryResultPersonString = this.getEntryResultPersonString(versionJoin);
                    TextFactory.constructTextNode((Node)cellElement, (String)entryResultPersonString, (String)textStyle);
                }
                if (versionJoin.getConnectionResultOrganisationId() != null && versionJoin.getConnectionResultPersonId() != null) {
                    String connectionResultPersonString = this.getConnectionResultPersonString(versionJoin);
                    TextFactory.constructTextNode((Node)cellElement, (String)connectionResultPersonString, (String)textStyle);
                }
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = "";
                String s2 = "";
                if (versionJoinOne.getEntryResultOrganisationId() != null && versionJoinOne.getEntryResultPersonId() != null) {
                    s1 = this.getEntryResultPersonString(versionJoinOne);
                    s2 = this.getEntryResultPersonString(versionJoinTwo);
                }
                if (versionJoinOne.getConnectionResultOrganisationId() != null && versionJoinOne.getConnectionResultPersonId() != null) {
                    s1 = this.getConnectionResultPersonString(versionJoinOne);
                    s2 = this.getConnectionResultPersonString(versionJoinTwo);
                }
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getEntryResultPersonString(ReviewProtocolVersionJoin versionJoin) {
                return PersonHelper.getOrganisationAndInverseCommonName(versionJoin.getEntryResultOrganisation(), versionJoin.getEntryResultPerson());
            }

            private String getConnectionResultPersonString(ReviewProtocolVersionJoin versionJoin) {
                return PersonHelper.getOrganisationAndInverseCommonName(versionJoin.getConnectionResultOrganisation(), versionJoin.getConnectionResultPerson());
            }
        });
        HashMap<String, Double> relativeColumnWidths = new HashMap<String, Double>();
        relativeColumnWidths.put("versionInfo", 0.2);
        relativeColumnWidths.put("comment", 0.47);
        relativeColumnWidths.put("uploaded", 0.08);
        relativeColumnWidths.put("uploadedBy", 0.25);
        ArrayList<ColumnSortSpec> columnSortSpecs = new ArrayList<ColumnSortSpec>();
        columnSortSpecs.add(new ColumnSortSpec("uploaded", Boolean.valueOf(true)));
        Styles styles = context.getContentAutomaticStyles();
        FancyOdfTable table = ReviewProtocolPdfExporter.constructFancyTable(styles, localStyles, 23.9, columns, relativeColumnWidths);
        table.setTableStyle(tableUnderCaptionStyle);
        table.setRenderHeaderLine(true);
        table.render((Node)officeText, otherVersionJoins, columnSortSpecs);
        if (otherVersionJoins.size() == 0) {
            this.appendNoEntriesTable(officeText, context, localStyles, resourceBundle);
        }
    }

    private void appendReferenceTable(OfficeTextElement officeText, OdfContext context, final ArchiveFileFormat archiveFileFormat, ReviewProtocolLocalStyles localStyles, ReviewProtocolData reviewProtocolData, final ResourceBundle resourceBundle, final String userLocale, final List<String> contentLocales) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        String documentReferenceCaption = resourceBundle.getString("reviewProtocolDocumentReferenceCaption");
        this.appendContentCaption(officeText, context, localStyles, documentReferenceCaption);
        String tableUnderCaptionStyle = null;
        List referenceJoins = reviewProtocolData.getReferenceJoins();
        final Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        final String dataTextStyle = localStyles.getDataTextStyle();
        String dataTextStyleSmall = localStyles.getDataTextStyleSmall();
        String dataTextStyleRight = localStyles.getDataTextStyleRight();
        String dataTextStyleSmallRight = localStyles.getDataTextStyleSmallRight();
        final String dataCellStyle = localStyles.getDataCellStyle();
        ArrayList columns = new ArrayList();
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("realm", resourceBundle.getString("reviewProtocolReferenceRealmColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = this.getOutput(versionJoinOne);
                String s2 = this.getOutput(versionJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin versionJoin) {
                String realm = I18nHelper.getLocaleStringFromDatabase(versionJoin.getDocumentReferenceRealm(), userLocale, contentLocales);
                return realm != null ? realm : "";
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("reference", resourceBundle.getString("reviewProtocolReferenceReferenceColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                if (archiveFileFormat == null) {
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                    OdfFromHtmlConverter.convert((Node)cellElement, this.getOutput(versionJoin), dataTextStyle, contentAutomaticStyles);
                } else {
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                    TextPElement pElement = TextFactory.constructTextNode((Node)cellElement, (String)"", (String)dataTextStyle);
                    String attachmentFiletype = "";
                    Object href = null;
                    if (versionJoin.getDocumentReferenceAttachmentFilename() != null) {
                        attachmentFiletype = versionJoin.getDocumentReferenceAttachmentFiletype();
                    } else if (versionJoin.getDocumentReferenceReferencedVersionId() != null) {
                        DocumentVersion referencedVersion = (DocumentVersion)ReviewProtocolPdfExporter.this.documentVersionDAO.get(versionJoin.getDocumentReferenceReferencedVersionId());
                        attachmentFiletype = referencedVersion.getFiletype();
                    }
                    OdfFromHtmlConverter.convert((Node)cellElement, versionJoin.getDocumentReferenceReference(), dataTextStyle, contentAutomaticStyles);
                }
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = this.getOutput(versionJoinOne);
                String s2 = this.getOutput(versionJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin versionJoin) {
                String reference = versionJoin.getDocumentReferenceReference();
                return reference != null ? reference : "";
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("gz", resourceBundle.getString("reviewProtocolReferenceGzColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = this.getOutput(versionJoinOne);
                String s2 = this.getOutput(versionJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin versionJoin) {
                String gz = versionJoin.getDocumentReferenceGz();
                return gz != null ? gz : "";
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("created", resourceBundle.getString("reviewProtocolReferenceCreatedColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                Double createdOne = versionJoinOne.getDocumentReferenceCreated();
                Double createdTwo = versionJoinTwo.getDocumentReferenceCreated();
                return ReviewProtocolPdfExporter.defaultDoubleCompare(createdOne, createdTwo, descending);
            }

            private String getOutput(ReviewProtocolVersionJoin versionJoin) {
                Double created = versionJoin.getDocumentReferenceCreated();
                if (created != null) {
                    String format = resourceBundle.getString("yearToSecondFormat");
                    return DateHelper.formatUtcSeconds(created, "Europe/Vienna", format);
                }
                return "";
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("validFor", resourceBundle.getString("reviewProtocolReferenceValidForColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = this.getOutput(versionJoinOne);
                String s2 = this.getOutput(versionJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin referenceJoin) {
                String sinceVersionPartA = referenceJoin.getSinceDocumentVersionVersionParta();
                String sinceVersionPartB = referenceJoin.getSinceDocumentVersionVersionPartb();
                String sinceVersionPartSeparator = referenceJoin.getSinceDocumentVersionVersionPartSeperator();
                String untilVersionPartA = referenceJoin.getUntilDocumentVersionVersionParta();
                String untilVersionPartB = referenceJoin.getUntilDocumentVersionVersionPartb();
                String untilVersionPartSeparator = referenceJoin.getUntilDocumentVersionVersionPartSeperator();
                String validFor = MessageFormat.format(resourceBundle.getString("reviewProtocolReferenceValidForValue"), ReviewProtocolPdfExporter.getNonNull(sinceVersionPartA), ReviewProtocolPdfExporter.getNonNull(sinceVersionPartSeparator), ReviewProtocolPdfExporter.getNonNull(sinceVersionPartB), ReviewProtocolPdfExporter.getNonNull(untilVersionPartA), ReviewProtocolPdfExporter.getNonNull(untilVersionPartSeparator), ReviewProtocolPdfExporter.getNonNull(untilVersionPartB));
                return validFor;
            }
        });
        HashMap<String, Double> relativeColumnWidths = new HashMap<String, Double>();
        relativeColumnWidths.put("realm", 0.1);
        relativeColumnWidths.put("reference", 0.55);
        relativeColumnWidths.put("gz", 0.1);
        relativeColumnWidths.put("created", 0.1);
        relativeColumnWidths.put("validFor", 0.15);
        ArrayList<ColumnSortSpec> columnSortSpecs = new ArrayList<ColumnSortSpec>();
        columnSortSpecs.add(new ColumnSortSpec("created", Boolean.valueOf(true)));
        Styles styles = context.getContentAutomaticStyles();
        FancyOdfTable table = ReviewProtocolPdfExporter.constructFancyTable(styles, localStyles, 23.9, columns, relativeColumnWidths);
        table.setTableStyle(tableUnderCaptionStyle);
        table.setRenderHeaderLine(true);
        table.render((Node)officeText, referenceJoins, columnSortSpecs);
        if (referenceJoins.size() == 0) {
            this.appendNoEntriesTable(officeText, context, localStyles, resourceBundle);
        }
    }

    private String constructPageBreakStyle(OdfContext context, String parentParagraphStyle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleParagraphPropertiesElement paragraphPropertiesElement = stylesOfficeStyles.constructParagraphPropertiesWithBreakBefore("page");
        paragraphPropertiesElement.setFoMarginTopAttribute("0cm");
        return stylesOfficeStyles.getParagraphStyleWithParent(parentParagraphStyle, new OdfStylePropertiesBase[]{paragraphPropertiesElement});
    }

    private void appendStatusSvgSection(ReviewProtocolData reviewProtocolData, OfficeTextElement officeText, OdfContext context, ReviewProtocolLocalStyles localStyles, ResourceBundle resourceBundle) {
        String headingStyle = localStyles.getSuperHeadingStyle();
        String captionStyle = this.constructPageBreakStyle(context, headingStyle);
        String caption = resourceBundle.getString("reviewProtocolStatusSvgCaption");
        TextFactory.constructTextHeaderNode((Node)officeText, (String)caption, (String)headingStyle, (Integer)2);
        String svg = reviewProtocolData.getSvgImage();
        int width = DocumentServiceImpl.REVIEW_PROTOCOL_STATUS_SVG_WIDTH;
        int actualHeight = reviewProtocolData.getSvgImageHeight();
        double scaleY = 250.0 / (double)actualHeight;
        double translateY = (double)actualHeight - 250.0;
        svg = svg.replace("__iemeeg0omudo8ieW__scaleY__", String.valueOf(scaleY));
        svg = svg.replace("__iemeeg0omudo8ieW__translateY__", String.valueOf(translateY));
        double fraction = (double)actualHeight / (double)width;
        double desiredWidth = 26.5;
        double desiredHeight = fraction * desiredWidth;
        if (desiredHeight > 20.0) {
            desiredHeight = 20.0;
            desiredWidth = desiredHeight / fraction;
        }
        DecimalFormat dimensionFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
        dimensionFormat.applyPattern("###,###.###");
        String desiredWidthString = dimensionFormat.format(desiredWidth) + "cm";
        String desiredHeightString = dimensionFormat.format(desiredHeight) + "cm";
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        Styles stylesStyles = context.getStylesOfficeStyles();
        String frameContentsStyle = stylesStyles.getParagraphStyleWithParent(stylesStyles.getParagraphStyleWithClass("text", new OdfStylePropertiesBase[0]), "extra", new OdfStylePropertiesBase[0]);
        TextPElement imagePElement = TextFactory.constructTextNode((Node)officeText, null, (String)frameContentsStyle);
        String parentStyle = stylesStyles.getGraphicStyle(new OdfStylePropertiesBase[]{FrameFactory.constructImageFrameParentProperties((Styles)stylesStyles)});
        StyleGraphicPropertiesElement graphicProperties = FrameFactory.constructImageFrameProperties((Styles)contentAutomaticStyles);
        String imageFrameStyle = contentAutomaticStyles.getGraphicStyleWithParent(parentStyle, new OdfStylePropertiesBase[]{graphicProperties});
        DrawFrameElement drawFrameElement = (DrawFrameElement)((OdfFileDom)imagePElement.getOwnerDocument()).newOdfElement(DrawFrameElement.class);
        drawFrameElement.setStyleName(imageFrameStyle);
        drawFrameElement.setTextAnchorTypeAttribute("as-char");
        drawFrameElement.setSvgWidthAttribute(desiredWidthString);
        drawFrameElement.setSvgHeightAttribute(desiredHeightString);
        drawFrameElement.setDrawZIndexAttribute(Integer.valueOf(0));
        DrawFrameElement trafficLightInnerFrame = FrameFactory.constructDrawFrameNode((Node)imagePElement, (String)imageFrameStyle, (String)"as-char", null, null, (String)desiredWidthString, (String)desiredHeightString, (Integer)0);
        try {
            OdfDrawImage image = (OdfDrawImage)trafficLightInnerFrame.newDrawImageElement();
            image.setXlinkShowAttribute("embed");
            image.setXlinkActuateAttribute("onLoad");
            OfficeBinaryDataElement officeBinaryDataElement = image.newOfficeBinaryDataElement();
            String base64Svg = Base64.encodeBase64String((byte[])svg.getBytes());
            officeBinaryDataElement.setTextContent(base64Svg);
            image.appendChild((Node)officeBinaryDataElement);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static int defaultDoubleCompare(Double d1, Double d2, boolean descending) {
        double diff;
        if (d1 == null) {
            return 1;
        }
        if (d2 == null) {
            return -1;
        }
        double d = diff = descending ? -(d2 - d1) : d2 - d1;
        if (diff > 0.0) {
            return 1;
        }
        if (diff == 0.0) {
            return 0;
        }
        return -1;
    }

    private void appendVersionSections(ReviewProtocolData reviewProtocolData, ArchiveScope archiveScope, OfficeTextElement officeText, OdfContext context, ReviewProtocolLocalStyles localStyles, ResourceBundle resourceBundle, String userLocale, List<String> contentLocales) {
        List versionJoins = reviewProtocolData.getVersionJoins();
        this.sortVersionJoinsByUploaded(versionJoins);
        for (ReviewProtocolVersionJoin versionJoin : versionJoins) {
            this.appendVersionSection(reviewProtocolData, versionJoin, archiveScope, officeText, context, localStyles, resourceBundle, userLocale, contentLocales);
        }
    }

    private void appendVersionSection(ReviewProtocolData reviewProtocolData, ReviewProtocolVersionJoin versionJoin, ArchiveScope archiveScope, OfficeTextElement officeText, OdfContext context, ReviewProtocolLocalStyles localStyles, ResourceBundle resourceBundle, String userLocale, List<String> contentLocales) {
        Long documentVersionId = versionJoin.getDocumentVersionId();
        List versionJoins = reviewProtocolData.getVersionJoins();
        this.appendVersionCaption(versionJoins, versionJoin, officeText, context, localStyles, resourceBundle, userLocale, contentLocales);
        this.appendStatementResultList(documentVersionId, reviewProtocolData, officeText, context, localStyles, resourceBundle, userLocale, contentLocales);
        this.appendEntryResultList(documentVersionId, reviewProtocolData, officeText, context, localStyles, resourceBundle, userLocale, contentLocales);
        this.appendInvalidatedList(documentVersionId, reviewProtocolData, versionJoin, officeText, context, localStyles, resourceBundle, userLocale, contentLocales);
        List<ReviewProtocolVersionJoin> nodeResultJoins = this.getNodeResultJoins(reviewProtocolData, versionJoin);
        for (ReviewProtocolVersionJoin nodeResultJoin : nodeResultJoins) {
            this.appendNodeResultSection(nodeResultJoin, reviewProtocolData, archiveScope, officeText, context, localStyles, resourceBundle, userLocale, contentLocales);
            this.appendOebbCommentSection(nodeResultJoin, reviewProtocolData, officeText, context, localStyles, resourceBundle);
            this.appendCrossCommentSection(nodeResultJoin, reviewProtocolData, archiveScope, officeText, context, localStyles, resourceBundle, userLocale, contentLocales);
        }
    }

    private List<ReviewProtocolVersionJoin> getNodeResultJoins(ReviewProtocolData reviewProtocolData, ReviewProtocolVersionJoin versionJoin) {
        Long documentVersionId = versionJoin.getDocumentVersionId();
        Map documentVersionIdToCellResultIds = reviewProtocolData.getDocumentVersionIdToCellResultIds();
        Set cellResultIds = (Set)documentVersionIdToCellResultIds.get(documentVersionId);
        if (cellResultIds == null) {
            return new ArrayList<ReviewProtocolVersionJoin>();
        }
        Map cellResultIdToNodeResultIdToNodeResultJoin = reviewProtocolData.getCellResultIdToNodeResultIdToNodeResult();
        HashMap<Long, ReviewProtocolVersionJoin> idToNodeResultJoin = new HashMap<Long, ReviewProtocolVersionJoin>();
        for (Long cellResultId : cellResultIds) {
            Map currIdToNodeResultJoin = (Map)cellResultIdToNodeResultIdToNodeResultJoin.get(cellResultId);
            if (currIdToNodeResultJoin == null) continue;
            for (Long nodeResultId : currIdToNodeResultJoin.keySet()) {
                idToNodeResultJoin.put(nodeResultId, (ReviewProtocolVersionJoin)currIdToNodeResultJoin.get(nodeResultId));
            }
        }
        ArrayList<ReviewProtocolVersionJoin> nodeResultJoins = new ArrayList<ReviewProtocolVersionJoin>();
        for (Long nodeResultId : idToNodeResultJoin.keySet()) {
            ReviewProtocolVersionJoin candidateJoin = (ReviewProtocolVersionJoin)idToNodeResultJoin.get(nodeResultId);
            if (!this.showNodeResult(reviewProtocolData, versionJoin, candidateJoin)) continue;
            nodeResultJoins.add(candidateJoin);
        }
        nodeResultJoins.sort(new Comparator<ReviewProtocolVersionJoin>(){

            @Override
            public int compare(ReviewProtocolVersionJoin joinOne, ReviewProtocolVersionJoin joinTwo) {
                Integer positionOne = joinOne.getReviewCycleNodePosition();
                Integer positionTwo = joinTwo.getReviewCycleNodePosition();
                return (positionOne != null ? positionOne : 0) - (positionTwo != null ? positionTwo : 0);
            }
        });
        return nodeResultJoins;
    }

    private boolean showNodeResult(ReviewProtocolData reviewProtocolData, ReviewProtocolVersionJoin versionJoin, ReviewProtocolVersionJoin nodeResultJoin) {
        List versionJoins = reviewProtocolData.getVersionJoins();
        Long resultOptionId = nodeResultJoin.getReviewCycleNodeResultReviewCycleResultOptionId();
        Map idToResultOption = reviewProtocolData.getIdToResultOption();
        ReviewCycleResultOption resultOption = (ReviewCycleResultOption)idToResultOption.get(resultOptionId);
        Long nodeResultReviewCycleNodeId = nodeResultJoin.getReviewCycleNodeId();
        Long documentVersionId = nodeResultJoin.getDocumentVersionId();
        Long versionReviewCycleNodeId = versionJoin.getReviewCycleNodeId();
        boolean equalNodeIds = nodeResultReviewCycleNodeId != null && versionReviewCycleNodeId != null && nodeResultReviewCycleNodeId.longValue() == versionReviewCycleNodeId.longValue();
        DocumentVersionStatus documentVersionStatus = DocumentVersionStatus.getByValue((Integer)versionJoin.getDocumentVersionStatus());
        boolean documentVersionIsInAction = CodeHelper.isDocumentVersionStatusInAction(documentVersionStatus);
        boolean documentVersionIsDeleted = documentVersionStatus == DocumentVersionStatus.DELETED;
        boolean isLastVersion = this.isLastVersion(versionJoins, documentVersionId);
        return resultOptionId != null && resultOption.getValue() != -8 || resultOptionId == null && equalNodeIds && documentVersionIsInAction && !documentVersionIsDeleted && isLastVersion || resultOptionId == null && !isLastVersion || nodeResultJoin.isReviewCycleNodeFree() != false;
    }

    private String getVersionCaptionSuffix(List<ReviewProtocolVersionJoin> versionJoins, ReviewProtocolVersionJoin versionJoin, ResourceBundle resourceBundle) {
        String suffix = "";
        Long documentVersionId = versionJoin.getDocumentVersionId();
        DocumentVersionStatus documentVersionStatus = DocumentVersionStatus.getByValue((Integer)versionJoin.getDocumentVersionStatus());
        int revisedCount = this.getRevisedCount(versionJoins, documentVersionId);
        if (versionJoin.getDocumentVersionRevisedDocumentVersionId() != null && documentVersionStatus != DocumentVersionStatus.RELEASEDPOSITIV) {
            suffix = suffix + resourceBundle.getString("reviewProtocolVersionSectionCaptionRevisionSuffix");
        } else if (revisedCount > 0 && documentVersionStatus == DocumentVersionStatus.REPLACED) {
            suffix = suffix + resourceBundle.getString("reviewProtocolVersionSectionCaptionReplacedSuffix");
        } else if (versionJoin.getDocumentVersionReactivatedDocumentVersionId() != null) {
            suffix = suffix + resourceBundle.getString("reviewProtocolVersionSectionCaptionReactivedSuffix");
        }
        return suffix;
    }

    private void appendVersionCaption(List<ReviewProtocolVersionJoin> versionJoins, ReviewProtocolVersionJoin versionJoin, OfficeTextElement officeText, OdfContext context, ReviewProtocolLocalStyles localStyles, ResourceBundle resourceBundle, String userLocale, List<String> contentLocales) {
        String rawReviewCycleCellName = versionJoin.getReviewCycleCellName();
        String reviewCycleCellName = I18nHelper.getLocaleStringFromDatabase(rawReviewCycleCellName, userLocale, contentLocales);
        String versionPart = ReviewProtocolPdfExporter.getNonNull(versionJoin.getDocumentVersionVersionParta()) + ReviewProtocolPdfExporter.getNonNull(versionJoin.getDocumentVersionVersionPartSeperator()) + ReviewProtocolPdfExporter.getNonNull(versionJoin.getDocumentVersionVersionPartb());
        String suffix = this.getVersionCaptionSuffix(versionJoins, versionJoin, resourceBundle);
        String captionRaw = resourceBundle.getString("reviewProtocolVersionSectionCaption");
        String caption = MessageFormat.format(captionRaw, reviewCycleCellName, versionPart, suffix);
        String headingStyle = localStyles.getSuperHeadingStyle();
        String captionStyle = this.constructPageBreakStyle(context, headingStyle);
        TextFactory.constructTextHeaderNode((Node)officeText, (String)caption, (String)headingStyle, (Integer)2);
    }

    private void appendStatementResultList(Long documentVersionId, final ReviewProtocolData reviewProtocolData, OfficeTextElement officeText, OdfContext context, ReviewProtocolLocalStyles localStyles, final ResourceBundle resourceBundle, final String userLocale, final List<String> contentLocales) {
        Map documentVersionIdToCellConnectionResultJoins = reviewProtocolData.getDocumentVersionIdToCellConnectionResultJoins();
        if (!documentVersionIdToCellConnectionResultJoins.containsKey(documentVersionId)) {
            return;
        }
        List connectionResultJoins = (List)documentVersionIdToCellConnectionResultJoins.get(documentVersionId);
        if (connectionResultJoins.size() == 0) {
            return;
        }
        String subHeadingStyle = localStyles.getSubHeadingStyle();
        String caption = resourceBundle.getString("reviewProtocolVersionConnectionResultCaption");
        TextFactory.constructTextHeaderNode((Node)officeText, (String)caption, (String)subHeadingStyle, (Integer)3);
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        String tableUnderCaptionStyle = null;
        final Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        final String dataCellStyle = localStyles.getDataCellStyle();
        final String dataTextStyle = localStyles.getDataTextStyle();
        String dataTextStyleMedium = localStyles.getDataTextStyleMedium();
        final String dataTextStyleComment = localStyles.getDataTextStyleComment();
        ArrayList columns = new ArrayList();
        this.addResultPlannerColumn(columns, dataCellStyle, dataTextStyle, resourceBundle);
        this.addResultRealmColumn(columns, dataCellStyle, dataTextStyle, dataTextStyleMedium, resourceBundle, userLocale, contentLocales);
        columns.add((FancyOdfTableColumn<ReviewProtocolVersionJoin>)new FancyOdfTableColumn<ReviewProtocolVersionJoin>("date", resourceBundle.getString("reviewProtocolVersionConnectionResultDateCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                Double createdOne = versionJoinOne.getDestVersionCellConnectionResultResultDate();
                Double createdTwo = versionJoinTwo.getDestVersionCellConnectionResultResultDate();
                return ReviewProtocolPdfExporter.defaultDoubleCompare(createdOne, createdTwo, descending);
            }

            private String getOutput(ReviewProtocolVersionJoin versionJoin) {
                Double resultDate = versionJoin.getDestVersionCellConnectionResultResultDate();
                if (resultDate != null) {
                    String format = resourceBundle.getString("yearToSecondFormat");
                    return DateHelper.formatUtcSeconds(resultDate, "Europe/Vienna", format);
                }
                return "";
            }
        });
        columns.add((FancyOdfTableColumn<ReviewProtocolVersionJoin>)new FancyOdfTableColumn<ReviewProtocolVersionJoin>("comment", resourceBundle.getString("reviewProtocolVersionConnectionResultCommentCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                String comment = versionJoin.getConnectionResultStatementResultComment();
                if (comment == null) {
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyleComment, (TableTableRowElement)rowElement, (String[])new String[]{""});
                } else {
                    OdfFromHtmlConverter.convert((Node)cellElement, comment, dataTextStyleComment, contentAutomaticStyles);
                }
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = ReviewProtocolPdfExporter.getNonNull(versionJoinOne.getConnectionResultStatementResultComment());
                String s2 = ReviewProtocolPdfExporter.getNonNull(versionJoinTwo.getConnectionResultStatementResultComment());
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }
        });
        columns.add((FancyOdfTableColumn<ReviewProtocolVersionJoin>)new FancyOdfTableColumn<ReviewProtocolVersionJoin>("result", resourceBundle.getString("reviewProtocolVersionConnectionResultCommentCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyleComment, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = this.getOutput(versionJoinOne);
                String s2 = this.getOutput(versionJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin versionJoin) {
                Long resultOptionId = versionJoin.getConnectionResultStatementResultReviewCycleResultOptionId();
                if (resultOptionId == null) {
                    return "";
                }
                ReviewCycleResultOption resultOption = (ReviewCycleResultOption)reviewProtocolData.getIdToResultOption().get(resultOptionId);
                String rawResultOptionName = resultOption.getName();
                String resultOptionName = I18nHelper.getLocaleStringFromDatabase(rawResultOptionName, userLocale, contentLocales);
                return resultOptionName;
            }
        });
        HashMap<String, Double> relativeColumnWidths = new HashMap<String, Double>();
        relativeColumnWidths.put("planner", 0.25);
        relativeColumnWidths.put("realm", 0.15);
        relativeColumnWidths.put("date", 0.1);
        relativeColumnWidths.put("comment", 0.4);
        relativeColumnWidths.put("result", 0.1);
        ArrayList<ColumnSortSpec> columnSortSpecs = new ArrayList<ColumnSortSpec>();
        columnSortSpecs.add(new ColumnSortSpec("date", Boolean.valueOf(true)));
        Styles styles = context.getContentAutomaticStyles();
        FancyOdfTable table = ReviewProtocolPdfExporter.constructFancyTable(styles, localStyles, 23.9, columns, relativeColumnWidths);
        table.setTableStyle(tableUnderCaptionStyle);
        table.setRenderHeaderLine(true);
        table.render((Node)officeText, connectionResultJoins, columnSortSpecs);
    }

    private void appendEntryResultList(Long documentVersionId, final ReviewProtocolData reviewProtocolData, OfficeTextElement officeText, OdfContext context, ReviewProtocolLocalStyles localStyles, final ResourceBundle resourceBundle, final String userLocale, final List<String> contentLocales) {
        Map documentVersionIdToEntryResultJoins = reviewProtocolData.getDocumentVersionIdToEntryResultJoins();
        if (!documentVersionIdToEntryResultJoins.containsKey(documentVersionId)) {
            return;
        }
        List entryResultJoins = (List)documentVersionIdToEntryResultJoins.get(documentVersionId);
        if (entryResultJoins.size() == 0) {
            return;
        }
        String subHeadingStyle = localStyles.getSubHeadingStyle();
        String caption = resourceBundle.getString("reviewProtocolVersionConnectionResultCaption");
        TextFactory.constructTextHeaderNode((Node)officeText, (String)caption, (String)subHeadingStyle, (Integer)3);
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        String tableUnderCaptionStyle = null;
        final Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        final String dataCellStyle = localStyles.getDataCellStyle();
        final String dataTextStyle = localStyles.getDataTextStyle();
        String dataTextStyleMedium = localStyles.getDataTextStyleMedium();
        final String dataTextStyleComment = localStyles.getDataTextStyleComment();
        ArrayList columns = new ArrayList();
        this.addResultPlannerColumn(columns, dataCellStyle, dataTextStyle, resourceBundle);
        this.addResultRealmColumn(columns, dataCellStyle, dataTextStyle, dataTextStyleMedium, resourceBundle, userLocale, contentLocales);
        columns.add((FancyOdfTableColumn<ReviewProtocolVersionJoin>)new FancyOdfTableColumn<ReviewProtocolVersionJoin>("date", resourceBundle.getString("reviewProtocolVersionConnectionResultDateCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                Double createdOne = versionJoinOne.getReviewCycleEntryResultResultDate();
                Double createdTwo = versionJoinTwo.getReviewCycleEntryResultResultDate();
                return ReviewProtocolPdfExporter.defaultDoubleCompare(createdOne, createdTwo, descending);
            }

            private String getOutput(ReviewProtocolVersionJoin versionJoin) {
                Double resultDate = versionJoin.getReviewCycleEntryResultResultDate();
                if (resultDate != null) {
                    String format = resourceBundle.getString("yearToSecondFormat");
                    return DateHelper.formatUtcSeconds(resultDate, "Europe/Vienna", format);
                }
                return "";
            }
        });
        columns.add((FancyOdfTableColumn<ReviewProtocolVersionJoin>)new FancyOdfTableColumn<ReviewProtocolVersionJoin>("comment", resourceBundle.getString("reviewProtocolVersionConnectionResultCommentCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                String comment = versionJoin.getReviewCycleEntryStatementResultComment();
                if (comment == null) {
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyleComment, (TableTableRowElement)rowElement, (String[])new String[]{""});
                } else {
                    OdfFromHtmlConverter.convert((Node)cellElement, comment, dataTextStyleComment, contentAutomaticStyles);
                }
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = ReviewProtocolPdfExporter.getNonNull(versionJoinOne.getReviewCycleEntryStatementResultComment());
                String s2 = ReviewProtocolPdfExporter.getNonNull(versionJoinTwo.getReviewCycleEntryStatementResultComment());
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }
        });
        columns.add((FancyOdfTableColumn<ReviewProtocolVersionJoin>)new FancyOdfTableColumn<ReviewProtocolVersionJoin>("result", resourceBundle.getString("reviewProtocolVersionConnectionResultCommentCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyleComment, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = this.getOutput(versionJoinOne);
                String s2 = this.getOutput(versionJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin versionJoin) {
                Long resultOptionId = versionJoin.getReviewCycleEntryStatementResultReviewCycleResultOptionId();
                if (resultOptionId == null) {
                    return "";
                }
                ReviewCycleResultOption resultOption = (ReviewCycleResultOption)reviewProtocolData.getIdToResultOption().get(resultOptionId);
                String rawResultOptionName = resultOption.getName();
                String resultOptionName = I18nHelper.getLocaleStringFromDatabase(rawResultOptionName, userLocale, contentLocales);
                return resultOptionName;
            }
        });
        HashMap<String, Double> relativeColumnWidths = new HashMap<String, Double>();
        relativeColumnWidths.put("planner", 0.25);
        relativeColumnWidths.put("realm", 0.15);
        relativeColumnWidths.put("date", 0.1);
        relativeColumnWidths.put("comment", 0.4);
        relativeColumnWidths.put("result", 0.1);
        ArrayList<ColumnSortSpec> columnSortSpecs = new ArrayList<ColumnSortSpec>();
        columnSortSpecs.add(new ColumnSortSpec("date", Boolean.valueOf(true)));
        Styles styles = context.getContentAutomaticStyles();
        FancyOdfTable table = ReviewProtocolPdfExporter.constructFancyTable(styles, localStyles, 23.9, columns, relativeColumnWidths);
        table.setTableStyle(tableUnderCaptionStyle);
        table.setRenderHeaderLine(true);
        table.render((Node)officeText, entryResultJoins, columnSortSpecs);
    }

    private void addResultPlannerColumn(List<FancyOdfTableColumn<ReviewProtocolVersionJoin>> columns, final String dataCellStyle, final String dataTextStyle, final ResourceBundle resourceBundle) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("planner", resourceBundle.getString("reviewProtocolVersionPlannerCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                String nameString = ReviewProtocolPdfExporter.this.getPositionPersonWithOrganisationString(versionJoin);
                TextFactory.constructTextNode((Node)cellElement, (String)nameString, (String)dataTextStyle);
                if (!versionJoin.isPositionParticipantMainParticipantFlag().booleanValue() || versionJoin.isPositionParticipantInactiveFlag().booleanValue()) {
                    String deputyString = "";
                    if (!versionJoin.getPositionOrganisationId().equals(versionJoin.getPositionMainOrganisationId())) {
                        deputyString = ReviewProtocolPdfExporter.this.getPositionMainPersonWithOrganisationDebString(versionJoin, resourceBundle);
                    } else if (!versionJoin.getPositionPersonId().equals(versionJoin.getPositionMainPersonId())) {
                        deputyString = ReviewProtocolPdfExporter.this.getPositionMainPersonDebString(versionJoin, resourceBundle);
                    }
                    TextFactory.constructTextNode((Node)cellElement, (String)deputyString, (String)dataTextStyle);
                }
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = ReviewProtocolPdfExporter.this.getPositionPersonWithOrganisationString(versionJoinOne);
                String s2 = ReviewProtocolPdfExporter.this.getPositionPersonWithOrganisationString(versionJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }
        });
    }

    private void addResultRealmColumn(List<FancyOdfTableColumn<ReviewProtocolVersionJoin>> columns, final String dataCellStyle, final String codeTextStyle, final String nameTextStyle, ResourceBundle resourceBundle, final String userLocale, final List<String> contentLocales) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("realm", resourceBundle.getString("reviewProtocolVersionRealmCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                if (versionJoin.getRealmCode() != null) {
                    TextFactory.constructTextNode((Node)cellElement, (String)versionJoin.getRealmCode(), (String)codeTextStyle);
                }
                if (versionJoin.getRealmName() != null) {
                    String rawRealmName = versionJoin.getRealmName();
                    String realmName = I18nHelper.getLocaleStringFromDatabase(rawRealmName, userLocale, contentLocales);
                    TextFactory.constructTextNode((Node)cellElement, (String)realmName, (String)nameTextStyle);
                }
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = (versionJoinOne.getRealmCode() != null ? versionJoinOne.getRealmCode() : "") + (versionJoinOne.getRealmName() != null ? versionJoinOne.getRealmName() : "");
                String s2 = (versionJoinTwo.getRealmCode() != null ? versionJoinTwo.getRealmCode() : "") + (versionJoinTwo.getRealmName() != null ? versionJoinTwo.getRealmName() : "");
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }
        });
    }

    private void appendInvalidatedList(Long documentVersionId, final ReviewProtocolData reviewProtocolData, ReviewProtocolVersionJoin versionJoin, OfficeTextElement officeText, OdfContext context, ReviewProtocolLocalStyles localStyles, final ResourceBundle resourceBundle, final String userLocale, final List<String> contentLocales) {
        List<ReviewProtocolVersionJoin> invalidationResultJoins = this.getInvalidationResultJoins(reviewProtocolData, documentVersionId);
        if (!this.isInvalidated(invalidationResultJoins, versionJoin)) {
            return;
        }
        String subHeadingStyle = localStyles.getSubHeadingStyle();
        String caption = this.getInvalidationCaption(versionJoin, resourceBundle);
        TextFactory.constructTextHeaderNode((Node)officeText, (String)caption, (String)subHeadingStyle, (Integer)3);
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        String tableUnderCaptionStyle = null;
        final String dataCellStyle = localStyles.getDataCellStyle();
        final String dataTextStyle = localStyles.getDataTextStyle();
        final String dataTextStyleComment = localStyles.getDataTextStyleComment();
        final Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        ArrayList columns = new ArrayList();
        this.addResultPlannerColumn(columns, dataCellStyle, dataTextStyle, resourceBundle);
        columns.add((FancyOdfTableColumn<ReviewProtocolVersionJoin>)new FancyOdfTableColumn<ReviewProtocolVersionJoin>("date", resourceBundle.getString("reviewProtocolVersionConnectionResultDateCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                Double createdOne = versionJoinOne.getReviewCyclePositionResultResultDate();
                Double createdTwo = versionJoinTwo.getReviewCyclePositionResultResultDate();
                return ReviewProtocolPdfExporter.defaultDoubleCompare(createdOne, createdTwo, descending);
            }

            private String getOutput(ReviewProtocolVersionJoin versionJoin) {
                Double resultDate = versionJoin.getReviewCyclePositionResultResultDate();
                if (resultDate != null) {
                    String format = resourceBundle.getString("yearToSecondFormat");
                    return DateHelper.formatUtcSeconds(resultDate, "Europe/Vienna", format);
                }
                return "";
            }
        });
        columns.add((FancyOdfTableColumn<ReviewProtocolVersionJoin>)new FancyOdfTableColumn<ReviewProtocolVersionJoin>("comment", resourceBundle.getString("reviewProtocolVersionConnectionResultCommentCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                String comment = versionJoin.getReviewCyclePositionResultComment();
                if (comment != null) {
                    OdfFromHtmlConverter.convert((Node)cellElement, comment, dataTextStyleComment, contentAutomaticStyles);
                }
                if (versionJoin.isReviewCyclePositionResultIsAuthorized().booleanValue()) {
                    String authorizedString = resourceBundle.getString("reviewCyclePositionResultAuthorized");
                    TextFactory.constructTextNode((Node)cellElement, (String)authorizedString, (String)dataTextStyleComment);
                }
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = ReviewProtocolPdfExporter.getNonNull(versionJoinOne.getReviewCyclePositionResultComment());
                String s2 = ReviewProtocolPdfExporter.getNonNull(versionJoinTwo.getReviewCyclePositionResultComment());
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }
        });
        columns.add((FancyOdfTableColumn<ReviewProtocolVersionJoin>)new FancyOdfTableColumn<ReviewProtocolVersionJoin>("result", resourceBundle.getString("reviewProtocolInvalidationResultTypeCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = this.getOutput(versionJoinOne);
                String s2 = this.getOutput(versionJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin versionJoin) {
                Long resultOptionId = versionJoin.getReviewCyclePositionResultReviewCycleResultOptionId();
                ReviewCycleResultOption resultOption = (ReviewCycleResultOption)reviewProtocolData.getIdToResultOption().get(resultOptionId);
                String rawResultOptionName = resultOption.getName();
                String resultOptionName = I18nHelper.getLocaleStringFromDatabase(rawResultOptionName, userLocale, contentLocales);
                return resultOptionName;
            }
        });
        HashMap<String, Double> relativeColumnWidths = new HashMap<String, Double>();
        relativeColumnWidths.put("planner", 0.25);
        relativeColumnWidths.put("date", 0.1);
        relativeColumnWidths.put("comment", 0.55);
        relativeColumnWidths.put("result", 0.1);
        ArrayList<ColumnSortSpec> columnSortSpecs = new ArrayList<ColumnSortSpec>();
        columnSortSpecs.add(new ColumnSortSpec("date", Boolean.valueOf(true)));
        Styles styles = context.getContentAutomaticStyles();
        FancyOdfTable table = ReviewProtocolPdfExporter.constructFancyTable(styles, localStyles, 23.9, columns, relativeColumnWidths);
        table.setTableStyle(tableUnderCaptionStyle);
        table.setRenderHeaderLine(true);
        table.render((Node)officeText, invalidationResultJoins, columnSortSpecs);
    }

    private List<ReviewProtocolVersionJoin> getPositionResultJoinsByDocumentVersionId(ReviewProtocolData reviewProtocolData, Long documentVersionId) {
        ArrayList<ReviewProtocolVersionJoin> positionResultJoins = new ArrayList<ReviewProtocolVersionJoin>();
        Map cellResultIdToNodeResultIdToNodeResult = reviewProtocolData.getCellResultIdToNodeResultIdToNodeResult();
        Map nodeResultIdToPositionResultIdToPositionResult = reviewProtocolData.getNodeResultIdToPositionResultIdToPositionResult();
        Map documentVersionIdToCellResultIds = reviewProtocolData.getDocumentVersionIdToCellResultIds();
        Set cellResultIds = (Set)documentVersionIdToCellResultIds.get(documentVersionId);
        for (Long cellResultId : cellResultIds) {
            if (!cellResultIdToNodeResultIdToNodeResult.containsKey(cellResultId)) continue;
            Map nodeResultIdToJoin = (Map)cellResultIdToNodeResultIdToNodeResult.get(cellResultId);
            for (Long nodeResultId : nodeResultIdToJoin.keySet()) {
                if (!nodeResultIdToPositionResultIdToPositionResult.containsKey(nodeResultId)) continue;
                Map positionResultIdToJoin = (Map)nodeResultIdToPositionResultIdToPositionResult.get(nodeResultId);
                positionResultJoins.addAll(positionResultIdToJoin.values());
            }
        }
        return positionResultJoins;
    }

    private List<ReviewProtocolVersionJoin> getInvalidationResultJoins(ReviewProtocolData reviewProtocolData, Long documentVersionId) {
        ArrayList<ReviewProtocolVersionJoin> invalidationResultJoins = new ArrayList<ReviewProtocolVersionJoin>();
        Map idToResultOption = reviewProtocolData.getIdToResultOption();
        List<ReviewProtocolVersionJoin> positionResultJoins = this.getPositionResultJoinsByDocumentVersionId(reviewProtocolData, documentVersionId);
        for (ReviewProtocolVersionJoin positionResultJoin : positionResultJoins) {
            ReviewCycleResultOption resultOption;
            Long resultOptionId = positionResultJoin.getReviewCyclePositionResultReviewCycleResultOptionId();
            if (resultOptionId == null || (resultOption = (ReviewCycleResultOption)idToResultOption.get(resultOptionId)).getValue() == null || resultOption.getValue() >= -8) continue;
            invalidationResultJoins.add(positionResultJoin);
        }
        return invalidationResultJoins;
    }

    private boolean isInvalidated(List<ReviewProtocolVersionJoin> invalidationResults, ReviewProtocolVersionJoin versionJoin) {
        DocumentVersionStatus documentVersionStatus = DocumentVersionStatus.getByValue((Integer)versionJoin.getDocumentVersionStatus());
        return (documentVersionStatus == DocumentVersionStatus.INVALIDATEDVERSION || documentVersionStatus != DocumentVersionStatus.INVALIDATEDALL || documentVersionStatus != DocumentVersionStatus.DELETED || documentVersionStatus != DocumentVersionStatus.REPLACED || documentVersionStatus != DocumentVersionStatus.ABORTED) && invalidationResults.size() > 0;
    }

    private String getInvalidationCaption(ReviewProtocolVersionJoin versionJoin, ResourceBundle resourceBundle) {
        DocumentVersionStatus documentVersionStatus = DocumentVersionStatus.getByValue((Integer)versionJoin.getDocumentVersionStatus());
        if (documentVersionStatus == DocumentVersionStatus.DELETED) {
            return resourceBundle.getString("reviewProtocolVersionDocumentDeletedCaption");
        }
        if (documentVersionStatus == DocumentVersionStatus.ABORTED) {
            return resourceBundle.getString("reviewProtocolVersionReviewAbortedCaption");
        }
        return resourceBundle.getString("reviewProtocolVersionInvalidDocumentCaption");
    }

    private static String getAttachmentImagePath(Attachment attachment) {
        if (attachment.isIsRedliningDelta().booleanValue()) {
            return "export/icons/redlining.gif";
        }
        return "export/icons/attachment.gif";
    }

    private void appendAttachmentIconsToCell(TableTableCellElement cellElement, ReviewProtocolVersionJoin versionJoin, ReviewProtocolData reviewProtocolData, OdfContext context, ArchiveScope archiveScope, ResourceBundle resourceBundle) {
        List attachments;
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        Styles stylesStyles = context.getStylesOfficeStyles();
        String frameContentsStyle = stylesStyles.getParagraphStyleWithParent(stylesStyles.getParagraphStyleWithClass("text", new OdfStylePropertiesBase[0]), "extra", new OdfStylePropertiesBase[0]);
        TextPElement innerPElement = TextFactory.constructTextNode((Node)cellElement, null, (String)frameContentsStyle);
        Long positionResultId = versionJoin.getReviewCyclePositionResultId();
        Map positionResultIdToAttachments = reviewProtocolData.getPositionResultIdToAttachments();
        List list = attachments = positionResultId != null ? (List)positionResultIdToAttachments.get(positionResultId) : null;
        if (attachments == null) {
            return;
        }
        for (Attachment attachment : attachments) {
            String attachmentImageFrameStyle = contentAutomaticStyles.getGraphicStyleWithParent(stylesStyles.getGraphicStyle(new OdfStylePropertiesBase[]{FrameFactory.constructImageFrameParentProperties((Styles)stylesStyles)}), new OdfStylePropertiesBase[]{FrameFactory.constructImageFrameProperties((Styles)contentAutomaticStyles)});
            TextPElement drawFrameParent = null;
            String attachmentUrl = this.getAttachmentUrl(archiveScope, versionJoin, reviewProtocolData, attachment, resourceBundle);
            if (attachmentUrl != null) {
                DrawAElement attachmentAElement = (DrawAElement)((OdfFileDom)innerPElement.getOwnerDocument()).newOdfElement(DrawAElement.class);
                attachmentAElement.setXlinkTypeAttribute("simple");
                attachmentAElement.setXlinkHrefAttribute(attachmentUrl);
                innerPElement.appendChild((Node)attachmentAElement);
                drawFrameParent = attachmentAElement;
            } else {
                drawFrameParent = innerPElement;
            }
            DrawFrameElement attachmentInnerFrame = FrameFactory.constructDrawFrameNode((Node)drawFrameParent, (String)attachmentImageFrameStyle, (String)"as-char", null, null, (String)"0.5cm", (String)"0.5cm", (Integer)0);
            String path = ReviewProtocolPdfExporter.getAttachmentImagePath(attachment);
            try {
                ClassLoader classLoader = PlanningReportHelper.class.getClassLoader();
                URL ampelUrl = classLoader.getResource(path);
                URI ampelUri = ampelUrl.toURI();
                OdfDrawImage image = (OdfDrawImage)attachmentInnerFrame.newDrawImageElement();
                image.setXlinkShowAttribute("embed");
                image.setXlinkActuateAttribute("onLoad");
                image.newImage(ampelUri);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void appendNodeResultSection(ReviewProtocolVersionJoin nodeResultJoin, final ReviewProtocolData reviewProtocolData, final ArchiveScope archiveScope, OfficeTextElement officeText, final OdfContext context, ReviewProtocolLocalStyles localStyles, final ResourceBundle resourceBundle, final String userLocale, final List<String> contentLocales) {
        String headingStyle = localStyles.getHeadingStyle();
        String captionStyle = this.constructPageBreakStyle(context, headingStyle);
        String caption = I18nHelper.getLocaleString(nodeResultJoin.getReviewCycleNodeName(), this.userLocale);
        TextFactory.constructTextHeaderNode((Node)officeText, (String)caption, (String)headingStyle, (Integer)2);
        String dataTextStyleMedium = localStyles.getDataTextStyleMedium();
        String intervalDataTextStyle = localStyles.getIntervalDataTextStyle();
        String dateFormat = resourceBundle.getString("yearToSecondFormat");
        Double arrivalDate = nodeResultJoin.getReviewCycleNodeResultArrivalDate();
        String arrivalString = arrivalDate != null ? DateHelper.formatUtcSeconds(arrivalDate, "Europe/Vienna", dateFormat) : "";
        Double departureDate = nodeResultJoin.getReviewCycleNodeResultDepartureDate();
        String departureString = departureDate != null ? DateHelper.formatUtcSeconds(departureDate, "Europe/Vienna", dateFormat) : "";
        String intervalString = MessageFormat.format(resourceBundle.getString("reviewProtocolNodeInterval"), arrivalString, departureString);
        TextFactory.constructTextNode((Node)officeText, (String)intervalString, (String)intervalDataTextStyle);
        Long documentVersionId = nodeResultJoin.getDocumentVersionId();
        Long nodeResultId = nodeResultJoin.getReviewCycleNodeResultId();
        Long nodeResultNodeId = nodeResultJoin.getReviewCycleNodeId();
        final Map idToResultOption = reviewProtocolData.getIdToResultOption();
        List<ReviewProtocolVersionJoin> positionResultJoins = this.getPositionResultJoinsByNodeResultId(reviewProtocolData, documentVersionId, nodeResultId, nodeResultNodeId);
        if (positionResultJoins.size() == 0) {
            this.appendNoEntriesTable(officeText, context, localStyles, resourceBundle);
            return;
        }
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        String tableUnderCaptionStyle = null;
        final String dataCellStyle = localStyles.getDataCellStyle();
        final String dataTextStyle = localStyles.getDataTextStyle();
        final String dataTextStyleBold = localStyles.getDataTextStyleBold();
        String dataTextStyleComment = localStyles.getDataTextStyleComment();
        final Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        Styles stylesStyles = context.getStylesOfficeStyles();
        ArrayList columns = new ArrayList();
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("reviewer", resourceBundle.getString("reviewProtocolPositionReviewerCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin positionJoin) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                ReviewProtocolBaseJoin baseJoin = reviewProtocolData.getBaseJoin();
                if (ReviewProtocolPdfExporter.this.isPositionResultJoin(positionJoin)) {
                    String label;
                    String nameString = ReviewProtocolPdfExporter.this.getPositionPersonWithOrganisationString(positionJoin);
                    TextFactory.constructTextNode((Node)cellElement, (String)nameString, (String)dataTextStyle);
                    if (positionJoin.getReviewCyclePositionResultSignatureId() != null && (!positionJoin.isPositionParticipantMainParticipantFlag().booleanValue() || positionJoin.isPositionParticipantInactiveFlag().booleanValue())) {
                        String deputyString = "";
                        if (!positionJoin.getPositionOrganisationId().equals(positionJoin.getPositionMainOrganisationId())) {
                            deputyString = ReviewProtocolPdfExporter.this.getPositionMainPersonWithOrganisationDebString(positionJoin, resourceBundle);
                        } else if (!positionJoin.getPositionPersonId().equals(positionJoin.getPositionMainPersonId())) {
                            deputyString = ReviewProtocolPdfExporter.this.getPositionMainPersonDebString(positionJoin, resourceBundle);
                        }
                        TextFactory.constructTextNode((Node)cellElement, (String)deputyString, (String)dataTextStyle);
                    }
                    if (positionJoin.getAttachedPositionResultId() != null) {
                        label = resourceBundle.getString("reviewProtocolPositionAttachedReviewLabel");
                        TextFactory.constructTextNode((Node)cellElement, (String)label, (String)dataTextStyle);
                    } else if (baseJoin.isSubProjectWithAdditionalRoleTypes().booleanValue() && positionJoin.getReviewCycleNodeRoleTypeId() != null && positionJoin.getPositionRoleTypeId() != null && positionJoin.getReviewCycleNodeRoleTypeId().longValue() != positionJoin.getPositionRoleTypeId().longValue()) {
                        label = "[" + positionJoin.getPositionRoleName() + "]";
                        TextFactory.constructTextNode((Node)cellElement, (String)label, (String)dataTextStyle);
                    }
                } else {
                    String nameString = ReviewProtocolPdfExporter.this.getPositionMainPersonWithOrganisationString(positionJoin);
                    TextFactory.constructTextNode((Node)cellElement, (String)nameString, (String)dataTextStyle);
                    if (positionJoin.getAttachedNodePositionId() != null) {
                        String label = resourceBundle.getString("reviewProtocolPositionAttachedReviewLabel");
                        TextFactory.constructTextNode((Node)cellElement, (String)label, (String)dataTextStyle);
                    } else if (baseJoin.getSubProjectWithAdditionalRoleTypes() != null && positionJoin.getRoleTypeId() != null && positionJoin.getPositionRoleTypeId() != null && positionJoin.getRoleTypeId().longValue() != positionJoin.getPositionRoleTypeId().longValue()) {
                        String label = "[" + positionJoin.getPositionRoleName() + "]";
                        TextFactory.constructTextNode((Node)cellElement, (String)label, (String)dataTextStyle);
                    }
                }
            }

            public int compare(ReviewProtocolVersionJoin positionJoinOne, ReviewProtocolVersionJoin positionJoinTwo, boolean descending) {
                String s1 = ReviewProtocolPdfExporter.this.getPositionPersonWithOrganisationString(positionJoinOne);
                String s2 = ReviewProtocolPdfExporter.this.getPositionPersonWithOrganisationString(positionJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }
        });
        this.addResultRealmColumn(columns, dataCellStyle, dataTextStyle, dataTextStyleMedium, resourceBundle, userLocale, contentLocales);
        columns.add((FancyOdfTableColumn<ReviewProtocolVersionJoin>)new FancyOdfTableColumn<ReviewProtocolVersionJoin>("date", resourceBundle.getString("reviewProtocolVersionConnectionResultDateCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                Double createdOne = versionJoinOne.getReviewCyclePositionResultResultDate();
                Double createdTwo = versionJoinTwo.getReviewCyclePositionResultResultDate();
                return ReviewProtocolPdfExporter.defaultDoubleCompare(createdOne, createdTwo, descending);
            }

            private String getOutput(ReviewProtocolVersionJoin positionJoin) {
                if (ReviewProtocolPdfExporter.this.isPositionResultJoin(positionJoin)) {
                    Double resultDate = positionJoin.getReviewCyclePositionResultResultDate();
                    if (positionJoin.getReviewCyclePositionResultSignatureId() != null && resultDate != null) {
                        String format = resourceBundle.getString("yearToSecondFormat");
                        return DateHelper.formatUtcSeconds(resultDate, "Europe/Vienna", format);
                    }
                    return "";
                }
                return "";
            }
        });
        columns.add((FancyOdfTableColumn<ReviewProtocolVersionJoin>)new FancyOdfTableColumn<ReviewProtocolVersionJoin>("review", resourceBundle.getString("reviewProtocolPositionReviewCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin positionJoin) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                if (positionJoin.getReviewCyclePositionResultSignatureId() != null) {
                    ReviewCycleResultOption resultOption;
                    Long resultOptionId = positionJoin.getReviewCycleNodeResultReviewCycleResultOptionId();
                    ReviewCycleResultOption reviewCycleResultOption = resultOption = resultOptionId != null ? (ReviewCycleResultOption)idToResultOption.get(resultOptionId) : null;
                    if (resultOption != null && resultOption.getValue() != null && resultOption.getValue() == -7) {
                        TextFactory.constructTextNode((Node)cellElement, (String)resourceBundle.getString("reviewProtocolPositionNotReviewedLabel"), (String)dataTextStyleBold);
                    }
                    if (positionJoin.getPositionOverridingPersonId() != null) {
                        String overridingPersonString = this.getOverridingPersonString(positionJoin);
                        String overridingLabel = MessageFormat.format(resourceBundle.getString("reviewProtocolPositionOverridingLabel"), overridingPersonString);
                        TextFactory.constructTextNode((Node)cellElement, (String)resourceBundle.getString("reviewProtocolPositionNotReviewedLabel"), (String)dataTextStyleBold);
                    }
                    String comment = positionJoin.getReviewCyclePositionResultComment();
                    String saveComment = ReviewProtocolPdfExporter.this.utilService.getSafeHtml(comment, true);
                    if (saveComment != null) {
                        OdfFromHtmlConverter.convert((Node)cellElement, saveComment, dataTextStyle, contentAutomaticStyles);
                    }
                }
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = versionJoinOne.getReviewCyclePositionResultComment();
                String s2 = versionJoinTwo.getReviewCyclePositionResultComment();
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOverridingPersonString(ReviewProtocolVersionJoin versionJoin) {
                return PersonHelper.getCommonName(versionJoin.getPositionOverridingPerson());
            }
        });
        columns.add((FancyOdfTableColumn<ReviewProtocolVersionJoin>)new FancyOdfTableColumn<ReviewProtocolVersionJoin>("attachments", ""){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin commentResultJoin) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                ReviewProtocolPdfExporter.this.appendAttachmentIconsToCell(cellElement, commentResultJoin, reviewProtocolData, context, archiveScope, resourceBundle);
            }

            public int compare(ReviewProtocolVersionJoin oebbCommentJoinOne, ReviewProtocolVersionJoin oebbCommentJoinTwo, boolean descending) {
                return 0;
            }
        });
        columns.add((FancyOdfTableColumn<ReviewProtocolVersionJoin>)new FancyOdfTableColumn<ReviewProtocolVersionJoin>("result", resourceBundle.getString("reviewProtocolPositionResultCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = this.getOutput(versionJoinOne);
                String s2 = this.getOutput(versionJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin positionJoin) {
                ReviewCycleResultOption resultOption;
                Long resultOptionId = positionJoin.getReviewCyclePositionResultReviewCycleResultOptionId();
                ReviewCycleResultOption reviewCycleResultOption = resultOption = resultOptionId != null ? (ReviewCycleResultOption)idToResultOption.get(resultOptionId) : null;
                if (positionJoin.getReviewCyclePositionResultSignatureId() != null && resultOption != null && resultOption.getName() != null) {
                    String rawResultOptionName = resultOption.getName();
                    String resultOptionName = I18nHelper.getLocaleStringFromDatabase(rawResultOptionName, userLocale, contentLocales);
                    return resultOptionName;
                }
                return "";
            }
        });
        HashMap<String, Double> relativeColumnWidths = new HashMap<String, Double>();
        relativeColumnWidths.put("reviewer", 0.25);
        relativeColumnWidths.put("realm", 0.2);
        relativeColumnWidths.put("date", 0.08);
        relativeColumnWidths.put("review", 0.34);
        relativeColumnWidths.put("attachments", 0.05);
        relativeColumnWidths.put("result", 0.08);
        ArrayList<ColumnSortSpec> columnSortSpecs = new ArrayList<ColumnSortSpec>();
        columnSortSpecs.add(new ColumnSortSpec("date", Boolean.valueOf(true)));
        Styles styles = context.getContentAutomaticStyles();
        FancyOdfTable table = ReviewProtocolPdfExporter.constructFancyTable(styles, localStyles, 23.9, columns, relativeColumnWidths);
        table.setTableStyle(tableUnderCaptionStyle);
        table.setRenderHeaderLine(true);
        table.render((Node)officeText, positionResultJoins, columnSortSpecs);
    }

    private List<ReviewProtocolVersionJoin> getPositionResultJoinsByNodeResultId(ReviewProtocolData reviewProtocolData, Long documentVersionId, Long nodeResultId, Long nodeResultNodeId) {
        Map nodeResultIdToPositionResultIdToPositionResultJoin = reviewProtocolData.getNodeResultIdToPositionResultIdToPositionResult();
        Map positionResultIdToPositionResultJoin = (Map)nodeResultIdToPositionResultIdToPositionResultJoin.get(nodeResultId);
        ArrayList positionResultJoins = new ArrayList();
        ArrayList<ReviewProtocolVersionJoin> positionResultWithEmptyPositionsJoins = new ArrayList<ReviewProtocolVersionJoin>();
        if (positionResultIdToPositionResultJoin != null) {
            positionResultJoins.addAll(positionResultIdToPositionResultJoin.values());
        }
        final Map idToPositionResultJoin = reviewProtocolData.getIdToPositionResultJoin();
        Collections.sort(positionResultJoins, new Comparator<ReviewProtocolVersionJoin>(){

            @Override
            public int compare(ReviewProtocolVersionJoin joinOne, ReviewProtocolVersionJoin joinTwo) {
                Long commentReferenceIdTwo;
                Long commentReferenceIdOne = joinOne.getReviewCyclePositionResultCommentReferenceId();
                if (commentReferenceIdOne != null) {
                    joinOne = (ReviewProtocolVersionJoin)idToPositionResultJoin.get(commentReferenceIdOne);
                }
                if ((commentReferenceIdTwo = joinTwo.getReviewCyclePositionResultCommentReferenceId()) != null) {
                    joinTwo = (ReviewProtocolVersionJoin)idToPositionResultJoin.get(commentReferenceIdTwo);
                }
                Double resultDateOne = joinOne.getReviewCyclePositionResultResultDate();
                Double resultDateTwo = joinTwo.getReviewCyclePositionResultResultDate();
                if (resultDateOne == null) {
                    resultDateOne = 0.0;
                }
                if (resultDateTwo == null) {
                    resultDateTwo = 0.0;
                }
                if (resultDateOne < resultDateTwo) {
                    return -1;
                }
                if (resultDateOne > resultDateTwo) {
                    return 1;
                }
                return 0;
            }
        });
        Map documentVersionIdToNodePositionJoins = reviewProtocolData.getDocumentVersionIdToNodePositionJoins();
        List nodePositionJoins = (List)documentVersionIdToNodePositionJoins.get(documentVersionId);
        Map documentVersionIdToAttachedNodePositionJoins = reviewProtocolData.getDocumentVersionIdToAttachedNodePositionJoins();
        List attachedNodePositionJoins = (List)documentVersionIdToAttachedNodePositionJoins.get(documentVersionId);
        Map idToResultOption = reviewProtocolData.getIdToResultOption();
        for (ReviewProtocolVersionJoin positionResultJoin : positionResultJoins) {
            Long signatureId = positionResultJoin.getReviewCyclePositionResultSignatureId();
            Long resultOptionId = positionResultJoin.getReviewCyclePositionResultReviewCycleResultOptionId();
            ReviewCycleResultOption resultOption = (ReviewCycleResultOption)idToResultOption.get(resultOptionId);
            if (signatureId == null || resultOption == null || resultOption.getValue() == null || resultOption.getValue() <= -9) continue;
            positionResultWithEmptyPositionsJoins.add(positionResultJoin);
        }
        if (nodePositionJoins != null) {
            positionResultWithEmptyPositionsJoins.addAll(this.getRelevantPositionJoins(nodePositionJoins, positionResultWithEmptyPositionsJoins, nodeResultNodeId, false));
        }
        if (attachedNodePositionJoins != null) {
            positionResultWithEmptyPositionsJoins.addAll(this.getRelevantPositionJoins(attachedNodePositionJoins, positionResultWithEmptyPositionsJoins, nodeResultNodeId, true));
        }
        return positionResultWithEmptyPositionsJoins;
    }

    private List<ReviewProtocolVersionJoin> getRelevantPositionJoins(List<ReviewProtocolVersionJoin> nodePositionJoins, List<ReviewProtocolVersionJoin> positionResultJoins, Long nodeResultNodeId, boolean attachedNodePositions) {
        ArrayList<ReviewProtocolVersionJoin> positionResultWithEmptyPositionsJoins = new ArrayList<ReviewProtocolVersionJoin>();
        for (ReviewProtocolVersionJoin nodePositionJoin : nodePositionJoins) {
            Long nodePositionParticipationId;
            Long nodePositionNodeId = nodePositionJoin.getReviewCycleNodeId();
            Long nodePositionRealmId = attachedNodePositions ? nodePositionJoin.getAttachedNodePositionRealmId() : nodePositionJoin.getNodePositionRealmId();
            Long l = nodePositionParticipationId = attachedNodePositions ? nodePositionJoin.getAttachedNodePositionProjectParticipationId() : nodePositionJoin.getNodePositionProjectParticipationId();
            if (!nodePositionNodeId.equals(nodeResultNodeId)) continue;
            boolean positionResultFound = false;
            for (ReviewProtocolVersionJoin positionResultJoin : positionResultJoins) {
                Long positionResultRealmId = positionResultJoin.getReviewCyclePositionResultRealmId();
                Long positionResultParticipationId = positionResultJoin.getPositionParticipantParticipationId();
                positionResultFound |= nodePositionRealmId.equals(positionResultRealmId) && nodePositionParticipationId.equals(positionResultParticipationId);
            }
            if (positionResultFound) continue;
            positionResultWithEmptyPositionsJoins.add(nodePositionJoin);
        }
        return positionResultWithEmptyPositionsJoins;
    }

    private boolean isPositionResultJoin(ReviewProtocolVersionJoin positionJoin) {
        return positionJoin.getReviewCyclePositionResultId() != null;
    }

    private void appendOebbCommentSection(ReviewProtocolVersionJoin nodeResultJoin, ReviewProtocolData reviewProtocolData, OfficeTextElement officeText, OdfContext context, ReviewProtocolLocalStyles localStyles, final ResourceBundle resourceBundle) {
        Long nodeResultId = nodeResultJoin.getReviewCycleNodeResultId();
        String reviewer = nodeResultJoin.getPositionOrganisationName() + " (" + nodeResultJoin.getPositionPersonSurName() + " " + nodeResultJoin.getPositionPersonGivenName() + ")";
        String format = resourceBundle.getString("yearToSecondFormat");
        String reviewDate = nodeResultJoin.getReviewCycleNodeResultDepartureDate() != null ? DateHelper.formatUtcSeconds(nodeResultJoin.getReviewCycleNodeResultDepartureDate(), "Europe/Vienna", format) : "";
        Map nodeResultIdToOebbCommentJoins = reviewProtocolData.getNodeResultIdToOebbCommentJoins();
        List oebbCommentJoins = (List)nodeResultIdToOebbCommentJoins.get(nodeResultId);
        if (oebbCommentJoins == null) {
            return;
        }
        String headingStyle = localStyles.getHeadingStyle();
        final String dataTextStyle = localStyles.getDataTextStyle();
        String captionRaw = resourceBundle.getString("reviewProtocolOebbCommentCaption");
        String nodeName = I18nHelper.getLocaleString(nodeResultJoin.getReviewCycleNodeName(), this.userLocale);
        String caption = MessageFormat.format(captionRaw, reviewer + " " + reviewDate);
        TextFactory.constructTextNode((Node)officeText, (String)caption, (String)dataTextStyle);
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        String tableUnderCaptionStyle = null;
        final String dataCellStyle = localStyles.getDataCellStyle();
        final String dataTextStyleComment = localStyles.getDataTextStyleComment();
        ArrayList columns = new ArrayList();
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("reviewer", resourceBundle.getString("reviewProtocolOebbCommentReviewerCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin oebbCommentJoinOne, ReviewProtocolVersionJoin oebbCommentJoinTwo, boolean descending) {
                String s1 = this.getOutput(oebbCommentJoinOne);
                String s2 = this.getOutput(oebbCommentJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin oebbCommentJoin) {
                String reviewer = oebbCommentJoin.getOebbCommentReviewer();
                return reviewer != null ? reviewer : "";
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("realm", resourceBundle.getString("reviewProtocolOebbCommentRealmCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin oebbCommentJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(oebbCommentJoin)});
            }

            public int compare(ReviewProtocolVersionJoin oebbCommentJoinOne, ReviewProtocolVersionJoin oebbCommentJoinTwo, boolean descending) {
                String s1 = this.getOutput(oebbCommentJoinOne);
                String s2 = this.getOutput(oebbCommentJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin oebbCommentJoin) {
                String realm = oebbCommentJoin.getOebbCommentRealm();
                return realm != null ? realm : "";
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("comment", resourceBundle.getString("reviewProtocolOebbCommentCommentCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin oebbCommentJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyleComment, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(oebbCommentJoin)});
            }

            public int compare(ReviewProtocolVersionJoin oebbCommentJoinOne, ReviewProtocolVersionJoin oebbCommentJoinTwo, boolean descending) {
                String s1 = this.getOutput(oebbCommentJoinOne);
                String s2 = this.getOutput(oebbCommentJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin oebbCommentJoin) {
                String comment = oebbCommentJoin.getOebbCommentComment();
                return comment != null ? comment : "";
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("result", resourceBundle.getString("reviewProtocolOebbCommentResultCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin oebbCommentJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyleComment, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(oebbCommentJoin)});
            }

            public int compare(ReviewProtocolVersionJoin oebbCommentJoinOne, ReviewProtocolVersionJoin oebbCommentJoinTwo, boolean descending) {
                String s1 = this.getOutput(oebbCommentJoinOne);
                String s2 = this.getOutput(oebbCommentJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin oebbCommentJoin) {
                String result = oebbCommentJoin.getOebbCommentResult();
                return this.translateOebbCommentResult(result);
            }

            public String translateOebbCommentResult(String result) {
                if (result == null) {
                    return resourceBundle.getString("reviewProtocolOebbCommentNoResult");
                }
                if ("n".equals(result)) {
                    return resourceBundle.getString("reviewProtocolOebbCommentNotAccepted");
                }
                if ("y".equals(result)) {
                    return resourceBundle.getString("reviewProtocolOebbCommentAccepted");
                }
                return resourceBundle.getString("reviewProtocolOebbCommentNoResult");
            }
        });
        HashMap<String, Double> relativeColumnWidths = new HashMap<String, Double>();
        relativeColumnWidths.put("reviewer", 0.25);
        relativeColumnWidths.put("realm", 0.2);
        relativeColumnWidths.put("comment", 0.47);
        relativeColumnWidths.put("result", 0.08);
        ArrayList<ColumnSortSpec> columnSortSpecs = new ArrayList<ColumnSortSpec>();
        columnSortSpecs.add(new ColumnSortSpec("reviewer", Boolean.valueOf(true)));
        Styles styles = context.getContentAutomaticStyles();
        FancyOdfTable table = ReviewProtocolPdfExporter.constructFancyTable(styles, localStyles, 23.9, columns, relativeColumnWidths);
        table.setTableStyle(tableUnderCaptionStyle);
        table.setRenderHeaderLine(true);
        table.render((Node)officeText, oebbCommentJoins, columnSortSpecs);
    }

    private void appendCrossCommentSection(ReviewProtocolVersionJoin nodeResultJoin, final ReviewProtocolData reviewProtocolData, final ArchiveScope archiveScope, OfficeTextElement officeText, final OdfContext context, ReviewProtocolLocalStyles localStyles, final ResourceBundle resourceBundle, final String userLocale, final List<String> contentLocales) {
        String reviewDate;
        Map nodeResultIdToOebbCommentJoins = reviewProtocolData.getNodeResultIdToOebbCommentJoins();
        List<ReviewProtocolVersionJoin> crossCommentJoins = this.getCrossCommentNodeResultJoins(reviewProtocolData, nodeResultJoin);
        String reviewer = nodeResultJoin.getPositionOrganisationName() + " (" + nodeResultJoin.getPositionPersonSurName() + " " + nodeResultJoin.getPositionPersonGivenName() + ")";
        String format = resourceBundle.getString("yearToSecondFormat");
        String string = reviewDate = nodeResultJoin.getReviewCycleNodeResultDepartureDate() != null ? DateHelper.formatUtcSeconds(nodeResultJoin.getReviewCycleNodeResultDepartureDate(), "Europe/Vienna", format) : "";
        if (crossCommentJoins == null || crossCommentJoins.size() == 0) {
            return;
        }
        final Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorAndFont("#000000", "Arial", "10pt", null);
        StyleParagraphPropertiesElement paragraphProperties = contentAutomaticStyles.constructParagraphPropertiesWithMargin(null, null, "0.5cm", null);
        String captionStyle = contentAutomaticStyles.getParagraphStyleWithParent(localStyles.getStandardParagraphStyle(), new OdfStylePropertiesBase[]{dataTextProperties, paragraphProperties});
        String headingStyle = localStyles.getHeadingStyle();
        final String dataTextStyle = localStyles.getDataTextStyle();
        String captionRaw = resourceBundle.getString("reviewProtocolOebbCommentCaption");
        String nodeName = I18nHelper.getLocaleString(nodeResultJoin.getReviewCycleNodeName(), this.userLocale);
        String caption = MessageFormat.format(captionRaw, reviewer + " " + reviewDate);
        TextFactory.constructTextHeaderNode((Node)officeText, (String)caption, (String)captionStyle, (Integer)2);
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        String tableUnderCaptionStyle = null;
        final String dataCellStyle = localStyles.getDataCellStyle();
        final String dataTextStyleMedium = localStyles.getDataTextStyleMedium();
        String dataTextStyleComment = localStyles.getDataTextStyleComment();
        final String dataTextStyleBold = localStyles.getDataTextStyleBold();
        final Map idToPositionResultJoin = reviewProtocolData.getIdToPositionResultJoin();
        final Map idToResultOption = reviewProtocolData.getIdToResultOption();
        Map positionResultIdToAttachments = reviewProtocolData.getPositionResultIdToAttachments();
        ArrayList columns = new ArrayList();
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("nodeName", resourceBundle.getString("reviewProtocolCommentNodeNameCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = this.getOutput(versionJoinOne);
                String s2 = this.getOutput(versionJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin versionJoin) {
                Long commentReferenceId = versionJoin.getReviewCyclePositionResultCommentReferenceId();
                ReviewProtocolVersionJoin commentReference = commentReferenceId != null ? (ReviewProtocolVersionJoin)idToPositionResultJoin.get(commentReferenceId) : null;
                return commentReference != null ? I18nHelper.getLocaleString(commentReference.getReviewCycleNodeName(), userLocale) : "";
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("reviewer", resourceBundle.getString("reviewProtocolCommentReviewerCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                Long commentReferenceId = versionJoin.getReviewCyclePositionResultCommentReferenceId();
                ReviewProtocolVersionJoin commentReference = commentReferenceId != null ? (ReviewProtocolVersionJoin)idToPositionResultJoin.get(commentReferenceId) : null;
                String nameString = ReviewProtocolPdfExporter.this.getPositionPersonWithOrganisationString(commentReference);
                TextFactory.constructTextNode((Node)cellElement, (String)nameString, (String)dataTextStyle);
                if (commentReference != null && (!commentReference.isPositionParticipantMainParticipantFlag().booleanValue() || commentReference.isPositionParticipantInactiveFlag().booleanValue())) {
                    String deputyString = "";
                    if (!commentReference.getPositionOrganisationId().equals(commentReference.getPositionMainOrganisationId())) {
                        deputyString = ReviewProtocolPdfExporter.this.getPositionMainPersonWithOrganisationDebString(commentReference, resourceBundle);
                    } else if (!versionJoin.getPositionPersonId().equals(commentReference.getPositionMainPersonId())) {
                        deputyString = ReviewProtocolPdfExporter.this.getPositionMainPersonDebString(commentReference, resourceBundle);
                    }
                    TextFactory.constructTextNode((Node)cellElement, (String)deputyString, (String)dataTextStyle);
                }
                if (commentReference.getAttachedPositionResultId() != null) {
                    String label = resourceBundle.getString("reviewProtocolPositionAttachedReviewLabel");
                    TextFactory.constructTextNode((Node)cellElement, (String)label, (String)dataTextStyle);
                }
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                String s1 = ReviewProtocolPdfExporter.this.getPositionPersonWithOrganisationString(versionJoinOne);
                String s2 = ReviewProtocolPdfExporter.this.getPositionPersonWithOrganisationString(versionJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("realm", resourceBundle.getString("reviewProtocolCommentRealmCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                Long commentReferenceId = versionJoin.getReviewCyclePositionResultCommentReferenceId();
                if (commentReferenceId != null) {
                    ReviewProtocolVersionJoin commentReference = (ReviewProtocolVersionJoin)idToPositionResultJoin.get(commentReferenceId);
                    if (commentReference.getRealmCode() != null) {
                        TextFactory.constructTextNode((Node)cellElement, (String)commentReference.getRealmCode(), (String)dataTextStyle);
                    }
                    if (commentReference.getRealmName() != null) {
                        String commentReferenceRealmName = I18nHelper.getLocaleStringFromDatabase(commentReference.getRealmName(), userLocale, contentLocales);
                        TextFactory.constructTextNode((Node)cellElement, (String)commentReferenceRealmName, (String)dataTextStyleMedium);
                    }
                }
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                Long commentReferenceIdOne = versionJoinOne.getReviewCyclePositionResultCommentReferenceId();
                Long commentReferenceIdTwo = versionJoinTwo.getReviewCyclePositionResultCommentReferenceId();
                ReviewProtocolVersionJoin commentReferenceOne = commentReferenceIdOne != null ? (ReviewProtocolVersionJoin)idToPositionResultJoin.get(commentReferenceIdOne) : null;
                ReviewProtocolVersionJoin commentReferenceTwo = commentReferenceIdTwo != null ? (ReviewProtocolVersionJoin)idToPositionResultJoin.get(commentReferenceIdTwo) : null;
                String s1 = (commentReferenceOne != null && commentReferenceOne.getRealmCode() != null ? commentReferenceOne.getRealmCode() : "") + (commentReferenceOne != null && commentReferenceOne.getRealmName() != null ? commentReferenceOne.getRealmName() : "");
                String s2 = (commentReferenceTwo != null && commentReferenceTwo.getRealmCode() != null ? commentReferenceTwo.getRealmCode() : "") + (commentReferenceTwo != null && commentReferenceTwo.getRealmName() != null ? commentReferenceTwo.getRealmName() : "");
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("reviewDate", resourceBundle.getString("reviewProtocolCommentReviewDateCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin versionJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(versionJoin)});
            }

            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo, boolean descending) {
                Double createdOne = versionJoinOne.getReviewCyclePositionResultResultDate();
                Double createdTwo = versionJoinTwo.getReviewCyclePositionResultResultDate();
                return ReviewProtocolPdfExporter.defaultDoubleCompare(createdOne, createdTwo, descending);
            }

            private String getOutput(ReviewProtocolVersionJoin commentResultJoin) {
                ReviewProtocolVersionJoin commentReference;
                Long commentReferenceId = commentResultJoin.getReviewCyclePositionResultCommentReferenceId();
                ReviewProtocolVersionJoin reviewProtocolVersionJoin = commentReference = commentReferenceId != null ? (ReviewProtocolVersionJoin)idToPositionResultJoin.get(commentReferenceId) : null;
                if (commentReference != null && commentReference.getReviewCyclePositionResultResultDate() != null) {
                    Double resultDate = commentReference.getReviewCyclePositionResultResultDate();
                    String format = resourceBundle.getString("yearToSecondFormat");
                    return DateHelper.formatUtcSeconds(resultDate, "Europe/Vienna", format);
                }
                return "";
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("review", resourceBundle.getString("reviewProtocolCommentReviewCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin positionJoin) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                Long commentReferenceId = positionJoin.getReviewCyclePositionResultCommentReferenceId();
                ReviewProtocolVersionJoin oldPositionJoin = (ReviewProtocolVersionJoin)idToPositionResultJoin.get(commentReferenceId);
                Long resultOptionId = positionJoin.getReviewCycleNodeResultReviewCycleResultOptionId();
                ReviewCycleResultOption resultOption = (ReviewCycleResultOption)idToResultOption.get(resultOptionId);
                if (resultOption != null && resultOption.getValue() == -7) {
                    String notReviewedLabel = resourceBundle.getString("reviewProtocolPositionNotReviewedLabel");
                    TextFactory.constructTextNode((Node)cellElement, (String)notReviewedLabel, (String)dataTextStyleBold);
                }
                if (positionJoin.getPositionOverridingPersonId() != null) {
                    String overridingPersonCommonName = PersonHelper.getCommonName(positionJoin.getPositionOverridingPerson());
                    String overridingLabel = MessageFormat.format(resourceBundle.getString("reviewProtocolPositionOverridingLabel"), overridingPersonCommonName);
                    TextFactory.constructTextNode((Node)cellElement, (String)overridingLabel, (String)dataTextStyleBold);
                }
                if (oldPositionJoin.getReviewCyclePositionResultComment() != null) {
                    OdfFromHtmlConverter.convert((Node)cellElement, oldPositionJoin.getReviewCyclePositionResultComment(), dataTextStyle, contentAutomaticStyles);
                }
            }

            public int compare(ReviewProtocolVersionJoin oebbCommentJoinOne, ReviewProtocolVersionJoin oebbCommentJoinTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("oldResult", resourceBundle.getString("reviewProtocolCommentOldResultCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin commentResultJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(commentResultJoin)});
            }

            public int compare(ReviewProtocolVersionJoin oebbCommentJoinOne, ReviewProtocolVersionJoin oebbCommentJoinTwo, boolean descending) {
                String s1 = this.getOutput(oebbCommentJoinOne);
                String s2 = this.getOutput(oebbCommentJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin commentResultJoin) {
                ReviewCycleResultOption resultOption;
                Long commentReferenceId = commentResultJoin.getReviewCyclePositionResultCommentReferenceId();
                ReviewProtocolVersionJoin oldPositionJoin = commentReferenceId != null ? (ReviewProtocolVersionJoin)idToPositionResultJoin.get(commentReferenceId) : null;
                Long resultOptionId = oldPositionJoin != null ? oldPositionJoin.getReviewCyclePositionResultReviewCycleResultOptionId() : null;
                ReviewCycleResultOption reviewCycleResultOption = resultOption = resultOptionId != null ? (ReviewCycleResultOption)idToResultOption.get(resultOptionId) : null;
                if (resultOption != null && resultOption.getName() != null) {
                    String rawResultOptionName = resultOption.getName();
                    String resultOptionName = I18nHelper.getLocaleStringFromDatabase(rawResultOptionName, userLocale, contentLocales);
                    return resultOptionName;
                }
                return "";
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("comment", resourceBundle.getString("reviewProtocolCommentCommentCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin commentResultJoin) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                String comment = this.getOutput(commentResultJoin);
                if (comment != null) {
                    OdfFromHtmlConverter.convert((Node)cellElement, comment, dataTextStyle, contentAutomaticStyles);
                }
            }

            public int compare(ReviewProtocolVersionJoin oebbCommentJoinOne, ReviewProtocolVersionJoin oebbCommentJoinTwo, boolean descending) {
                String s1 = this.getOutput(oebbCommentJoinOne);
                String s2 = this.getOutput(oebbCommentJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin commentResultJoin) {
                String comment = commentResultJoin.getReviewCyclePositionResultComment();
                return comment != null ? comment : "";
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("attachments", ""){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin commentResultJoin) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, null, (TableTableRowElement)rowElement);
                ReviewProtocolPdfExporter.this.appendAttachmentIconsToCell(cellElement, commentResultJoin, reviewProtocolData, context, archiveScope, resourceBundle);
            }

            public int compare(ReviewProtocolVersionJoin oebbCommentJoinOne, ReviewProtocolVersionJoin oebbCommentJoinTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<ReviewProtocolVersionJoin>("result", resourceBundle.getString("reviewProtocolCommentResultCaption")){

            public void appendCell(TableTableRowElement rowElement, ReviewProtocolVersionJoin commentResultJoin) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(commentResultJoin)});
            }

            public int compare(ReviewProtocolVersionJoin oebbCommentJoinOne, ReviewProtocolVersionJoin oebbCommentJoinTwo, boolean descending) {
                String s1 = this.getOutput(oebbCommentJoinOne);
                String s2 = this.getOutput(oebbCommentJoinTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)s1, (String)s2, (boolean)descending);
            }

            private String getOutput(ReviewProtocolVersionJoin commentResultJoin) {
                String rawResultOptionName = commentResultJoin.getReviewCycleCommentOptionName();
                if (rawResultOptionName != null) {
                    String resultOptionName = I18nHelper.getLocaleStringFromDatabase(rawResultOptionName, userLocale, contentLocales);
                    return resultOptionName;
                }
                return "-";
            }
        });
        HashMap<String, Double> relativeColumnWidths = new HashMap<String, Double>();
        relativeColumnWidths.put("nodeName", 0.1);
        relativeColumnWidths.put("reviewer", 0.15);
        relativeColumnWidths.put("realm", 0.1);
        relativeColumnWidths.put("reviewDate", 0.08);
        relativeColumnWidths.put("review", 0.23);
        relativeColumnWidths.put("oldResult", 0.07);
        relativeColumnWidths.put("comment", 0.15);
        relativeColumnWidths.put("attachments", 0.05);
        relativeColumnWidths.put("result", 0.07);
        ArrayList<ColumnSortSpec> columnSortSpecs = new ArrayList<ColumnSortSpec>();
        columnSortSpecs.add(new ColumnSortSpec("reviewDate", Boolean.valueOf(true)));
        Styles styles = context.getContentAutomaticStyles();
        FancyOdfTable table = ReviewProtocolPdfExporter.constructFancyTable(styles, localStyles, 23.9, columns, relativeColumnWidths);
        table.setTableStyle(tableUnderCaptionStyle);
        table.setRenderHeaderLine(true);
        table.render((Node)officeText, crossCommentJoins, columnSortSpecs);
    }

    private List<ReviewProtocolVersionJoin> getCrossCommentNodeResultJoins(ReviewProtocolData reviewProtocolData, ReviewProtocolVersionJoin nodeResultJoin) {
        ArrayList crossCommentNodeResultJoins = new ArrayList();
        if (log.isDebugEnabled()) {
            log.debug("Called getCrossCommentNodeResultJoins for nodeResultId = [" + nodeResultJoin.getReviewCycleNodeResultId() + "]");
        }
        final Map idToPositionResultJoin = reviewProtocolData.getIdToPositionResultJoin();
        Long cellResultId = nodeResultJoin.getReviewCycleCellResultId();
        Map cellResultIdToNodeResultIdToNodeResultJoin = reviewProtocolData.getCellResultIdToNodeResultIdToNodeResult();
        Map nodeResultIdToNodeResultJoin = (Map)cellResultIdToNodeResultIdToNodeResultJoin.get(cellResultId);
        ArrayList nodeResultJoins = new ArrayList();
        if (nodeResultIdToNodeResultJoin != null) {
            nodeResultJoins.addAll(nodeResultIdToNodeResultJoin.values());
        }
        Collections.sort(nodeResultJoins, new Comparator<ReviewProtocolVersionJoin>(){

            @Override
            public int compare(ReviewProtocolVersionJoin nodeResultJoinOne, ReviewProtocolVersionJoin nodeResultJoinTwo) {
                Integer positionOne = nodeResultJoinOne.getReviewCycleNodePosition();
                Integer positionTwo = nodeResultJoinTwo.getReviewCycleNodePosition();
                return (positionOne != null ? positionOne : 0) - (positionTwo != null ? positionTwo : 0);
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("CellResultId = [" + cellResultId + "], found [" + nodeResultJoins.size() + "] corresponding nodeResultJoins");
        }
        ArrayList<ReviewProtocolVersionJoin> allChosenPositionResultJoins = new ArrayList<ReviewProtocolVersionJoin>();
        for (ReviewProtocolVersionJoin currNodeResultJoin : nodeResultJoins) {
            Long nodeResultId = currNodeResultJoin.getReviewCycleNodeResultId();
            if (log.isDebugEnabled()) {
                log.debug("... Inspecting nodeResultId = [" + nodeResultId + "]");
            }
            if (currNodeResultJoin.getReviewCycleNodeResultId().longValue() == nodeResultJoin.getReviewCycleNodeResultId().longValue()) {
                if (!log.isDebugEnabled()) break;
                log.debug("... Breaking, since reviewCycleNodeResultIds are equal = [" + currNodeResultJoin.getReviewCycleNodeResultId() + "]");
                break;
            }
            if (currNodeResultJoin.getCrossCommentNodeId() == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug("... Continuing, since crossCommentId is null");
                continue;
            }
            Map nodeResultIdToPositionResultIdToPosition = reviewProtocolData.getNodeResultIdToPositionResultIdToPositionResult();
            Map positionResultIdToPositionResultJoins = (Map)nodeResultIdToPositionResultIdToPosition.get(currNodeResultJoin.getReviewCycleNodeResultId());
            ArrayList positionResultJoinsForBaseNodeResult = new ArrayList();
            if (positionResultIdToPositionResultJoins != null) {
                positionResultJoinsForBaseNodeResult.addAll(positionResultIdToPositionResultJoins.values());
            }
            HashMap<Long, ReviewProtocolVersionJoin> idToBasePositionResultJoin = new HashMap<Long, ReviewProtocolVersionJoin>();
            for (ReviewProtocolVersionJoin basePositionResultJoin : positionResultJoinsForBaseNodeResult) {
                idToBasePositionResultJoin.put(basePositionResultJoin.getReviewCyclePositionResultId(), basePositionResultJoin);
            }
            Map positionResultIdToPositionResultJoin = (Map)nodeResultIdToPositionResultIdToPosition.get(nodeResultJoin.getReviewCycleNodeResultId());
            ArrayList positionResultJoins = new ArrayList();
            if (positionResultIdToPositionResultJoin != null) {
                positionResultJoins.addAll(positionResultIdToPositionResultJoin.values());
            }
            if (log.isDebugEnabled()) {
                log.debug("... Found [" + positionResultJoins.size() + "] position result joins");
            }
            boolean chooseThisNodeResult = false;
            ArrayList<ReviewProtocolVersionJoin> chosenPositionResultJoins = new ArrayList<ReviewProtocolVersionJoin>();
            for (ReviewProtocolVersionJoin positionResultJoin : positionResultJoins) {
                Long positionResultId = positionResultJoin.getReviewCyclePositionResultId();
                String digest = positionResultJoin.getReviewCyclePositionResultDigest();
                String comment = positionResultJoin.getReviewCyclePositionResultComment();
                Long commentOptionId = positionResultJoin.getReviewCyclePositionResultReviewCycleCommentOptionId();
                boolean hasAttachments = this.hasPositionResultAttachments(reviewProtocolData, positionResultId);
                if (log.isDebugEnabled()) {
                    log.debug("...... Processing position result join [" + positionResultId + "] with (digest != null) [" + (digest != null) + "]; (comment filled) [" + (comment != null && comment.length() > 0) + "]; (commentOptionId != null) [" + (commentOptionId != null) + "]; (hasAttachments) [" + hasAttachments + "]");
                }
                Long commentReferenceId = positionResultJoin.getReviewCyclePositionResultCommentReferenceId();
                if (log.isDebugEnabled()) {
                    log.debug("...... commentReferenceId = [" + commentReferenceId + "]");
                }
                if (commentReferenceId == null || !idToBasePositionResultJoin.containsKey(commentReferenceId)) continue;
                chosenPositionResultJoins.add(positionResultJoin);
                if (digest == null || (comment == null || comment.length() <= 0) && commentOptionId == null && !hasAttachments) continue;
                chooseThisNodeResult = true;
            }
            if (!chooseThisNodeResult) continue;
            Collections.sort(chosenPositionResultJoins, new Comparator<ReviewProtocolVersionJoin>(){

                @Override
                public int compare(ReviewProtocolVersionJoin joinOne, ReviewProtocolVersionJoin joinTwo) {
                    double delta;
                    Long idOne = joinOne.getReviewCyclePositionResultId();
                    Long commentReferenceIdOne = joinOne.getReviewCyclePositionResultCommentReferenceId();
                    ReviewProtocolVersionJoin oldPositionJoinOne = commentReferenceIdOne != null ? (ReviewProtocolVersionJoin)idToPositionResultJoin.get(commentReferenceIdOne) : null;
                    Double resultDateOne = oldPositionJoinOne != null && oldPositionJoinOne.getReviewCyclePositionResultResultDate() != null ? oldPositionJoinOne.getReviewCyclePositionResultResultDate() : 0.0;
                    Long idTwo = joinTwo.getReviewCyclePositionResultId();
                    Long commentReferenceIdTwo = joinTwo.getReviewCyclePositionResultCommentReferenceId();
                    ReviewProtocolVersionJoin oldPositionJoinTwo = commentReferenceIdTwo != null ? (ReviewProtocolVersionJoin)idToPositionResultJoin.get(commentReferenceIdTwo) : null;
                    Double resultDateTwo = oldPositionJoinTwo != null && oldPositionJoinTwo.getReviewCyclePositionResultResultDate() != null ? oldPositionJoinTwo.getReviewCyclePositionResultResultDate() : 0.0;
                    if (log.isDebugEnabled()) {
                        log.debug("Comparing for position results [" + idOne + "] vs. [" + idTwo + "]: Result dates [" + resultDateOne + "] with resultDateTwo [" + resultDateTwo + "] for persons [" + oldPositionJoinOne.getPositionMainPersonSurName() + "] vs. [" + oldPositionJoinTwo.getPositionMainPersonSurName() + "]");
                    }
                    if ((delta = resultDateOne - resultDateTwo) < 0.0) {
                        return -1;
                    }
                    if (delta > 0.0) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (ReviewProtocolVersionJoin chosenPositionResultJoin : chosenPositionResultJoins) {
                allChosenPositionResultJoins.add(chosenPositionResultJoin);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning [" + crossCommentNodeResultJoins.size() + "] cross comment node result joins");
        }
        return allChosenPositionResultJoins;
    }

    private boolean hasPositionResultAttachments(ReviewProtocolData reviewProtocolData, Long positionResultId) {
        Map positionResultIdToAttachments = reviewProtocolData.getPositionResultIdToAttachments();
        return positionResultIdToAttachments != null && positionResultIdToAttachments.size() > 0;
    }

    private String getPositionPersonWithOrganisationString(ReviewProtocolVersionJoin versionJoin) {
        return PersonHelper.getOrganisationAndCommonName(versionJoin.getPositionOrganisation(), versionJoin.getPositionPerson());
    }

    private String getPositionMainPersonWithOrganisationString(ReviewProtocolVersionJoin versionJoin) {
        return PersonHelper.getOrganisationAndCommonName(versionJoin.getPositionMainOrganisation(), versionJoin.getPositionMainPerson());
    }

    private String getPositionMainPersonDebString(ReviewProtocolVersionJoin versionJoin, ResourceBundle resourceBundle) {
        return MessageFormat.format(resourceBundle.getString("reviewProtocolDeputy"), PersonHelper.getCommonName(versionJoin.getPositionMainPerson()));
    }

    private String getPositionMainPersonWithOrganisationDebString(ReviewProtocolVersionJoin versionJoin, ResourceBundle resourceBundle) {
        return MessageFormat.format(resourceBundle.getString("reviewProtocolDeputy"), PersonHelper.getCommonNameAndOrganisation(versionJoin.getPositionMainOrganisation(), versionJoin.getPositionMainPerson()));
    }

    private static class ReviewProtocolLocalStyles {
        private String standardParagraphStyle;
        private String superHeadingStyle;
        private String headingStyle;
        private String subHeadingStyle;
        private String nodeBoldTextStyle;
        private String spanBoldTextStyle;
        private String spanDefaultTextStyle;
        private String headerCellStyle;
        private String headerTextStyle;
        private String dataCellStyle;
        private String dataTextStyle;
        private String dataTextStyleBold;
        private String dataTextStyleMedium;
        private String intervalDataTextStyle;
        private String dataTextStyleSmall;
        private String dataTextStyleComment;
        private String dataTextStyleRight;
        private String dataTextStyleSmallRight;
        private String dataRowStyle;

        private ReviewProtocolLocalStyles() {
        }

        public String getStandardParagraphStyle() {
            return this.standardParagraphStyle;
        }

        public void setStandardParagraphStyle(String standardParagraphStyle) {
            this.standardParagraphStyle = standardParagraphStyle;
        }

        public String getSuperHeadingStyle() {
            return this.superHeadingStyle;
        }

        public void setSuperHeadingStyle(String superHeadingStyle) {
            this.superHeadingStyle = superHeadingStyle;
        }

        public String getHeadingStyle() {
            return this.headingStyle;
        }

        public void setHeadingStyle(String headingStyle) {
            this.headingStyle = headingStyle;
        }

        public String getSubHeadingStyle() {
            return this.subHeadingStyle;
        }

        public void setSubHeadingStyle(String subHeadingStyle) {
            this.subHeadingStyle = subHeadingStyle;
        }

        public String getNodeBoldTextStyle() {
            return this.nodeBoldTextStyle;
        }

        public void setNodeBoldTextStyle(String nodeBoldTextStyle) {
            this.nodeBoldTextStyle = nodeBoldTextStyle;
        }

        public String getSpanBoldTextStyle() {
            return this.spanBoldTextStyle;
        }

        public void setSpanBoldTextStyle(String spanBoldTextStyle) {
            this.spanBoldTextStyle = spanBoldTextStyle;
        }

        public String getSpanDefaultTextStyle() {
            return this.spanDefaultTextStyle;
        }

        public void setSpanDefaultTextStyle(String spanDefaultTextStyle) {
            this.spanDefaultTextStyle = spanDefaultTextStyle;
        }

        public String getHeaderCellStyle() {
            return this.headerCellStyle;
        }

        public void setHeaderCellStyle(String headerCellStyle) {
            this.headerCellStyle = headerCellStyle;
        }

        public String getHeaderTextStyle() {
            return this.headerTextStyle;
        }

        public void setHeaderTextStyle(String headerTextStyle) {
            this.headerTextStyle = headerTextStyle;
        }

        public String getDataCellStyle() {
            return this.dataCellStyle;
        }

        public void setDataCellStyle(String dataCellStyle) {
            this.dataCellStyle = dataCellStyle;
        }

        public String getDataTextStyle() {
            return this.dataTextStyle;
        }

        public void setDataTextStyle(String dataTextStyle) {
            this.dataTextStyle = dataTextStyle;
        }

        public String getDataTextStyleBold() {
            return this.dataTextStyleBold;
        }

        public void setDataTextStyleBold(String dataTextStyleBold) {
            this.dataTextStyleBold = dataTextStyleBold;
        }

        public String getDataTextStyleMedium() {
            return this.dataTextStyleMedium;
        }

        public void setDataTextStyleMedium(String dataTextStyleMedium) {
            this.dataTextStyleMedium = dataTextStyleMedium;
        }

        public String getIntervalDataTextStyle() {
            return this.intervalDataTextStyle;
        }

        public void setIntervalDataTextStyle(String intervalDataTextStyle) {
            this.intervalDataTextStyle = intervalDataTextStyle;
        }

        public String getDataTextStyleSmall() {
            return this.dataTextStyleSmall;
        }

        public void setDataTextStyleSmall(String dataTextStyleSmall) {
            this.dataTextStyleSmall = dataTextStyleSmall;
        }

        public String getDataTextStyleComment() {
            return this.dataTextStyleComment;
        }

        public void setDataTextStyleComment(String dataTextStyleComment) {
            this.dataTextStyleComment = dataTextStyleComment;
        }

        public String getDataTextStyleRight() {
            return this.dataTextStyleRight;
        }

        public void setDataTextStyleRight(String dataTextStyleRight) {
            this.dataTextStyleRight = dataTextStyleRight;
        }

        public String getDataTextStyleSmallRight() {
            return this.dataTextStyleSmallRight;
        }

        public void setDataTextStyleSmallRight(String dataTextStyleSmallRight) {
            this.dataTextStyleSmallRight = dataTextStyleSmallRight;
        }

        public String getDataRowStyle() {
            return this.dataRowStyle;
        }

        public void setDataRowStyle(String dataRowStyle) {
            this.dataRowStyle = dataRowStyle;
        }
    }
}

