/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util.svg;

import at.cdes.impl.util.svg.SvgPathKit;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SvgHelper {
    private static final Logger log = LoggerFactory.getLogger(SvgHelper.class);
    public static final String SVG_NS_URI = "http://www.w3.org/2000/svg";

    public static NamespaceContext constructSvgNamespaceContext() {
        return new NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                return Collections.singleton(this.getPrefix(namespaceURI)).iterator();
            }

            @Override
            public String getPrefix(String namespaceURI) {
                if (SvgHelper.SVG_NS_URI.equals(namespaceURI)) {
                    return "svg";
                }
                return null;
            }

            @Override
            public String getNamespaceURI(String prefix) {
                if ("svg".equals(prefix)) {
                    return SvgHelper.SVG_NS_URI;
                }
                return null;
            }
        };
    }

    public static void addLine(XMLStreamWriter xsw, Double x1, Double y1, Double x2, Double y2, String ... styles) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Drawing line: (" + x1 + "," + y1 + ") --> (" + x2 + "," + y2 + ")");
        }
        xsw.writeStartElement("line");
        xsw.writeAttribute("x1", x1.toString());
        xsw.writeAttribute("y1", y1.toString());
        xsw.writeAttribute("x2", x2.toString());
        xsw.writeAttribute("y2", y2.toString());
        SvgHelper.writeStyles(xsw, styles);
        xsw.writeEndElement();
    }

    public static void addLineWithStroke(XMLStreamWriter xsw, Double x1, Double y1, Double x2, Double y2, String stroke, Double strokeWidth) throws Exception {
        SvgHelper.addLine(xsw, x1, y1, x2, y2, "stroke", stroke, "stroke-width", strokeWidth.toString() + "px");
    }

    public static void addRect(XMLStreamWriter xsw, Double x, Double y, Double width, Double height, String id, String ... styles) throws Exception {
        if (width < 0.0) {
            x = x + width;
            width = width * -1.0;
        }
        if (height < 0.0) {
            y = y + height;
            height = height * -1.0;
        }
        xsw.writeStartElement("rect");
        if (x != null) {
            xsw.writeAttribute("x", x.toString());
        }
        if (y != null) {
            xsw.writeAttribute("y", y.toString());
        }
        if (width != null && width < 0.0) {
            throw new IllegalArgumentException("width must be positive, received width = [" + width + "]");
        }
        if (height != null && height < 0.0) {
            throw new IllegalArgumentException("height must be positive, received height = [" + height + "]");
        }
        if (width != null) {
            xsw.writeAttribute("width", width.toString());
        }
        if (height != null) {
            xsw.writeAttribute("height", height.toString());
        }
        if (id != null) {
            if (id.contains("=")) {
                throw new IllegalArgumentException("The old code did some magic here, splitting up the id parameter, and adding some filter attribute.  We left this magic out for now, if needed it should be implemented with extra funtion parameters etc.");
            }
            xsw.writeAttribute("id", id);
        }
        SvgHelper.writeStyles(xsw, styles);
        xsw.writeEndElement();
    }

    public static void addRectWithStrokeAndFill(XMLStreamWriter xsw, Double x, Double y, Double width, Double height, String stroke, String fill) throws Exception {
        SvgHelper.addRect(xsw, x, y, width, height, null, "stroke", stroke, "fill", fill);
    }

    public static void addRectWithStrokeStrokeSizeAndFill(XMLStreamWriter xsw, Double x, Double y, Double width, Double height, String stroke, double strokeSize, String fill) throws Exception {
        SvgHelper.addRect(xsw, x, y, width, height, null, "stroke", stroke, "stroke-width", new Double(strokeSize).toString() + "px", "fill", fill);
    }

    public static void addRectWithStrokeFillAndOpacity(XMLStreamWriter xsw, Double x, Double y, Double width, Double height, String stroke, String fill, String opacity) throws Exception {
        SvgHelper.addRect(xsw, x, y, width, height, null, "stroke", stroke, "fill", fill, "opacity", opacity);
    }

    public static void addRectWithStrokeFillAndFillOpacity(XMLStreamWriter xsw, Double x, Double y, Double width, Double height, String stroke, String fill, String fillOpacity) throws Exception {
        SvgHelper.addRect(xsw, x, y, width, height, null, "stroke", stroke, "fill", fill, "opacity", fillOpacity);
    }

    public static void addRectWithFill(XMLStreamWriter xsw, Double x, Double y, Double width, Double height, String fill) throws Exception {
        SvgHelper.addRect(xsw, x, y, width, height, null, "fill", fill);
    }

    public static void addRectWithFillAndOpacity(XMLStreamWriter xsw, Double x, Double y, Double width, Double height, String fill, String opacity) throws Exception {
        SvgHelper.addRect(xsw, x, y, width, height, null, "fill", fill, "opacity", opacity);
    }

    public static void addRectWithEdges(XMLStreamWriter xsw, double x, double y, double lrx, double lry, double rrx, double rry, double width, double height, boolean lcircle, boolean rcircle, String ... styles) throws Exception {
        int leftSweepFlag;
        boolean rlessThanZero = rrx < 0.0 || rry < 0.0;
        boolean llessThanZero = lrx < 0.0 || lry < 0.0;
        int rightSweepFlag = rlessThanZero ? 0 : 1;
        int n = leftSweepFlag = llessThanZero ? 0 : 1;
        if (width / 2.0 < Math.abs(lrx)) {
            lrx = width / 2.0;
        }
        if (width / 2.0 < Math.abs(rrx)) {
            rrx = width / 2.0;
        }
        lrx = lcircle || !llessThanZero ? Math.abs(lrx) : -Math.abs(lrx);
        lry = Math.abs(lry);
        rrx = rcircle || !rlessThanZero ? Math.abs(rrx) : -Math.abs(rrx);
        if (height < 2.0 * (rry = Math.abs(rry))) {
            rry = height / 2.0;
        }
        if (height < 2.0 * lry) {
            lry = height / 2.0;
        }
        double left = !lcircle && llessThanZero ? 0.0 : Math.abs(lrx);
        double right = !rcircle && rlessThanZero ? 0.0 : Math.abs(rrx);
        width -= left + right;
        x += left;
        boolean redges = true;
        boolean ledges = true;
        if (Math.abs(rrx) <= 0.0 || Math.abs(rry) <= 0.0) {
            redges = false;
        }
        if (Math.abs(lrx) <= 0.0 || Math.abs(lry) <= 0.0) {
            ledges = false;
        }
        xsw.writeStartElement("path");
        String pathString = SvgPathKit.getAbsoluteMoveTo(x, y) + SvgPathKit.getRelativeHorizontalLineTo(width) + (redges ? (rcircle ? SvgPathKit.getEllipticalArc(rrx, rry, 0.0, 0, rightSweepFlag, rrx, rry) : SvgPathKit.getRelativeLineto(rrx, rry)) + SvgPathKit.getRelativeVerticalLineTo(height - 2.0 * rry) + (rcircle ? SvgPathKit.getEllipticalArc(rrx, rry, 0.0, 0, rightSweepFlag, -rrx, rry) : SvgPathKit.getRelativeLineto(-rrx, rry)) : SvgPathKit.getRelativeVerticalLineTo(height)) + SvgPathKit.getRelativeHorizontalLineTo(-width) + (ledges ? (lcircle ? SvgPathKit.getEllipticalArc(lrx, lry, 0.0, 0, leftSweepFlag, -lrx, -lry) : SvgPathKit.getRelativeLineto(-lrx, -lry)) + SvgPathKit.getRelativeVerticalLineTo(-(height - 2.0 * lry)) + (lcircle ? SvgPathKit.getEllipticalArc(lrx, lry, 0.0, 0, leftSweepFlag, lrx, -lry) : SvgPathKit.getRelativeLineto(lrx, -lry)) : SvgPathKit.getRelativeVerticalLineTo(-height)) + " z";
        xsw.writeAttribute("d", pathString);
        SvgHelper.writeStyles(xsw, styles);
        xsw.writeEndElement();
    }

    public static void addRectWithEdgesStrokeFillAndOpacity(XMLStreamWriter xsw, double x, double y, double lrx, double lry, double rrx, double rry, double width, double height, boolean lcircle, boolean rcircle, String stroke, String fill, String opacity) throws Exception {
        SvgHelper.addRectWithEdges(xsw, x, y, lrx, lry, rrx, rry, width, height, lcircle, rcircle, "stroke", stroke, "fill", fill, "opacity", opacity);
    }

    public static void addRectWithEdgesFillAndOpacity(XMLStreamWriter xsw, double x, double y, double lrx, double lry, double rrx, double rry, double width, double height, boolean lcircle, boolean rcircle, String fill, String opacity) throws Exception {
        SvgHelper.addRectWithEdges(xsw, x, y, lrx, lry, rrx, rry, width, height, lcircle, rcircle, "fill", fill, "opacity", opacity);
    }

    public static void addRectWithEdgesStrokeStrokeSizeAndFill(XMLStreamWriter xsw, double x, double y, double lrx, double lry, double rrx, double rry, double width, double height, boolean lcircle, boolean rcircle, String stroke, double strokeSize, String fill) throws Exception {
        SvgHelper.addRectWithEdges(xsw, x, y, lrx, lry, rrx, rry, width, height, lcircle, rcircle, "stroke", stroke, "stroke-width", new Double(strokeSize).toString() + "px", "fill", fill);
    }

    public static void addRectWithRxy(XMLStreamWriter xsw, double x, double y, double rx, double ry, double width, double height, String ... styles) throws Exception {
        xsw.writeStartElement("rect");
        xsw.writeAttribute("x", Double.toString(x));
        xsw.writeAttribute("y", Double.toString(y));
        xsw.writeAttribute("rx", Double.toString(rx));
        xsw.writeAttribute("ry", Double.toString(ry));
        xsw.writeAttribute("width", Double.toString(width));
        xsw.writeAttribute("height", Double.toString(height));
        SvgHelper.writeStyles(xsw, styles);
        xsw.writeEndElement();
    }

    public static void addRectWithRxyStrokeFillAndOpacity(XMLStreamWriter xsw, double x, double y, double rx, double ry, double width, double height, String stroke, String fill, String opacity) throws Exception {
        SvgHelper.addRectWithRxy(xsw, x, y, rx, ry, width, height, "stroke", stroke, "fill", fill, "opacity", opacity);
    }

    public static void addCircle(XMLStreamWriter xsw, double cx, double cy, double r, String ... styles) throws Exception {
        xsw.writeStartElement("circle");
        xsw.writeAttribute("cx", Double.toString(cx));
        xsw.writeAttribute("cy", Double.toString(cy));
        xsw.writeAttribute("r", Double.toString(r));
        SvgHelper.writeStyles(xsw, styles);
        xsw.writeEndElement();
    }

    public static void addCircleWithStrokeAndFill(XMLStreamWriter xsw, double cx, double cy, double r, String stroke, Double strokeWidth, String fill) throws Exception {
        SvgHelper.addCircle(xsw, cx, cy, r, "stroke", stroke, "stroke-width", strokeWidth.toString(), "fill", fill);
    }

    public static void addPolygon(XMLStreamWriter xsw, double[] points, String ... styles) throws Exception {
        if (points.length % 2 != 0) {
            throw new IllegalArgumentException("Points for polygon must be given pair-wise.");
        }
        String pointString = "";
        for (int i = 0; i < points.length; ++i) {
            pointString = pointString + points[i];
            if (i % 2 == 1) {
                if (i >= points.length - 1) continue;
                pointString = pointString + ", ";
                continue;
            }
            pointString = pointString + " ";
        }
        xsw.writeStartElement("polygon");
        xsw.writeAttribute("points", pointString);
        SvgHelper.writeStyles(xsw, styles);
        xsw.writeEndElement();
    }

    public static void addPolygonWithFill(XMLStreamWriter xsw, double[] points, String fill) throws Exception {
        SvgHelper.addPolygon(xsw, points, "fill", fill);
    }

    public static void addUse(XMLStreamWriter xsw, String href, String transform) throws Exception {
        xsw.writeStartElement("use");
        if (href != null) {
            xsw.writeAttribute("xlink:href", href);
        }
        if (transform != null) {
            xsw.writeAttribute("transform", transform);
        }
        xsw.writeEndElement();
    }

    public static void addUse(XMLStreamWriter xsw, String href) throws Exception {
        SvgHelper.addUse(xsw, href, null);
    }

    public static void addTextWithTransform(XMLStreamWriter xsw, double x, double y, String content, String transform, String ... styles) throws Exception {
        xsw.writeStartElement("text");
        xsw.writeAttribute("x", Double.toString(x));
        xsw.writeAttribute("y", Double.toString(y));
        if (transform != null) {
            xsw.writeAttribute("transform", transform);
        }
        SvgHelper.writeStyles(xsw, styles);
        xsw.writeCharacters(content);
        xsw.writeEndElement();
    }

    public static void addText(XMLStreamWriter xsw, double x, double y, String content, String ... styles) throws Exception {
        SvgHelper.addTextWithTransform(xsw, x, y, content, null, styles);
    }

    public static void addTextWithFontFamilyAndSize(XMLStreamWriter xsw, double x, double y, String content, String fontFamily, double fontSize) throws Exception {
        SvgHelper.addText(xsw, x, y, content, "font-family", fontFamily, "font-size", new Double(fontSize).toString() + "px");
    }

    public static void addTextWithFillFontFamilyWeightAndSize(XMLStreamWriter xsw, double x, double y, String content, String fill, String fontFamily, String fontWeight, double fontSize) throws Exception {
        SvgHelper.addText(xsw, x, y, content, "fill", fill, "font-family", fontFamily, "font-weight", fontWeight, "font-size", new Double(fontSize).toString() + "px");
    }

    private static void writeStyles(XMLStreamWriter xsw, String ... styles) throws Exception {
        if (styles == null) {
            return;
        }
        if (styles.length == 1) {
            xsw.writeAttribute("style", styles[0]);
            return;
        }
        if (styles.length % 2 != 0) {
            throw new IllegalArgumentException("Each style name must match a value.");
        }
        String result = "";
        for (int n = 0; n < styles.length; n += 2) {
            String style = styles[n];
            String value = styles[n + 1];
            result = result + style + ":" + value + ";";
        }
        xsw.writeAttribute("style", result);
    }

    public static void addMilestone(XMLStreamWriter xsw, double x, double y, double height, double width, String style) throws Exception {
        if (width < 0.0 || height < 0.0) {
            if (log.isDebugEnabled()) {
                log.debug("width and height need to be greater than 1/100");
            }
            return;
        }
        double moveX = width / 2.0;
        double moveY = height / 2.0;
        String path = SvgPathKit.getAbsoluteMoveTo(x, y - moveY) + SvgPathKit.getRelativeLineto(moveX, moveY) + SvgPathKit.getRelativeLineto(-moveX, moveY) + SvgPathKit.getRelativeLineto(-moveX, -moveY) + SvgPathKit.getRelativeLineto(moveX, -moveY);
        xsw.writeEmptyElement("path");
        xsw.writeAttribute("d", path);
        xsw.writeAttribute("style", style);
    }
}

