/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.compositeDto.ResetPasswordInfo;
import at.cdes.api.compositeDto.UserPolicyInfo;
import at.cdes.api.dto.Person;
import at.cdes.api.guiService.ResetPasswordService;
import at.cdes.api.joinDto.CertificateOrgPersonJoin;
import at.cdes.api.person.PersonPasswordChanger;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.sec.PasswordValidationError;
import at.cdes.api.sec.PasswordValidator;
import at.cdes.api.voc.ResetPasswordResult;
import at.cdes.impl.dao.CertificateRequestDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PersonDAO;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.PasswordUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.clazzes.util.aop.ThreadLocalManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetPasswordServiceImpl
implements ResetPasswordService {
    private static final Logger log = LoggerFactory.getLogger(ResetPasswordServiceImpl.class);
    private PersonDAO personDAO;
    private CertificateRequestDAO certificateRequestDAO;
    private PasswordValidator passwordValidator;
    private Long passwordMaxAge;
    private Long passwordExpireInterval;
    private PersonPasswordChanger personPasswordChanger;
    private Integer securityAnswerMinLength;
    private OrganisationPersonDAO organisationPersonDAO;
    private Integer passwordMinLength;
    private Instant userPolicyDeadline;
    private Long userPolicyDeadlineInterval;
    private Integer userPolicyVersion;

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public void setCertificateRequestDAO(CertificateRequestDAO certificateRequestDAO) {
        this.certificateRequestDAO = certificateRequestDAO;
    }

    public void setPasswordValidator(PasswordValidator passwordValidator) {
        this.passwordValidator = passwordValidator;
    }

    public void setPasswordMaxAge(Long passwordMaxAge) {
        this.passwordMaxAge = passwordMaxAge;
    }

    public void setPasswordExpireInterval(Long passwordExpireInterval) {
        this.passwordExpireInterval = passwordExpireInterval;
    }

    public void setPersonPasswordChanger(PersonPasswordChanger personPasswordChanger) {
        this.personPasswordChanger = personPasswordChanger;
    }

    public void setSecurityAnswerMinLength(Integer securityAnswerMinLength) {
        this.securityAnswerMinLength = securityAnswerMinLength;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPasswordMinLength(Integer passwordMinLength) {
        this.passwordMinLength = passwordMinLength;
    }

    public void setUserPolicyDeadline(String userPolicyDeadline) {
        if (userPolicyDeadline != null && userPolicyDeadline.length() > 0) {
            this.userPolicyDeadline = LocalDate.parse(userPolicyDeadline, DateTimeFormatter.ofPattern("dd.MM.yyyy")).plusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant();
        }
    }

    public void setUserPolicyDeadlineInterval(Long userPolicyDeadlineInterval) {
        this.userPolicyDeadlineInterval = userPolicyDeadlineInterval;
    }

    public void setUserPolicyVersion(Integer userPolicyVersion) {
        this.userPolicyVersion = userPolicyVersion;
    }

    public ResetPasswordResult resetPassword(Long organisationPersonId, String oldPassword, String newPassword, String question, String answer) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Long personId = ((CdesPrincipal)ThreadLocalManager.getLoginPrincipal()).getPersonId();
        Person person = (Person)this.personDAO.get(personId);
        log.info("Called ResetPasswordServiceImpl.resetPassword for person [" + personId + "] with name [" + person.getGivenName() + " " + person.getSurName() + "]");
        boolean ok = PasswordUtil.checkPassword(person.getPassword(), oldPassword);
        if (!ok) {
            return ResetPasswordResult.WRONG_PASSWORD;
        }
        PasswordValidationError validationResult = this.passwordValidator.validate(newPassword, personId);
        if (validationResult != PasswordValidationError.OK) {
            return ResetPasswordResult.INVALID_PASSWORD;
        }
        this.personPasswordChanger.changePersonPasswordAndSecurityQuestion(personId, newPassword, oldPassword, question, answer);
        return ResetPasswordResult.SUCCESS;
    }

    public PasswordValidationError validatePassword(String newPassword) {
        Long personId = ((CdesPrincipal)ThreadLocalManager.getLoginPrincipal()).getPersonId();
        return this.passwordValidator.validate(newPassword, personId);
    }

    public ResetPasswordInfo getResetPasswordInfo() {
        Long personId = ((CdesPrincipal)ThreadLocalManager.getLoginPrincipal()).getPersonId();
        ResetPasswordInfo ret = new ResetPasswordInfo();
        Person person = (Person)this.personDAO.get(personId);
        long passedDays = this.passwordMaxAge - this.passwordExpireInterval;
        if (person.getLastPasswordChangeTs() != null) {
            passedDays = ChronoUnit.DAYS.between(Instant.ofEpochMilli(person.getLastPasswordChangeTs()), Instant.now());
        } else {
            Instant lastPasswordChange = Instant.now();
            lastPasswordChange = ChronoUnit.DAYS.addTo(lastPasswordChange, -passedDays);
            person.setLastPasswordChangeTs(Long.valueOf(lastPasswordChange.toEpochMilli()));
            this.personDAO.update(person);
        }
        Long remainingDays = this.passwordMaxAge - passedDays;
        ret.setNeedsSecurityQuestion(Boolean.valueOf(true));
        ret.setPasswordMaxAge(this.passwordMaxAge.toString());
        ret.setPasswordRemainingDays(remainingDays.toString());
        ret.setSecurityAnswerMinLength(this.securityAnswerMinLength);
        ret.setPasswordMinLength(this.passwordMinLength);
        return ret;
    }

    public UserPolicyInfo getUserPolicyInfo(Long personId) {
        personId = ((CdesPrincipal)ThreadLocalManager.getLoginPrincipal()).getPersonId();
        UserPolicyInfo ret = new UserPolicyInfo();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        Instant shownDeadline = ChronoUnit.DAYS.addTo(this.userPolicyDeadline, -(this.userPolicyDeadlineInterval + 1L));
        String userPolicyDeadlineString = DateHelper.formatUtcSeconds(Long.valueOf(shownDeadline.getEpochSecond()).doubleValue(), "Europe/Vienna", resourceBundle.getString("yearToDayFormat"));
        ret.setUserPolicyDeadline(userPolicyDeadlineString);
        ret.setUserPolicyVersion(this.userPolicyVersion);
        ArrayList<Long> orgPersonIds = new ArrayList<Long>();
        List<CertificateOrgPersonJoin> signedUserPolicyVersions = this.certificateRequestDAO.getSignedUserPolicyVersionsForPerson(personId);
        for (CertificateOrgPersonJoin signedUserPolicyVersion : signedUserPolicyVersions) {
            Integer mostRecentSignedVersion = signedUserPolicyVersion.getCertificateRequestRequestPdfUploadVersion();
            if (mostRecentSignedVersion != null && mostRecentSignedVersion >= this.userPolicyVersion) continue;
            orgPersonIds.add(signedUserPolicyVersion.getCertificateOrganisationPersonId());
        }
        ret.setOrgPersonIds(orgPersonIds);
        return ret;
    }
}

