/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util;

import at.cdes.api.result.ResultSummary;
import at.cdes.api.voc.EntityVoc;
import at.cdes.impl.util.ObjectCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.clazzes.util.sql.dao.IIdDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBChanges<T> {
    private boolean containsNullNewInstances = false;
    private List<T> newInstances = new ArrayList<T>();
    private Map<Long, T> idToUpdateInstance = new HashMap<Long, T>();
    private Set<Long> deleteInstanceIds = new HashSet<Long>();
    private static final Logger log = LoggerFactory.getLogger(DBChanges.class);

    public void registerNew(T t) {
        this.newInstances.add(t);
        this.containsNullNewInstances |= t == null;
    }

    public void registerForUpdate(Long id, T t) {
        if (id == null) {
            log.error("Affected instance: [" + (t != null ? t.toString() : "null") + "]");
            throw new NullPointerException("Only instances with id can be scheduled for update.");
        }
        if (this.deleteInstanceIds.contains(id)) {
            throw new IllegalArgumentException("Instance already scheduled for delete: [" + id + "]");
        }
        this.idToUpdateInstance.put(id, t);
    }

    public void registerForDelete(Long id) {
        if (id == null) {
            throw new NullPointerException("Only instances with id can be scheduled for delete.");
        }
        if (this.idToUpdateInstance.containsKey(id)) {
            this.idToUpdateInstance.remove(id);
        }
        this.deleteInstanceIds.add(id);
    }

    public void registerForDelete(ObjectCriteria<T> criteria) {
        Iterator<T> newIterator = this.newInstances.iterator();
        while (newIterator.hasNext()) {
            T t = newIterator.next();
            if (!criteria.matches(t)) continue;
            newIterator.remove();
        }
        Iterator<Map.Entry<Long, T>> updateIterator = this.idToUpdateInstance.entrySet().iterator();
        while (updateIterator.hasNext()) {
            Map.Entry<Long, T> entry = updateIterator.next();
            if (!criteria.matches(entry.getValue())) continue;
            this.deleteInstanceIds.add(entry.getKey());
            updateIterator.remove();
        }
    }

    public T getNewInstance(int n) {
        return this.newInstances.get(n);
    }

    public int getNumberOfNewInstances() {
        return this.newInstances.size();
    }

    public List<T> saveBatch(IIdDAO<T> dao, EntityVoc entity, ResultSummary resultSummary) {
        if (this.containsNullNewInstances) {
            ArrayList<T> effectiveNewInstances = new ArrayList<T>();
            for (T newInstance : this.newInstances) {
                if (newInstance == null) continue;
                effectiveNewInstances.add(newInstance);
            }
            List savedNewInstances = dao.saveBatch(effectiveNewInstances);
            if (resultSummary != null) {
                resultSummary.recordInsertedTuples(entity, savedNewInstances.size());
            }
            ArrayList returnedNewInstances = new ArrayList();
            int savedIndex = 0;
            for (T newInstance : this.newInstances) {
                if (newInstance == null) {
                    returnedNewInstances.add(null);
                    continue;
                }
                returnedNewInstances.add(savedNewInstances.get(savedIndex));
                ++savedIndex;
            }
            return returnedNewInstances;
        }
        if (resultSummary != null) {
            resultSummary.recordInsertedTuples(entity, this.newInstances.size());
        }
        return dao.saveBatch(this.newInstances);
    }

    public Collection<T> getUpdateInstances() {
        return this.idToUpdateInstance.values();
    }

    public Set<Long> getDeleteInstanceIds() {
        return this.deleteInstanceIds;
    }

    public void updateBatch(IIdDAO<T> dao, EntityVoc entity, ResultSummary resultSummary) {
        dao.updateBatch(this.idToUpdateInstance.values());
        if (resultSummary != null) {
            resultSummary.recordUpdatedTuples(entity, this.idToUpdateInstance.size());
        }
    }

    public void deleteBatch(IIdDAO<T> dao, EntityVoc entity, ResultSummary resultSummary) {
        dao.deleteBatch(this.deleteInstanceIds);
        if (resultSummary != null) {
            resultSummary.recordDeletedTuples(entity, this.deleteInstanceIds.size());
        }
    }

    public void updateDeleteBatch(IIdDAO<T> dao, EntityVoc entity, ResultSummary resultSummary) {
        this.updateBatch(dao, entity, resultSummary);
        this.deleteBatch(dao, entity, resultSummary);
    }
}

